/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.annotations;

import com.vectrace.MercurialEclipse.HgRevision;
import com.vectrace.MercurialEclipse.annotations.AnnotateBlock;
import com.vectrace.MercurialEclipse.annotations.AnnotateBlocks;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgFile;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class AnnotateCommand {
    private static final Pattern ANNOTATE = Pattern.compile("^\\s*(.+[^ ])\\s+(\\w+)\\s+(\\w+)\\s+(\\w+ \\w+ \\w+ \\w+:\\w+:\\w+ \\w+ [\\+\\-]\\w+).*: (.*)$");
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy Z", Locale.ENGLISH);
    private final HgFile file;

    public AnnotateCommand(HgFile file) {
        this.file = file;
    }

    public AnnotateBlocks execute() throws HgException {
        IFile resource = (IFile)MercurialUtilities.convert(this.file);
        if (!MercurialUtilities.hgIsTeamProviderFor((IResource)resource, true)) {
            return null;
        }
        File workingDir = MercurialUtilities.getWorkingDir((IResource)resource);
        String FullPath = MercurialUtilities.getResourceName((IResource)resource);
        String[] launchCmd = new String[]{MercurialUtilities.getHGExecutable(), "annotate", "--user", "--number", "--changeset", "--date", "--", FullPath};
        String output = MercurialUtilities.executeCommand(launchCmd, workingDir, true);
        if (output == null) {
            return null;
        }
        return AnnotateCommand.createFromStdOut(new StringReader(output));
    }

    protected static AnnotateBlocks createFromStdOut(InputStream contents) {
        return AnnotateCommand.createFromStdOut(new InputStreamReader(contents));
    }

    protected static AnnotateBlocks createFromStdOut(Reader contents) {
        AnnotateBlocks blocks = new AnnotateBlocks();
        String line = null;
        try {
            BufferedReader reader = new BufferedReader(contents);
            int count = 0;
            line = reader.readLine();
            while (line != null) {
                if (line.trim().length() != 0) {
                    Matcher matcher = ANNOTATE.matcher(line);
                    matcher.find();
                    String author = matcher.group(1);
                    int revision = Integer.parseInt(matcher.group(2));
                    String changeset = matcher.group(3);
                    Date date = DATE_FORMAT.parse(matcher.group(4));
                    blocks.add(new AnnotateBlock(new HgRevision(changeset, revision), author, date, count, count));
                    ++count;
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return blocks;
    }
}

