/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.actions;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgCloneClient;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AddToWorkspaceAction
extends WorkspaceModifyOperation {
    private String[] referenceStrings = null;
    private IProject[] projectsCreated = null;

    public AddToWorkspaceAction() {
    }

    public AddToWorkspaceAction(ISchedulingRule rule) {
        super(rule);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Adding projects to workspace...", this.referenceStrings.length);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ArrayList<IProject> projects = new ArrayList<IProject>(this.referenceStrings.length);
            String[] stringArray = this.referenceStrings;
            int n = this.referenceStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String reference = stringArray[n2];
                if (monitor.isCanceled()) break;
                String[] referenceParts = reference.split("_");
                IProject proj = workspace.getRoot().getProject(referenceParts[1]);
                if (proj.exists() || proj.getLocation() != null) {
                    MercurialEclipsePlugin.logInfo("Project" + proj.getName() + " not imported. Already exists.", null);
                    monitor.worked(1);
                } else {
                    try {
                        HgRepositoryLocation location = MercurialEclipsePlugin.getRepoManager().getRepoLocation(referenceParts[2], null, null);
                        HgCloneClient.clone(workspace.getRoot().getLocation().toOSString(), location, false, false, false, false, null, referenceParts[1]);
                        proj.create(monitor);
                        proj.open(monitor);
                        RepositoryProvider.map((IProject)proj, (String)MercurialTeamProvider.class.getName());
                        RepositoryProvider.getProvider((IProject)proj, (String)MercurialTeamProvider.class.getName());
                        projects.add(proj);
                        MercurialEclipsePlugin.getRepoManager().setDefaultProjectRepository(proj, location);
                        MercurialEclipsePlugin.getRepoManager().addRepoLocation(proj, location);
                        proj.refreshLocal(2, monitor);
                    }
                    catch (Exception e) {
                        MercurialEclipsePlugin.logError(e);
                        CoreException ex = new CoreException((IStatus)new Status(4, "com.vectrace.MercurialEclipse", e.getLocalizedMessage()));
                        ex.initCause((Throwable)e);
                        throw ex;
                    }
                    monitor.worked(1);
                }
                ++n2;
            }
            this.projectsCreated = projects.toArray(new IProject[projects.size()]);
        }
        finally {
            monitor.done();
        }
    }

    public String[] getReferenceStrings() {
        return this.referenceStrings;
    }

    public void setReferenceStrings(String[] referenceStrings) {
        this.referenceStrings = referenceStrings;
    }

    public IProject[] getProjectsCreated() {
        return this.projectsCreated;
    }

    public void setProjectsCreated(IProject[] projectsCreated) {
        this.projectsCreated = projectsCreated;
    }
}

