/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.Messages;
import com.vectrace.MercurialEclipse.commands.IConfiguration;
import com.vectrace.MercurialEclipse.commands.IConsole;
import com.vectrace.MercurialEclipse.commands.IErrorHandler;
import com.vectrace.MercurialEclipse.exception.HgCoreException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.views.console.HgConsole;
import com.vectrace.MercurialEclipse.views.console.HgConsoleHolder;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DefaultConfiguration
implements IConsole,
IErrorHandler,
IConfiguration {
    public String getDefaultUserName() {
        return MercurialUtilities.getHGUsername(false);
    }

    public String getExecutable() {
        if (!MercurialEclipsePlugin.getDefault().isHgUsable()) {
            MercurialUtilities.configureHgExecutable();
            MercurialEclipsePlugin.getDefault().checkHgInstallation();
        }
        return MercurialEclipsePlugin.getDefault().getPreferenceStore().getString("hg");
    }

    public String getPreference(String preferenceConstant, String defaultIfNotSet) {
        return MercurialUtilities.getPreference(preferenceConstant, defaultIfNotSet);
    }

    public void logError(Throwable e) {
        MercurialEclipsePlugin.logError(e);
    }

    public void logWarning(String message, Throwable e) {
        MercurialEclipsePlugin.logWarning(message, e);
    }

    public int getTimeOut(String commandId) {
        int timeout = 12000;
        String pref = this.getPreference(commandId, String.valueOf(timeout));
        try {
            timeout = Integer.parseInt(pref);
            if (timeout < 0) {
                throw new NumberFormatException(Messages.getString("DefaultConfiguration.timoutLessThanEqual"));
            }
        }
        catch (NumberFormatException e) {
            this.logWarning(String.valueOf(Messages.getString("DefaultConfiguration.timeoutForCommand")) + commandId + Messages.getString("DefaultConfiguration.notCorrectlyConfigured"), e);
        }
        return timeout;
    }

    public void commandCompleted(final int exitCode, final String message, final Throwable error) {
        this.run(new WithConsole(){

            public void run(HgConsole console) {
                int severity = 0;
                switch (exitCode) {
                    case 0: {
                        severity = 0;
                        break;
                    }
                    case 1: {
                        severity = 0;
                        break;
                    }
                    default: {
                        severity = 4;
                    }
                }
                console.commandCompleted((IStatus)new Status(severity, "com.vectrace.MercurialEclipse", message), error);
            }
        });
    }

    private void run(final WithConsole r) {
        MercurialEclipsePlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                r.run(HgConsoleHolder.getInstance().getConsole());
            }
        });
    }

    public void commandInvoked(final String command) {
        this.run(new WithConsole(){

            public void run(HgConsole console) {
                console.commandInvoked(command);
            }
        });
    }

    public void printError(final String message, final Throwable root) {
        this.run(new WithConsole(){

            public void run(HgConsole console) {
                console.errorLineReceived(root.getMessage(), (IStatus)new Status(4, "com.vectrace.MercurialEclipse", message, root));
            }
        });
    }

    public void printMessage(final String message, final Throwable root) {
        this.run(new WithConsole(){

            public void run(HgConsole console) {
                console.messageLineReceived(message, (IStatus)new Status(1, "com.vectrace.MercurialEclipse", message, root));
            }
        });
    }

    public HgRoot getHgRoot(File file) {
        try {
            return MercurialTeamProvider.getHgRoot(file);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgCoreException(e);
        }
    }

    private static interface WithConsole {
        public void run(HgConsole var1);
    }
}

