/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   
* This file was autogenerated by rpcgen, but should be modified by the developer.
* Make sure you don't use the -component_mod flag in future or this file will be overwritten.
* Mon Oct 13 13:43:15 2003
* System Includes
*
*/




#include <stdio.h>
#include <math.h>


/****************************************************************************************
 * 
 * Local Includes
 * 
 ***************************************************************************************/
#include "CSvcHacontroller.h"
#include "hacontroller.h"
#include "standard_service_manager.h"


/****************************************************************************************
 * 
 * Macro Functions
 * 
 ***************************************************************************************/


/****************************************************************************************
 * 
 * File-scope variables
 * 
 ***************************************************************************************/
static TStartupInfo iStartupInfo;
static CIntegerAllocator *iAliasHostAddressAllocator;
static CNetworkPartitionManager *iNetworkPartitionManager;
static CComponentManager<CSHacontroller> *iComponentManager;

/****************************************************************************************
 * 
 * Implementation
 * 
 ***************************************************************************************/


/****************************************************************************************
 * 
 * PUBLIC: GetInstanceKeyFromArgs
 * 
 ***************************************************************************************/
int CSvcHacontroller::GetInstanceKeyFromArgs( int aMethod, void *aArgs )
{
	int rv;
	int *ik_integer;
	TOptionDesc *ik_option;
	THaTunnelID *ik_tunnel_id;
	TTimeoutRequest *ik_timeout;
	TGetTunnelRequest *ik_tunnel_info;

	switch( aMethod ) {
	 
	  // Methods with an integer arg that is the key
	case DSTR_REMOVEAGENT:
	case STARTMOBILEAGENT:
	case STOPMOBILEAGENT:
	case GETMOBILEAGENTSTATUS:
	case GETSTATUS:
	case LISTTUNNELS:
	  ik_integer = (int*)aArgs;
	  rv = *ik_integer;
	  break;

	  // TOptionDesc
	case SETSINGLEOPTION:
	case REMOVESINGLEOPTION:
	case ADDLISTOPTION:
	case REMOVELISTOPTION:
	  ik_option = (TOptionDesc*)aArgs;
	  rv = ik_option->iAgentID;
	  break;
	  
	  // THaTunnelID
	case DESTROYTUNNELID:
	  ik_tunnel_id = (THaTunnelID*)aArgs;
	  rv = ik_tunnel_id->iAgentID;
	  break;

	  // Timeout
	case SETTIMEOUT:
	  ik_timeout = (TTimeoutRequest*)aArgs;
	  rv = ik_timeout->iAgentID;
	  break;

	  // TGetTunnelRequest
	case GETTUNNELINFO:
		ik_tunnel_info = (TGetTunnelRequest*)aArgs;
		rv = ik_tunnel_info->iAgentID;
		break;

	  // Invalid
	default:
	  rv = ERR_INVALID_METHOD;
	  break;
	}
	return rv;
}


/****************************************************************************************
 * 
 * PUBLIC: SetError
 * 
 ***************************************************************************************/
int CSvcHacontroller::SetError( int aMethod, void *aArgs, int aError )
{
  int rv = ERR_NONE;
  TResult *rv_result;
  TComponentList *rv_cl;
  THaStatus *rv_status;
  THaTunnelList *rv_tunnellist;
  THaTunnelInfo *rv_tunnel_info;

  switch( aMethod ) {
    
    // TComponentList
  case LIST_DEVICES:
    SET_LIST_ERROR_CODE( TComponentList, rv_cl );
    break;
    
    // TResult
  case CSTR_CREATEAGENT:
  case DSTR_REMOVEAGENT:
  case STARTMOBILEAGENT:
  case STOPMOBILEAGENT:
  case SETSINGLEOPTION:
  case REMOVESINGLEOPTION:
  case ADDLISTOPTION:
  case REMOVELISTOPTION:
  case DESTROYTUNNELID:
    SET_ERROR_CODE( TResult, iServiceResult, rv_result );
    break;
    
    // THaStatus
  case GETSTATUS:
    SET_ERROR_CODE( THaStatus, iCallResult.iServiceResult, rv_status );
    break;

    // THaTunnelList
  case LISTTUNNELS:
    SET_LIST_ERROR_CODE( THaTunnelList, rv_tunnellist );
    break;

	// THaTunnelInfo
  case GETTUNNELINFO:
	SET_ERROR_CODE( THaTunnelInfo, iCallResult.iServiceResult, rv_tunnel_info );
	break;

    // Invalid
  default:
    rv = ERR_INVALID_METHOD;
    break;
  }
  return rv;
}


/****************************************************************************************
 * 
 * PUBLIC: GetError
 * 
 ***************************************************************************************/
int CSvcHacontroller::GetError( int aMethod, void *aArgs )
{
  TResult *result;
  
  // check assumption
  assert( (aMethod == CSTR_CREATEAGENT) || (aMethod == DSTR_REMOVEAGENT) );
  
  // return error code
  result = (TResult*)aArgs;
  return result->iServiceResult;
}


/****************************************************************************************
 * 
 * PUBLIC: StartRPCService
 * 
 ***************************************************************************************/
int CSvcHacontroller::StartRPCService( CComponentManager<CSHacontroller> *aComponentManager, TStartupInfo *aArg )
{
	int err;

	// save the startup info
	iStartupInfo = *((TStartupInfo*)aArg);

	// store the component manager
	assert( iComponentManager == NULL );
	iComponentManager = aComponentManager;

	// setup the home address integer allocator
	iAliasHostAddressAllocator = new CIntegerAllocator();
	assert( iAliasHostAddressAllocator != NULL );
	err = iAliasHostAddressAllocator->AddToIntegerPool( iStartupInfo.iBaseInterfaceStartHostAddressRange, 
							    iStartupInfo.iBaseInterfaceStopHostAddressRange );
	if( err == -1 ) {
		delete iAliasHostAddressAllocator;
		iAliasHostAddressAllocator = NULL;
	    return ERR_INTEGER_ALLOCATOR_SETUP_ERROR;
	}

	// setup the network partition manager 
	iNetworkPartitionManager = new CNetworkPartitionManager();
	assert( iNetworkPartitionManager != NULL );
	err = iNetworkPartitionManager->SetConfiguration( iStartupInfo.iVirtualNetworkPrefix, 
							  iStartupInfo.iVirtualNetworkPrefixMask, 
							  iStartupInfo.iVirtualNetworkAllocSize );
	if( err == -1 ) {
		delete iAliasHostAddressAllocator;
		iAliasHostAddressAllocator = NULL;
		delete iNetworkPartitionManager;
		iNetworkPartitionManager = NULL;
		return ERR_VIRTUAL_NETWORK_CONFIGURATION_ERROR;
	}


	// done - success	
	return ERR_NONE;
}


/****************************************************************************************
 * 
 * PUBLIC: StopRPCService
 * 
 ***************************************************************************************/
int CSvcHacontroller::StopRPCService()
{
	// delete the host address allocator
	delete iAliasHostAddressAllocator;
	iAliasHostAddressAllocator = NULL;

	// delete the subnet address allocator
	delete iNetworkPartitionManager;
	iNetworkPartitionManager = NULL;

	// cleanup the component manager (stubs do the deletion)
	iComponentManager = NULL;
	return ERR_NONE;
}


/****************************************************************************************
 * 
 * PUBLIC: GetStartupInfo
 * 
 ***************************************************************************************/
TStartupInfo CSvcHacontroller::GetStartupInfo()
{
	return iStartupInfo;
}


/****************************************************************************************
 * 
 * PUBLIC: GetAliasHostAddressAllocator
 * 
 ***************************************************************************************/
CIntegerAllocator *CSvcHacontroller::GetAliasHostAddressAllocator()
{
	return iAliasHostAddressAllocator;
}


/****************************************************************************************
 * 
 * PUBLIC: GetAliasHostAddressAllocator
 * 
 ***************************************************************************************/
CNetworkPartitionManager *CSvcHacontroller::GetNetworkPartitionManager()
{
	return iNetworkPartitionManager;
}

