/*
* Copyright (c) 2005-2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* Some RSA key pairs.
*
*/




/**
 @file
*/

#include <cryptospi/keys.h>

RSA* key1;    /* modulus is 64 bytes */
RSA* key2;    /* modulus is 50 bytes */
RSA* key3;    /* modulus is 128 bytes */

#define SetKey \
  key->n = BN_bin2bn(n, sizeof(n)-1, key->n); \
  key->e = BN_bin2bn(e, sizeof(e)-1, key->e); \
  key->d = BN_bin2bn(d, sizeof(d)-1, key->d); \
  key->p = BN_bin2bn(p, sizeof(p)-1, key->p); \
  key->q = BN_bin2bn(q, sizeof(q)-1, key->q); \
  key->dmp1 = BN_bin2bn(dmp1, sizeof(dmp1)-1, key->dmp1); \
  key->dmq1 = BN_bin2bn(dmq1, sizeof(dmq1)-1, key->dmq1); \
  key->iqmp = BN_bin2bn(iqmp, sizeof(iqmp)-1, key->iqmp);

static void setKey1(RSA *key)
    {
    static unsigned char n[] =
"\x00\xAA\x36\xAB\xCE\x88\xAC\xFD\xFF\x55\x52\x3C\x7F\xC4\x52\x3F"
"\x90\xEF\xA0\x0D\xF3\x77\x4A\x25\x9F\x2E\x62\xB4\xC5\xD9\x9C\xB5"
"\xAD\xB3\x00\xA0\x28\x5E\x53\x01\x93\x0E\x0C\x70\xFB\x68\x76\x93"
"\x9C\xE6\x16\xCE\x62\x4A\x11\xE0\x08\x6D\x34\x1E\xBC\xAC\xA0\xA1"
"\xF5";

    static unsigned char e[] = "\x11";

    static unsigned char d[] =
"\x0A\x03\x37\x48\x62\x64\x87\x69\x5F\x5F\x30\xBC\x38\xB9\x8B\x44"
"\xC2\xCD\x2D\xFF\x43\x40\x98\xCD\x20\xD8\xA1\x38\xD0\x90\xBF\x64"
"\x79\x7C\x3F\xA7\xA2\xCD\xCB\x3C\xD1\xE0\xBD\xBA\x26\x54\xB4\xF9"
"\xDF\x8E\x8A\xE5\x9D\x73\x3D\x9F\x33\xB3\x01\x62\x4A\xFD\x1D\x51";

    static unsigned char p[] =
"\x00\xD8\x40\xB4\x16\x66\xB4\x2E\x92\xEA\x0D\xA3\xB4\x32\x04\xB5"
"\xCF\xCE\x33\x52\x52\x4D\x04\x16\xA5\xA4\x41\xE7\x00\xAF\x46\x12"
"\x0D";
    
    static unsigned char q[] =
"\x00\xC9\x7F\xB1\xF0\x27\xF4\x53\xF6\x34\x12\x33\xEA\xAA\xD1\xD9"
"\x35\x3F\x6C\x42\xD0\x88\x66\xB1\xD0\x5A\x0F\x20\x35\x02\x8B\x9D"
"\x89";

    static unsigned char dmp1[] =
"\x59\x0B\x95\x72\xA2\xC2\xA9\xC4\x06\x05\x9D\xC2\xAB\x2F\x1D\xAF"
"\xEB\x7E\x8B\x4F\x10\xA7\x54\x9E\x8E\xED\xF5\xB4\xFC\xE0\x9E\x05";

    static unsigned char dmq1[] =
"\x00\x8E\x3C\x05\x21\xFE\x15\xE0\xEA\x06\xA3\x6F\xF0\xF1\x0C\x99"
"\x52\xC3\x5B\x7A\x75\x14\xFD\x32\x38\xB8\x0A\xAD\x52\x98\x62\x8D"
"\x51";

    static unsigned char iqmp[] =
"\x36\x3F\xF7\x18\x9D\xA8\xE9\x0B\x1D\x34\x1F\x71\xD0\x9B\x76\xA8"
"\xA9\x43\xE1\x1D\x10\xB2\x4D\x24\x9F\x2D\xEA\xFE\xF8\x0C\x18\x26";

    SetKey;
    }

static void setKey2(RSA *key)
    {
    static unsigned char n[] =
"\x00\xA3\x07\x9A\x90\xDF\x0D\xFD\x72\xAC\x09\x0C\xCC\x2A\x78\xB8"
"\x74\x13\x13\x3E\x40\x75\x9C\x98\xFA\xF8\x20\x4F\x35\x8A\x0B\x26"
"\x3C\x67\x70\xE7\x83\xA9\x3B\x69\x71\xB7\x37\x79\xD2\x71\x7B\xE8"
"\x34\x77\xCF";

    static unsigned char e[] = "\x3";

    static unsigned char d[] =
"\x6C\xAF\xBC\x60\x94\xB3\xFE\x4C\x72\xB0\xB3\x32\xC6\xFB\x25\xA2"
"\xB7\x62\x29\x80\x4E\x68\x65\xFC\xA4\x5A\x74\xDF\x0F\x8F\xB8\x41"
"\x3B\x52\xC0\xD0\xE5\x3D\x9B\x59\x0F\xF1\x9B\xE7\x9F\x49\xDD\x21"
"\xE5\xEB";

    static unsigned char p[] =
"\x00\xCF\x20\x35\x02\x8B\x9D\x86\x98\x40\xB4\x16\x66\xB4\x2E\x92"
"\xEA\x0D\xA3\xB4\x32\x04\xB5\xCF\xCE\x91";

    static unsigned char q[] =
"\x00\xC9\x7F\xB1\xF0\x27\xF4\x53\xF6\x34\x12\x33\xEA\xAA\xD1\xD9"
"\x35\x3F\x6C\x42\xD0\x88\x66\xB1\xD0\x5F";
    
    static unsigned char dmp1[] =
"\x00\x8A\x15\x78\xAC\x5D\x13\xAF\x10\x2B\x22\xB9\x99\xCD\x74\x61"
"\xF1\x5E\x6D\x22\xCC\x03\x23\xDF\xDF\x0B";

    static unsigned char dmq1[] =
"\x00\x86\x55\x21\x4A\xC5\x4D\x8D\x4E\xCD\x61\x77\xF1\xC7\x36\x90"
"\xCE\x2A\x48\x2C\x8B\x05\x99\xCB\xE0\x3F";

    static unsigned char iqmp[] =
"\x00\x83\xEF\xEF\xB8\xA9\xA4\x0D\x1D\xB6\xED\x98\xAD\x84\xED\x13"
"\x35\xDC\xC1\x08\xF3\x22\xD0\x57\xCF\x8D";

    SetKey;
    }

static RSA* createRSAKey3()
	{
	unsigned char n_data[] =
		"\xa3\x50\x45\x34\xc2\x9c\x59\xca\x9a\x34\xcb\xb9\x5a\x18\xd4\x35"
		"\xfe\x66\xfb\xc7\xde\xcd\x57\x2b\x91\xc8\x0f\x72\xee\x07\x86\xd4"
		"\xdd\x92\xf8\xb8\x41\x6d\x54\xbd\xe1\x2d\xf2\xe8\x3f\x8d\xc9\xb1"
		"\x64\x29\x80\xbd\x31\x85\x26\x50\xa5\xa8\xf6\xd6\xd8\xc6\xa9\xbe"
		"\x96\x5b\x34\xfe\x76\x59\xac\x5d\xd3\x72\xab\x91\x27\x7b\x2c\x9c"
		"\xeb\x79\x7c\x4b\x4b\x58\x88\xe3\x3c\x0d\x2c\xfb\xe9\xaa\xd5\x3e"
		"\x15\x84\x75\xed\x88\x88\x4d\x5d\xcc\x66\x3a\xf5\xaa\xa6\x20\x30"
		"\xe3\x79\x9f\xaa\x1f\xa4\x7a\xb2\x66\x52\x08\x59\x7f\x35\x84\x97";

	int n_data_len = 128;

	unsigned char e_data[] =
		"\x01\x00\x01";

	int e_data_len = 3;

	unsigned char d_data[] =
		"\x85\xb3\xb3\xd4\xeb\xf6\xc0\xf4\x43\xa7\x31\x9a\x7f\x8e\x90\x3d"
		"\xdc\x17\x47\xce\x6c\x33\xc4\x47\xe1\x43\xde\x92\x03\x19\x9a\x63"
		"\x2f\x3b\xa1\xf0\x87\x70\x10\xce\x9b\x49\xd8\xf2\x17\x05\xe7\xb8"
		"\x18\xfe\x79\x6d\x6a\xdb\x4d\x70\xfd\x0f\x05\x77\x03\x66\x31\x94"
		"\x8d\xd2\x1f\xfe\x77\x15\x7a\xaf\x97\x88\x57\xe4\x35\x8d\xed\x82"
		"\xb5\x8c\xc8\x5f\x5e\xf7\x04\x80\xff\xd7\xbe\x08\x48\xda\xfb\x98"
		"\x35\x43\xb2\xe8\x67\xf8\x31\x55\x08\x4d\x85\x41\xa1\x4b\x5e\xa6"
		"\xcf\x5f\xcb\x65\x11\x27\xb2\xc6\x43\x83\x11\x4f\x02\xa1\x4c\xb1";

	int d_data_len = 128;

	RSA* key = RSA_new();
	key->n = BN_new();
	key->e = BN_new();
	key->d = BN_new();
	BN_bin2bn(n_data, n_data_len, key->n);
	BN_bin2bn(e_data, e_data_len, key->e);
	BN_bin2bn(d_data, d_data_len, key->d);
	return key;
	}

void initKeys()
    {
	key1 = RSA_new();
	key2 = RSA_new();

    setKey1(key1);
    setKey2(key2);

	key3 = createRSAKey3();
    }
