# Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
# All rights reserved.
# This component and the accompanying materials are made available
# under the terms of the License "Eclipse Public License v1.0"
# which accompanies this distribution, and is available
# at the URL "http://www.eclipse.org/legal/epl-v10.html".
#
# Initial Contributors:
# Nokia Corporation - initial contribution.
#
# Contributors:
#
# Description:
#

#!C:\Perl\bin\perl
# file: NaptTestServer.pl

use IO::Socket;
use IO::Handle;
use IO::Select;
use Net::Ping;
use IPC::SysV qw(IPC_PRIVATE IPC_RMID IPC_CREAT S_IRWXU);
use IPC::Semaphore;
use Net::DNS::Resolver;
use Switch;

#Parent process PID
my $pidFile = '/var/run/NaptTestServer.pid';

#for some unknown reasons that i don't know of...the program seems to freeze if the data sent is not ended with a "\n"
#NaptTestServer listen port
$listenport = 48555;
#tcp send params
$ipaddr2sendtcp = "192.168.20.11";
#tcp port no
$port2sendtcp = 7;
#tcp message
$tcpmessage = "tHis is ecHo calling for narcIssus the tcp way \n";
$tcpbulkmessage = "tHis is ecHo calling for narcIssus the tcp way ";

#udp send params
$ipaddr2sendudp = "192.168.20.11";
#udp port no
$port2sendudp = 7;
$echoport = 7;
#udp message
$udpmessage = "tHis is ecHo calling for narcIssus the udp way \n";
#udp invalid port
$invalidport2sendudp = 600000;
#test case 4 & 5
$NameServerIp = "10.225.66.20";
#test case 4
$ipaddress2resolv = "64.233.187.99";
#test case 6
$pingaddr_default = "192.168.20.11";
$pingaddr_custom = undef;
$add_buffer="";
$storeaddr = 0;
$current_ip_addr = 0;
$current_port = 48555; # Unused ports
$port_base_val = 48305;

$shm_size = 6; # Number of bytes to hold the port number
$shm_handle = undef;
$enable_log = undef;
$file_Line = undef;

sub REAPER
{
	#print "in reaper as the child died...........................\n";
	$waitedpid = wait;
	# loathe sysV: it makes us not only reinstate
	# the handler, but place it after the wait
	$SIG{CHLD} = \&REAPER;
}
$SIG{CHLD} = \&REAPER;

# Allocate the Shared Memory and protect the same using Semaphore.
sub alloc 
	{
	my $class = shift;
	my $value = @_ ? shift : '';

	$shm_handle = shmget(IPC_PRIVATE, $shm_size, S_IRWXU) or die "shmget: $!\n";
	my $semaphore = IPC::Semaphore->new(IPC_PRIVATE, 1, S_IRWXU | IPC_CREAT)
			or die "IPC::Semaphore->new: $!\n";
	$semaphore->setval(0,1)    or die "sem setval: $!\n";

	my $self_reference = bless {
	process_id => $$,
	shm_key => $shm_handle,
	semaphore => $semaphore,
	} => $class;

	put($self_reference, $value);
	return $self_reference;
}

# Fetch the contents from Shared memory using Semaphore
sub get 
{
	my $self_reference = shift;
	lock($self_reference);
	my $value = peek($self_reference);
	unlock($self_reference);
	return $value;
}

# Read the content from Shared Memory.
sub peek 
{
	my $self_reference = shift;
	shmread($self_reference->{shm_key}, my $buff='', 0, $shm_size) or die "shmread: $!\n";
	return $buff;
}

# Write the content into Shared Memory using Semaphore. 
sub put 
{
	my $self_reference = shift;
	my $msg = shift;
	lock($self_reference);
	poke($self_reference, $msg);
	unlock($self_reference);
}

# Write the content into Shared Memory.
sub poke 
{
	my($self_reference,$msg) = @_;
	shmwrite($self_reference->{shm_key}, $msg, 0, $shm_size) or die "shmwrite: $!\n";
}

# Establish Semaphore Lock
sub lock 
{
	my $self_reference = shift;
	$self_reference->{semaphore}->op(0,-1,0) or die "semop: $!\n";
}

# Establish Semaphore UnLock
sub unlock 
{
	my $self_reference = shift;
	$self_reference->{semaphore}->op(0,1,0) or die "semop: $!\n";
}

# When the server is running, by pressing the key "Ctrl+C" interrupt INT is raised.
# This signal is handled here to cleanup the used resources(iptables and shared memory).
sub clean_shared_Mem
{
	# To clean the shared memory
	#print "INFO: Clearing the shared memory\n";
	my $self_reference = $shm_handle;
	return unless $self_reference->{process_id} == $$;  # avoid dup dealloc
	shmctl($self_reference->{shm_key}, IPC_RMID, 0) or warn "shmctl RMID: $!\n";
	$self_reference->{semaphore}->remove() or warn "sema->remove: $!\n";
	
	#print "INFO: Cleaning iptable rules\n";
	while(!system("iptables -t mangle -D OUTPUT 1"))
	{}
	
	$SIG{TERM} = \&clean_shared_Mem;
	exit(0);
}

$SIG{TERM} = \&clean_shared_Mem;

# Function to start with.
# The parent process always listening on port TODO , upon receiving the connection request spawns a child process.
#  Child process receives the messages from EPOC and triggers the respective test case one by one.
sub initfunction
{
	&CheckUsage;
	my $GlobalPid = fork();
	if($GlobalPid == 0)
		{
		&EnableIpForwarding;
		&InitializeResources;
		$listensock = new IO::Socket::INET (LocalPort => $listenport,
	                              Proto     => 'tcp',
	                              Listen    => 100,
	                              Reuse     => 1,
								);
		if($listensock == undef)
		{
		my $err_reason = $!;
		&clean_shared_Mem;
		die "Could not connect: $err_reason";
		}
		
		while(1)
			{
			#print "INFO: Listening for connections on port $listenport...........................\n";
				    					
			$newlistensock = $listensock->accept();
						
			#print "INFO: Connection established..................................................\n";
			$pid = fork();
				die "fork() failed: $!" unless defined($pid);
			
			if($pid == 0)
				{
				$listensock->autoflush(1);
			
				while(defined ($recvbuf = <$newlistensock>))
					{
					chop($recvbuf);
					$newlistensock->autoflush(1);
					parsemessage($recvbuf);
					close(newlistensock);
					}#while(defined ($recvbuf = <$newlistensock>) )
				exit(0);
			   }#if ends here	
			}#while
		}# if($GlobalPid == 0)
	else
		{
	  	open PIDFILE, ">$pidFile" or die "can't open $pidFile: $!\n";
		print PIDFILE $GlobalPid;
		close PIDFILE;
		exit 0;
		}
}

sub GetIpAddress
{
	open HANDLE, "ifconfig |";
	my @log = <HANDLE>;
	close HANDLE;
	if (@log == undef)
	{
		return;
	}

	@InetAddrList = grep (/inet addr/i, @log );
	my @IpAddrList = grep (!/192/, @InetAddrList );
	#Take the first ethernet interface address
	$IpAddrList[0] =~ /inet\s*addr\:(.*)\s*Bcast/i;
	return $1;
}

sub GetNameServerIp
{
	
	my @log = undef;
	my $FirstNameServer = undef;
	if(-e "/etc/resolv.conf")
	{
		open HANDLE, "</etc/resolv.conf" or die "Error: Command IP config failed\n";
		@log = <HANDLE>;
		close HANDLE;
		@NameServerList = grep (/nameserver/i, @log );
		#Take the first nameserver interface address
		$NameServerList[0] =~ /nameserver(\s)*(.*)\s*$/i;
		$FirstNameServer = $2;
	}
	print ($FirstNameServer == undef)? $NameServerIp : $FirstNameServer;
	return ($FirstNameServer == undef)? $NameServerIp : $FirstNameServer;
}

# Extract the IP address from the received buffer, this IP is used as a gateway for all the testcases.
sub ExtractCurrentIp
{
	#Route add function
	$add_buffer = $_[0];
	chomp($add_buffer);
	@strings=split(/:ethaddress/,$add_buffer);
	$current_ip_addr = $strings[0];
}

sub PingGlobal
{
	$ping_buffer = $_[0];
	chomp($ping_buffer);
	@strings=split(/:pingglobal/,$ping_buffer);
	$pingaddr_custom = $strings[0];
	
	return &testcase6($current_ip_addr);
}

sub StoreAddr
{
	$ping_add = $_[0];
	chomp($ping_add);
	@strings=split(/:storeaddr/,$ping_add);
	$storeaddr = $strings[0];
	$current_ip_addr = $strings[0];
}

# Parse the message and trigger the test cases.
sub parsemessage
{
	
	my $result = 0;

	$buffer = $_[0];
	if ($buffer =~ /:ethaddress/)
	{
		ExtractCurrentIp($buffer);
		return;
	}
	elsif ($buffer =~ /:pingglobal/)
	{
		#print " \n Test Case :- Ping Global Interface. \n";
		$result = PingGlobal($buffer);
		$pingaddr_custom = undef;
	}
	elsif ($buffer =~ /:storeaddr/)
	{
		StoreAddr($buffer);
		return;
	}
	elsif("test1" eq $buffer)
	{
		#print "\n Test Case :- Send data over TCP socket to Echo Server running in Test Network \n";
		$result = &testcase1($current_ip_addr);
	}
	elsif("test2" eq $buffer)
	{
		#print "\n Test Case 2:- Send data over UDP Socket to Echo Server running in Test Network \n";
		$result = &testcase2($current_ip_addr);
	}
	elsif("test3" eq $buffer)
	{
		#print "\n Test Case 3 :- Send data over UDP Socket to invalid port. \n";
		$result = &testcase3($current_ip_addr);
	}
	elsif("test4" eq $buffer)
	{
		#print "\n Test Case 4:- Resolve host name from IP address.\n";
		$result = &testcase4($current_ip_addr);
	}
	elsif("test5" eq $buffer)
	{
		#print " \n Test Case 5:- Resolve IP addr from host name.\n";
		$result = &testcase5($current_ip_addr);
	}
	elsif("test6" eq $buffer)
	{
		#print "Test Case 6:- Ping Echo Server in Test Network.\n";
		$result = &testcase6($current_ip_addr);
		$pingaddr_custom = undef;
	}
	elsif("test7" eq $buffer)
	{
		#print " \n Test Case 7:- Open many TCP Sockets and Send data to Echo Server over each socket.\n";
		$result = &testcase7($current_ip_addr);
	}
	elsif("test8" eq $buffer)
	{
		#print " \n Test Case 8:- Send bulk data over TCP socket to Echo Server in Test Network.\n";
		$result = &testcase8($current_ip_addr);
	}
	elsif("test9" eq $buffer)
	{
		#print " \n Test Case 9:- Open,Send and Close TCP Sockets in different order.\n";
		$result = &testcase9($current_ip_addr);
	}
	elsif("test10" eq $buffer)
	{
		#print " \n Test Case 10:- NAPT UDP Timer Expires. \n";
		$result = &testcase10($current_ip_addr);
	}
	elsif("test11" eq $buffer)
	{
		#print " \n Test Case 11:- Send data over global socket and Napt socket \n";
		$result = &testcase1($current_ip_addr);
	}
	elsif("test12" eq $buffer)
	{
		#print " \n Test Case 12:- \n ICMP packet with customised TTL value test \n";
		$result = &icmp_ttl($current_ip_addr);
		#print "\n Test step result: $result\n";

		#print " \n ICMP Address Mask Message test \n";
		$result = &icmp_addr($current_ip_addr);
		#print "\n Test step result: $result\n";

		#print " \n TCP packet with customised TTL value test \n";
		$result = &tcp_ttl($current_ip_addr);
		#print "\n Test step result: $result\n";

		#print " \n UDP packet with customised TTL value test \n";
		$result = &udp_ttl($current_ip_addr);
		#print "\n Test step result: $result\n";

		#print " \n ICMP Time Stamp Message test \n";
		$result = &icmp_timestamp($current_ip_addr);
		#print "\n Test step result: $result\n";
	}
	elsif("test13" eq $buffer)
	{
		#print " \n Test Case 13:- NAPT TCP timer expires\n";
		$result = &testcase13($current_ip_addr);
	}
	else
	{	
		#print __FILE__.": ".__LINE__.": ERROR: Invalid test case number received \n";
	}
	#print "\n Test case result: $result\n";
	#print "\n.....................................End of test case............................ \n";
}

#May not be required.
sub EnableIpForwarding
{
	system("echo 1 >| /proc/sys/net/ipv4/ip_forward");
	system("echo 0 >| /proc/sys/net/ipv4/conf/all/rp_filter");
}

# 1. Insert the dummy rules into iptables. Later these rules are replaced with actual rules.
# 2. Make the port number availbale for all the child processes by writing it into Shared Memory.
# 3. Simultanious access to the port number can fail the test cases, Use Semaphore to protect the port number across processes.

sub InitializeResources
{
	#print "INFO: Initializing iptable with dummy rules\n";
	my $traffic_mark_command = undef;
	my $max_index = $current_port - $port_base_val;
	for ($index = 1; $index <= $max_index; $index++)
	{
	$traffic_mark_command = "iptables -t mangle -I OUTPUT $index ";
	system($traffic_mark_command);
	}
	
	# Create the shared memory segment and Place the port number
	$shm_handle = &alloc("Object", $current_port);
}

# Unassigned port range picked from IANA. These ports are used as source port for all the traffic generated by this TestServer.
# 1. Port number will read from Shared Memory which is controlled by Semaphore.
# 2. Port numbers are started from the begining once the unassinged port least level is reached.
	
sub SelectPortNumber
{
	$port = get($shm_handle);

	if($port <= 48306)
	{
		$port = 48555;
	}
	else
	{
		$port--;
	}
	lock($shm_handle);
	poke($shm_handle, "$port");
	unlock($shm_handle);
	return $port;
}

# Creates an source port based route using LINUX iptables utility. Route selection is based on the 
# source port of TCP or UDP packet. Routing decisions are decided well before the connection start.
# 1. Route Table entry is added into /etc/iproute2/rt_tables
# 2. Traffic is marked based on the source port at OUTPUT hook.
# 3. Associate the Marked traffic to the Route Table.
# 4. Route the individual Route Table traffic to the specific gateway(In our case EPOC private IP is the Gateway).
sub CreateRouteTable
{
	my $log_file = $_[0];
	my $gateway_addr = $_[1];
	my $source_port = $_[2];
	my $proto = $_[3];
	my $result = 0;

	my $route_index = $source_port - $port_base_val;

	#Mark the outgoing traffic from the local host
	my $traffic_mark_command = undef;
	if ($proto =~ /^tcp$/i)
	{
		$traffic_mark_command = "iptables -t mangle -R OUTPUT $route_index -p tcp --sport $source_port -j MARK --set-mark $source_port";
	}
	elsif ($proto =~ /^udp$/i)
	{
		$traffic_mark_command = "iptables -t mangle -R OUTPUT $route_index -p udp --sport $source_port -j MARK --set-mark $source_port";
	}
	elsif ($proto =~ /icmp/i)
	{
		my $type = undef;
		if ($proto =~ /ping/i)
		{
			$type = 8;
		}
		elsif ($proto =~ /ttl/i)#To generat Time exceeded message
		{
			$type = 8;
		}
		elsif ($proto =~ /time/i)
		{
			$type = 13;
		}
		elsif ($proto =~ /addr/i)#address mask request
		{
			$type = 17;
		}
		else
		{
			$file_Line = __FILE__.": ".__LINE__;
			&Log($log_file, "$file_Line: ERROR: Route can not be added for the type, $proto");
			return sendresult($log_file, $result);
		}
		$traffic_mark_command = "iptables -t mangle -R OUTPUT $route_index -p icmp --icmp-type $type -j MARK --set-mark $source_port";
	}
	else
	{
		$file_Line = __FILE__.": ".__LINE__;
		&Log($log_file, "$file_Line: ERROR: Invalid protocol type received");
		return sendresult($log_file, $result);
	}
	&Log($log_file, $traffic_mark_command);
	system($traffic_mark_command);
	
	#Read all the route table entries and add new entry if not found
	open(FILE,"</etc/iproute2/rt_tables") or die "opening /etc/iproute2/rt_tables failed $!\n";

	my $found = 0;
	my @to_write = <FILE>;
	close FILE;

	my $index = 0;
	my $no_of_lines = @to_write;
	while(($index < $no_of_lines) && ($found == 0))
	{
		$route = $to_write[$index];
		if ($route =~ /^$route_index\s*/i)
		{
			$found = 1;
		}
		$index++;
	}
	if($found == 0)
	{
		$route_table_entry = "$route_index       rt_table$route_index\n";
		&Log($log_file, $route_table_entry);
		push (@to_write, $route_table_entry);
	}

	open(FILE,">/etc/iproute2/rt_tables") or die "opening /etc/iproute2/rt_tables failed $!\n";
	print FILE @to_write;
	close FILE;

	#Flush the table
	my $flush_one_table = "ip route flush table rt_table$route_index 2>&1 ";
	&Log($log_file, $flush_one_table);
	system($flush_one_table);
	
	#Add the route into the route table
	my $route_add = "ip route add default via $gateway_addr table rt_table$route_index";
	&Log($log_file, $route_add);
	system($route_add);
	
	#route all the marked packets to respective route
	my $routing_rule = "ip rule add fwmark $source_port table rt_table$route_index";
	&Log($log_file, $routing_rule);
	system($routing_rule);
}

sub Log
{
	my $log_file = $_[0];
	my $data = $_[1];
	if($enable_log)
	{
		print $log_file "$data\n";
	}
}

# Delete multiple routes
# Received arrays first argument is an log file handle, rest all are port numbers.
sub DeleteRouteTables
{
	my @port_list = @_;
	my $no_of_ports = @port_list;
	while( 2 < $no_of_ports)
	{
		$no_of_ports--;
		&DeleteRouteTable($port_list[1], $port_list[$no_of_ports]);
	}
}

# Delete single route.
sub DeleteRouteTable
{
	my $log_file = $_[0];
	my $port = $_[1];
	my $route_index = $port - $port_base_val;

	#Delete the rule
	my $delete_routing_rule = "ip rule del fwmark $port";
	&Log($log_file, $delete_routing_rule);
	system($delete_routing_rule);	

	#delete the table entry from /etc/iproute2/rt_tables
	open IN, "</etc/iproute2/rt_tables" or "opening /etc/iproute2/rt_tables failed $!\n";
	my @to_write;
	while($route = <IN>)
	{
		if ($route !~ /^$route_index\s*/i)
		{
			push (@to_write,$route);
		}
	}
	close IN;
	open(FILE,">/etc/iproute2/rt_tables") or die "opening /etc/iproute2/rt_tables failed $!\n";
	print FILE @to_write;
	close FILE;

	# Delete the iptables entry
	my $delete_chain = "iptables -t mangle -R OUTPUT $route_index";
	&Log($log_file, $delete_chain);
	system($delete_chain);
}

#DESCRIPTION:Sending TCP packets to echo server in Test Network.
sub testcase1
{
	my $gateway_addr = $_[0];
	$result = "0";
	my $source_port = &SelectPortNumber;
	my $protocol = "tcp";
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;

	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase1");
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);

	if($tcpsendsock = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										PeerPort => "$port2sendtcp",
										Proto    => 'tcp',
										LocalPort => "$source_port",
										ReuseAddr => 1,
										Timeout => 10,
						))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: TCP socket could not be created. Reason: $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}	
	
	if(print $tcpsendsock $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: TCP socket unable to send. Reason: $!\n";	
		$result = 0;
		close $tcpsendsock;
		sleep 1;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
	
	$answertcpserver = <$tcpsendsock>;
	&Log (*LOGFILE, $answertcpserver);
	close $tcpsendsock;
	sleep 1;
	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:testcase2
#Sending UDP packets to echo server in test n/w
sub testcase2
{
	#print "executing test case2 UDP\n";
	$result = 0;
	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	my $protocol = "udp";
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "ERROR: Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase2");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	

	if($udpsendsock = new IO::Socket::INET (Proto => "$protocol",
											LocalPort => "$source_port",
											Timeout => 10,
											))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: UDP socket could not be created. Reason: $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}	
		
	$udpipaddr = inet_aton($ipaddr2sendudp);
	$udpaddr = sockaddr_in($port2sendudp, $udpipaddr);
	
$z = 0;
while($z < 11 )
{
	if(send($udpsendsock, $udpmessage, 0, $udpaddr) == length($udpmessage) )
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot send to $ipaddr2sendudp($port2sendudp): $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
$z++;
}

	$MAXLEN = 100;
	if($udpserveraddr = recv($udpsendsock, $ansudpserver, $MAXLEN, 0))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot recv: $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}

	($udpserverport, $udpserveripaddr) = sockaddr_in($udpserveraddr);
	&Log (*LOGFILE, $ansudpserver);
	close $udpsendsock;
	sleep(1);
	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:testcase3
#Sending UDP packets to invalid port
sub testcase3
{
	#print "executing test case3 invalid UDP\n";
	$result = 0;
	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	my $protocol = "udp";
	
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase3");
	
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);

	if($udpsendsock = new IO::Socket::INET (Proto => "$protocol",
											LocalPort => "$source_port",
											Timeout => 10,
											Blocking => 0,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: UDP socket could not be created. Reason: $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}	
		
	$udpipaddr   = inet_aton($ipaddr2sendudp);
	$udpaddr = sockaddr_in($invalidport2sendudp, $udpipaddr);
	
	if(send($udpsendsock, $udpmessage, 0, $udpaddr) == length($udpmessage) )
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot send to $ipaddr2sendudp($port2sendudp): $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
	$MAXLEN = 100;
	if($udpserveraddr = recv($udpsendsock, $ansudpserver, $MAXLEN, 0))
	{
		$result = 0;
	}
	else
	{
		&Log (*LOGFILE, "ans is: $ansudpserver\n");
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot recv: $!\n";
		close ($udpsendsock);
		sleep(1);
		$result = 1;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}

	($udpserverport, $udpserveripaddr) = sockaddr_in($udpserveraddr);
	&Log (*LOGFILE, $ansudpserver);
	close ($udpsendsock);
	sleep(1);
	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:testcase4
#Resolve IP address to host name
sub testcase4
{
  	$ip2resolv = "81.89.142.130"; #www.symbian.org
	$result = 0;
	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	my $protocol = "udp";
	
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;

	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase4");
	
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	
	$res = new Net::DNS::Resolver;
	if($res == undef)
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot instantiate DNS::Resolver: $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
	
	$addr = &GetIpAddress;
	if($addr == undef)
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Ip address extraction failed\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}

	$res->srcaddr($addr);
	$res->srcport($source_port);
	$res->nameservers(&GetNameServerIp); #DNS server ip picked from /etc/resolv.conf or hardcoded
	$res->retry(2);
	$res->udp_timeout(10);

	if($packet = $res->send($ip2resolv))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Failed to resolve $ip2resolv :$!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
	sleep(1);
	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:testcase5
#Resolve host name  to IP address
sub testcase5
{
	$host2resolv = "www.symbian.org";
	$result = 0;
	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	my $protocol = "udp";
	
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase5");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);

	$res = new Net::DNS::Resolver;

	if($res == undef)
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot instantiate DNS::Resolver. Reason: $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}

	$addr = &GetIpAddress;
	if($addr == undef)
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Ip address extraction failed\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
	
	$res->srcaddr($addr);
	$res->srcport($source_port);
	$res->nameservers(&GetNameServerIp); #DNS server ip picked from /etc/resolv.conf or hardcoded
	$res->retry(2);
	$res->udp_timeout(10);

	if($packet = $res->send($host2resolv))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Failed to resolve $host2resolv :(\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
	sleep(1);
	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:testcase6
#Ping someone
sub testcase6
{
	#print "executing test case6 ping \n";
	$result = 0;

	if($pingaddr_custom != undef)
	{
		$pingaddr = $pingaddr_custom;
	}
	else
	{
		$pingaddr = $pingaddr_default;
	}	

	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	$protocol = "icmpping";
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase6");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	&Log (*LOGFILE, "ping $pingaddr");

	$pinghandle = Net::Ping->new("icmp",2);
	if($pinghandle->ping($pingaddr))
	{
		$result = 1;
		&Log (*LOGFILE, "INFO: ping successful");
	}
	else
	{
		$result = 0;
		&Log (*LOGFILE, "INFO: ping Failed");
	}
	sleep (1);
	$pinghandle->close();
	$pingaddr_custom = undef;
	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:testcase7
#Opening 5 tcp sockets and send data(not the most eligent way of doing it..need to improve upon it)
sub testcase7
{
	#print "executing test case7 open 5 sockets and send data \n";
	$result = 0;
	my $gateway_addr = $_[0];
	my $source_port1 = &SelectPortNumber;
	my $protocol = "tcp";
	my @port_list = undef;
	
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase7");
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port1, $protocol);
	
	push (@port_list, *LOGFILE);
	push (@port_list, $source_port1);

	if($tcpsendsock1 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port1",
										 ReuseAddr =>1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock1:TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}
	sleep 1;
	
	my $source_port2 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port2, $protocol);
	push (@port_list, $source_port2);

	if($tcpsendsock2 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port2",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock2:TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;

	my $source_port3 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port3, $protocol);
	push (@port_list, $source_port3);

	if($tcpsendsock3 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port3",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock3:TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;

	my $source_port4 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port4, $protocol);
	push (@port_list, $source_port4);
	
	if($tcpsendsock4 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port4",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock4:TCP socket could not be created by. Reason: $!
";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;

	my $source_port5 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port5, $protocol);
	push (@port_list, $source_port5);

	if($tcpsendsock5 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port5",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock5:TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;
	
	#socket opening is over need to send data through all of them...printing the response as it comes
		
	if(print $tcpsendsock1 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock1:TCP socket unable to send. Reason: $!\n";	
		$result = 0;
		close $tcpsendsock1;
		sleep 1;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}
	
	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock1>;
	&Log (*LOGFILE, $answertcpserver);

	sleep 1;

	if(print $tcpsendsock2 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock2:TCP socket unable to send. Reason: $!\n";	
		$result = 0;
		close $tcpsendsock2;
		sleep 1;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock2>;
	&Log (*LOGFILE, $answertcpserver);

	sleep 1;

	if(print $tcpsendsock3 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock3:TCP socket unable to send. Reason: $!\n";	
		$result = 0;
		close $tcpsendsock3;
		sleep 1;		
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}
	
	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock3>;
	&Log (*LOGFILE, $answertcpserver);

	sleep 1;

	if(print $tcpsendsock4 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock4:TCP socket unable to send. Reason: $!\n";
		$result = 0;
		close $tcpsendsock4;
		sleep 1;		
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock4>;
	&Log (*LOGFILE, $answertcpserver);

	sleep 1;

	if(print $tcpsendsock5 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock5:TCP socket unable to send. Reason: $!\n";
		$result = 0;
		close $tcpsendsock5;
		sleep 1;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock5>;
	&Log (*LOGFILE, $answertcpserver);

	sleep 1;
	close($tcpsendsock1);
	close($tcpsendsock2);
	close($tcpsendsock3);
	close($tcpsendsock4);
	close($tcpsendsock5);
	sleep(1);	
	&DeleteRouteTables(@port_list);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:testcase8
#Sending bulk data
sub testcase8
{
	#print "executing test case8 sending bulk \n";
	$result = 0;
	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	my $protocol = "tcp";

	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase8");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	
	$count = 0;
	$longtcpmessage = "";
	#Generating data long enough for TCP socket
	while($count<400)
	{
		$longtcpmessage = join($longtcpmessage,'',$tcpbulkmessage);
		$count++;
	}
	$longtcpmessage = join($longtcpmessage,'',$tcpmessage);
	#&Log (*LOGFILE, "message is=  $longtcpmessage");

	if($tcpsendsock = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: TCP socket could not be created. Reason: $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}	
	
	if(print $tcpsendsock $longtcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: TCP socket unable to send. Reason: $!\n";	
		$result = 0;
		close $tcpsendsock;
		sleep 1;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
	
	$answertcpserver = <$tcpsendsock>;
	#&Log (*LOGFILE, "Echo message is=  $answertcpserver");

	close ($tcpsendsock);
	sleep(1);
	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:testcase9
#Random opening sending and closing data
sub testcase9
{
	#print "executing test case9 random sending data \n";
	#Opening 5 sockets 
	$result = 0;
	my $gateway_addr = $_[0];
	my $source_port1 = &SelectPortNumber;
	my $protocol = "tcp";
	my @port_list = undef;
	
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase9");
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port1, $protocol);
	push (@port_list, *LOGFILE);
	push (@port_list,$source_port1);
	$answertcpserver = "";
	
	&Log (*LOGFILE, "opening socket no 1, 2, 3, 4 and 5\n");

	if($tcpsendsock1 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port1",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock1:TCP socket could not be created by. Reason:$!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}
	
	sleep 1;
	
	my $source_port2 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port2, $protocol);
	push (@port_list,$source_port2);

	if($tcpsendsock2 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port2",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock2:TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;

	my $source_port3 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port3, $protocol);
	push (@port_list,$source_port3);	

	if($tcpsendsock3 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port3",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock3:TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;

	my $source_port4 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port4, $protocol);
	push (@port_list, $source_port4);

	if($tcpsendsock4 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port4",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock4::TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;

	my $source_port5 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port5, $protocol);
	push (@port_list,$source_port5);

	if($tcpsendsock5 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port5",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock5::TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;

	#here we have socket fds tcpsendsock1,tcpsendsock2,tcpsendsock3,tcpsendsock4,tcpsendsock5
	
	#sending message through sockets 5, 2 and 4
	if(print $tcpsendsock5 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock5:TCP socket unable to send from $tcpsendsock5. Reason: $!\n";
		$result = 0;
		close 
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}
	
	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock5>;
	&Log (*LOGFILE, $answertcpserver);

	if(print $tcpsendsock2 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock2:TCP socket unable to send from $tcpsendsock2. Reason: $!\n";	
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock2>;
	&Log (*LOGFILE, $answertcpserver);

	if(print $tcpsendsock4 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: tcpsendsock4:TCP socket unable to send from $tcpsendsock4. Reason: $!\n";	
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}
	
	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock4>;
	&Log (*LOGFILE, $answertcpserver);

	#closing 5 2 1 3
	&Log (*LOGFILE, "closing socket no 5, 2, 1 and 3");
	close ($tcpsendsock5);
	close ($tcpsendsock2);
	close ($tcpsendsock1);
	close ($tcpsendsock3);
	sleep(1);

	#opening 5 and 2
	$source_port5 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port5, $protocol);
	push (@port_list, $source_port5);

	if($tcpsendsock5 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port5",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: reopen tcpsendsock5:TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;

	$source_port2 = &SelectPortNumber;
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port2, $protocol);
	push (@port_list, $source_port2);

	if($tcpsendsock2 = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										 PeerPort => "$port2sendtcp",
										 Proto    => "$protocol",
										 LocalPort => "$source_port2",
										 ReuseAddr => 1,
										 Timeout => 10,
										))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: reopen tcpsendsock2:TCP socket could not be created by. Reason: $!\n";
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	sleep 1;

	#sending message through sockets 5, 2 and 4
	&Log (*LOGFILE, "sending message 5 2 and 4 \n");
	if(print $tcpsendsock5 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: resend tcpsendsock5:TCP socket unable to send from $tcpsendsock5. Reason: $!\n";	
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock5>;
	&Log (*LOGFILE, $answertcpserver);

	if(print $tcpsendsock2 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: resend tcpsendsock2:TCP socket unable to send from $tcpsendsock2. Reason: $!\n";	
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock2>;
	&Log (*LOGFILE, $answertcpserver);

	if(print $tcpsendsock4 $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: resend tcpsendsock4:TCP socket unable to send from $tcpsendsock5. Reason: $!\n";	
		$result = 0;
		&DeleteRouteTables(@port_list);
		return sendresult(*LOGFILE, $result);
	}

	$answertcpserver = "";
	$answertcpserver = <$tcpsendsock4>;
	&Log (*LOGFILE, $answertcpserver);

	#closing 5 4 2 
	&Log (*LOGFILE, "closing socket no 5, 4, and 2...in that order\n");
	close ($tcpsendsock5);
	close ($tcpsendsock4);
	close ($tcpsendsock2);

	sleep(1);

	&DeleteRouteTables(@port_list);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:testcase10
#Sending UDP packets to echo server in test and sleep for 10 secs n/w
sub testcase10
{
	#print "executing test case10 UDP send and sleep\n";
	$result = 0;
	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	my $protocol = "udp";
	
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase10");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	
	if($udpsendsock = new IO::Socket::INET (Proto => "$protocol",
											LocalPort => "$source_port",
											))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: UDP socket could not be created. Reason: $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}	
		
	
	$udpipaddr = inet_aton($ipaddr2sendudp);
	$udpaddr = sockaddr_in($port2sendudp, $udpipaddr);
	
	if(send($udpsendsock, $udpmessage, 0, $udpaddr) == length($udpmessage) )
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot send to $ipaddr2sendudp($port2sendudp): $!\n";
		$result = 0;
		close $udpsendsock;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}

	$MAXLEN = 100;
	if($udpserveraddr = recv($udpsendsock, $ansudpserver, $MAXLEN, 0))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot recv: $!\n";
		$result = 0;
		close $udpsendsock;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}

	($udpserverport, $udpserveripaddr) = sockaddr_in($udpserveraddr);
	&Log (*LOGFILE, $ansudpserver);
	
	&Log (*LOGFILE, "Sleeping for 10 secs\n");	
	sleep 10;
	
	if(send($udpsendsock, $udpmessage, 0, $udpaddr) == length($udpmessage) )
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot send to $ipaddr2sendudp($port2sendudp): $!\n";
		$result = 0;
		close $udpsendsock;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}

	$MAXLEN = 100;
	if($udpserveraddr = recv($udpsendsock, $ansudpserver, $MAXLEN, 0))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: Cannot recv: $!";
		$result = 0;
		close $udpsendsock;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}

	($udpserverport, $udpserveripaddr) = sockaddr_in($udpserveraddr);
	&Log(*LOGFILE, $ansudpserver);
	
	close($udpsendsock);
	sleep(1);

	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:icmp_ttl
#To test ICMP Time exceeded message type 
sub icmp_ttl
{
	$result = 0;
	my $pingaddr = undef;

	if($pingaddr_custom != undef)
	{
		$pingaddr = $pingaddr_custom;
	}
	else
	{
		$pingaddr = $pingaddr_default;
	}

	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	$protocol = "icmpttl";
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase12_icmp_ttl");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	#takes input(-E) from file input, sends one(-c) ICMP(-1) Echo Request packet 
	#with TTL(-t). sourceport(-s), destination port(-p), data size(-d) 14, -J dump data
	$icmp_Ping = "hping2 $pingaddr -1 -s $source_port -t 2 -c 1 -p $echoport -E input -d 14 -J > dump_log 2>&1";
	&Log(*LOGFILE, $icmp_Ping);
	if (system($icmp_Ping) != 0)
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: System() command failed with error $?\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return $result;
	}

	open (LOGHANDLE, "<dump_log");
	my @log = <LOGHANDLE> ;

	my @Napt_String = grep (/NAPT\s*TEST/, @log);
	if(@Napt_String == undef)
	{
		$result = 1;
	}
	else
	{
		$result = 0;
	}
	close LOGHANDLE;
	#unlink dump_log;
	&DeleteRouteTable(*LOGFILE, $source_port);
	return $result;
}

#DESCRIPTION:udp_ttl
#To test ICMP Time exceeded message type for UDP packet
sub udp_ttl
{
	$result = 0;
	my $pingaddr = undef;

	if($pingaddr_custom != undef)
	{
		$pingaddr = $pingaddr_custom;
	}
	else
	{
		$pingaddr = $pingaddr_default;
	}
	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	$protocol = "udp";
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase12_udp_ttl");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	#takes input(-E) from file input, sends one(-c) UDP(-2) packet 
	#with TTL(-t). sourceport(-s), destination port(-p), data size(-d) 14, -J dump data
	$udp_Ping = "hping2 $pingaddr -2 -s $source_port -t 1 -c 1 -p $echoport -E input -d 14 -J > dump_log 2>&1";
	&Log(*LOGFILE, $udp_Ping);
	if (system($udp_Ping) != 0)
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: System() command failed with error $?\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return $result;
	}

	open (LOGHANDLE, "<dump_log");
	my @log = <LOGHANDLE> ;

	my @Napt_String = grep (/NAPT\s*TEST/, @log);
	if(@Napt_String == undef)
	{
		$result = 1;
	}
	else
	{
		$result = 0;
	}
	close LOGHANDLE;
	unlink dump_log;
	&DeleteRouteTable(*LOGFILE, $source_port);
	return $result;
}

#DESCRIPTION:tcp_ttl
#To test TCP Time exceeded message type for TCP packet
sub tcp_ttl
{
	$result = 0;
	my $pingaddr = undef;

	if($pingaddr_custom != undef)
	{
		$pingaddr = $pingaddr_custom;
	}
	else
	{
		$pingaddr = $pingaddr_default;
	}

	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	$protocol = "tcp";
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase12_tcp_ttl");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	#takes input(-E) from file input, sends one(-c) TCP packet 
	#with TTL(-t). sourceport(-s), destination port(-p), data size(-d) 14, -J dump data
	$tcp_Ping = "hping2 $pingaddr -s $source_port -t 2 -c 1 -p $echoport --syn -E input -d 14 -J > dump_log 2>&1";
	&Log(*LOGFILE, $tcp_Ping);
	system($tcp_Ping);
	$result = 1;
	unlink dump_log;
	&DeleteRouteTable(*LOGFILE, $source_port);
	return $result;
}

#DESCRIPTION:icmp_timestamp
#To test ICMP Time stamp message
sub icmp_timestamp
{
	$result = 0;
	my $pingaddr = undef;

	if($pingaddr_custom != undef)
	{
		$pingaddr = $pingaddr_custom;
	}
	else
	{
		$pingaddr = $pingaddr_default;
	}
	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	$protocol = "icmptime";
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase12_icmp_timestamp");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	#takes input(-E) from file input, sends one(-c) TCP packet 
	#with TTL(-t). sourceport(-s)
	$icmp_time = "hping2 $pingaddr --icmp-ts -c 1 -J > /dev/null 2>&1";
	&Log(*LOGFILE, $icmp_time);
	if (system($icmp_time) != 0)
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: System() command failed with error $?\n";
		$result = 0;
	}
	else
	{
		$result = 1;
	}
	sleep(1);
	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

#DESCRIPTION:icmp_addr
#To test ICMP address mask request message
sub icmp_addr
{
	$result = 0;
	my $pingaddr = undef;

	if($pingaddr_custom != undef)
	{
		$pingaddr = $pingaddr_custom;
	}
	else
	{
		$pingaddr = $pingaddr_default;
	}
	my $gateway_addr = $_[0];
	my $source_port = &SelectPortNumber;
	$protocol = "icmpaddr";
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;
	
	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase12_icmp_addr");

	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);
	#takes input(-E) from file input, sends one(-c) TCP packet 
	#with TTL(-t). sourceport(-s), destination port(-p), data size(-d) 14, -J dump data
	$icmp_addr = "hping2 $pingaddr --icmp-addr -c 1 -J > /dev/null 2>&1";
	&Log(*LOGFILE, $icmp_addr);
	if (system($icmp_addr) != 0)
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: System() command failed with error $?\n";
		$result = 0;
	}
	else
	{
		$result = 1;
	}
	sleep(1);
	&DeleteRouteTable(*LOGFILE, $source_port);
	return $result;
}

#DESCRIPTION:Sending TCP packets to echo server in Test Network.
sub testcase13
{
	my $gateway_addr = $_[0];
	$result = "0";
	my $source_port = &SelectPortNumber;
	my $protocol = "tcp";
	my $file_name = $gateway_addr;
	$file_name =~ s/\./\_/g;

	open (LOGFILE, ">>$file_name") or die "Failed to open log file $file_name";
	&Log (*LOGFILE, "testcase1");
	&CreateRouteTable(*LOGFILE, $gateway_addr, $source_port, $protocol);

	if($tcpsendsock = new IO::Socket::INET (PeerAddr => "$ipaddr2sendtcp",
										PeerPort => "$port2sendtcp",
										Proto    => 'tcp',
										LocalPort => "$source_port",
										ReuseAddr => 1,
										Timeout => 10,
						))
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: TCP socket could not be created. Reason: $!\n";
		$result = 0;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}	
	
	if(print $tcpsendsock $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: TCP socket unable to send. Reason: $!\n";	
		$result = 0;
		close $tcpsendsock;
		sleep 1;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
	
	$answertcpserver = <$tcpsendsock>;
	sleep (10); #Sleep for 10 seconds
	&Log(*LOGFILE, "Sleeping for 10 seconds");

	if(print $tcpsendsock $tcpmessage)
	{
		$result = 1;
	}
	else
	{
		print LOGFILE __FILE__.": ".__LINE__.": ERROR: TCP socket unable to send. Reason: $!\n";	
		$result = 0;
		close $tcpsendsock;
		sleep 1;
		&DeleteRouteTable(*LOGFILE, $source_port);
		return sendresult(*LOGFILE, $result);
	}
	
	$answertcpserver = <$tcpsendsock>;	
	&Log (*LOGFILE, $answertcpserver);
	close $tcpsendsock;
	sleep 1;
	&DeleteRouteTable(*LOGFILE, $source_port);
	return sendresult(*LOGFILE, $result);
}

sub sendresult
{
	$log_file = $_[0];
	$testresult = $_[1];
	print $newlistensock $testresult;
	&Log($log_file, "INFO: Test case result:$testresult");
	close $log_file;
	return $testresult;
}

sub CheckUsage
{
	my $args = $#ARGV;

	if ($args >= 0)
	{
		foreach $args (0..$#ARGV)
		{
			switch($ARGV[$args])
			{
				case /^\s*(l|log)$/i
				{
					$enable_log = 1 ;
				}
				case /^\s*(h|help)$/i
				{
					print 
			"	NaptTestServer - Linux Based Napt Test Server
		Syntax: NaptTestServer_linux.pl <option>
		option: l or log 	- Enable logging
			h or help	- Display this message\n";
				exit(0);
				}
			}
		}
	}
}


initfunction;


