// Copyright (c) 1998-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// e32test\system\execinfo.cpp
// 
//

#include "execinfo.h"

static const SExecInfo[]=
	{
		{
		EFastExecWaitForAnyRequest,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecLanguage,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecFatUtilityFunctions,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecHeap,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecHeapSwitch,
		1,
		ANY_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecPushTrapFrame,
		1,
		ANY_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecPopTrapFrame,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecActiveScheduler,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecSetActiveScheduler,
		1,
		ANY_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecLockPeriod,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecTrapHandler,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecSetTrapHandler,
		1,
		ANY_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecKernelStartup,
		1,
		ANY_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecBlockThreads,
		1,
		ANY_INT,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecJustInTime,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecSetJustInTime,
		1,
		BOOL,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecLockedInc,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecLockedDec,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecSafeInc,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecSafeDec,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecSetDebugMask,
		1,
		ANY_INT
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecFastCounter,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecGetLocaleCharSet,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecUnlockRamDrive,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecLockRamDrive,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecRomRootDirAddress,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecRomHeaderAddress,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EFastExecDebugMask,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		}
	};


static const SExecInfo[]=
	{
		{
		EExecObjectNext,
		4,
		OBJECT_TYPE,
		WDES,
		INT_PTR,
		DES
		},
		{
		EExecChunkBase,
		1,
		CHUNK_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecChunkSize,
		1,
		CHUNK_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecChunkBottom,
		1,
		CHUNK_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecChunkTop,
		1,
		CHUNK_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecChunkMaxSize,
		1,
		CHUNK_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLogicalDeviceGetCaps,
		2,
		LDEV_HANDLE,
		WDES8,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLogicalDeviceQueryVersionSupported,
		2,
		LDEV_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLogicalDeviceIsAvailable,
		4,
		LDEV_HANDLE,
		DEV_UNIT,
		DES,
		DES8
		},
		{
		EExecChannelRequest,
		4,
		CHANNEL_HANDLE,
		ANY_INT,
		ANY_PTR,
		ANY_PTR
		},
		{
		EExecLibraryType,
		2,
		LIBRARY_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLibraryLookup,
		2,
		LIBRARY_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLibraryEntryPoint,
		1,
		LIBRARY_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLibraryDllRefTable,
		1,
		LIBRARY_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecStaticCallList,
		3,
		THREAD_HANDLE,
		INT_PTR,
		INT_PTR,
		NO_PAR
		},
		{
		EExecDynamicCallList,
		3,
		THREAD_HANDLE,
		INT_PTR,
		INT_PTR,
		NO_PAR
		},
		{
		EExecLibraryCallList,
		3,
		LIBRARY_HANDLE,
		INT_PTR,
		INT_PTR,
		NO_PAR
		},
		{
		EExecLibraryFileName,
		2,
		LIBRARY_HANDLE,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecMutexCount,
		1,
		MUTEX_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecMutexWait,
		1,
		MUTEX_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecMutexSignal,
		1,
		MUTEX_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessType,
		2,
		PROCESS_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessSetType,
		2,
		PROCESS_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessId,
		1,
		PROCESS_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessResume,
		1,
		PROCESS_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessFileName,
		2,
		PROCESS_HANDLE,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessCommandLine,
		2,
		PROCESS_HANDLE,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessCommandLineLength,
		1,
		PROCESS_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessExitType,
		1,
		PROCESS_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessExitReason,
		1,
		PROCESS_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessExitCategory,
		2,
		PROCESS_HANDLE,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessPriority,
		1,
		PROCESS_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessSetPriority,
		2,
		PROCESS_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessFlags,
		1,
		PROCESS_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessSetFlags,
		3,
		PROCESS_HANDLE,
		ANY_INT,
		ANY_INT,
		NO_PAR
		},
		{
		EExecProcessSetOwner,
		2,
		PROCESS_HANDLE,
		PROCESS_HANDLE,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSemaphoreCount,
		1,
		SEM_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSemaphoreWait,
		1,
		SEM_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSemaphoreSignal1,
		1,
		SEM_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSemaphoreSignalN,
		2,
		SEM_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecServerReceive,
		3,
		SERVER_HANDLE,
		INT_PTR,
		INT_PTR,
		NO_PAR
		},
		{
		EExecServerCancel,
		1,
		SERVER_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSetSessionPtr,
		3,
		MSG_HANDLE,
		ANY_PTR,
		BOOL,
		NO_PAR
		},
		{
		EExecSessionSend,
		4,
		SESSION_HANDLE,
		ANY_INT,
		ANY_PTR,
		INT_PTR
		},
		{
		EExecSessionSendSync,
		4,
		SESSION_HANDLE,
		ANY_INT,
		ANY_PTR,
		INT_PTR
		},
		{
		EExecThreadId,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadResume,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadSuspend,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadPriority,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadSetPriority,
		2,
		THREAD_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadProcessPriority,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadSetProcessPriority,
		2,
		THREAD_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadFlags,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadSetFlags,
		3,
		THREAD_HANDLE,
		ANY_INT,
		ANY_INT,
		NO_PAR
		},
		{
		EExecThreadRequestCount,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadExitType,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadExitReason,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadExitCategory,
		2,
		THREAD_HANDLE,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadGetDesLength,
		2,
		THREAD_HANDLE,
		ANY_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadGetDesMaxLength,
		2,
		THREAD_HANDLE,
		ANY_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadRead8,
		4,
		THREAD_HANDLE,
		ANY_PTR,
		WDES8,
		ANY_INT
		},
		{
		EExecThreadRead16,
		4,
		THREAD_HANDLE,
		ANY_PTR,
		WDES,
		ANY_INT
		},
		{
		EExecThreadWrite8,
		4,
		THREAD_HANDLE,
		ANY_PTR,
		DES8,
		ANY_INT
		},
		{
		EExecThreadWrite16,
		4,
		THREAD_HANDLE,
		ANY_PTR,
		DES,
		ANY_INT
		},
		{
		EExecThreadGetCpuTime,
		2,
		THREAD_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecTimerCancel,
		1,
		TIMER_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecTimerAfter,
		3,
		TIMER_HANDLE,
		INT_PTR,
		ANY_INT,
		NO_PAR
		},
		{
		EExecTimerHighRes,
		3,
		TIMER_HANDLE,
		INT_PTR,
		ANY_INT,
		NO_PAR
		},
		{
		EExecTimerAt,
		3,
		TIMER_HANDLE,
		INT_PTR,
		ANY_INT,
		NO_PAR
		},
		{
		EExecTimerLock,
		3,
		TIMER_HANDLE,
		INT_PTR,
		ANY_INT,
		NO_PAR
		},
		{
		EExecTimerInactivity,
		3,
		TIMER_HANDLE,
		INT_PTR,
		ANY_INT,
		NO_PAR
		},
		{
		EExecUserInactivityTime,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecResetInactivityTime,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecChangeNotifierLogon,
		2,
		CHNOT_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecChangeNotifierLogoff,
		1,
		CHNOT_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecRequestSignal,
		1,
		ANY_INT,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecMatch8,
		3,
		DES8,
		DES8,
		ANY_INT,
		NO_PAR
		},
		{
		EExecMatch16,
		3,
		DES,
		DES,
		ANY_INT,
		NO_PAR
		},
		{
		EExecHandleName,
		2,
		ANY_HANDLE,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecHandleFullName,
		2,
		ANY_HANDLE,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecHandleInfo,
		2,
		ANY_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecHandleCount,
		3,
		ANY_HANDLE,
		INT_PTR,
		INT_PTR,
		NO_PAR
		},
		{
		EExecAfter,
		2,
		ANY_INT,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecAfterHighRes,
		2,
		ANY_INT,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecAt,
		2,
		INT_PTR,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDayName,
		2,
		ANY_INT,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDayNameAbb,
		2,
		ANY_INT,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecMonthName,
		2,
		ANY_INT,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecMonthNameAbb,
		2,
		ANY_INT,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSuffix,
		2,
		ANY_INT,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecAmPmName,
		2,
		ANY_INT,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecCurrencySymbol,
		1,
		WDES,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSetCurrencySymbol,
		1,
		DES,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecShortDateFormatSpec,
		1,
		WDES,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLongDateFormatSpec,
		1,
		WDES,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecTimeFormatSpec,
		1,
		WDES,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLocale,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLocaleSet,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLocaleMessageText,
		2,
		ANY_INT,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecMessageComplete,
		2,
		MSG_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecTimeNow,
		2,
		INT_PTR,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSetHomeTime,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecTickCount,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecCaptureEventHook,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecReleaseEventHook,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecRequestEvent,
		2,
		WDES8,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecRequestEventCancel,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecAddEvent,
		1,
		DES8,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDllGlobalAllocated,
		1,
		MODULE_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDllGlobalRead,
		4,
		MODULE_HANDLE,
		ANY_INT,
		ANY_INT,
		WDES8
		},
		{
		EExecDllGlobalWrite,
		3,
		MODULE_HANDLE,
		ANY_INT,
		DES8,
		NO_PAR
		},
		{
		EExecDllTls,
		1,
		MODULE_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDllSetTls,
		2,
		MODULE_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDllFreeTls,
		1,
		MODULE_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDllDataInfo,
		2,
		MODULE_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDllFileName,
		2,
		MODULE_HANDLE,
		WDES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDllInitialiseData,
		1,
		MODULE_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDllFreeData,
		1,
		MODULE_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecHalFunction,
		4,
		ANY_INT,
		ANY_INT,
		ANY_PTR,
		ANY_PTR,
		},
		{
		EExecWsRegisterThread,
		1,
		ANY_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecFsRegisterThread,
		1,
		ANY_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDebugFunction,
		4,
		INT_PTR,
		ANY_PTR,
		ANY_PTR,
		ANY_PTR
		},
		{
		EExecBreakPoint,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProfileStart,
		1,
		ANY_INT,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProfileEnd,
		1,
		ANY_INT,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecPasswordIsEnabled,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecPasswordIsValid,
		1,
		DES,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecExceptionHandler,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSetExceptionHandler,
		3,
		THREAD_HANDLE,
		ANY_PTR,
		ANY_INT,
		NO_PAR
		},
		{
		EExecModifyExceptionMask,
		3,
		THREAD_HANDLE,
		ANY_INT,
		ANY_INT,
		NO_PAR
		},
		{
		EExecRaiseException,
		2,
		THREAD_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecIsExceptionHandled,
		2,
		THREAD_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadContext,
		2,
		THREAD_HANDLE,
		WDES8,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadGetRamSizes,
		3,
		THREAD_HANDLE,
		INT_PTR,
		INT_PTR,
		NO_PAR
		},
		{
		EExecProcessGetRamSizes,
		2,
		PROCESS_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLibraryGetRamSizes,
		3,
		LIBRARY_HANDLE,
		INT_PTR,
		INT_PTR,
		NO_PAR
		},
		{
		EExecFind8,
		4,
		DES8,
		ANY_PTR,
		ANY_INT,
		ANY_INT
		},
		{
		EExecFind16,
		4,
		DES,
		ANY_PTR,
		ANY_INT,
		ANY_INT
		},
		{
		EExecLocateF8,
		2,
		DES8,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLocateF16,
		2,
		DES,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecMachineConfiguration,
		2,
		WDES8,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSetMachineConfiguration,
		1,
		DES8,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecHandleAttributes,
		1,
		ANY_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecMathRandom,
		0,
		NO_PAR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadCreate,
		3,
		DES,
		ANY_INT,
		INT_PTR,
		NO_PAR
		},
		{
		EExecProcessCreate,
		2,
		INT_PTR,
		DES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessLoaded,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecFindHandleOpen,
		3,
		ANY_INT,
		ANY_INT,
		INT_PTR,
		NO_PAR
		},
		{
		EExecHandleClose,
		1,
		ANY_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecChunkCreate,
		4,
		ANY_INT,
		DES,
		INT_PTR,
		INT_PTR
		},
		{
		EExecChunkAdjust,
		4,
		CHUNK_HANDLE,
		ANY_INT,
		ANY_INT,
		ANY_INT
		},
		{
		EExecOpenNamedObject,
		4,
		ANY_INT,
		DES,
		INT_PTR,
		INT_PTR
		},
		{
		EExecHandleDuplicate,
		3,
		THREAD_HANDLE,
		ANY_INT,
		HANDLE_PTR,
		NO_PAR
		},
		{
		EExecMutexCreate,
		3,
		INT_PTR,
		DES,
		ANY_INT,
		NO_PAR
		},
		{
		EExecSemaphoreCreate,
		4,
		INT_PTR,
		DES,
		ANY_INT,
		ANY_INT
		},
		{
		EExecThreadOpenById,
		3,
		INT_PTR,
		ANY_INT,
		ANY_INT,
		NO_PAR
		},
		{
		EExecProcessOpenById,
		3,
		INT_PTR,
		ANY_INT,
		ANY_INT,
		NO_PAR
		},
		{
		EExecThreadKill,
		4,
		THREAD_HANDLE,
		ANY_INT,
		ANY_INT,
		DES
		},
		{
		EExecProcessKill,
		4,
		PROCESS_HANDLE,
		ANY_INT,
		ANY_INT,
		DES
		},
		{
		EExecThreadLogon,
		2,
		THREAD_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadLogonCancel,
		2,
		THREAD_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessLogon,
		2,
		PROCESS_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessLogonCancel,
		2,
		PROCESS_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadRename,
		2,
		THREAD_HANDLE,
		DES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessRename,
		2,
		PROCESS_HANDLE,
		DES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecProcessOwner,
		2,
		PROCESS_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadProcess,
		2,
		THREAD_HANDLE,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadSetInitialParameter,
		2,
		THREAD_HANDLE,
		ANY_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecThreadGetHeap,
		1,
		THREAD_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecServerCreate,
		2,
		DES,
		INT_PTR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSessionCreate,
		3,
		DES,
		ANY_INT,
		INT_PTR,
		NO_PAR
		},
		{
		EExecSessionShare,
		2,
		SESSION_HANDLE_PTR,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecSessionAttach,
		1,
		SESSION_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLibraryLoadExact,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecLibraryLoaded,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDeviceLoad,
		2,
		LIBRARY_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDeviceFree,
		2,
		DES,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecChannelCreate,
		4,
		INT_PTR,
		DES,
		INT_PTR,
		ANY_INT,
		},
		{
		EExecTimerCreate,
		1,
		INT_PTR,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecDllAddDependency,
		3,
		ANY_PTR,
		ANY_PTR,
		ANY_PTR,
		NO_PAR
		},
		{
		EExecChangeNotifierCreate,
		2,
		INT_PTR,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecUndertakerCreate,
		2,
		INT_PTR,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecUndertakerLogon,
		3,
		UND_HANDLE,
		INT_PTR,
		INT_PTR,
		NO_PAR
		},
		{
		EExecUndertakerLogonCancel,
		1,
		UND_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecKernelHeapDebug,
		4,
		ANY_INT,
		ANY_INT,
		ANY_INT,
		ANY_PTR
		},
		{
		EExecDllGlobalAlloc,
		2,
		MODULE_HANDLE,
		ANY_INT,
		NO_PAR,
		NO_PAR
		},
		{
		EExecPasswordSetEnabled,
		2,
		DES,
		BOOL,
		NO_PAR,
		NO_PAR
		},
		{
		EExecPasswordSet,
		2,
		DES,
		DES,
		NO_PAR,
		NO_PAR
		},
		{
		EExecChangeLocale,
		1,
		LIBRARY_HANDLE,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecResetMachine,
		1,
		ANY_INT,
		NO_PAR,
		NO_PAR,
		NO_PAR
		},
		{
		EExecExecuteInSupervisorMode,
		2,
		ANY_PTR,
		ANY_PTR,
		NO_PAR,
		NO_PAR
		}
	};
