/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSStyleDeclaration.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "CSSRule.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSRule.h"
#include "JSCSSValue.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSStyleDeclarationTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "cssText", JSCSSStyleDeclaration::CssTextAttrNum, DontDelete, 0, &JSCSSStyleDeclarationTableEntries[4] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "length", JSCSSStyleDeclaration::LengthAttrNum, DontDelete|ReadOnly, 0, &JSCSSStyleDeclarationTableEntries[5] },
    { "parentRule", JSCSSStyleDeclaration::ParentRuleAttrNum, DontDelete|ReadOnly, 0, &JSCSSStyleDeclarationTableEntries[6] },
    { "constructor", JSCSSStyleDeclaration::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSCSSStyleDeclarationTable = 
{
    2, 7, JSCSSStyleDeclarationTableEntries, 4
};

/* Hash table for constructor */

static const HashEntry JSCSSStyleDeclarationConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleDeclarationConstructorTable = 
{
    2, 1, JSCSSStyleDeclarationConstructorTableEntries, 1
};

class JSCSSStyleDeclarationConstructor : public DOMObject {
public:
    JSCSSStyleDeclarationConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSCSSStyleDeclarationPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSStyleDeclarationConstructor::info = { "CSSStyleDeclarationConstructor", 0, &JSCSSStyleDeclarationConstructorTable, 0 };

bool JSCSSStyleDeclarationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleDeclarationConstructor, DOMObject>(exec, &JSCSSStyleDeclarationConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSStyleDeclarationConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCSSStyleDeclarationPrototypeTableEntries[] =
{
    { "removeProperty", JSCSSStyleDeclaration::RemovePropertyFuncNum, DontDelete|Function, 1, &JSCSSStyleDeclarationPrototypeTableEntries[8] },
    { 0, 0, 0, 0, 0 },
    { "getPropertyPriority", JSCSSStyleDeclaration::GetPropertyPriorityFuncNum, DontDelete|Function, 1, 0 },
    { "getPropertyValue", JSCSSStyleDeclaration::GetPropertyValueFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { "getPropertyShorthand", JSCSSStyleDeclaration::GetPropertyShorthandFuncNum, DontDelete|Function, 1, &JSCSSStyleDeclarationPrototypeTableEntries[9] },
    { "getPropertyCSSValue", JSCSSStyleDeclaration::GetPropertyCSSValueFuncNum, DontDelete|Function, 1, 0 },
    { "item", JSCSSStyleDeclaration::ItemFuncNum, DontDelete|Function, 1, 0 },
    { "setProperty", JSCSSStyleDeclaration::SetPropertyFuncNum, DontDelete|Function, 3, 0 },
    { "isPropertyImplicit", JSCSSStyleDeclaration::IsPropertyImplicitFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSCSSStyleDeclarationPrototypeTable = 
{
    2, 10, JSCSSStyleDeclarationPrototypeTableEntries, 8
};

const ClassInfo JSCSSStyleDeclarationPrototype::info = { "CSSStyleDeclarationPrototype", 0, &JSCSSStyleDeclarationPrototypeTable, 0 };

JSObject* JSCSSStyleDeclarationPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSStyleDeclarationPrototype>(exec, "[[JSCSSStyleDeclaration.prototype]]");
}

bool JSCSSStyleDeclarationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSCSSStyleDeclarationPrototypeFunction, JSObject>(exec, &JSCSSStyleDeclarationPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSStyleDeclaration::info = { "CSSStyleDeclaration", 0, &JSCSSStyleDeclarationTable, 0 };

JSCSSStyleDeclaration::JSCSSStyleDeclaration(ExecState* exec, CSSStyleDeclaration* impl)
    : m_impl(impl)
{
    setPrototype(JSCSSStyleDeclarationPrototype::self(exec));
}

JSCSSStyleDeclaration::~JSCSSStyleDeclaration()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSCSSStyleDeclaration::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSCSSStyleDeclarationTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSCSSStyleDeclaration>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CSSStyleDeclaration*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<CSSStyleDeclaration*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return KJS::DOMObject::getOwnPropertySlot(exec, propertyName, slot);
}

JSValue* JSCSSStyleDeclaration::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CssTextAttrNum: {
        CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(impl());

        return jsStringOrNull(imp->cssText());
    }
    case LengthAttrNum: {
        CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(impl());

        return jsNumber(imp->length());
    }
    case ParentRuleAttrNum: {
        CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(impl());

        return toJS(exec, WTF::getPtr(imp->parentRule()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSCSSStyleDeclaration::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    if (customPut(exec, propertyName, value, attr))
        return;
    lookupPut<JSCSSStyleDeclaration, KJS::DOMObject>(exec, propertyName, value, attr, &JSCSSStyleDeclarationTable, this);
}

void JSCSSStyleDeclaration::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case CssTextAttrNum: {
        CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(impl());

        ExceptionCode ec = 0;
        imp->setCssText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

JSValue* JSCSSStyleDeclaration::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSStyleDeclarationConstructor>(exec, "[[CSSStyleDeclaration.constructor]]");
}
JSValue* JSCSSStyleDeclarationPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSCSSStyleDeclaration::info))
      return throwError(exec, TypeError);

    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(static_cast<JSCSSStyleDeclaration*>(thisObj)->impl());

    switch (id) {
    case JSCSSStyleDeclaration::GetPropertyValueFuncNum: {
        String propertyName = args[0]->toString(exec);


        KJS::JSValue* result = jsStringOrNull(imp->getPropertyValue(propertyName));
        return result;
    }
    case JSCSSStyleDeclaration::GetPropertyCSSValueFuncNum: {
        String propertyName = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getPropertyCSSValue(propertyName)));
        return result;
    }
    case JSCSSStyleDeclaration::RemovePropertyFuncNum: {
        ExceptionCode ec = 0;
        String propertyName = args[0]->toString(exec);


        KJS::JSValue* result = jsStringOrNull(imp->removeProperty(propertyName, ec));
        setDOMException(exec, ec);
        return result;
    }
    case JSCSSStyleDeclaration::GetPropertyPriorityFuncNum: {
        String propertyName = args[0]->toString(exec);


        KJS::JSValue* result = jsStringOrNull(imp->getPropertyPriority(propertyName));
        return result;
    }
    case JSCSSStyleDeclaration::SetPropertyFuncNum: {
        ExceptionCode ec = 0;
        String propertyName = args[0]->toString(exec);
        String value = valueToStringWithNullCheck(exec, args[1]);
        String priority = args[2]->toString(exec);

        imp->setProperty(propertyName, value, priority, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSCSSStyleDeclaration::ItemFuncNum: {
        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = jsStringOrNull(imp->item(index));
        return result;
    }
    case JSCSSStyleDeclaration::GetPropertyShorthandFuncNum: {
        String propertyName = args[0]->toString(exec);


        KJS::JSValue* result = jsStringOrNull(imp->getPropertyShorthand(propertyName));
        return result;
    }
    case JSCSSStyleDeclaration::IsPropertyImplicitFuncNum: {
        String propertyName = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->isPropertyImplicit(propertyName));
        return result;
    }
    }
    return 0;
}

JSValue* JSCSSStyleDeclaration::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSCSSStyleDeclaration* thisObj = static_cast<JSCSSStyleDeclaration*>(slot.slotBase());
    return jsStringOrNull(thisObj->impl()->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, CSSStyleDeclaration* obj)
{
    return KJS::cacheDOMObject<CSSStyleDeclaration, JSCSSStyleDeclaration>(exec, obj);
}
CSSStyleDeclaration* toCSSStyleDeclaration(KJS::JSValue* val)
{
    return val->isObject(&JSCSSStyleDeclaration::info) ? static_cast<JSCSSStyleDeclaration*>(val)->impl() : 0;
}

}
