/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLFieldSetElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFieldSetElement.h"
#include "HTMLFormElement.h"
#include "JSHTMLFormElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLFieldSetElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "form", JSHTMLFieldSetElement::FormAttrNum, DontDelete|ReadOnly, 0, &JSHTMLFieldSetElementTableEntries[2] },
    { "constructor", JSHTMLFieldSetElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLFieldSetElementTable = 
{
    2, 3, JSHTMLFieldSetElementTableEntries, 2
};

/* Hash table for constructor */

static const HashEntry JSHTMLFieldSetElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLFieldSetElementConstructorTable = 
{
    2, 1, JSHTMLFieldSetElementConstructorTableEntries, 1
};

class JSHTMLFieldSetElementConstructor : public DOMObject {
public:
    JSHTMLFieldSetElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLFieldSetElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLFieldSetElementConstructor::info = { "HTMLFieldSetElementConstructor", 0, &JSHTMLFieldSetElementConstructorTable, 0 };

bool JSHTMLFieldSetElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFieldSetElementConstructor, DOMObject>(exec, &JSHTMLFieldSetElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLFieldSetElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLFieldSetElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLFieldSetElementPrototypeTable = 
{
    2, 1, JSHTMLFieldSetElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLFieldSetElementPrototype::info = { "HTMLFieldSetElementPrototype", 0, &JSHTMLFieldSetElementPrototypeTable, 0 };

JSObject* JSHTMLFieldSetElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLFieldSetElementPrototype>(exec, "[[JSHTMLFieldSetElement.prototype]]");
}

const ClassInfo JSHTMLFieldSetElement::info = { "HTMLFieldSetElement", &JSHTMLElement::info, &JSHTMLFieldSetElementTable, 0 };

JSHTMLFieldSetElement::JSHTMLFieldSetElement(ExecState* exec, HTMLFieldSetElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLFieldSetElementPrototype::self(exec));
}

bool JSHTMLFieldSetElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFieldSetElement, JSHTMLElement>(exec, &JSHTMLFieldSetElementTable, this, propertyName, slot);
}

JSValue* JSHTMLFieldSetElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLFieldSetElement* imp = static_cast<HTMLFieldSetElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSHTMLFieldSetElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLFieldSetElementConstructor>(exec, "[[HTMLFieldSetElement.constructor]]");
}

}
