/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSStyleSheet.h"

#include <wtf/GetPtr.h>

#include "JSMediaList.h"
#include "JSNode.h"
#include "JSStyleSheet.h"
#include "MediaList.h"
#include "Node.h"
#include "PlatformString.h"
#include "StyleSheet.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSStyleSheetTableEntries[] =
{
    { "href", JSStyleSheet::HrefAttrNum, DontDelete|ReadOnly, 0, &JSStyleSheetTableEntries[8] },
    { "disabled", JSStyleSheet::DisabledAttrNum, DontDelete, 0, &JSStyleSheetTableEntries[9] },
    { "parentStyleSheet", JSStyleSheet::ParentStyleSheetAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "type", JSStyleSheet::TypeAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "ownerNode", JSStyleSheet::OwnerNodeAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "media", JSStyleSheet::MediaAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "title", JSStyleSheet::TitleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "constructor", JSStyleSheet::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSStyleSheetTable = 
{
    2, 10, JSStyleSheetTableEntries, 8
};

/* Hash table for constructor */

static const HashEntry JSStyleSheetConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSStyleSheetConstructorTable = 
{
    2, 1, JSStyleSheetConstructorTableEntries, 1
};

class JSStyleSheetConstructor : public DOMObject {
public:
    JSStyleSheetConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSStyleSheetPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSStyleSheetConstructor::info = { "StyleSheetConstructor", 0, &JSStyleSheetConstructorTable, 0 };

bool JSStyleSheetConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStyleSheetConstructor, DOMObject>(exec, &JSStyleSheetConstructorTable, this, propertyName, slot);
}

JSValue* JSStyleSheetConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSStyleSheetPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSStyleSheetPrototypeTable = 
{
    2, 1, JSStyleSheetPrototypeTableEntries, 1
};

const ClassInfo JSStyleSheetPrototype::info = { "StyleSheetPrototype", 0, &JSStyleSheetPrototypeTable, 0 };

JSObject* JSStyleSheetPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSStyleSheetPrototype>(exec, "[[JSStyleSheet.prototype]]");
}

const ClassInfo JSStyleSheet::info = { "StyleSheet", 0, &JSStyleSheetTable, 0 };

JSStyleSheet::JSStyleSheet(ExecState* exec, StyleSheet* impl)
    : m_impl(impl)
{
    setPrototype(JSStyleSheetPrototype::self(exec));
}

JSStyleSheet::~JSStyleSheet()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSStyleSheet::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStyleSheet, KJS::DOMObject>(exec, &JSStyleSheetTable, this, propertyName, slot);
}

JSValue* JSStyleSheet::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TypeAttrNum: {
        StyleSheet* imp = static_cast<StyleSheet*>(impl());

        return jsStringOrNull(imp->type());
    }
    case DisabledAttrNum: {
        StyleSheet* imp = static_cast<StyleSheet*>(impl());

        return jsBoolean(imp->disabled());
    }
    case OwnerNodeAttrNum: {
        StyleSheet* imp = static_cast<StyleSheet*>(impl());

        return toJS(exec, WTF::getPtr(imp->ownerNode()));
    }
    case ParentStyleSheetAttrNum: {
        StyleSheet* imp = static_cast<StyleSheet*>(impl());

        return toJS(exec, WTF::getPtr(imp->parentStyleSheet()));
    }
    case HrefAttrNum: {
        StyleSheet* imp = static_cast<StyleSheet*>(impl());

        return jsStringOrNull(imp->href());
    }
    case TitleAttrNum: {
        StyleSheet* imp = static_cast<StyleSheet*>(impl());

        return jsStringOrNull(imp->title());
    }
    case MediaAttrNum: {
        StyleSheet* imp = static_cast<StyleSheet*>(impl());

        return toJS(exec, WTF::getPtr(imp->media()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSStyleSheet::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSStyleSheet, KJS::DOMObject>(exec, propertyName, value, attr, &JSStyleSheetTable, this);
}

void JSStyleSheet::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case DisabledAttrNum: {
        StyleSheet* imp = static_cast<StyleSheet*>(impl());

        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    }
}

JSValue* JSStyleSheet::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSStyleSheetConstructor>(exec, "[[StyleSheet.constructor]]");
}
StyleSheet* toStyleSheet(KJS::JSValue* val)
{
    return val->isObject(&JSStyleSheet::info) ? static_cast<JSStyleSheet*>(val)->impl() : 0;
}

}
