/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLBodyElement.h"

#include <wtf/GetPtr.h>

#include "HTMLBodyElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLBodyElementTableEntries[] =
{
    { "aLink", JSHTMLBodyElement::ALinkAttrNum, DontDelete, 0, &JSHTMLBodyElementTableEntries[11] },
    { "text", JSHTMLBodyElement::TextAttrNum, DontDelete, 0, &JSHTMLBodyElementTableEntries[12] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "link", JSHTMLBodyElement::LinkAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "background", JSHTMLBodyElement::BackgroundAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "vLink", JSHTMLBodyElement::VLinkAttrNum, DontDelete, 0, 0 },
    { "scrollLeft", JSHTMLBodyElement::ScrollLeftAttrNum, DontDelete, 0, &JSHTMLBodyElementTableEntries[13] },
    { "bgColor", JSHTMLBodyElement::BgColorAttrNum, DontDelete, 0, &JSHTMLBodyElementTableEntries[14] },
    { "scrollTop", JSHTMLBodyElement::ScrollTopAttrNum, DontDelete, 0, &JSHTMLBodyElementTableEntries[15] },
    { "scrollWidth", JSHTMLBodyElement::ScrollWidthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "scrollHeight", JSHTMLBodyElement::ScrollHeightAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "constructor", JSHTMLBodyElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLBodyElementTable = 
{
    2, 16, JSHTMLBodyElementTableEntries, 11
};

/* Hash table for constructor */

static const HashEntry JSHTMLBodyElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLBodyElementConstructorTable = 
{
    2, 1, JSHTMLBodyElementConstructorTableEntries, 1
};

class JSHTMLBodyElementConstructor : public DOMObject {
public:
    JSHTMLBodyElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLBodyElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLBodyElementConstructor::info = { "HTMLBodyElementConstructor", 0, &JSHTMLBodyElementConstructorTable, 0 };

bool JSHTMLBodyElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBodyElementConstructor, DOMObject>(exec, &JSHTMLBodyElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLBodyElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLBodyElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLBodyElementPrototypeTable = 
{
    2, 1, JSHTMLBodyElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLBodyElementPrototype::info = { "HTMLBodyElementPrototype", 0, &JSHTMLBodyElementPrototypeTable, 0 };

JSObject* JSHTMLBodyElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBodyElementPrototype>(exec, "[[JSHTMLBodyElement.prototype]]");
}

const ClassInfo JSHTMLBodyElement::info = { "HTMLBodyElement", &JSHTMLElement::info, &JSHTMLBodyElementTable, 0 };

JSHTMLBodyElement::JSHTMLBodyElement(ExecState* exec, HTMLBodyElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLBodyElementPrototype::self(exec));
}

bool JSHTMLBodyElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBodyElement, JSHTMLElement>(exec, &JSHTMLBodyElementTable, this, propertyName, slot);
}

JSValue* JSHTMLBodyElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ALinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsString(imp->aLink());
    }
    case BackgroundAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsString(imp->background());
    }
    case BgColorAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsString(imp->bgColor());
    }
    case LinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsString(imp->link());
    }
    case TextAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsString(imp->text());
    }
    case VLinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsString(imp->vLink());
    }
    case ScrollLeftAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsNumber(imp->scrollLeft());
    }
    case ScrollTopAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsNumber(imp->scrollTop());
    }
    case ScrollWidthAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsNumber(imp->scrollWidth());
    }
    case ScrollHeightAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        return jsNumber(imp->scrollHeight());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLBodyElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLBodyElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLBodyElementTable, this);
}

void JSHTMLBodyElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case ALinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        imp->setALink(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BackgroundAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        imp->setBackground(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BgColorAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        imp->setBgColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case LinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        imp->setLink(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TextAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        imp->setText(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VLinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        imp->setVLink(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ScrollLeftAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        imp->setScrollLeft(value->toInt32(exec));
        break;
    }
    case ScrollTopAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());

        imp->setScrollTop(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSHTMLBodyElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBodyElementConstructor>(exec, "[[HTMLBodyElement.constructor]]");
}

}
