/*
* Copyright (c) 2000 - 2001 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


/** ----------------------------------------------------------------------- **
    @package:     NW_WBXML

    @synopsis:    default

    @description: Definitions for WBXML low-level event handling.

 ** ----------------------------------------------------------------------- **/

#ifndef NW_PARSER_WBXML_EVENT_H
#define NW_PARSER_WBXML_EVENT_H

#include "nw_wbxml_document.h"
#include "cxml_proj.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct NW_WBXML_Parser_s NW_WBXML_Parser_t;


/** ----------------------------------------------------------------------- **
    @typedef:     NW_WBXML_Exception

    @synopsis:    Exception identifier.

    @scope:       public
    @type:        NW_Int32

    @description: Exception identifier.
 ** ----------------------------------------------------------------------- **/
typedef NW_Int32 NW_WBXML_Exception_t;

/* No RME doc support for function calls as variables */

struct NW_WBXML_EventHandler_s {

  /* State change events */

  NW_Status_t (*StartDocument_CB) (NW_WBXML_Parser_t *, 
                                   NW_WBXML_Document_t *, 
                                   void *);
  
  NW_Status_t (*EndDocument_CB) (NW_WBXML_Parser_t *, 
                                 void *);

  NW_Status_t (*Pi_CB) (NW_WBXML_Parser_t *, 
                        void *);

  NW_Status_t (*Pi_End_CB) (NW_WBXML_Parser_t *, 
                            void *);

  NW_Status_t (*Tag_Start_CB) (NW_WBXML_Parser_t *, 
                               void *);

  NW_Status_t (*Tag_End_CB) (NW_WBXML_Parser_t *, 
                             void *);

  NW_Status_t (*Attr_Start_CB) (NW_WBXML_Parser_t *, 
                                void *);

  NW_Status_t (*Attr_Val_CB) (NW_WBXML_Parser_t *, 
                              void *);

  NW_Status_t (*Content_CB) (NW_WBXML_Parser_t *, 
                             void *);

  NW_Status_t (*CodePage_CB) (NW_WBXML_Parser_t *, 
                              void *);

  NW_Status_t (*Extension_CB) (NW_WBXML_Parser_t *, 
                               void *);

  /* Handle data types */
  
  NW_Status_t (*Token_CB) (NW_WBXML_Parser_t *, 
                           NW_Uint8, 
                           void *);

  NW_Status_t (*FQToken_CB)(NW_WBXML_Parser_t *, 
                            NW_Uint32, 
                            void *);

  NW_Status_t (*InlineString_CB) (NW_WBXML_Parser_t *, 
                                  NW_Uint32, 
                                  void *);

  NW_Status_t (*TableString_CB) (NW_WBXML_Parser_t *, 
                                 NW_Uint32, 
                                 void *);

  NW_Status_t (*Binary_CB) (NW_WBXML_Parser_t *, 
                            NW_Uint32, 
                            void *);

  NW_Status_t (*Opaque_CB) (NW_WBXML_Parser_t *, 
                            NW_Uint32, 
                            void *);

  NW_Status_t (*Entity_CB) (NW_WBXML_Parser_t *, 
                            NW_Uint32, 
                            void *);
  
  /* For parse errors */
  
  NW_Status_t (*Exception_CB) (NW_WBXML_Parser_t *, 
                               NW_WBXML_Exception_t, 
                               void *);
};


/** ----------------------------------------------------------------------- **
    @typedef:     NW_WBXML_EventHandler

    @synopsis:    Parsing event handler structure.

    @scope:       public
    @type:        NW_WBXML_EventHandler_s

    @description: Parsing events are generated as the parser parses a
                  document. The interface is currently implemented by
                  the WBXML parser, but the XML parser will use the same
                  event interface, although not all of the events will
                  be generated by both parsers. To create an event
                  handler, an application implements a set of event
                  handler functions and creates an
                  NMXB_Parse_EventHandler_t structure that contains the
                  addresses of these functions. Not all of the events
                  need to be handled; an application need only provide
                  handlers for those events it is interested in
                  Addresses of the other handlers should be set to
                  NULL.                  
                  This data type contains addresses of the parser
                  callback functions. To use the parser event interface,
                  the caller must implement a set of handlers and
                  initialize a NMXB_Parser_EventHandler_t to point to
                  them. Addresses must be set to NULL for any handlers
                  not implemented. The caller then registers the handler
                  with the parser by calling the appropriate handler
                  registration function.  The callbacks are divided
                  between "state" callbacks and "data" callbacks. The
                  state callbacks indicate the current parser state:
                  that is, what type of element it is currently
                  parsing. The data callbacks indicate a specific data
                  type for the currently parsed element.

 ** ----------------------------------------------------------------------- **/
typedef struct NW_WBXML_EventHandler_s NW_WBXML_EventHandler_t;
  

#ifdef __cplusplus
} /* extern "C" { */
#endif /* __cplusplus */

#endif  /* NW_PARSER_WBXML_EVENT_H */
