/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLOptionElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFormElement.h"
#include "HTMLOptionElement.h"
#include "JSHTMLFormElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLOptionElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "disabled", JSHTMLOptionElement::DisabledAttrNum, DontDelete, 0, &JSHTMLOptionElementTableEntries[9] },
    { "index", JSHTMLOptionElement::IndexAttrNum, DontDelete, 0, 0 },
    { "value", JSHTMLOptionElement::ValueAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "form", JSHTMLOptionElement::FormAttrNum, DontDelete|ReadOnly, 0, &JSHTMLOptionElementTableEntries[8] },
    { "text", JSHTMLOptionElement::TextAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "defaultSelected", JSHTMLOptionElement::DefaultSelectedAttrNum, DontDelete, 0, 0 },
    { "label", JSHTMLOptionElement::LabelAttrNum, DontDelete, 0, &JSHTMLOptionElementTableEntries[10] },
    { "selected", JSHTMLOptionElement::SelectedAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSHTMLOptionElementTable = 
{
    2, 11, JSHTMLOptionElementTableEntries, 8
};

/* Hash table for prototype */

static const HashEntry JSHTMLOptionElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionElementPrototypeTable = 
{
    2, 1, JSHTMLOptionElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLOptionElementPrototype::info = { "HTMLOptionElementPrototype", 0, &JSHTMLOptionElementPrototypeTable, 0 };

JSObject* JSHTMLOptionElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLOptionElementPrototype>(exec, "[[JSHTMLOptionElement.prototype]]");
}

const ClassInfo JSHTMLOptionElement::info = { "HTMLOptionElement", &JSHTMLElement::info, &JSHTMLOptionElementTable, 0 };

JSHTMLOptionElement::JSHTMLOptionElement(ExecState* exec, HTMLOptionElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLOptionElementPrototype::self(exec));
}

bool JSHTMLOptionElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptionElement, JSHTMLElement>(exec, &JSHTMLOptionElementTable, this, propertyName, slot);
}

JSValue* JSHTMLOptionElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case DefaultSelectedAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        return jsBoolean(imp->defaultSelected());
    }
    case TextAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        return jsString(imp->text());
    }
    case IndexAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        return jsNumber(imp->index());
    }
    case DisabledAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        return jsBoolean(imp->disabled());
    }
    case LabelAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        return jsString(imp->label());
    }
    case SelectedAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        return jsBoolean(imp->selected());
    }
    case ValueAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        return jsString(imp->value());
    }
    }
    return 0;
}

void JSHTMLOptionElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLOptionElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLOptionElementTable, this);
}

void JSHTMLOptionElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case DefaultSelectedAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        imp->setDefaultSelected(value->toBoolean(exec));
        break;
    }
    case TextAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        ExceptionCode ec = 0;
        imp->setText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    case IndexAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        ExceptionCode ec = 0;
        imp->setIndex(value->toInt32(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case DisabledAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case LabelAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        imp->setLabel(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SelectedAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        imp->setSelected(value->toBoolean(exec));
        break;
    }
    case ValueAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());

        imp->setValue(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

HTMLOptionElement* toHTMLOptionElement(KJS::JSValue* val)
{
    return val->isObject(&JSHTMLOptionElement::info) ? static_cast<JSHTMLOptionElement*>(val)->impl() : 0;
}

HTMLOptionElement* JSHTMLOptionElement::impl() const
{
    return static_cast<HTMLOptionElement*>(JSHTMLElement::impl());
}

}
