/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNodeIterator.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include "NodeIterator.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSNodeIteratorTableEntries[] =
{
    { "root", JSNodeIterator::RootAttrNum, DontDelete|ReadOnly, 0, &JSNodeIteratorTableEntries[7] },
    { 0, 0, 0, 0, 0 },
    { "whatToShow", JSNodeIterator::WhatToShowAttrNum, DontDelete|ReadOnly, 0, &JSNodeIteratorTableEntries[6] },
    { "referenceNode", JSNodeIterator::ReferenceNodeAttrNum, DontDelete|ReadOnly, 0, &JSNodeIteratorTableEntries[8] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "filter", JSNodeIterator::FilterAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "expandEntityReferences", JSNodeIterator::ExpandEntityReferencesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "pointerBeforeReferenceNode", JSNodeIterator::PointerBeforeReferenceNodeAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSNodeIteratorTable = 
{
    2, 9, JSNodeIteratorTableEntries, 6
};

/* Hash table for prototype */

static const HashEntry JSNodeIteratorPrototypeTableEntries[] =
{
    { "nextNode", JSNodeIterator::NextNodeFuncNum, DontDelete|Function, 0, &JSNodeIteratorPrototypeTableEntries[3] },
    { 0, 0, 0, 0, 0 },
    { "previousNode", JSNodeIterator::PreviousNodeFuncNum, DontDelete|Function, 0, 0 },
    { "detach", JSNodeIterator::DetachFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSNodeIteratorPrototypeTable = 
{
    2, 4, JSNodeIteratorPrototypeTableEntries, 3
};

const ClassInfo JSNodeIteratorPrototype::info = { "NodeIteratorPrototype", 0, &JSNodeIteratorPrototypeTable, 0 };

JSObject* JSNodeIteratorPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNodeIteratorPrototype>(exec, "[[JSNodeIterator.prototype]]");
}

bool JSNodeIteratorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSNodeIteratorPrototypeFunction, JSObject>(exec, &JSNodeIteratorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNodeIterator::info = { "NodeIterator", 0, &JSNodeIteratorTable, 0 };

JSNodeIterator::JSNodeIterator(ExecState* exec, NodeIterator* impl)
    : m_impl(impl)
{
    setPrototype(JSNodeIteratorPrototype::self(exec));
}

JSNodeIterator::~JSNodeIterator()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSNodeIterator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeIterator, KJS::DOMObject>(exec, &JSNodeIteratorTable, this, propertyName, slot);
}

JSValue* JSNodeIterator::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case RootAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());

        return toJS(exec, WTF::getPtr(imp->root()));
    }
    case WhatToShowAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());

        return jsNumber(imp->whatToShow());
    }
    case FilterAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());

        return toJS(exec, WTF::getPtr(imp->filter()));
    }
    case ExpandEntityReferencesAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());

        return jsBoolean(imp->expandEntityReferences());
    }
    case ReferenceNodeAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());

        return toJS(exec, WTF::getPtr(imp->referenceNode()));
    }
    case PointerBeforeReferenceNodeAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());

        return jsBoolean(imp->pointerBeforeReferenceNode());
    }
    }
    return 0;
}

JSValue* JSNodeIteratorPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNodeIterator::info))
      return throwError(exec, TypeError);

    NodeIterator* imp = static_cast<NodeIterator*>(static_cast<JSNodeIterator*>(thisObj)->impl());

    switch (id) {
    case JSNodeIterator::NextNodeFuncNum: {
        ExceptionCode ec = 0;


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->nextNode(ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSNodeIterator::PreviousNodeFuncNum: {
        ExceptionCode ec = 0;


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->previousNode(ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSNodeIterator::DetachFuncNum: {

        imp->detach();
        return jsUndefined();
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, NodeIterator* obj)
{
    return KJS::cacheDOMObject<NodeIterator, JSNodeIterator>(exec, obj);
}
NodeIterator* toNodeIterator(KJS::JSValue* val)
{
    return val->isObject(&JSNodeIterator::info) ? static_cast<JSNodeIterator*>(val)->impl() : 0;
}

}
