/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLBlockquoteElement.h"

#include <wtf/GetPtr.h>

#include "HTMLBlockquoteElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLBlockquoteElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "cite", JSHTMLBlockquoteElement::CiteAttrNum, DontDelete, 0, &JSHTMLBlockquoteElementTableEntries[2] },
    { "constructor", JSHTMLBlockquoteElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLBlockquoteElementTable = 
{
    2, 3, JSHTMLBlockquoteElementTableEntries, 2
};

/* Hash table for constructor */

static const HashEntry JSHTMLBlockquoteElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLBlockquoteElementConstructorTable = 
{
    2, 1, JSHTMLBlockquoteElementConstructorTableEntries, 1
};

class JSHTMLBlockquoteElementConstructor : public DOMObject {
public:
    JSHTMLBlockquoteElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLBlockquoteElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLBlockquoteElementConstructor::info = { "HTMLBlockquoteElementConstructor", 0, &JSHTMLBlockquoteElementConstructorTable, 0 };

bool JSHTMLBlockquoteElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBlockquoteElementConstructor, DOMObject>(exec, &JSHTMLBlockquoteElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLBlockquoteElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLBlockquoteElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLBlockquoteElementPrototypeTable = 
{
    2, 1, JSHTMLBlockquoteElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLBlockquoteElementPrototype::info = { "HTMLBlockquoteElementPrototype", 0, &JSHTMLBlockquoteElementPrototypeTable, 0 };

JSObject* JSHTMLBlockquoteElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBlockquoteElementPrototype>(exec, "[[JSHTMLBlockquoteElement.prototype]]");
}

const ClassInfo JSHTMLBlockquoteElement::info = { "HTMLBlockquoteElement", &JSHTMLElement::info, &JSHTMLBlockquoteElementTable, 0 };

JSHTMLBlockquoteElement::JSHTMLBlockquoteElement(ExecState* exec, HTMLBlockquoteElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLBlockquoteElementPrototype::self(exec));
}

bool JSHTMLBlockquoteElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBlockquoteElement, JSHTMLElement>(exec, &JSHTMLBlockquoteElementTable, this, propertyName, slot);
}

JSValue* JSHTMLBlockquoteElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CiteAttrNum: {
        HTMLBlockquoteElement* imp = static_cast<HTMLBlockquoteElement*>(impl());

        return jsString(imp->cite());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLBlockquoteElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLBlockquoteElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLBlockquoteElementTable, this);
}

void JSHTMLBlockquoteElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case CiteAttrNum: {
        HTMLBlockquoteElement* imp = static_cast<HTMLBlockquoteElement*>(impl());

        imp->setCite(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLBlockquoteElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLBlockquoteElementConstructor>(exec, "[[HTMLBlockquoteElement.constructor]]");
}

}
