/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLCanvasElement.h"

#include <wtf/GetPtr.h>

#include "HTMLCanvasElement.h"
#include "JSCanvasRenderingContext2D.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLCanvasElementTableEntries[] =
{
    { "constructor", JSHTMLCanvasElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 },
    { "width", JSHTMLCanvasElement::WidthAttrNum, DontDelete, 0, 0 },
    { "height", JSHTMLCanvasElement::HeightAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSHTMLCanvasElementTable = 
{
    2, 3, JSHTMLCanvasElementTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSHTMLCanvasElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLCanvasElementConstructorTable = 
{
    2, 1, JSHTMLCanvasElementConstructorTableEntries, 1
};

class JSHTMLCanvasElementConstructor : public DOMObject {
public:
    JSHTMLCanvasElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLCanvasElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLCanvasElementConstructor::info = { "HTMLCanvasElementConstructor", 0, &JSHTMLCanvasElementConstructorTable, 0 };

bool JSHTMLCanvasElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCanvasElementConstructor, DOMObject>(exec, &JSHTMLCanvasElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLCanvasElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLCanvasElementPrototypeTableEntries[] =
{
    { "getContext", JSHTMLCanvasElement::GetContextFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSHTMLCanvasElementPrototypeTable = 
{
    2, 1, JSHTMLCanvasElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLCanvasElementPrototype::info = { "HTMLCanvasElementPrototype", 0, &JSHTMLCanvasElementPrototypeTable, 0 };

JSObject* JSHTMLCanvasElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLCanvasElementPrototype>(exec, "[[JSHTMLCanvasElement.prototype]]");
}

bool JSHTMLCanvasElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSHTMLCanvasElementPrototypeFunction, JSObject>(exec, &JSHTMLCanvasElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLCanvasElement::info = { "HTMLCanvasElement", &JSHTMLElement::info, &JSHTMLCanvasElementTable, 0 };

JSHTMLCanvasElement::JSHTMLCanvasElement(ExecState* exec, HTMLCanvasElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLCanvasElementPrototype::self(exec));
}

bool JSHTMLCanvasElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCanvasElement, JSHTMLElement>(exec, &JSHTMLCanvasElementTable, this, propertyName, slot);
}

JSValue* JSHTMLCanvasElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case WidthAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());

        return jsNumber(imp->width());
    }
    case HeightAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());

        return jsNumber(imp->height());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLCanvasElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLCanvasElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLCanvasElementTable, this);
}

void JSHTMLCanvasElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case WidthAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());

        imp->setWidth(value->toInt32(exec));
        break;
    }
    case HeightAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());

        imp->setHeight(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSHTMLCanvasElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLCanvasElementConstructor>(exec, "[[HTMLCanvasElement.constructor]]");
}
JSValue* JSHTMLCanvasElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLCanvasElement::info))
      return throwError(exec, TypeError);

    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(static_cast<JSHTMLCanvasElement*>(thisObj)->impl());

    switch (id) {
    case JSHTMLCanvasElement::GetContextFuncNum: {
        String contextId = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getContext(contextId)));
        return result;
    }
    }
    return 0;
}

}
