/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMSelection.h"

#include <wtf/GetPtr.h>

#include "DOMSelection.h"
#include "ExceptionCode.h"
#include "JSNode.h"
#include "JSRange.h"
#include "Node.h"
#include "PlatformString.h"
#include "Range.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDOMSelectionTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "anchorOffset", JSDOMSelection::AnchorOffsetAttrNum, DontDelete|ReadOnly, 0, &JSDOMSelectionTableEntries[11] },
    { "baseOffset", JSDOMSelection::BaseOffsetAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "extentOffset", JSDOMSelection::ExtentOffsetAttrNum, DontDelete|ReadOnly, 0, &JSDOMSelectionTableEntries[14] },
    { "focusNode", JSDOMSelection::FocusNodeAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "anchorNode", JSDOMSelection::AnchorNodeAttrNum, DontDelete|ReadOnly, 0, &JSDOMSelectionTableEntries[12] },
    { "focusOffset", JSDOMSelection::FocusOffsetAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "baseNode", JSDOMSelection::BaseNodeAttrNum, DontDelete|ReadOnly, 0, &JSDOMSelectionTableEntries[13] },
    { "extentNode", JSDOMSelection::ExtentNodeAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "isCollapsed", JSDOMSelection::IsCollapsedAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "type", JSDOMSelection::TypeAttrNum, DontDelete|ReadOnly, 0, &JSDOMSelectionTableEntries[15] },
    { "rangeCount", JSDOMSelection::RangeCountAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSDOMSelectionTable = 
{
    2, 16, JSDOMSelectionTableEntries, 11
};

/* Hash table for prototype */

static const HashEntry JSDOMSelectionPrototypeTableEntries[] =
{
    { "toString", JSDOMSelection::ToStringFuncNum, DontDelete|DontEnum|Function, 0, 0 },
    { "modify", JSDOMSelection::ModifyFuncNum, DontDelete|Function, 3, 0 },
    { "collapse", JSDOMSelection::CollapseFuncNum, DontDelete|Function, 2, &JSDOMSelectionPrototypeTableEntries[11] },
    { 0, 0, 0, 0, 0 },
    { "removeAllRanges", JSDOMSelection::RemoveAllRangesFuncNum, DontDelete|Function, 0, 0 },
    { "addRange", JSDOMSelection::AddRangeFuncNum, DontDelete|Function, 1, 0 },
    { "setBaseAndExtent", JSDOMSelection::SetBaseAndExtentFuncNum, DontDelete|Function, 4, 0 },
    { "empty", JSDOMSelection::EmptyFuncNum, DontDelete|Function, 0, &JSDOMSelectionPrototypeTableEntries[12] },
    { "setPosition", JSDOMSelection::SetPositionFuncNum, DontDelete|Function, 2, 0 },
    { 0, 0, 0, 0, 0 },
    { "collapseToEnd", JSDOMSelection::CollapseToEndFuncNum, DontDelete|Function, 0, 0 },
    { "collapseToStart", JSDOMSelection::CollapseToStartFuncNum, DontDelete|Function, 0, 0 },
    { "getRangeAt", JSDOMSelection::GetRangeAtFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSDOMSelectionPrototypeTable = 
{
    2, 13, JSDOMSelectionPrototypeTableEntries, 11
};

const ClassInfo JSDOMSelectionPrototype::info = { "DOMSelectionPrototype", 0, &JSDOMSelectionPrototypeTable, 0 };

JSObject* JSDOMSelectionPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDOMSelectionPrototype>(exec, "[[JSDOMSelection.prototype]]");
}

bool JSDOMSelectionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSDOMSelectionPrototypeFunction, JSObject>(exec, &JSDOMSelectionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMSelection::info = { "DOMSelection", 0, &JSDOMSelectionTable, 0 };

JSDOMSelection::JSDOMSelection(ExecState* exec, DOMSelection* impl)
    : m_impl(impl)
{
    setPrototype(JSDOMSelectionPrototype::self(exec));
}

JSDOMSelection::~JSDOMSelection()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSDOMSelection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMSelection, KJS::DOMObject>(exec, &JSDOMSelectionTable, this, propertyName, slot);
}

JSValue* JSDOMSelection::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AnchorNodeAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return toJS(exec, WTF::getPtr(imp->anchorNode()));
    }
    case AnchorOffsetAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return jsNumber(imp->anchorOffset());
    }
    case FocusNodeAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return toJS(exec, WTF::getPtr(imp->focusNode()));
    }
    case FocusOffsetAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return jsNumber(imp->focusOffset());
    }
    case BaseNodeAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return toJS(exec, WTF::getPtr(imp->baseNode()));
    }
    case BaseOffsetAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return jsNumber(imp->baseOffset());
    }
    case ExtentNodeAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return toJS(exec, WTF::getPtr(imp->extentNode()));
    }
    case ExtentOffsetAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return jsNumber(imp->extentOffset());
    }
    case IsCollapsedAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return jsBoolean(imp->isCollapsed());
    }
    case TypeAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return jsString(imp->type());
    }
    case RangeCountAttrNum: {
        DOMSelection* imp = static_cast<DOMSelection*>(impl());

        return jsNumber(imp->rangeCount());
    }
    }
    return 0;
}

JSValue* JSDOMSelectionPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDOMSelection::info))
      return throwError(exec, TypeError);

    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(thisObj)->impl());

    switch (id) {
    case JSDOMSelection::CollapseFuncNum: {
        ExceptionCode ec = 0;
        Node* node = toNode(args[0]);
        bool indexOk;
        int index = args[1]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->collapse(node, index, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSDOMSelection::CollapseToEndFuncNum: {

        imp->collapseToEnd();
        return jsUndefined();
    }
    case JSDOMSelection::CollapseToStartFuncNum: {

        imp->collapseToStart();
        return jsUndefined();
    }
    case JSDOMSelection::EmptyFuncNum: {

        imp->empty();
        return jsUndefined();
    }
    case JSDOMSelection::SetBaseAndExtentFuncNum: {
        ExceptionCode ec = 0;
        Node* baseNode = toNode(args[0]);
        bool baseOffsetOk;
        int baseOffset = args[1]->toInt32(exec, baseOffsetOk);
        if (!baseOffsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }
        Node* extentNode = toNode(args[2]);
        bool extentOffsetOk;
        int extentOffset = args[3]->toInt32(exec, extentOffsetOk);
        if (!extentOffsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->setBaseAndExtent(baseNode, baseOffset, extentNode, extentOffset, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSDOMSelection::SetPositionFuncNum: {
        ExceptionCode ec = 0;
        Node* node = toNode(args[0]);

        int argsCount = args.size();
        if (argsCount < 2) {
            imp->setPosition(node, ec);
            setDOMException(exec, ec);
            return jsUndefined();
        }

        bool offsetOk;
        int offset = args[1]->toInt32(exec, offsetOk);
        if (!offsetOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }

        imp->setPosition(node, offset, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSDOMSelection::ModifyFuncNum: {
        String alter = args[0]->toString(exec);
        String direction = args[1]->toString(exec);
        String granularity = args[2]->toString(exec);

        imp->modify(alter, direction, granularity);
        return jsUndefined();
    }
    case JSDOMSelection::GetRangeAtFuncNum: {
        ExceptionCode ec = 0;
        bool indexOk;
        int index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getRangeAt(index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDOMSelection::RemoveAllRangesFuncNum: {

        imp->removeAllRanges();
        return jsUndefined();
    }
    case JSDOMSelection::AddRangeFuncNum: {
        Range* range = toRange(args[0]);

        imp->addRange(range);
        return jsUndefined();
    }
    case JSDOMSelection::ToStringFuncNum: {


        KJS::JSValue* result = jsString(imp->toString());
        return result;
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, DOMSelection* obj)
{
    return KJS::cacheDOMObject<DOMSelection, JSDOMSelection>(exec, obj);
}
DOMSelection* toDOMSelection(KJS::JSValue* val)
{
    return val->isObject(&JSDOMSelection::info) ? static_cast<JSDOMSelection*>(val)->impl() : 0;
}

}
