/*
* Copyright (c) 2000 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#include "nw_xhtml_xhtmlentityseti.h"

/* ------------------------------------------------------------------------- */

/* ------------------------------------------------------------------------- */
/* Note:		This array must be sorted by entity name.  The lookup function
				does a binary search. */

/* IMPORTANT:	When you update this table make sure the constant 
				NW_XHTML_Num_CaseInsensitive_Entries which is the count of 
				caseinsensitive entries is updated correctly */
static
const NW_HED_EntitySet_Entry_t _NW_XHTML_EntitySet_Array[] = {
// CaseSensitive entries
  { "AElig", 198 },
  { "Aacute", 193 },
  { "Acirc", 194 },
  { "Agrave", 192 },
  { "Alpha", 913 },
  { "Aring", 197 },
  { "Atilde", 195 },
  { "Auml", 196 },
  { "Beta", 914 },
  { "Ccedil", 199 },
  { "Chi", 935 },
  { "Dagger", 8225 },
  { "Delta", 916 },
  { "ETH", 208 },
  { "Eacute", 201 },
  { "Ecirc", 202 },
  { "Egrave", 200 },
  { "Epsilon", 917 },
  { "Eta", 919 },
  { "Euml", 203 },
  { "Gamma", 915 },
  { "Iacute", 205 },
  { "Icirc", 206 },
  { "Igrave", 204 },
  { "Iota", 921 },
  { "Iuml", 207 },
  { "Kappa", 922 },
  { "Lambda", 923 },
  { "Mu", 924 },
  { "Ntilde", 209 },
  { "Nu", 925 },
  { "OElig", 338 },
  { "Oacute", 211 },
  { "Ocirc", 212 },
  { "Ograve", 210 },
  { "Omega", 937 },
  { "Omicron", 927 },
  { "Oslash", 216 },
  { "Otilde", 213 },
  { "Ouml", 214 },
  { "Phi", 934 },
  { "Pi", 928 },
  { "Prime", 8243 },
  { "Psi", 936 },
  { "Rho", 929 },
  { "Scaron", 352 },
  { "Sigma", 931 },
  { "THORN", 222 },
  { "Tau", 932 },
  { "Theta", 920 },
  { "Uacute", 218 },
  { "Ucirc", 219 },
  { "Ugrave", 217 },
  { "Upsilon", 933 },
  { "Uuml", 220 },
  { "Xi", 926 },
  { "Yacute", 221 },
  { "Yuml", 376 },
  { "Zeta", 918 },
  { "aacute", 225 },
  { "acirc", 226 },
  { "acute", 180 },
  { "aelig", 230 },
  { "agrave", 224 },
  { "alpha", 945 },
  { "atilde", 227 },
  { "auml", 228 },
  { "beta", 946 },
  { "ccedil", 231 },
  { "chi", 967 },
  { "dArr", 8659 },
  { "dagger", 8224 },
  { "darr", 8595 },
  { "delta", 948 },
  { "eacute", 233 },
  { "ecirc", 234 },
  { "egrave", 232 },
  { "epsilon", 949 },
  { "eta", 951 },
  { "euml", 235 },
  { "gamma", 947 },
  { "hArr", 8660 },
  { "harr", 8596 },
  { "iacute", 237 },
  { "icirc", 238 },
  { "igrave", 236 },
  { "iota", 953 },
  { "iuml", 239 },
  { "kappa", 954 },
  { "lArr", 8656 },
  { "lambda", 955 },
  { "larr", 8592 },
  { "mu", 956 },
  { "ntilde", 241 },
  { "nu", 957 },
  { "oacute", 243 },
  { "ocirc", 244 },
  { "oelig", 339 },
  { "ograve", 242 },
  { "omega", 969 },
  { "omicron", 959 },
  { "oslash", 248 },
  { "otilde", 245 },
  { "otimes", 8855 },
  { "ouml", 246 },
  { "phi", 966 },
  { "pi", 960 },
  { "psi", 968 },
  { "rArr", 8658 },
  { "rarr", 8594 },
  { "rho", 961 },
  { "scaron", 353 },
  { "sigma", 963 },
  { "tau", 964 },
  { "theta", 952 },
  { "thorn", 254 },
  { "uArr", 8657 },
  { "uacute", 250 },
  { "uarr", 8593 },
  { "ucirc", 251 },
  { "ugrave", 249 },
  { "upsilon", 965 },
  { "uuml", 252 },
  { "xi", 958 },
  { "yacute", 253 },
  { "yuml", 255 },
  { "zeta", 950 },
  { "zwj", 8205 },
  { "zwnj", 8204 },
// Case Insensitive entries
  { "alefsym", 8501 },
  { "amp", 38 },
  { "and", 8743 },
  { "ang", 8736 },
  { "apos", 39 },
  { "aring", 229 },
  { "asymp", 8776 },
  { "bdquo", 8222 },
  { "brvbar", 166 },
  { "bull", 8226 },
  { "cap", 8745 },
  { "cedil", 184 },
  { "cent", 162 },
  { "circ", 710 },
  { "clubs", 9827 },
  { "cong", 8773 },
  { "copy", 169 },
  { "crarr", 8629 },
  { "cup", 8746 },
  { "curren", 164 },
  { "deg", 176 },
  { "diams", 9830 },
  { "divide", 247 },
  { "empty", 8709 },
  { "emsp", 8195 },
  { "ensp", 8194 },
  { "equiv", 8801 },
  { "eth", 240 },
  { "euro", 8364 },
  { "exist", 8707 },
  { "fnof", 402 },
  { "forall", 8704 },
  { "frac12", 189 },
  { "frac14", 188 },
  { "frac34", 190 },
  { "frasl", 8260 },
  { "ge", 8805 },
  { "gt", 62 },
  { "hearts", 9829 },
  { "hellip", 8230 },
  { "iexcl", 161 },
  { "image", 8465 },
  { "infin", 8734 },
  { "int", 8747 },
  { "iquest", 191 },
  { "isin", 8712 },
  { "lang", 9001 },
  { "laquo", 171 },
  { "lceil", 8968 },
  { "ldquo", 8220 },
  { "le", 8804 },
  { "lfloor", 8970 },
  { "lowast", 8727 },
  { "loz", 9674 },
  { "lrm", 8206 },
  { "lsaquo", 8249 },
  { "lsquo", 8216 },
  { "lt", 60 },
  { "macr", 175 },
  { "mdash", 8212 },
  { "micro", 181 },
  { "middot", 183 },
  { "minus", 8722 },
  { "nabla", 8711 },
  { "nbsp", 160 },
  { "ndash", 8211 },
  { "ne", 8800 },
  { "ni", 8715 },
  { "not", 172 },
  { "notin", 8713 },
  { "nsub", 8836 },
  { "oline", 8254 },
  { "oplus", 8853 },
  { "or", 8744 },
  { "ordf", 170 },
  { "ordm", 186 },
  { "para", 182 },
  { "part", 8706 },
  { "permil", 8240 },
  { "perp", 8869 },
  { "piv", 982 },
  { "plusmn", 177 },
  { "pound", 163 },
  { "prime", 8242 },
  { "prod", 8719 },
  { "prop", 8733 },
  { "quot", 34 },
  { "radic", 8730 },
  { "rang", 9002 },
  { "raquo", 187 },
  { "rceil", 8969 },
  { "rdquo", 8221 },
  { "real", 8476 },
  { "reg", 174 },
  { "rfloor", 8971 },
  { "rlm", 8207 },
  { "rsaquo", 8250 },
  { "rsquo", 8217 },
  { "sbquo", 8218 },
  { "sdot", 8901 },
  { "sect", 167 },
  { "shy", 173 },
  { "sigmaf", 962 },
  { "sim", 8764 },
  { "spades", 9824 },
  { "sub", 8834 },
  { "sube", 8838 },
  { "sum", 8721 },
  { "sup", 8835 },
  { "sup1", 185 },
  { "sup2", 178 },
  { "sup3", 179 },
  { "supe", 8839 },
  { "szlig", 223 },
  { "there4", 8756 },
  { "thetasym", 977 },
  { "thinsp", 8201 },
  { "tilde", 732 },
  { "times", 215 },
  { "trade", 8482 },
  { "uml", 168 },
  { "upsih", 978 },
  { "weierp", 8472 },
  { "yen", 165 },
  { "zwj", 8205 },
  { "zwnj", 8204 },
};

/* ------------------------------------------------------------------------- */
/* IMPORTANT:	When you update the above table make sure the constant 
				NW_XHTML_Num_CaseInsensitive_Entries which is the count of 
				caseinsensitive entries is updated correctly */

#define NW_XHTML_Num_CaseInsensitive_Entries 126

/* ------------------------------------------------------------------------- */
const
NW_XHTML_EntitySet_Class_t NW_XHTML_EntitySet_Class = {
  { /* NW_Object_Core				*/
    /* superclass					*/ &NW_HED_EntitySet_Class,
    /* queryInterface				*/ _NW_Object_Base_QueryInterface
  },
  { /* NW_HED_EntitySet				*/
    /* numEntries					*/ sizeof(_NW_XHTML_EntitySet_Array) 
									/ sizeof(_NW_XHTML_EntitySet_Array[0]),
    /* numCaseInsensitiveEntries    */ NW_XHTML_Num_CaseInsensitive_Entries,
    /* entries						*/ &_NW_XHTML_EntitySet_Array[0],
    /* createContentHandler			*/ _NW_HED_EntitySet_GetEntityChar
  },
  { /* NW_XHTML_EntitySet			*/
    /* unused						*/ NW_Object_Unused
  }
};

/* ------------------------------------------------------------------------- */
const NW_XHTML_EntitySet_t NW_XHTML_EntitySet = {
  { { &NW_XHTML_EntitySet_Class } }
};
