/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGLineElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGElement.h"
#include "SVGLineElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGLineElementTableEntries[] =
{
    { "xmllang", JSSVGLineElement::XmllangAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "xmlspace", JSSVGLineElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "transform", JSSVGLineElement::TransformAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "externalResourcesRequired", JSSVGLineElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "x1", JSSVGLineElement::X1AttrNum, DontDelete|ReadOnly, 0, &JSSVGLineElementTableEntries[17] },
    { "x2", JSSVGLineElement::X2AttrNum, DontDelete|ReadOnly, 0, &JSSVGLineElementTableEntries[15] },
    { "requiredExtensions", JSSVGLineElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "requiredFeatures", JSSVGLineElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, &JSSVGLineElementTableEntries[16] },
    { 0, 0, 0, 0, 0 },
    { "style", JSSVGLineElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "y1", JSSVGLineElement::Y1AttrNum, DontDelete|ReadOnly, 0, 0 },
    { "farthestViewportElement", JSSVGLineElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "y2", JSSVGLineElement::Y2AttrNum, DontDelete|ReadOnly, 0, 0 },
    { "systemLanguage", JSSVGLineElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "className", JSSVGLineElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, &JSSVGLineElementTableEntries[18] },
    { "nearestViewportElement", JSSVGLineElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGLineElementTable = 
{
    2, 19, JSSVGLineElementTableEntries, 15
};

/* Hash table for prototype */

static const HashEntry JSSVGLineElementPrototypeTableEntries[] =
{
    { "hasExtension", JSSVGLineElement::HasExtensionFuncNum, DontDelete|Function, 1, &JSSVGLineElementPrototypeTableEntries[6] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getBBox", JSSVGLineElement::GetBBoxFuncNum, DontDelete|Function, 0, &JSSVGLineElementPrototypeTableEntries[5] },
    { "getTransformToElement", JSSVGLineElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 },
    { "getCTM", JSSVGLineElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getScreenCTM", JSSVGLineElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSSVGLineElementPrototypeTable = 
{
    2, 7, JSSVGLineElementPrototypeTableEntries, 5
};

const ClassInfo JSSVGLineElementPrototype::info = { "SVGLineElementPrototype", 0, &JSSVGLineElementPrototypeTable, 0 };

JSObject* JSSVGLineElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGLineElementPrototype>(exec, "[[JSSVGLineElement.prototype]]");
}

bool JSSVGLineElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGLineElementPrototypeFunction, JSObject>(exec, &JSSVGLineElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGLineElement::info = { "SVGLineElement", &JSSVGElement::info, &JSSVGLineElementTable, 0 };

JSSVGLineElement::JSSVGLineElement(ExecState* exec, SVGLineElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGLineElementPrototype::self(exec));
}

bool JSSVGLineElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLineElement, JSSVGElement>(exec, &JSSVGLineElementTable, this, propertyName, slot);
}

JSValue* JSSVGLineElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case X1AttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->x1Animated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case Y1AttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->y1Animated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case X2AttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->x2Animated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case Y2AttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->y2Animated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RequiredFeaturesAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case TransformAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case NearestViewportElementAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    }
    return 0;
}

void JSSVGLineElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGLineElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGLineElementTable, this);
}

void JSSVGLineElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGLineElement* imp = static_cast<SVGLineElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGLineElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGLineElement::info))
      return throwError(exec, TypeError);

    SVGLineElement* imp = static_cast<SVGLineElement*>(static_cast<JSSVGLineElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGLineElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    case JSSVGLineElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGLineElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGLineElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGLineElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
