/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGElementInstanceList.h"

#include <wtf/GetPtr.h>

#include "ExceptionCode.h"
#include "JSSVGElementInstance.h"
#include "SVGElementInstance.h"
#include "SVGElementInstanceList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGElementInstanceListTableEntries[] =
{
    { "length", JSSVGElementInstanceList::LengthAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGElementInstanceListTable = 
{
    2, 1, JSSVGElementInstanceListTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSSVGElementInstanceListPrototypeTableEntries[] =
{
    { "item", JSSVGElementInstanceList::ItemFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGElementInstanceListPrototypeTable = 
{
    2, 1, JSSVGElementInstanceListPrototypeTableEntries, 1
};

const ClassInfo JSSVGElementInstanceListPrototype::info = { "SVGElementInstanceListPrototype", 0, &JSSVGElementInstanceListPrototypeTable, 0 };

JSObject* JSSVGElementInstanceListPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGElementInstanceListPrototype>(exec, "[[JSSVGElementInstanceList.prototype]]");
}

bool JSSVGElementInstanceListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGElementInstanceListPrototypeFunction, JSObject>(exec, &JSSVGElementInstanceListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGElementInstanceList::info = { "SVGElementInstanceList", 0, &JSSVGElementInstanceListTable, 0 };

JSSVGElementInstanceList::JSSVGElementInstanceList(ExecState* exec, SVGElementInstanceList* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGElementInstanceListPrototype::self(exec));
}

JSSVGElementInstanceList::~JSSVGElementInstanceList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGElementInstanceList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstanceList, KJS::DOMObject>(exec, &JSSVGElementInstanceListTable, this, propertyName, slot);
}

JSValue* JSSVGElementInstanceList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        SVGElementInstanceList* imp = static_cast<SVGElementInstanceList*>(impl());

        return jsNumber(imp->length());
    }
    }
    return 0;
}

JSValue* JSSVGElementInstanceListPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGElementInstanceList::info))
      return throwError(exec, TypeError);

    SVGElementInstanceList* imp = static_cast<SVGElementInstanceList*>(static_cast<JSSVGElementInstanceList*>(thisObj)->impl());

    switch (id) {
    case JSSVGElementInstanceList::ItemFuncNum: {
        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
        return result;
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, SVGElementInstanceList* obj)
{
    return KJS::cacheDOMObject<SVGElementInstanceList, JSSVGElementInstanceList>(exec, obj);
}
SVGElementInstanceList* toSVGElementInstanceList(KJS::JSValue* val)
{
    return val->isObject(&JSSVGElementInstanceList::info) ? static_cast<JSSVGElementInstanceList*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
