/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLMetaElement.h"

#include <wtf/GetPtr.h>

#include "HTMLMetaElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLMetaElementTableEntries[] =
{
    { "name", JSHTMLMetaElement::NameAttrNum, DontDelete, 0, &JSHTMLMetaElementTableEntries[5] },
    { "httpEquiv", JSHTMLMetaElement::HttpEquivAttrNum, DontDelete, 0, 0 },
    { "constructor", JSHTMLMetaElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 },
    { "content", JSHTMLMetaElement::ContentAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "scheme", JSHTMLMetaElement::SchemeAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSHTMLMetaElementTable = 
{
    2, 6, JSHTMLMetaElementTableEntries, 5
};

/* Hash table for constructor */

static const HashEntry JSHTMLMetaElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLMetaElementConstructorTable = 
{
    2, 1, JSHTMLMetaElementConstructorTableEntries, 1
};

class JSHTMLMetaElementConstructor : public DOMObject {
public:
    JSHTMLMetaElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLMetaElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLMetaElementConstructor::info = { "HTMLMetaElementConstructor", 0, &JSHTMLMetaElementConstructorTable, 0 };

bool JSHTMLMetaElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMetaElementConstructor, DOMObject>(exec, &JSHTMLMetaElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLMetaElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLMetaElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLMetaElementPrototypeTable = 
{
    2, 1, JSHTMLMetaElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLMetaElementPrototype::info = { "HTMLMetaElementPrototype", 0, &JSHTMLMetaElementPrototypeTable, 0 };

JSObject* JSHTMLMetaElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLMetaElementPrototype>(exec, "[[JSHTMLMetaElement.prototype]]");
}

const ClassInfo JSHTMLMetaElement::info = { "HTMLMetaElement", &JSHTMLElement::info, &JSHTMLMetaElementTable, 0 };

JSHTMLMetaElement::JSHTMLMetaElement(ExecState* exec, HTMLMetaElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLMetaElementPrototype::self(exec));
}

bool JSHTMLMetaElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMetaElement, JSHTMLElement>(exec, &JSHTMLMetaElementTable, this, propertyName, slot);
}

JSValue* JSHTMLMetaElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ContentAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());

        return jsString(imp->content());
    }
    case HttpEquivAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());

        return jsString(imp->httpEquiv());
    }
    case NameAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());

        return jsString(imp->name());
    }
    case SchemeAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());

        return jsString(imp->scheme());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLMetaElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLMetaElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLMetaElementTable, this);
}

void JSHTMLMetaElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case ContentAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());

        imp->setContent(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HttpEquivAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());

        imp->setHttpEquiv(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NameAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());

        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SchemeAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());

        imp->setScheme(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLMetaElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLMetaElementConstructor>(exec, "[[HTMLMetaElement.constructor]]");
}

}
