/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGRectElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGElement.h"
#include "SVGRectElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGRectElementTableEntries[] =
{
    { "height", JSSVGRectElement::HeightAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "requiredFeatures", JSSVGRectElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "systemLanguage", JSSVGRectElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "farthestViewportElement", JSSVGRectElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "x", JSSVGRectElement::XAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "ry", JSSVGRectElement::RyAttrNum, DontDelete|ReadOnly, 0, &JSSVGRectElementTableEntries[19] },
    { 0, 0, 0, 0, 0 },
    { "requiredExtensions", JSSVGRectElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "width", JSSVGRectElement::WidthAttrNum, DontDelete|ReadOnly, 0, &JSSVGRectElementTableEntries[21] },
    { "y", JSSVGRectElement::YAttrNum, DontDelete|ReadOnly, 0, &JSSVGRectElementTableEntries[17] },
    { "transform", JSSVGRectElement::TransformAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "rx", JSSVGRectElement::RxAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "style", JSSVGRectElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "xmllang", JSSVGRectElement::XmllangAttrNum, DontDelete, 0, &JSSVGRectElementTableEntries[18] },
    { "xmlspace", JSSVGRectElement::XmlspaceAttrNum, DontDelete, 0, &JSSVGRectElementTableEntries[20] },
    { "externalResourcesRequired", JSSVGRectElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "className", JSSVGRectElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "nearestViewportElement", JSSVGRectElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGRectElementTable = 
{
    2, 22, JSSVGRectElementTableEntries, 17
};

/* Hash table for prototype */

static const HashEntry JSSVGRectElementPrototypeTableEntries[] =
{
    { "hasExtension", JSSVGRectElement::HasExtensionFuncNum, DontDelete|Function, 1, &JSSVGRectElementPrototypeTableEntries[6] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getBBox", JSSVGRectElement::GetBBoxFuncNum, DontDelete|Function, 0, &JSSVGRectElementPrototypeTableEntries[5] },
    { "getTransformToElement", JSSVGRectElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 },
    { "getCTM", JSSVGRectElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getScreenCTM", JSSVGRectElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSSVGRectElementPrototypeTable = 
{
    2, 7, JSSVGRectElementPrototypeTableEntries, 5
};

const ClassInfo JSSVGRectElementPrototype::info = { "SVGRectElementPrototype", 0, &JSSVGRectElementPrototypeTable, 0 };

JSObject* JSSVGRectElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGRectElementPrototype>(exec, "[[JSSVGRectElement.prototype]]");
}

bool JSSVGRectElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGRectElementPrototypeFunction, JSObject>(exec, &JSSVGRectElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGRectElement::info = { "SVGRectElement", &JSSVGElement::info, &JSSVGRectElementTable, 0 };

JSSVGRectElement::JSSVGRectElement(ExecState* exec, SVGRectElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGRectElementPrototype::self(exec));
}

bool JSSVGRectElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRectElement, JSSVGElement>(exec, &JSSVGRectElementTable, this, propertyName, slot);
}

JSValue* JSSVGRectElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case YAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case WidthAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case HeightAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RxAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->rxAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RyAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->ryAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RequiredFeaturesAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case TransformAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case NearestViewportElementAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    }
    return 0;
}

void JSSVGRectElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGRectElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGRectElementTable, this);
}

void JSSVGRectElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGRectElement* imp = static_cast<SVGRectElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGRectElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGRectElement::info))
      return throwError(exec, TypeError);

    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGRectElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    case JSSVGRectElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGRectElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGRectElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGRectElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
