/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGTRefElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedString.h"
#include "SVGTRefElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGTRefElementTableEntries[] =
{
    { "href", JSSVGTRefElement::HrefAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGTRefElementTable = 
{
    2, 1, JSSVGTRefElementTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSSVGTRefElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGTRefElementPrototypeTable = 
{
    2, 1, JSSVGTRefElementPrototypeTableEntries, 1
};

const ClassInfo JSSVGTRefElementPrototype::info = { "SVGTRefElementPrototype", 0, &JSSVGTRefElementPrototypeTable, 0 };

JSObject* JSSVGTRefElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGTRefElementPrototype>(exec, "[[JSSVGTRefElement.prototype]]");
}

const ClassInfo JSSVGTRefElement::info = { "SVGTRefElement", &JSSVGTextPositioningElement::info, &JSSVGTRefElementTable, 0 };

JSSVGTRefElement::JSSVGTRefElement(ExecState* exec, SVGTRefElement* impl)
    : JSSVGTextPositioningElement(exec, impl)
{
    setPrototype(JSSVGTRefElementPrototype::self(exec));
}

bool JSSVGTRefElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTRefElement, JSSVGTextPositioningElement>(exec, &JSSVGTRefElementTable, this, propertyName, slot);
}

JSValue* JSSVGTRefElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case HrefAttrNum: {
        SVGTRefElement* imp = static_cast<SVGTRefElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    }
    return 0;
}


}

#endif // ENABLE(SVG)
