/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_EXPERIMENTAL_FEATURES)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGFEMergeNodeElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedString.h"
#include "SVGFEMergeNodeElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGFEMergeNodeElementTableEntries[] =
{
    { "in1", JSSVGFEMergeNodeElement::In1AttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGFEMergeNodeElementTable = 
{
    2, 1, JSSVGFEMergeNodeElementTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSSVGFEMergeNodeElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGFEMergeNodeElementPrototypeTable = 
{
    2, 1, JSSVGFEMergeNodeElementPrototypeTableEntries, 1
};

const ClassInfo JSSVGFEMergeNodeElementPrototype::info = { "SVGFEMergeNodeElementPrototype", 0, &JSSVGFEMergeNodeElementPrototypeTable, 0 };

JSObject* JSSVGFEMergeNodeElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGFEMergeNodeElementPrototype>(exec, "[[JSSVGFEMergeNodeElement.prototype]]");
}

const ClassInfo JSSVGFEMergeNodeElement::info = { "SVGFEMergeNodeElement", &JSSVGElement::info, &JSSVGFEMergeNodeElementTable, 0 };

JSSVGFEMergeNodeElement::JSSVGFEMergeNodeElement(ExecState* exec, SVGFEMergeNodeElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGFEMergeNodeElementPrototype::self(exec));
}

bool JSSVGFEMergeNodeElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEMergeNodeElement, JSSVGElement>(exec, &JSSVGFEMergeNodeElementTable, this, propertyName, slot);
}

JSValue* JSSVGFEMergeNodeElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case In1AttrNum: {
        SVGFEMergeNodeElement* imp = static_cast<SVGFEMergeNodeElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->in1Animated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    }
    return 0;
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_EXPERIMENTAL_FEATURES)
