/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGEllipseElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "PlatformString.h"
#include "SVGElement.h"
#include "SVGEllipseElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGEllipseElementTableEntries[] =
{
    { "xmllang", JSSVGEllipseElement::XmllangAttrNum, DontDelete, 0, 0 },
    { "rx", JSSVGEllipseElement::RxAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmlspace", JSSVGEllipseElement::XmlspaceAttrNum, DontDelete, 0, 0 },
    { "cy", JSSVGEllipseElement::CyAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "ry", JSSVGEllipseElement::RyAttrNum, DontDelete|ReadOnly, 0, &JSSVGEllipseElementTableEntries[17] },
    { "externalResourcesRequired", JSSVGEllipseElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "className", JSSVGEllipseElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, &JSSVGEllipseElementTableEntries[18] },
    { 0, 0, 0, 0, 0 },
    { "requiredExtensions", JSSVGEllipseElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "cx", JSSVGEllipseElement::CxAttrNum, DontDelete|ReadOnly, 0, &JSSVGEllipseElementTableEntries[15] },
    { 0, 0, 0, 0, 0 },
    { "style", JSSVGEllipseElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "farthestViewportElement", JSSVGEllipseElement::FarthestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "requiredFeatures", JSSVGEllipseElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, &JSSVGEllipseElementTableEntries[16] },
    { "systemLanguage", JSSVGEllipseElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "transform", JSSVGEllipseElement::TransformAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "nearestViewportElement", JSSVGEllipseElement::NearestViewportElementAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGEllipseElementTable = 
{
    2, 19, JSSVGEllipseElementTableEntries, 15
};

/* Hash table for prototype */

static const HashEntry JSSVGEllipseElementPrototypeTableEntries[] =
{
    { "hasExtension", JSSVGEllipseElement::HasExtensionFuncNum, DontDelete|Function, 1, &JSSVGEllipseElementPrototypeTableEntries[6] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getBBox", JSSVGEllipseElement::GetBBoxFuncNum, DontDelete|Function, 0, &JSSVGEllipseElementPrototypeTableEntries[5] },
    { "getTransformToElement", JSSVGEllipseElement::GetTransformToElementFuncNum, DontDelete|Function, 1, 0 },
    { "getCTM", JSSVGEllipseElement::GetCTMFuncNum, DontDelete|Function, 0, 0 },
    { "getScreenCTM", JSSVGEllipseElement::GetScreenCTMFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSSVGEllipseElementPrototypeTable = 
{
    2, 7, JSSVGEllipseElementPrototypeTableEntries, 5
};

const ClassInfo JSSVGEllipseElementPrototype::info = { "SVGEllipseElementPrototype", 0, &JSSVGEllipseElementPrototypeTable, 0 };

JSObject* JSSVGEllipseElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGEllipseElementPrototype>(exec, "[[JSSVGEllipseElement.prototype]]");
}

bool JSSVGEllipseElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGEllipseElementPrototypeFunction, JSObject>(exec, &JSSVGEllipseElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGEllipseElement::info = { "SVGEllipseElement", &JSSVGElement::info, &JSSVGEllipseElementTable, 0 };

JSSVGEllipseElement::JSSVGEllipseElement(ExecState* exec, SVGEllipseElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGEllipseElementPrototype::self(exec));
}

bool JSSVGEllipseElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGEllipseElement, JSSVGElement>(exec, &JSSVGEllipseElementTable, this, propertyName, slot);
}

JSValue* JSSVGEllipseElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CxAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->cxAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case CyAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->cyAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RxAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->rxAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RyAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedLength> obj = imp->ryAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedLength>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedLength>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedLength>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case RequiredFeaturesAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case XmllangAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    case TransformAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case NearestViewportElementAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
    }
    case FarthestViewportElementAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
    }
    }
    return 0;
}

void JSSVGEllipseElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGEllipseElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGEllipseElementTable, this);
}

void JSSVGEllipseElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}

JSValue* JSSVGEllipseElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGEllipseElement::info))
      return throwError(exec, TypeError);

    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(static_cast<JSSVGEllipseElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGEllipseElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    case JSSVGEllipseElement::GetBBoxFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<FloatRect>(imp->getBBox()));
        return result;
    }
    case JSSVGEllipseElement::GetCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getCTM()));
        return result;
    }
    case JSSVGEllipseElement::GetScreenCTMFuncNum: {


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getScreenCTM()));
        return result;
    }
    case JSSVGEllipseElement::GetTransformToElementFuncNum: {
        ExceptionCode ec = 0;
        SVGElement* element = toSVGElement(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<AffineTransform>(imp->getTransformToElement(element, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
