/*
 * Copyright (C) 2006 Apple Computer, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef FontCache_h
#define FontCache_h

#include <wtf/unicode/Unicode.h>

#if PLATFORM(WIN)
#include <mlang.h>
#endif

namespace WebCore
{

class AtomicString;
class FontData;
class FontPlatformData;
class Font;
class FontDescription;

class FontCache {
public:
    static const FontData* getFontData(const Font&, int& familyIndex);
    
    // This method is implemented by the platform.
    static const FontData* getFontDataForCharacters(const Font&, const UChar* characters, int length);
    
    // Also implemented by the platform.
    static void platformInit();

#if PLATFORM(WIN)
    static IMLangFontLink2* getFontLinkInterface();
#elif PLATFORM(SYMBIAN)
    static const AtomicString& systemFontFamilyName( const AtomicString& familyName );
    static FontPlatformData* getDeviceDefaultFont(float size);
#endif
    static void deleteFontDataCache();
    
private:
    static FontPlatformData* getCachedFontPlatformData(const FontDescription&, const AtomicString& family, bool checkingAlternateName = false);
    static FontData* getCachedFontData(const FontPlatformData*);
    
    // These three methods are implemented by each platform.
    static FontPlatformData* getSimilarFontPlatformData(const Font&);
    static FontPlatformData* getLastResortFallbackFont(const Font&);
    static FontPlatformData* createFontPlatformData(const FontDescription&, const AtomicString& family);

    friend class FontData;
    friend class FontFallbackList;
};

}

#endif
