/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLOptGroupElement.h"

#include <wtf/GetPtr.h>

#include "HTMLOptGroupElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLOptGroupElementTableEntries[] =
{
    { "constructor", JSHTMLOptGroupElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 },
    { "disabled", JSHTMLOptGroupElement::DisabledAttrNum, DontDelete, 0, 0 },
    { "label", JSHTMLOptGroupElement::LabelAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementTable = 
{
    2, 3, JSHTMLOptGroupElementTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSHTMLOptGroupElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementConstructorTable = 
{
    2, 1, JSHTMLOptGroupElementConstructorTableEntries, 1
};

class JSHTMLOptGroupElementConstructor : public DOMObject {
public:
    JSHTMLOptGroupElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLOptGroupElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLOptGroupElementConstructor::info = { "HTMLOptGroupElementConstructor", 0, &JSHTMLOptGroupElementConstructorTable, 0 };

bool JSHTMLOptGroupElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptGroupElementConstructor, DOMObject>(exec, &JSHTMLOptGroupElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLOptGroupElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLOptGroupElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementPrototypeTable = 
{
    2, 1, JSHTMLOptGroupElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLOptGroupElementPrototype::info = { "HTMLOptGroupElementPrototype", 0, &JSHTMLOptGroupElementPrototypeTable, 0 };

JSObject* JSHTMLOptGroupElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLOptGroupElementPrototype>(exec, "[[JSHTMLOptGroupElement.prototype]]");
}

const ClassInfo JSHTMLOptGroupElement::info = { "HTMLOptGroupElement", &JSHTMLElement::info, &JSHTMLOptGroupElementTable, 0 };

JSHTMLOptGroupElement::JSHTMLOptGroupElement(ExecState* exec, HTMLOptGroupElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLOptGroupElementPrototype::self(exec));
}

bool JSHTMLOptGroupElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptGroupElement, JSHTMLElement>(exec, &JSHTMLOptGroupElementTable, this, propertyName, slot);
}

JSValue* JSHTMLOptGroupElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DisabledAttrNum: {
        HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(impl());

        return jsBoolean(imp->disabled());
    }
    case LabelAttrNum: {
        HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(impl());

        return jsString(imp->label());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLOptGroupElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLOptGroupElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLOptGroupElementTable, this);
}

void JSHTMLOptGroupElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case DisabledAttrNum: {
        HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(impl());

        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case LabelAttrNum: {
        HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(impl());

        imp->setLabel(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLOptGroupElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLOptGroupElementConstructor>(exec, "[[HTMLOptGroupElement.constructor]]");
}

}
