/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGScriptElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "PlatformString.h"
#include "SVGScriptElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGScriptElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "type", JSSVGScriptElement::TypeAttrNum, DontDelete, 0, &JSSVGScriptElementTableEntries[3] },
    { "externalResourcesRequired", JSSVGScriptElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "href", JSSVGScriptElement::HrefAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGScriptElementTable = 
{
    2, 4, JSSVGScriptElementTableEntries, 3
};

/* Hash table for prototype */

static const HashEntry JSSVGScriptElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGScriptElementPrototypeTable = 
{
    2, 1, JSSVGScriptElementPrototypeTableEntries, 1
};

const ClassInfo JSSVGScriptElementPrototype::info = { "SVGScriptElementPrototype", 0, &JSSVGScriptElementPrototypeTable, 0 };

JSObject* JSSVGScriptElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGScriptElementPrototype>(exec, "[[JSSVGScriptElement.prototype]]");
}

const ClassInfo JSSVGScriptElement::info = { "SVGScriptElement", &JSSVGElement::info, &JSSVGScriptElementTable, 0 };

JSSVGScriptElement::JSSVGScriptElement(ExecState* exec, SVGScriptElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGScriptElementPrototype::self(exec));
}

bool JSSVGScriptElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGScriptElement, JSSVGElement>(exec, &JSSVGScriptElementTable, this, propertyName, slot);
}

JSValue* JSSVGScriptElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TypeAttrNum: {
        SVGScriptElement* imp = static_cast<SVGScriptElement*>(impl());

        return jsString(imp->type());
    }
    case HrefAttrNum: {
        SVGScriptElement* imp = static_cast<SVGScriptElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGScriptElement* imp = static_cast<SVGScriptElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    }
    return 0;
}

void JSSVGScriptElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGScriptElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGScriptElementTable, this);
}

void JSSVGScriptElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case TypeAttrNum: {
        SVGScriptElement* imp = static_cast<SVGScriptElement*>(impl());

        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}


}

#endif // ENABLE(SVG)
