/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDocumentType.h"

#include <wtf/GetPtr.h>

#include "DocumentType.h"
#include "JSNamedNodeMap.h"
#include "NamedAttrMap.h"
#include "NamedNodeMap.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDocumentTypeTableEntries[] =
{
    { "notations", JSDocumentType::NotationsAttrNum, DontDelete|ReadOnly, 0, &JSDocumentTypeTableEntries[7] },
    { 0, 0, 0, 0, 0 },
    { "name", JSDocumentType::NameAttrNum, DontDelete|ReadOnly, 0, &JSDocumentTypeTableEntries[9] },
    { 0, 0, 0, 0, 0 },
    { "entities", JSDocumentType::EntitiesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "systemId", JSDocumentType::SystemIdAttrNum, DontDelete|ReadOnly, 0, &JSDocumentTypeTableEntries[8] },
    { 0, 0, 0, 0, 0 },
    { "publicId", JSDocumentType::PublicIdAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "internalSubset", JSDocumentType::InternalSubsetAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "constructor", JSDocumentType::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSDocumentTypeTable = 
{
    2, 10, JSDocumentTypeTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSDocumentTypeConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSDocumentTypeConstructorTable = 
{
    2, 1, JSDocumentTypeConstructorTableEntries, 1
};

class JSDocumentTypeConstructor : public DOMObject {
public:
    JSDocumentTypeConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSDocumentTypePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSDocumentTypeConstructor::info = { "DocumentTypeConstructor", 0, &JSDocumentTypeConstructorTable, 0 };

bool JSDocumentTypeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentTypeConstructor, DOMObject>(exec, &JSDocumentTypeConstructorTable, this, propertyName, slot);
}

JSValue* JSDocumentTypeConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSDocumentTypePrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSDocumentTypePrototypeTable = 
{
    2, 1, JSDocumentTypePrototypeTableEntries, 1
};

const ClassInfo JSDocumentTypePrototype::info = { "DocumentTypePrototype", 0, &JSDocumentTypePrototypeTable, 0 };

JSObject* JSDocumentTypePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDocumentTypePrototype>(exec, "[[JSDocumentType.prototype]]");
}

const ClassInfo JSDocumentType::info = { "DocumentType", &JSNode::info, &JSDocumentTypeTable, 0 };

JSDocumentType::JSDocumentType(ExecState* exec, DocumentType* impl)
    : JSNode(exec, impl)
{
    setPrototype(JSDocumentTypePrototype::self(exec));
}

bool JSDocumentType::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentType, JSNode>(exec, &JSDocumentTypeTable, this, propertyName, slot);
}

JSValue* JSDocumentType::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case NameAttrNum: {
        DocumentType* imp = static_cast<DocumentType*>(impl());

        return jsString(imp->name());
    }
    case EntitiesAttrNum: {
        DocumentType* imp = static_cast<DocumentType*>(impl());

        return toJS(exec, WTF::getPtr(imp->entities()));
    }
    case NotationsAttrNum: {
        DocumentType* imp = static_cast<DocumentType*>(impl());

        return toJS(exec, WTF::getPtr(imp->notations()));
    }
    case PublicIdAttrNum: {
        DocumentType* imp = static_cast<DocumentType*>(impl());

        return jsStringOrNull(imp->publicId());
    }
    case SystemIdAttrNum: {
        DocumentType* imp = static_cast<DocumentType*>(impl());

        return jsStringOrNull(imp->systemId());
    }
    case InternalSubsetAttrNum: {
        DocumentType* imp = static_cast<DocumentType*>(impl());

        return jsStringOrNull(imp->internalSubset());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSDocumentType::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDocumentTypeConstructor>(exec, "[[DocumentType.constructor]]");
}
DocumentType* toDocumentType(KJS::JSValue* val)
{
    return val->isObject(&JSDocumentType::info) ? static_cast<JSDocumentType*>(val)->impl() : 0;
}

DocumentType* JSDocumentType::impl() const
{
    return static_cast<DocumentType*>(JSNode::impl());
}

}
