/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGNumber.h"

#include <wtf/GetPtr.h>


using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGNumberTableEntries[] =
{
    { "value", JSSVGNumber::ValueAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSSVGNumberTable = 
{
    2, 1, JSSVGNumberTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSSVGNumberPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGNumberPrototypeTable = 
{
    2, 1, JSSVGNumberPrototypeTableEntries, 1
};

const ClassInfo JSSVGNumberPrototype::info = { "SVGNumberPrototype", 0, &JSSVGNumberPrototypeTable, 0 };

JSObject* JSSVGNumberPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGNumberPrototype>(exec, "[[JSSVGNumber.prototype]]");
}

const ClassInfo JSSVGNumber::info = { "SVGNumber", 0, &JSSVGNumberTable, 0 };

JSSVGNumber::JSSVGNumber(ExecState* exec, JSSVGPODTypeWrapper<double>* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGNumberPrototype::self(exec));
}

JSSVGNumber::~JSSVGNumber()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGNumber::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGNumber, KJS::DOMObject>(exec, &JSSVGNumberTable, this, propertyName, slot);
}

JSValue* JSSVGNumber::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ValueAttrNum: {
        double& imp(*impl());

        return jsNumber(imp);
    }
    }
    return 0;
}

void JSSVGNumber::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGNumber, KJS::DOMObject>(exec, propertyName, value, attr, &JSSVGNumberTable, this);
}

void JSSVGNumber::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case ValueAttrNum: {
        double& imp(*impl());

        imp = value->toNumber(exec);
        m_impl->commitChange(exec);
        break;
    }
    }
}

KJS::JSValue* toJS(KJS::ExecState* exec, JSSVGPODTypeWrapper<double>* obj)
{
    return KJS::cacheDOMObject<JSSVGPODTypeWrapper<double>, JSSVGNumber>(exec, obj);
}
double toSVGNumber(KJS::JSValue* val)
{
    return val->isObject(&JSSVGNumber::info) ? (double) *static_cast<JSSVGNumber*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
