/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGGradientElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "SVGGradientElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGGradientElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "spreadMethod", JSSVGGradientElement::SpreadMethodAttrNum, DontDelete|ReadOnly, 0, &JSSVGGradientElementTableEntries[8] },
    { "gradientUnits", JSSVGGradientElement::GradientUnitsAttrNum, DontDelete|ReadOnly, 0, &JSSVGGradientElementTableEntries[7] },
    { "gradientTransform", JSSVGGradientElement::GradientTransformAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "href", JSSVGGradientElement::HrefAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "externalResourcesRequired", JSSVGGradientElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, &JSSVGGradientElementTableEntries[9] },
    { "className", JSSVGGradientElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "style", JSSVGGradientElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGGradientElementTable = 
{
    2, 10, JSSVGGradientElementTableEntries, 7
};

/* Hash table for prototype */

static const HashEntry JSSVGGradientElementPrototypeTableEntries[] =
{
    { "SVG_SPREADMETHOD_UNKNOWN", SVGGradientElement::SVG_SPREADMETHOD_UNKNOWN, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "SVG_SPREADMETHOD_REPEAT", SVGGradientElement::SVG_SPREADMETHOD_REPEAT, DontDelete|ReadOnly, 0, 0 },
    { "SVG_SPREADMETHOD_PAD", SVGGradientElement::SVG_SPREADMETHOD_PAD, DontDelete|ReadOnly, 0, &JSSVGGradientElementPrototypeTableEntries[4] },
    { "SVG_SPREADMETHOD_REFLECT", SVGGradientElement::SVG_SPREADMETHOD_REFLECT, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGGradientElementPrototypeTable = 
{
    2, 5, JSSVGGradientElementPrototypeTableEntries, 4
};

const ClassInfo JSSVGGradientElementPrototype::info = { "SVGGradientElementPrototype", 0, &JSSVGGradientElementPrototypeTable, 0 };

JSObject* JSSVGGradientElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGGradientElementPrototype>(exec, "[[JSSVGGradientElement.prototype]]");
}

bool JSSVGGradientElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGGradientElementPrototype, JSObject>(exec, &JSSVGGradientElementPrototypeTable, this, propertyName, slot);
}

JSValue* JSSVGGradientElementPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSSVGGradientElement::info = { "SVGGradientElement", &JSSVGElement::info, &JSSVGGradientElementTable, 0 };

JSSVGGradientElement::JSSVGGradientElement(ExecState* exec, SVGGradientElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGGradientElementPrototype::self(exec));
}

bool JSSVGGradientElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGGradientElement, JSSVGElement>(exec, &JSSVGGradientElementTable, this, propertyName, slot);
}

JSValue* JSSVGGradientElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case GradientUnitsAttrNum: {
        SVGGradientElement* imp = static_cast<SVGGradientElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedEnumeration> obj = imp->gradientUnitsAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedEnumeration>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedEnumeration>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedEnumeration>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case GradientTransformAttrNum: {
        SVGGradientElement* imp = static_cast<SVGGradientElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedTransformList> obj = imp->gradientTransformAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedTransformList>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedTransformList>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedTransformList>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case SpreadMethodAttrNum: {
        SVGGradientElement* imp = static_cast<SVGGradientElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedEnumeration> obj = imp->spreadMethodAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedEnumeration>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedEnumeration>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedEnumeration>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case HrefAttrNum: {
        SVGGradientElement* imp = static_cast<SVGGradientElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGGradientElement* imp = static_cast<SVGGradientElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case ClassNameAttrNum: {
        SVGGradientElement* imp = static_cast<SVGGradientElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGGradientElement* imp = static_cast<SVGGradientElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    }
    return 0;
}


}

#endif // ENABLE(SVG)
