/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLBaseElement.h"

#include "HTMLBaseElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLBaseElement);

/* Hash table */

static const HashTableValue JSHTMLBaseElementTableValues[4] =
{
    { "href", DontDelete, (intptr_t)jsHTMLBaseElementHref, (intptr_t)setJSHTMLBaseElementHref },
    { "target", DontDelete, (intptr_t)jsHTMLBaseElementTarget, (intptr_t)setJSHTMLBaseElementTarget },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLBaseElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLBaseElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSHTMLBaseElementTableValues, 0 };
#else
    { 8, 7, JSHTMLBaseElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLBaseElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLBaseElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBaseElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLBaseElementConstructorTableValues, 0 };
#endif

class JSHTMLBaseElementConstructor : public DOMConstructorObject {
public:
    JSHTMLBaseElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLBaseElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLBaseElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLBaseElementConstructor::s_info = { "HTMLBaseElementConstructor", 0, &JSHTMLBaseElementConstructorTable, 0 };

bool JSHTMLBaseElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBaseElementConstructor, DOMObject>(exec, &JSHTMLBaseElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLBaseElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLBaseElementConstructor, DOMObject>(exec, &JSHTMLBaseElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLBaseElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLBaseElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLBaseElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLBaseElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLBaseElementPrototype::s_info = { "HTMLBaseElementPrototype", 0, &JSHTMLBaseElementPrototypeTable, 0 };

JSObject* JSHTMLBaseElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLBaseElement>(exec, globalObject);
}

const ClassInfo JSHTMLBaseElement::s_info = { "HTMLBaseElement", &JSHTMLElement::s_info, &JSHTMLBaseElementTable, 0 };

JSHTMLBaseElement::JSHTMLBaseElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLBaseElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLBaseElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLBaseElementPrototype(JSHTMLBaseElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLBaseElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBaseElement, Base>(exec, &JSHTMLBaseElementTable, this, propertyName, slot);
}

bool JSHTMLBaseElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLBaseElement, Base>(exec, &JSHTMLBaseElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLBaseElementHref(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLBaseElement* castedThis = static_cast<JSHTMLBaseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::hrefAttr));
}

JSValue jsHTMLBaseElementTarget(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLBaseElement* castedThis = static_cast<JSHTMLBaseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(castedThis->impl());
    return jsString(exec, imp->getAttribute(HTMLNames::targetAttr));
}

JSValue jsHTMLBaseElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLBaseElement* domObject = static_cast<JSHTMLBaseElement*>(asObject(slot.slotBase()));
    return JSHTMLBaseElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLBaseElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLBaseElement, Base>(exec, propertyName, value, &JSHTMLBaseElementTable, this, slot);
}

void setJSHTMLBaseElementHref(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(static_cast<JSHTMLBaseElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::hrefAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLBaseElementTarget(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(static_cast<JSHTMLBaseElement*>(thisObject)->impl());
    imp->setAttribute(HTMLNames::targetAttr, valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLBaseElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLBaseElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
