/*
* Copyright (c) 2003 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  This file contains the header file of the CCbsRecMessage class
*
*/


#ifndef CCBSRECMESSAGE_H
#define CCBSRECMESSAGE_H

// INCLUDES
		/*****************************************************
		*	Series 60 Customer / ETel
		*	Series 60  ETel API
		*****************************************************/
#include <etelmm.h>

#include "CbsCommon.h"
#include "CCbsMessage.h"

// CLASS DECLARATION

/**
*   CCbsRecMessage represents a message page generated by CCbsRecEtelMonitor.
*
*   CCbsRecMessage is constructed from a CB message page received from 
*   EPOC Telephony Server.
*/
class CCbsRecMessage : public CCbsMessage
    {
    public:        // Constructors and destructors

        /**
        *   Constructs a new CCbsRecMessage based on TDes8&
        *   (which is a descriptor) received from EPOC Telephony Server.
        *   
        *   @param  aMessagePage        Source message descriptor
        *   @return                     A new instance of CCbsRecMessage
        */
        static CCbsRecMessage* NewL( const TDes8& aMessagePage );

        /**
        *   Copy constructor
        *
        *   @param  aMessagePage        Source CCbsRecMessage instance
        *   @return                     A new instance of CCbsRecMessage
        */
        static CCbsRecMessage* NewL( const CCbsMessage& aMessagePage );

        /**
        *   Destructor
        */
        ~CCbsRecMessage();     

    public:

        /**
        *   Returns the page number of this page in the message page sequence,
        *
        *   @return                     Page number of this page.
        */
        TUint ThisPage() const;

        /**
        *   Returns the total number of pages in this page's message.
        *
        *   @return                     Total number of pages in this message
        */
        TUint TotalPages() const;        

    public: // from CCbsMessage

        /**
        *   Returns the type of the message (only in WCDMA)
        *
        *   @return                     Type of this message
        */
        TInt MessageType() const;

    protected:

        /**
        *   Default constructor
        */
        CCbsRecMessage();

    private:

        /**
        *   2nd-phase constructor.
        *
        *   @param aMessagePage         Message page
        */
        void ConstructL( const TDes8& aMessagePage );

        /**
        *   2nd-phase copy constructor.
        *
        *   @param aMessagePage         Message page
        */
        void ConstructL( const CCbsMessage& aMessagePage ); 


    private:    // prohibited functions and operators
        
        // Copy constructor: NewL() used instead
        CCbsRecMessage( const CCbsRecMessage& );

        // Assignment operator
        CCbsRecMessage& operator=( const CCbsRecMessage& );

    };

#endif // CCBSRECMESSAGE_H

// End of File
