// Copyright (c) 2000-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __T_corruptMpa_h__
#define __T_corruptMpa_h__

/*
	Header			Body1					Body 2
1.  OK				Corrupt ( junk)			OK
2.	OK				OK						Corrupt (junk)
3.  Corrupt(junk)	OK						OK
4.	OK				Hdr Length Val Short	OK
5.	OK				OK						Hdr Length Val Short
6.	OK				Hdr Length Val Long		OK	
7.	OK				OK						Hdr Length Val Long		
8.	OK				Body Length Val Short	OK
9.	OK				OK						Length Val Short		
10.	OK				Body Length Val Long	OK					
11.	OK				OK						Length Val Long						
12.	OK				Body Short				OK
13.	OK				OK						Body Short	(Same as a truncated message)	
14.	OK				Body Long				OK					
15.	OK				OK						Body Long	
16. 	Specifies 3 parts when there's only 2
17. 	Specifies 2 parts when there's 3.
18. 	Wrong App ID - should be deleted - tests the Unknown App Handler
19. 	No binary data - message contents missing
20. 	Single Null value for message contents
21.     Message body full of junk, no proper WAP message headers

*/


const TUint8 KMultiAltMsgNullValue[]= 
	{
	0x00
	};

const TUint8 KMultiMixedContentType[]=
	{
	0xA3
	};

const TUint8 KMultiRelatedContentType[] =
	{
	0xB3
	};

const TUint8 KMultiAlternativeContentType[] = 
	{
	0xA6
	};

// Valid WSP header for a Multipart Alternative Push Msg
const TUint8 KWSPHeaderMultiAltValid[]=
	{
	0xA6,  //Content type "application/vnd.wap.multipart.alternative"
	0x94,0x04, 0x35,0x3F,0x45,0x11,   // Date  - Thur 23 Apr 1998 13:41:37 GMT
	0xAF,0x82  //X-Wap-Application-ID- 0x02 = x-wap-application:push.ua
	};

// Valid WSP header for a Multipart Related Push Msg
const TUint8 KWSPHeaderMultiRelValid[]=
	{
	0xB3,  //Content type "application/vnd.wap.multipart.related"
	0x94, 0x04, 0x35, 0x3F, 0x45, 0x11,  // Date - Thur 23 Apr 1998 13:41:37 GMT
	0xAF,  //X-Wap-Application-ID
	0x82  // Short int - 0x02 represent x-wap-application:push.ua
	};

// WSP header for multipart  alternative - specifies wrong App ID
const TUint8 KWSPHeaderMultiAltWrongAppID[]=
	{
	0xA6,  //Content type "application/vnd.wap.multipart.alternative"
	0x94,0x04, 0x35,0x3F,0x45,0x11,   // Date  - Thur 23 Apr 1998 13:41:37 GMT
	0xAF,0x8F  //X-Wap-Application-ID- 0x0F invalid application
	};


// WSP header for multipart related- specifies wrong App ID
const TUint8 KWSPHeaderMultiRelWrongAppID[]=
	{
	0xB3,  //Content type "application/vnd.wap.multipart.related"
	0x94,0x04, 0x35,0x3F,0x45,0x11,   // Date  - Thur 23 Apr 1998 13:41:37 GMT
	0xAF,0x8F  //X-Wap-Application-ID- 0x99 invalid application
	};



// Corrupt WSP header - used for testing all multipart types
const TUint8 KWSPHeaderCorrupt[]=
	{
	//Content type missing 
	0x0C, 0xFF,  //Language - English
	0x94,0x03, 0xFF,0x3F,0x45,0x11,   // Date  - Thur 23 Apr 1998 13:41:37 GMT
	// From : "Fred Bloggs", no string termination!
	0x15, 0x46, 0x72, 0x65, 0x64,0x20, 0x42, 0x6C, 0x6F, 0x67, 0x67, 0x73, 0x01,  
	0xAF,0x82  //X-Wap-Application-ID- 0x02 = x-wap-application:push.ua
	};

// WSP header for all multiparts - specifies wrong content
const TUint8 KWSPHeaderWrongContent[]=
	{
	0xA9,  //Content type wrong
	0x94,0x04, 0x35,0x3F,0x45,0x11,   // Date  - Thur 23 Apr 1998 13:41:37 GMT
	0xAF,0x82  //X-Wap-Application-ID- 0x02 = x-wap-application:push.ua
	};


// Beginning Header for the a 2 piece multipart
const TUint8 KMultiAltNoParts2[]=
	{
	0x02	// number of parts
	};

// Beginning of header for a 3 piece multipart
const TUint8 KMultiAltNoParts3[]=
	{
	0x03	// number of parts
	};

// Header for 1st part of message - valid
const TUint8 KHeaderPart1Valid[]=
	{
	0x0A,	// part 1 header size
	0x1D,	// part 1 body size
	0xB0,	// content type application/vnd.wap.slc ... the headers:
	0x94,0x04,0x35,0x3F,0x45, 0x11,	// Date - Thur 23 Apr 1998 13:41:37 GMT
	0x3F,	
	0x45,
	0x11
	};

// Header for 1st part of message - header length too short
const TUint8 KHeaderPart1HeaderValTooSmall[]=
	{
	0x05,	// part 1 header size - too short should be 0x0A
	0x1D,	// part 1 body size
	0xB0,	// content type application/vnd.wap.slc ... the headers:
	0x94,0x04,0x35,0x3F,0x45, 0x11,	// Date - Thur 23 Apr 1998 13:41:37 GMT
	0x3F,	
	0x45,
	0x11
	};

// Header for 1st part of message - header length too large
const TUint8 KHeaderPart1HeaderValTooBig[]=
	{
	0x1A,	// part 1 header size should be 0x0A
	0x1D,	// part 1 body size
	0xB0,	// content type application/vnd.wap.slc ... the headers:
	0x94,0x04,0x35,0x3F,0x45, 0x11,	// Date - Thur 23 Apr 1998 13:41:37 GMT
	0x3F,	
	0x45,
	0x11
	};


// Header for 1st part of message - body size too small
const TUint8 KHeaderPart1BodyValTooSmall[]=
	{
	0x0A,	// part 1 header size
	0x19,	// part 1 body size  - should be 0x1D
	0xB0,	// content type application/vnd.wap.slc ... the headers:
	0x94,0x04,0x35,0x3F,0x45, 0x11,	// Date - Thur 23 Apr 1998 13:41:37 GMT
	0x3F,	
	0x45,
	0x11
	};


// Header for 1st part of message - valid
const TUint8 KHeaderPart1BodyValTooBig[]=
	{
	0x0A,	// part 1 header size
	0x29,	// part 1 body size
	0xB0,	// content type application/vnd.wap.slc ... the headers:
	0x94,0x04,0x35,0x3F,0x45, 0x11,	// Date - Thur 23 Apr 1998 13:41:37 GMT
	0x3F,	
	0x45,
	0x11
	};

// Header for 1st part of message - corrupt values arbitarily chosen
const TUint8 KHeaderPart1Corrupt[]=
	{
	0x23,	// part 1 header size
	0x26,	// part 1 body size
	0x48,	// content type not supported
	0x00,0x02,0x6F,0x3A,0xA5, 0x01,	
	0x3F,	
	0x45,
	0x11, 
	0x64
	};


// Valid Header for 2nd part of message 
const TUint8 KHeaderPart2Valid[]=
	{
	0x0A,	// part 2 header size
	0x64,	// part 2 body size
	0xAE,	// content type application/vnd.wap.sic ... the headers:
	0x94, 0x04, 0x35, 0x3F, 0x45, 0x11,	// Date	-  Thur 23 Apr 1998 13:41:37 GMT
	0x3F,	
	0x45,
	0x11
	};

// Valid Header for 2nd part of message 
const TUint8 KHeaderPart2HeaderValTooSmall[]=
	{
	0x06,	// part 2 header size - should be 0x0A
	0x64,	// part 2 body size
	0xAE,	// content type application/vnd.wap.sic ... the headers:
	0x94, 0x04, 0x35, 0x3F, 0x45, 0x11,	// Date	-  Thur 23 Apr 1998 13:41:37 GMT	
	0x3F,	
	0x45,
	0x11
	};

// Header for 2nd part of message - length of header given is too large.
const TUint8 KHeaderPart2HeaderValTooBig[]=
	{
	0x1F,	// part 2 header size - should be 0x0A
	0x64,	// part 2 body size
	0xAE,	// content type application/vnd.wap.slc ... the headers:
	0x94, 0x04, 0x35, 0x3F, 0x45,0x11,	// Date	-  Thur 23 Apr 1998 13:41:37 GMT
	0x3F,	
	0x45,
	0x11
	};
	

// Header for 2nd part of message  -  value for body length is too small
const TUint8 KHeaderPart2BodyValTooSmall[]=
	{
	0x0A,	// part 2 header size
	0x2F,	// part 2 body size - should be 0x64
	0xAE,	// content type application/vnd.wap.sic ... the headers:
	0x94, 0x04, 0x35, 0x3F, 0x45, 0x11,	// Date	-  Thur 23 Apr 1998 13:41:37 GMT
	0x3F,	
	0x45,
	0x11
	};
 
// Header for 2nd part of message  - value for body length is too large
const TUint8 KHeaderPart2BodyValTooBig[]=
	{
	0x0A,	// part 2 header size
	0x7F,	// part 2 body size should be 0x64
	0xAE,	// content type application/vnd.wap.sic ... the headers:
	0x94, 0x04, 0x35, 0x3F, 0x45,0x11,	// Date	-  Thur 23 Apr 1998 13:41:37 GMT
	0x3F,	
	0x45,
	0x11
	};

// Header for 2nd part of message - corrupt values arbitarily chosen
const TUint8 KHeaderPart2Corrupt[]=
	{
	0x0F,	// part 1 header size
	0x2F,	// part 1 body size
	0x2B,	// content type corrupt
	0x02,0x34,0x2E,0x15,0x59, 0xA1,	
	0x3F,	
	0x45,
	0x11, 
	0x64,
	0xFF,
	0x93
	};



// Part 1 Valid Message body
const TUint8 KPart1BodyValid[]=
	{
	// Body - slc (www.schmookie.com)
	0x01, 0x06, 0x6A, 0x00, 0x85, 0x09, 0x03, 0x6D, 0x6D, 0x6D,
	0x2E, 0x73, 0x63, 0x68, 0x6D, 0x6F, 0x6F, 0x6B, 0x69, 0x65,
	0x2E, 0x63, 0x6F, 0x64, 0x65, 0x2F, 0x00, 0x06, 0x01
	};		

// Corrupt 1st Part body 
const TUint8 KPart1BodyCorrupt[]=
	{
// junk
	0x01, 0x10, 0x1a, 0x1a, 0xff, 0xff,	0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	0xff, 0xff, 0x00, 0x00,
	0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,	0xdd, 0xdd, 0xdd
	};

// Part 1 Message body too short - has termination
const TUint8 KPart1BodyTooShort[]=
	{
	// Body - slc (www.schmookie.com)
	0x01, 0x06, 0x6A, 0x00, 0x85, 0x09, 0x03, 0x6D, 0x6D, 0x6D,
	0x2E, 0x73, 0x63, 0x68, 0x6D, 0x6F, 0x6F, 0x6B, 0x69, 0x65,
	0x00, 0x06, 0x01
	};	

// Part 1 Invalid Message body - greater than length given in valid header
const TUint8 KPart1BodyTooLong[]=
	{
	// Body - slc (www.schmookie.code/junk/)
	0x01, 0x06, 0x6A, 0x00, 0x85, 0x09, 0x03, 0x6D, 0x6D, 0x6D,
	0x2E, 0x73, 0x63, 0x68, 0x6D, 0x6F, 0x6F, 0x6B, 0x69, 0x65,
	0x2E, 0x63, 0x6F, 0x64, 0x65, 0x2F, 0x6A, 0x75, 0x6E, 0x6B, 
	0x2F, 0x00, 0x06, 0x01
	};	

// Part 1 Unterminated Message body - length correct
const TUint8 KPart1BodyUnterminated[]=
	{
	// Body - slc (www.schmookie.com)
	0x01, 0x06, 0x6A, 0x00, 0x85, 0x09, 0x03, 0x6D, 0x6D, 0x6D,
	0x2E, 0x73, 0x63, 0x68, 0x6D, 0x6F, 0x6F, 0x6B, 0x69, 0x65,
	0x2E, 0x63, 0x6F, 0x64, 0x65, 0x2F, 0x2F, 0x00, 0x06
	};	


// Part 1 Unterminated Message body - length correct
const TUint8 KPart1BodyNull[]=
	{
	// Empty Body
	0x00 
	};

// Part 2 Valid Message 
// SI message from WAP Push SI Specs
const TUint8 KPart2BodyValid[]=
	{
	0x01, 0x05, 0x6A, 0x12, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x2F,
	0x31, 0x32, 0x33, 0x2F, 0x61, 0x62, 0x63, 0x2E, 0x77, 0x6D,
	0x6C, 0x00, 0x45, 0xC6, 0x05, 0x0D, 0x03, 0x78, 0x79, 0x7A, 
	0x00, 0x85, 0x83, 0x00, 0x11, 0x03, 0x68, 0x74, 0x74, 0x70,
	0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x78, 0x79, 0x7A,
	0x00, 0x85, 0x83, 0x00, 0x0A, 0xC3, 0x07, 0x19, 0x99, 0x06,
	0x25, 0x15, 0x23, 0x15, 0x10, 0xC3, 0x04, 0x20, 0x01, 0x06,
	0x30, 0x01, 0x03, 0x20, 0x59, 0x6F, 0x75, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x20, 0x34, 0x20, 0x6E, 0x65, 0x77, 0x20, 0x65,
	0x6D, 0x61, 0x69, 0x6C, 0x73, 0x2E, 0x20, 0x00, 0x01, 0x01
	};



// Corrupt 2nd Part body 
const TUint8 KPart2BodyCorrupt[]=
	{
// Mangled SI message from WAP Push SI Specs
	0x01, 0x15, 0x6A, 0x12, 0x65, 0x22, 0x61, 0xDD, 0xEF, 0x2F,
	0x31, 0x2F, 0x33, 0x2F, 0x00, 0x01, 0x10, 0x2E, 0x77, 0x6D,
	0x02, 0x00, 0xDD, 0xFA, 0x05, 0x1D, 0x03, 0x78, 0x79, 0x7A, 
	0x00, 0xFE, 0x83, 0x00, 0x11, 0x03, 0x68, 0x74, 0x74, 0x70,
	0x00, 0x2F, 0x2F, 0x77, 0x77, 0x07, 0x2E, 0xEF, 0x04, 0x7A,
	0x00, 0x85, 0x83, 0x00, 0x0A, 0xC3, 0x07, 0x19, 0x99, 0x06,
	0x25, 0x17, 0x23, 0x15, 0x00, 0x10, 0x04, 0x20, 0x01, 0x06,
	0x30, 0x01, 0x03, 0x20, 0x56, 0x6F, 0x74, 0x20, 0x68, 0x61,
	0x76, 0x68, 0x20, 0x34, 0x20, 0x6E, 0x65, 0x77, 0x1F, 0x65,
	0x69, 0x61, 0x69, 0x6C, 0x73, 0xFF, 0x20, 0x00, 0x01, 0x01
	};

	
// Part 2 Invalid Message Body - too short but still terminated
const TUint8 KPart2BodyTooShort[]=
	{
	0x00, 0x05, 0x6A, 0x00, 0x45, //5
	0xC6, 0x0D, 0x03, 0x78, 0x79, 
	0x7A, 0x85, 0x03, 0x65, 0x6D, 
	0x61, 0x69, 0x6C, 0x2F, 0x31, //20
	0x32, 0x33, 0x2F, 0x61, 0x62, 
	0x63, 0x2E, 0x77, 0x6D, 0x6C, //30
	0x00, 0x0A, 0xC3, 0x07, 0x19, 
	0x99, 0x06, 0x25, 0x15, 0x23, //40
	0x15, 0x10, 0xC3, 0x04, 0x19, 
	0x99, 0x06, 0x30, 0x01, 0x03, //50
	0x59, 0x6F, 0x75, 0x20, 0x68, 
	 0x01,	0x01
	};

// Part 2 Valid Message 
const TUint8 KPart2BodyTooLong[]=
	{
	0x01, 0x05, 0x6A, 0x12, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x2F,
	0x31, 0x32, 0x33, 0x2F, 0x61, 0x62, 0x63, 0x2E, 0x77, 0x6D,
	0x6C, 0x00, 0x45, 0xC6, 0x05, 0x0D, 0x03, 0x78, 0x79, 0x7A, 
	0x00, 0x85, 0x83, 0x00, 0x11, 0x03, 0x68, 0x74, 0x74, 0x70,
	0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x78, 0x79, 0x7A,
	0x00, 0x85, 0x83, 0x2F, 0x61, 0x62, 0x63, 0x64, 0x65, 0x00, 
	0x0A, 0xC3, 0x07, 0x19, 0x99, 0x06, 0x25, 0x15, 0x23, 0x15, 
	0x10, 0xC3, 0x04, 0x20, 0x01, 0x06,	0x30, 0x01, 0x03, 0x20, 
	0x59, 0x6F, 0x75, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x34, 
	0x20, 0x6E, 0x65, 0x77, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 
	0x73, 0x2E, 0x20, 0x00, 0x01, 0x01
	};

// Part 2 Unterminated SI  Message - length correct
const TUint8 KPart2BodyUnterminated[]=
	{
	0x01, 0x05, 0x6A, 0x12, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x2F,
	0x31, 0x32, 0x33, 0x2F, 0x61, 0x62, 0x63, 0x2E, 0x77, 0x6D,
	0x6C, 0x00, 0x45, 0xC6, 0x05, 0x0D, 0x03, 0x78, 0x79, 0x7A, 
	0x00, 0x85, 0x83, 0x00, 0x11, 0x03, 0x68, 0x74, 0x74, 0x70,
	0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x78, 0x79, 0x7A,
	0x00, 0x85, 0x83, 0x00, 0x0A, 0xC3, 0x07, 0x19, 0x99, 0x06,
	0x25, 0x15, 0x23, 0x15, 0x10, 0xC3, 0x04, 0x20, 0x01, 0x06,
	0x30, 0x01, 0x03, 0x20, 0x59, 0x6F, 0x75, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x20, 0x34, 0x20, 0x6E, 0x65, 0x77, 0x20, 0x65,
	0x6D, 0x61, 0x69, 0x6C, 0x73, 0x2E, 0x20, 0x2E, 0x00, 0x01
	};

#endif
