// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __T_PERFORMANCEINITIALISATIONCLIENT_H__
#define __T_PERFORMANCEINITIALISATIONCLIENT_H__

#include "emailtestutils.h"
#include <iapprefs.h>
#include <cemailaccounts.h>
#include <imapconnectionobserver.h>
#include <test/testexecutestepbase.h>
#include "T_PerformanceStepBase.h"

// For loading the serial comms device drivers 
#if defined (__WINS__)
	#define PDD_NAME		_L("ECDRV")
    #define LDD_NAME		_L("ECOMM")
#else
	#define PDD_NAME		_L("EUART1")
	#define LDD_NAME		_L("ECOMM")
#endif

class CPerformanceInitialisationClient : public CActive , public MMsvImapConnectionObserver
	{

public:
	static CPerformanceInitialisationClient* NewL(CPerformanceStepBase& aTestStep);
	static CPerformanceInitialisationClient* NewLC(CPerformanceStepBase& aTestStep);
	~CPerformanceInitialisationClient();
	void Start();
	void DeleteRemoteMessagesL();
	void UploadMessagesL();
	void CreateMessageL(const TMsvId aTMsvId,TInt aCount,TDesC& aBody,TPtrC& aAddress,TDesC& aSubject,TDesC& aAttachment1,TDesC& aAttachment2,TDesC& aAttachment3);
private:
	CPerformanceInitialisationClient(CPerformanceStepBase& aTestStep);
	void ConstructL();
	virtual void DoCancel();
	virtual void RunL();
	virtual TInt RunError(TInt aError);
	void CompleteSelf();
	//implementation of pure virtual inherited from MMsvImapConnectionObserver 
	virtual void HandleImapConnectionEvent(TImapConnectionEvent aConnectionState);
private:

	enum TIMAPClientState 
		{
		EConnectAndSync=0,
		EWait,
		EDeleteRemoteEntries,
		EUploadMessages,
		EDisconnect, 
		EComplete
		};
		
	TImapAccount iImapAccount;
	TSmtpAccount iSmtpAccount;
	CMsvSession* iSession;
	CBaseMtm* iClientMtm;
	CClientMtmRegistry*	iClientRegistry;
	TDummySessionObserver*	iSessionObserver;
	CMsvOperation* iMsvOperation;
	TIMAPClientState iState;
	CMsvEntrySelection* iSelection;
	CPerformanceStepBase& iTestStep;
	TPckgBuf<TImImap4GetMailInfo> iPackage;
	CMsvEntry* iInboxEntry;
	CMsvEntrySelection* iChildren;
	CMsvOperation* iOperation;
	CTestActive* iTestActive;
	CMsvEntrySelection* iEntrySelectionToSend;
	CPerformanceInitialisationClient* iInitialisationClient;
	};
	

#endif  //__T_PERFORMANCEINITIALISATIONCLIENT_H__
