/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#include "pytable.h"

const TText16 KPinyin000[1] = {'a', };
const TInt charForPinyin000[8] = {
	0x554A, 0x963F, 0x5475, 0x5416, 0x55C4, 0x814C, 0x9515, 0x9312
	};
const TText16 KPinyin001[3] = {'a', 'e', 's', };
const TInt charForPinyin001[1] = {
	0x5391
	};
const TText16 KPinyin002[2] = {'a', 'i', };
const TInt charForPinyin002[92] = {
	0x7231, 0x77EE, 0x6328, 0x54CE, 0x788D, 0x764C, 0x827E, 0x5509, 0x54C0, 0x853C, 0x9698, 0x57C3, 0x7691, 0x5446, 0x55CC, 0x5AD2, 
	0x7477, 0x66A7, 0x6371, 0x7839, 0x55F3, 0x953F, 0x972D, 0x4E42, 0x4E43, 0x4F0C, 0x50FE, 0x5117, 0x51D2, 0x5240, 0x5274, 0x53C6, 
	0x5443, 0x545D, 0x5540, 0x560A, 0x566B, 0x566F, 0x5828, 0x5867, 0x58D2, 0x5947, 0x5A2D, 0x5A3E, 0x5B21, 0x5D66, 0x611B, 0x61D3, 
	0x61DD, 0x6571, 0x6573, 0x6639, 0x66D6, 0x6B2C, 0x6B38, 0x6BD0, 0x6EB0, 0x6EBE, 0x6FED, 0x70E0, 0x7125, 0x74A6, 0x769A, 0x76A7, 
	0x77B9, 0x784B, 0x78D1, 0x7919, 0x7D60, 0x8586, 0x85F9, 0x8AF0, 0x8B6A, 0x8B7A, 0x8CF9, 0x8EB7, 0x91B7, 0x9384, 0x9440, 0x95A1, 
	0x9602, 0x9628, 0x9638, 0x9691, 0x9744, 0x9749, 0x9932, 0x99A4, 0x9A03, 0x9BE6, 0x9C6B, 0x9D31
	};
const TText16 KPinyin003[2] = {'a', 'n', };
const TInt charForPinyin003[75] = {
	0x6309, 0x5B89, 0x6697, 0x5CB8, 0x4FFA, 0x6848, 0x978D, 0x6C28, 0x80FA, 0x5382, 0x5E7F, 0x5EB5, 0x63DE, 0x72B4, 0x94F5, 0x6849, 
	0x8C19, 0x9E4C, 0x57EF, 0x9EEF, 0x4F92, 0x5111, 0x533C, 0x5388, 0x54B9, 0x5535, 0x557D, 0x57B5, 0x57BE, 0x5813, 0x5A69, 0x5A95, 
	0x5C7D, 0x5CD6, 0x5E72, 0x667B, 0x6D1D, 0x73B5, 0x75F7, 0x76D2, 0x76E6, 0x76EB, 0x78AA, 0x7F6F, 0x8164, 0x834C, 0x83F4, 0x843B, 
	0x844A, 0x84ED, 0x88FA, 0x8A9D, 0x8AF3, 0x8C7B, 0x8C8B, 0x9043, 0x9257, 0x92A8, 0x930C, 0x94B3, 0x95C7, 0x9670, 0x9682, 0x968C, 
	0x96F8, 0x978C, 0x97FD, 0x9807, 0x981E, 0x9878, 0x99A3, 0x9B9F, 0x9D33, 0x9D6A, 0x9D95
	};
const TText16 KPinyin004[3] = {'a', 'n', 'g', };
const TInt charForPinyin004[11] = {
	0x6602, 0x80AE, 0x76CE, 0x4EF0, 0x536C, 0x5C87, 0x663B, 0x678A, 0x9183, 0x91A0, 0x9AAF
	};
const TText16 KPinyin005[2] = {'a', 'o', };
const TInt charForPinyin005[79] = {
	0x8884, 0x51F9, 0x50B2, 0x5965, 0x71AC, 0x61CA, 0x6556, 0x7FF1, 0x6FB3, 0x56A3, 0x62D7, 0x5AAA, 0x5ED2, 0x9A9C, 0x55F7, 0x5773, 
	0x9068, 0x8071, 0x87AF, 0x7352, 0x93CA, 0x9CCC, 0x93D6, 0x5C99, 0x53AB, 0x55F8, 0x5662, 0x56BB, 0x56C2, 0x5787, 0x58BA, 0x58BD, 
	0x5961, 0x5967, 0x5ABC, 0x5AEF, 0x5CB0, 0x5D85, 0x5DB4, 0x6160, 0x6277, 0x629D, 0x646E, 0x64D9, 0x67EA, 0x688E, 0x68CD, 0x6CD1, 
	0x6D47, 0x6EF6, 0x6F86, 0x6F9A, 0x719D, 0x720A, 0x7353, 0x7488, 0x7711, 0x78DD, 0x78FD, 0x7909, 0x7FF6, 0x7FFA, 0x82BA, 0x851C, 
	0x8779, 0x8956, 0x8B37, 0x8B38, 0x8EEA, 0x90E9, 0x93D5, 0x957A, 0x969E, 0x9A41, 0x9C32, 0x9D01, 0x9D22, 0x9DD4, 0x9F07
	};
const TText16 KPinyin006[2] = {'b', 'a', };
const TInt charForPinyin006[76] = {
	0x628A, 0x516B, 0x5427, 0x7238, 0x62D4, 0x7F62, 0x8DCB, 0x5DF4, 0x82AD, 0x6252, 0x575D, 0x9738, 0x53ED, 0x9776, 0x7B06, 0x75A4, 
	0x8019, 0x634C, 0x7C91, 0x8307, 0x5C9C, 0x9C85, 0x94AF, 0x9B43, 0x83DD, 0x705E, 0x4EC8, 0x4F2F, 0x53D0, 0x54F1, 0x54F5, 0x577A, 
	0x57BB, 0x58A2, 0x58E9, 0x593F, 0x59AD, 0x5CC7, 0x5F1D, 0x629C, 0x62AA, 0x636D, 0x6733, 0x6777, 0x67ED, 0x6B1B, 0x6E43, 0x70A6, 
	0x72AE, 0x7390, 0x7679, 0x7685, 0x77F2, 0x7B29, 0x7D26, 0x7F77, 0x7F93, 0x80C8, 0x8337, 0x8406, 0x8686, 0x8987, 0x8A59, 0x8C5D, 
	0x8DC1, 0x8EF7, 0x91DB, 0x91DF, 0x9200, 0x98B0, 0x9B5E, 0x9B81, 0x9B8A, 0x9C83, 0x9C8C, 0x9F25
	};
const TText16 KPinyin007[3] = {'b', 'a', 'i', };
const TInt charForPinyin007[34] = {
	0x767E, 0x767D, 0x6446, 0x8D25, 0x67CF, 0x62DC, 0x4F70, 0x4F2F, 0x7A17, 0x636D, 0x5457, 0x63B0, 0x5504, 0x5E8D, 0x6252, 0x62DD, 
	0x6300, 0x6392, 0x64FA, 0x6557, 0x6822, 0x6D3E, 0x7308, 0x7AE1, 0x7CA8, 0x7CBA, 0x7D54, 0x859C, 0x85AD, 0x896C, 0x8D01, 0x9781, 
	0x97B4, 0x97DB
	};
const TText16 KPinyin008[5] = {'b', 'a', 'i', 'k', 'e', };
const TInt charForPinyin008[1] = {
	0x5161
	};
const TText16 KPinyin009[5] = {'b', 'a', 'i', 'w', 'a', };
const TInt charForPinyin009[1] = {
	0x74F8
	};
const TText16 KPinyin010[3] = {'b', 'a', 'n', };
const TInt charForPinyin010[62] = {
	0x534A, 0x529E, 0x73ED, 0x822C, 0x62CC, 0x642C, 0x7248, 0x6591, 0x677F, 0x4F34, 0x6273, 0x626E, 0x74E3, 0x9881, 0x7ECA, 0x764D, 
	0x5742, 0x94A3, 0x8228, 0x962A, 0x7622, 0x4E26, 0x5206, 0x5762, 0x57FF, 0x59C5, 0x5C85, 0x5F6C, 0x6011, 0x642B, 0x653D, 0x6592, 
	0x6604, 0x670C, 0x67C8, 0x6E74, 0x74EA, 0x79DA, 0x7C53, 0x7C84, 0x7D46, 0x80A6, 0x8742, 0x8781, 0x878C, 0x8929, 0x8982, 0x8C73, 
	0x8DD8, 0x8FA6, 0x8FA7, 0x8FA8, 0x8FA9, 0x8FAC, 0x8FAF, 0x9211, 0x9261, 0x95C6, 0x977D, 0x9812, 0x9B6C, 0x9CFB
	};
const TText16 KPinyin011[4] = {'b', 'a', 'n', 'g', };
const TInt charForPinyin011[51] = {
	0x5E2E, 0x68D2, 0x7ED1, 0x78C5, 0x9551, 0x90A6, 0x699C, 0x868C, 0x508D, 0x6886, 0x8180, 0x8C24, 0x6D5C, 0x84A1, 0x4E26, 0x55D9, 
	0x57B9, 0x57F2, 0x585D, 0x5ACE, 0x5CC0, 0x5D17, 0x5E47, 0x5E5A, 0x5E6B, 0x5F6D, 0x5FAC, 0x6337, 0x6360, 0x6412, 0x65C1, 0x68D3, 
	0x7253, 0x73A4, 0x7865, 0x7A16, 0x7D21, 0x7D81, 0x7E0D, 0x7EBA, 0x8255, 0x8684, 0x86D6, 0x872F, 0x8783, 0x8B17, 0x90AB, 0x938A, 
	0x97A4, 0x9A2F, 0x9AC8
	};
const TText16 KPinyin012[3] = {'b', 'a', 'o', };
const TInt charForPinyin012[78] = {
	0x5305, 0x62B1, 0x62A5, 0x9971, 0x4FDD, 0x66B4, 0x8584, 0x5B9D, 0x7206, 0x5265, 0x8C79, 0x5228, 0x96F9, 0x8912, 0x5821, 0x82DE, 
	0x80DE, 0x9C8D, 0x70AE, 0x7011, 0x9F85, 0x5B62, 0x7172, 0x8913, 0x9E28, 0x8DB5, 0x8446, 0x4F68, 0x5124, 0x525D, 0x52F9, 0x52FD, 
	0x5446, 0x5610, 0x5697, 0x5822, 0x5831, 0x5AAC, 0x5AD1, 0x5BDA, 0x5BF3, 0x5BF6, 0x5FC1, 0x6009, 0x66D3, 0x67B9, 0x73E4, 0x7832, 
	0x7A87, 0x7B23, 0x7C3F, 0x7DE5, 0x83E2, 0x8554, 0x85F5, 0x8663, 0x86AB, 0x888C, 0x888D, 0x88D2, 0x88E6, 0x8943, 0x8CF2, 0x924B, 
	0x9464, 0x94C7, 0x95C1, 0x974C, 0x9764, 0x98F9, 0x98FD, 0x99C2, 0x9AB2, 0x9AF1, 0x9B91, 0x9CF5, 0x9D07, 0x9F59
	};
const TText16 KPinyin013[2] = {'b', 'e', };
const TInt charForPinyin013[1] = {
	0x8421
	};
const TText16 KPinyin014[3] = {'b', 'e', 'i', };
const TInt charForPinyin014[84] = {
	0x88AB, 0x5317, 0x500D, 0x676F, 0x80CC, 0x60B2, 0x5907, 0x7891, 0x5351, 0x8D1D, 0x8F88, 0x94A1, 0x7119, 0x72C8, 0x60EB, 0x81C2, 
	0x8919, 0x6096, 0x84D3, 0x9E4E, 0x943E, 0x5457, 0x90B6, 0x97B4, 0x5B5B, 0x9642, 0x789A, 0x4FFB, 0x4FFE, 0x505D, 0x5079, 0x5099, 
	0x50C3, 0x54F1, 0x5504, 0x55BA, 0x57BB, 0x57E4, 0x602B, 0x6102, 0x618A, 0x63F9, 0x6601, 0x676E, 0x67F8, 0x686E, 0x6896, 0x68D1, 
	0x68D3, 0x6911, 0x6CE2, 0x726C, 0x7295, 0x72FD, 0x73FC, 0x7432, 0x75FA, 0x76C3, 0x7999, 0x7B83, 0x7CD2, 0x82DD, 0x8300, 0x83E9, 
	0x8406, 0x842F, 0x8461, 0x85E3, 0x86FD, 0x871A, 0x896C, 0x8A96, 0x8AC0, 0x8C9D, 0x8DCB, 0x8EF0, 0x8F29, 0x9101, 0x9273, 0x92C7, 
	0x930D, 0x9434, 0x9AB3, 0x9D6F
	};
const TText16 KPinyin015[3] = {'b', 'e', 'n', };
const TInt charForPinyin015[31] = {
	0x672C, 0x5954, 0x82EF, 0x7B28, 0x592F, 0x951B, 0x8D32, 0x755A, 0x574C, 0x4F53, 0x5034, 0x55AF, 0x5932, 0x5959, 0x6379, 0x64AA, 
	0x6873, 0x694D, 0x6CCD, 0x6E00, 0x7083, 0x71CC, 0x7287, 0x7356, 0x7FC9, 0x87E6, 0x8CC1, 0x8F3D, 0x9029, 0x931B, 0x943C
	};
const TText16 KPinyin016[4] = {'b', 'e', 'n', 'g', };
const TInt charForPinyin016[44] = {
	0x8E66, 0x7EF7, 0x752D, 0x5D29, 0x8FF8, 0x868C, 0x6CF5, 0x750F, 0x5623, 0x4F3B, 0x4FF8, 0x508D, 0x50B0, 0x552A, 0x55D9, 0x57C4, 
	0x57F2, 0x580B, 0x5874, 0x595F, 0x5D6D, 0x5E73, 0x62A8, 0x6337, 0x6412, 0x65C1, 0x699C, 0x6F28, 0x71A2, 0x7423, 0x742B, 0x75ED, 
	0x794A, 0x7D63, 0x7DB3, 0x7E43, 0x83F6, 0x8DF0, 0x902C, 0x930B, 0x93F0, 0x955A, 0x958D, 0x979B
	};
const TText16 KPinyin017[2] = {'b', 'i', };
const TInt charForPinyin017[219] = {
	0x6BD4, 0x7B14, 0x95ED, 0x9F3B, 0x78A7, 0x5FC5, 0x907F, 0x903C, 0x6BD5, 0x81C2, 0x5F7C, 0x9119, 0x58C1, 0x84D6, 0x5E01, 0x5F0A, 
	0x8F9F, 0x853D, 0x6BD9, 0x5E87, 0x655D, 0x965B, 0x6BD6, 0x75F9, 0x79D8, 0x6CCC, 0x79D5, 0x859C, 0x8378, 0x8298, 0x8406, 0x5315, 
	0x88E8, 0x7540, 0x4FFE, 0x5B16, 0x72F4, 0x7B5A, 0x7B85, 0x7BE6, 0x822D, 0x835C, 0x895E, 0x5EB3, 0x94CB, 0x8DF8, 0x5421, 0x610E, 
	0x8D32, 0x6ED7, 0x6FDE, 0x74A7, 0x54D4, 0x9AC0, 0x5F3C, 0x59A3, 0x5A62, 0x4EF3, 0x4F4A, 0x4F56, 0x4F5B, 0x506A, 0x5302, 0x5351, 
	0x5487, 0x555A, 0x55F6, 0x5752, 0x57E4, 0x581B, 0x590D, 0x5936, 0x5970, 0x59BC, 0x5A1D, 0x5AB2, 0x5B36, 0x5C44, 0x5D25, 0x5E45, 
	0x5E63, 0x5E64, 0x5E80, 0x5EE6, 0x5F3B, 0x5F43, 0x602D, 0x6036, 0x6082, 0x610A, 0x62C2, 0x636D, 0x6583, 0x65C7, 0x670D, 0x673C, 
	0x6787, 0x6788, 0x67C0, 0x67F2, 0x6890, 0x6911, 0x6945, 0x6A97, 0x6B8D, 0x6BF4, 0x6C98, 0x6CE2, 0x6E62, 0x6EED, 0x6F77, 0x714F, 
	0x719A, 0x7358, 0x7359, 0x73CC, 0x7541, 0x7550, 0x7562, 0x7595, 0x75AA, 0x75FA, 0x7680, 0x7695, 0x77A5, 0x7986, 0x7A2B, 0x7B13, 
	0x7B46, 0x7B83, 0x7B84, 0x7B86, 0x7BF3, 0x7C83, 0x7C8A, 0x7D15, 0x7D34, 0x7DBC, 0x7E2A, 0x7E74, 0x7EB0, 0x7F77, 0x7F7C, 0x7FCD, 
	0x805B, 0x80B6, 0x80B8, 0x80C7, 0x813E, 0x8157, 0x8177, 0x82FE, 0x841E, 0x84FD, 0x8617, 0x8651, 0x870C, 0x8795, 0x8890, 0x88AB, 
	0x8945, 0x8963, 0x89F1, 0x8A56, 0x8BD0, 0x8C4D, 0x8C8F, 0x8CB1, 0x8CBB, 0x8CC1, 0x8D14, 0x8D39, 0x8D51, 0x8DDB, 0x8E3E, 0x8E55, 
	0x8E83, 0x8E84, 0x90B2, 0x9128, 0x912A, 0x921A, 0x924D, 0x930D, 0x939E, 0x93CE, 0x9434, 0x943E, 0x9587, 0x9588, 0x9589, 0x959F, 
	0x95EC, 0x9642, 0x9674, 0x9781, 0x979E, 0x97B8, 0x97E0, 0x98F6, 0x9946, 0x999D, 0x99A5, 0x99DC, 0x9A46, 0x9AF2, 0x9B53, 0x9B6E, 
	0x9B85, 0x9BA9, 0x9C0F, 0x9CBE, 0x9D13, 0x9D56, 0x9D9D, 0x9DDD, 0x9DE9, 0x9E0A, 0x9F0A
	};
const TText16 KPinyin018[4] = {'b', 'i', 'a', 'n', };
const TInt charForPinyin018[76] = {
	0x8FB9, 0x53D8, 0x4FBF, 0x904D, 0x7F16, 0x8FA9, 0x6241, 0x8D2C, 0x97AD, 0x535E, 0x8FA8, 0x8FAB, 0x5FED, 0x782D, 0x533E, 0x6C74, 
	0x78A5, 0x8759, 0x890A, 0x9CCA, 0x7B3E, 0x82C4, 0x7A86, 0x5F01, 0x9ADF, 0x7F0F, 0x7178, 0x5909, 0x5C01, 0x5CC5, 0x5FA7, 0x60FC, 
	0x6283, 0x62DA, 0x63D9, 0x662A, 0x6C73, 0x709E, 0x7251, 0x7335, 0x7371, 0x7502, 0x75BA, 0x7A28, 0x7A39, 0x7BAF, 0x7C69, 0x7CC4, 
	0x7DE8, 0x7DF6, 0x81F1, 0x8251, 0x8439, 0x85CA, 0x898D, 0x89B5, 0x8B8A, 0x8C4D, 0x8CB6, 0x8FA1, 0x8FA6, 0x8FA7, 0x8FAE, 0x8FAF, 
	0x9089, 0x908A, 0x90B2, 0x91C6, 0x937D, 0x959E, 0x9795, 0x9828, 0x9BFE, 0x9BFF, 0x9D18, 0x9DA3
	};
const TText16 KPinyin019[4] = {'b', 'i', 'a', 'o', };
const TInt charForPinyin019[62] = {
	0x8868, 0x6807, 0x5F6A, 0x8198, 0x6753, 0x5A4A, 0x98D1, 0x98D9, 0x9CD4, 0x762D, 0x98DA, 0x9573, 0x88F1, 0x9AA0, 0x9556, 0x4FF5, 
	0x50C4, 0x5126, 0x527D, 0x5882, 0x5AD6, 0x5E56, 0x5FB1, 0x647D, 0x6A19, 0x6AA6, 0x6DF2, 0x6EEE, 0x6F02, 0x700C, 0x706C, 0x719B, 
	0x7202, 0x730B, 0x7A6E, 0x7BFB, 0x813F, 0x8194, 0x81D5, 0x82DE, 0x8508, 0x85E8, 0x893E, 0x8AD8, 0x8B24, 0x8D06, 0x9336, 0x93D6, 
	0x93E2, 0x9463, 0x98AE, 0x98B7, 0x98C6, 0x98C7, 0x98C8, 0x98CA, 0x9A43, 0x9A6B, 0x9A89, 0x9ADF, 0x9C3E, 0x9E83
	};
const TText16 KPinyin020[3] = {'b', 'i', 'e', };
const TInt charForPinyin020[30] = {
	0x522B, 0x618B, 0x9CD6, 0x762A, 0x8E69, 0x5225, 0x5487, 0x5F46, 0x5FB6, 0x6252, 0x62D4, 0x634C, 0x6486, 0x6487, 0x67ED, 0x67F2, 
	0x7330, 0x765F, 0x79D8, 0x7A6A, 0x82FE, 0x8382, 0x853D, 0x864C, 0x86C2, 0x87DE, 0x8952, 0x9C49, 0x9F08, 0x9F9E
	};
const TText16 KPinyin021[3] = {'b', 'i', 'n', };
const TInt charForPinyin021[50] = {
	0x5BBE, 0x6FD2, 0x6448, 0x5F6C, 0x658C, 0x6EE8, 0x8C73, 0x8191, 0x6BA1, 0x7F24, 0x9ACC, 0x50A7, 0x69DF, 0x9B13, 0x9554, 0x73A2, 
	0x4EFD, 0x5110, 0x64EF, 0x6915, 0x6BAF, 0x6C1E, 0x6C43, 0x6D5C, 0x6FF1, 0x6FF5, 0x7015, 0x7478, 0x74B8, 0x780F, 0x7E7D, 0x81CF, 
	0x8668, 0x8819, 0x8A1C, 0x8C69, 0x8CD3, 0x8CD4, 0x8D07, 0x8D5F, 0x90A0, 0x944C, 0x9726, 0x983B, 0x986E, 0x9891, 0x9AD5, 0x9AE9, 
	0x9B02, 0x9B22
	};
const TText16 KPinyin022[4] = {'b', 'i', 'n', 'g', };
const TInt charForPinyin022[67] = {
	0x5E76, 0x75C5, 0x5175, 0x51B0, 0x4E19, 0x997C, 0x5C4F, 0x79C9, 0x67C4, 0x70B3, 0x6452, 0x69DF, 0x7980, 0x90B4, 0x4E26, 0x4ECC, 
	0x4F75, 0x5002, 0x504B, 0x50A1, 0x51AB, 0x57AA, 0x5BCE, 0x5E73, 0x5E77, 0x5EB0, 0x6032, 0x62A6, 0x62FC, 0x63A4, 0x661E, 0x663A, 
	0x678B, 0x681F, 0x6824, 0x68B9, 0x68C5, 0x6AB3, 0x6C37, 0x71F7, 0x71F9, 0x7415, 0x75ED, 0x765B, 0x765D, 0x772A, 0x7A1F, 0x7A89, 
	0x7ADD, 0x7D63, 0x7D86, 0x7EE0, 0x82EA, 0x86C3, 0x8A81, 0x8DF0, 0x9235, 0x927C, 0x92F2, 0x9643, 0x9750, 0x9786, 0x979E, 0x97B8, 
	0x9905, 0x9920, 0x9BA9
	};
const TText16 KPinyin023[2] = {'b', 'o', };
const TInt charForPinyin023[158] = {
	0x62E8, 0x6CE2, 0x64AD, 0x6CCA, 0x535A, 0x4F2F, 0x9A73, 0x73BB, 0x5265, 0x8584, 0x52C3, 0x83E0, 0x94B5, 0x640F, 0x8116, 0x5E1B, 
	0x822C, 0x67CF, 0x8236, 0x6E24, 0x94C2, 0x7B94, 0x818A, 0x9B44, 0x535C, 0x7934, 0x8DDB, 0x6A97, 0x4EB3, 0x9E41, 0x8E23, 0x5575, 
	0x8543, 0x7C38, 0x94B9, 0x997D, 0x64D8, 0x4EE2, 0x4F5B, 0x4FBC, 0x50E0, 0x50F0, 0x525D, 0x52DF, 0x54F1, 0x5643, 0x5697, 0x58C6, 
	0x59AD, 0x5B5B, 0x5B79, 0x5D93, 0x5E17, 0x5F74, 0x6015, 0x613D, 0x61EA, 0x62CD, 0x62D4, 0x632C, 0x64A5, 0x64D7, 0x66B4, 0x670D, 
	0x67ED, 0x6872, 0x6991, 0x6A98, 0x6B02, 0x6B95, 0x6CFC, 0x6D61, 0x6DFF, 0x6E50, 0x6F51, 0x6F58, 0x7011, 0x717F, 0x7206, 0x7254, 
	0x72A6, 0x72BB, 0x72DB, 0x733C, 0x74DD, 0x74DF, 0x756A, 0x7676, 0x767C, 0x767D, 0x767E, 0x76AA, 0x76CB, 0x7835, 0x7886, 0x78FB, 
	0x7921, 0x79E1, 0x7A5B, 0x7B29, 0x7BA5, 0x7C19, 0x7C3F, 0x7CEA, 0x7D34, 0x7F3D, 0x8091, 0x80C9, 0x824A, 0x8274, 0x82E9, 0x8300, 
	0x8337, 0x83E9, 0x8467, 0x84B2, 0x8514, 0x8522, 0x859C, 0x8616, 0x8617, 0x86BE, 0x889A, 0x88AF, 0x88B9, 0x894E, 0x894F, 0x896E, 
	0x8A59, 0x8B52, 0x8C70, 0x8DB5, 0x8DD1, 0x8E73, 0x90E3, 0x9238, 0x9251, 0x9262, 0x92CD, 0x939B, 0x946E, 0x9548, 0x9911, 0x993A, 
	0x998E, 0x999B, 0x999E, 0x99C1, 0x99EE, 0x9A4B, 0x9AC6, 0x9AC9, 0x9B81, 0x9B8A, 0x9C4D, 0x9C85, 0x9C8C, 0x9D53
	};
const TText16 KPinyin024[2] = {'b', 'u', };
const TInt charForPinyin024[66] = {
	0x4E0D, 0x6B65, 0x8865, 0x5E03, 0x90E8, 0x6355, 0x535C, 0x7C3F, 0x54FA, 0x5821, 0x57E0, 0x6016, 0x57D4, 0x74FF, 0x900B, 0x6661, 
	0x94B8, 0x949A, 0x91AD, 0x535F, 0x4F48, 0x50D5, 0x52CF, 0x5425, 0x5498, 0x57D7, 0x5A44, 0x5C03, 0x5CEC, 0x5EAF, 0x5ECD, 0x6091, 
	0x62AA, 0x62CA, 0x6357, 0x636C, 0x64B2, 0x64C8, 0x67E8, 0x6B68, 0x6B69, 0x6EA5, 0x735B, 0x79FF, 0x7B81, 0x7BF0, 0x8379, 0x8500, 
	0x8584, 0x88DC, 0x8AA7, 0x8E04, 0x8F39, 0x8F50, 0x90F6, 0x9208, 0x923D, 0x9644, 0x9660, 0x97B4, 0x9914, 0x9922, 0x9BC6, 0x9CEA, 
	0x9D4F, 0x9E14
	};
const TText16 KPinyin025[2] = {'c', 'a', };
const TInt charForPinyin025[12] = {
	0x64E6, 0x62C6, 0x7924, 0x5693, 0x50AA, 0x56C3, 0x6503, 0x6A74, 0x78E3, 0x7938, 0x8521, 0x906A
	};
const TText16 KPinyin026[3] = {'c', 'a', 'i', };
const TInt charForPinyin026[27] = {
	0x624D, 0x83DC, 0x91C7, 0x6750, 0x8D22, 0x88C1, 0x731C, 0x8E29, 0x776C, 0x8521, 0x5F69, 0x5038, 0x5072, 0x554B, 0x57F0, 0x5A47, 
	0x5BC0, 0x621D, 0x6250, 0x63A1, 0x63CC, 0x68CC, 0x7DB5, 0x7E29, 0x7E94, 0x8CA1, 0x8DF4
	};
const TText16 KPinyin027[3] = {'c', 'a', 'l', };
const TInt charForPinyin027[1] = {
	0x4E72
	};
const TText16 KPinyin028[3] = {'c', 'a', 'n', };
const TInt charForPinyin028[54] = {
	0x8695, 0x6B8B, 0x63BA, 0x53C2, 0x60E8, 0x60ED, 0x9910, 0x707F, 0x9A96, 0x74A8, 0x5B71, 0x9EEA, 0x7CB2, 0x50AA, 0x510F, 0x53C3, 
	0x53C4, 0x53C5, 0x55B0, 0x5607, 0x5646, 0x56CB, 0x5B20, 0x5B31, 0x5D7E, 0x6158, 0x6159, 0x615A, 0x61AF, 0x6214, 0x6472, 0x6701, 
	0x6B98, 0x6DFA, 0x6E4C, 0x6FAF, 0x71E6, 0x7218, 0x7A47, 0x7BF8, 0x8592, 0x8745, 0x8836, 0x883A, 0x8B32, 0x8E54, 0x93D2, 0x98E1, 
	0x98F1, 0x9A42, 0x9BF5, 0x9C3A, 0x9CB9, 0x9EF2
	};
const TText16 KPinyin029[4] = {'c', 'a', 'n', 'g', };
const TInt charForPinyin029[28] = {
	0x85CF, 0x4ED3, 0x6CA7, 0x8231, 0x82CD, 0x4F27, 0x4EFA, 0x5009, 0x5096, 0x51D4, 0x5328, 0x5D62, 0x6B0C, 0x6EC4, 0x6FF8, 0x734A, 
	0x7472, 0x7BEC, 0x7F49, 0x81E7, 0x8259, 0x84BC, 0x8535, 0x87A5, 0x8CF6, 0x9476, 0x9DAC, 0x9E27
	};
const TText16 KPinyin030[3] = {'c', 'a', 'o', };
const TInt charForPinyin030[31] = {
	0x8349, 0x64CD, 0x66F9, 0x69FD, 0x7CD9, 0x5608, 0x825A, 0x87AC, 0x6F15, 0x50AE, 0x5C6E, 0x5D86, 0x613A, 0x6145, 0x6152, 0x61C6, 
	0x64A1, 0x66FA, 0x6FA1, 0x808F, 0x8278, 0x8279, 0x84F8, 0x893F, 0x8959, 0x9020, 0x9135, 0x93EA, 0x9430, 0x9A32, 0x9F1C
	};
const TText16 KPinyin031[2] = {'c', 'e', };
const TInt charForPinyin031[34] = {
	0x518C, 0x4FA7, 0x7B56, 0x6D4B, 0x5395, 0x607B, 0x5074, 0x518A, 0x53A0, 0x5884, 0x5AE7, 0x5E3B, 0x5E58, 0x5EC1, 0x60FB, 0x61A1, 
	0x62FA, 0x6547, 0x67F5, 0x6805, 0x6E2C, 0x755F, 0x7B27, 0x7B5E, 0x7B74, 0x7BA3, 0x7C0E, 0x7CA3, 0x835D, 0x8417, 0x8434, 0x84DB, 
	0x8D66, 0x9F70
	};
const TText16 KPinyin032[3] = {'c', 'e', 'n', };
const TInt charForPinyin032[14] = {
	0x53C2, 0x5C91, 0x6D94, 0x53C3, 0x53C4, 0x53C5, 0x5D7E, 0x68A3, 0x6C75, 0x7876, 0x7A47, 0x7B12, 0x7BF8, 0x81A5
	};
const TText16 KPinyin033[4] = {'c', 'e', 'n', 'g', };
const TInt charForPinyin033[13] = {
	0x66FE, 0x5C42, 0x8E6D, 0x564C, 0x50E7, 0x589E, 0x5C64, 0x5D92, 0x6A67, 0x7AF2, 0x7E52, 0x7F2F, 0x9A53
	};
const TText16 KPinyin034[4] = {'c', 'e', 'o', 'k', };
const TInt charForPinyin034[2] = {
	0x785B, 0x7873
	};
const TText16 KPinyin035[4] = {'c', 'e', 'o', 'm', };
const TInt charForPinyin035[1] = {
	0x5CBE
	};
const TText16 KPinyin036[4] = {'c', 'e', 'o', 'n', };
const TInt charForPinyin036[1] = {
	0x7320
	};
const TText16 KPinyin037[4] = {'c', 'e', 'o', 'r', };
const TInt charForPinyin037[1] = {
	0x4E7D
	};
const TText16 KPinyin038[3] = {'c', 'h', 'a', };
const TInt charForPinyin038[68] = {
	0x67E5, 0x63D2, 0x53C9, 0x8336, 0x5DEE, 0x5C94, 0x643D, 0x5BDF, 0x832C, 0x78B4, 0x5239, 0x8BE7, 0x6942, 0x69CE, 0x9572, 0x8869, 
	0x6C4A, 0x9987, 0x6AAB, 0x59F9, 0x6748, 0x9538, 0x5693, 0x4EDB, 0x4F98, 0x505B, 0x524E, 0x55CF, 0x571F, 0x579E, 0x597C, 0x5C8E, 
	0x5D56, 0x6260, 0x6271, 0x633F, 0x6348, 0x6377, 0x63A5, 0x63F7, 0x6456, 0x659C, 0x67FB, 0x688C, 0x7339, 0x7580, 0x79C5, 0x7D01, 
	0x809E, 0x81FF, 0x8256, 0x8286, 0x82F4, 0x8356, 0x837C, 0x8928, 0x8A0D, 0x8A67, 0x8A6B, 0x8E45, 0x91F5, 0x929F, 0x9364, 0x9388, 
	0x9454, 0x9497, 0x976B, 0x9937
	};
const TText16 KPinyin039[4] = {'c', 'h', 'a', 'i', };
const TInt charForPinyin039[27] = {
	0x67F4, 0x62C6, 0x5DEE, 0x8C7A, 0x9497, 0x7625, 0x867F, 0x4FAA, 0x5115, 0x52D1, 0x53C9, 0x558D, 0x56C6, 0x6260, 0x6413, 0x67E5, 
	0x72B2, 0x7961, 0x8308, 0x831D, 0x8515, 0x8806, 0x8883, 0x8A0D, 0x91F5, 0x9F5C, 0x9F87
	};
const TText16 KPinyin040[4] = {'c', 'h', 'a', 'n', };
const TInt charForPinyin040[138] = {
	0x4EA7, 0x7F20, 0x63BA, 0x6400, 0x9610, 0x98A4, 0x94F2, 0x8C17, 0x8749, 0x5355, 0x998B, 0x89C7, 0x5A75, 0x8487, 0x8C04, 0x5181, 
	0x5EDB, 0x5B71, 0x87FE, 0x7FBC, 0x9561, 0x5FCF, 0x6F7A, 0x7985, 0x9AA3, 0x8E94, 0x6FB6, 0x4E33, 0x4EB6, 0x4F54, 0x50DD, 0x50E4, 
	0x5103, 0x5133, 0x514E, 0x5154, 0x522C, 0x5257, 0x5277, 0x5296, 0x5358, 0x5398, 0x5574, 0x55AE, 0x563D, 0x56B5, 0x56C5, 0x5718, 
	0x58A0, 0x58E5, 0x5B0B, 0x5B17, 0x5D2D, 0x5D7C, 0x5D83, 0x5D84, 0x5DC9, 0x5E5D, 0x5E68, 0x619A, 0x61F4, 0x61FA, 0x63B8, 0x644C, 
	0x6472, 0x647B, 0x64A3, 0x6519, 0x65BA, 0x65F5, 0x68B4, 0x68CE, 0x6990, 0x6B03, 0x6BDA, 0x6CBE, 0x6D50, 0x6E10, 0x6E79, 0x6EFB, 
	0x6F38, 0x6F79, 0x700D, 0x703A, 0x705B, 0x7158, 0x71C0, 0x7351, 0x7522, 0x7523, 0x785F, 0x78DB, 0x79AA, 0x7C05, 0x7DC2, 0x7DFE, 
	0x7E5F, 0x7E75, 0x7E8F, 0x7E92, 0x80C0, 0x8120, 0x826C, 0x82EB, 0x8546, 0x87B9, 0x87EC, 0x87FA, 0x88A9, 0x88E3, 0x88E7, 0x894C, 
	0x895C, 0x895D, 0x8998, 0x8A97, 0x8AC2, 0x8B42, 0x8B87, 0x8B92, 0x8B96, 0x8C36, 0x8E4D, 0x8FBF, 0x913D, 0x9141, 0x91A6, 0x9246, 
	0x92CB, 0x92D3, 0x93DF, 0x9471, 0x9575, 0x95B3, 0x95E1, 0x97C2, 0x986B, 0x995E
	};
const TText16 KPinyin041[5] = {'c', 'h', 'a', 'n', 'g', };
const TInt charForPinyin041[78] = {
	0x957F, 0x5531, 0x5E38, 0x573A, 0x5382, 0x5C1D, 0x80A0, 0x7545, 0x660C, 0x655E, 0x5021, 0x507F, 0x7316, 0x88F3, 0x9CB3, 0x6C05, 
	0x83D6, 0x60DD, 0x5AE6, 0x5F9C, 0x9B2F, 0x960A, 0x6005, 0x4F25, 0x6636, 0x82CC, 0x5A3C, 0x4EE7, 0x5000, 0x5018, 0x50D8, 0x511F, 
	0x513B, 0x514F, 0x53B0, 0x5617, 0x5690, 0x5834, 0x5872, 0x5C19, 0x5C1A, 0x5EE0, 0x60B5, 0x667F, 0x66A2, 0x68D6, 0x6919, 0x6DCC, 
	0x6DD0, 0x713B, 0x739A, 0x7429, 0x7452, 0x747A, 0x74FA, 0x751E, 0x757C, 0x8139, 0x8178, 0x8193, 0x8407, 0x87D0, 0x88EE, 0x8AAF, 
	0x92F9, 0x92FF, 0x9329, 0x93DB, 0x9520, 0x9577, 0x9578, 0x95B6, 0x95DB, 0x97D4, 0x9BE7, 0x9C68, 0x9CBF, 0x9F1A
	};
const TText16 KPinyin042[4] = {'c', 'h', 'a', 'o', };
const TInt charForPinyin042[58] = {
	0x671D, 0x6284, 0x8D85, 0x5435, 0x6F6E, 0x5DE2, 0x7092, 0x5632, 0x527F, 0x7EF0, 0x949E, 0x600A, 0x712F, 0x8016, 0x6641, 0x4EE6, 
	0x4EEF, 0x528B, 0x52E6, 0x5520, 0x562E, 0x5DD0, 0x5DE3, 0x5F28, 0x6477, 0x69F1, 0x6A14, 0x6B29, 0x6D9B, 0x6F05, 0x6FE4, 0x7123, 
	0x717C, 0x724A, 0x7727, 0x7AB2, 0x7C86, 0x7D39, 0x7DA4, 0x7DBD, 0x7E10, 0x7E5B, 0x7EC9, 0x7ECD, 0x7F7A, 0x89D8, 0x8A2C, 0x8B05, 
	0x8B3F, 0x8BCC, 0x8DA0, 0x8DAB, 0x8F48, 0x911B, 0x9214, 0x9EA8, 0x9F02, 0x9F0C
	};
const TText16 KPinyin043[3] = {'c', 'h', 'e', };
const TInt charForPinyin043[42] = {
	0x8F66, 0x64A4, 0x626F, 0x63A3, 0x5F7B, 0x5C3A, 0x6F88, 0x577C, 0x7817, 0x4F21, 0x4FE5, 0x5056, 0x52F6, 0x546B, 0x5513, 0x55A2, 
	0x591A, 0x591B, 0x5972, 0x5B85, 0x5C6E, 0x5FB9, 0x63CA, 0x6470, 0x64A6, 0x65A5, 0x6C60, 0x70E2, 0x70F2, 0x710E, 0x7221, 0x77AE, 
	0x7868, 0x7869, 0x8045, 0x8397, 0x86FC, 0x8A40, 0x8B35, 0x8ECA, 0x8FE0, 0x9819
	};
const TText16 KPinyin044[4] = {'c', 'h', 'e', 'n', };
const TInt charForPinyin044[95] = {
	0x8D81, 0x79F0, 0x8FB0, 0x81E3, 0x5C18, 0x6668, 0x6C89, 0x9648, 0x886C, 0x6A59, 0x5FF1, 0x90F4, 0x6987, 0x62BB, 0x8C0C, 0x789C, 
	0x8C36, 0x5BB8, 0x9F80, 0x55D4, 0x4F27, 0x741B, 0x4FB2, 0x5096, 0x512D, 0x56AB, 0x582A, 0x5861, 0x586B, 0x5875, 0x588B, 0x5926, 
	0x5E18, 0x6116, 0x6375, 0x63E8, 0x6550, 0x66DF, 0x6795, 0x686D, 0x68E7, 0x68FD, 0x6A04, 0x6AEC, 0x6C88, 0x6E5B, 0x700B, 0x70E5, 
	0x7141, 0x75A2, 0x75B9, 0x760E, 0x7628, 0x7708, 0x778B, 0x7876, 0x78E3, 0x7A31, 0x7D9D, 0x7E1D, 0x7F1C, 0x809C, 0x80C2, 0x831E, 
	0x8380, 0x8390, 0x852F, 0x85BC, 0x87B4, 0x896F, 0x8A26, 0x8AC3, 0x8AF6, 0x8B13, 0x8B32, 0x8B96, 0x8CDD, 0x8D02, 0x8D82, 0x8DBB, 
	0x8DC8, 0x8E38, 0x8ED9, 0x8FE7, 0x91A6, 0x9202, 0x9356, 0x95D6, 0x95EF, 0x9673, 0x9703, 0x9DD0, 0x9E8E, 0x9F53, 0x9F54
	};
const TText16 KPinyin045[5] = {'c', 'h', 'e', 'n', 'g', };
const TInt charForPinyin045[129] = {
	0x6210, 0x4E58, 0x76DB, 0x6491, 0x79F0, 0x57CE, 0x7A0B, 0x5448, 0x8BDA, 0x79E4, 0x60E9, 0x901E, 0x9A8B, 0x6F84, 0x6A59, 0x627F, 
	0x584D, 0x67FD, 0x57D5, 0x94D6, 0x564C, 0x94DB, 0x9172, 0x665F, 0x88CE, 0x67A8, 0x86CF, 0x4E1E, 0x77A0, 0x4E57, 0x4F25, 0x4FB1, 
	0x5000, 0x5041, 0x50DC, 0x51C0, 0x545B, 0x55C6, 0x57E9, 0x5818, 0x5856, 0x5A0D, 0x5BAC, 0x5CF8, 0x5D4A, 0x5EB1, 0x5F8E, 0x5FB4, 
	0x5FB5, 0x609C, 0x6186, 0x6195, 0x61F2, 0x62A2, 0x6330, 0x6381, 0x6436, 0x645A, 0x6464, 0x6490, 0x649C, 0x655E, 0x673E, 0x68D6, 
	0x68E6, 0x6909, 0x69CD, 0x6A18, 0x6A55, 0x6A56, 0x6A89, 0x6A99, 0x6C36, 0x6CDF, 0x6D06, 0x6D48, 0x6D67, 0x6D7E, 0x6DE8, 0x6E97, 
	0x6F82, 0x7013, 0x701E, 0x722F, 0x725A, 0x73F5, 0x73F9, 0x7424, 0x7472, 0x757B, 0x76EF, 0x7748, 0x77C3, 0x7880, 0x7A31, 0x7A6A, 
	0x7A9A, 0x7AC0, 0x7B6C, 0x7D7E, 0x7DFD, 0x8100, 0x812D, 0x837F, 0x8670, 0x87F6, 0x89D5, 0x8AA0, 0x8D6A, 0x8D6C, 0x8D9F, 0x8E1C, 
	0x8E66, 0x90D5, 0x90E2, 0x9192, 0x92EE, 0x9397, 0x93F3, 0x93FF, 0x943A, 0x9637, 0x9757, 0x9833, 0x9953, 0x9A01, 0x9A2C, 0x9BCE, 
	0x9EE8
	};
const TText16 KPinyin046[3] = {'c', 'h', 'i', };
const TInt charForPinyin046[200] = {
	0x5403, 0x5C3A, 0x8FDF, 0x6C60, 0x7FC5, 0x75F4, 0x8D64, 0x9F7F, 0x803B, 0x6301, 0x65A5, 0x4F88, 0x5F1B, 0x9A70, 0x70BD, 0x5319, 
	0x8E1F, 0x577B, 0x830C, 0x5880, 0x996C, 0x5AB8, 0x8C49, 0x892B, 0x6555, 0x54E7, 0x761B, 0x86A9, 0x557B, 0x9E31, 0x7735, 0x87AD, 
	0x7BEA, 0x9B51, 0x53F1, 0x5F73, 0x7B1E, 0x55E4, 0x50BA, 0x4F41, 0x4F99, 0x4FFF, 0x525F, 0x52C5, 0x5359, 0x5376, 0x53FA, 0x544E, 
	0x546C, 0x546E, 0x5479, 0x54C6, 0x5578, 0x559C, 0x55AB, 0x5628, 0x562F, 0x5644, 0x566D, 0x5758, 0x5791, 0x5953, 0x5979, 0x599B, 
	0x5C5F, 0x5CBB, 0x5F68, 0x5F72, 0x5FB2, 0x605C, 0x6065, 0x6157, 0x6178, 0x618F, 0x61D8, 0x6261, 0x62AC, 0x62B6, 0x62C6, 0x62D5, 
	0x62D6, 0x62F8, 0x6347, 0x63D0, 0x640B, 0x645B, 0x6474, 0x6521, 0x6758, 0x67C5, 0x67E2, 0x6A06, 0x6B3C, 0x6B57, 0x6B6D, 0x6B6F, 
	0x6C56, 0x6CB1, 0x6CB6, 0x6CBB, 0x6CDC, 0x6DD4, 0x6E41, 0x6EDE, 0x6EEF, 0x6F26, 0x707B, 0x70FE, 0x71BE, 0x72CB, 0x74FB, 0x75D3, 
	0x75F8, 0x7608, 0x7661, 0x7719, 0x779D, 0x7947, 0x79BB, 0x79FB, 0x7AFE, 0x7B42, 0x7B88, 0x7B8E, 0x7C9A, 0x7CE6, 0x7D7A, 0x7FC4, 
	0x7FE4, 0x7FE8, 0x801B, 0x8094, 0x80DD, 0x80E3, 0x80F5, 0x812A, 0x815F, 0x82AA, 0x832C, 0x834E, 0x8389, 0x83ED, 0x8687, 0x86B3, 
	0x86C7, 0x876D, 0x88B2, 0x88B3, 0x88ED, 0x8A35, 0x8A80, 0x8A83, 0x8ABA, 0x8B18, 0x8B3B, 0x8CBE, 0x8D7F, 0x8D8D, 0x8D90, 0x8DA9, 
	0x8DC5, 0x8DE2, 0x8DEE, 0x8E05, 0x8E36, 0x8EE7, 0x8FE1, 0x8FE3, 0x9045, 0x905F, 0x906B, 0x9072, 0x908C, 0x9253, 0x9279, 0x9290, 
	0x9349, 0x96E2, 0x96F4, 0x98ED, 0x98FE, 0x991D, 0x994E, 0x9970, 0x99B3, 0x9A3A, 0x9A6A, 0x9A8A, 0x9CF7, 0x9D1F, 0x9D44, 0x9D63, 
	0x9D92, 0x9D97, 0x9D99, 0x9DD8, 0x9EB6, 0x9ED0, 0x9F52, 0x9F5D
	};
const TText16 KPinyin047[5] = {'c', 'h', 'o', 'n', 'g', };
const TInt charForPinyin047[51] = {
	0x51B2, 0x91CD, 0x866B, 0x5145, 0x5BA0, 0x5D07, 0x6D8C, 0x79CD, 0x825F, 0x5FE1, 0x8202, 0x94F3, 0x61A7, 0x833A, 0x5045, 0x50AD, 
	0x50EE, 0x55A0, 0x5603, 0x57EB, 0x5BF5, 0x5D08, 0x5FB8, 0x6183, 0x63F0, 0x644F, 0x6A01, 0x6C96, 0x6D7A, 0x6F34, 0x6F7C, 0x70DB, 
	0x721E, 0x73EB, 0x75CB, 0x76C5, 0x794C, 0x7A2E, 0x7DDF, 0x7F7F, 0x7FC0, 0x8327, 0x8769, 0x87F2, 0x885D, 0x8908, 0x8E56, 0x8E71, 
	0x916E, 0x9283, 0x9680
	};
const TText16 KPinyin048[4] = {'c', 'h', 'o', 'u', };
const TInt charForPinyin048[83] = {
	0x62BD, 0x6101, 0x81ED, 0x4EC7, 0x4E11, 0x7A20, 0x7EF8, 0x916C, 0x7B79, 0x8E0C, 0x7574, 0x7785, 0x60C6, 0x4FE6, 0x5E31, 0x7633, 
	0x96E0, 0x4E12, 0x4FB4, 0x5062, 0x5114, 0x541C, 0x568B, 0x5733, 0x59AF, 0x5A64, 0x5ABF, 0x5B26, 0x5E6C, 0x601E, 0x61E4, 0x626D, 
	0x63AB, 0x63C4, 0x640A, 0x64E3, 0x677B, 0x677D, 0x6826, 0x6906, 0x6AAE, 0x6BA0, 0x6EB4, 0x71FD, 0x7270, 0x72A8, 0x72AB, 0x7564, 
	0x7587, 0x7697, 0x76E9, 0x7723, 0x77C1, 0x7BD8, 0x7C4C, 0x7D2C, 0x7D52, 0x7DA2, 0x81F0, 0x83D7, 0x85B5, 0x88EF, 0x8A76, 0x8B05, 
	0x8B78, 0x8B8E, 0x8B90, 0x8BCC, 0x8BEA, 0x8DFE, 0x8E8A, 0x905A, 0x9167, 0x9194, 0x919C, 0x91BB, 0x9215, 0x94AE, 0x96D4, 0x9B57, 
	0x9B98, 0x9BC8, 0x9C8B
	};
const TText16 KPinyin049[3] = {'c', 'h', 'u', };
const TInt charForPinyin049[116] = {
	0x51FA, 0x5904, 0x521D, 0x9504, 0x9664, 0x89E6, 0x6A71, 0x695A, 0x7840, 0x50A8, 0x755C, 0x6EC1, 0x77D7, 0x6410, 0x8E87, 0x53A8, 
	0x96CF, 0x696E, 0x6775, 0x520D, 0x6035, 0x7ECC, 0x4E8D, 0x61B7, 0x8E70, 0x9EDC, 0x870D, 0x6A17, 0x4FF6, 0x5097, 0x510A, 0x5132, 
	0x51E6, 0x52A9, 0x563C, 0x57F1, 0x5AB0, 0x5C80, 0x5E6E, 0x5EDA, 0x6149, 0x61E8, 0x62C0, 0x6462, 0x6474, 0x654A, 0x65B6, 0x67E0, 
	0x6918, 0x698B, 0x69D2, 0x6A7B, 0x6A9A, 0x6AC9, 0x6AD6, 0x6AE5, 0x6B2A, 0x6B5C, 0x6D82, 0x6DD1, 0x6EC0, 0x6FCB, 0x70AA, 0x7293, 
	0x73FF, 0x7421, 0x74B4, 0x786B, 0x790E, 0x795D, 0x7987, 0x7ACC, 0x7AD0, 0x7BE8, 0x7D40, 0x7D6E, 0x801D, 0x8021, 0x81C5, 0x82BB, 
	0x83C6, 0x8457, 0x84A2, 0x84AD, 0x84EB, 0x854F, 0x85F8, 0x8655, 0x87F5, 0x8829, 0x891A, 0x89D5, 0x89F8, 0x8A58, 0x8AD4, 0x8AF8, 
	0x8BCE, 0x8BF8, 0x8C56, 0x8C60, 0x8C99, 0x8D8E, 0x8DE6, 0x8E00, 0x8E30, 0x8E95, 0x9110, 0x924F, 0x92E4, 0x95A6, 0x96DB, 0x9DB5, 
	0x9E00, 0x9F63, 0x9F6D, 0x9F7C
	};
const TText16 KPinyin050[4] = {'c', 'h', 'u', 'a', };
const TInt charForPinyin050[3] = {
	0x64AE, 0x6B3B, 0x6B58
	};
const TText16 KPinyin051[5] = {'c', 'h', 'u', 'a', 'i', };
const TInt charForPinyin051[9] = {
	0x63E3, 0x81AA, 0x555C, 0x562C, 0x640B, 0x8E39, 0x6B3C, 0x8144, 0x8197
	};
const TText16 KPinyin052[5] = {'c', 'h', 'u', 'a', 'n', };
const TInt charForPinyin052[38] = {
	0x7A7F, 0x8239, 0x4F20, 0x4E32, 0x5DDD, 0x5598, 0x693D, 0x6C1A, 0x9044, 0x948F, 0x8221, 0x821B, 0x5DDB, 0x50B3, 0x50E2, 0x5276, 
	0x570C, 0x583E, 0x60F4, 0x63BE, 0x66B7, 0x6B42, 0x6C4C, 0x732D, 0x7394, 0x744F, 0x750E, 0x7BC5, 0x819E, 0x8229, 0x8348, 0x8CD7, 
	0x8E33, 0x8E39, 0x8F32, 0x91E7, 0x9569, 0x9DA8
	};
const TText16 KPinyin053[6] = {'c', 'h', 'u', 'a', 'n', 'g', };
const TInt charForPinyin053[38] = {
	0x7A97, 0x5E8A, 0x95EF, 0x521B, 0x75AE, 0x5E62, 0x6006, 0x4ED3, 0x4EFA, 0x5009, 0x50B8, 0x5205, 0x5231, 0x524F, 0x5259, 0x5275, 
	0x5647, 0x56EA, 0x56F1, 0x6134, 0x6227, 0x6450, 0x6723, 0x6A66, 0x6F34, 0x6F3A, 0x7240, 0x724E, 0x7255, 0x7621, 0x78E2, 0x7A93, 
	0x7ABB, 0x81A7, 0x8202, 0x8471, 0x8525, 0x95D6
	};
const TText16 KPinyin054[4] = {'c', 'h', 'u', 'i', };
const TInt charForPinyin054[25] = {
	0x5439, 0x5782, 0x708A, 0x9524, 0x6376, 0x690E, 0x69CC, 0x68F0, 0x9672, 0x5015, 0x570C, 0x57C0, 0x60D9, 0x6425, 0x6858, 0x7BA0, 
	0x8144, 0x83D9, 0x90F5, 0x9318, 0x939A, 0x9840, 0x9B0C, 0x9B4B, 0x9FA1
	};
const TText16 KPinyin055[4] = {'c', 'h', 'u', 'n', };
const TInt charForPinyin055[54] = {
	0x6625, 0x5507, 0x7EAF, 0x8822, 0x9187, 0x6DF3, 0x693F, 0x877D, 0x83BC, 0x9E51, 0x5046, 0x50E2, 0x583E, 0x5A8B, 0x60F7, 0x65FE, 
	0x6699, 0x6710, 0x6776, 0x696F, 0x69C6, 0x6A41, 0x6AC4, 0x6C8C, 0x6D71, 0x6E7B, 0x6EE3, 0x6F18, 0x7289, 0x7443, 0x7776, 0x7BBA, 
	0x7D14, 0x80AB, 0x80CA, 0x8123, 0x819E, 0x829A, 0x8405, 0x8436, 0x8493, 0x84F4, 0x8CF0, 0x8E33, 0x8F07, 0x8F34, 0x8F81, 0x9195, 
	0x931E, 0x9659, 0x9BD9, 0x9C06, 0x9D89, 0x9D9E
	};
const TText16 KPinyin056[4] = {'c', 'h', 'u', 'o', };
const TInt charForPinyin056[50] = {
	0x6233, 0x7EF0, 0x8E14, 0x555C, 0x9F8A, 0x8F8D, 0x4FC3, 0x5437, 0x56BD, 0x5A15, 0x5A16, 0x5A65, 0x5A7C, 0x5B4E, 0x60D9, 0x62FA, 
	0x64C9, 0x65AB, 0x6B60, 0x6DB0, 0x6DD6, 0x712F, 0x78ED, 0x7BB9, 0x7C07, 0x7DB4, 0x7DBD, 0x7E5B, 0x7F00, 0x814F, 0x8343, 0x851F, 
	0x8DA0, 0x8DB5, 0x8DFF, 0x8E31, 0x8E87, 0x8F1F, 0x8FB5, 0x8FB6, 0x9034, 0x916B, 0x919B, 0x92DC, 0x9323, 0x93C3, 0x9461, 0x955E, 
	0x9F6A, 0x9F71
	};
const TText16 KPinyin057[2] = {'c', 'i', };
const TInt charForPinyin057[88] = {
	0x6B21, 0x6B64, 0x8BCD, 0x74F7, 0x6148, 0x96CC, 0x78C1, 0x8F9E, 0x523A, 0x8328, 0x4F3A, 0x75B5, 0x8D50, 0x5DEE, 0x5179, 0x5472, 
	0x9E5A, 0x7960, 0x7CCD, 0x4F4C, 0x4F7D, 0x5068, 0x523E, 0x5395, 0x53A0, 0x53F8, 0x5470, 0x5559, 0x5790, 0x5832, 0x59D5, 0x5B28, 
	0x5D6F, 0x5D73, 0x5E9B, 0x5EC1, 0x63AA, 0x673F, 0x67B1, 0x67CC, 0x67F4, 0x681C, 0x6828, 0x6CDA, 0x6ECB, 0x6FAC, 0x6FE8, 0x73BC, 
	0x73C1, 0x7506, 0x7689, 0x7920, 0x7CA2, 0x7D58, 0x7E12, 0x80D4, 0x8308, 0x8326, 0x8332, 0x8360, 0x83BF, 0x8415, 0x858B, 0x85BA, 
	0x869D, 0x86D3, 0x8785, 0x8786, 0x8800, 0x8A5E, 0x8CDC, 0x8D7C, 0x8D80, 0x8D91, 0x8DD0, 0x8F9D, 0x8FA4, 0x8FAD, 0x9236, 0x98FA, 
	0x9908, 0x9AB4, 0x9ACA, 0x9B86, 0x9D1C, 0x9DBF, 0x9DC0, 0x9F79
	};
const TText16 KPinyin058[3] = {'c', 'i', 's', };
const TInt charForPinyin058[1] = {
	0x55ED
	};
const TText16 KPinyin059[4] = {'c', 'o', 'n', 'g', };
const TInt charForPinyin059[71] = {
	0x4ECE, 0x4E1B, 0x8471, 0x5306, 0x806A, 0x56F1, 0x742E, 0x679E, 0x6DD9, 0x7481, 0x9AA2, 0x82C1, 0x506C, 0x53E2, 0x56EA, 0x5A43, 
	0x5B6E, 0x5F93, 0x5F96, 0x5F9E, 0x5FE9, 0x6031, 0x60A4, 0x60B0, 0x6152, 0x6181, 0x66B0, 0x68C7, 0x6964, 0x6A05, 0x6A2C, 0x6A37, 
	0x6B09, 0x6F0E, 0x6F17, 0x6F40, 0x6F48, 0x6F68, 0x7047, 0x7127, 0x719C, 0x71EA, 0x721C, 0x747D, 0x779B, 0x7882, 0x7A97, 0x7BF5, 
	0x7DCF, 0x7DEB, 0x7E26, 0x7E31, 0x7E3D, 0x7E71, 0x7EB5, 0x8061, 0x8066, 0x8070, 0x8310, 0x83C6, 0x84EF, 0x8525, 0x85C2, 0x87CC, 
	0x8AB4, 0x8B25, 0x8CE8, 0x8CE9, 0x93E6, 0x9A18, 0x9A44
	};
const TText16 KPinyin060[3] = {'c', 'o', 'u', };
const TInt charForPinyin060[17] = {
	0x51D1, 0x6971, 0x8F8F, 0x8160, 0x594F, 0x63CD, 0x65CF, 0x6E4A, 0x73BC, 0x7C07, 0x851F, 0x85AE, 0x85EA, 0x8D8B, 0x8DA3, 0x8DA8, 
	0x8F33
	};
const TText16 KPinyin061[2] = {'c', 'u', };
const TInt charForPinyin061[51] = {
	0x7C97, 0x918B, 0x7C07, 0x4FC3, 0x5352, 0x5F82, 0x731D, 0x851F, 0x8E59, 0x9162, 0x6B82, 0x8E74, 0x4E14, 0x5346, 0x5648, 0x5A15, 
	0x5A16, 0x5AA8, 0x601A, 0x61B1, 0x621A, 0x637D, 0x7604, 0x762F, 0x76BB, 0x7E10, 0x7E2C, 0x7EC9, 0x8128, 0x850D, 0x8516, 0x89D5, 
	0x8A8E, 0x8D8B, 0x8D97, 0x8DA3, 0x8DA5, 0x8DA8, 0x8E00, 0x8E13, 0x8E24, 0x8E27, 0x8E75, 0x932F, 0x9519, 0x9863, 0x9E81, 0x9E84, 
	0x9E86, 0x9EA4, 0x9F00
	};
const TText16 KPinyin062[4] = {'c', 'u', 'a', 'n', };
const TInt charForPinyin062[30] = {
	0x7A9C, 0x8E7F, 0x7BE1, 0x6512, 0x6C46, 0x7228, 0x9569, 0x64BA, 0x50D4, 0x5DD1, 0x6505, 0x651B, 0x6522, 0x6615, 0x6AD5, 0x6B11, 
	0x6BA9, 0x6FFD, 0x7052, 0x71B6, 0x7A73, 0x7ABE, 0x7AC4, 0x7BF9, 0x7C12, 0x83C6, 0x8978, 0x8EA5, 0x92D1, 0x9479
	};
const TText16 KPinyin063[3] = {'c', 'u', 'i', };
const TInt charForPinyin063[58] = {
	0x50AC, 0x8106, 0x6467, 0x7FE0, 0x5D14, 0x6DEC, 0x8870, 0x7601, 0x7CB9, 0x7480, 0x5550, 0x60B4, 0x8403, 0x6BF3, 0x69B1, 0x4E7C, 
	0x4F1C, 0x4F53, 0x5005, 0x51D7, 0x555B, 0x5894, 0x5BDF, 0x5D12, 0x5D2A, 0x5D89, 0x5FF0, 0x615B, 0x690A, 0x69EF, 0x6F3C, 0x6FE2, 
	0x7120, 0x71A3, 0x7355, 0x7417, 0x75A9, 0x76A0, 0x78EA, 0x7AC1, 0x7C8B, 0x7D23, 0x7DB7, 0x7E17, 0x7E40, 0x7F1E, 0x7FC6, 0x8103, 
	0x813A, 0x81AC, 0x81B5, 0x81CE, 0x894A, 0x8DA1, 0x8E24, 0x93D9, 0x96B9, 0x9847
	};
const TText16 KPinyin064[3] = {'c', 'u', 'n', };
const TInt charForPinyin064[18] = {
	0x6751, 0x5BF8, 0x5B58, 0x8E72, 0x5FD6, 0x76B4, 0x4F9F, 0x520C, 0x540B, 0x58AB, 0x62F5, 0x6D0A, 0x6D5A, 0x6F8A, 0x7AF4, 0x7C7F, 
	0x8E06, 0x90A8
	};
const TText16 KPinyin065[3] = {'c', 'u', 'o', };
const TInt charForPinyin065[49] = {
	0x9519, 0x64AE, 0x6413, 0x632B, 0x63AA, 0x78CB, 0x5D6F, 0x539D, 0x9E7E, 0x811E, 0x75E4, 0x8E49, 0x7625, 0x9509, 0x77EC, 0x5249, 
	0x5252, 0x590E, 0x5D73, 0x5EB4, 0x6467, 0x6614, 0x6700, 0x68E4, 0x6FA8, 0x71DF, 0x7473, 0x7749, 0x7E12, 0x839D, 0x83A1, 0x84AB, 
	0x84CC, 0x8516, 0x8658, 0x894A, 0x8ACE, 0x8E9C, 0x8EA6, 0x902A, 0x9073, 0x9142, 0x9147, 0x919D, 0x92BC, 0x932F, 0x9ACA, 0x9E7A, 
	0x9F79
	};
const TText16 KPinyin066[2] = {'d', 'a', };
const TInt charForPinyin066[63] = {
	0x5927, 0x7B54, 0x8FBE, 0x6253, 0x642D, 0x7629, 0x5854, 0x7B2A, 0x8037, 0x54D2, 0x8921, 0x75B8, 0x601B, 0x977C, 0x59B2, 0x6C93, 
	0x55D2, 0x9791, 0x4EA3, 0x5273, 0x5312, 0x547E, 0x5491, 0x5660, 0x57AF, 0x584C, 0x58B6, 0x619A, 0x6428, 0x6498, 0x6A7D, 0x6BFC, 
	0x6C4F, 0x6E9A, 0x709F, 0x71F5, 0x7557, 0x7563, 0x7714, 0x77FA, 0x7B1A, 0x7E68, 0x7F8D, 0x80C6, 0x8345, 0x8359, 0x8598, 0x87FD, 
	0x89F0, 0x8A5A, 0x8DF6, 0x8E82, 0x8FCF, 0x8FD6, 0x8FED, 0x9039, 0x9054, 0x9389, 0x939D, 0x943D, 0x97C3, 0x9F96, 0x9F98
	};
const TText16 KPinyin067[3] = {'d', 'a', 'i', };
const TInt charForPinyin067[71] = {
	0x5E26, 0x4EE3, 0x5446, 0x6234, 0x5F85, 0x888B, 0x902E, 0x6B79, 0x8D37, 0x6020, 0x50A3, 0x5927, 0x6B86, 0x5454, 0x73B3, 0x8FE8, 
	0x5CB1, 0x7519, 0x9EDB, 0x9A80, 0x7ED0, 0x57ED, 0x4FA2, 0x53C7, 0x561A, 0x5788, 0x5E12, 0x5E2F, 0x5E36, 0x5ED7, 0x61DB, 0x66C3, 
	0x67CB, 0x68E3, 0x6BD2, 0x6C4F, 0x703B, 0x7343, 0x7447, 0x7B89, 0x7C24, 0x7D3F, 0x7DFF, 0x825C, 0x8515, 0x86AE, 0x8773, 0x87AE, 
	0x8976, 0x8A52, 0x8BD2, 0x8CB8, 0x8DE2, 0x8E5B, 0x8ED1, 0x8EDA, 0x8EE9, 0x8F6A, 0x902F, 0x905E, 0x9070, 0x96B6, 0x9734, 0x9746, 
	0x99B1, 0x99C4, 0x99D8, 0x9A6E, 0x9B98, 0x9D0F, 0x9EF1
	};
const TText16 KPinyin068[3] = {'d', 'a', 'n', };
const TInt charForPinyin068[130] = {
	0x4F46, 0x5355, 0x86CB, 0x62C5, 0x5F39, 0x63B8, 0x80C6, 0x6DE1, 0x4E39, 0x803D, 0x65E6, 0x6C2E, 0x8BDE, 0x90F8, 0x60EE, 0x77F3, 
	0x75B8, 0x6FB9, 0x7605, 0x840F, 0x6B9A, 0x7708, 0x8043, 0x7BAA, 0x8D55, 0x510B, 0x5556, 0x4E3C, 0x4EB6, 0x4F14, 0x5013, 0x50E4, 
	0x5103, 0x5184, 0x5189, 0x5210, 0x52EF, 0x5330, 0x5358, 0x547E, 0x550C, 0x5557, 0x557F, 0x55AE, 0x563E, 0x5649, 0x5661, 0x56AA, 
	0x575B, 0x58C7, 0x5989, 0x5A0A, 0x5A85, 0x5E0E, 0x5F3E, 0x5F48, 0x5FF1, 0x601B, 0x60D4, 0x6116, 0x619A, 0x61BA, 0x61BE, 0x628C, 
	0x64A2, 0x64A3, 0x64D4, 0x67E6, 0x6A90, 0x6B3F, 0x6BAB, 0x6C8A, 0x6CF9, 0x6E5B, 0x6F6D, 0x6FB6, 0x6FB8, 0x71C0, 0x72DA, 0x73AC, 
	0x74ED, 0x7514, 0x758D, 0x7649, 0x765A, 0x76BD, 0x7803, 0x79AB, 0x7A9E, 0x7C1E, 0x7D1E, 0x7E75, 0x803C, 0x8078, 0x8145, 0x81BB, 
	0x81BD, 0x8711, 0x8712, 0x87FA, 0x8874, 0x891D, 0x894C, 0x895C, 0x8998, 0x89C7, 0x89DB, 0x8A11, 0x8A79, 0x8A95, 0x8B42, 0x8D09, 
	0x8D0D, 0x8D61, 0x8E5B, 0x8EAD, 0x9132, 0x9156, 0x9188, 0x972E, 0x9815, 0x9924, 0x994F, 0x99BE, 0x99F3, 0x9AE7, 0x9D20, 0x9ED5, 
	0x9EEE, 0x9EF5
	};
const TText16 KPinyin069[4] = {'d', 'a', 'n', 'g', };
const TInt charForPinyin069[61] = {
	0x5F53, 0x515A, 0x6321, 0x6863, 0x8361, 0x8C20, 0x94DB, 0x5B95, 0x83EA, 0x51FC, 0x88C6, 0x7800, 0x5052, 0x5105, 0x5679, 0x5735, 
	0x573A, 0x57B1, 0x5834, 0x58CB, 0x5A78, 0x5D35, 0x5D63, 0x6113, 0x64CB, 0x6529, 0x6A94, 0x6B13, 0x6C39, 0x6F52, 0x6FA2, 0x7059, 
	0x70EB, 0x71D9, 0x73F0, 0x7452, 0x7497, 0x74AB, 0x74FD, 0x7576, 0x760D, 0x76EA, 0x778A, 0x78AD, 0x7911, 0x7B5C, 0x7C1C, 0x7C39, 
	0x8261, 0x8569, 0x862F, 0x87F7, 0x8960, 0x8B61, 0x8B9C, 0x8DA4, 0x903F, 0x943A, 0x95E3, 0x96FC, 0x9EE8
	};
const TText16 KPinyin070[3] = {'d', 'a', 'o', };
const TInt charForPinyin070[75] = {
	0x5230, 0x9053, 0x5012, 0x5200, 0x5C9B, 0x76D7, 0x7A3B, 0x6363, 0x60BC, 0x5BFC, 0x8E48, 0x7977, 0x5E31, 0x7E9B, 0x5FC9, 0x7118, 
	0x6C18, 0x53E8, 0x4FE6, 0x5114, 0x5202, 0x53D7, 0x5541, 0x5604, 0x5675, 0x58D4, 0x5BB2, 0x5C0E, 0x5C76, 0x5CF6, 0x5D8B, 0x5D8C, 
	0x5DB9, 0x5E6C, 0x5FD1, 0x60C6, 0x636F, 0x6417, 0x64E3, 0x6737, 0x6921, 0x69DD, 0x6AA4, 0x6AAE, 0x6D2E, 0x6D9B, 0x6FE4, 0x71FE, 
	0x74D9, 0x76DC, 0x7982, 0x79B1, 0x7A32, 0x7B8C, 0x7D69, 0x7FE2, 0x7FFF, 0x8220, 0x83FF, 0x85B5, 0x866D, 0x885C, 0x885F, 0x88EF, 
	0x8EC7, 0x91BB, 0x91D6, 0x9666, 0x9676, 0x969D, 0x96AF, 0x9B5B, 0x9C7D, 0x9CE5, 0x9E1F
	};
const TText16 KPinyin071[2] = {'d', 'e', };
const TInt charForPinyin071[16] = {
	0x7684, 0x5730, 0x5F97, 0x5FB7, 0x5E95, 0x951D, 0x561A, 0x5FB3, 0x6074, 0x60B3, 0x60EA, 0x68CF, 0x6DC2, 0x767B, 0x9340, 0x965F
	};
const TText16 KPinyin072[3] = {'d', 'e', 'i', };
const TInt charForPinyin072[2] = {
	0x5F97, 0x54CB
	};
const TText16 KPinyin073[3] = {'d', 'e', 'm', };
const TInt charForPinyin073[1] = {
	0x63FC
	};
const TText16 KPinyin074[3] = {'d', 'e', 'n', };
const TInt charForPinyin074[2] = {
	0x6265, 0x627D
	};
const TText16 KPinyin075[4] = {'d', 'e', 'n', 'g', };
const TInt charForPinyin075[29] = {
	0x7B49, 0x706F, 0x9093, 0x767B, 0x6F84, 0x77AA, 0x51F3, 0x8E6C, 0x78F4, 0x956B, 0x5654, 0x5D9D, 0x6225, 0x7C26, 0x50DC, 0x58B1, 
	0x5B01, 0x6195, 0x6A59, 0x6AC8, 0x71C8, 0x7492, 0x7AF3, 0x8260, 0x89B4, 0x8C4B, 0x9127, 0x9419, 0x96A5
	};
const TText16 KPinyin076[3] = {'d', 'e', 'o', };
const TInt charForPinyin076[1] = {
	0x54E3
	};
const TText16 KPinyin077[2] = {'d', 'i', };
const TInt charForPinyin077[162] = {
	0x5730, 0x7B2C, 0x5E95, 0x4F4E, 0x654C, 0x62B5, 0x6EF4, 0x5E1D, 0x9012, 0x5AE1, 0x5F1F, 0x7F14, 0x5824, 0x7684, 0x6DA4, 0x63D0, 
	0x7B1B, 0x8FEA, 0x72C4, 0x7FDF, 0x8482, 0x89CC, 0x90B8, 0x8C1B, 0x8BCB, 0x5600, 0x67E2, 0x9AB6, 0x7F9D, 0x6C10, 0x68E3, 0x7747, 
	0x5A23, 0x837B, 0x78B2, 0x955D, 0x577B, 0x7C74, 0x7825, 0x4EFE, 0x4FE4, 0x5059, 0x50C0, 0x5125, 0x52FA, 0x538E, 0x5467, 0x5519, 
	0x5547, 0x5572, 0x557B, 0x5681, 0x5754, 0x5758, 0x57C5, 0x57CA, 0x57DE, 0x5886, 0x5891, 0x58AC, 0x5943, 0x5A82, 0x5D7D, 0x5DB3, 
	0x5EF8, 0x5F14, 0x5F1A, 0x5F24, 0x5F7D, 0x601F, 0x6178, 0x625A, 0x62DE, 0x638B, 0x63E5, 0x6455, 0x6575, 0x65F3, 0x6753, 0x6755, 
	0x67A4, 0x688A, 0x6891, 0x6974, 0x6A00, 0x6D5F, 0x6E27, 0x6ECC, 0x710D, 0x7274, 0x7393, 0x73F6, 0x750B, 0x7590, 0x7731, 0x78AE, 
	0x78FE, 0x7976, 0x7998, 0x7BF4, 0x7CF4, 0x7D04, 0x7DE0, 0x7EA6, 0x805C, 0x8091, 0x80DD, 0x8163, 0x828D, 0x82D0, 0x82D6, 0x839C, 
	0x83C2, 0x83E7, 0x84E7, 0x850B, 0x8510, 0x8515, 0x85CB, 0x85E1, 0x86B3, 0x8743, 0x87AE, 0x889B, 0x89BF, 0x89DD, 0x8A46, 0x8ADF, 
	0x8AE6, 0x8C74, 0x8D7F, 0x8D86, 0x8E27, 0x8E36, 0x8E44, 0x8E4F, 0x8E62, 0x8EE7, 0x9010, 0x9013, 0x902E, 0x905E, 0x9069, 0x9070, 
	0x91F1, 0x926A, 0x9349, 0x93D1, 0x963A, 0x9684, 0x96B6, 0x976E, 0x97AE, 0x9814, 0x984C, 0x9898, 0x99B0, 0x9AE2, 0x9B04, 0x9B61, 
	0x9BF3, 0x9E10
	};
const TText16 KPinyin078[3] = {'d', 'i', 'a', };
const TInt charForPinyin078[1] = {
	0x55F2
	};
const TText16 KPinyin079[4] = {'d', 'i', 'a', 'n', };
const TInt charForPinyin079[72] = {
	0x70B9, 0x7535, 0x5E97, 0x6BBF, 0x6DC0, 0x6382, 0x98A0, 0x57AB, 0x7898, 0x60E6, 0x5960, 0x5178, 0x4F43, 0x975B, 0x6EC7, 0x7538, 
	0x8E2E, 0x94BF, 0x576B, 0x963D, 0x766B, 0x7C1F, 0x73B7, 0x5DC5, 0x765C, 0x4F54, 0x508E, 0x53A7, 0x5538, 0x57DD, 0x588A, 0x58C2, 
	0x594C, 0x5A5D, 0x5A70, 0x5D6E, 0x5DD3, 0x5DD4, 0x6242, 0x62C8, 0x6527, 0x6541, 0x655F, 0x6923, 0x69C7, 0x69D9, 0x6A42, 0x6A5D, 
	0x6CBE, 0x6D8E, 0x6E7A, 0x6FB1, 0x7414, 0x75F6, 0x7628, 0x7672, 0x78F9, 0x814D, 0x84A7, 0x8547, 0x8713, 0x8714, 0x8A40, 0x8E4E, 
	0x923F, 0x96FB, 0x9815, 0x985A, 0x985B, 0x9A54, 0x9EDE, 0x9F7B
	};
const TText16 KPinyin080[4] = {'d', 'i', 'a', 'o', };
const TInt charForPinyin080[78] = {
	0x6389, 0x9493, 0x53FC, 0x540A, 0x96D5, 0x8C03, 0x5201, 0x7889, 0x51CB, 0x9E1F, 0x94DE, 0x94EB, 0x9CB7, 0x8C82, 0x4F04, 0x4F7B, 
	0x501C, 0x5200, 0x521F, 0x595D, 0x5B25, 0x5C4C, 0x5F14, 0x5F34, 0x5F6B, 0x625A, 0x6311, 0x6906, 0x6BA6, 0x6C48, 0x6DCD, 0x7431, 
	0x7639, 0x7797, 0x77F5, 0x7A20, 0x7A8E, 0x7AB5, 0x7AE8, 0x7C13, 0x7C9C, 0x7CF6, 0x7D69, 0x7DA2, 0x7EF8, 0x839C, 0x84E7, 0x85CB, 
	0x866D, 0x86C1, 0x8729, 0x8A0B, 0x8A82, 0x8ABF, 0x8D75, 0x8D99, 0x8DF3, 0x8E14, 0x8EFA, 0x8F7A, 0x91E3, 0x921F, 0x92B1, 0x92FD, 
	0x932D, 0x9443, 0x96FF, 0x98A9, 0x9AA0, 0x9B61, 0x9B89, 0x9BDB, 0x9CE5, 0x9CED, 0x9D43, 0x9D70, 0x9E3C, 0x9F26
	};
const TText16 KPinyin081[3] = {'d', 'i', 'e', };
const TInt charForPinyin081[79] = {
	0x7239, 0x8DCC, 0x53E0, 0x789F, 0x8776, 0x8FED, 0x8C0D, 0x7252, 0x581E, 0x74DE, 0x63F2, 0x8E40, 0x800B, 0x9CBD, 0x57A4, 0x558B, 
	0x4F5A, 0x54A5, 0x54CB, 0x5551, 0x5CCC, 0x5D3C, 0x5D7D, 0x5E49, 0x6022, 0x604E, 0x60F5, 0x621C, 0x6303, 0x6315, 0x6633, 0x66E1, 
	0x67E3, 0x696A, 0x69E2, 0x6B9C, 0x6C0E, 0x6CC6, 0x6D89, 0x6E09, 0x6E2B, 0x7243, 0x7573, 0x7582, 0x7589, 0x758A, 0x7723, 0x7730, 
	0x7A92, 0x7D70, 0x7ED6, 0x800A, 0x80C5, 0x81F3, 0x81F7, 0x8253, 0x82F5, 0x8728, 0x87B2, 0x890B, 0x8936, 0x893A, 0x8A44, 0x8ADC, 
	0x8D83, 0x8DD5, 0x8DEE, 0x8E22, 0x8E5B, 0x8EFC, 0x8F76, 0x9421, 0x9435, 0x957B, 0x97A2, 0x9B99, 0x9C08, 0x9C28, 0x9CCE
	};
const TText16 KPinyin082[3] = {'d', 'i', 'm', };
const TInt charForPinyin082[1] = {
	0x56B8
	};
const TText16 KPinyin083[4] = {'d', 'i', 'n', 'g', };
const TInt charForPinyin083[50] = {
	0x9876, 0x5B9A, 0x76EF, 0x8BA2, 0x53EE, 0x4E01, 0x9489, 0x9F0E, 0x952D, 0x753A, 0x738E, 0x94E4, 0x815A, 0x7887, 0x7594, 0x4EC3, 
	0x8035, 0x914A, 0x5576, 0x5960, 0x5975, 0x5D7F, 0x5E04, 0x5FCA, 0x639F, 0x6917, 0x6C40, 0x6FCE, 0x706F, 0x753C, 0x77F4, 0x78A0, 
	0x78F8, 0x8062, 0x827C, 0x8423, 0x8476, 0x85A1, 0x8670, 0x8A02, 0x91D8, 0x92CC, 0x9320, 0x9424, 0x976A, 0x9802, 0x9841, 0x98E3, 
	0x9964, 0x9F11
	};
const TText16 KPinyin084[3] = {'d', 'i', 'u', };
const TInt charForPinyin084[5] = {
	0x4E22, 0x94E5, 0x4E1F, 0x92A9, 0x98A9
	};
const TText16 KPinyin085[4] = {'d', 'o', 'n', 'g', };
const TInt charForPinyin085[69] = {
	0x52A8, 0x4E1C, 0x61C2, 0x6D1E, 0x51BB, 0x51AC, 0x8463, 0x680B, 0x4F97, 0x606B, 0x5CD2, 0x9E2B, 0x578C, 0x80E8, 0x80F4, 0x7850, 
	0x6C21, 0x5CBD, 0x549A, 0x5032, 0x50CD, 0x51CD, 0x52D5, 0x52ED, 0x57EC, 0x58A5, 0x59DB, 0x5A3B, 0x5B1E, 0x5CDD, 0x5D20, 0x5D2C, 
	0x6219, 0x630F, 0x63F0, 0x6638, 0x6771, 0x6850, 0x68DF, 0x6C2D, 0x6DB7, 0x6E69, 0x70D4, 0x71D1, 0x72EB, 0x752C, 0x7B17, 0x7B52, 
	0x7B69, 0x7BBD, 0x7D67, 0x8156, 0x82F3, 0x83C4, 0x856B, 0x8740, 0x8855, 0x8A77, 0x8ACC, 0x8FF5, 0x916E, 0x9718, 0x99E7, 0x9A06, 
	0x9B97, 0x9BDF, 0x9D87, 0x9DAB, 0x9F15
	};
const TText16 KPinyin086[3] = {'d', 'o', 'u', };
const TInt charForPinyin086[54] = {
	0x90FD, 0x6597, 0x8C46, 0x9017, 0x9661, 0x6296, 0x75D8, 0x515C, 0x8BFB, 0x86AA, 0x7AA6, 0x7BFC, 0x8538, 0x4E67, 0x4FB8, 0x5160, 
	0x51DF, 0x5245, 0x543A, 0x5517, 0x6295, 0x65A3, 0x6793, 0x68AA, 0x6A77, 0x6BED, 0x6C00, 0x6D62, 0x6E0E, 0x7006, 0x7797, 0x7AAC, 
	0x7AC7, 0x8130, 0x8254, 0x8373, 0x8B80, 0x903E, 0x90D6, 0x9158, 0x9161, 0x9204, 0x92C0, 0x94AD, 0x9597, 0x95D8, 0x9627, 0x9916, 
	0x997E, 0x9B25, 0x9B26, 0x9B2A, 0x9B2C, 0x9B2D
	};
const TText16 KPinyin087[2] = {'d', 'u', };
const TInt charForPinyin087[94] = {
	0x8BFB, 0x5EA6, 0x6BD2, 0x6E21, 0x5835, 0x72EC, 0x809A, 0x9540, 0x8D4C, 0x7779, 0x675C, 0x7763, 0x90FD, 0x728A, 0x5992, 0x987F, 
	0x8839, 0x7B03, 0x561F, 0x6E0E, 0x691F, 0x724D, 0x9EE9, 0x9AD1, 0x828F, 0x5125, 0x51DF, 0x5262, 0x526B, 0x5335, 0x53BE, 0x5663, 
	0x571F, 0x5857, 0x59AC, 0x5B3B, 0x5B85, 0x5E3E, 0x6581, 0x6675, 0x668F, 0x6A1A, 0x6A1E, 0x6A50, 0x6ADD, 0x6BAC, 0x6BB0, 0x6D9C, 
	0x7006, 0x7258, 0x72A2, 0x7368, 0x743D, 0x74C4, 0x76BE, 0x776A, 0x79FA, 0x7AC7, 0x7AFA, 0x7B01, 0x7BE4, 0x7E9B, 0x8370, 0x8773, 
	0x8799, 0x8827, 0x88FB, 0x8961, 0x8969, 0x89A9, 0x8A6B, 0x8AAD, 0x8B80, 0x8B9F, 0x8BE7, 0x8C44, 0x8CED, 0x8D15, 0x918F, 0x9316, 
	0x934D, 0x937A, 0x945F, 0x9517, 0x95CD, 0x9607, 0x967C, 0x976F, 0x97C7, 0x97E3, 0x97E5, 0x9813, 0x9A33, 0x9EF7
	};
const TText16 KPinyin088[4] = {'d', 'u', 'a', 'n', };
const TInt charForPinyin088[29] = {
	0x6BB5, 0x77ED, 0x65AD, 0x7AEF, 0x953B, 0x7F0E, 0x6934, 0x7145, 0x7C16, 0x5073, 0x526C, 0x5845, 0x5A8F, 0x5F56, 0x65B7, 0x6BC8, 
	0x7456, 0x78AB, 0x7BC5, 0x7C6A, 0x7DDE, 0x8011, 0x8176, 0x846E, 0x890D, 0x8E39, 0x8E96, 0x935B, 0x9374
	};
const TText16 KPinyin089[3] = {'d', 'u', 'g', };
const TInt charForPinyin089[1] = {
	0x53FE
	};
const TText16 KPinyin090[3] = {'d', 'u', 'i', };
const TInt charForPinyin090[49] = {
	0x5BF9, 0x961F, 0x5806, 0x5151, 0x6566, 0x9566, 0x7893, 0x603C, 0x619D, 0x514A, 0x514C, 0x5796, 0x57FB, 0x5860, 0x593A, 0x596A, 
	0x5BFE, 0x5C0D, 0x5D5F, 0x619E, 0x61DF, 0x6425, 0x6778, 0x6FE7, 0x6FFB, 0x7022, 0x7029, 0x75FD, 0x78D3, 0x794B, 0x7D90, 0x81AD, 
	0x85B1, 0x8B09, 0x8B48, 0x8B75, 0x8FFD, 0x9217, 0x92B3, 0x92ED, 0x931E, 0x939A, 0x9413, 0x941C, 0x9510, 0x966E, 0x968A, 0x9827, 
	0x9D2D
	};
const TText16 KPinyin091[3] = {'d', 'u', 'l', };
const TInt charForPinyin091[1] = {
	0x4E67
	};
const TText16 KPinyin092[3] = {'d', 'u', 'n', };
const TInt charForPinyin092[49] = {
	0x5428, 0x987F, 0x8E72, 0x58A9, 0x6566, 0x949D, 0x76FE, 0x56E4, 0x9041, 0x4E0D, 0x8DB8, 0x6C8C, 0x76F9, 0x9566, 0x7905, 0x7096, 
	0x7818, 0x4F05, 0x4FCA, 0x5678, 0x58AA, 0x58FF, 0x5E89, 0x5FF3, 0x60C7, 0x619E, 0x6489, 0x64B4, 0x696F, 0x6A54, 0x6F61, 0x71C9, 
	0x729C, 0x7364, 0x78B7, 0x815E, 0x816F, 0x8733, 0x8C5A, 0x8E32, 0x8E7E, 0x8E89, 0x9007, 0x906F, 0x920D, 0x9413, 0x941C, 0x9813, 
	0x9A50
	};
const TText16 KPinyin093[3] = {'d', 'u', 'o', };
const TInt charForPinyin093[104] = {
	0x591A, 0x6735, 0x593A, 0x8235, 0x5241, 0x579B, 0x8DFA, 0x60F0, 0x5815, 0x6387, 0x54C6, 0x9A6E, 0x5EA6, 0x8EB2, 0x8E31, 0x6CB2, 
	0x5484, 0x94CE, 0x88F0, 0x54DA, 0x7F0D, 0x4EB8, 0x4EDB, 0x514A, 0x514C, 0x5151, 0x51D9, 0x5234, 0x525F, 0x526B, 0x540B, 0x55A5, 
	0x5689, 0x56B2, 0x579C, 0x57F5, 0x58AE, 0x58AF, 0x591B, 0x596A, 0x5972, 0x5AA0, 0x5AF7, 0x5C2E, 0x5D1C, 0x5D9E, 0x619C, 0x6305, 
	0x6306, 0x6376, 0x63E3, 0x6553, 0x655A, 0x6560, 0x656A, 0x6736, 0x6742, 0x6755, 0x67A4, 0x67C1, 0x67C2, 0x67EE, 0x6857, 0x68F0, 
	0x692F, 0x6A62, 0x6BF2, 0x6CB0, 0x6CB1, 0x6FA4, 0x75E5, 0x787E, 0x7D9E, 0x8324, 0x88B3, 0x8A51, 0x8A83, 0x8C80, 0x8D93, 0x8DE2, 
	0x8DE5, 0x8DFF, 0x8EB1, 0x8EC3, 0x90F8, 0x9132, 0x922C, 0x931E, 0x937A, 0x9438, 0x9517, 0x9640, 0x964A, 0x964F, 0x968B, 0x9693, 
	0x98FF, 0x9973, 0x99B1, 0x99C4, 0x9B0C, 0x9BB5, 0x9D7D, 0x9EDE
	};
const TText16 KPinyin094[1] = {'e', };
const TInt charForPinyin094[160] = {
	0x997F, 0x54E6, 0x989D, 0x9E45, 0x86FE, 0x627C, 0x4FC4, 0x8BB9, 0x963F, 0x904F, 0x5CE8, 0x5A25, 0x6076, 0x5384, 0x9102, 0x9507, 
	0x8C14, 0x57A9, 0x9537, 0x960F, 0x843C, 0x82CA, 0x8F6D, 0x5A40, 0x83AA, 0x9CC4, 0x989A, 0x816D, 0x6115, 0x5443, 0x5669, 0x9E57, 
	0x5C59, 0x4E9A, 0x4E9C, 0x4E9E, 0x4F2A, 0x4F6E, 0x4F89, 0x5054, 0x507D, 0x50DE, 0x50EB, 0x530E, 0x533C, 0x537E, 0x542A, 0x545D, 
	0x54A2, 0x54B9, 0x54D1, 0x5516, 0x5548, 0x554A, 0x5550, 0x555E, 0x5641, 0x56D0, 0x56EE, 0x57AD, 0x57E1, 0x580A, 0x5828, 0x582E, 
	0x59B8, 0x59BF, 0x59F6, 0x5A3E, 0x5A3F, 0x5A95, 0x5C75, 0x5C8B, 0x5CC9, 0x5CE9, 0x5D3F, 0x5EB5, 0x5EC5, 0x60AA, 0x60E1, 0x6239, 
	0x6415, 0x6424, 0x6439, 0x64DC, 0x66F7, 0x6799, 0x690F, 0x6AEE, 0x6B38, 0x6B5E, 0x6B79, 0x6B7A, 0x6D1D, 0x6D90, 0x6E42, 0x7380, 
	0x73F4, 0x7427, 0x75F7, 0x7692, 0x774B, 0x7808, 0x7810, 0x7828, 0x7835, 0x7846, 0x786A, 0x78C0, 0x7918, 0x80FA, 0x848D, 0x855A, 
	0x8601, 0x8685, 0x8741, 0x89A8, 0x8A1B, 0x8A7B, 0x8A90, 0x8AE4, 0x8B4C, 0x8B8D, 0x8C5F, 0x8EDB, 0x8EF6, 0x8F35, 0x8FD7, 0x904C, 
	0x907B, 0x9091, 0x920B, 0x92E8, 0x9354, 0x9469, 0x959C, 0x95BC, 0x9628, 0x9638, 0x9698, 0x981E, 0x981F, 0x984D, 0x984E, 0x9913, 
	0x9929, 0x9A00, 0x9B32, 0x9B64, 0x9B65, 0x9C10, 0x9C2A, 0x9C77, 0x9D33, 0x9D48, 0x9D5D, 0x9D5E, 0x9D9A, 0x9F43, 0x9F76, 0x9F7E
	};
const TText16 KPinyin095[2] = {'e', 'i', };
const TInt charForPinyin095[2] = {
	0x8BF6, 0x6B38
	};
const TText16 KPinyin096[2] = {'e', 'n', };
const TInt charForPinyin096[8] = {
	0x6069, 0x6441, 0x84BD, 0x55EF, 0x5940, 0x5CCE, 0x717E, 0x9950
	};
const TText16 KPinyin097[3] = {'e', 'n', 'g', };
const TInt charForPinyin097[1] = {
	0x97A5
	};
const TText16 KPinyin098[2] = {'e', 'o', };
const TInt charForPinyin098[1] = {
	0x4ED2
	};
const TText16 KPinyin099[3] = {'e', 'o', 'l', };
const TInt charForPinyin099[1] = {
	0x4E7B
	};
const TText16 KPinyin100[3] = {'e', 'o', 'm', };
const TInt charForPinyin100[1] = {
	0x6B15
	};
const TText16 KPinyin101[3] = {'e', 'o', 's', };
const TInt charForPinyin101[1] = {
	0x65D5
	};
const TText16 KPinyin102[2] = {'e', 'r', };
const TInt charForPinyin102[62] = {
	0x800C, 0x4E8C, 0x8033, 0x513F, 0x9975, 0x5C14, 0x8D30, 0x6D31, 0x73E5, 0x9C95, 0x9E38, 0x4F74, 0x8FE9, 0x94D2, 0x4F95, 0x5150, 
	0x5152, 0x5235, 0x54A1, 0x5532, 0x5B2D, 0x5C12, 0x5C13, 0x5CCF, 0x5F0D, 0x5F10, 0x6752, 0x682D, 0x682E, 0x6A32, 0x6BE6, 0x6D0F, 
	0x6E2A, 0x6FE1, 0x723E, 0x7CAB, 0x800F, 0x804F, 0x80F9, 0x81D1, 0x834B, 0x85BE, 0x8848, 0x88BB, 0x8A80, 0x8CAE, 0x8CB3, 0x8DB0, 
	0x8F00, 0x8F2D, 0x8F5C, 0x9087, 0x927A, 0x9651, 0x967E, 0x96AD, 0x990C, 0x99EC, 0x9AF5, 0x9AF6, 0x9B9E, 0x9D2F
	};
const TText16 KPinyin103[2] = {'f', 'a', };
const TInt charForPinyin103[43] = {
	0x53D1, 0x6CD5, 0x7F5A, 0x4F10, 0x4E4F, 0x7B4F, 0x9600, 0x73D0, 0x57A1, 0x781D, 0x4F71, 0x50A0, 0x59C2, 0x5EE2, 0x5F42, 0x62D4, 
	0x62E8, 0x64A5, 0x6830, 0x6A43, 0x6C4E, 0x6CB7, 0x6CDB, 0x704B, 0x743A, 0x75BA, 0x767A, 0x767C, 0x7782, 0x7B29, 0x7F70, 0x7F78, 
	0x8337, 0x855F, 0x85C5, 0x8CB6, 0x8D2C, 0x9197, 0x91B1, 0x9345, 0x95A5, 0x9AEA, 0x9AEE
	};
const TText16 KPinyin104[3] = {'f', 'a', 'n', };
const TInt charForPinyin104[91] = {
	0x53CD, 0x996D, 0x7FFB, 0x756A, 0x72AF, 0x51E1, 0x5E06, 0x8FD4, 0x6CDB, 0x7E41, 0x70E6, 0x8D29, 0x8303, 0x6A0A, 0x85E9, 0x77FE, 
	0x9492, 0x71D4, 0x8629, 0x7548, 0x8543, 0x8E6F, 0x68B5, 0x5E61, 0x4EEE, 0x4F0B, 0x51E2, 0x51E3, 0x52EB, 0x5325, 0x5643, 0x58A6, 
	0x597F, 0x5A4F, 0x5B0E, 0x5B0F, 0x5B14, 0x5FDB, 0x61A3, 0x6255, 0x62DA, 0x65D9, 0x65DB, 0x674B, 0x67C9, 0x68E5, 0x6953, 0x6A4E, 
	0x6C3E, 0x6C4E, 0x6E22, 0x6EFC, 0x702A, 0x703F, 0x7169, 0x72BF, 0x74A0, 0x7568, 0x76D5, 0x792C, 0x7B32, 0x7B35, 0x7BC4, 0x7C53, 
	0x7C75, 0x7DD0, 0x7E59, 0x7FB3, 0x81B0, 0x8224, 0x8227, 0x8229, 0x85A0, 0x87E0, 0x881C, 0x88A2, 0x894E, 0x8A09, 0x8CA9, 0x8ED3, 
	0x8EEC, 0x8F53, 0x8FBA, 0x91E9, 0x9407, 0x98BF, 0x98DC, 0x98EF, 0x98F0, 0x9C55, 0x9DED
	};
const TText16 KPinyin105[4] = {'f', 'a', 'n', 'g', };
const TInt charForPinyin105[45] = {
	0x653E, 0x623F, 0x9632, 0x7EBA, 0x82B3, 0x65B9, 0x8BBF, 0x4EFF, 0x574A, 0x59A8, 0x80AA, 0x94AB, 0x5F77, 0x90A1, 0x678B, 0x822B, 
	0x9C82, 0x5023, 0x531A, 0x57C5, 0x580F, 0x65CA, 0x6609, 0x6618, 0x661E, 0x6C78, 0x6DD3, 0x7265, 0x74EC, 0x7706, 0x772A, 0x794A, 
	0x7D21, 0x8684, 0x8A2A, 0x8DBD, 0x9201, 0x933A, 0x96F1, 0x9AE3, 0x9B74, 0x9C1F, 0x9CD1, 0x9D0B, 0x9DAD
	};
const TText16 KPinyin106[3] = {'f', 'e', 'i', };
const TInt charForPinyin106[95] = {
	0x975E, 0x98DE, 0x80A5, 0x8D39, 0x80BA, 0x5E9F, 0x532A, 0x5420, 0x6CB8, 0x83F2, 0x8BFD, 0x5561, 0x7BDA, 0x871A, 0x8153, 0x6249, 
	0x5983, 0x6590, 0x72D2, 0x82BE, 0x60B1, 0x9544, 0x970F, 0x7FE1, 0x69A7, 0x6DDD, 0x9CB1, 0x7EEF, 0x75F1, 0x4FF7, 0x5255, 0x539E, 
	0x58A2, 0x595C, 0x5A53, 0x5A54, 0x5C5D, 0x5EC3, 0x5EE2, 0x602B, 0x62C2, 0x6632, 0x6683, 0x66CA, 0x670F, 0x676E, 0x67F9, 0x68D0, 
	0x6A43, 0x6A68, 0x6AE0, 0x6E04, 0x6FF7, 0x72BB, 0x7306, 0x7432, 0x75BF, 0x7648, 0x7829, 0x7953, 0x7B30, 0x7D3C, 0x7DCB, 0x7ECB, 
	0x80C7, 0x80CF, 0x80D0, 0x8300, 0x8307, 0x8409, 0x855C, 0x855F, 0x8561, 0x8730, 0x87E6, 0x88F4, 0x88F5, 0x88F6, 0x894F, 0x8AB9, 
	0x8CBB, 0x9428, 0x966B, 0x9745, 0x975F, 0x98DB, 0x98DD, 0x9925, 0x99A1, 0x9A11, 0x9A1B, 0x9AF4, 0x9BE1, 0x9F23, 0x9F25
	};
const TText16 KPinyin107[3] = {'f', 'e', 'n', };
const TInt charForPinyin107[96] = {
	0x5206, 0x4EFD, 0x82AC, 0x7C89, 0x575F, 0x594B, 0x6124, 0x7EB7, 0x5FFF, 0x7CAA, 0x915A, 0x711A, 0x5429, 0x6C1B, 0x6C7E, 0x68FC, 
	0x7035, 0x9CBC, 0x73A2, 0x507E, 0x9F22, 0x50E8, 0x532A, 0x55B7, 0x5674, 0x5746, 0x574B, 0x58B3, 0x5954, 0x596E, 0x59A2, 0x5C8E, 
	0x5E09, 0x5E69, 0x5F05, 0x610D, 0x61A4, 0x626E, 0x62DA, 0x6543, 0x6610, 0x6706, 0x670C, 0x678C, 0x68A4, 0x68FB, 0x6A68, 0x6B55, 
	0x6FC6, 0x7083, 0x71CC, 0x71D3, 0x71D4, 0x7356, 0x76FC, 0x7793, 0x780F, 0x79CE, 0x7AD5, 0x7CDE, 0x7D1B, 0x7F92, 0x7FB5, 0x7FC2, 
	0x80A6, 0x81B9, 0x8450, 0x84B6, 0x8561, 0x86A0, 0x86A1, 0x886F, 0x8A1C, 0x8C6E, 0x8C76, 0x8CC1, 0x8D32, 0x8EAE, 0x8F52, 0x9216, 
	0x9300, 0x943C, 0x96AB, 0x96F0, 0x9812, 0x9881, 0x9934, 0x9959, 0x999A, 0x99A9, 0x9B75, 0x9C5D, 0x9CFB, 0x9EC2, 0x9EFA, 0x9F16
	};
const TText16 KPinyin108[4] = {'f', 'e', 'n', 'g', };
const TInt charForPinyin108[90] = {
	0x98CE, 0x5C01, 0x9022, 0x7F1D, 0x8702, 0x4E30, 0x67AB, 0x75AF, 0x51AF, 0x5949, 0x8BBD, 0x51E4, 0x5CF0, 0x950B, 0x70FD, 0x781C, 
	0x4FF8, 0x9146, 0x8451, 0x6CA3, 0x552A, 0x4EF9, 0x5051, 0x50FC, 0x51E8, 0x51EC, 0x51EE, 0x57C4, 0x5838, 0x5906, 0x59A6, 0x5BF7, 
	0x5CEF, 0x5D36, 0x6340, 0x6367, 0x6453, 0x687B, 0x6953, 0x6A92, 0x6CA8, 0x6CDB, 0x6D72, 0x6E22, 0x6E57, 0x6E84, 0x6F28, 0x7043, 
	0x7090, 0x7128, 0x7148, 0x71A2, 0x728E, 0x7326, 0x7412, 0x752E, 0x760B, 0x76FD, 0x78B8, 0x7BC8, 0x7D98, 0x7E2B, 0x80A8, 0x823D, 
	0x8242, 0x8391, 0x8615, 0x8634, 0x868C, 0x8982, 0x8AF7, 0x8C4A, 0x8C50, 0x8CF5, 0x8D57, 0x9004, 0x9137, 0x92D2, 0x93BD, 0x93E0, 
	0x974A, 0x98A8, 0x98CC, 0x99AE, 0x9CEF, 0x9CF3, 0x9D0C, 0x9D6C, 0x9E4F, 0x9EB7
	};
const TText16 KPinyin109[5] = {'f', 'e', 'n', 'w', 'a', };
const TInt charForPinyin109[1] = {
	0x74F0
	};
const TText16 KPinyin110[4] = {'f', 'i', 'a', 'o', };
const TInt charForPinyin110[1] = {
	0x8985
	};
const TText16 KPinyin111[2] = {'f', 'o', };
const TInt charForPinyin111[5] = {
	0x4F5B, 0x4ECF, 0x4EF8, 0x5772, 0x68BB
	};
const TText16 KPinyin112[3] = {'f', 'o', 'u', };
const TInt charForPinyin112[13] = {
	0x5426, 0x7F36, 0x4E0D, 0x57BA, 0x599A, 0x70B0, 0x7D11, 0x7F39, 0x7F3B, 0x82A3, 0x8843, 0x96EC, 0x9D00
	};
const TText16 KPinyin113[2] = {'f', 'u', };
const TInt charForPinyin113[268] = {
	0x526F, 0x5E45, 0x6276, 0x6D6E, 0x5BCC, 0x798F, 0x8D1F, 0x4F0F, 0x4ED8, 0x590D, 0x670D, 0x9644, 0x4FEF, 0x65A7, 0x8D74, 0x7F1A, 
	0x62C2, 0x592B, 0x7236, 0x7B26, 0x5B75, 0x6577, 0x8D4B, 0x8F85, 0x5E9C, 0x8150, 0x8179, 0x5987, 0x629A, 0x8986, 0x8F90, 0x80A4, 
	0x6C1F, 0x4F5B, 0x4FD8, 0x5085, 0x8BA3, 0x5F17, 0x6DAA, 0x88B1, 0x5E02, 0x752B, 0x91DC, 0x812F, 0x8151, 0x961C, 0x5490, 0x9EFC, 
	0x7829, 0x82FB, 0x8DBA, 0x8DD7, 0x86A8, 0x82BE, 0x9C8B, 0x5E5E, 0x832F, 0x6ECF, 0x8709, 0x62CA, 0x83D4, 0x8760, 0x9CC6, 0x876E, 
	0x7EC2, 0x7ECB, 0x8D59, 0x7F58, 0x7A03, 0x5310, 0x9EB8, 0x51EB, 0x6874, 0x83A9, 0x5B5A, 0x99A5, 0x9A78, 0x602B, 0x7953, 0x544B, 
	0x90DB, 0x8299, 0x8274, 0x9EFB, 0x4E0D, 0x4E40, 0x4EC5, 0x4F15, 0x4FCC, 0x4FDB, 0x5069, 0x506A, 0x51A8, 0x51B9, 0x521C, 0x5305, 
	0x5452, 0x5488, 0x54F9, 0x54FA, 0x5638, 0x577F, 0x5798, 0x57BA, 0x5831, 0x598B, 0x59C7, 0x5A10, 0x5A4F, 0x5A66, 0x5A8D, 0x5B0E, 
	0x5B14, 0x5B93, 0x5C03, 0x5CAA, 0x5CCA, 0x5DFF, 0x5E17, 0x5F23, 0x5F73, 0x5F7F, 0x5FA9, 0x6000, 0x6024, 0x61EF, 0x6299, 0x634A, 
	0x636C, 0x638A, 0x64AB, 0x65C9, 0x678E, 0x67B9, 0x67CE, 0x67EB, 0x67ED, 0x683F, 0x68F4, 0x6928, 0x6931, 0x6991, 0x6C71, 0x6C95, 
	0x6CB8, 0x6CED, 0x6D11, 0x6EA5, 0x6F93, 0x70A5, 0x70F0, 0x7124, 0x739E, 0x73B8, 0x7408, 0x74B7, 0x7536, 0x7549, 0x7550, 0x7557, 
	0x7641, 0x76D9, 0x7806, 0x7954, 0x79A3, 0x79FF, 0x7A2A, 0x7ACE, 0x7B30, 0x7B5F, 0x7B81, 0x7B99, 0x7C20, 0x7CB0, 0x7CD0, 0x7D28, 
	0x7D31, 0x7D3C, 0x7D65, 0x7D8D, 0x7D92, 0x7DEE, 0x7E1B, 0x7E80, 0x7F66, 0x7FC7, 0x80D5, 0x819A, 0x8240, 0x82A3, 0x8300, 0x8342, 
	0x8374, 0x8386, 0x8409, 0x842F, 0x844D, 0x84F2, 0x8567, 0x8659, 0x86A5, 0x86B9, 0x86D7, 0x8705, 0x875C, 0x886D, 0x889A, 0x889D, 
	0x8907, 0x8914, 0x8946, 0x8965, 0x8984, 0x8A03, 0x8A42, 0x8AE8, 0x8C67, 0x8CA0, 0x8CBB, 0x8CE6, 0x8CFB, 0x8D39, 0x8E3E, 0x8EF5, 
	0x8F14, 0x8F39, 0x8F3B, 0x8FD8, 0x909A, 0x909E, 0x90CD, 0x90D9, 0x911C, 0x915C, 0x917B, 0x91E1, 0x9207, 0x9258, 0x925C, 0x9307, 
	0x9351, 0x9362, 0x952B, 0x961D, 0x965A, 0x97B4, 0x97CD, 0x97DB, 0x97E8, 0x982B, 0x98AB, 0x98B0, 0x99D9, 0x9AF4, 0x9B34, 0x9B84, 
	0x9B92, 0x9BB2, 0x9C12, 0x9CE7, 0x9CEC, 0x9CFA, 0x9D14, 0x9D69, 0x9D9D, 0x9EA9, 0x9EAC, 0x9EB1
	};
const TText16 KPinyin114[3] = {'f', 'u', 'i', };
const TInt charForPinyin114[1] = {
	0x7324
	};
const TText16 KPinyin115[2] = {'g', 'a', };
const TInt charForPinyin115[19] = {
	0x5676, 0x80F3, 0x5939, 0x560E, 0x5496, 0x8F67, 0x9486, 0x4F3D, 0x65EE, 0x5C2C, 0x5C15, 0x5C1C, 0x5477, 0x5620, 0x738D, 0x8ECB, 
	0x91D3, 0x9337, 0x9B40
	};
const TText16 KPinyin116[3] = {'g', 'a', 'd', };
const TInt charForPinyin116[1] = {
	0x7534
	};
const TText16 KPinyin117[3] = {'g', 'a', 'i', };
const TInt charForPinyin117[50] = {
	0x8BE5, 0x6539, 0x76D6, 0x6982, 0x9499, 0x82A5, 0x6E89, 0x6224, 0x5793, 0x4E10, 0x9654, 0x8D45, 0x4E62, 0x4F85, 0x5303, 0x5304, 
	0x54B3, 0x59DF, 0x5CD0, 0x5FCB, 0x6461, 0x6650, 0x675A, 0x6838, 0x69E9, 0x69EA, 0x6C7D, 0x6F11, 0x74C2, 0x7561, 0x78D1, 0x7974, 
	0x7D60, 0x7D6F, 0x80F2, 0x8344, 0x8462, 0x84CB, 0x8A72, 0x8C65, 0x8CC5, 0x8CCC, 0x90C2, 0x9223, 0x9385, 0x95A1, 0x9602, 0x9623, 
	0x9691, 0x9AB8
	};
const TText16 KPinyin118[3] = {'g', 'a', 'n', };
const TInt charForPinyin118[81] = {
	0x8D76, 0x5E72, 0x611F, 0x6562, 0x7AFF, 0x7518, 0x809D, 0x67D1, 0x6746, 0x8D63, 0x79C6, 0x65F0, 0x9150, 0x77F8, 0x75B3, 0x6CD4, 
	0x82F7, 0x64C0, 0x7EC0, 0x6A44, 0x6F89, 0x6DE6, 0x5C34, 0x5769, 0x4E2A, 0x4E79, 0x4E7E, 0x4E81, 0x4EE0, 0x4F44, 0x501D, 0x51CE, 
	0x51F2, 0x5481, 0x5978, 0x5C32, 0x5C36, 0x5C37, 0x5E79, 0x5FD3, 0x625E, 0x634D, 0x653C, 0x687F, 0x69A6, 0x6A8A, 0x6C57, 0x6C75, 
	0x6D5B, 0x6F27, 0x7068, 0x7395, 0x73B5, 0x76AF, 0x76F0, 0x7A08, 0x7B34, 0x7B78, 0x7BE2, 0x7C33, 0x7C93, 0x7D3A, 0x8289, 0x8677, 
	0x8866, 0x8A4C, 0x8AF4, 0x8C43, 0x8D11, 0x8D1B, 0x8D95, 0x8FC0, 0x91EC, 0x930E, 0x98E6, 0x9AAD, 0x9B50, 0x9C14, 0x9C64, 0x9CE1, 
	0x9CF1
	};
const TText16 KPinyin119[4] = {'g', 'a', 'n', 'g', };
const TInt charForPinyin119[45] = {
	0x521A, 0x94A2, 0x7EB2, 0x6E2F, 0x7F38, 0x5C97, 0x6760, 0x5188, 0x809B, 0x625B, 0x7B7B, 0x7F61, 0x6206, 0x4EA2, 0x4F09, 0x51AE, 
	0x525B, 0x5808, 0x583D, 0x5CA1, 0x5D17, 0x6205, 0x6207, 0x6297, 0x6386, 0x68E1, 0x69D3, 0x6E9D, 0x7135, 0x7268, 0x7285, 0x72BA, 
	0x7598, 0x77FC, 0x7899, 0x7DB1, 0x7F41, 0x7F53, 0x80AE, 0x91ED, 0x92FC, 0x93A0, 0x962C, 0x980F, 0x9883
	};
const TText16 KPinyin120[3] = {'g', 'a', 'o', };
const TInt charForPinyin120[58] = {
	0x9AD8, 0x641E, 0x544A, 0x7A3F, 0x818F, 0x7BD9, 0x7F94, 0x7CD5, 0x9550, 0x768B, 0x90DC, 0x8BF0, 0x6772, 0x7F1F, 0x777E, 0x69D4, 
	0x9506, 0x69C1, 0x85C1, 0x52C2, 0x543F, 0x548E, 0x5930, 0x5CFC, 0x66A0, 0x69C0, 0x69F9, 0x6A70, 0x6ABA, 0x6ADC, 0x6D69, 0x6EDC, 
	0x6F94, 0x734B, 0x7354, 0x7690, 0x776A, 0x796E, 0x7970, 0x799E, 0x7A01, 0x7A3E, 0x7B76, 0x7E1E, 0x7F99, 0x81EF, 0x83D2, 0x84BF, 
	0x85F3, 0x8AA5, 0x92EF, 0x93AC, 0x97DF, 0x993B, 0x9AD9, 0x9DCE, 0x9DF1, 0x9F1B
	};
const TText16 KPinyin121[2] = {'g', 'e', };
const TInt charForPinyin121[114] = {
	0x4E2A, 0x5404, 0x6B4C, 0x5272, 0x54E5, 0x6401, 0x683C, 0x9601, 0x9694, 0x9769, 0x54AF, 0x80F3, 0x845B, 0x86E4, 0x6208, 0x9E3D, 
	0x7599, 0x76D6, 0x5C79, 0x5408, 0x94EC, 0x784C, 0x9ABC, 0x988C, 0x88BC, 0x5865, 0x867C, 0x572A, 0x9549, 0x4EE1, 0x8238, 0x9B32, 
	0x55DD, 0x8188, 0x643F, 0x7EA5, 0x54FF, 0x4ECB, 0x4F6B, 0x4F6E, 0x500B, 0x530C, 0x53EF, 0x5424, 0x5444, 0x5605, 0x5622, 0x5676, 
	0x5F41, 0x6105, 0x6213, 0x6228, 0x6262, 0x630C, 0x64F1, 0x654B, 0x675A, 0x69C5, 0x6ACA, 0x6D69, 0x6EC6, 0x6ED2, 0x6F94, 0x726B, 
	0x7271, 0x72B5, 0x7332, 0x7366, 0x781D, 0x79F4, 0x7B87, 0x7D07, 0x8090, 0x81C8, 0x81F5, 0x8316, 0x83CF, 0x84CB, 0x86D2, 0x88D3, 
	0x89E1, 0x8A65, 0x8AFD, 0x8B0C, 0x8F35, 0x8F55, 0x9240, 0x927B, 0x927F, 0x9391, 0x9398, 0x93B6, 0x94BE, 0x94EA, 0x9598, 0x95A3, 
	0x95A4, 0x95F8, 0x9788, 0x97B7, 0x97D0, 0x97DA, 0x981C, 0x9A14, 0x9AC2, 0x9B7A, 0x9BA5, 0x9BAF, 0x9C2A, 0x9C84, 0x9D10, 0x9D1A, 
	0x9D3F, 0x9D45
	};
const TText16 KPinyin122[3] = {'g', 'e', 'i', };
const TInt charForPinyin122[2] = {
	0x7ED9, 0x7D66
	};
const TText16 KPinyin123[3] = {'g', 'e', 'n', };
const TInt charForPinyin123[9] = {
	0x8DDF, 0x6839, 0x54CF, 0x831B, 0x4E98, 0x826E, 0x63EF, 0x6404, 0x75D5
	};
const TText16 KPinyin124[4] = {'g', 'e', 'n', 'g', };
const TInt charForPinyin124[43] = {
	0x66F4, 0x8015, 0x9888, 0x6897, 0x803F, 0x5E9A, 0x7FB9, 0x57C2, 0x8D53, 0x9CA0, 0x54FD, 0x7EE0, 0x4E99, 0x4EA2, 0x522F, 0x5829, 
	0x5CFA, 0x6046, 0x632D, 0x63B6, 0x6685, 0x6929, 0x6D6D, 0x713F, 0x754A, 0x786C, 0x7D59, 0x7D5A, 0x7D86, 0x7DEA, 0x7E06, 0x7FAE, 
	0x8384, 0x83EE, 0x8CE1, 0x90A2, 0x90C9, 0x90E0, 0x9838, 0x9ABE, 0x9BC1, 0x9D8A, 0x9E52
	};
const TText16 KPinyin125[3] = {'g', 'e', 'o', };
const TInt charForPinyin125[1] = {
	0x56BF
	};
const TText16 KPinyin126[3] = {'g', 'e', 'u', };
const TInt charForPinyin126[1] = {
	0x5579
	};
const TText16 KPinyin127[3] = {'g', 'i', 'b', };
const TInt charForPinyin127[1] = {
	0x55BC
	};
const TText16 KPinyin128[2] = {'g', 'o', };
const TInt charForPinyin128[1] = {
	0x55F0
	};
const TText16 KPinyin129[4] = {'g', 'o', 'n', 'g', };
const TInt charForPinyin129[58] = {
	0x5DE5, 0x516C, 0x529F, 0x5171, 0x5F13, 0x653B, 0x5BAB, 0x4F9B, 0x606D, 0x62F1, 0x8D21, 0x8EAC, 0x5DE9, 0x6C5E, 0x9F9A, 0x7EA2, 
	0x80B1, 0x89E5, 0x73D9, 0x86A3, 0x5311, 0x5314, 0x53B7, 0x54A3, 0x551D, 0x55CA, 0x5868, 0x5BAE, 0x5E4A, 0x5EFE, 0x6129, 0x6150, 
	0x62F2, 0x675B, 0x6760, 0x6831, 0x6E31, 0x7195, 0x78BD, 0x7BE2, 0x7CFC, 0x7D05, 0x7FBE, 0x8679, 0x86E9, 0x89F5, 0x8CA2, 0x8D11, 
	0x8D1B, 0x8D63, 0x8EB3, 0x8F01, 0x92BE, 0x978F, 0x9AF8, 0x9B5F, 0x9F8F, 0x9F94
	};
const TText16 KPinyin130[7] = {'g', 'o', 'n', 'g', 'f', 'e', 'n', };
const TInt charForPinyin130[1] = {
	0x515D
	};
const TText16 KPinyin131[6] = {'g', 'o', 'n', 'g', 'l', 'i', };
const TInt charForPinyin131[1] = {
	0x5163
	};
const TText16 KPinyin132[3] = {'g', 'o', 'u', };
const TInt charForPinyin132[63] = {
	0x591F, 0x6C9F, 0x72D7, 0x94A9, 0x52FE, 0x8D2D, 0x6784, 0x82DF, 0x57A2, 0x53E5, 0x5CA3, 0x5F40, 0x67B8, 0x97B2, 0x89CF, 0x7F11, 
	0x7B31, 0x8BDF, 0x9058, 0x5ABE, 0x7BDD, 0x4F5D, 0x508B, 0x5193, 0x533A, 0x5340, 0x5474, 0x5778, 0x5920, 0x59E4, 0x6285, 0x62D8, 
	0x6406, 0x6480, 0x69CB, 0x6CC3, 0x6E9D, 0x7179, 0x73BD, 0x7C3C, 0x7DF1, 0x8007, 0x8008, 0x8009, 0x8329, 0x86BC, 0x88A7, 0x8920, 
	0x89AF, 0x8A3D, 0x8A6C, 0x8C70, 0x8C7F, 0x8CFC, 0x8EE5, 0x920E, 0x9264, 0x96CA, 0x97DD, 0x9B88, 0x9D1D, 0x9E1C, 0x9E32
	};
const TText16 KPinyin133[2] = {'g', 'u', };
const TInt charForPinyin133[123] = {
	0x53E4, 0x80A1, 0x9F13, 0x8C37, 0x6545, 0x5B64, 0x7B8D, 0x59D1, 0x987E, 0x56FA, 0x96C7, 0x4F30, 0x5495, 0x9AA8, 0x8F9C, 0x6CBD, 
	0x86CA, 0x8D3E, 0x83C7, 0x688F, 0x9E2A, 0x6C69, 0x8F71, 0x5D2E, 0x83F0, 0x9E44, 0x9E58, 0x94B4, 0x81CC, 0x9164, 0x5471, 0x9CB4, 
	0x8BC2, 0x726F, 0x77BD, 0x6BC2, 0x9522, 0x727F, 0x75FC, 0x89DA, 0x86C4, 0x7F5F, 0x560F, 0x50A6, 0x50F1, 0x51C5, 0x52B7, 0x544A, 
	0x54CC, 0x5502, 0x5503, 0x5552, 0x55C0, 0x55D7, 0x580C, 0x5903, 0x5AF4, 0x5C33, 0x5CE0, 0x5D13, 0x6018, 0x6132, 0x6262, 0x6287, 
	0x67AF, 0x67E7, 0x68DD, 0x6996, 0x69BE, 0x6A6D, 0x6ACE, 0x6CD2, 0x6DC8, 0x6ED1, 0x6FF2, 0x7014, 0x7138, 0x74E0, 0x768B, 0x76B7, 
	0x76EC, 0x7872, 0x78C6, 0x797B, 0x7A12, 0x7A40, 0x7B1F, 0x7B9B, 0x7BD0, 0x7CD3, 0x7E0E, 0x7F5B, 0x7F96, 0x80CD, 0x8135, 0x81EF, 
	0x82E6, 0x82FD, 0x84C7, 0x85A3, 0x86CC, 0x8831, 0x89D2, 0x8A41, 0x8CC8, 0x8EF1, 0x8EF2, 0x8F42, 0x9027, 0x9232, 0x9237, 0x932E, 
	0x980B, 0x9867, 0x9936, 0x9989, 0x9AB0, 0x9B95, 0x9BDD, 0x9D23, 0x9D60, 0x9DBB, 0x9F14
	};
const TText16 KPinyin134[3] = {'g', 'u', 'a', };
const TInt charForPinyin134[42] = {
	0x6302, 0x522E, 0x74DC, 0x5BE1, 0x5250, 0x8902, 0x5366, 0x5471, 0x80CD, 0x9E39, 0x681D, 0x8BD6, 0x518E, 0x526E, 0x5280, 0x53E7, 
	0x54B6, 0x54BC, 0x5569, 0x576C, 0x60F4, 0x639B, 0x6B44, 0x713B, 0x7171, 0x7D53, 0x7DFA, 0x7F63, 0x7F6B, 0x820C, 0x82FD, 0x8A7F, 
	0x8AE3, 0x8D8F, 0x8E3B, 0x929B, 0x92BD, 0x94E6, 0x98AA, 0x98B3, 0x9A27, 0x9D30
	};
const TText16 KPinyin135[4] = {'g', 'u', 'a', 'i', };
const TInt charForPinyin135[13] = {
	0x602A, 0x62D0, 0x4E56, 0x63B4, 0x53CF, 0x54D9, 0x5672, 0x592C, 0x6060, 0x67B4, 0x67FA, 0x7B89, 0x7F6B
	};
const TText16 KPinyin136[4] = {'g', 'u', 'a', 'n', };
const TInt charForPinyin136[80] = {
	0x5173, 0x7BA1, 0x5B98, 0x89C2, 0x9986, 0x60EF, 0x7F50, 0x704C, 0x51A0, 0x8D2F, 0x68FA, 0x7EB6, 0x76E5, 0x77DC, 0x839E, 0x63BC, 
	0x6DAB, 0x9CCF, 0x9E73, 0x500C, 0x4E31, 0x4E32, 0x535D, 0x5A60, 0x60B9, 0x60BA, 0x6163, 0x61FD, 0x645C, 0x65A1, 0x679C, 0x6844, 
	0x6A0C, 0x6AEC, 0x6B0A, 0x6BCC, 0x6CA6, 0x6CF4, 0x6DC9, 0x6DEA, 0x6F45, 0x721F, 0x742F, 0x74D8, 0x75EF, 0x761D, 0x764F, 0x77D4, 
	0x7936, 0x797C, 0x7AA4, 0x7B66, 0x7DB8, 0x7F46, 0x8218, 0x83C5, 0x8416, 0x8484, 0x898C, 0x89B3, 0x89C0, 0x8CAB, 0x8E80, 0x8F28, 
	0x9066, 0x9327, 0x93C6, 0x9475, 0x959E, 0x95A2, 0x95D7, 0x95DC, 0x96DA, 0x9928, 0x9C25, 0x9C5E, 0x9C79, 0x9CE4, 0x9D4D, 0x9E1B
	};
const TText16 KPinyin137[5] = {'g', 'u', 'a', 'n', 'g', };
const TInt charForPinyin137[40] = {
	0x5149, 0x5E7F, 0x901B, 0x6844, 0x72B7, 0x54A3, 0x80F1, 0x4F8A, 0x4FC7, 0x50D9, 0x5799, 0x59EF, 0x5E83, 0x5EE3, 0x604D, 0x6269, 
	0x6304, 0x6497, 0x64F4, 0x6A2A, 0x6ACE, 0x6B1F, 0x6D38, 0x6F62, 0x706E, 0x7097, 0x709A, 0x709B, 0x70E1, 0x7377, 0x73D6, 0x7844, 
	0x81E6, 0x81E9, 0x832A, 0x8DAA, 0x8F04, 0x8FCB, 0x92A7, 0x9EC6
	};
const TText16 KPinyin138[3] = {'g', 'u', 'i', };
const TInt charForPinyin138[134] = {
	0x5F52, 0x8D35, 0x9B3C, 0x8DEA, 0x8F68, 0x89C4, 0x7845, 0x6842, 0x67DC, 0x9F9F, 0x8BE1, 0x95FA, 0x7470, 0x572D, 0x523D, 0x5080, 
	0x7678, 0x7094, 0x5E8B, 0x5B84, 0x6867, 0x523F, 0x9CDC, 0x9C91, 0x7688, 0x5326, 0x59AB, 0x6677, 0x7C0B, 0x7085, 0x4E80, 0x4F2A, 
	0x4F79, 0x507D, 0x50DE, 0x528A, 0x528C, 0x532D, 0x532E, 0x5331, 0x53AC, 0x54C7, 0x579D, 0x59FD, 0x5A03, 0x5AAF, 0x5AE2, 0x5B00, 
	0x5DA1, 0x5DB2, 0x5DC2, 0x5E30, 0x5EAA, 0x5EC6, 0x6051, 0x646B, 0x648C, 0x6530, 0x6531, 0x660B, 0x6739, 0x6845, 0x691D, 0x6922, 
	0x6982, 0x69E3, 0x69F6, 0x69FB, 0x69FC, 0x6A9C, 0x6AC3, 0x6AF0, 0x6AF7, 0x6B78, 0x6C3F, 0x6CA9, 0x6D3C, 0x6E40, 0x6E8E, 0x6F59, 
	0x73EA, 0x749D, 0x74CC, 0x7650, 0x7786, 0x77A1, 0x77B6, 0x784A, 0x7948, 0x796A, 0x79AC, 0x7A90, 0x7B40, 0x7C02, 0x7D75, 0x7E6A, 
	0x7ED8, 0x80FF, 0x81AD, 0x8325, 0x84D5, 0x862C, 0x86EB, 0x879D, 0x87E1, 0x88BF, 0x8958, 0x898F, 0x89D6, 0x89E4, 0x8A6D, 0x8B09, 
	0x8CB4, 0x8D7D, 0x8DB9, 0x8E76, 0x8ECC, 0x90BD, 0x90CC, 0x95A8, 0x9652, 0x9697, 0x96DF, 0x97BC, 0x9A29, 0x9B36, 0x9B39, 0x9BAD, 
	0x9C56, 0x9C65, 0x9CFA, 0x9D02, 0x9D03, 0x9F9C
	};
const TText16 KPinyin139[3] = {'g', 'u', 'n', };
const TInt charForPinyin139[32] = {
	0x6EDA, 0x68CD, 0x8F8A, 0x9CA7, 0x886E, 0x78D9, 0x7EF2, 0x4E28, 0x60C3, 0x68DE, 0x6D51, 0x6DF7, 0x6E3E, 0x6EFE, 0x742F, 0x74AD, 
	0x7754, 0x7774, 0x7DC4, 0x7DF7, 0x84D8, 0x8509, 0x889E, 0x88F7, 0x8B34, 0x8F25, 0x9315, 0x951F, 0x9B8C, 0x9BC0, 0x9C25, 0x9CCF
	};
const TText16 KPinyin140[3] = {'g', 'u', 'o', };
const TInt charForPinyin140[76] = {
	0x8FC7, 0x56FD, 0x679C, 0x88F9, 0x9505, 0x90ED, 0x6DA1, 0x57DA, 0x6901, 0x8052, 0x9998, 0x7313, 0x5D1E, 0x63B4, 0x5E3C, 0x5459, 
	0x8662, 0x873E, 0x8748, 0x5212, 0x54B6, 0x54BC, 0x552C, 0x556F, 0x5613, 0x56D7, 0x56EF, 0x56F6, 0x56FB, 0x5700, 0x570B, 0x57FB, 
	0x581D, 0x588E, 0x5E57, 0x5F49, 0x5F4D, 0x60C8, 0x6156, 0x6413, 0x6451, 0x654B, 0x67B8, 0x6947, 0x69E8, 0x6ACE, 0x6D3B, 0x6DC9, 
	0x6E26, 0x6F0D, 0x6FC4, 0x7611, 0x77CC, 0x7C02, 0x7CBF, 0x7DB6, 0x805D, 0x8142, 0x8158, 0x8195, 0x83D3, 0x852E, 0x872E, 0x8778, 
	0x87C8, 0x8803, 0x8901, 0x8F20, 0x904E, 0x921B, 0x9301, 0x934B, 0x9439, 0x951E, 0x991C, 0x9983
	};
const TText16 KPinyin141[2] = {'h', 'a', };
const TInt charForPinyin141[13] = {
	0x54C8, 0x86E4, 0x867E, 0x94EA, 0x4E37, 0x5413, 0x5475, 0x5964, 0x598E, 0x70BA, 0x736C, 0x8766, 0x927F
	};
const TText16 KPinyin142[3] = {'h', 'a', 'i', };
const TInt charForPinyin142[34] = {
	0x8FD8, 0x6D77, 0x5BB3, 0x54B3, 0x6C26, 0x5B69, 0x9A87, 0x9AB8, 0x4EA5, 0x55E8, 0x91A2, 0x80F2, 0x4F85, 0x548D, 0x54B4, 0x55D0, 
	0x56A1, 0x5870, 0x62F8, 0x6B2C, 0x70F8, 0x7332, 0x7D6F, 0x9084, 0x90C2, 0x917C, 0x95A1, 0x9602, 0x9826, 0x988F, 0x9900, 0x995A, 
	0x99ED, 0x99F4
	};
const TText16 KPinyin143[3] = {'h', 'a', 'l', };
const TInt charForPinyin143[1] = {
	0x4E64
	};
const TText16 KPinyin144[3] = {'h', 'a', 'n', };
const TInt charForPinyin144[126] = {
	0x558A, 0x542B, 0x6C57, 0x5BD2, 0x6C49, 0x65F1, 0x9163, 0x97E9, 0x710A, 0x6DB5, 0x51FD, 0x61A8, 0x7FF0, 0x7F55, 0x64BC, 0x634D, 
	0x61BE, 0x608D, 0x90AF, 0x9097, 0x83E1, 0x6496, 0x701A, 0x961A, 0x9878, 0x86B6, 0x7113, 0x9894, 0x6657, 0x9F3E, 0x4EE0, 0x4F44, 
	0x50BC, 0x516F, 0x51FE, 0x5382, 0x5388, 0x5481, 0x54FB, 0x5505, 0x5682, 0x5705, 0x57BE, 0x5A22, 0x5AE8, 0x5C7D, 0x5D21, 0x5D45, 
	0x5D4C, 0x5FD3, 0x611F, 0x625E, 0x653C, 0x65F0, 0x6658, 0x6665, 0x66B5, 0x687F, 0x6892, 0x6937, 0x69A6, 0x6B26, 0x6B5B, 0x6C75, 
	0x6CD4, 0x6D5B, 0x6D6B, 0x6D86, 0x6DCA, 0x6DE6, 0x6EE9, 0x6F22, 0x6F89, 0x6F8F, 0x6FA3, 0x7058, 0x71AF, 0x7233, 0x7302, 0x7400, 
	0x7518, 0x751D, 0x7694, 0x7745, 0x77F8, 0x7B12, 0x7B68, 0x7CEE, 0x80A3, 0x839F, 0x850A, 0x862B, 0x8677, 0x86FF, 0x872C, 0x872D, 
	0x8792, 0x8B40, 0x8C3D, 0x8C43, 0x8ED2, 0x8F69, 0x91EC, 0x9210, 0x92B2, 0x92CE, 0x92E1, 0x94A4, 0x9588, 0x95DE, 0x95EC, 0x96D7, 
	0x976C, 0x97D3, 0x9807, 0x981C, 0x9837, 0x9844, 0x9869, 0x99A0, 0x99AF, 0x99FB, 0x9B2B, 0x9B7D, 0x9CF1, 0x9DBE
	};
const TText16 KPinyin145[4] = {'h', 'a', 'n', 'g', };
const TInt charForPinyin145[29] = {
	0x884C, 0x5DF7, 0x822A, 0x592F, 0x676D, 0x542D, 0x9883, 0x6C86, 0x7ED7, 0x73E9, 0x57B3, 0x5994, 0x5FFC, 0x65BB, 0x6841, 0x7095, 
	0x72FC, 0x7B10, 0x7B55, 0x7D4E, 0x80AE, 0x82C0, 0x86A2, 0x8CA5, 0x8FD2, 0x909F, 0x9150, 0x980F, 0x9B67
	};
const TText16 KPinyin146[3] = {'h', 'a', 'o', };
const TInt charForPinyin146[73] = {
	0x597D, 0x53F7, 0x6D69, 0x568E, 0x58D5, 0x90DD, 0x6BEB, 0x8C6A, 0x8017, 0x8C89, 0x9550, 0x660A, 0x98A2, 0x704F, 0x5686, 0x869D, 
	0x55E5, 0x7693, 0x84BF, 0x6FE0, 0x8585, 0x5090, 0x512B, 0x547A, 0x54E0, 0x552C, 0x5637, 0x5651, 0x599E, 0x604F, 0x608E, 0x6626, 
	0x6667, 0x66A0, 0x66A4, 0x66AD, 0x66CD, 0x6903, 0x6DCF, 0x6EC8, 0x6EDC, 0x6F94, 0x705D, 0x7346, 0x734B, 0x768B, 0x769C, 0x769E, 
	0x76A1, 0x76A5, 0x777E, 0x79CF, 0x7AD3, 0x7C47, 0x7FEF, 0x8055, 0x81A0, 0x81EF, 0x8320, 0x8583, 0x85A7, 0x85C3, 0x865F, 0x8660, 
	0x8814, 0x8AD5, 0x8B79, 0x9117, 0x9392, 0x93AC, 0x941E, 0x9865, 0x9C1D
	};
const TText16 KPinyin147[5] = {'h', 'a', 'o', 'k', 'e', };
const TInt charForPinyin147[1] = {
	0x515E
	};
const TText16 KPinyin148[2] = {'h', 'e', };
const TInt charForPinyin148[138] = {
	0x548C, 0x559D, 0x5408, 0x6CB3, 0x79BE, 0x6838, 0x4F55, 0x5475, 0x8377, 0x8D3A, 0x8D6B, 0x8910, 0x76D2, 0x9E64, 0x83CF, 0x8C89, 
	0x9602, 0x6DB8, 0x5413, 0x55EC, 0x52BE, 0x76CD, 0x7FEE, 0x9616, 0x988C, 0x58D1, 0x8BC3, 0x7EA5, 0x66F7, 0x4F6B, 0x5459, 0x547C, 
	0x548A, 0x54BC, 0x54C8, 0x54EC, 0x555D, 0x559B, 0x55C3, 0x55D1, 0x5648, 0x5687, 0x578E, 0x59C0, 0x5BB3, 0x5BC9, 0x5CC6, 0x60D2, 
	0x6112, 0x62B2, 0x630C, 0x63ED, 0x6546, 0x67C7, 0x683C, 0x6941, 0x6B31, 0x6BFC, 0x6D3D, 0x6E07, 0x6E2E, 0x6E34, 0x6E7C, 0x6F95, 
	0x7103, 0x7142, 0x7186, 0x7187, 0x71FA, 0x7200, 0x72B5, 0x72E2, 0x764B, 0x76AC, 0x76C7, 0x76C9, 0x7845, 0x788B, 0x7909, 0x79F4, 
	0x7BD5, 0x7C7A, 0x7CAD, 0x7D07, 0x7E73, 0x7F34, 0x7FEF, 0x82DB, 0x8402, 0x85C3, 0x85FF, 0x86B5, 0x874E, 0x879B, 0x881A, 0x8894, 
	0x8988, 0x8A36, 0x8A38, 0x8A65, 0x8B1E, 0x8C88, 0x8CC0, 0x8F05, 0x8F44, 0x8F82, 0x8F96, 0x90C3, 0x924C, 0x9449, 0x95A1, 0x95D4, 
	0x960B, 0x96BA, 0x970D, 0x974D, 0x974E, 0x974F, 0x97A8, 0x981C, 0x9904, 0x9932, 0x9978, 0x9B29, 0x9B7A, 0x9C84, 0x9D60, 0x9DA1, 
	0x9DAE, 0x9DB4, 0x9E16, 0x9E44, 0x9E56, 0x9EA7, 0x9F43, 0x9F55, 0x9F81, 0x9FA2
	};
const TText16 KPinyin149[3] = {'h', 'e', 'i', };
const TInt charForPinyin149[6] = {
	0x9ED1, 0x563F, 0x55E8, 0x5B12, 0x6F76, 0x9ED2
	};
const TText16 KPinyin150[3] = {'h', 'e', 'm', };
const TInt charForPinyin150[1] = {
	0x519A
	};
const TText16 KPinyin151[3] = {'h', 'e', 'n', };
const TInt charForPinyin151[12] = {
	0x5F88, 0x72E0, 0x6068, 0x75D5, 0x4F77, 0x54CF, 0x5677, 0x62EB, 0x6380, 0x826E, 0x8A6A, 0x978E
	};
const TText16 KPinyin152[4] = {'h', 'e', 'n', 'g', };
const TInt charForPinyin152[26] = {
	0x6A2A, 0x6052, 0x54FC, 0x8861, 0x4EA8, 0x884C, 0x6841, 0x73E9, 0x8605, 0x4F77, 0x5548, 0x583C, 0x59EE, 0x6046, 0x6099, 0x6A6B, 
	0x6DA5, 0x70C6, 0x72DF, 0x80FB, 0x811D, 0x8A07, 0x9445, 0x9D34, 0x9D46, 0x9E3B
	};
const TText16 KPinyin153[4] = {'h', 'e', 'u', 'i', };
const TInt charForPinyin153[1] = {
	0x56CD
	};
const TText16 KPinyin154[2] = {'h', 'o', };
const TInt charForPinyin154[1] = {
	0x4E4A
	};
const TText16 KPinyin155[3] = {'h', 'o', 'l', };
const TInt charForPinyin155[1] = {
	0x4E65
	};
const TText16 KPinyin156[4] = {'h', 'o', 'n', 'g', };
const TInt charForPinyin156[95] = {
	0x7EA2, 0x8F70, 0x54C4, 0x8679, 0x6D2A, 0x5B8F, 0x70D8, 0x9E3F, 0x5F18, 0x8BA7, 0x8A07, 0x857B, 0x95F3, 0x85A8, 0x9EC9, 0x836D, 
	0x6CD3, 0x4EDC, 0x53B7, 0x53FF, 0x5430, 0x543D, 0x54C5, 0x551D, 0x55CA, 0x569D, 0x57AC, 0x5985, 0x5A02, 0x5B96, 0x5C78, 0x5DC6, 
	0x5F4B, 0x6129, 0x63C8, 0x6494, 0x664E, 0x6C6A, 0x6C6F, 0x6D64, 0x6D72, 0x6E2F, 0x6E31, 0x6E39, 0x6F42, 0x6F8B, 0x6F92, 0x7074, 
	0x7122, 0x7392, 0x739C, 0x74E8, 0x7854, 0x7861, 0x7AD1, 0x7AE4, 0x7BCA, 0x7CA0, 0x7D05, 0x7D18, 0x7D2D, 0x7D8B, 0x7EAE, 0x7FBE, 
	0x7FC3, 0x7FDD, 0x803E, 0x823C, 0x82F0, 0x8452, 0x8453, 0x8A0C, 0x8B0D, 0x8C39, 0x8C3C, 0x8C3E, 0x8EE3, 0x8F37, 0x8F5F, 0x921C, 
	0x9277, 0x92BE, 0x92D0, 0x9367, 0x958E, 0x95A7, 0x95C0, 0x95C2, 0x9710, 0x971F, 0x9783, 0x9B28, 0x9B5F, 0x9D3B, 0x9ECC
	};
const TText16 KPinyin157[3] = {'h', 'o', 'u', };
const TInt charForPinyin157[40] = {
	0x540E, 0x539A, 0x543C, 0x5589, 0x4FAF, 0x5019, 0x7334, 0x9C8E, 0x7BCC, 0x5820, 0x5F8C, 0x9005, 0x7CC7, 0x9ABA, 0x760A, 0x543D, 
	0x5474, 0x5795, 0x5E3F, 0x6D09, 0x72BC, 0x777A, 0x77E6, 0x7FED, 0x7FF5, 0x8144, 0x8454, 0x8A6C, 0x8BDF, 0x8C5E, 0x90C8, 0x9107, 
	0x9297, 0x936D, 0x9931, 0x9B9C, 0x9BF8, 0x9C5F, 0x9C98, 0x9F41
	};
const TText16 KPinyin158[2] = {'h', 'u', };
const TInt charForPinyin158[171] = {
	0x6E56, 0x6237, 0x547C, 0x864E, 0x58F6, 0x4E92, 0x80E1, 0x62A4, 0x7CCA, 0x5F27, 0x5FFD, 0x72D0, 0x8774, 0x846B, 0x6CAA, 0x4E4E, 
	0x620F, 0x6838, 0x548C, 0x745A, 0x552C, 0x9E55, 0x51B1, 0x6019, 0x9E71, 0x7B0F, 0x623D, 0x6248, 0x9E58, 0x6D52, 0x795C, 0x9190, 
	0x7425, 0x56EB, 0x70C0, 0x8F77, 0x74E0, 0x7173, 0x659B, 0x9E44, 0x7322, 0x60DA, 0x5CB5, 0x6EF9, 0x89F3, 0x553F, 0x69F2, 0x4E55, 
	0x4FFF, 0x51B4, 0x5322, 0x532B, 0x5596, 0x55C0, 0x55C3, 0x5611, 0x561D, 0x569B, 0x5780, 0x58F7, 0x58FA, 0x59F1, 0x5A5F, 0x5AA9, 
	0x5AED, 0x5AEE, 0x5BE3, 0x5E0D, 0x5E60, 0x5F16, 0x6018, 0x6057, 0x622F, 0x6231, 0x6232, 0x6236, 0x6238, 0x6287, 0x6430, 0x6462, 
	0x64ED, 0x6608, 0x6612, 0x66F6, 0x6791, 0x695B, 0x695C, 0x69F4, 0x6B51, 0x6BBB, 0x6C69, 0x6C7B, 0x6C8D, 0x6CD8, 0x6D3F, 0x6DC8, 
	0x6DF2, 0x6DF4, 0x6EEC, 0x6EF8, 0x6FE9, 0x702B, 0x7100, 0x71A9, 0x74E1, 0x74F3, 0x7910, 0x7A6B, 0x7B8E, 0x7BB6, 0x7C04, 0x7C90, 
	0x7D57, 0x7D94, 0x7E0E, 0x7E0F, 0x7E20, 0x7FBD, 0x80CD, 0x81B4, 0x8217, 0x8290, 0x8294, 0x82A6, 0x82B4, 0x82E6, 0x82F8, 0x8400, 
	0x851B, 0x8530, 0x864D, 0x8656, 0x865D, 0x879C, 0x885A, 0x89F7, 0x8A31, 0x8B3C, 0x8B77, 0x8BB8, 0x8C70, 0x8EE4, 0x9120, 0x9237, 
	0x92D8, 0x933F, 0x9359, 0x9378, 0x94B4, 0x96BA, 0x96C7, 0x96D0, 0x96FD, 0x97C4, 0x9800, 0x9836, 0x992C, 0x9B0D, 0x9B71, 0x9BF1, 
	0x9C17, 0x9C6F, 0x9CE0, 0x9CF8, 0x9D29, 0x9D60, 0x9D98, 0x9DA6, 0x9DAE, 0x9DBB, 0x9E0C
	};
const TText16 KPinyin159[3] = {'h', 'u', 'a', };
const TInt charForPinyin159[80] = {
	0x8BDD, 0x82B1, 0x5316, 0x753B, 0x534E, 0x5212, 0x6ED1, 0x54D7, 0x733E, 0x8C41, 0x94E7, 0x6866, 0x9A85, 0x7809, 0x4F89, 0x5283, 
	0x5290, 0x542A, 0x54C7, 0x5629, 0x57D6, 0x59E1, 0x5A72, 0x5A73, 0x5AFF, 0x5B05, 0x5B66, 0x5B78, 0x5D0B, 0x627E, 0x6433, 0x6466, 
	0x64B6, 0x654C, 0x6779, 0x691B, 0x69EC, 0x6A3A, 0x6AB4, 0x6D4D, 0x6F85, 0x6FAE, 0x736A, 0x748D, 0x756B, 0x7575, 0x7874, 0x78C6, 
	0x7A1E, 0x7CBF, 0x7CC0, 0x7E63, 0x8142, 0x8219, 0x82B2, 0x83EF, 0x848D, 0x8550, 0x8624, 0x8633, 0x8796, 0x89DF, 0x8A71, 0x8AAE, 
	0x8AD9, 0x8AE3, 0x8B41, 0x8B6E, 0x8F20, 0x91EA, 0x91EB, 0x92D8, 0x9335, 0x93F5, 0x9A4A, 0x9B64, 0x9BAD, 0x9C91, 0x9DE8, 0x9ECA
	};
const TText16 KPinyin160[4] = {'h', 'u', 'a', 'i', };
const TInt charForPinyin160[24] = {
	0x574F, 0x6000, 0x6DEE, 0x69D0, 0x5F8A, 0x5212, 0x8E1D, 0x4F6A, 0x54B6, 0x559F, 0x5633, 0x5733, 0x576F, 0x58CA, 0x58DE, 0x61D0, 
	0x61F7, 0x6AF0, 0x7024, 0x8032, 0x8639, 0x863E, 0x8922, 0x8931
	};
const TText16 KPinyin161[4] = {'h', 'u', 'a', 'n', };
const TInt charForPinyin161[113] = {
	0x6362, 0x8FD8, 0x5524, 0x73AF, 0x60A3, 0x7F13, 0x6B22, 0x5E7B, 0x5BA6, 0x6DA3, 0x7115, 0x8C62, 0x6853, 0x75EA, 0x6F36, 0x737E, 
	0x64D0, 0x902D, 0x9CA9, 0x90C7, 0x9B1F, 0x5BF0, 0x5942, 0x953E, 0x571C, 0x6D39, 0x8411, 0x7F33, 0x6D63, 0x559A, 0x559B, 0x56BE, 
	0x5702, 0x57B8, 0x581A, 0x5950, 0x5B49, 0x5BCF, 0x5CD8, 0x5D48, 0x5DDC, 0x610C, 0x61C1, 0x61FD, 0x63DB, 0x63F4, 0x650C, 0x6899, 
	0x69F5, 0x6B25, 0x6B53, 0x6B61, 0x6C4D, 0x6E19, 0x6F45, 0x6FA3, 0x6FB4, 0x704C, 0x70C9, 0x7165, 0x72BF, 0x72DF, 0x744D, 0x7457, 
	0x74B0, 0x74DB, 0x7613, 0x7696, 0x7729, 0x7746, 0x7754, 0x778F, 0x77A3, 0x7CEB, 0x7D59, 0x7D84, 0x7DE9, 0x7E6F, 0x7FA6, 0x8092, 
	0x8118, 0x8341, 0x8408, 0x849D, 0x85E7, 0x878C, 0x8838, 0x8B99, 0x8C69, 0x8C72, 0x8C86, 0x8C9B, 0x8F10, 0x8F58, 0x9084, 0x9144, 
	0x926E, 0x9370, 0x9436, 0x956E, 0x95E4, 0x961B, 0x96C8, 0x96DA, 0x9A69, 0x9BC7, 0x9BF6, 0x9C00, 0x9D05, 0x9D4D, 0x9E1B, 0x9E6E, 
	0x9E73
	};
const TText16 KPinyin162[5] = {'h', 'u', 'a', 'n', 'g', };
const TInt charForPinyin162[78] = {
	0x9EC4, 0x614C, 0x6643, 0x8352, 0x7C27, 0x51F0, 0x7687, 0x8C0E, 0x60F6, 0x8757, 0x78FA, 0x604D, 0x714C, 0x5E4C, 0x968D, 0x8093, 
	0x6F62, 0x7BC1, 0x5FA8, 0x9CC7, 0x9051, 0x7640, 0x6E5F, 0x87E5, 0x749C, 0x505F, 0x5164, 0x55A4, 0x582D, 0x5843, 0x58B4, 0x595B, 
	0x5A93, 0x5BBA, 0x5D32, 0x5DDF, 0x6033, 0x6130, 0x63D8, 0x6644, 0x66C2, 0x671A, 0x697B, 0x69A5, 0x6ACE, 0x6C7B, 0x6D38, 0x6EC9, 
	0x70BE, 0x7180, 0x71BF, 0x720C, 0x735A, 0x745D, 0x769D, 0x76A9, 0x7A54, 0x7E28, 0x824E, 0x8292, 0x832B, 0x845F, 0x8841, 0x8A64, 
	0x8AFB, 0x8B0A, 0x8DAA, 0x9360, 0x93A4, 0x9404, 0x953D, 0x97F9, 0x992D, 0x9A1C, 0x9C09, 0x9C51, 0x9DEC, 0x9EC3
	};
const TText16 KPinyin163[3] = {'h', 'u', 'i', };
const TInt charForPinyin163[178] = {
	0x56DE, 0x4F1A, 0x7070, 0x7ED8, 0x6325, 0x6C47, 0x8F89, 0x6BC1, 0x6094, 0x60E0, 0x6666, 0x5FBD, 0x6062, 0x79FD, 0x6167, 0x8D3F, 
	0x86D4, 0x8BB3, 0x5F8A, 0x5349, 0x70E9, 0x8BF2, 0x5F57, 0x6D4D, 0x73F2, 0x8559, 0x5599, 0x605A, 0x54D5, 0x6656, 0x96B3, 0x9EBE, 
	0x8BD9, 0x87EA, 0x8334, 0x6D04, 0x54B4, 0x867A, 0x835F, 0x7F0B, 0x4F6A, 0x50E1, 0x5136, 0x532F, 0x53C0, 0x5612, 0x5645, 0x5655, 
	0x5666, 0x5696, 0x56D8, 0x56EC, 0x571A, 0x5815, 0x58AE, 0x58DE, 0x5A4E, 0x5A88, 0x5B48, 0x5BED, 0x5C77, 0x5E51, 0x5EC6, 0x5EFB, 
	0x5EFD, 0x5F59, 0x5F5A, 0x5FBB, 0x605B, 0x6075, 0x6193, 0x61F3, 0x62FB, 0x63EE, 0x649D, 0x6689, 0x66B3, 0x6703, 0x6867, 0x6932, 
	0x694E, 0x69E5, 0x6A5E, 0x6A85, 0x6A93, 0x6A9C, 0x6AD8, 0x6BC0, 0x6BC7, 0x6CAC, 0x6CCB, 0x6D03, 0x6DA3, 0x6E4F, 0x6ED9, 0x6F53, 
	0x6FAE, 0x6FCA, 0x7008, 0x7073, 0x70DC, 0x70E0, 0x70E3, 0x7147, 0x7152, 0x71EC, 0x71F4, 0x7369, 0x743F, 0x74A4, 0x74AF, 0x75D0, 
	0x7623, 0x7693, 0x772D, 0x7762, 0x7773, 0x77BA, 0x7988, 0x7A62, 0x7BF2, 0x7D75, 0x7E62, 0x7E6A, 0x7FD9, 0x7FDA, 0x7FEC, 0x7FFD, 
	0x8294, 0x8490, 0x8527, 0x8588, 0x8589, 0x85F1, 0x862C, 0x8633, 0x866B, 0x8698, 0x86D5, 0x8716, 0x879D, 0x8886, 0x8918, 0x8958, 
	0x8A6F, 0x8A7C, 0x8AA8, 0x8AF1, 0x8B53, 0x8B6D, 0x8B6E, 0x8B7F, 0x8C57, 0x8CC4, 0x8F1D, 0x8F20, 0x8FDD, 0x8FF4, 0x9025, 0x9055, 
	0x928A, 0x93F8, 0x942C, 0x95E0, 0x9613, 0x9693, 0x9767, 0x97BC, 0x97CB, 0x97E2, 0x97E6, 0x982E, 0x986A, 0x992F, 0x9BB0, 0x9C34, 
	0x9F3F, 0x9F40
	};
const TText16 KPinyin164[3] = {'h', 'u', 'n', };
const TInt charForPinyin164[56] = {
	0x6DF7, 0x660F, 0x8364, 0x6D51, 0x5A5A, 0x9B42, 0x960D, 0x73F2, 0x9984, 0x6EB7, 0x8BE8, 0x4FD2, 0x5031, 0x5702, 0x5A6B, 0x5FF6, 
	0x60DB, 0x60FD, 0x6141, 0x6325, 0x6346, 0x638D, 0x63EE, 0x6606, 0x662C, 0x68A1, 0x68B1, 0x68CD, 0x68D4, 0x6B99, 0x6DBD, 0x6E3E, 
	0x6E63, 0x6E77, 0x7104, 0x711D, 0x743F, 0x7703, 0x7767, 0x776F, 0x7DC4, 0x7DCD, 0x7DE1, 0x7E49, 0x7EF2, 0x7F17, 0x8477, 0x8512, 
	0x89E8, 0x8AE2, 0x8F4B, 0x95BD, 0x9850, 0x991B, 0x992B, 0x9F32
	};
const TText16 KPinyin165[3] = {'h', 'u', 'o', };
const TInt charForPinyin165[86] = {
	0x6216, 0x6D3B, 0x706B, 0x4F19, 0x8D27, 0x548C, 0x83B7, 0x7978, 0x8C41, 0x970D, 0x60D1, 0x56AF, 0x956C, 0x8020, 0x5290, 0x85FF, 
	0x6509, 0x952A, 0x8816, 0x94AC, 0x5925, 0x4F78, 0x4FF0, 0x5268, 0x5316, 0x5419, 0x548A, 0x549F, 0x55C0, 0x5684, 0x56BF, 0x596F, 
	0x59E1, 0x626E, 0x6347, 0x639D, 0x6409, 0x64ED, 0x65E4, 0x66E4, 0x6947, 0x6AB4, 0x6C8E, 0x6E71, 0x6F37, 0x6FCA, 0x6FE9, 0x7016, 
	0x706C, 0x7103, 0x7372, 0x74E0, 0x7668, 0x7713, 0x77C6, 0x77D0, 0x790A, 0x798D, 0x79EE, 0x79F3, 0x7A6B, 0x7BE7, 0x802F, 0x8158, 
	0x8195, 0x81DB, 0x8267, 0x843F, 0x84A6, 0x8AD5, 0x8B0B, 0x8C70, 0x8CA8, 0x8D8A, 0x8D8F, 0x904E, 0x90A9, 0x9225, 0x9343, 0x944A, 
	0x9584, 0x96BB, 0x96D8, 0x9743, 0x9A1E, 0x9B4A
	};
const TText16 KPinyin166[3] = {'h', 'w', 'a', };
const TInt charForPinyin166[1] = {
	0x593B
	};
const TText16 KPinyin167[6] = {'h', 'w', 'e', 'o', 'n', 'g', };
const TInt charForPinyin167[1] = {
	0x9064
	};
const TText16 KPinyin168[1] = {'i', };
const TInt charForPinyin168[1] = {
	0x4E41
	};
const TText16 KPinyin169[2] = {'j', 'i', };
const TInt charForPinyin169[384] = {
	0x51E0, 0x53CA, 0x6025, 0x65E2, 0x5373, 0x673A, 0x9E21, 0x79EF, 0x8BB0, 0x7EA7, 0x6781, 0x8BA1, 0x6324, 0x5DF1, 0x5B63, 0x5BC4, 
	0x7EAA, 0x7CFB, 0x57FA, 0x6FC0, 0x5409, 0x810A, 0x9645, 0x6C72, 0x808C, 0x5AC9, 0x59EC, 0x7EE9, 0x7F09, 0x9965, 0x8FF9, 0x68D8, 
	0x84DF, 0x6280, 0x5180, 0x8F91, 0x4F0E, 0x796D, 0x5242, 0x60B8, 0x6D4E, 0x7C4D, 0x5BC2, 0x671F, 0x5176, 0x5947, 0x5FCC, 0x9F50, 
	0x5993, 0x7EE7, 0x96C6, 0x7ED9, 0x9769, 0x51FB, 0x573E, 0x7B95, 0x8BA5, 0x7578, 0x7A3D, 0x75BE, 0x58BC, 0x6D0E, 0x9C9A, 0x5C50, 
	0x9F51, 0x621F, 0x9CAB, 0x5D47, 0x77F6, 0x7A37, 0x6222, 0x866E, 0x8BD8, 0x7B08, 0x66A8, 0x7B04, 0x525E, 0x53FD, 0x84BA, 0x8DFB, 
	0x5D74, 0x638E, 0x8DFD, 0x9701, 0x5527, 0x757F, 0x8360, 0x7620, 0x7391, 0x7F81, 0x4E0C, 0x5048, 0x82A8, 0x4F76, 0x8D4D, 0x696B, 
	0x9AFB, 0x54AD, 0x857A, 0x89CA, 0x9E82, 0x9AA5, 0x6B9B, 0x5C8C, 0x4E9F, 0x7284, 0x4E69, 0x82B0, 0x54DC, 0x4E2E, 0x4E41, 0x4EBC, 
	0x4F0B, 0x501A, 0x506E, 0x50DF, 0x517E, 0x5209, 0x520F, 0x5264, 0x5291, 0x52E3, 0x5359, 0x535F, 0x537D, 0x539D, 0x53DD, 0x5407, 
	0x5470, 0x559E, 0x55D8, 0x5630, 0x568C, 0x5756, 0x578D, 0x5832, 0x5849, 0x588D, 0x5980, 0x59DE, 0x59FC, 0x5C10, 0x5C45, 0x5C70, 
	0x5C8B, 0x5CDC, 0x5D46, 0x5DAF, 0x5E3A, 0x5E7E, 0x5EB4, 0x5EED, 0x5F50, 0x5F51, 0x5F76, 0x5F9B, 0x5FE3, 0x60CE, 0x6131, 0x61BF, 
	0x61E0, 0x61FB, 0x63D6, 0x63E4, 0x6483, 0x64A0, 0x64BD, 0x64CA, 0x64E0, 0x6532, 0x6567, 0x65E1, 0x65E3, 0x66A9, 0x66C1, 0x6785, 
	0x689E, 0x68CB, 0x6956, 0x6975, 0x69C9, 0x69E3, 0x6A2D, 0x6A5F, 0x6A76, 0x6A95, 0x6A9D, 0x6AB5, 0x6AC5, 0x6AED, 0x6BC4, 0x6C65, 
	0x6CF2, 0x6D01, 0x6DC1, 0x6E08, 0x6E52, 0x6F03, 0x6F08, 0x6F57, 0x6FC8, 0x6FDF, 0x7031, 0x710F, 0x72B1, 0x72E4, 0x7317, 0x7482, 
	0x74A3, 0x74BE, 0x755F, 0x75B5, 0x75F5, 0x7635, 0x7660, 0x766A, 0x7680, 0x768D, 0x777D, 0x7789, 0x77BF, 0x78EF, 0x799D, 0x79A8, 
	0x79F8, 0x7A18, 0x7A29, 0x7A44, 0x7A4A, 0x7A4D, 0x7A56, 0x7A67, 0x7B53, 0x7BBF, 0x7C0A, 0x7C0E, 0x7CA2, 0x7CED, 0x7D00, 0x7D12, 
	0x7D1A, 0x7D50, 0x7D66, 0x7D99, 0x7DDD, 0x7E18, 0x7E3E, 0x7E4B, 0x7E6B, 0x7E7C, 0x7ED3, 0x7F7D, 0x7F87, 0x7F88, 0x8024, 0x802D, 
	0x80D4, 0x8114, 0x8128, 0x818C, 0x81EE, 0x8265, 0x827B, 0x82B6, 0x82D9, 0x830D, 0x8324, 0x838B, 0x8401, 0x8415, 0x846A, 0x84A9, 
	0x8507, 0x8540, 0x8572, 0x858A, 0x85BA, 0x85C9, 0x8604, 0x860E, 0x862E, 0x863B, 0x8640, 0x8721, 0x874D, 0x878F, 0x87E3, 0x87FB, 
	0x87FF, 0x8800, 0x88DA, 0x8900, 0x8940, 0x894B, 0x8989, 0x898A, 0x8998, 0x89AC, 0x89BF, 0x89C7, 0x89CC, 0x89D9, 0x89ED, 0x8A08, 
	0x8A10, 0x8A18, 0x8A8B, 0x8AC5, 0x8AD4, 0x8B4F, 0x8B64, 0x8BA6, 0x8C3B, 0x8C3F, 0x8CEB, 0x8CF7, 0x8D8C, 0x8D9E, 0x8DC2, 0x8DE1, 
	0x8E11, 0x8E16, 0x8E26, 0x8E50, 0x8E5F, 0x8E8B, 0x8EA4, 0x8EB8, 0x8F2F, 0x8F5A, 0x90C5, 0x90C6, 0x913F, 0x9288, 0x92A1, 0x9324, 
	0x9353, 0x93F6, 0x9416, 0x9447, 0x9459, 0x9694, 0x969B, 0x96AE, 0x96DE, 0x96E6, 0x96E7, 0x9735, 0x973D, 0x978A, 0x97BF, 0x97F2, 
	0x98B3, 0x98E2, 0x9951, 0x9A0E, 0x9A65, 0x9A91, 0x9B3E, 0x9B5D, 0x9B62, 0x9B65, 0x9B86, 0x9BDA, 0x9BEF, 0x9BFD, 0x9C36, 0x9C3F, 
	0x9C40, 0x9C6D, 0x9C7E, 0x9CEE, 0x9D4B, 0x9D8F, 0x9DBA, 0x9DC4, 0x9DD1, 0x9E04, 0x9E61, 0x9F4A, 0x9F4C, 0x9F4D, 0x9F4E, 0x9F4F
	};
const TText16 KPinyin170[3] = {'j', 'i', 'a', };
const TInt charForPinyin170[115] = {
	0x5BB6, 0x52A0, 0x5047, 0x4EF7, 0x67B6, 0x7532, 0x4F73, 0x5939, 0x5609, 0x9A7E, 0x5AC1, 0x67B7, 0x835A, 0x988A, 0x94BE, 0x7A3C, 
	0x8304, 0x8D3E, 0x94D7, 0x846D, 0x8FE6, 0x621B, 0x6D43, 0x9553, 0x75C2, 0x605D, 0x5CAC, 0x8DCF, 0x560F, 0x4F3D, 0x80DB, 0x7B33, 
	0x73C8, 0x7615, 0x90CF, 0x8888, 0x86F1, 0x50A2, 0x50F9, 0x53DA, 0x5477, 0x5496, 0x550A, 0x573F, 0x57C9, 0x590F, 0x5913, 0x593E, 
	0x5A7D, 0x5B8A, 0x5E4F, 0x5FA6, 0x5FE6, 0x621E, 0x6274, 0x62B8, 0x62BC, 0x62C1, 0x62EE, 0x6308, 0x631F, 0x633E, 0x63E9, 0x63F3, 
	0x64D6, 0x659A, 0x659D, 0x6687, 0x689C, 0x6935, 0x698E, 0x69A2, 0x69DA, 0x6A9F, 0x6BE0, 0x6CC7, 0x6D79, 0x728C, 0x7330, 0x7333, 
	0x73BE, 0x7B74, 0x7CD8, 0x801E, 0x8125, 0x8175, 0x83A2, 0x86FA, 0x8766, 0x88B7, 0x88CC, 0x8C6D, 0x8C91, 0x8CC8, 0x8DF2, 0x90DF, 
	0x9240, 0x926B, 0x927F, 0x92CF, 0x93B5, 0x94EA, 0x9821, 0x982C, 0x9830, 0x9889, 0x9904, 0x9978, 0x99D5, 0x99F1, 0x9A86, 0x9AB1, 
	0x9D36, 0x9D4A, 0x9E9A
	};
const TText16 KPinyin171[6] = {'j', 'i', 'a', 'l', 'u', 'n', };
const TInt charForPinyin171[1] = {
	0x55E7
	};
const TText16 KPinyin172[4] = {'j', 'i', 'a', 'n', };
const TInt charForPinyin172[276] = {
	0x89C1, 0x4EF6, 0x51CF, 0x5C16, 0x95F4, 0x952E, 0x8D31, 0x80A9, 0x517C, 0x5EFA, 0x68C0, 0x7BAD, 0x714E, 0x7B80, 0x526A, 0x6B7C, 
	0x76D1, 0x575A, 0x5978, 0x5065, 0x8270, 0x8350, 0x5251, 0x6E10, 0x6E85, 0x6DA7, 0x9274, 0x6D45, 0x8DF5, 0x6361, 0x67EC, 0x7B3A, 
	0x4FED, 0x78B1, 0x7877, 0x62E3, 0x8230, 0x69DB, 0x7F04, 0x8327, 0x996F, 0x7FE6, 0x97AF, 0x620B, 0x8C0F, 0x726E, 0x67A7, 0x8171, 
	0x8DBC, 0x7F23, 0x641B, 0x622C, 0x6BFD, 0x83C5, 0x9CA3, 0x7B15, 0x8C2B, 0x6957, 0x56DD, 0x8E47, 0x88E5, 0x8E3A, 0x7751, 0x8B07, 
	0x9E63, 0x84B9, 0x50ED, 0x950F, 0x6E54, 0x4F9F, 0x4FF4, 0x5039, 0x5042, 0x5094, 0x50E3, 0x5109, 0x51BF, 0x524D, 0x5263, 0x5271, 
	0x528D, 0x528E, 0x5292, 0x5294, 0x558A, 0x56CF, 0x5805, 0x5811, 0x583F, 0x5879, 0x58B9, 0x59E6, 0x59E7, 0x5B71, 0x5BCB, 0x5E34, 
	0x5E75, 0x5F3F, 0x5F45, 0x5FA4, 0x60E4, 0x6214, 0x6229, 0x6338, 0x63C0, 0x63C3, 0x63F5, 0x64BF, 0x64F6, 0x6515, 0x65D4, 0x6695, 
	0x6701, 0x67D9, 0x682B, 0x6898, 0x691C, 0x6937, 0x693E, 0x6997, 0x6A2B, 0x6A4C, 0x6A4F, 0x6A7A, 0x6AA2, 0x6ABB, 0x6AFC, 0x6BB1, 
	0x6BB2, 0x6D0A, 0x6D80, 0x6DFA, 0x6E1B, 0x6E55, 0x6EE5, 0x6F38, 0x6F97, 0x6FEB, 0x6FFA, 0x7010, 0x7033, 0x7038, 0x703D, 0x719E, 
	0x71B8, 0x724B, 0x728D, 0x730F, 0x73AA, 0x73D4, 0x744A, 0x7450, 0x76E3, 0x7777, 0x77AF, 0x77B7, 0x77BC, 0x788A, 0x78F5, 0x7900, 
	0x7906, 0x791B, 0x7A34, 0x7B67, 0x7B8B, 0x7BB4, 0x7BEF, 0x7C21, 0x7C48, 0x7C5B, 0x7CCB, 0x7D78, 0x7DD8, 0x7E11, 0x7E5D, 0x7E6D, 
	0x7E8E, 0x7E96, 0x7EA4, 0x807B, 0x81F6, 0x8266, 0x8271, 0x831B, 0x83FA, 0x844C, 0x844F, 0x8465, 0x852A, 0x8551, 0x8573, 0x85A6, 
	0x85C6, 0x8643, 0x87B9, 0x8812, 0x88B8, 0x8947, 0x8949, 0x897A, 0x898B, 0x89B5, 0x89B8, 0x8A43, 0x8AD3, 0x8AEB, 0x8B2D, 0x8B56, 
	0x8B7C, 0x8B7E, 0x8C2E, 0x8C5C, 0x8C63, 0x8CCE, 0x8CE4, 0x8D9D, 0x8DC8, 0x8E10, 0x8F5E, 0x918E, 0x91B6, 0x91F0, 0x91FC, 0x9203, 
	0x9292, 0x92AD, 0x92C4, 0x92D1, 0x92FB, 0x9322, 0x932C, 0x933D, 0x934A, 0x9373, 0x9375, 0x93AB, 0x93E9, 0x9417, 0x9427, 0x9431, 
	0x9451, 0x9452, 0x946C, 0x946F, 0x9473, 0x9498, 0x94B1, 0x9592, 0x9593, 0x9669, 0x96AA, 0x976C, 0x97AC, 0x97C0, 0x97C9, 0x991E, 
	0x9930, 0x99A2, 0x9A2B, 0x9A9E, 0x9B0B, 0x9C0E, 0x9C14, 0x9C1C, 0x9C39, 0x9CD2, 0x9CFD, 0x9D73, 0x9DBC, 0x9E78, 0x9E79, 0x9E7B, 
	0x9E7C, 0x9E89, 0x9EDA, 0x9EEC
	};
const TText16 KPinyin173[5] = {'j', 'i', 'a', 'n', 'g', };
const TInt charForPinyin173[73] = {
	0x5C06, 0x8BB2, 0x6C5F, 0x5956, 0x964D, 0x6D46, 0x50F5, 0x59DC, 0x9171, 0x848B, 0x7586, 0x5320, 0x5F3A, 0x6868, 0x8679, 0x8C47, 
	0x7913, 0x7F30, 0x729F, 0x8029, 0x7EDB, 0x8333, 0x7CE8, 0x6D1A, 0x508B, 0x52E5, 0x531E, 0x5842, 0x58C3, 0x5905, 0x5968, 0x596C, 
	0x5C07, 0x5D79, 0x5F1C, 0x5F36, 0x5F37, 0x5F4A, 0x646A, 0x647E, 0x6762, 0x69F3, 0x6A7F, 0x6AE4, 0x6BAD, 0x6EF0, 0x6F3F, 0x734E, 
	0x7555, 0x757A, 0x7585, 0x7CE1, 0x7D05, 0x7D73, 0x7E6E, 0x7EA2, 0x7FDE, 0x8199, 0x8441, 0x8503, 0x8523, 0x8591, 0x8780, 0x87BF, 
	0x88B6, 0x8B1B, 0x8B3D, 0x91A4, 0x91AC, 0x97C1, 0x985C, 0x9C42, 0x9CC9
	};
const TText16 KPinyin174[4] = {'j', 'i', 'a', 'o', };
const TInt charForPinyin174[169] = {
	0x53EB, 0x811A, 0x4EA4, 0x89D2, 0x6559, 0x8F83, 0x7F34, 0x89C9, 0x7126, 0x80F6, 0x5A07, 0x7EDE, 0x6821, 0x6405, 0x9A84, 0x72E1, 
	0x6D47, 0x77EB, 0x90CA, 0x56BC, 0x8549, 0x8F7F, 0x7A96, 0x6912, 0x7901, 0x997A, 0x94F0, 0x9175, 0x4FA5, 0x527F, 0x5FBC, 0x827D, 
	0x50EC, 0x86DF, 0x656B, 0x5CE4, 0x8DE4, 0x59E3, 0x768E, 0x832D, 0x9E6A, 0x564D, 0x91AE, 0x4F7C, 0x6E6B, 0x9C9B, 0x6322, 0x4E54, 
	0x4FA8, 0x50D1, 0x50E5, 0x510C, 0x528B, 0x52E6, 0x52EA, 0x5374, 0x537B, 0x544C, 0x54AC, 0x55AC, 0x5602, 0x5604, 0x5610, 0x5626, 
	0x566D, 0x5996, 0x5AF6, 0x5B0C, 0x5B13, 0x5B42, 0x5B66, 0x5B78, 0x5CE7, 0x5D7A, 0x5D95, 0x5DA0, 0x5DA3, 0x6054, 0x608E, 0x618D, 
	0x61A2, 0x61BF, 0x630D, 0x6341, 0x6477, 0x649F, 0x64B9, 0x652A, 0x654E, 0x6565, 0x657D, 0x657F, 0x65A0, 0x6648, 0x669E, 0x66D2, 
	0x6A14, 0x6A4B, 0x6AF5, 0x6E6C, 0x6ED8, 0x6F16, 0x6F50, 0x6F86, 0x6FC0, 0x7042, 0x705A, 0x70C4, 0x7133, 0x714D, 0x71CB, 0x7365, 
	0x73D3, 0x74AC, 0x76A6, 0x76AD, 0x77EF, 0x7A3E, 0x7A5A, 0x7A8C, 0x7B05, 0x7B4A, 0x7C25, 0x7CFE, 0x7D5E, 0x7E73, 0x7E90, 0x7EA0, 
	0x8173, 0x81A0, 0x81B2, 0x81EB, 0x8281, 0x832E, 0x83FD, 0x8429, 0x854E, 0x85E0, 0x8660, 0x87DC, 0x87ED, 0x8990, 0x899A, 0x89BA, 
	0x8A06, 0x8B51, 0x8B65, 0x8CCB, 0x8DAB, 0x8DAD, 0x8E0B, 0x8E7B, 0x8F03, 0x8F47, 0x8F4E, 0x9117, 0x91C2, 0x91E5, 0x9278, 0x940E, 
	0x9903, 0x9A55, 0x9AB9, 0x9BAB, 0x9C4E, 0x9D41, 0x9D64, 0x9DE6, 0x9DEE
	};
const TText16 KPinyin175[3] = {'j', 'i', 'e', };
const TInt charForPinyin175[187] = {
	0x63A5, 0x8282, 0x8857, 0x501F, 0x7686, 0x622A, 0x89E3, 0x754C, 0x7ED3, 0x5C4A, 0x59D0, 0x63ED, 0x6212, 0x4ECB, 0x9636, 0x52AB, 
	0x82A5, 0x7AED, 0x6D01, 0x75A5, 0x85C9, 0x4EF7, 0x6977, 0x79F8, 0x6854, 0x6770, 0x6377, 0x8BEB, 0x776B, 0x5BB6, 0x5048, 0x6840, 
	0x5588, 0x62EE, 0x9AB1, 0x7FAF, 0x86A7, 0x55DF, 0x9889, 0x9C92, 0x5A55, 0x78A3, 0x8BA6, 0x5B51, 0x7596, 0x8BD8, 0x4E2F, 0x4EA5, 
	0x5022, 0x5047, 0x507C, 0x5091, 0x50F9, 0x5226, 0x5227, 0x523C, 0x52BC, 0x5369, 0x536A, 0x5424, 0x5527, 0x5536, 0x5551, 0x568C, 
	0x573E, 0x5826, 0x583A, 0x5951, 0x5979, 0x598E, 0x5A8E, 0x5A98, 0x5AAB, 0x5AC5, 0x5C10, 0x5C46, 0x5C8A, 0x5C95, 0x5D28, 0x5D51, 
	0x5D65, 0x5DB0, 0x5DBB, 0x5DC0, 0x5E6F, 0x5E8E, 0x5FA3, 0x5FE6, 0x6088, 0x6262, 0x62C5, 0x62FE, 0x63B2, 0x6429, 0x64D1, 0x64EE, 
	0x64F3, 0x65BA, 0x6605, 0x66A8, 0x66C1, 0x685D, 0x6904, 0x6950, 0x696C, 0x6976, 0x6982, 0x69A4, 0x69CB, 0x6A9E, 0x6AED, 0x6BD1, 
	0x6D2F, 0x6E07, 0x6E34, 0x6E5D, 0x6ED0, 0x6F54, 0x716F, 0x7297, 0x72E4, 0x736C, 0x73A0, 0x743E, 0x754D, 0x758C, 0x75CE, 0x7664, 
	0x780E, 0x781D, 0x790D, 0x7956, 0x7A2D, 0x7BC0, 0x7C4D, 0x7D07, 0x7D12, 0x7D50, 0x7D5C, 0x7E72, 0x7EA5, 0x8024, 0x813B, 0x8250, 
	0x83AD, 0x83E8, 0x84F5, 0x86E3, 0x86F6, 0x8710, 0x874D, 0x8754, 0x8818, 0x881E, 0x883D, 0x8871, 0x8878, 0x8893, 0x88B7, 0x88BA, 
	0x88D3, 0x892F, 0x89E7, 0x8A10, 0x8A70, 0x8AA1, 0x8AB1, 0x8B2F, 0x8D8C, 0x8DF2, 0x8E15, 0x8FFC, 0x9263, 0x9347, 0x937B, 0x9534, 
	0x968E, 0x96C3, 0x9782, 0x978A, 0x9821, 0x98F7, 0x9AEB, 0x9B5D, 0x9B6A, 0x9B9A, 0x9D9B
	};
const TText16 KPinyin176[3] = {'j', 'i', 'n', };
const TInt charForPinyin176[114] = {
	0x8FDB, 0x8FD1, 0x4ECA, 0x4EC5, 0x7D27, 0x91D1, 0x65A4, 0x5C3D, 0x52B2, 0x7981, 0x6D78, 0x9526, 0x664B, 0x7B4B, 0x6D25, 0x8C28, 
	0x5DFE, 0x895F, 0x70EC, 0x9773, 0x5ED1, 0x747E, 0x9991, 0x69FF, 0x887F, 0x5807, 0x8369, 0x77DC, 0x5664, 0x7F19, 0x537A, 0x5997, 
	0x8D46, 0x89D0, 0x4F12, 0x4FAD, 0x50C5, 0x50F8, 0x5118, 0x5153, 0x51DA, 0x52A4, 0x52C1, 0x53AA, 0x541F, 0x552B, 0x568D, 0x57D0, 
	0x583B, 0x5890, 0x58D7, 0x5A5C, 0x5AE4, 0x5B10, 0x5B27, 0x5BD6, 0x5D9C, 0x5DF9, 0x60CD, 0x616C, 0x6422, 0x65B3, 0x6649, 0x6783, 
	0x6997, 0x6B4F, 0x6BA3, 0x6D55, 0x6E8D, 0x6F0C, 0x6FC5, 0x6FDC, 0x7161, 0x71FC, 0x73D2, 0x740E, 0x743B, 0x7468, 0x74A1, 0x74B6, 
	0x76E1, 0x781B, 0x7972, 0x7AFB, 0x7B12, 0x7D1F, 0x7D3E, 0x7DCA, 0x7E09, 0x808B, 0x81F8, 0x8355, 0x83EB, 0x83F3, 0x84F3, 0x85CE, 
	0x89B2, 0x89D4, 0x8A21, 0x8B39, 0x8CEE, 0x8D10, 0x9032, 0x91D2, 0x91FF, 0x92DF, 0x9326, 0x9485, 0x9513, 0x9949, 0x99B8, 0x9E76, 
	0x9EC5, 0x9F7D
	};
const TText16 KPinyin177[4] = {'j', 'i', 'n', 'g', };
const TInt charForPinyin177[134] = {
	0x7ADF, 0x9759, 0x4E95, 0x60CA, 0x7ECF, 0x955C, 0x4EAC, 0x51C0, 0x656C, 0x7CBE, 0x666F, 0x8B66, 0x7ADE, 0x5883, 0x5F84, 0x8346, 
	0x6676, 0x9CB8, 0x7CB3, 0x9888, 0x5162, 0x830E, 0x775B, 0x52B2, 0x75C9, 0x9756, 0x80BC, 0x734D, 0x9631, 0x8148, 0x5F2A, 0x522D, 
	0x61AC, 0x5A67, 0x80EB, 0x83C1, 0x5106, 0x65CC, 0x8FF3, 0x9753, 0x6CFE, 0x4E3C, 0x4EB0, 0x4EF1, 0x4FD3, 0x501E, 0x50B9, 0x512C, 
	0x51C8, 0x5244, 0x52A4, 0x52C1, 0x5753, 0x5755, 0x5759, 0x598C, 0x5A59, 0x5A5B, 0x5B91, 0x5DE0, 0x5E5C, 0x5F33, 0x5F91, 0x61BC, 
	0x64CF, 0x65CD, 0x665F, 0x66BB, 0x66D4, 0x6871, 0x68B7, 0x6A78, 0x6AA0, 0x6B91, 0x6C0F, 0x6C6B, 0x6C6C, 0x6D44, 0x6D87, 0x6DE8, 
	0x6FEA, 0x701E, 0x70C3, 0x70F4, 0x71DD, 0x7304, 0x7377, 0x7484, 0x749F, 0x74A5, 0x75D9, 0x79D4, 0x7A09, 0x7A7D, 0x7AE7, 0x7AEB, 
	0x7AF6, 0x7AF8, 0x7B90, 0x7C87, 0x7D4C, 0x7D93, 0x8059, 0x811B, 0x834A, 0x8396, 0x845D, 0x873B, 0x87FC, 0x8AA9, 0x8E01, 0x9015, 
	0x9192, 0x92DE, 0x93E1, 0x9649, 0x9658, 0x9751, 0x9752, 0x9758, 0x975A, 0x975C, 0x981A, 0x9834, 0x9838, 0x9895, 0x9A5A, 0x9BE8, 
	0x9D5B, 0x9D81, 0x9D84, 0x9E96, 0x9EA0, 0x9F31
	};
const TText16 KPinyin178[5] = {'j', 'i', 'o', 'n', 'g', };
const TInt charForPinyin178[42] = {
	0x7A98, 0x70AF, 0x6243, 0x8FE5, 0x4FB0, 0x50D2, 0x5182, 0x518B, 0x518F, 0x56E7, 0x5770, 0x57A7, 0x57DB, 0x5BAD, 0x6244, 0x660B, 
	0x6CC2, 0x6D7B, 0x6F83, 0x7005, 0x7085, 0x70F1, 0x715A, 0x715B, 0x7192, 0x71B2, 0x71D1, 0x71DB, 0x7D45, 0x7D97, 0x81E6, 0x81E9, 
	0x860F, 0x8614, 0x8927, 0x9008, 0x9284, 0x93A3, 0x9848, 0x988E, 0x99C9, 0x99EB
	};
const TText16 KPinyin179[3] = {'j', 'i', 'u', };
const TInt charForPinyin179[79] = {
	0x5C31, 0x4E5D, 0x9152, 0x65E7, 0x4E45, 0x63EA, 0x6551, 0x7EA0, 0x8205, 0x7A76, 0x97ED, 0x53A9, 0x81FC, 0x7396, 0x7078, 0x548E, 
	0x759A, 0x8D73, 0x9E6B, 0x8E74, 0x50E6, 0x67E9, 0x6855, 0x9B0F, 0x9E20, 0x9604, 0x557E, 0x4E29, 0x4E46, 0x4E63, 0x5003, 0x5279, 
	0x52FC, 0x5313, 0x531B, 0x5336, 0x564D, 0x597A, 0x5EC4, 0x5ECF, 0x5ED0, 0x6101, 0x6166, 0x6344, 0x63C2, 0x63EB, 0x644E, 0x673B, 
	0x6766, 0x67FE, 0x6A1B, 0x6A5A, 0x6BA7, 0x6C3F, 0x6C63, 0x6E6B, 0x6E6C, 0x725E, 0x7542, 0x7A35, 0x7A4B, 0x7A8C, 0x7CFA, 0x7CFE, 
	0x7D24, 0x7E46, 0x7F2A, 0x820A, 0x820F, 0x841B, 0x8764, 0x9579, 0x97EE, 0x9B2E, 0x9BE6, 0x9CE9, 0x9DF2, 0x9E94, 0x9F68
	};
const TText16 KPinyin180[3] = {'j', 'o', 'u', };
const TInt charForPinyin180[1] = {
	0x6B0D
	};
const TText16 KPinyin181[2] = {'j', 'u', };
const TInt charForPinyin181[222] = {
	0x53E5, 0x4E3E, 0x5DE8, 0x5C40, 0x5177, 0x8DDD, 0x952F, 0x5267, 0x5C45, 0x805A, 0x62D8, 0x83CA, 0x77E9, 0x6CAE, 0x62D2, 0x60E7, 
	0x97A0, 0x72D9, 0x9A79, 0x4E14, 0x636E, 0x67DC, 0x6854, 0x4FF1, 0x8F66, 0x5480, 0x75BD, 0x8E1E, 0x70AC, 0x5028, 0x91B5, 0x88FE, 
	0x5C66, 0x728B, 0x82F4, 0x7AAD, 0x98D3, 0x9514, 0x6910, 0x82E3, 0x741A, 0x63AC, 0x6998, 0x9F83, 0x8D84, 0x8392, 0x96CE, 0x907D, 
	0x6A58, 0x8E3D, 0x6989, 0x97AB, 0x949C, 0x8BB5, 0x67B8, 0x4EC7, 0x4F21, 0x4F5D, 0x4FB7, 0x4FE5, 0x5036, 0x50EA, 0x51A3, 0x51E5, 
	0x5287, 0x52EE, 0x530A, 0x544A, 0x5727, 0x5765, 0x57E7, 0x57FE, 0x58C9, 0x59D0, 0x59D6, 0x5A35, 0x5A36, 0x5A45, 0x5A6E, 0x5BE0, 
	0x5C68, 0x5CA0, 0x5CA8, 0x5D0C, 0x5DC8, 0x5F06, 0x5FC2, 0x6007, 0x6010, 0x601A, 0x6133, 0x61C5, 0x61FC, 0x6285, 0x62E0, 0x62F1, 
	0x6319, 0x6336, 0x6344, 0x63C8, 0x63DF, 0x64DA, 0x64E7, 0x661B, 0x68AE, 0x6907, 0x6908, 0x6A8B, 0x6AF8, 0x6B05, 0x6B6B, 0x6BE9, 
	0x6BF1, 0x6CC3, 0x6CE6, 0x6D30, 0x6DBA, 0x6DD7, 0x6E20, 0x6E68, 0x6FBD, 0x7117, 0x7123, 0x7220, 0x7291, 0x72CA, 0x73C7, 0x75C0, 
	0x7717, 0x77BF, 0x7820, 0x79DF, 0x79EC, 0x7AB6, 0x7B65, 0x7BD3, 0x7C0D, 0x7C34, 0x7C67, 0x7C94, 0x7CB7, 0x7F5D, 0x801F, 0x8065, 
	0x8152, 0x81C4, 0x8209, 0x824D, 0x83F9, 0x842D, 0x8445, 0x848C, 0x849F, 0x84A9, 0x84FB, 0x851E, 0x861C, 0x8627, 0x8655, 0x8661, 
	0x86B7, 0x86C6, 0x871B, 0x87B6, 0x8893, 0x8977, 0x8A4E, 0x8ACA, 0x8C66, 0x8C97, 0x8D89, 0x8D9C, 0x8DA1, 0x8DB3, 0x8DD4, 0x8DD9, 
	0x8DFC, 0x8E18, 0x8E6B, 0x8E7B, 0x8E86, 0x8EB9, 0x8EE5, 0x8F02, 0x90AD, 0x90B9, 0x90E5, 0x90F0, 0x90F9, 0x9112, 0x9139, 0x9245, 
	0x924F, 0x92E4, 0x92E6, 0x92F8, 0x943B, 0x9504, 0x95B0, 0x9671, 0x96CF, 0x96DB, 0x98B6, 0x99CF, 0x99D2, 0x99F6, 0x9A55, 0x9A67, 
	0x9A84, 0x9B3B, 0x9B88, 0x9B8D, 0x9B94, 0x9C8F, 0x9D21, 0x9D59, 0x9D74, 0x9D8B, 0x9DAA, 0x9F30, 0x9F33, 0x9F5F
	};
const TText16 KPinyin182[4] = {'j', 'u', 'a', 'n', };
const TInt charForPinyin182[80] = {
	0x5377, 0x5708, 0x5026, 0x9E43, 0x6350, 0x5A1F, 0x7737, 0x7EE2, 0x9104, 0x9529, 0x8832, 0x954C, 0x72F7, 0x684A, 0x6D93, 0x96BD, 
	0x52B5, 0x52CC, 0x52EC, 0x545F, 0x570F, 0x57CD, 0x57E2, 0x5946, 0x59E2, 0x5DB2, 0x5DC2, 0x5E23, 0x5F2E, 0x6081, 0x60D3, 0x617B, 
	0x6372, 0x64D0, 0x6718, 0x688B, 0x68EC, 0x6CEB, 0x6DC3, 0x7106, 0x7367, 0x74F9, 0x7504, 0x7729, 0x7743, 0x774A, 0x7760, 0x7D6D, 
	0x7D79, 0x7E33, 0x7F65, 0x7F82, 0x8127, 0x8143, 0x81C7, 0x83E4, 0x8412, 0x8528, 0x854A, 0x854B, 0x8737, 0x88D0, 0x8948, 0x8B82, 
	0x8E21, 0x8EAB, 0x92D1, 0x92D7, 0x9308, 0x93B8, 0x942B, 0x95C2, 0x96CB, 0x96DF, 0x9799, 0x97CF, 0x98EC, 0x990B, 0x9D4D, 0x9D51
	};
const TText16 KPinyin183[3] = {'j', 'u', 'e', };
const TInt charForPinyin183[144] = {
	0x51B3, 0x7EDD, 0x89C9, 0x89D2, 0x7235, 0x6398, 0x8BC0, 0x6485, 0x5014, 0x6289, 0x652B, 0x56BC, 0x811A, 0x6877, 0x5671, 0x6A5B, 
	0x55DF, 0x89D6, 0x5282, 0x721D, 0x77CD, 0x9562, 0x7357, 0x73CF, 0x5D1B, 0x8568, 0x5658, 0x8C32, 0x8E76, 0x5B53, 0x53A5, 0x4E59, 
	0x4E85, 0x5095, 0x5214, 0x52EA, 0x5337, 0x53CF, 0x5437, 0x5573, 0x57C6, 0x58C6, 0x592C, 0x599C, 0x5B52, 0x5C48, 0x5C69, 0x5C6B, 
	0x5D2B, 0x5DA1, 0x5DA5, 0x5F21, 0x5F4F, 0x61A0, 0x61B0, 0x6204, 0x6317, 0x6354, 0x64A7, 0x658D, 0x67FD, 0x6A5C, 0x6B14, 0x6B2E, 
	0x6B8C, 0x6C12, 0x6C7A, 0x6CEC, 0x6F4F, 0x704D, 0x7106, 0x7133, 0x71A6, 0x71CB, 0x7211, 0x7234, 0x72C2, 0x7383, 0x73A6, 0x73A8, 
	0x7474, 0x749A, 0x75A6, 0x761A, 0x77DE, 0x77E1, 0x7804, 0x7A71, 0x7A74, 0x7D55, 0x7D76, 0x7E51, 0x7E58, 0x8173, 0x81C4, 0x82B5, 
	0x855D, 0x855E, 0x8673, 0x8697, 0x86D9, 0x87E8, 0x87E9, 0x883C, 0x88A6, 0x8990, 0x899A, 0x89BA, 0x89FC, 0x8A23, 0x8AB3, 0x8B4E, 
	0x8C9C, 0x8D7D, 0x8D89, 0x8DB9, 0x8E77, 0x8E7B, 0x8EA9, 0x8F03, 0x8F83, 0x902B, 0x920C, 0x940D, 0x941D, 0x9481, 0x957C, 0x95CB, 
	0x95D5, 0x9615, 0x9619, 0x9792, 0x97BD, 0x99C3, 0x9A24, 0x9A99, 0x9AC9, 0x9C56, 0x9CDC, 0x9D02, 0x9D03, 0x9D8C, 0x9DE2, 0x9FA3
	};
const TText16 KPinyin184[3] = {'j', 'u', 'n', };
const TInt charForPinyin184[69] = {
	0x519B, 0x541B, 0x5747, 0x83CC, 0x4FCA, 0x5CFB, 0x9F9F, 0x7AE3, 0x9A8F, 0x94A7, 0x6D5A, 0x90E1, 0x7B60, 0x9E87, 0x76B2, 0x6343, 
	0x5101, 0x52FB, 0x5300, 0x5441, 0x57C8, 0x59F0, 0x5BEF, 0x61CF, 0x6508, 0x65EC, 0x6659, 0x687E, 0x6C6E, 0x6FEC, 0x710C, 0x711E, 
	0x71C7, 0x72FB, 0x73FA, 0x756F, 0x76B8, 0x76B9, 0x7885, 0x7B98, 0x7B9F, 0x8399, 0x8470, 0x8528, 0x8690, 0x8720, 0x8880, 0x89A0, 
	0x8A07, 0x8ECD, 0x921E, 0x9281, 0x929E, 0x92C6, 0x9355, 0x9656, 0x96BD, 0x96CB, 0x9915, 0x9982, 0x99FF, 0x9BB6, 0x9CAA, 0x9D54, 
	0x9D55, 0x9D58, 0x9E8F, 0x9E95, 0x9F9C
	};
const TText16 KPinyin185[2] = {'k', 'a', };
const TInt charForPinyin185[13] = {
	0x5361, 0x5580, 0x54AF, 0x5496, 0x80E9, 0x5494, 0x4F67, 0x547F, 0x57B0, 0x73C8, 0x8849, 0x88C3, 0x9272
	};
const TText16 KPinyin186[3] = {'k', 'a', 'i', };
const TInt charForPinyin186[51] = {
	0x5F00, 0x63E9, 0x51EF, 0x6168, 0x6977, 0x57B2, 0x5240, 0x950E, 0x94E0, 0x9534, 0x5FFE, 0x607A, 0x8488, 0x51F1, 0x5274, 0x52BE, 
	0x52D3, 0x559D, 0x55AB, 0x5605, 0x5644, 0x584F, 0x5952, 0x5D66, 0x5E46, 0x6112, 0x6137, 0x613E, 0x669F, 0x6838, 0x6B2C, 0x6B2F, 
	0x6E07, 0x6E34, 0x6E98, 0x6FED, 0x708C, 0x708F, 0x70D7, 0x8849, 0x8C48, 0x8F06, 0x9347, 0x938E, 0x93A7, 0x9426, 0x958B, 0x95D3, 
	0x95FF, 0x96C9, 0x98BD
	};
const TText16 KPinyin187[3] = {'k', 'a', 'l', };
const TInt charForPinyin187[1] = {
	0x4E6B
	};
const TText16 KPinyin188[3] = {'k', 'a', 'n', };
const TInt charForPinyin188[49] = {
	0x770B, 0x780D, 0x582A, 0x520A, 0x5D4C, 0x574E, 0x69DB, 0x52D8, 0x9F9B, 0x6221, 0x4F83, 0x77B0, 0x83B0, 0x961A, 0x5058, 0x519A, 
	0x51F5, 0x558A, 0x57F3, 0x583F, 0x586A, 0x5888, 0x5D01, 0x5D41, 0x60C2, 0x627B, 0x681E, 0x6ABB, 0x6B3F, 0x6B41, 0x76E3, 0x77D9, 
	0x78AA, 0x78E1, 0x7AF7, 0x83B6, 0x859F, 0x884E, 0x8B7C, 0x8F21, 0x8F31, 0x8F41, 0x8F57, 0x95DE, 0x976C, 0x9851, 0x9921, 0x9985, 
	0x9F95
	};
const TText16 KPinyin189[4] = {'k', 'a', 'n', 'g', };
const TInt charForPinyin189[35] = {
	0x6297, 0x7095, 0x625B, 0x7CE0, 0x5EB7, 0x6177, 0x4EA2, 0x94AA, 0x95F6, 0x4F09, 0x531F, 0x56E5, 0x5751, 0x594B, 0x5ADD, 0x5D7B, 
	0x5FFC, 0x6443, 0x676D, 0x69FA, 0x6C86, 0x6F2E, 0x72BA, 0x780A, 0x7A45, 0x7C87, 0x8352, 0x8EBF, 0x909F, 0x9227, 0x93EE, 0x958C, 
	0x962C, 0x9AAF, 0x9C47
	};
const TText16 KPinyin190[3] = {'k', 'a', 'o', };
const TInt charForPinyin190[30] = {
	0x9760, 0x8003, 0x70E4, 0x62F7, 0x6832, 0x7292, 0x5C3B, 0x94D0, 0x4E02, 0x5D6A, 0x5F40, 0x6322, 0x641E, 0x649F, 0x6537, 0x69C0, 
	0x69C1, 0x6D18, 0x7105, 0x7187, 0x71FA, 0x7A3E, 0x85A7, 0x85F3, 0x8A04, 0x92AC, 0x9ADB, 0x9BB3, 0x9BCC, 0x9C93
	};
const TText16 KPinyin191[2] = {'k', 'e', };
const TInt charForPinyin191[98] = {
	0x53EF, 0x514B, 0x68F5, 0x79D1, 0x9897, 0x523B, 0x8BFE, 0x5BA2, 0x58F3, 0x6E34, 0x82DB, 0x67EF, 0x78D5, 0x54B3, 0x5777, 0x5475, 
	0x606A, 0x5CA2, 0x874C, 0x7F02, 0x86B5, 0x8F72, 0x7AA0, 0x94B6, 0x6C2A, 0x988F, 0x778C, 0x951E, 0x7A1E, 0x73C2, 0x9AC1, 0x75B4, 
	0x55D1, 0x6E98, 0x9A92, 0x524B, 0x52C0, 0x52CA, 0x533C, 0x5580, 0x5801, 0x5A14, 0x5C05, 0x5CC7, 0x5D51, 0x5D59, 0x5DB1, 0x6088, 
	0x6118, 0x6119, 0x63E2, 0x6415, 0x6564, 0x69BC, 0x6A16, 0x6B2C, 0x6B41, 0x6BBB, 0x6BFC, 0x6E07, 0x6FED, 0x70A3, 0x7241, 0x7290, 
	0x75FE, 0x76CD, 0x7822, 0x785E, 0x78A3, 0x78A6, 0x78C6, 0x790A, 0x791A, 0x7ABC, 0x7C3B, 0x7DD9, 0x7FD7, 0x80E2, 0x8250, 0x842A, 
	0x8596, 0x8849, 0x8894, 0x8AB2, 0x8DB7, 0x8EFB, 0x9198, 0x9233, 0x927F, 0x9301, 0x9312, 0x94EA, 0x9515, 0x9826, 0x9846, 0x9A0D, 
	0x9F95, 0x9F9B
	};
const TText16 KPinyin192[3] = {'k', 'e', 'g', };
const TInt charForPinyin192[1] = {
	0x4E6A
	};
const TText16 KPinyin193[3] = {'k', 'e', 'i', };
const TInt charForPinyin193[5] = {
	0x523B, 0x524B, 0x52C0, 0x52CA, 0x5C05
	};
const TText16 KPinyin194[3] = {'k', 'e', 'm', };
const TInt charForPinyin194[1] = {
	0x8804
	};
const TText16 KPinyin195[3] = {'k', 'e', 'n', };
const TInt charForPinyin195[22] = {
	0x80AF, 0x5543, 0x6073, 0x57A6, 0x88C9, 0x57A0, 0x58BE, 0x61C7, 0x63AF, 0x72E0, 0x73E2, 0x784D, 0x808E, 0x80BB, 0x8903, 0x8C64, 
	0x8C87, 0x9339, 0x980E, 0x9880, 0x9F66, 0x9F88
	};
const TText16 KPinyin196[4] = {'k', 'e', 'n', 'g', };
const TInt charForPinyin196[28] = {
	0x5751, 0x542D, 0x94FF, 0x52A5, 0x5748, 0x595F, 0x5994, 0x5FD0, 0x6333, 0x63C1, 0x647C, 0x6BB8, 0x727C, 0x7841, 0x784D, 0x784E, 
	0x785C, 0x787B, 0x80EB, 0x811B, 0x8A99, 0x8E01, 0x927A, 0x92B5, 0x935E, 0x93D7, 0x94D2, 0x962C
	};
const TText16 KPinyin197[3] = {'k', 'e', 'o', };
const TInt charForPinyin197[2] = {
	0x5DEA, 0x824D
	};
const TText16 KPinyin198[4] = {'k', 'e', 'o', 'l', };
const TInt charForPinyin198[1] = {
	0x4E6C
	};
const TText16 KPinyin199[4] = {'k', 'e', 'o', 'p', };
const TInt charForPinyin199[1] = {
	0x8FF2
	};
const TText16 KPinyin200[4] = {'k', 'e', 'o', 's', };
const TInt charForPinyin200[1] = {
	0x551F
	};
const TText16 KPinyin201[4] = {'k', 'e', 'u', 'm', };
const TInt charForPinyin201[1] = {
	0x53BC
	};
const TText16 KPinyin202[2] = {'k', 'i', };
const TInt charForPinyin202[1] = {
	0x603E
	};
const TText16 KPinyin203[4] = {'k', 'o', 'n', 'g', };
const TInt charForPinyin203[21] = {
	0x7A7A, 0x5B54, 0x63A7, 0x6050, 0x5025, 0x5D06, 0x7B9C, 0x57EA, 0x5B86, 0x60BE, 0x690C, 0x6DB3, 0x77FC, 0x787F, 0x7A79, 0x7FAB, 
	0x8154, 0x8EBB, 0x9313, 0x979A, 0x9D7C
	};
const TText16 KPinyin204[3] = {'k', 'o', 's', };
const TInt charForPinyin204[1] = {
	0x5EE4
	};
const TText16 KPinyin205[3] = {'k', 'o', 'u', };
const TInt charForPinyin205[35] = {
	0x53E3, 0x6263, 0x62A0, 0x5BC7, 0x853B, 0x82A4, 0x770D, 0x7B58, 0x53E9, 0x4F5D, 0x51A6, 0x527E, 0x52B6, 0x59AA, 0x5AD7, 0x5BBC, 
	0x5F44, 0x6010, 0x630E, 0x6473, 0x6542, 0x6BC6, 0x6E9D, 0x6EF1, 0x7717, 0x7789, 0x7798, 0x7A9B, 0x7AD8, 0x7C06, 0x8320, 0x8532, 
	0x91E6, 0x93C2, 0x9DC7
	};
const TText16 KPinyin206[2] = {'k', 'u', };
const TInt charForPinyin206[45] = {
	0x54ED, 0x5E93, 0x82E6, 0x67AF, 0x88E4, 0x7A9F, 0x9177, 0x5233, 0x9AB7, 0x55BE, 0x5800, 0x7ED4, 0x4FC8, 0x53E4, 0x56B3, 0x5710, 
	0x5723, 0x5D2B, 0x5EAB, 0x625D, 0x630E, 0x6341, 0x6398, 0x6430, 0x670F, 0x684D, 0x695B, 0x6CCF, 0x7105, 0x72DC, 0x7614, 0x77FB, 
	0x785E, 0x79D9, 0x7A8B, 0x7D5D, 0x80D0, 0x88B4, 0x8932, 0x8DB6, 0x8DCD, 0x8DE8, 0x90C0, 0x9BAC, 0x9F41
	};
const TText16 KPinyin207[3] = {'k', 'u', 'a', };
const TInt charForPinyin207[23] = {
	0x8DE8, 0x57AE, 0x630E, 0x5938, 0x80EF, 0x4F89, 0x54B5, 0x59F1, 0x6057, 0x6647, 0x6947, 0x7D53, 0x823F, 0x83EF, 0x8550, 0x8894, 
	0x8A87, 0x9299, 0x9301, 0x951E, 0x985D, 0x9ABB, 0x9AC1
	};
const TText16 KPinyin208[4] = {'k', 'u', 'a', 'i', };
const TInt charForPinyin208[36] = {
	0x5FEB, 0x5757, 0x7B77, 0x4F1A, 0x4FA9, 0x54D9, 0x84AF, 0x6D4D, 0x90D0, 0x72EF, 0x810D, 0x5080, 0x5108, 0x51F7, 0x5672, 0x5726, 
	0x584A, 0x58A4, 0x5DDC, 0x5EE5, 0x64D3, 0x65DD, 0x6703, 0x6FAE, 0x736A, 0x74AF, 0x7CE9, 0x81BE, 0x8489, 0x8562, 0x9136, 0x99C3, 
	0x9B20, 0x9B41, 0x9C60, 0x9C99
	};
const TText16 KPinyin209[4] = {'k', 'u', 'a', 'n', };
const TInt charForPinyin209[16] = {
	0x5BBD, 0x6B3E, 0x9ACB, 0x5B8C, 0x5BDB, 0x5BEC, 0x68A1, 0x68F5, 0x6B35, 0x6B40, 0x7ABD, 0x7ABE, 0x9467, 0x9846, 0x9897, 0x9AD6
	};
const TText16 KPinyin210[5] = {'k', 'u', 'a', 'n', 'g', };
const TInt charForPinyin210[65] = {
	0x77FF, 0x7B50, 0x72C2, 0x6846, 0x51B5, 0x65F7, 0x5321, 0x7736, 0x8BF3, 0x909D, 0x7EA9, 0x593C, 0x8BD3, 0x5739, 0x8D36, 0x54D0, 
	0x4E31, 0x5123, 0x5144, 0x52BB, 0x5329, 0x535D, 0x58D9, 0x5CB2, 0x5EE3, 0x5FF9, 0x6047, 0x61EC, 0x61ED, 0x6282, 0x663F, 0x66E0, 
	0x6789, 0x6CC1, 0x6D2D, 0x6E5F, 0x720C, 0x72C5, 0x7716, 0x77CC, 0x783F, 0x7844, 0x78FA, 0x7926, 0x7A6C, 0x7B7A, 0x7D4B, 0x7D56, 
	0x7E8A, 0x8A86, 0x8A91, 0x8CBA, 0x8ED6, 0x8EE0, 0x8EE6, 0x8EED, 0x8FCB, 0x901B, 0x90BC, 0x913A, 0x9271, 0x92DB, 0x945B, 0x9D5F, 
	0x9ECB
	};
const TText16 KPinyin211[3] = {'k', 'u', 'i', };
const TInt charForPinyin211[92] = {
	0x4E8F, 0x6127, 0x594E, 0x7AA5, 0x6E83, 0x8475, 0x9B41, 0x9988, 0x76D4, 0x5080, 0x5CBF, 0x532E, 0x6126, 0x63C6, 0x777D, 0x8DEC, 
	0x8069, 0x7BD1, 0x55B9, 0x9035, 0x668C, 0x8489, 0x609D, 0x559F, 0x9997, 0x8770, 0x9697, 0x5914, 0x5232, 0x5331, 0x537C, 0x5633, 
	0x5ABF, 0x5B07, 0x5C2F, 0x5DCB, 0x5DD9, 0x6192, 0x6223, 0x6646, 0x694F, 0x6951, 0x6A3B, 0x6AC6, 0x6B33, 0x6B78, 0x6BA8, 0x6F70, 
	0x7143, 0x77B6, 0x78C8, 0x7ABA, 0x7C23, 0x7C44, 0x7F3A, 0x8067, 0x806D, 0x8075, 0x80FF, 0x8143, 0x81AD, 0x81FE, 0x848D, 0x8562, 
	0x85C8, 0x862C, 0x8637, 0x8641, 0x8667, 0x89D6, 0x8B09, 0x8E29, 0x8E5E, 0x8EA8, 0x9108, 0x9368, 0x9377, 0x9400, 0x944E, 0x95CB, 
	0x95DA, 0x9615, 0x9803, 0x9804, 0x980D, 0x982F, 0x985D, 0x9877, 0x993D, 0x994B, 0x9A24, 0x9A99
	};
const TText16 KPinyin212[3] = {'k', 'u', 'n', };
const TInt charForPinyin212[63] = {
	0x6346, 0x56F0, 0x6606, 0x5764, 0x9CB2, 0x951F, 0x9AE1, 0x7428, 0x918C, 0x9603, 0x6083, 0x5375, 0x5803, 0x5812, 0x58F8, 0x58FC, 
	0x5A6B, 0x5C21, 0x5D10, 0x5D11, 0x665C, 0x68B1, 0x6D83, 0x6DF7, 0x6F49, 0x711C, 0x71B4, 0x7311, 0x747B, 0x774F, 0x7871, 0x7975, 
	0x7A07, 0x7A1B, 0x7D91, 0x7F64, 0x81D7, 0x83CE, 0x872B, 0x88C8, 0x88CD, 0x88E9, 0x890C, 0x8C64, 0x8C87, 0x9315, 0x95AB, 0x95B8, 
	0x9811, 0x987D, 0x991B, 0x9984, 0x9A09, 0x9AE0, 0x9AE8, 0x9BE4, 0x9C25, 0x9CCF, 0x9D7E, 0x9DA4, 0x9E4D, 0x9F66, 0x9F88
	};
const TText16 KPinyin213[3] = {'k', 'u', 'o', };
const TInt charForPinyin213[36] = {
	0x9614, 0x6269, 0x62EC, 0x5ED3, 0x9002, 0x86DE, 0x681D, 0x4F1A, 0x5233, 0x54D9, 0x564B, 0x5672, 0x61D6, 0x62E1, 0x6304, 0x64F4, 
	0x6703, 0x6870, 0x6F37, 0x6FF6, 0x71ED, 0x7225, 0x79F3, 0x7B48, 0x843F, 0x8440, 0x909D, 0x913A, 0x95CA, 0x9729, 0x979F, 0x97B9, 
	0x97D5, 0x9822, 0x9AFA, 0x9B20
	};
const TText16 KPinyin214[5] = {'k', 'w', 'e', 'o', 'k', };
const TInt charForPinyin214[1] = {
	0x7A52
	};
const TText16 KPinyin215[3] = {'k', 'w', 'i', };
const TInt charForPinyin215[1] = {
	0x6AF7
	};
const TText16 KPinyin216[2] = {'l', 'a', };
const TInt charForPinyin216[45] = {
	0x62C9, 0x5566, 0x8FA3, 0x8721, 0x814A, 0x5587, 0x5783, 0x84DD, 0x843D, 0x760C, 0x908B, 0x782C, 0x524C, 0x65EF, 0x5120, 0x56B9, 
	0x63E6, 0x63E7, 0x641A, 0x647A, 0x64F8, 0x650B, 0x67C6, 0x694B, 0x6AF4, 0x6E82, 0x7209, 0x74CE, 0x7669, 0x78D6, 0x7FCB, 0x81C8, 
	0x81D8, 0x83C8, 0x85DE, 0x874B, 0x8772, 0x881F, 0x8FA2, 0x945E, 0x9574, 0x97A1, 0x9B0E, 0x9BFB, 0x9C72
	};
const TText16 KPinyin217[3] = {'l', 'a', 'i', };
const TInt charForPinyin217[56] = {
	0x6765, 0x8D56, 0x83B1, 0x6FD1, 0x8D49, 0x5D03, 0x6D9E, 0x94FC, 0x7C41, 0x5F95, 0x765E, 0x7750, 0x4F86, 0x4FEB, 0x5008, 0x52D1, 
	0x53B2, 0x553B, 0x5A15, 0x5A61, 0x5D0D, 0x5EB2, 0x5FA0, 0x61F6, 0x650B, 0x68BE, 0x68F6, 0x6AF4, 0x6DF6, 0x7028, 0x702C, 0x730D, 
	0x741C, 0x7669, 0x775E, 0x7B59, 0x7B82, 0x7C5F, 0x840A, 0x85FE, 0x8970, 0x8ABA, 0x8CDA, 0x8CF4, 0x9028, 0x90F2, 0x91D0, 0x9338, 
	0x983C, 0x9842, 0x9A0B, 0x9BE0, 0x9D63, 0x9D86, 0x9EB3, 0x9EE7
	};
const TText16 KPinyin218[3] = {'l', 'a', 'n', };
const TInt charForPinyin218[97] = {
	0x84DD, 0x5170, 0x70C2, 0x62E6, 0x7BEE, 0x61D2, 0x680F, 0x63FD, 0x7F06, 0x6EE5, 0x9611, 0x8C30, 0x5A6A, 0x6F9C, 0x89C8, 0x6984, 
	0x5C9A, 0x8934, 0x9567, 0x6593, 0x7F71, 0x6F24, 0x50CB, 0x5116, 0x53B1, 0x5549, 0x5682, 0x56D2, 0x5754, 0x58C8, 0x58CF, 0x5B3E, 
	0x5B44, 0x5B4F, 0x5D50, 0x5E71, 0x5EE9, 0x5EEA, 0x60CF, 0x61D4, 0x61E2, 0x61F6, 0x64E5, 0x6514, 0x652C, 0x6595, 0x6695, 0x6B04, 
	0x6B16, 0x6B17, 0x6D68, 0x6D9F, 0x6E45, 0x6F23, 0x6FEB, 0x703E, 0x7046, 0x7060, 0x7061, 0x70BC, 0x7149, 0x71D7, 0x71E3, 0x7201, 
	0x721B, 0x7224, 0x7226, 0x74BC, 0x74D3, 0x7937, 0x7C43, 0x7C63, 0x7CF7, 0x7E7F, 0x7E9C, 0x847B, 0x85CD, 0x862B, 0x862D, 0x8955, 
	0x8964, 0x8974, 0x897D, 0x89A7, 0x89BD, 0x8AEB, 0x8B4B, 0x8B95, 0x8C0F, 0x8E9D, 0x90F4, 0x9182, 0x946D, 0x9484, 0x95CC, 0x97CA, 
	0x9872
	};
const TText16 KPinyin219[4] = {'l', 'a', 'n', 'g', };
const TInt charForPinyin219[49] = {
	0x6D6A, 0x72FC, 0x5ECA, 0x90CE, 0x6717, 0x6994, 0x7405, 0x7A02, 0x8782, 0x83A8, 0x5577, 0x9512, 0x9606, 0x8497, 0x4FCD, 0x52C6, 
	0x54F4, 0x5525, 0x57CC, 0x5871, 0x5ACF, 0x5D00, 0x60A2, 0x6716, 0x6724, 0x6879, 0x6A03, 0x6A20, 0x6B34, 0x70FA, 0x746F, 0x7860, 
	0x7B64, 0x7FAE, 0x7FB9, 0x813C, 0x8246, 0x84C8, 0x84E2, 0x870B, 0x8A8F, 0x8E09, 0x8EB4, 0x90D2, 0x90DE, 0x92C3, 0x93AF, 0x95AC, 
	0x99FA
	};
const TText16 KPinyin220[3] = {'l', 'a', 'o', };
const TInt charForPinyin220[63] = {
	0x8001, 0x635E, 0x7262, 0x52B3, 0x70D9, 0x6D9D, 0x843D, 0x59E5, 0x916A, 0x7EDC, 0x4F6C, 0x6F66, 0x8022, 0x94F9, 0x91AA, 0x94D1, 
	0x5520, 0x6833, 0x5D02, 0x75E8, 0x50D7, 0x50DA, 0x52B4, 0x52DE, 0x54BE, 0x54F0, 0x55E0, 0x5610, 0x562E, 0x5AEA, 0x5D97, 0x6045, 
	0x61A5, 0x61A6, 0x6488, 0x64A9, 0x6725, 0x6A51, 0x6A6F, 0x6D76, 0x6F87, 0x72EB, 0x7360, 0x73EF, 0x7646, 0x7853, 0x78F1, 0x7A82, 
	0x7C29, 0x7CA9, 0x7D61, 0x802E, 0x8356, 0x84FC, 0x86EF, 0x87E7, 0x8EC2, 0x8F51, 0x92A0, 0x9412, 0x985F, 0x9ADD, 0x9BB1
	};
const TText16 KPinyin221[2] = {'l', 'e', };
const TInt charForPinyin221[25] = {
	0x4E86, 0x4E50, 0x52D2, 0x808B, 0x9CD3, 0x4EC2, 0x53FB, 0x6CD0, 0x561E, 0x5FC7, 0x6250, 0x697D, 0x6A02, 0x6C3B, 0x725E, 0x738F, 
	0x7833, 0x7AFB, 0x7C15, 0x827B, 0x961E, 0x97F7, 0x990E, 0x9979, 0x9C33
	};
const TText16 KPinyin222[3] = {'l', 'e', 'i', };
const TInt charForPinyin222[83] = {
	0x7C7B, 0x7D2F, 0x6CEA, 0x96F7, 0x5792, 0x52D2, 0x64C2, 0x857E, 0x808B, 0x956D, 0x5121, 0x78CA, 0x7F27, 0x8BD4, 0x8012, 0x9179, 
	0x7FB8, 0x5AD8, 0x6A91, 0x561E, 0x50AB, 0x513D, 0x5362, 0x53BD, 0x54A7, 0x5841, 0x58D8, 0x58E8, 0x6502, 0x6A0F, 0x6AD0, 0x6AD1, 
	0x6B19, 0x6D21, 0x6D99, 0x6DDA, 0x6F2F, 0x7045, 0x74C3, 0x757E, 0x7623, 0x7657, 0x76E7, 0x77CB, 0x78E5, 0x790C, 0x7927, 0x7928, 
	0x7971, 0x79B7, 0x7D6B, 0x7E32, 0x7E87, 0x7E8D, 0x7E9D, 0x7F4D, 0x8137, 0x8142, 0x8502, 0x854C, 0x85DF, 0x8631, 0x8632, 0x863D, 
	0x8646, 0x881D, 0x8A84, 0x8B84, 0x8F60, 0x90F2, 0x9287, 0x9311, 0x9433, 0x9458, 0x9478, 0x9741, 0x981B, 0x982A, 0x985E, 0x98A3, 
	0x9C69, 0x9E13, 0x9F3A
	};
const TText16 KPinyin223[3] = {'l', 'e', 'm', };
const TInt charForPinyin223[1] = {
	0x51A7
	};
const TText16 KPinyin224[3] = {'l', 'e', 'n', };
const TInt charForPinyin224[1] = {
	0x5549
	};
const TText16 KPinyin225[4] = {'l', 'e', 'n', 'g', };
const TInt charForPinyin225[13] = {
	0x51B7, 0x68F1, 0x695E, 0x6123, 0x5844, 0x5030, 0x580E, 0x7756, 0x7890, 0x7A1C, 0x8590, 0x8E1C, 0x8F18
	};
const TText16 KPinyin226[2] = {'l', 'i', };
const TInt charForPinyin226[276] = {
	0x91CC, 0x79BB, 0x529B, 0x7ACB, 0x674E, 0x4F8B, 0x54E9, 0x7406, 0x5229, 0x68A8, 0x5398, 0x793C, 0x5386, 0x4E3D, 0x540F, 0x783E, 
	0x6F13, 0x8389, 0x5088, 0x8354, 0x4FD0, 0x75E2, 0x72F8, 0x7C92, 0x6CA5, 0x96B6, 0x6817, 0x7483, 0x9CA4, 0x5389, 0x52B1, 0x7281, 
	0x9ECE, 0x7BF1, 0x90E6, 0x9E42, 0x7B20, 0x575C, 0x82C8, 0x9CE2, 0x7F21, 0x8DDE, 0x870A, 0x9502, 0x609D, 0x6FA7, 0x7C9D, 0x84E0, 
	0x67A5, 0x8821, 0x9B32, 0x5456, 0x783A, 0x5AE0, 0x7BE5, 0x75A0, 0x75AC, 0x7301, 0x85DC, 0x6EA7, 0x9CA1, 0x623E, 0x680E, 0x5533, 
	0x91B4, 0x8F79, 0x8A48, 0x9A8A, 0x7F79, 0x9026, 0x4FEA, 0x55B1, 0x96F3, 0x9EE7, 0x8385, 0x4FDA, 0x86CE, 0x5A0C, 0x4EC2, 0x4F4D, 
	0x512E, 0x5137, 0x51D3, 0x5215, 0x5217, 0x5253, 0x527A, 0x5299, 0x52F5, 0x53A4, 0x53AF, 0x53B2, 0x53D3, 0x53D5, 0x53FB, 0x550E, 
	0x569F, 0x56A6, 0x56C4, 0x56C7, 0x585B, 0x58E2, 0x5A33, 0x5A6F, 0x5B4B, 0x5B77, 0x5C74, 0x5CA6, 0x5CDB, 0x5CF2, 0x5DC1, 0x5EF2, 
	0x60A1, 0x60A7, 0x60B7, 0x6144, 0x6250, 0x625A, 0x6369, 0x642E, 0x64FD, 0x650A, 0x6526, 0x652D, 0x6584, 0x66A6, 0x66C6, 0x66DE, 
	0x6738, 0x67C2, 0x6803, 0x681B, 0x6835, 0x68B8, 0x68C3, 0x68D9, 0x6A06, 0x6AAA, 0x6AD4, 0x6ADF, 0x6AEA, 0x6B10, 0x6B1A, 0x6B74, 
	0x6B77, 0x6C02, 0x6CB4, 0x6CB5, 0x6CE3, 0x6D6C, 0x6D96, 0x6DDA, 0x6FFC, 0x6FFF, 0x701D, 0x7051, 0x7055, 0x7204, 0x720F, 0x7282, 
	0x729B, 0x72A1, 0x73D5, 0x73DE, 0x740D, 0x746E, 0x74C5, 0x74C8, 0x74D1, 0x74E5, 0x7658, 0x7667, 0x76AA, 0x76E0, 0x76ED, 0x775D, 
	0x77D6, 0x7805, 0x782C, 0x784C, 0x78FF, 0x792A, 0x792B, 0x7930, 0x79AE, 0x79B2, 0x79DD, 0x7A72, 0x7AF0, 0x7B63, 0x7C6C, 0x7C9A, 
	0x7CB4, 0x7CCE, 0x7CF2, 0x7D9F, 0x7E2D, 0x7E85, 0x7E9A, 0x7FEE, 0x8137, 0x8243, 0x82D9, 0x8318, 0x8372, 0x83DE, 0x849A, 0x849E, 
	0x853E, 0x85F6, 0x863A, 0x86B8, 0x86E0, 0x8727, 0x8755, 0x8777, 0x87CD, 0x87F8, 0x8807, 0x8823, 0x882B, 0x88CF, 0x88E1, 0x8935, 
	0x89FB, 0x8B27, 0x8B88, 0x8C4A, 0x8C8D, 0x8D72, 0x8E92, 0x8F62, 0x8F63, 0x908C, 0x9090, 0x9148, 0x91A8, 0x91C3, 0x91D0, 0x925D, 
	0x9290, 0x92EB, 0x92F0, 0x9305, 0x9311, 0x9398, 0x93EB, 0x9457, 0x9460, 0x94C4, 0x9549, 0x96B7, 0x96B8, 0x96E2, 0x973E, 0x9742, 
	0x974B, 0x98AF, 0x98D2, 0x9A6A, 0x9B01, 0x9B34, 0x9BC9, 0x9BCF, 0x9BEC, 0x9C67, 0x9C71, 0x9C73, 0x9C7A, 0x9CE8, 0x9D17, 0x9D79, 
	0x9DC5, 0x9E1D, 0x9E97, 0x9E9C
	};
const TText16 KPinyin227[3] = {'l', 'i', 'a', };
const TInt charForPinyin227[2] = {
	0x4FE9, 0x5006
	};
const TText16 KPinyin228[4] = {'l', 'i', 'a', 'n', };
const TInt charForPinyin228[116] = {
	0x8FDE, 0x8054, 0x7EC3, 0x83B2, 0x604B, 0x8138, 0x70BC, 0x94FE, 0x655B, 0x601C, 0x5EC9, 0x5E18, 0x9570, 0x6D9F, 0x880A, 0x740F, 
	0x6B93, 0x8539, 0x9CA2, 0x5941, 0x6F4B, 0x81C1, 0x88E2, 0x6FC2, 0x88E3, 0x695D, 0x4EB7, 0x4EE4, 0x50C6, 0x5286, 0x5332, 0x5333, 
	0x55F9, 0x5652, 0x581C, 0x5969, 0x5A08, 0x5AA1, 0x5AFE, 0x5B1A, 0x5B4C, 0x6169, 0x6190, 0x6200, 0x631B, 0x641B, 0x6459, 0x64BF, 
	0x6523, 0x6582, 0x68BF, 0x69CF, 0x69E4, 0x6AE3, 0x6B04, 0x6B5B, 0x6BAE, 0x6D70, 0x6E45, 0x6E93, 0x6F23, 0x6FB0, 0x6FD3, 0x7032, 
	0x7149, 0x7191, 0x71EB, 0x7453, 0x7489, 0x77B5, 0x78CF, 0x7A34, 0x7C3E, 0x7C62, 0x7C68, 0x7DF4, 0x7E3A, 0x7E9E, 0x7FB7, 0x7FB8, 
	0x7FF4, 0x8068, 0x806B, 0x806E, 0x806F, 0x81A6, 0x81C9, 0x82D3, 0x83B6, 0x8430, 0x84EE, 0x8595, 0x859F, 0x861D, 0x861E, 0x878A, 
	0x8933, 0x895D, 0x899D, 0x8B30, 0x8B67, 0x8E65, 0x9023, 0x913B, 0x91B6, 0x932C, 0x934A, 0x938C, 0x93C8, 0x942E, 0x9567, 0x96F6, 
	0x9B11, 0x9C0A, 0x9C31, 0x9C44
	};
const TText16 KPinyin229[5] = {'l', 'i', 'a', 'n', 'g', };
const TInt charForPinyin229[55] = {
	0x4E24, 0x4EAE, 0x8F86, 0x51C9, 0x7CAE, 0x6881, 0x91CF, 0x826F, 0x667E, 0x8C05, 0x4FE9, 0x7CB1, 0x589A, 0x9753, 0x8E09, 0x690B, 
	0x9B49, 0x83A8, 0x4E21, 0x4FCD, 0x5006, 0x501E, 0x5169, 0x54F4, 0x5521, 0x5562, 0x55A8, 0x60A2, 0x60CA, 0x639A, 0x6A11, 0x6DBC, 
	0x6E78, 0x7177, 0x7C17, 0x7CE7, 0x7DA1, 0x7DC9, 0x813C, 0x870B, 0x873D, 0x88F2, 0x8AD2, 0x8E52, 0x8E63, 0x8F0C, 0x8F1B, 0x8F2C, 
	0x8F8C, 0x9344, 0x95AC, 0x9606, 0x975A, 0x99FA, 0x9B4E
	};
const TText16 KPinyin230[4] = {'l', 'i', 'a', 'o', };
const TInt charForPinyin230[71] = {
	0x4E86, 0x6599, 0x64A9, 0x804A, 0x6482, 0x7597, 0x5ED6, 0x71CE, 0x8FBD, 0x50DA, 0x5BE5, 0x9563, 0x6F66, 0x948C, 0x84FC, 0x5C25, 
	0x5BEE, 0x7F2D, 0x7360, 0x9E69, 0x5639, 0x4F6C, 0x50C7, 0x52B3, 0x52DE, 0x5AFD, 0x5C1E, 0x5C26, 0x5C6A, 0x5D7A, 0x5D9A, 0x5D9B, 
	0x5EEB, 0x6180, 0x61AD, 0x644E, 0x6579, 0x66B8, 0x6A1B, 0x6F3B, 0x7093, 0x720E, 0x7212, 0x7499, 0x7642, 0x77AD, 0x7AB7, 0x7AC2, 
	0x7C1D, 0x7E5A, 0x818B, 0x81AB, 0x87C9, 0x87DF, 0x87E7, 0x8C42, 0x8CFF, 0x8E58, 0x8E7D, 0x8F51, 0x907C, 0x911D, 0x91D5, 0x93D0, 
	0x9410, 0x9560, 0x957D, 0x98C2, 0x98C9, 0x9ACE, 0x9DEF
	};
const TText16 KPinyin231[3] = {'l', 'i', 'e', };
const TInt charForPinyin231[57] = {
	0x5217, 0x88C2, 0x730E, 0x52A3, 0x70C8, 0x54A7, 0x57D2, 0x6369, 0x9B23, 0x8D94, 0x8E90, 0x51BD, 0x6D0C, 0x4F8B, 0x5008, 0x5120, 
	0x52A6, 0x52BD, 0x54F7, 0x57D3, 0x594A, 0x59F4, 0x5CE2, 0x5DC1, 0x5DE4, 0x5FDA, 0x6312, 0x6318, 0x64F8, 0x6817, 0x68D9, 0x6AD1, 
	0x6BDF, 0x6D56, 0x70EE, 0x716D, 0x71E4, 0x7204, 0x7209, 0x72A3, 0x731F, 0x7375, 0x7759, 0x7D9F, 0x8057, 0x811F, 0x818A, 0x81D8, 
	0x8322, 0x86DA, 0x8FFE, 0x908B, 0x98B2, 0x9B1B, 0x9BA4, 0x9C72, 0x9D37
	};
const TText16 KPinyin232[3] = {'l', 'i', 'n', };
const TInt charForPinyin232[85] = {
	0x6797, 0x4E34, 0x6DCB, 0x90BB, 0x78F7, 0x9CDE, 0x8D41, 0x541D, 0x62CE, 0x7433, 0x9716, 0x51DB, 0x9074, 0x5D99, 0x853A, 0x7CBC, 
	0x9E9F, 0x8E8F, 0x8F9A, 0x5EEA, 0x61D4, 0x77B5, 0x6AA9, 0x81A6, 0x5549, 0x4E83, 0x4EFB, 0x4F08, 0x50EF, 0x51DC, 0x53B8, 0x58E3, 
	0x5D0A, 0x5EE9, 0x6061, 0x608B, 0x60CF, 0x61CD, 0x649B, 0x65B4, 0x667D, 0x66BD, 0x6A49, 0x6A81, 0x6D81, 0x6E17, 0x6EF2, 0x6F7E, 
	0x6F9F, 0x7036, 0x711B, 0x71D0, 0x735C, 0x73AA, 0x7498, 0x7510, 0x7584, 0x75F3, 0x765B, 0x765D, 0x7884, 0x7A1F, 0x7B96, 0x7CA6, 
	0x7E57, 0x7FF7, 0x81E8, 0x83FB, 0x85FA, 0x8CC3, 0x8E78, 0x8E99, 0x8EAA, 0x8F54, 0x8F65, 0x9130, 0x93FB, 0x95B5, 0x9634, 0x96A3, 
	0x9872, 0x9A4E, 0x9B7F, 0x9C57, 0x9E90
	};
const TText16 KPinyin233[4] = {'l', 'i', 'n', 'g', };
const TInt charForPinyin233[100] = {
	0x53E6, 0x4EE4, 0x9886, 0x96F6, 0x94C3, 0x73B2, 0x7075, 0x5CAD, 0x9F84, 0x51CC, 0x9675, 0x83F1, 0x4F36, 0x7F9A, 0x68F1, 0x7FCE, 
	0x86C9, 0x82D3, 0x7EEB, 0x74F4, 0x9143, 0x5464, 0x6CE0, 0x68C2, 0x67C3, 0x9CAE, 0x8046, 0x56F9, 0x5030, 0x51B7, 0x5222, 0x577D, 
	0x590C, 0x59C8, 0x5A48, 0x5B41, 0x5CBA, 0x5D1A, 0x5DBA, 0x5F7E, 0x601C, 0x62CE, 0x6395, 0x6624, 0x670E, 0x6AFA, 0x6B1E, 0x6DE9, 
	0x6FAA, 0x702E, 0x70A9, 0x71EF, 0x7227, 0x72D1, 0x740C, 0x768A, 0x7831, 0x78F7, 0x797E, 0x79E2, 0x7ADB, 0x7B2D, 0x7D37, 0x7DBE, 
	0x8232, 0x84E4, 0x8506, 0x8576, 0x8626, 0x8851, 0x888A, 0x88EC, 0x8A45, 0x8DC9, 0x8EE8, 0x8F18, 0x91BD, 0x91D8, 0x9234, 0x9302, 
	0x9489, 0x959D, 0x963E, 0x970A, 0x9717, 0x971B, 0x971D, 0x9747, 0x9748, 0x9818, 0x99D6, 0x9B7F, 0x9BEA, 0x9D12, 0x9E30, 0x9E77, 
	0x9EA2, 0x9F61, 0x9F62, 0x9F97
	};
const TText16 KPinyin234[3] = {'l', 'i', 'u', };
const TInt charForPinyin234[100] = {
	0x516D, 0x6D41, 0x7559, 0x5218, 0x67F3, 0x6E9C, 0x786B, 0x7624, 0x69B4, 0x7409, 0x998F, 0x788C, 0x9646, 0x7EFA, 0x950D, 0x938F, 
	0x954F, 0x6D4F, 0x9A9D, 0x65D2, 0x9E68, 0x7198, 0x905B, 0x507B, 0x50C2, 0x5289, 0x56A0, 0x586F, 0x5AB9, 0x5B3C, 0x5D67, 0x5EC7, 
	0x61F0, 0x62A1, 0x65BF, 0x65C8, 0x6801, 0x685E, 0x687A, 0x6A4A, 0x6A6E, 0x6CA0, 0x6CD6, 0x6CF5, 0x6E38, 0x6F3B, 0x6F91, 0x700F, 
	0x71AE, 0x73CB, 0x7460, 0x746C, 0x74A2, 0x7542, 0x7544, 0x7571, 0x7581, 0x7645, 0x78C2, 0x78DF, 0x7DB9, 0x7F76, 0x7F80, 0x7FCF, 
	0x804A, 0x81A2, 0x848C, 0x84A5, 0x84C5, 0x84FC, 0x851E, 0x85F0, 0x87C9, 0x88D7, 0x8E53, 0x925A, 0x92F6, 0x93A6, 0x93D0, 0x9402, 
	0x94C6, 0x9560, 0x9678, 0x96E1, 0x9724, 0x98C0, 0x98C2, 0x98C5, 0x98D7, 0x993E, 0x99E0, 0x99F5, 0x9A2E, 0x9A51, 0x9B38, 0x9C21, 
	0x9DB9, 0x9DDA, 0x9E60, 0x9E8D
	};
const TText16 KPinyin235[4] = {'l', 'i', 'w', 'a', };
const TInt charForPinyin235[2] = {
	0x74FC, 0x7505
	};
const TText16 KPinyin236[2] = {'l', 'o', };
const TInt charForPinyin236[2] = {
	0x54AF, 0x56D6
	};
const TText16 KPinyin237[4] = {'l', 'o', 'n', 'g', };
const TInt charForPinyin237[79] = {
	0x9F99, 0x62E2, 0x7B3C, 0x804B, 0x9686, 0x5784, 0x5F04, 0x5499, 0x7ABF, 0x9647, 0x5785, 0x80E7, 0x73D1, 0x830F, 0x6CF7, 0x680A, 
	0x7643, 0x783B, 0x5131, 0x5390, 0x54E2, 0x56A8, 0x58DF, 0x58E0, 0x5BA0, 0x5BF5, 0x5C78, 0x5D90, 0x5DC3, 0x5DC4, 0x5E9E, 0x5FBF, 
	0x603B, 0x650F, 0x663D, 0x66E8, 0x6727, 0x6887, 0x69DE, 0x6AF3, 0x6E70, 0x6EDD, 0x6F0B, 0x7027, 0x7216, 0x74CF, 0x772C, 0x77D3, 
	0x7866, 0x7931, 0x7932, 0x7AC9, 0x7ADC, 0x7BE2, 0x7BED, 0x7C60, 0x807E, 0x856F, 0x8622, 0x8755, 0x882A, 0x882C, 0x8856, 0x8971, 
	0x8C3E, 0x8C45, 0x8D1A, 0x8E98, 0x93E7, 0x9468, 0x96B4, 0x9733, 0x9747, 0x9A61, 0x9E17, 0x9F8D, 0x9F90, 0x9F92, 0x9F93
	};
const TText16 KPinyin238[3] = {'l', 'o', 'u', };
const TInt charForPinyin238[48] = {
	0x697C, 0x6402, 0x6F0F, 0x964B, 0x9732, 0x5A04, 0x7BD3, 0x507B, 0x877C, 0x9542, 0x848C, 0x8027, 0x9AC5, 0x55BD, 0x7618, 0x5D5D, 
	0x50C2, 0x560D, 0x587F, 0x5A41, 0x5BE0, 0x5C5A, 0x5D81, 0x5ED4, 0x617A, 0x645F, 0x6A13, 0x6E87, 0x6F0A, 0x71A1, 0x7262, 0x750A, 
	0x763A, 0x763B, 0x779C, 0x7AB6, 0x7C0D, 0x802C, 0x81A2, 0x825B, 0x851E, 0x87BB, 0x8B31, 0x8EC1, 0x9071, 0x93E4, 0x97BB, 0x9ACF
	};
const TText16 KPinyin239[2] = {'l', 'u', };
const TInt charForPinyin239[176] = {
	0x8DEF, 0x9732, 0x5F55, 0x9E7F, 0x9646, 0x7089, 0x5362, 0x9C81, 0x5364, 0x82A6, 0x9885, 0x5E90, 0x788C, 0x63B3, 0x7EFF, 0x864F, 
	0x8D42, 0x622E, 0x6F5E, 0x7984, 0x9E93, 0x516D, 0x9C88, 0x680C, 0x6E0C, 0x84FC, 0x902F, 0x6CF8, 0x8F73, 0x6C07, 0x7C0F, 0x6A79, 
	0x8F82, 0x5786, 0x80EA, 0x565C, 0x9565, 0x8F98, 0x6F09, 0x64B8, 0x7490, 0x9E2C, 0x9E6D, 0x823B, 0x4F93, 0x50C7, 0x5279, 0x52CE, 
	0x52E0, 0x55E0, 0x5695, 0x56A7, 0x5725, 0x5774, 0x5876, 0x5877, 0x58DA, 0x5A3D, 0x5CCD, 0x5ED8, 0x5EEC, 0x5F54, 0x6314, 0x634B, 
	0x635B, 0x6445, 0x645D, 0x64C4, 0x64FC, 0x6504, 0x650E, 0x67A6, 0x6902, 0x6A10, 0x6A1A, 0x6AD3, 0x6AE8, 0x6C0C, 0x6DD5, 0x6DE5, 
	0x6EE4, 0x6EF7, 0x6F0A, 0x6F9B, 0x6FFE, 0x7002, 0x7018, 0x719D, 0x7210, 0x7379, 0x7388, 0x742D, 0x74B7, 0x74D0, 0x752A, 0x7633, 
	0x76DD, 0x76E7, 0x7769, 0x77D1, 0x7849, 0x7875, 0x78E0, 0x797F, 0x7A11, 0x7A4B, 0x7B93, 0x7C2C, 0x7C35, 0x7C36, 0x7C59, 0x7C5A, 
	0x7CB6, 0x7DD1, 0x7E91, 0x7F4F, 0x7FCF, 0x80A4, 0x8194, 0x819A, 0x819F, 0x81DA, 0x822E, 0x8263, 0x826A, 0x826B, 0x83C9, 0x84FE, 
	0x850D, 0x8557, 0x8606, 0x8642, 0x865C, 0x87B0, 0x8826, 0x89D2, 0x89EE, 0x89FB, 0x8C37, 0x8CC2, 0x8DA2, 0x8E1B, 0x8E57, 0x8F05, 
	0x8F46, 0x8F64, 0x911C, 0x916A, 0x9181, 0x9229, 0x9304, 0x9332, 0x9334, 0x93C0, 0x93D5, 0x93F4, 0x942A, 0x9465, 0x946A, 0x9678, 
	0x9871, 0x9A04, 0x9A3C, 0x9AD7, 0x9B6F, 0x9B72, 0x9BE5, 0x9C73, 0x9C78, 0x9D3C, 0x9D66, 0x9D71, 0x9DFA, 0x9E15, 0x9E75, 0x9EF8
	};
const TText16 KPinyin240[4] = {'l', 'u', 'a', 'n', };
const TInt charForPinyin240[37] = {
	0x4E71, 0x5375, 0x6EE6, 0x5CE6, 0x5B6A, 0x631B, 0x683E, 0x92AE, 0x8114, 0x5A08, 0x9E3E, 0x4E7F, 0x4E82, 0x571D, 0x571E, 0x5971, 
	0x5B4C, 0x5B7F, 0x5DD2, 0x6523, 0x66EB, 0x6B12, 0x7053, 0x7064, 0x7674, 0x7675, 0x7F89, 0x811F, 0x81E0, 0x81E1, 0x858D, 0x864A, 
	0x89B6, 0x91E0, 0x947E, 0x9D49, 0x9E1E
	};
const TText16 KPinyin241[3] = {'l', 'u', 'e', };
const TInt charForPinyin241[15] = {
	0x7565, 0x63A0, 0x950A, 0x5260, 0x5719, 0x5BFD, 0x64FD, 0x7387, 0x7567, 0x7A24, 0x836F, 0x85E5, 0x8A7B, 0x92DD, 0x92E2
	};
const TText16 KPinyin242[3] = {'l', 'u', 'n', };
const TInt charForPinyin242[35] = {
	0x8BBA, 0x8F6E, 0x62A1, 0x4F26, 0x6CA6, 0x4ED1, 0x7EB6, 0x56F5, 0x4F96, 0x502B, 0x5707, 0x57E8, 0x5A68, 0x5D18, 0x5D19, 0x60C0, 
	0x6384, 0x68C6, 0x6DEA, 0x6EA3, 0x7754, 0x7896, 0x78EE, 0x7A10, 0x7DB8, 0x8023, 0x8140, 0x83D5, 0x8726, 0x8AD6, 0x8E1A, 0x8F2A, 
	0x9300, 0x966F, 0x9BE9
	};
const TText16 KPinyin243[3] = {'l', 'u', 'o', };
const TInt charForPinyin243[98] = {
	0x843D, 0x7F57, 0x9523, 0x88F8, 0x9AA1, 0x70D9, 0x7BA9, 0x87BA, 0x841D, 0x6D1B, 0x9A86, 0x903B, 0x7EDC, 0x54AF, 0x8366, 0x6F2F, 
	0x8803, 0x96D2, 0x502E, 0x784C, 0x6924, 0x634B, 0x8136, 0x7630, 0x645E, 0x6CFA, 0x73DE, 0x9559, 0x7321, 0x4E50, 0x5138, 0x513D, 
	0x5246, 0x5570, 0x56C9, 0x5CC8, 0x633C, 0x6370, 0x650E, 0x651E, 0x652D, 0x66EA, 0x679C, 0x683C, 0x6A02, 0x6A50, 0x6ADF, 0x6B0F, 
	0x6B19, 0x6FFC, 0x70C1, 0x720D, 0x7296, 0x7313, 0x7380, 0x7673, 0x76AA, 0x7822, 0x7866, 0x788C, 0x792B, 0x7B3F, 0x7C6E, 0x7D61, 
	0x7E99, 0x7F85, 0x8161, 0x81DD, 0x8316, 0x84CF, 0x863F, 0x86D2, 0x873E, 0x8778, 0x8821, 0x88BC, 0x89B6, 0x89BC, 0x8A7B, 0x8DDE, 
	0x8DEF, 0x8E92, 0x8EB6, 0x908F, 0x927B, 0x93AF, 0x93CD, 0x947C, 0x94EC, 0x9831, 0x9960, 0x99F1, 0x9A3E, 0x9A58, 0x9BA5, 0x9C73, 
	0x9D45, 0x9E01
	};
const TText16 KPinyin244[2] = {'l', 'v', };
const TInt charForPinyin244[86] = {
	0x7EFF, 0x7387, 0x94DD, 0x9A74, 0x65C5, 0x5C61, 0x6EE4, 0x5415, 0x5F8B, 0x6C2F, 0x7F15, 0x4FA3, 0x8651, 0x5C65, 0x507B, 0x8182, 
	0x6988, 0x95FE, 0x634B, 0x891B, 0x7A06, 0x4FB6, 0x5122, 0x52F4, 0x535B, 0x5362, 0x5442, 0x54F7, 0x578F, 0x58D8, 0x5A04, 0x5A41, 
	0x5BE0, 0x5BFD, 0x5C62, 0x5D42, 0x5E90, 0x5EEC, 0x616E, 0x617A, 0x66E5, 0x68A0, 0x6A13, 0x6AD6, 0x6ADA, 0x6AE8, 0x6C00, 0x7112, 
	0x7208, 0x763B, 0x76E7, 0x779C, 0x7963, 0x7A5E, 0x7A6D, 0x7BBB, 0x7BD3, 0x7C0D, 0x7D2F, 0x7D7D, 0x7DA0, 0x7DD1, 0x7E37, 0x7E42, 
	0x8190, 0x81A2, 0x844E, 0x848C, 0x851E, 0x85D8, 0x8938, 0x8B31, 0x8EC1, 0x90D8, 0x92C1, 0x9332, 0x93E4, 0x9462, 0x9542, 0x95AD, 
	0x99BF, 0x9A62, 0x9B6F, 0x9C81, 0x9DDC, 0x9E7F
	};
const TText16 KPinyin245[1] = {'m', };
const TInt charForPinyin245[3] = {
	0x5452, 0x5463, 0x5638
	};
const TText16 KPinyin246[2] = {'m', 'a', };
const TInt charForPinyin246[57] = {
	0x5417, 0x5988, 0x9A6C, 0x561B, 0x9EBB, 0x9A82, 0x62B9, 0x7801, 0x739B, 0x8682, 0x6469, 0x551B, 0x87C6, 0x72B8, 0x5B37, 0x6769, 
	0x4E48, 0x4E87, 0x508C, 0x5450, 0x55CE, 0x561C, 0x5ABD, 0x5AF2, 0x5B24, 0x5B56, 0x5C1B, 0x69AA, 0x6EA4, 0x7298, 0x7341, 0x746A, 
	0x75F2, 0x7770, 0x78BC, 0x7923, 0x7943, 0x79A1, 0x7F75, 0x84E6, 0x8534, 0x879E, 0x87C7, 0x8C89, 0x8C8A, 0x9064, 0x93B7, 0x9581, 
	0x9761, 0x99AC, 0x99E1, 0x9A40, 0x9B15, 0x9C22, 0x9DCC, 0x9EBC, 0x9EBD
	};
const TText16 KPinyin247[3] = {'m', 'a', 'i', };
const TInt charForPinyin247[28] = {
	0x4E70, 0x5356, 0x8FC8, 0x57CB, 0x9EA6, 0x8109, 0x52A2, 0x973E, 0x836C, 0x4F45, 0x52F1, 0x54AA, 0x54E9, 0x562A, 0x58F2, 0x6D3E, 
	0x8108, 0x8552, 0x85B6, 0x8847, 0x8C8D, 0x8CB7, 0x8CE3, 0x9081, 0x9721, 0x9722, 0x9DF6, 0x9EA5
	};
const TText16 KPinyin248[3] = {'m', 'a', 'n', };
const TInt charForPinyin248[56] = {
	0x6EE1, 0x6162, 0x7792, 0x6F2B, 0x86EE, 0x8513, 0x66FC, 0x9992, 0x57CB, 0x8C29, 0x5E54, 0x9CD7, 0x5881, 0x87A8, 0x9558, 0x989F, 
	0x9794, 0x7F26, 0x71B3, 0x50C8, 0x59CF, 0x5ADA, 0x5C58, 0x5E55, 0x6097, 0x6172, 0x6471, 0x69FE, 0x6A20, 0x6E80, 0x6EFF, 0x6FAB, 
	0x6FB7, 0x734C, 0x774C, 0x779E, 0x77D5, 0x7D7B, 0x7E35, 0x8504, 0x8630, 0x87C3, 0x87CE, 0x883B, 0x8954, 0x8B3E, 0x8E52, 0x8E63, 
	0x9124, 0x93CB, 0x93DD, 0x9862, 0x9945, 0x9B17, 0x9B18, 0x9C3B
	};
const TText16 KPinyin249[4] = {'m', 'a', 'n', 'g', };
const TInt charForPinyin249[47] = {
	0x5FD9, 0x8292, 0x76F2, 0x83BD, 0x832B, 0x6C13, 0x786D, 0x9099, 0x87D2, 0x6F2D, 0x5396, 0x5402, 0x54E4, 0x58FE, 0x5A0F, 0x5C28, 
	0x5EAC, 0x607E, 0x671A, 0x6726, 0x6757, 0x6767, 0x6C52, 0x6D5D, 0x7264, 0x727B, 0x72F5, 0x753F, 0x75DD, 0x76F3, 0x77A2, 0x7865, 
	0x7B00, 0x833B, 0x83BE, 0x8609, 0x86D6, 0x880E, 0x91EF, 0x92E9, 0x94D3, 0x99F9, 0x9E0F, 0x9E72, 0x9F8D, 0x9F92, 0x9F99
	};
const TText16 KPinyin250[6] = {'m', 'a', 'n', 'g', 'm', 'i', };
const TInt charForPinyin250[1] = {
	0x5301
	};
const TText16 KPinyin251[3] = {'m', 'a', 'o', };
const TInt charForPinyin251[75] = {
	0x6BDB, 0x5192, 0x5E3D, 0x732B, 0x77DB, 0x536F, 0x8C8C, 0x8302, 0x8D38, 0x94C6, 0x951A, 0x8305, 0x8004, 0x8306, 0x7441, 0x8765, 
	0x9AE6, 0x61CB, 0x6634, 0x7266, 0x7780, 0x5CC1, 0x88A4, 0x87CA, 0x65C4, 0x6CD6, 0x4F94, 0x5183, 0x5187, 0x5190, 0x52D6, 0x52D9, 
	0x5825, 0x5918, 0x5AA2, 0x5D4D, 0x6117, 0x623C, 0x63CF, 0x6693, 0x6786, 0x6959, 0x6BE3, 0x6BF7, 0x6C02, 0x6E35, 0x725F, 0x729B, 
	0x734F, 0x7683, 0x770A, 0x79CF, 0x7B37, 0x7DE2, 0x7F5E, 0x8017, 0x82BC, 0x843A, 0x84E9, 0x86D1, 0x8750, 0x8992, 0x8C87, 0x8C93, 
	0x8CBF, 0x8EDE, 0x911A, 0x912E, 0x9155, 0x925A, 0x927E, 0x9328, 0x973F, 0x9AF3, 0x9D9C
	};
const TText16 KPinyin252[3] = {'m', 'a', 's', };
const TInt charForPinyin252[1] = {
	0x551C
	};
const TText16 KPinyin253[2] = {'m', 'e', };
const TInt charForPinyin253[10] = {
	0x4E48, 0x5692, 0x569C, 0x56B0, 0x5B6D, 0x5E85, 0x6FF9, 0x7666, 0x9EBC, 0x9EBD
	};
const TText16 KPinyin254[3] = {'m', 'e', 'i', };
const TInt charForPinyin254[92] = {
	0x6CA1, 0x6BCF, 0x7164, 0x9541, 0x7F8E, 0x9176, 0x59B9, 0x679A, 0x9709, 0x73AB, 0x7709, 0x6885, 0x5BD0, 0x6627, 0x5A92, 0x7CDC, 
	0x5A9A, 0x8C1C, 0x6CAB, 0x5D4B, 0x7338, 0x8882, 0x6E44, 0x6D7C, 0x9E5B, 0x8393, 0x9B45, 0x9545, 0x6963, 0x51C2, 0x5445, 0x5473, 
	0x569C, 0x5746, 0x5776, 0x5833, 0x587A, 0x58A8, 0x5A84, 0x5ABA, 0x5B0D, 0x5D44, 0x5FBE, 0x62BA, 0x6334, 0x6517, 0x651F, 0x67D0, 
	0x6802, 0x6973, 0x69D1, 0x6AD7, 0x6BCE, 0x6C3C, 0x6C92, 0x6CAC, 0x6E3C, 0x6E48, 0x6EA6, 0x715D, 0x71D8, 0x73FB, 0x7442, 0x75D7, 
	0x770A, 0x771B, 0x7742, 0x7778, 0x77C0, 0x7959, 0x7996, 0x7BC3, 0x7F99, 0x8104, 0x8122, 0x815C, 0x81B4, 0x82FA, 0x847F, 0x862A, 
	0x875E, 0x8DCA, 0x8EBE, 0x90FF, 0x92C2, 0x9382, 0x9387, 0x97CE, 0x9B3D, 0x9DA5, 0x9EE3, 0x9EF4
	};
const TText16 KPinyin255[3] = {'m', 'e', 'n', };
const TInt charForPinyin255[35] = {
	0x95E8, 0x4EEC, 0x95F7, 0x61D1, 0x626A, 0x9494, 0x7116, 0x4EB9, 0x5011, 0x600B, 0x6097, 0x60B6, 0x60DB, 0x61E3, 0x636B, 0x66AA, 
	0x691A, 0x6B99, 0x6C76, 0x6E80, 0x6EE1, 0x6EFF, 0x71DC, 0x739F, 0x73A3, 0x73A7, 0x748A, 0x779E, 0x7A48, 0x83DB, 0x864B, 0x9346, 
	0x9580, 0x9585, 0x9794
	};
const TText16 KPinyin256[4] = {'m', 'e', 'n', 'g', };
const TInt charForPinyin256[72] = {
	0x731B, 0x68A6, 0x8499, 0x9530, 0x5B5F, 0x76DF, 0x6AAC, 0x840C, 0x6C13, 0x791E, 0x8722, 0x52D0, 0x61F5, 0x750D, 0x8813, 0x867B, 
	0x6726, 0x824B, 0x8268, 0x77A2, 0x511A, 0x51A1, 0x5922, 0x5923, 0x5AC7, 0x5C28, 0x5E6A, 0x5EAC, 0x61DC, 0x61DE, 0x63B9, 0x64DD, 
	0x660E, 0x66DA, 0x6A57, 0x6C0B, 0x6E95, 0x6FDB, 0x7374, 0x74FE, 0x753F, 0x7791, 0x77C7, 0x77D2, 0x7F5E, 0x8394, 0x8420, 0x8544, 
	0x8771, 0x87CA, 0x87D2, 0x9133, 0x9138, 0x92C2, 0x9333, 0x96FA, 0x971A, 0x9725, 0x9727, 0x973F, 0x9740, 0x986D, 0x995B, 0x9AF3, 
	0x9BCD, 0x9BED, 0x9C66, 0x9E0F, 0x9E72, 0x9EFD, 0x9EFE, 0x9F06
	};
const TText16 KPinyin257[3] = {'m', 'e', 'o', };
const TInt charForPinyin257[1] = {
	0x8E0E
	};
const TText16 KPinyin258[2] = {'m', 'i', };
const TInt charForPinyin258[113] = {
	0x7C73, 0x5BC6, 0x8FF7, 0x772F, 0x871C, 0x8C1C, 0x89C5, 0x79D8, 0x5F25, 0x5E42, 0x9761, 0x7CDC, 0x6CCC, 0x919A, 0x863C, 0x7E3B, 
	0x54AA, 0x6C68, 0x9E8B, 0x7962, 0x7315, 0x5F2D, 0x8C27, 0x8288, 0x8112, 0x5B93, 0x6549, 0x5627, 0x7CF8, 0x4F8E, 0x5196, 0x519E, 
	0x51AA, 0x5298, 0x54CB, 0x5853, 0x5B4A, 0x5BBB, 0x5C12, 0x5C13, 0x5C14, 0x5CDA, 0x5E4E, 0x5E66, 0x5E7A, 0x5F4C, 0x6202, 0x6469, 
	0x6475, 0x64DF, 0x64F5, 0x6520, 0x6993, 0x6A12, 0x6AB7, 0x6AC1, 0x6C95, 0x6CB5, 0x6D23, 0x6DE7, 0x6E33, 0x6E9F, 0x6EF5, 0x6F1E, 
	0x6FD4, 0x6FD7, 0x7030, 0x7056, 0x7190, 0x7222, 0x723E, 0x736F, 0x737C, 0x74D5, 0x772B, 0x773D, 0x7787, 0x77B4, 0x7955, 0x79B0, 
	0x7A48, 0x7C1A, 0x7C4B, 0x7C8E, 0x7F59, 0x7F83, 0x7F8B, 0x82FE, 0x845E, 0x84BE, 0x84C2, 0x851D, 0x8524, 0x85CC, 0x8746, 0x88AE, 
	0x8993, 0x8994, 0x899B, 0x8A78, 0x8B0E, 0x8B10, 0x8F9F, 0x91BE, 0x91BF, 0x91C4, 0x92A4, 0x9456, 0x957E, 0x9E0D, 0x9E8A, 0x9E9B, 
	0x9F0F
	};
const TText16 KPinyin259[4] = {'m', 'i', 'a', 'n', };
const TInt charForPinyin259[60] = {
	0x9762, 0x68C9, 0x514D, 0x7EF5, 0x7720, 0x7F05, 0x52C9, 0x5195, 0x5A29, 0x817C, 0x6E4E, 0x7704, 0x6C94, 0x9EFE, 0x6E11, 0x4E0F, 
	0x4FDB, 0x506D, 0x51A5, 0x52D4, 0x53B8, 0x5595, 0x5A42, 0x5A94, 0x5B35, 0x5B80, 0x6110, 0x6AB0, 0x6ACB, 0x6C45, 0x6CEF, 0x6E63, 
	0x6FA0, 0x7251, 0x7791, 0x77C8, 0x77CA, 0x77CF, 0x7CC6, 0x7D7B, 0x7DBF, 0x7DCD, 0x7DDC, 0x7DE1, 0x7DEC, 0x7F17, 0x81F1, 0x8287, 
	0x83AC, 0x8442, 0x8752, 0x8820, 0x9763, 0x9766, 0x9BB8, 0x9EAA, 0x9EAB, 0x9EB5, 0x9EBA, 0x9EFD
	};
const TText16 KPinyin260[4] = {'m', 'i', 'a', 'o', };
const TInt charForPinyin260[35] = {
	0x79D2, 0x82D7, 0x5E99, 0x5999, 0x63CF, 0x7784, 0x85D0, 0x6E3A, 0x7707, 0x7F2A, 0x7F08, 0x6DFC, 0x55B5, 0x676A, 0x9E4B, 0x9088, 
	0x4EEF, 0x5435, 0x5A8C, 0x5AF9, 0x5EBF, 0x5EDF, 0x5F6F, 0x732B, 0x7385, 0x7AD7, 0x7BCE, 0x7D17, 0x7DE2, 0x7DF2, 0x7EB1, 0x8731, 
	0x8A2C, 0x9C59, 0x9D93
	};
const TText16 KPinyin261[3] = {'m', 'i', 'e', };
const TInt charForPinyin261[24] = {
	0x706D, 0x8511, 0x54A9, 0x7BFE, 0x881B, 0x4E5C, 0x5400, 0x54AA, 0x54F6, 0x5B6D, 0x5E6D, 0x61F1, 0x6423, 0x6AD7, 0x6EC5, 0x700E, 
	0x771C, 0x858E, 0x884A, 0x8995, 0x8C02, 0x9456, 0x9C74, 0x9D13
	};
const TText16 KPinyin262[9] = {'m', 'i', 'l', 'i', 'k', 'l', 'a', 'n', 'm', };
const TInt charForPinyin262[1] = {
	0x74F1
	};
const TText16 KPinyin263[3] = {'m', 'i', 'n', };
const TInt charForPinyin263[67] = {
	0x6C11, 0x62BF, 0x654F, 0x95FD, 0x76BF, 0x60AF, 0x73C9, 0x610D, 0x7F17, 0x95F5, 0x739F, 0x82E0, 0x6CEF, 0x9EFE, 0x9CD8, 0x5CB7, 
	0x50F6, 0x51A7, 0x51BA, 0x5221, 0x52C4, 0x5461, 0x578A, 0x59C4, 0x5D0F, 0x5FDE, 0x600B, 0x615C, 0x61AB, 0x636A, 0x6543, 0x656F, 
	0x65FB, 0x65FC, 0x668B, 0x6C76, 0x6E02, 0x6E4F, 0x6E63, 0x6F63, 0x7418, 0x741D, 0x7449, 0x75FB, 0x76F7, 0x76FF, 0x7720, 0x7807, 
	0x7888, 0x7B22, 0x7B3D, 0x7C22, 0x7DCD, 0x7DE1, 0x7E69, 0x7EF3, 0x7F60, 0x8820, 0x8CEF, 0x9231, 0x9309, 0x9372, 0x9594, 0x95A9, 
	0x9C35, 0x9D16, 0x9EFD
	};
const TText16 KPinyin264[4] = {'m', 'i', 'n', 'g', };
const TInt charForPinyin264[32] = {
	0x540D, 0x660E, 0x547D, 0x9E23, 0x94ED, 0x879F, 0x76DF, 0x51A5, 0x7791, 0x669D, 0x8317, 0x6E9F, 0x9169, 0x4F72, 0x51D5, 0x59F3, 
	0x5AC7, 0x614F, 0x63B5, 0x6719, 0x69A0, 0x6D3A, 0x733D, 0x7700, 0x7733, 0x840C, 0x84C2, 0x89AD, 0x8A7A, 0x910D, 0x9298, 0x9CF4
	};
const TText16 KPinyin265[3] = {'m', 'i', 'u', };
const TInt charForPinyin265[4] = {
	0x8C2C, 0x7F2A, 0x7E46, 0x8B2C
	};
const TText16 KPinyin266[2] = {'m', 'o', };
const TInt charForPinyin266[116] = {
	0x6478, 0x78E8, 0x62B9, 0x672B, 0x819C, 0x58A8, 0x6CA1, 0x83AB, 0x9ED8, 0x9B54, 0x6A21, 0x6469, 0x6479, 0x6F20, 0x964C, 0x8611, 
	0x8109, 0x6CAB, 0x4E07, 0x65E0, 0x563F, 0x5192, 0x5BDE, 0x79E3, 0x763C, 0x6B81, 0x9546, 0x5AEB, 0x8C1F, 0x84E6, 0x8C8A, 0x8C98, 
	0x9EBD, 0x8309, 0x998D, 0x8031, 0x4E48, 0x4F2F, 0x4F70, 0x5298, 0x52B0, 0x52FF, 0x55FC, 0x56A4, 0x56A9, 0x573D, 0x587B, 0x59BA, 
	0x5AFC, 0x5C1B, 0x5E13, 0x5E15, 0x5E1E, 0x603D, 0x61E1, 0x6202, 0x629A, 0x64AB, 0x64F5, 0x6520, 0x6627, 0x6629, 0x66AF, 0x67BA, 
	0x6A45, 0x6B7E, 0x6B7F, 0x6C92, 0x700E, 0x7121, 0x7205, 0x72E2, 0x767E, 0x768C, 0x771C, 0x773D, 0x773F, 0x7790, 0x7799, 0x781E, 
	0x7933, 0x7C96, 0x7CE2, 0x7D48, 0x7D54, 0x7E38, 0x7E86, 0x8252, 0x8388, 0x85D0, 0x85E6, 0x86E8, 0x87C6, 0x87D4, 0x889C, 0x88B9, 
	0x8B28, 0x8B29, 0x8B55, 0x8C83, 0x8C88, 0x8C89, 0x8C8C, 0x9286, 0x93CC, 0x977A, 0x97A8, 0x9943, 0x995D, 0x9A40, 0x9ACD, 0x9B69, 
	0x9B79, 0x9EBC, 0x9EBF, 0x9ED9
	};
const TText16 KPinyin267[3] = {'m', 'o', 'l', };
const TInt charForPinyin267[1] = {
	0x4E6E
	};
const TText16 KPinyin268[3] = {'m', 'o', 'u', };
const TInt charForPinyin268[29] = {
	0x67D0, 0x8C0B, 0x725F, 0x7738, 0x86D1, 0x936A, 0x4F94, 0x7F2A, 0x54DE, 0x4EF6, 0x52BA, 0x53B6, 0x5463, 0x5825, 0x5A7A, 0x6048, 
	0x6544, 0x6859, 0x6BCB, 0x6D20, 0x77B4, 0x7E46, 0x87F1, 0x88A4, 0x8B00, 0x927E, 0x97AA, 0x9D3E, 0x9EB0
	};
const TText16 KPinyin269[2] = {'m', 'u', };
const TInt charForPinyin269[62] = {
	0x6728, 0x6BCD, 0x4EA9, 0x5E55, 0x76EE, 0x5893, 0x7267, 0x725F, 0x6A21, 0x7A46, 0x66AE, 0x7261, 0x62C7, 0x52DF, 0x6155, 0x7766, 
	0x59C6, 0x59E5, 0x94BC, 0x6BEA, 0x5776, 0x6C90, 0x4EEB, 0x82DC, 0x51E9, 0x563F, 0x58B2, 0x5A12, 0x5A7A, 0x5CD4, 0x5E59, 0x6154, 
	0x6737, 0x6958, 0x6A22, 0x6BE3, 0x6C01, 0x7091, 0x7273, 0x72C7, 0x734F, 0x7546, 0x7552, 0x755D, 0x755E, 0x756E, 0x782A, 0x7E38, 
	0x7E46, 0x7F2A, 0x80DF, 0x8252, 0x833B, 0x83AF, 0x843A, 0x869E, 0x8E07, 0x9267, 0x926C, 0x96EE, 0x9702, 0x97AA
	};
const TText16 KPinyin270[4] = {'m', 'y', 'e', 'o', };
const TInt charForPinyin270[1] = {
	0x65C0
	};
const TText16 KPinyin271[5] = {'m', 'y', 'e', 'o', 'n', };
const TInt charForPinyin271[1] = {
	0x4E06
	};
const TText16 KPinyin272[6] = {'m', 'y', 'e', 'o', 'n', 'g', };
const TInt charForPinyin272[1] = {
	0x6927
	};
const TText16 KPinyin273[1] = {'n', };
const TInt charForPinyin273[3] = {
	0x55EF, 0x54B9, 0x54CF
	};
const TText16 KPinyin274[2] = {'n', 'a', };
const TInt charForPinyin274[46] = {
	0x90A3, 0x62FF, 0x54EA, 0x7EB3, 0x94A0, 0x5A1C, 0x5450, 0x5357, 0x8872, 0x637A, 0x954E, 0x80AD, 0x4E78, 0x5167, 0x5185, 0x5436, 
	0x5476, 0x55F1, 0x59A0, 0x6290, 0x62CF, 0x6310, 0x6DF0, 0x79C5, 0x7B1A, 0x7B1D, 0x7BAC, 0x7BDB, 0x7D0D, 0x7D6E, 0x8498, 0x84B3, 
	0x88A6, 0x8A24, 0x8A49, 0x8ABD, 0x8C7D, 0x8C80, 0x8E43, 0x8EDC, 0x90CD, 0x9209, 0x93BF, 0x96EB, 0x9779, 0x9B76
	};
const TText16 KPinyin275[3] = {'n', 'a', 'i', };
const TInt charForPinyin275[30] = {
	0x4E43, 0x8010, 0x5976, 0x5948, 0x6C16, 0x54EA, 0x8418, 0x827F, 0x67F0, 0x9F10, 0x4F74, 0x5037, 0x59B3, 0x5B2D, 0x5B7B, 0x5EFC, 
	0x639C, 0x6431, 0x6468, 0x6E3F, 0x718B, 0x7593, 0x800F, 0x80FD, 0x8149, 0x879A, 0x8926, 0x8FFA, 0x91E2, 0x933C
	};
const TText16 KPinyin276[3] = {'n', 'a', 'n', };
const TInt charForPinyin276[36] = {
	0x96BE, 0x5357, 0x7537, 0x8D67, 0x56E1, 0x877B, 0x6960, 0x5583, 0x8169, 0x4FBD, 0x56DD, 0x59A0, 0x5A1A, 0x5A7B, 0x5AE8, 0x5F07, 
	0x6201, 0x62A9, 0x63C7, 0x644A, 0x6524, 0x6694, 0x678F, 0x67AC, 0x67DF, 0x6E73, 0x6EE9, 0x7058, 0x7175, 0x7558, 0x83AE, 0x8433, 
	0x8AF5, 0x9056, 0x96E3, 0x988C
	};
const TText16 KPinyin277[4] = {'n', 'a', 'n', 'g', };
const TInt charForPinyin277[24] = {
	0x56CA, 0x9995, 0x66E9, 0x56D4, 0x652E, 0x4E6A, 0x513E, 0x54DD, 0x5665, 0x56A2, 0x5D00, 0x61B9, 0x6411, 0x64C3, 0x6B1C, 0x6DB3, 
	0x703C, 0x7062, 0x8618, 0x8830, 0x8B68, 0x9962, 0x9B1E, 0x9F49
	};
const TText16 KPinyin278[3] = {'n', 'a', 'o', };
const TInt charForPinyin278[46] = {
	0x95F9, 0x8111, 0x607C, 0x6320, 0x6DD6, 0x5B6C, 0x94D9, 0x7459, 0x57B4, 0x5476, 0x86F2, 0x7331, 0x7847, 0x5318, 0x5816, 0x5912, 
	0x5A65, 0x5AD0, 0x5CF1, 0x5DA9, 0x5DCE, 0x5DD9, 0x6013, 0x60A9, 0x60F1, 0x61B9, 0x6493, 0x6A48, 0x6A82, 0x6D47, 0x6F86, 0x7376, 
	0x737F, 0x7899, 0x78AF, 0x8133, 0x815D, 0x8166, 0x81D1, 0x875A, 0x87EF, 0x8A49, 0x8B4A, 0x9403, 0x9599, 0x9B27
	};
const TText16 KPinyin279[2] = {'n', 'e', };
const TInt charForPinyin279[11] = {
	0x5462, 0x54EA, 0x90A3, 0x5450, 0x8BB7, 0x5436, 0x6290, 0x7592, 0x7594, 0x7732, 0x8A25
	};
const TText16 KPinyin280[3] = {'n', 'e', 'i', };
const TInt charForPinyin280[16] = {
	0x5185, 0x54EA, 0x9981, 0x90A3, 0x5167, 0x5A1E, 0x5A51, 0x6C1D, 0x6D7D, 0x812E, 0x8147, 0x9317, 0x9912, 0x9927, 0x9BBE, 0x9BD8
	};
const TText16 KPinyin281[3] = {'n', 'e', 'm', };
const TInt charForPinyin281[1] = {
	0x713E
	};
const TText16 KPinyin282[3] = {'n', 'e', 'n', };
const TInt charForPinyin282[7] = {
	0x5AE9, 0x6041, 0x5A86, 0x5AF0, 0x6798, 0x815D, 0x81D1
	};
const TText16 KPinyin283[4] = {'n', 'e', 'n', 'g', };
const TInt charForPinyin283[5] = {
	0x80FD, 0x7ADC, 0x800C, 0x8010, 0x879A
	};
const TText16 KPinyin284[4] = {'n', 'e', 'u', 's', };
const TInt charForPinyin284[1] = {
	0x83BB
	};
const TText16 KPinyin285[2] = {'n', 'g', };
const TInt charForPinyin285[1] = {
	0x55EF
	};
const TText16 KPinyin286[4] = {'n', 'g', 'a', 'g', };
const TInt charForPinyin286[1] = {
	0x922A
	};
const TText16 KPinyin287[4] = {'n', 'g', 'a', 'i', };
const TInt charForPinyin287[1] = {
	0x92B0
	};
const TText16 KPinyin288[4] = {'n', 'g', 'a', 'm', };
const TInt charForPinyin288[1] = {
	0x5571
	};
const TText16 KPinyin289[2] = {'n', 'i', };
const TInt charForPinyin289[95] = {
	0x4F60, 0x6CE5, 0x62DF, 0x817B, 0x9006, 0x5462, 0x6EBA, 0x502A, 0x5C3C, 0x533F, 0x59AE, 0x9713, 0x94CC, 0x6635, 0x576D, 0x7962, 
	0x730A, 0x4F32, 0x6029, 0x9CB5, 0x7768, 0x65CE, 0x4F31, 0x5117, 0x511E, 0x5150, 0x5152, 0x57FF, 0x5804, 0x59B3, 0x5A57, 0x5ADF, 
	0x5B2D, 0x5B3A, 0x5B68, 0x5B74, 0x5C54, 0x5C70, 0x5DB7, 0x5F4C, 0x60C4, 0x6135, 0x615D, 0x61DD, 0x6290, 0x62B3, 0x639C, 0x64EC, 
	0x6672, 0x66B1, 0x67C5, 0x68FF, 0x6AB7, 0x6C3C, 0x6DE3, 0x6EE0, 0x6FD4, 0x6FD8, 0x7030, 0x7044, 0x72D4, 0x75C6, 0x7724, 0x79B0, 
	0x79DC, 0x7C7E, 0x7E0C, 0x807B, 0x80D2, 0x815D, 0x81A9, 0x81E1, 0x82E8, 0x85BF, 0x86AD, 0x86EA, 0x873A, 0x88AE, 0x89EC, 0x8ABD, 
	0x8B7A, 0x8C8E, 0x8DDC, 0x8F17, 0x8FE1, 0x90F3, 0x922E, 0x9268, 0x9448, 0x957E, 0x96AC, 0x999C, 0x9BE2, 0x9E91, 0x9F6F
	};
const TText16 KPinyin290[4] = {'n', 'i', 'a', 'n', };
const TInt charForPinyin290[42] = {
	0x5E74, 0x5FF5, 0x637B, 0x64B5, 0x62C8, 0x78BE, 0x852B, 0x7C98, 0x5EFF, 0x9ECF, 0x8F87, 0x9C87, 0x9CB6, 0x57DD, 0x5344, 0x54D6, 
	0x5538, 0x59E9, 0x6375, 0x649A, 0x6506, 0x6990, 0x6D8A, 0x6DF0, 0x6E93, 0x75C6, 0x79CA, 0x79E5, 0x7C10, 0x824C, 0x8D81, 0x8D82, 
	0x8DC8, 0x8E4D, 0x8E68, 0x8E8E, 0x8F26, 0x8F3E, 0x8F97, 0x9B8E, 0x9BF0, 0x9D47
	};
const TText16 KPinyin291[5] = {'n', 'i', 'a', 'n', 'g', };
const TInt charForPinyin291[6] = {
	0x5A18, 0x917F, 0x5B22, 0x5B43, 0x91B8, 0x91C0
	};
const TText16 KPinyin292[4] = {'n', 'i', 'a', 'o', };
const TInt charForPinyin292[17] = {
	0x9E1F, 0x5C3F, 0x8885, 0x8311, 0x8132, 0x5B32, 0x5ACB, 0x5B1D, 0x5C25, 0x5C26, 0x6A22, 0x6EBA, 0x832E, 0x8526, 0x88CA, 0x892D, 
	0x9CE5
	};
const TText16 KPinyin293[3] = {'n', 'i', 'e', };
const TInt charForPinyin293[76] = {
	0x634F, 0x954D, 0x8042, 0x5B7D, 0x6D85, 0x954A, 0x556E, 0x9667, 0x8616, 0x55EB, 0x81EC, 0x8E51, 0x989E, 0x4E5C, 0x502A, 0x55A6, 
	0x565B, 0x5699, 0x56C1, 0x56D0, 0x56D3, 0x56E1, 0x573C, 0x57DD, 0x5B7C, 0x5CCA, 0x5D52, 0x5D72, 0x5DAD, 0x5DD5, 0x5E07, 0x5E78, 
	0x60D7, 0x637B, 0x639C, 0x63D1, 0x6442, 0x6444, 0x6470, 0x651D, 0x655C, 0x67BF, 0x68FF, 0x69F7, 0x6AF1, 0x75C6, 0x7BDE, 0x7C4B, 
	0x7CF1, 0x7CF5, 0x8076, 0x8080, 0x81F2, 0x82F6, 0x83CD, 0x8825, 0x8939, 0x8AD7, 0x8B98, 0x8E02, 0x8E17, 0x8E19, 0x8EA1, 0x9268, 
	0x9269, 0x92B8, 0x92F7, 0x931C, 0x93B3, 0x9448, 0x9477, 0x9480, 0x95D1, 0x9689, 0x9873, 0x9F67
	};
const TText16 KPinyin294[3] = {'n', 'i', 'n', };
const TInt charForPinyin294[5] = {
	0x60A8, 0x6041, 0x56DC, 0x62F0, 0x810C
	};
const TText16 KPinyin295[4] = {'n', 'i', 'n', 'g', };
const TInt charForPinyin295[37] = {
	0x62E7, 0x51DD, 0x5B81, 0x67E0, 0x72DE, 0x6CDE, 0x4F5E, 0x752F, 0x549B, 0x804D, 0x4FAB, 0x511C, 0x51B0, 0x5680, 0x5B23, 0x5BCD, 
	0x5BD5, 0x5BD7, 0x5BDC, 0x5BE7, 0x5E74, 0x64F0, 0x6518, 0x6A63, 0x6AB8, 0x6F9D, 0x6FD8, 0x7370, 0x7591, 0x77C3, 0x8079, 0x82E7, 
	0x85B4, 0x944F, 0x9B21, 0x9B24, 0x9E0B
	};
const TText16 KPinyin296[3] = {'n', 'i', 'u', };
const TInt charForPinyin296[20] = {
	0x725B, 0x626D, 0x7EBD, 0x94AE, 0x62D7, 0x599E, 0x72C3, 0x5FF8, 0x6013, 0x629D, 0x677B, 0x6C7C, 0x6C91, 0x7084, 0x725C, 0x7D10, 
	0x83A5, 0x86B4, 0x9215, 0x9775
	};
const TText16 KPinyin297[4] = {'n', 'o', 'n', 'g', };
const TInt charForPinyin297[27] = {
	0x5F04, 0x6D53, 0x519C, 0x8113, 0x54DD, 0x4FAC, 0x5102, 0x5494, 0x5665, 0x61B9, 0x630A, 0x6335, 0x6B01, 0x6FC3, 0x7651, 0x79AF, 
	0x79FE, 0x7A60, 0x7E77, 0x81BF, 0x8380, 0x857D, 0x895B, 0x8FB2, 0x8FB3, 0x91B2, 0x9F48
	};
const TText16 KPinyin298[3] = {'n', 'o', 'u', };
const TInt charForPinyin298[13] = {
	0x8028, 0x5542, 0x5B2C, 0x6419, 0x64E9, 0x69C8, 0x6ABD, 0x7373, 0x7FBA, 0x8B68, 0x8B73, 0x9392, 0x941E
	};
const TText16 KPinyin299[2] = {'n', 'u', };
const TInt charForPinyin299[20] = {
	0x6012, 0x52AA, 0x5974, 0x5B65, 0x80EC, 0x9A7D, 0x5F29, 0x4EC5, 0x4F16, 0x4F2E, 0x5089, 0x5476, 0x5E11, 0x6419, 0x64E9, 0x782E, 
	0x7B2F, 0x8925, 0x8A49, 0x99D1
	};
const TText16 KPinyin300[4] = {'n', 'u', 'a', 'n', };
const TInt charForPinyin300[8] = {
	0x6696, 0x597B, 0x6E1C, 0x6E6A, 0x6FE1, 0x7156, 0x7157, 0x992A
	};
const TText16 KPinyin301[3] = {'n', 'u', 'e', };
const TInt charForPinyin301[4] = {
	0x8650, 0x759F, 0x8C11, 0x7878
	};
const TText16 KPinyin302[3] = {'n', 'u', 'n', };
const TInt charForPinyin302[1] = {
	0x9EC1
	};
const TText16 KPinyin303[4] = {'n', 'u', 'n', 'g', };
const TInt charForPinyin303[1] = {
	0x71F6
	};
const TText16 KPinyin304[3] = {'n', 'u', 'o', };
const TInt charForPinyin304[43] = {
	0x632A, 0x8BFA, 0x61E6, 0x7CEF, 0x5A1C, 0x558F, 0x50A9, 0x9518, 0x6426, 0x513A, 0x5436, 0x5450, 0x54EA, 0x5827, 0x5AA0, 0x5AF7, 
	0x611E, 0x61E7, 0x6389, 0x63BF, 0x6419, 0x643B, 0x689B, 0x6992, 0x6A60, 0x6BED, 0x6E2A, 0x7A2C, 0x7A64, 0x7CD1, 0x7CE5, 0x800E, 
	0x88B2, 0x88B3, 0x8AFE, 0x8E43, 0x903D, 0x90A3, 0x90CD, 0x9369, 0x96BE, 0x96E3, 0x9700
	};
const TText16 KPinyin305[2] = {'n', 'v', };
const TInt charForPinyin305[13] = {
	0x5973, 0x8844, 0x9495, 0x6067, 0x6712, 0x6C91, 0x72C3, 0x7C79, 0x7D6E, 0x804F, 0x80AD, 0x8842, 0x91F9
	};
const TText16 KPinyin306[3] = {'n', 'v', 'e', };
const TInt charForPinyin306[4] = {
	0x5A69, 0x759F, 0x7627, 0x8650
	};
const TText16 KPinyin307[1] = {'o', };
const TInt charForPinyin307[4] = {
	0x54E6, 0x5594, 0x5662, 0x7B7D
	};
const TText16 KPinyin308[3] = {'o', 'e', 's', };
const TInt charForPinyin308[1] = {
	0x591E
	};
const TText16 KPinyin309[2] = {'o', 'l', };
const TInt charForPinyin309[1] = {
	0x4E6F
	};
const TText16 KPinyin310[2] = {'o', 'n', };
const TInt charForPinyin310[2] = {
	0x6637, 0x97B0
	};
const TText16 KPinyin311[2] = {'o', 'u', };
const TInt charForPinyin311[44] = {
	0x5076, 0x5455, 0x6B27, 0x85D5, 0x9E25, 0x533A, 0x6CA4, 0x6BB4, 0x6004, 0x74EF, 0x8BB4, 0x8026, 0x5340, 0x5418, 0x543D, 0x5614, 
	0x5878, 0x616A, 0x62A0, 0x63E1, 0x6473, 0x657A, 0x6AD9, 0x6B50, 0x6BC6, 0x6E25, 0x6F1A, 0x6FAB, 0x71B0, 0x750C, 0x7D06, 0x7EA1, 
	0x8162, 0x8192, 0x84F2, 0x8545, 0x85F2, 0x8B33, 0x9047, 0x91A7, 0x93C2, 0x9D0E, 0x9DD7, 0x9F75
	};
const TText16 KPinyin312[2] = {'p', 'a', };
const TInt charForPinyin312[28] = {
	0x6015, 0x722C, 0x8DB4, 0x556A, 0x8019, 0x6252, 0x5E15, 0x7436, 0x6D3E, 0x7B62, 0x6777, 0x8469, 0x53ED, 0x5427, 0x5991, 0x5E0A, 
	0x628A, 0x63B1, 0x6C43, 0x6F56, 0x7685, 0x8225, 0x82AD, 0x82E9, 0x8899, 0x8DC1, 0x9200, 0x94AF
	};
const TText16 KPinyin313[3] = {'p', 'a', 'i', };
const TInt charForPinyin313[21] = {
	0x6D3E, 0x6392, 0x62CD, 0x724C, 0x8FEB, 0x5F98, 0x6E43, 0x54CC, 0x4FF3, 0x848E, 0x5561, 0x68D1, 0x6911, 0x72A4, 0x7305, 0x7B84, 
	0x7C30, 0x813E, 0x8157, 0x8F2B, 0x9383
	};
const TText16 KPinyin314[3] = {'p', 'a', 'k', };
const TInt charForPinyin314[1] = {
	0x78D7
	};
const TText16 KPinyin315[3] = {'p', 'a', 'n', };
const TInt charForPinyin315[75] = {
	0x76D8, 0x76FC, 0x5224, 0x6500, 0x7554, 0x6F58, 0x53DB, 0x78D0, 0x756A, 0x822C, 0x80D6, 0x897B, 0x87E0, 0x88A2, 0x6CEE, 0x62DA, 
	0x723F, 0x8E52, 0x4E51, 0x4F34, 0x51B8, 0x534A, 0x535E, 0x5762, 0x59CD, 0x59D7, 0x5ABB, 0x5BA1, 0x5BB7, 0x5BE9, 0x5E4B, 0x5F01, 
	0x5F66, 0x6273, 0x62CC, 0x642B, 0x67C8, 0x69C3, 0x6C9C, 0x6D00, 0x6E74, 0x6EBF, 0x700A, 0x700B, 0x708D, 0x7247, 0x7249, 0x7253, 
	0x7568, 0x76A4, 0x76E4, 0x76FB, 0x7705, 0x772B, 0x7886, 0x78FB, 0x7C53, 0x7E0F, 0x7E41, 0x81B0, 0x84B0, 0x878C, 0x8929, 0x8A4A, 
	0x8DD8, 0x8E2B, 0x8E63, 0x9131, 0x92EC, 0x939C, 0x947B, 0x95C6, 0x97B6, 0x9816, 0x9D65
	};
const TText16 KPinyin316[4] = {'p', 'a', 'n', 'g', };
const TInt charForPinyin316[44] = {
	0x65C1, 0x80D6, 0x802A, 0x5E9E, 0x4E53, 0x8180, 0x78C5, 0x6EC2, 0x5F77, 0x9004, 0x8783, 0x4EFF, 0x508D, 0x5390, 0x55D9, 0x5906, 
	0x5ACE, 0x5C28, 0x5F6D, 0x5FAC, 0x623F, 0x65B9, 0x6C78, 0x6C97, 0x7090, 0x7BE3, 0x80A8, 0x80EE, 0x8196, 0x823D, 0x84A1, 0x882D, 
	0x89AB, 0x8DBD, 0x9022, 0x938A, 0x9551, 0x96F1, 0x9736, 0x9AC8, 0x9C1F, 0x9CD1, 0x9F8E, 0x9F90
	};
const TText16 KPinyin317[3] = {'p', 'a', 'o', };
const TInt charForPinyin317[49] = {
	0x8DD1, 0x629B, 0x70AE, 0x6CE1, 0x5228, 0x888D, 0x5486, 0x72CD, 0x530F, 0x5E96, 0x75B1, 0x812C, 0x5305, 0x5697, 0x5789, 0x5945, 
	0x62B1, 0x62CB, 0x647D, 0x70B0, 0x722E, 0x72A5, 0x74DF, 0x76B0, 0x7832, 0x791F, 0x792E, 0x7A6E, 0x7A8C, 0x80DE, 0x811F, 0x82DE, 
	0x8422, 0x85E8, 0x86AB, 0x888C, 0x891C, 0x8B08, 0x8EF3, 0x924B, 0x94C7, 0x9784, 0x98AE, 0x98D1, 0x9B91, 0x9C8D, 0x9E83, 0x9E85, 
	0x9EAD
	};
const TText16 KPinyin318[3] = {'p', 'e', 'i', };
const TInt charForPinyin318[58] = {
	0x966A, 0x914D, 0x8D54, 0x5478, 0x80DA, 0x4F69, 0x57F9, 0x6C9B, 0x88F4, 0x65C6, 0x952B, 0x5E14, 0x9185, 0x9708, 0x8F94, 0x4F02, 
	0x4FD6, 0x500D, 0x5561, 0x574F, 0x57BA, 0x5983, 0x599A, 0x59F5, 0x5A44, 0x5A90, 0x5D8F, 0x600C, 0x62B7, 0x638A, 0x6508, 0x65BE, 
	0x6622, 0x67F8, 0x68D1, 0x6BF0, 0x6D7F, 0x6DE0, 0x72BB, 0x73EE, 0x7423, 0x7432, 0x7B29, 0x80A7, 0x8274, 0x8307, 0x8337, 0x84DC, 
	0x871A, 0x8843, 0x88F5, 0x8CE0, 0x8F61, 0x9307, 0x962B, 0x966B, 0x99B7, 0x99CD
	};
const TText16 KPinyin319[3] = {'p', 'e', 'n', };
const TInt charForPinyin319[16] = {
	0x55B7, 0x76C6, 0x6E53, 0x5429, 0x5460, 0x55AF, 0x5674, 0x672C, 0x6B55, 0x6C7E, 0x6FC6, 0x74EB, 0x7FC9, 0x7FF8, 0x8450, 0x886F
	};
const TText16 KPinyin320[4] = {'p', 'e', 'n', 'g', };
const TInt charForPinyin320[81] = {
	0x78B0, 0x6367, 0x68DA, 0x7830, 0x84EC, 0x670B, 0x5F6D, 0x9E4F, 0x70F9, 0x787C, 0x81A8, 0x62A8, 0x6F8E, 0x7BF7, 0x6026, 0x580B, 
	0x87DB, 0x562D, 0x4EA8, 0x5017, 0x508D, 0x50B0, 0x527B, 0x5309, 0x585C, 0x5873, 0x5E84, 0x5F38, 0x6072, 0x6189, 0x6337, 0x63BD, 
	0x6412, 0x6453, 0x65C1, 0x6888, 0x6916, 0x692A, 0x69F0, 0x6A25, 0x6CD9, 0x6DCE, 0x6DDC, 0x6EC2, 0x6F28, 0x6F30, 0x71A2, 0x75ED, 
	0x768F, 0x7851, 0x78DE, 0x7A1D, 0x7AFC, 0x7BE3, 0x7D63, 0x7E84, 0x80D3, 0x8283, 0x82F9, 0x8353, 0x8391, 0x87DA, 0x8E2B, 0x8EEF, 
	0x8EFF, 0x8F23, 0x8F27, 0x8FF8, 0x9022, 0x902C, 0x930B, 0x945D, 0x959B, 0x97F8, 0x97FC, 0x99CD, 0x9A2F, 0x9AFC, 0x9B05, 0x9B14, 
	0x9D6C
	};
const TText16 KPinyin321[4] = {'p', 'e', 'o', 'l', };
const TInt charForPinyin321[1] = {
	0x6D4C
	};
const TText16 KPinyin322[4] = {'p', 'h', 'a', 's', };
const TInt charForPinyin322[1] = {
	0x5DFC
	};
const TText16 KPinyin323[6] = {'p', 'h', 'd', 'e', 'n', 'g', };
const TInt charForPinyin323[1] = {
	0x95CF
	};
const TText16 KPinyin324[4] = {'p', 'h', 'o', 'i', };
const TInt charForPinyin324[1] = {
	0x4E76
	};
const TText16 KPinyin325[4] = {'p', 'h', 'o', 's', };
const TInt charForPinyin325[1] = {
	0x55B8
	};
const TText16 KPinyin326[2] = {'p', 'i', };
const TInt charForPinyin326[159] = {
	0x6279, 0x76AE, 0x62AB, 0x5339, 0x5288, 0x8F9F, 0x576F, 0x5C41, 0x813E, 0x50FB, 0x75B2, 0x75DE, 0x9739, 0x7435, 0x6BD7, 0x5564, 
	0x8B6C, 0x7812, 0x5426, 0x8C94, 0x4E15, 0x572E, 0x5AB2, 0x7656, 0x4EF3, 0x64D7, 0x90EB, 0x7513, 0x6787, 0x7765, 0x8731, 0x9F19, 
	0x90B3, 0x5421, 0x9642, 0x94CD, 0x5E80, 0x7F74, 0x57E4, 0x7EB0, 0x9674, 0x6DE0, 0x567C, 0x868D, 0x88E8, 0x4F13, 0x4F3E, 0x4FFE, 
	0x526F, 0x5351, 0x567D, 0x568A, 0x56AD, 0x574F, 0x57F9, 0x58C0, 0x599A, 0x5AD3, 0x5CAF, 0x5D25, 0x5D8F, 0x5E14, 0x5E87, 0x5EB3, 
	0x6036, 0x6082, 0x61B5, 0x6251, 0x62B7, 0x62C2, 0x63CA, 0x65C7, 0x6707, 0x6788, 0x6911, 0x698C, 0x6BD4, 0x6BD8, 0x6BDE, 0x6E12, 
	0x6F4E, 0x6FBC, 0x6FDE, 0x708B, 0x7137, 0x72C9, 0x72D3, 0x7308, 0x7588, 0x758B, 0x75E6, 0x75FA, 0x7764, 0x78C7, 0x7914, 0x7915, 
	0x79DB, 0x79E0, 0x7A2B, 0x7B13, 0x7B86, 0x7BE6, 0x7BFA, 0x7C32, 0x7C83, 0x7D15, 0x7F77, 0x7F86, 0x7FCD, 0x801A, 0x80B6, 0x8134, 
	0x8157, 0x818D, 0x8298, 0x82C9, 0x82E4, 0x8406, 0x8543, 0x868C, 0x86BD, 0x86BE, 0x8795, 0x87B7, 0x882F, 0x88AB, 0x8AC0, 0x8C7C, 
	0x8C7E, 0x9131, 0x91FD, 0x9208, 0x921A, 0x9232, 0x9239, 0x925F, 0x9294, 0x92A2, 0x9303, 0x930D, 0x939E, 0x949A, 0x95E2, 0x9630, 
	0x96A6, 0x979E, 0x9817, 0x9856, 0x9887, 0x99D3, 0x9AEC, 0x9B6E, 0x9B7E, 0x9B8D, 0x9C8F, 0x9D04, 0x9D67, 0x9DFF, 0x9E0A
	};
const TText16 KPinyin327[4] = {'p', 'i', 'a', 'n', };
const TInt charForPinyin327[41] = {
	0x7247, 0x7BC7, 0x9A97, 0x504F, 0x4FBF, 0x6241, 0x7FE9, 0x7F0F, 0x728F, 0x9A88, 0x80FC, 0x8E41, 0x8C1D, 0x56E8, 0x5AA5, 0x5E73, 
	0x5FA7, 0x6944, 0x6969, 0x7335, 0x74B8, 0x7DF6, 0x8141, 0x8439, 0x8759, 0x890A, 0x8991, 0x8ADA, 0x8ADE, 0x8CB5, 0x8CC6, 0x8DF0, 
	0x8FA9, 0x8FAF, 0x99E2, 0x9A08, 0x9A17, 0x9A19, 0x9ABF, 0x9B78, 0x9DA3
	};
const TText16 KPinyin328[8] = {'p', 'i', 'a', 'n', 'p', 'a', 'n', 'g', };
const TInt charForPinyin328[41] = {
	0x7592, 0x961D, 0x8080, 0x531A, 0x7E9F, 0x8279, 0x864D, 0x4EA0, 0x5EFE, 0x5FC4, 0x5F50, 0x5182, 0x4EBB, 0x5C22, 0x5B80, 0x5202, 
	0x706C, 0x4E36, 0x624C, 0x51AB, 0x6535, 0x4E28, 0x793B, 0x5902, 0x9963, 0x4E3F, 0x5C6E, 0x8FB6, 0x5196, 0x5F61, 0x9485, 0x72AD, 
	0x56D7, 0x52F9, 0x5369, 0x5EF4, 0x8864, 0x4E2C, 0x51F5, 0x6C35, 0x8BA0
	};
const TText16 KPinyin329[4] = {'p', 'i', 'a', 'o', };
const TInt charForPinyin329[42] = {
	0x7968, 0x98D8, 0x6F02, 0x74E2, 0x6734, 0x87B5, 0x83A9, 0x5AD6, 0x779F, 0x6B8D, 0x7F25, 0x560C, 0x9AA0, 0x527D, 0x50C4, 0x52E1, 
	0x5F6F, 0x5FB1, 0x6153, 0x647D, 0x65DA, 0x6F4E, 0x72A5, 0x76AB, 0x78E6, 0x7BFB, 0x7E39, 0x7FF2, 0x8198, 0x8508, 0x85B8, 0x8B24, 
	0x91A5, 0x95DD, 0x9860, 0x98C3, 0x98C4, 0x9A43, 0x9A6B, 0x9A89, 0x9ADF, 0x9B52
	};
const TText16 KPinyin330[3] = {'p', 'i', 'e', };
const TInt charForPinyin330[13] = {
	0x77A5, 0x6487, 0x6C15, 0x82E4, 0x4E3F, 0x5AF3, 0x6486, 0x66BC, 0x6F4E, 0x80BA, 0x853D, 0x8995, 0x9405
	};
const TText16 KPinyin331[3] = {'p', 'i', 'n', };
const TInt charForPinyin331[31] = {
	0x54C1, 0x8D2B, 0x8058, 0x62FC, 0x9891, 0x5AD4, 0x6980, 0x59D8, 0x725D, 0x98A6, 0x5315, 0x56AC, 0x5A09, 0x5B2A, 0x62DA, 0x6729, 
	0x6C56, 0x6CF5, 0x73AD, 0x7415, 0x77C9, 0x780F, 0x7917, 0x7A66, 0x85B2, 0x860B, 0x8CA7, 0x983B, 0x9870, 0x99AA, 0x9A5E
	};
const TText16 KPinyin332[4] = {'p', 'i', 'n', 'g', };
const TInt charForPinyin332[59] = {
	0x5E73, 0x51ED, 0x74F6, 0x8BC4, 0x5C4F, 0x4E52, 0x840D, 0x82F9, 0x576A, 0x51AF, 0x5A09, 0x9C86, 0x67B0, 0x4FDC, 0x5017, 0x51F4, 
	0x546F, 0x5840, 0x5A26, 0x5C5B, 0x5CBC, 0x5E21, 0x5E32, 0x5E48, 0x617F, 0x6191, 0x6A98, 0x6CD9, 0x6D34, 0x6D84, 0x6DDC, 0x7129, 
	0x73B6, 0x7501, 0x7539, 0x782F, 0x7830, 0x7851, 0x79E4, 0x7AEE, 0x7BB3, 0x7C08, 0x7F3E, 0x8060, 0x80D3, 0x8275, 0x8353, 0x84F1, 
	0x860B, 0x86B2, 0x86E2, 0x8A55, 0x8EFF, 0x8F27, 0x90F1, 0x927C, 0x9829, 0x99AE, 0x9B83
	};
const TText16 KPinyin333[2] = {'p', 'o', };
const TInt charForPinyin333[64] = {
	0x7834, 0x5761, 0x9887, 0x5A46, 0x6CFC, 0x8FEB, 0x6CCA, 0x9B44, 0x6734, 0x7E41, 0x7C95, 0x7B38, 0x76A4, 0x948B, 0x9642, 0x9131, 
	0x6534, 0x53F5, 0x73C0, 0x94B7, 0x54F1, 0x5619, 0x5964, 0x5A1D, 0x5C00, 0x5C03, 0x5C70, 0x5CA5, 0x5CB6, 0x5DFF, 0x5EF9, 0x642B, 
	0x6540, 0x6622, 0x6872, 0x693A, 0x6AC7, 0x6D26, 0x6DFF, 0x6E50, 0x6E8C, 0x6EA5, 0x6F51, 0x6FFC, 0x70DE, 0x733C, 0x769B, 0x7836, 
	0x7FCD, 0x818A, 0x84AA, 0x8522, 0x8B08, 0x8DDB, 0x9166, 0x91B1, 0x91D9, 0x9255, 0x93FA, 0x9738, 0x9817, 0x999E, 0x99CA, 0x9AC6
	};
const TText16 KPinyin334[3] = {'p', 'o', 'u', };
const TInt charForPinyin334[27] = {
	0x5256, 0x638A, 0x88D2, 0x5425, 0x5485, 0x54E3, 0x57BA, 0x57F9, 0x5837, 0x5A44, 0x6294, 0x6299, 0x62B1, 0x634A, 0x68D3, 0x6DAA, 
	0x7283, 0x7B81, 0x88E6, 0x8912, 0x8943, 0x8E23, 0x90E8, 0x90F6, 0x9307, 0x952B, 0x9892
	};
const TText16 KPinyin335[4] = {'p', 'p', 'u', 'n', };
const TInt charForPinyin335[2] = {
	0x517A, 0x54DB
	};
const TText16 KPinyin336[2] = {'p', 'u', };
const TInt charForPinyin336[80] = {
	0x6251, 0x94FA, 0x8C31, 0x812F, 0x4EC6, 0x84B2, 0x8461, 0x6734, 0x83E9, 0x66DD, 0x8386, 0x7011, 0x57D4, 0x5703, 0x6D66, 0x5821, 
	0x666E, 0x66B4, 0x9568, 0x5657, 0x530D, 0x6EA5, 0x6FEE, 0x6C06, 0x8E7C, 0x749E, 0x9564, 0x50D5, 0x525D, 0x5265, 0x535C, 0x5711, 
	0x5724, 0x58A3, 0x5DEC, 0x5DED, 0x6276, 0x62AA, 0x6357, 0x64B2, 0x64C8, 0x6534, 0x6535, 0x669C, 0x67E8, 0x6A38, 0x6A8F, 0x6F7D, 
	0x7087, 0x70F3, 0x735B, 0x752B, 0x75E1, 0x77A8, 0x7832, 0x79FF, 0x7A59, 0x7B81, 0x7E80, 0x8216, 0x8217, 0x82FB, 0x8379, 0x83D0, 
	0x84B1, 0x8705, 0x8946, 0x8965, 0x8AE9, 0x8B5C, 0x8C67, 0x8D0C, 0x917A, 0x92EA, 0x93F7, 0x9420, 0x9660, 0x99C7, 0x9BC6, 0x9D4F
	};
const TText16 KPinyin337[1] = {'q', };
const TInt charForPinyin337[1] = {
	0x7441
	};
const TText16 KPinyin338[2] = {'q', 'i', };
const TInt charForPinyin338[284] = {
	0x8D77, 0x5176, 0x4E03, 0x6C14, 0x671F, 0x9F50, 0x5668, 0x59BB, 0x9A91, 0x6C7D, 0x68CB, 0x5947, 0x6B3A, 0x6F06, 0x542F, 0x621A, 
	0x67D2, 0x5C82, 0x780C, 0x5F03, 0x6CE3, 0x7941, 0x51C4, 0x4F01, 0x4E5E, 0x5951, 0x6B67, 0x7948, 0x6816, 0x7566, 0x8110, 0x5D0E, 
	0x7A3D, 0x8FC4, 0x7F09, 0x6C8F, 0x8BAB, 0x65D7, 0x797A, 0x9880, 0x9A90, 0x5C7A, 0x5C90, 0x8E4A, 0x8401, 0x8572, 0x6864, 0x61A9, 
	0x82AA, 0x8360, 0x840B, 0x8291, 0x6C54, 0x4E9F, 0x9CCD, 0x4FDF, 0x69ED, 0x5601, 0x86F4, 0x7DA6, 0x4E93, 0x6B39, 0x742A, 0x9E92, 
	0x7426, 0x871E, 0x573B, 0x675E, 0x847A, 0x789B, 0x6DC7, 0x7957, 0x8006, 0x7EEE, 0x4E0C, 0x4E9D, 0x4F0E, 0x501B, 0x5048, 0x50B6, 
	0x50DB, 0x5207, 0x523A, 0x5258, 0x52E4, 0x5403, 0x5431, 0x5447, 0x546E, 0x54A0, 0x5518, 0x552D, 0x5553, 0x5554, 0x555F, 0x55B0, 
	0x5650, 0x57FC, 0x5921, 0x5A38, 0x5A4D, 0x5BBF, 0x5C93, 0x5D5C, 0x5DF1, 0x5E3A, 0x5FD4, 0x5FEE, 0x5FEF, 0x5FFE, 0x6053, 0x605D, 
	0x60BD, 0x6112, 0x612D, 0x613E, 0x617C, 0x617D, 0x6187, 0x61E0, 0x6262, 0x6271, 0x627A, 0x6280, 0x62B5, 0x62DE, 0x6308, 0x637F, 
	0x6391, 0x63ED, 0x6456, 0x652F, 0x6532, 0x6567, 0x6589, 0x658A, 0x65C2, 0x6675, 0x66A3, 0x671E, 0x679D, 0x6814, 0x687C, 0x68A9, 
	0x68C4, 0x68CA, 0x68E8, 0x68F2, 0x69BF, 0x6AB1, 0x6AC0, 0x6B2B, 0x6BC4, 0x6C17, 0x6C23, 0x6D13, 0x6D4E, 0x6DD2, 0x6E08, 0x6E0D, 
	0x6E0F, 0x6E46, 0x6E47, 0x6ECA, 0x6F2C, 0x6FDD, 0x6FDF, 0x7081, 0x710F, 0x7309, 0x7382, 0x7398, 0x7482, 0x7508, 0x752D, 0x7578, 
	0x75A7, 0x76C0, 0x76F5, 0x77F5, 0x7881, 0x7895, 0x78B6, 0x78CE, 0x78DC, 0x78E7, 0x78E9, 0x7918, 0x793A, 0x7947, 0x79A5, 0x79A8, 
	0x7A18, 0x7AD2, 0x7C2F, 0x7C31, 0x7C4F, 0x7CB8, 0x7D2A, 0x7D5C, 0x7DA5, 0x7DA8, 0x7DAE, 0x7DBA, 0x7DC0, 0x7DD5, 0x7DDD, 0x7E83, 
	0x7F3C, 0x7F4A, 0x8090, 0x80B5, 0x81CD, 0x8219, 0x8269, 0x829E, 0x8415, 0x85BA, 0x85C4, 0x8604, 0x8691, 0x8694, 0x869A, 0x871D, 
	0x8787, 0x87A7, 0x87E3, 0x87FF, 0x8810, 0x8879, 0x88B3, 0x88FF, 0x8900, 0x8904, 0x89ED, 0x8A16, 0x8AC6, 0x8AEC, 0x8AFF, 0x8C48, 
	0x8D9E, 0x8DBF, 0x8DC2, 0x8E11, 0x8E16, 0x8E26, 0x8EA4, 0x8EA9, 0x8ED9, 0x8EDD, 0x8FC9, 0x9017, 0x9094, 0x90EA, 0x913F, 0x91EE, 
	0x9321, 0x93DA, 0x9416, 0x951C, 0x95D9, 0x9691, 0x970B, 0x980E, 0x9951, 0x9A0E, 0x9A0F, 0x9A39, 0x9B10, 0x9B3E, 0x9B3F, 0x9B4C, 
	0x9B55, 0x9BA8, 0x9BD5, 0x9C2D, 0x9CAF, 0x9D78, 0x9D80, 0x9D88, 0x9EA1, 0x9F1C, 0x9F4A, 0x9F6E
	};
const TText16 KPinyin339[3] = {'q', 'i', 'a', };
const TInt charForPinyin339[33] = {
	0x6070, 0x5361, 0x6390, 0x6D3D, 0x9AC2, 0x88B7, 0x845C, 0x4F49, 0x50F9, 0x51BE, 0x54AD, 0x5736, 0x5BA2, 0x5E22, 0x6118, 0x62B2, 
	0x62E4, 0x6308, 0x63E2, 0x6433, 0x64D6, 0x696C, 0x6B8E, 0x75B4, 0x77FB, 0x7848, 0x78CD, 0x7D5C, 0x8DD2, 0x9160, 0x9790, 0x9B9A, 
	0x9C92
	};
const TText16 KPinyin340[4] = {'q', 'i', 'a', 'n', };
const TInt charForPinyin340[206] = {
	0x524D, 0x94B1, 0x5343, 0x7275, 0x6D45, 0x7B7E, 0x6B20, 0x94C5, 0x5D4C, 0x948E, 0x8FC1, 0x94B3, 0x4E7E, 0x8C34, 0x8C26, 0x6F5C, 
	0x6B49, 0x7EA4, 0x6266, 0x9063, 0x9ED4, 0x5811, 0x4EDF, 0x5C8D, 0x94A4, 0x8930, 0x7B9D, 0x63AE, 0x6434, 0x5029, 0x614A, 0x60AD, 
	0x6106, 0x8654, 0x82A1, 0x8368, 0x7F31, 0x4F65, 0x828A, 0x9621, 0x80B7, 0x831C, 0x6920, 0x728D, 0x9A9E, 0x4E79, 0x4EF1, 0x4F23, 
	0x4FD4, 0x5042, 0x5094, 0x50C9, 0x5119, 0x51C4, 0x51F5, 0x520B, 0x53B1, 0x550A, 0x55DB, 0x5731, 0x5732, 0x5879, 0x5898, 0x58CD, 
	0x5977, 0x5A5C, 0x5A8A, 0x5B31, 0x5B45, 0x5B6F, 0x5BE8, 0x5C92, 0x5D70, 0x5EDE, 0x5FCF, 0x5FF4, 0x6093, 0x6173, 0x6272, 0x62D1, 
	0x62EA, 0x6333, 0x6394, 0x63C3, 0x63F5, 0x647C, 0x6481, 0x648D, 0x6496, 0x6510, 0x6511, 0x6513, 0x6701, 0x6744, 0x6774, 0x67D1, 
	0x68C8, 0x69A9, 0x69CF, 0x69E7, 0x6A6C, 0x6AB6, 0x6ACF, 0x6B26, 0x6B3F, 0x6B41, 0x6B6C, 0x6C58, 0x6C67, 0x6D94, 0x6DD2, 0x6DFA, 
	0x6E10, 0x6E54, 0x6F38, 0x6F5B, 0x6FF3, 0x6FFD, 0x704A, 0x7052, 0x70B6, 0x7154, 0x7191, 0x71C2, 0x71EB, 0x727D, 0x7698, 0x7ACF, 
	0x7B4B, 0x7B9E, 0x7BCF, 0x7BDF, 0x7C3D, 0x7C56, 0x7C64, 0x7C81, 0x7DAA, 0x7E34, 0x7E7E, 0x7F9F, 0x7FA5, 0x7FAC, 0x8125, 0x8171, 
	0x8181, 0x81E4, 0x824C, 0x82C2, 0x833E, 0x8355, 0x8465, 0x8474, 0x84A8, 0x8533, 0x8541, 0x85D6, 0x8688, 0x8699, 0x8738, 0x8AD0, 
	0x8B19, 0x8B74, 0x8C38, 0x8D76, 0x8EE1, 0x8F24, 0x9077, 0x91FA, 0x9206, 0x9210, 0x9246, 0x9257, 0x925B, 0x92AD, 0x92DF, 0x930E, 
	0x9322, 0x937C, 0x9386, 0x93F2, 0x9431, 0x9453, 0x946F, 0x9513, 0x958B, 0x96C3, 0x976C, 0x97C6, 0x9845, 0x99AF, 0x9A1A, 0x9A1D, 
	0x9A2B, 0x9B1C, 0x9B1D, 0x9C1C, 0x9C2C, 0x9CD2, 0x9CFD, 0x9D6E, 0x9DBC, 0x9E50, 0x9E63, 0x9EDA, 0x9F66, 0x9F88
	};
const TText16 KPinyin341[5] = {'q', 'i', 'a', 'n', 'g', };
const TInt charForPinyin341[84] = {
	0x5F3A, 0x67AA, 0x5899, 0x62A2, 0x8154, 0x545B, 0x7F8C, 0x8537, 0x5C06, 0x8723, 0x8DC4, 0x6217, 0x8941, 0x6215, 0x709D, 0x956A, 
	0x9516, 0x9535, 0x7F9F, 0x6A2F, 0x5AF1, 0x5275, 0x52E5, 0x54D0, 0x5534, 0x554C, 0x55C6, 0x55F4, 0x588F, 0x58BB, 0x5B19, 0x5C07, 
	0x5D88, 0x5E86, 0x5EE7, 0x5F37, 0x5F4A, 0x6176, 0x6227, 0x63A7, 0x6436, 0x6464, 0x646A, 0x65A8, 0x690C, 0x69CD, 0x6AA3, 0x6BBB, 
	0x6EAC, 0x6F12, 0x7197, 0x723F, 0x7244, 0x7246, 0x7310, 0x7347, 0x73B1, 0x7437, 0x7472, 0x77FC, 0x7B90, 0x7BEC, 0x7E48, 0x7E66, 
	0x7F97, 0x7FA5, 0x7FAB, 0x7FBB, 0x8262, 0x8503, 0x8594, 0x8620, 0x89AA, 0x8B12, 0x8DEB, 0x8E4C, 0x8E61, 0x9306, 0x9397, 0x93D8, 
	0x93F9, 0x9869, 0x9DAC, 0x9E27
	};
const TText16 KPinyin342[6] = {'q', 'i', 'a', 'n', 'k', 'e', };
const TInt charForPinyin342[1] = {
	0x515B
	};
const TText16 KPinyin343[6] = {'q', 'i', 'a', 'n', 'w', 'a', };
const TInt charForPinyin343[1] = {
	0x74E9
	};
const TText16 KPinyin344[4] = {'q', 'i', 'a', 'o', };
const TInt charForPinyin344[126] = {
	0x6865, 0x77A7, 0x6572, 0x5DE7, 0x7FD8, 0x9539, 0x58F3, 0x9798, 0x64AC, 0x6084, 0x4FCF, 0x7A8D, 0x96C0, 0x4E54, 0x4FA8, 0x5CED, 
	0x6A47, 0x6A35, 0x835E, 0x8DF7, 0x7857, 0x6194, 0x8C2F, 0x9792, 0x6100, 0x7F32, 0x8BEE, 0x5281, 0x5062, 0x50D1, 0x50FA, 0x524A, 
	0x52EA, 0x55AC, 0x55BF, 0x563A, 0x566D, 0x5859, 0x589D, 0x58A7, 0x58BD, 0x5AF6, 0x5CE4, 0x5D6A, 0x5DA0, 0x5E29, 0x5E53, 0x5E67, 
	0x6101, 0x62DB, 0x634E, 0x641E, 0x646E, 0x64BD, 0x656B, 0x6821, 0x69D7, 0x6A4B, 0x6A7E, 0x6BBC, 0x6BC3, 0x6BF3, 0x6F50, 0x7126, 
	0x7133, 0x71C6, 0x71CB, 0x729E, 0x7644, 0x7744, 0x785A, 0x785D, 0x78BB, 0x78DD, 0x78FD, 0x7904, 0x7909, 0x7AAF, 0x7AC5, 0x7BBE, 
	0x7E51, 0x7E70, 0x7FF9, 0x832D, 0x834D, 0x83EC, 0x8549, 0x854E, 0x85EE, 0x87DC, 0x8A9A, 0x8B51, 0x8B59, 0x8DAB, 0x8DAC, 0x8DE4, 
	0x8E03, 0x8E0D, 0x8E7A, 0x8E7B, 0x8E88, 0x90FB, 0x9117, 0x9121, 0x9125, 0x91AE, 0x91E5, 0x929A, 0x936B, 0x936C, 0x93D2, 0x9408, 
	0x9430, 0x94EB, 0x9657, 0x97A9, 0x97BD, 0x97D2, 0x981D, 0x9864, 0x9866, 0x9A55, 0x9A84, 0x9AB9, 0x9ADA, 0x9ADC
	};
const TText16 KPinyin345[3] = {'q', 'i', 'e', };
const TInt charForPinyin345[60] = {
	0x5207, 0x4E14, 0x602F, 0x7A83, 0x8304, 0x780C, 0x90C4, 0x8D84, 0x60EC, 0x9532, 0x59BE, 0x7BA7, 0x614A, 0x4F3D, 0x6308, 0x5022, 
	0x503F, 0x507C, 0x5327, 0x5392, 0x553C, 0x558B, 0x5951, 0x5A55, 0x5AAB, 0x5E39, 0x608F, 0x611C, 0x6377, 0x6705, 0x6904, 0x6C8F, 
	0x6D2F, 0x6DC1, 0x6F06, 0x758C, 0x767F, 0x7A27, 0x7A55, 0x7ACA, 0x7B21, 0x7BCB, 0x7C61, 0x7DC1, 0x807A, 0x811E, 0x82C6, 0x857A, 
	0x85D2, 0x86E3, 0x86EA, 0x8A67, 0x8DD9, 0x8E25, 0x9365, 0x9411, 0x9B65, 0x9BDC, 0x9C08, 0x9CBD
	};
const TText16 KPinyin346[3] = {'q', 'i', 'n', };
const TInt charForPinyin346[105] = {
	0x4EB2, 0x7434, 0x4FB5, 0x52E4, 0x64D2, 0x5BDD, 0x79E6, 0x82B9, 0x6C81, 0x79BD, 0x94A6, 0x5423, 0x8983, 0x77DC, 0x887E, 0x82A9, 
	0x6EB1, 0x5ED1, 0x55EA, 0x8793, 0x5659, 0x63FF, 0x6A8E, 0x9513, 0x512D, 0x53AA, 0x5422, 0x551A, 0x5745, 0x57C1, 0x57D0, 0x5807, 
	0x5890, 0x5A87, 0x5AC0, 0x5BD1, 0x5BE2, 0x5BF4, 0x5D5A, 0x5D94, 0x5D9C, 0x5E88, 0x5EDE, 0x5FF4, 0x616C, 0x61C3, 0x61C4, 0x6272, 
	0x628B, 0x6366, 0x6407, 0x64B3, 0x65B3, 0x6611, 0x68AB, 0x69FF, 0x6A6C, 0x6AEC, 0x6B3D, 0x6D78, 0x6D81, 0x6E17, 0x6EF2, 0x6FBF, 
	0x6FC5, 0x7019, 0x73E1, 0x7439, 0x763D, 0x77DD, 0x7B09, 0x7D85, 0x8039, 0x80A3, 0x81E4, 0x83E3, 0x83E6, 0x83F3, 0x84C1, 0x8572, 
	0x85FD, 0x8604, 0x8699, 0x87BC, 0x8804, 0x887F, 0x89AA, 0x8A9B, 0x8D7A, 0x8D7E, 0x9202, 0x920A, 0x9219, 0x92DF, 0x96C2, 0x9772, 
	0x981C, 0x9849, 0x9869, 0x988C, 0x99F8, 0x9A8E, 0x9B35, 0x9BBC, 0x9CF9
	};
const TText16 KPinyin347[4] = {'q', 'i', 'n', 'g', };
const TInt charForPinyin347[75] = {
	0x8BF7, 0x8F7B, 0x6E05, 0x9752, 0x60C5, 0x6674, 0x6C22, 0x503E, 0x5E86, 0x64CE, 0x9877, 0x4EB2, 0x537F, 0x6C30, 0x570A, 0x8B26, 
	0x6AA0, 0x7B90, 0x82D8, 0x873B, 0x9EE5, 0x7F44, 0x9CAD, 0x78EC, 0x7DAE, 0x5029, 0x50BE, 0x512C, 0x51CA, 0x5260, 0x52CD, 0x5568, 
	0x57E5, 0x58F0, 0x591D, 0x5A87, 0x5BC8, 0x5EBC, 0x5ECE, 0x6176, 0x6385, 0x64CF, 0x6692, 0x68FE, 0x6A08, 0x6ABE, 0x6AE6, 0x6B91, 
	0x6BB8, 0x6C2B, 0x6D87, 0x6DF8, 0x6E39, 0x6F00, 0x6FEA, 0x73AA, 0x7520, 0x7858, 0x785C, 0x7883, 0x7CBE, 0x7DAA, 0x80DC, 0x8394, 
	0x845D, 0x8ACB, 0x8EFD, 0x8F15, 0x90EC, 0x944B, 0x9751, 0x9758, 0x9803, 0x9BD6, 0x9D84
	};
const TText16 KPinyin348[5] = {'q', 'i', 'o', 'n', 'g', };
const TInt charForPinyin348[36] = {
	0x7A77, 0x743C, 0x8DEB, 0x7A79, 0x909B, 0x86E9, 0x8315, 0x928E, 0x7B47, 0x511D, 0x536D, 0x5B1B, 0x5B86, 0x60F8, 0x618C, 0x684F, 
	0x6A69, 0x712A, 0x712D, 0x7162, 0x718D, 0x7401, 0x749A, 0x74CA, 0x74D7, 0x7758, 0x778F, 0x7AAE, 0x7AC6, 0x7B3B, 0x823C, 0x85D1, 
	0x85ED, 0x86EC, 0x8D79, 0x97A0
	};
const TText16 KPinyin349[3] = {'q', 'i', 'u', };
const TInt charForPinyin349[109] = {
	0x6C42, 0x7403, 0x79CB, 0x4E18, 0x6CC5, 0x4EC7, 0x90B1, 0x56DA, 0x914B, 0x9F9F, 0x6978, 0x86AF, 0x88D8, 0x7CD7, 0x8764, 0x5DEF, 
	0x9011, 0x4FC5, 0x866C, 0x8D47, 0x9CC5, 0x72B0, 0x6E6B, 0x9F3D, 0x9052, 0x4E20, 0x533A, 0x53B9, 0x53F4, 0x5512, 0x56E2, 0x5775, 
	0x5A9D, 0x5BBF, 0x5BC8, 0x5D37, 0x5DF0, 0x6058, 0x60C6, 0x6100, 0x624F, 0x6344, 0x641D, 0x6739, 0x6882, 0x6AF9, 0x6B8F, 0x6BEC, 
	0x6C3D, 0x6C3F, 0x6C53, 0x6D57, 0x6E1E, 0x6E6C, 0x6E6D, 0x716A, 0x726B, 0x738C, 0x7486, 0x76B3, 0x76DA, 0x79CC, 0x7A50, 0x7BCD, 
	0x7D0C, 0x7D7F, 0x7DE7, 0x808D, 0x827D, 0x838D, 0x8429, 0x84F2, 0x8612, 0x866F, 0x86F7, 0x8775, 0x87D7, 0x8824, 0x89D3, 0x89E9, 
	0x8A04, 0x8A05, 0x8CD5, 0x8D9C, 0x8DA5, 0x900E, 0x90BA, 0x9194, 0x91D3, 0x91DA, 0x91FB, 0x92B6, 0x9486, 0x97A6, 0x97A7, 0x9997, 
	0x9B82, 0x9BC4, 0x9C0C, 0x9C0D, 0x9C3D, 0x9C43, 0x9CE9, 0x9D6D, 0x9D96, 0x9E20, 0x9E59, 0x9F9C, 0x9F9D
	};
const TText16 KPinyin350[2] = {'q', 'u', };
const TInt charForPinyin350[138] = {
	0x53BB, 0x53D6, 0x533A, 0x5A36, 0x6E20, 0x66F2, 0x8D8B, 0x8DA3, 0x5C48, 0x9A71, 0x86C6, 0x8EAF, 0x9F8B, 0x620C, 0x883C, 0x8627, 
	0x795B, 0x8556, 0x78F2, 0x52AC, 0x8BCE, 0x9E32, 0x9612, 0x9EB4, 0x766F, 0x8862, 0x9EE2, 0x74A9, 0x6C0D, 0x89D1, 0x86D0, 0x6710, 
	0x77BF, 0x5C96, 0x82E3, 0x4F39, 0x4F49, 0x4F62, 0x521E, 0x5324, 0x5337, 0x5340, 0x53BA, 0x53E5, 0x547F, 0x5765, 0x5CA8, 0x5CB4, 
	0x5D87, 0x5DE8, 0x5F06, 0x5FC2, 0x601A, 0x6188, 0x6235, 0x62BE, 0x657A, 0x65AA, 0x6B0B, 0x6B2A, 0x6BC6, 0x6D40, 0x6DED, 0x7048, 
	0x710C, 0x7496, 0x7AD8, 0x7AEC, 0x7B41, 0x7C67, 0x7CAC, 0x7D36, 0x7D44, 0x7D47, 0x7EC4, 0x7FD1, 0x7FF5, 0x801D, 0x80CA, 0x80E0, 
	0x8125, 0x81DE, 0x83C3, 0x844B, 0x86BC, 0x8721, 0x877A, 0x87B6, 0x87DD, 0x8837, 0x8850, 0x88AA, 0x89B0, 0x89B7, 0x89BB, 0x8A53, 
	0x8A58, 0x8A87, 0x8AB3, 0x8D8D, 0x8D9C, 0x8DA8, 0x8DD4, 0x8DD9, 0x8DFC, 0x8EA3, 0x8EC0, 0x8EE5, 0x8FF2, 0x907D, 0x90E5, 0x9264, 
	0x943B, 0x947A, 0x95B4, 0x95C3, 0x9639, 0x97A0, 0x97AB, 0x99C6, 0x99C8, 0x9A36, 0x9A45, 0x9A7A, 0x9AF7, 0x9B7C, 0x9B88, 0x9C38, 
	0x9C4B, 0x9D1D, 0x9D8C, 0x9E1C, 0x9EAE, 0x9EAF, 0x9EB9, 0x9F01, 0x9F29, 0x9F72
	};
const TText16 KPinyin351[4] = {'q', 'u', 'a', 'n', };
const TInt charForPinyin351[93] = {
	0x5168, 0x6743, 0x529D, 0x5708, 0x62F3, 0x72AC, 0x6CC9, 0x5238, 0x98A7, 0x75CA, 0x919B, 0x94E8, 0x7B4C, 0x7EFB, 0x8BE0, 0x8F81, 
	0x754E, 0x9B08, 0x609B, 0x8737, 0x8343, 0x4F7A, 0x52E7, 0x52F8, 0x5377, 0x5573, 0x570F, 0x5733, 0x57E2, 0x59FE, 0x5A58, 0x5B49, 
	0x5CD1, 0x5DCF, 0x5DFB, 0x5F2E, 0x606E, 0x60D3, 0x62F4, 0x6372, 0x643C, 0x6812, 0x684A, 0x68EC, 0x6926, 0x697E, 0x69EB, 0x6A29, 
	0x6B0A, 0x6C71, 0x6D24, 0x6E76, 0x7065, 0x70C7, 0x7276, 0x7277, 0x7288, 0x72AD, 0x737E, 0x742F, 0x7454, 0x753D, 0x77D4, 0x7842, 
	0x7D14, 0x7D5F, 0x7DA3, 0x7E13, 0x7EAF, 0x8143, 0x8472, 0x8647, 0x8838, 0x89E0, 0x8A6E, 0x8B1C, 0x8B54, 0x8DE7, 0x8E21, 0x8F07, 
	0x9144, 0x9293, 0x9409, 0x95CE, 0x97CF, 0x9874, 0x99E9, 0x9A21, 0x9C01, 0x9CC8, 0x9E1B, 0x9E73, 0x9F64
	};
const TText16 KPinyin352[3] = {'q', 'u', 'e', };
const TInt charForPinyin352[52] = {
	0x5374, 0x7F3A, 0x786E, 0x96C0, 0x7638, 0x9E4A, 0x7094, 0x69B7, 0x9619, 0x9615, 0x60AB, 0x5095, 0x51B3, 0x537B, 0x57C6, 0x5859, 
	0x58A7, 0x5C48, 0x5D05, 0x6128, 0x6164, 0x6409, 0x6509, 0x6560, 0x6BBB, 0x6BC3, 0x6C4B, 0x6C7A, 0x71E9, 0x730E, 0x7361, 0x76B5, 
	0x785E, 0x788F, 0x78BA, 0x78BB, 0x7910, 0x792D, 0x8203, 0x8204, 0x828D, 0x849B, 0x8697, 0x8D9E, 0x8E16, 0x8EA4, 0x95CB, 0x95D5, 
	0x96BA, 0x9CE5, 0x9D72, 0x9E1F
	};
const TText16 KPinyin353[3] = {'q', 'u', 'n', };
const TInt charForPinyin353[18] = {
	0x7FA4, 0x88D9, 0x9E87, 0x9021, 0x56F7, 0x590B, 0x5BAD, 0x5CEE, 0x5E2C, 0x6B4F, 0x7B98, 0x7FA3, 0x88E0, 0x8E06, 0x8F11, 0x9041, 
	0x9E8F, 0x9E95
	};
const TText16 KPinyin354[2] = {'r', 'a', };
const TInt charForPinyin354[2] = {
	0x4EBD, 0x7F56
	};
const TText16 KPinyin355[3] = {'r', 'a', 'm', };
const TInt charForPinyin355[1] = {
	0x56D5
	};
const TText16 KPinyin356[3] = {'r', 'a', 'n', };
const TInt charForPinyin356[27] = {
	0x67D3, 0x71C3, 0x7136, 0x5189, 0x9AEF, 0x82D2, 0x86BA, 0x5184, 0x536A, 0x5465, 0x562B, 0x59CC, 0x5AA3, 0x67DF, 0x6A6A, 0x71AF, 
	0x73C3, 0x7E4E, 0x80B0, 0x8211, 0x8485, 0x86A6, 0x887B, 0x8887, 0x88A1, 0x8E68, 0x9AE5
	};
const TText16 KPinyin357[4] = {'r', 'a', 'n', 'g', };
const TInt charForPinyin357[27] = {
	0x8BA9, 0x56B7, 0x74E4, 0x6518, 0x58E4, 0x7A70, 0x79B3, 0x5134, 0x52F7, 0x58CC, 0x5B43, 0x5FC0, 0x61F9, 0x6B00, 0x703C, 0x7219, 
	0x737D, 0x7A63, 0x7E95, 0x8618, 0x8830, 0x8B72, 0x8B93, 0x8E9F, 0x9472, 0x9576, 0x9B24
	};
const TText16 KPinyin358[3] = {'r', 'a', 'o', };
const TInt charForPinyin358[22] = {
	0x9976, 0x7ED5, 0x6270, 0x835B, 0x6861, 0x5A06, 0x5B08, 0x6320, 0x6493, 0x64FE, 0x6A48, 0x72AA, 0x7A58, 0x7E5A, 0x7E5E, 0x7F2D, 
	0x8558, 0x87EF, 0x8953, 0x9076, 0x96A2, 0x9952
	};
const TText16 KPinyin359[2] = {'r', 'e', };
const TInt charForPinyin359[9] = {
	0x70ED, 0x82E5, 0x60F9, 0x558F, 0x504C, 0x637C, 0x6E03, 0x71B1, 0x8E43
	};
const TText16 KPinyin360[3] = {'r', 'e', 'n', };
const TInt charForPinyin360[63] = {
	0x4EBA, 0x4EFB, 0x5FCD, 0x8BA4, 0x5203, 0x4EC1, 0x97E7, 0x598A, 0x7EAB, 0x58EC, 0x996A, 0x8F6B, 0x4EDE, 0x834F, 0x845A, 0x887D, 
	0x7A14, 0x4EBB, 0x4EED, 0x513F, 0x5204, 0x59D9, 0x5C7B, 0x5FC8, 0x5FCE, 0x6041, 0x6268, 0x6732, 0x6752, 0x6820, 0x6823, 0x6895, 
	0x68EF, 0x6D8A, 0x7263, 0x79C2, 0x79F9, 0x7D09, 0x7D1D, 0x7D4D, 0x7D9B, 0x7EB4, 0x8095, 0x814D, 0x82A2, 0x8375, 0x83CD, 0x88B5, 
	0x8A12, 0x8A8D, 0x8BB1, 0x8EB5, 0x8ED4, 0x91F0, 0x9213, 0x928B, 0x976D, 0x9771, 0x97CC, 0x98EA, 0x9901, 0x9B5C, 0x9D40
	};
const TText16 KPinyin361[4] = {'r', 'e', 'n', 'g', };
const TInt charForPinyin361[10] = {
	0x4ECD, 0x6254, 0x620E, 0x793D, 0x7A70, 0x8033, 0x827F, 0x82BF, 0x8FB8, 0x967E
	};
const TText16 KPinyin362[2] = {'r', 'i', };
const TInt charForPinyin362[7] = {
	0x65E5, 0x56F8, 0x6C1C, 0x91F0, 0x9224, 0x99B9, 0x9A72
	};
const TText16 KPinyin363[4] = {'r', 'o', 'n', 'g', };
const TInt charForPinyin363[58] = {
	0x5BB9, 0x7ED2, 0x878D, 0x6EB6, 0x7194, 0x8363, 0x620E, 0x84C9, 0x5197, 0x8338, 0x6995, 0x72E8, 0x5D58, 0x809C, 0x877E, 0x5087, 
	0x509B, 0x5748, 0x5AB6, 0x5AC6, 0x5B2B, 0x5B82, 0x5CF5, 0x5D64, 0x5DB8, 0x5DC6, 0x6408, 0x6411, 0x6449, 0x66E7, 0x6804, 0x69AE, 
	0x69B5, 0x6BE7, 0x6C04, 0x701C, 0x70FF, 0x7203, 0x7462, 0x7A41, 0x7A43, 0x7D68, 0x7E19, 0x7E1F, 0x7F1B, 0x7FA2, 0x8319, 0x878E, 
	0x8811, 0x8923, 0x8EF5, 0x9394, 0x9555, 0x9694, 0x980C, 0x9882, 0x99E5, 0x9AF6
	};
const TText16 KPinyin364[3] = {'r', 'o', 'u', };
const TInt charForPinyin364[28] = {
	0x8089, 0x63C9, 0x67D4, 0x7CC5, 0x8E42, 0x97A3, 0x53B9, 0x5A83, 0x5B8D, 0x697A, 0x6E18, 0x7163, 0x7448, 0x74C7, 0x79B8, 0x7C88, 
	0x816C, 0x83A5, 0x8447, 0x875A, 0x8F2E, 0x9352, 0x9450, 0x97D6, 0x9A25, 0x9AF3, 0x9C07, 0x9D94
	};
const TText16 KPinyin365[2] = {'r', 'u', };
const TInt charForPinyin365[62] = {
	0x5982, 0x5165, 0x6C5D, 0x5112, 0x8339, 0x4E73, 0x8925, 0x8FB1, 0x8815, 0x5B7A, 0x84D0, 0x8966, 0x94F7, 0x5685, 0x7F1B, 0x6FE1, 
	0x85B7, 0x98A5, 0x6EBD, 0x6D33, 0x4F9E, 0x5044, 0x543A, 0x54AE, 0x55D5, 0x5973, 0x5AB7, 0x5B2C, 0x5DBF, 0x5E24, 0x6256, 0x6310, 
	0x64E9, 0x66D8, 0x6708, 0x6741, 0x6847, 0x6ABD, 0x6E2A, 0x71F8, 0x7373, 0x7B4E, 0x7E1F, 0x7E7B, 0x8089, 0x8097, 0x81D1, 0x8498, 
	0x8560, 0x88BD, 0x8FBC, 0x909A, 0x910F, 0x91B9, 0x92A3, 0x9450, 0x9700, 0x986C, 0x9C6C, 0x9CF0, 0x9D11, 0x9D3D
	};
const TText16 KPinyin366[3] = {'r', 'u', 'a', };
const TInt charForPinyin366[1] = {
	0x633C
	};
const TText16 KPinyin367[4] = {'r', 'u', 'a', 'n', };
const TInt charForPinyin367[25] = {
	0x8F6F, 0x962E, 0x670A, 0x5044, 0x5827, 0x58D6, 0x5A86, 0x5AF0, 0x611E, 0x648B, 0x6ABD, 0x6E2A, 0x6FE1, 0x71F8, 0x744C, 0x74C0, 
	0x789D, 0x791D, 0x7DDB, 0x800E, 0x815D, 0x8761, 0x8EDF, 0x8F2D, 0x9700
	};
const TText16 KPinyin368[3] = {'r', 'u', 'i', };
const TInt charForPinyin368[40] = {
	0x745E, 0x854A, 0x9510, 0x777F, 0x82AE, 0x868B, 0x6798, 0x8564, 0x514A, 0x514C, 0x5151, 0x5167, 0x5185, 0x53E1, 0x58E1, 0x5A51, 
	0x60E2, 0x6290, 0x648B, 0x6875, 0x68C1, 0x6A64, 0x6C6D, 0x7524, 0x7B0D, 0x7D8F, 0x7DCC, 0x7E60, 0x7EE5, 0x82FC, 0x854B, 0x8602, 
	0x8603, 0x8739, 0x8E12, 0x9209, 0x92B3, 0x92ED, 0x93F8, 0x94A0
	};
const TText16 KPinyin369[3] = {'r', 'u', 'n', };
const TInt charForPinyin369[7] = {
	0x6DA6, 0x95F0, 0x648B, 0x6A4D, 0x6F64, 0x958F, 0x95A0
	};
const TText16 KPinyin370[3] = {'r', 'u', 'o', };
const TInt charForPinyin370[23] = {
	0x82E5, 0x5F31, 0x7BAC, 0x504C, 0x53D2, 0x5A7C, 0x5D76, 0x60F9, 0x633C, 0x637C, 0x648B, 0x6949, 0x6E03, 0x6EBA, 0x712B, 0x7207, 
	0x7BDB, 0x82AE, 0x84BB, 0x9100, 0x9C19, 0x9C2F, 0x9DB8
	};
const TText16 KPinyin371[2] = {'s', 'a', };
const TInt charForPinyin371[33] = {
	0x6492, 0x6D12, 0x8428, 0x6332, 0x4EE8, 0x5345, 0x98D2, 0x810E, 0x644B, 0x6503, 0x686C, 0x6AAB, 0x6AD2, 0x6BBA, 0x6CE7, 0x6F75, 
	0x7051, 0x7E9A, 0x8521, 0x856F, 0x85A9, 0x8A2F, 0x8EA0, 0x9212, 0x939D, 0x93FE, 0x9491, 0x96A1, 0x9705, 0x9778, 0x9788, 0x98AF, 
	0x99BA
	};
const TText16 KPinyin372[5] = {'s', 'a', 'e', 'n', 'g', };
const TInt charForPinyin372[1] = {
	0x680D
	};
const TText16 KPinyin373[3] = {'s', 'a', 'i', };
const TInt charForPinyin373[18] = {
	0x585E, 0x816E, 0x9CC3, 0x601D, 0x8D5B, 0x567B, 0x50FF, 0x55EE, 0x5625, 0x6122, 0x63CC, 0x6BE2, 0x6BF8, 0x7C11, 0x7C3A, 0x8CFD, 
	0x984B, 0x9C13
	};
const TText16 KPinyin374[3] = {'s', 'a', 'l', };
const TInt charForPinyin374[2] = {
	0x4E77, 0x8644
	};
const TText16 KPinyin375[3] = {'s', 'a', 'n', };
const TInt charForPinyin375[36] = {
	0x4E09, 0x6563, 0x4F1E, 0x53C1, 0x9993, 0x7CC1, 0x6BF5, 0x9730, 0x4FD5, 0x5098, 0x50AA, 0x5381, 0x53C2, 0x53C3, 0x53C4, 0x53C5, 
	0x58ED, 0x5E34, 0x5F0E, 0x6A75, 0x6BF6, 0x6BFF, 0x6F75, 0x7299, 0x7CC2, 0x7CDD, 0x7CE3, 0x7CE4, 0x7E56, 0x8518, 0x8B32, 0x93D2, 
	0x93FE, 0x9590, 0x994A, 0x9B16
	};
const TText16 KPinyin376[4] = {'s', 'a', 'n', 'g', };
const TInt charForPinyin376[13] = {
	0x6851, 0x4E27, 0x55D3, 0x98A1, 0x78C9, 0x6421, 0x55AA, 0x6852, 0x69E1, 0x7E95, 0x892C, 0x939F, 0x9859
	};
const TText16 KPinyin377[3] = {'s', 'a', 'o', };
const TInt charForPinyin377[36] = {
	0x626B, 0x5AC2, 0x6414, 0x9A9A, 0x68A2, 0x57FD, 0x9CCB, 0x81CA, 0x7F2B, 0x7619, 0x54E8, 0x6145, 0x61C6, 0x6383, 0x63BB, 0x6A7E, 
	0x6C09, 0x6E9E, 0x7170, 0x71E5, 0x77C2, 0x7E3F, 0x7E45, 0x7E70, 0x7F32, 0x9135, 0x9430, 0x98BE, 0x9A12, 0x9A37, 0x9ADE, 0x9BF5, 
	0x9C20, 0x9C3A, 0x9C62, 0x9CB9
	};
const TText16 KPinyin378[2] = {'s', 'e', };
const TInt charForPinyin378[51] = {
	0x8272, 0x6DA9, 0x745F, 0x585E, 0x556C, 0x94EF, 0x7A51, 0x55C7, 0x5BE8, 0x5EE7, 0x612C, 0x61CE, 0x62FA, 0x64CC, 0x681C, 0x69ED, 
	0x6B6E, 0x6B70, 0x6CE3, 0x6D13, 0x6E0B, 0x6E0D, 0x6EB9, 0x6F2C, 0x6F80, 0x6F81, 0x6FC7, 0x6FCF, 0x7012, 0x7417, 0x74B1, 0x7637, 
	0x7A61, 0x7A6F, 0x7CA3, 0x7E6C, 0x8537, 0x8594, 0x8669, 0x8B45, 0x8F56, 0x924D, 0x92AB, 0x938D, 0x93A9, 0x93FC, 0x94CB, 0x94E9, 
	0x95DF, 0x96ED, 0x98CB
	};
const TText16 KPinyin379[3] = {'s', 'e', 'd', };
const TInt charForPinyin379[1] = {
	0x88C7
	};
const TText16 KPinyin380[3] = {'s', 'e', 'i', };
const TInt charForPinyin380[2] = {
	0x6D81, 0x8053
	};
const TText16 KPinyin381[3] = {'s', 'e', 'n', };
const TInt charForPinyin381[8] = {
	0x68EE, 0x63BA, 0x647B, 0x69EE, 0x6E17, 0x6EF2, 0x7BF8, 0x8942
	};
const TText16 KPinyin382[4] = {'s', 'e', 'n', 'g', };
const TInt charForPinyin382[2] = {
	0x50E7, 0x9B19
	};
const TText16 KPinyin383[3] = {'s', 'e', 'o', };
const TInt charForPinyin383[1] = {
	0x95AA
	};
const TText16 KPinyin384[4] = {'s', 'e', 'o', 'n', };
const TInt charForPinyin384[1] = {
	0x7E07
	};
const TText16 KPinyin385[3] = {'s', 'h', 'a', };
const TInt charForPinyin385[62] = {
	0x6740, 0x6C99, 0x5565, 0x7EB1, 0x50BB, 0x7802, 0x5239, 0x838E, 0x53A6, 0x715E, 0x6749, 0x55C4, 0x553C, 0x9CA8, 0x970E, 0x94E9, 
	0x75E7, 0x88DF, 0x6332, 0x6B43, 0x4E77, 0x503D, 0x510D, 0x524E, 0x5526, 0x5551, 0x55A2, 0x564E, 0x5E39, 0x5EC8, 0x6331, 0x63A5, 
	0x6442, 0x6444, 0x644B, 0x651D, 0x699D, 0x6A27, 0x6BBA, 0x6FC8, 0x7300, 0x7870, 0x7B91, 0x7C86, 0x7D17, 0x7E4C, 0x7E7A, 0x7FDC, 
	0x7FE3, 0x83E8, 0x8410, 0x8531, 0x8CD2, 0x8CD6, 0x8D4A, 0x93A9, 0x95AF, 0x95B7, 0x9705, 0x9B66, 0x9BCA, 0x9BCB
	};
const TText16 KPinyin386[4] = {'s', 'h', 'a', 'i', };
const TInt charForPinyin386[16] = {
	0x6652, 0x7B5B, 0x8272, 0x917E, 0x644B, 0x6526, 0x66EC, 0x6BBA, 0x7BE9, 0x7C01, 0x7C1B, 0x7C6D, 0x7E7A, 0x8853, 0x8AF0, 0x95B7
	};
const TText16 KPinyin387[4] = {'s', 'h', 'a', 'n', };
const TInt charForPinyin387[129] = {
	0x5C71, 0x95EA, 0x886B, 0x5584, 0x6247, 0x6749, 0x5220, 0x717D, 0x5355, 0x73CA, 0x63BA, 0x8D61, 0x6805, 0x82EB, 0x63B8, 0x81B3, 
	0x9655, 0x6C55, 0x64C5, 0x7F2E, 0x5B17, 0x87EE, 0x829F, 0x7985, 0x8DDA, 0x912F, 0x6F78, 0x9CDD, 0x59D7, 0x5261, 0x9A9F, 0x759D, 
	0x81BB, 0x8BAA, 0x9490, 0x8222, 0x57CF, 0x5093, 0x50D0, 0x50E4, 0x5103, 0x510B, 0x522A, 0x527C, 0x5358, 0x55AE, 0x5607, 0x5738, 
	0x58A0, 0x58A1, 0x58C7, 0x59CD, 0x5DA6, 0x5E53, 0x5F61, 0x633B, 0x639E, 0x6400, 0x6427, 0x647B, 0x64D4, 0x6519, 0x657E, 0x6671, 
	0x66CF, 0x66D1, 0x6763, 0x67F5, 0x692B, 0x6A3F, 0x6A80, 0x6A86, 0x6AFC, 0x6F6C, 0x6F98, 0x6FB9, 0x7057, 0x70B6, 0x70FB, 0x7154, 
	0x718C, 0x72E6, 0x732D, 0x75C1, 0x7752, 0x78F0, 0x79AA, 0x7A47, 0x7B18, 0x7B27, 0x7E3F, 0x7E55, 0x7E94, 0x7FB4, 0x7FB6, 0x8120, 
	0x8460, 0x852A, 0x87EC, 0x87FA, 0x8942, 0x8973, 0x89A2, 0x8A15, 0x8B06, 0x8B71, 0x8D0D, 0x8D78, 0x8ED5, 0x9093, 0x9096, 0x91E4, 
	0x928F, 0x9425, 0x9583, 0x9584, 0x958A, 0x965D, 0x9843, 0x986B, 0x98A4, 0x994D, 0x9A38, 0x9ADF, 0x9BC5, 0x9C53, 0x9C54, 0x9C63, 
	0x9CE3
	};
const TText16 KPinyin388[5] = {'s', 'h', 'a', 'n', 'g', };
const TInt charForPinyin388[42] = {
	0x4E0A, 0x4F24, 0x5C1A, 0x5546, 0x8D4F, 0x664C, 0x5892, 0x6C64, 0x88F3, 0x71B5, 0x89DE, 0x7EF1, 0x6B87, 0x57A7, 0x4E04, 0x4EE9, 
	0x50B7, 0x573A, 0x57EB, 0x5834, 0x5872, 0x5C19, 0x6066, 0x6113, 0x616F, 0x6244, 0x6BA4, 0x6E6F, 0x6EF3, 0x6F21, 0x7993, 0x7DD4, 
	0x850F, 0x87AA, 0x8830, 0x89F4, 0x8B2A, 0x8CDE, 0x8E3C, 0x945C, 0x979D, 0x9B3A
	};
const TText16 KPinyin389[4] = {'s', 'h', 'a', 'o', };
const TInt charForPinyin389[50] = {
	0x5C11, 0x70E7, 0x634E, 0x54E8, 0x52FA, 0x68A2, 0x7A0D, 0x90B5, 0x97F6, 0x7ECD, 0x828D, 0x53EC, 0x9798, 0x82D5, 0x52AD, 0x6F72, 
	0x8244, 0x86F8, 0x7B72, 0x4F4B, 0x524A, 0x5372, 0x5A0B, 0x5F30, 0x62DB, 0x641C, 0x65D3, 0x67D6, 0x6EB2, 0x713C, 0x71D2, 0x71FF, 
	0x73BF, 0x7744, 0x7B24, 0x7D39, 0x7D83, 0x7DA4, 0x7EE1, 0x83A6, 0x8414, 0x8437, 0x8571, 0x8891, 0x8F0E, 0x97A9, 0x97D2, 0x98B5, 
	0x9AFE, 0x9BB9
	};
const TText16 KPinyin390[3] = {'s', 'h', 'e', };
const TInt charForPinyin390[60] = {
	0x793E, 0x5C04, 0x86C7, 0x8BBE, 0x820C, 0x6444, 0x820D, 0x6298, 0x6D89, 0x8D4A, 0x8D66, 0x6151, 0x5962, 0x6B59, 0x538D, 0x7572, 
	0x731E, 0x9E9D, 0x6EE0, 0x4F58, 0x5399, 0x5953, 0x5F3D, 0x6174, 0x61FE, 0x62B4, 0x62FE, 0x6315, 0x6368, 0x63F2, 0x6442, 0x6475, 
	0x651D, 0x6AA8, 0x6B07, 0x6DBB, 0x6E09, 0x7044, 0x756C, 0x776B, 0x789F, 0x78FC, 0x8042, 0x8076, 0x820E, 0x8449, 0x850E, 0x8675, 
	0x86DE, 0x86E5, 0x8802, 0x8A2D, 0x8CD2, 0x8CD6, 0x8F0B, 0x95CD, 0x9607, 0x97A8, 0x97D8, 0x9A07
	};
const TText16 KPinyin391[4] = {'s', 'h', 'e', 'i', };
const TInt charForPinyin391[1] = {
	0x8C01
	};
const TText16 KPinyin392[4] = {'s', 'h', 'e', 'n', };
const TInt charForPinyin392[117] = {
	0x8EAB, 0x4F38, 0x6DF1, 0x5A76, 0x795E, 0x751A, 0x6E17, 0x80BE, 0x5BA1, 0x7533, 0x6C88, 0x7EC5, 0x547B, 0x53C2, 0x7837, 0x4EC0, 
	0x5A20, 0x614E, 0x845A, 0x7CC1, 0x8398, 0x8BDC, 0x8C02, 0x77E7, 0x6939, 0x6E16, 0x8703, 0x54C2, 0x80C2, 0x4F14, 0x4F81, 0x4FBA, 
	0x4FE1, 0x515F, 0x53C3, 0x53C4, 0x53C5, 0x5432, 0x5607, 0x5814, 0x59BD, 0x59FA, 0x5AC0, 0x5B38, 0x5B5E, 0x5BB7, 0x5BE9, 0x5C7E, 
	0x5CF7, 0x5E53, 0x5F1E, 0x613C, 0x625F, 0x628C, 0x62BB, 0x6437, 0x661A, 0x66CB, 0x67DB, 0x68EF, 0x692E, 0x698A, 0x69EE, 0x6C20, 
	0x6D81, 0x6DF0, 0x6EF2, 0x700B, 0x71CA, 0x73C5, 0x7521, 0x7527, 0x7606, 0x762E, 0x7712, 0x7718, 0x778B, 0x77AB, 0x77E4, 0x7973, 
	0x7A7C, 0x7C76, 0x7C78, 0x7D33, 0x7D9D, 0x7F59, 0x7F67, 0x8124, 0x814E, 0x8460, 0x84E1, 0x8518, 0x8593, 0x8704, 0x88D1, 0x89BE, 
	0x8A20, 0x8A37, 0x8A75, 0x8AD7, 0x8B85, 0x8C09, 0x90A5, 0x926E, 0x92E0, 0x9707, 0x9823, 0x99EA, 0x9B6B, 0x9BC5, 0x9BD3, 0x9BF5, 
	0x9C30, 0x9C3A, 0x9CB9, 0x9D62, 0x9EEE
	};
const TText16 KPinyin393[5] = {'s', 'h', 'e', 'n', 'g', };
const TInt charForPinyin393[67] = {
	0x58F0, 0x7701, 0x5269, 0x751F, 0x5347, 0x7EF3, 0x80DC, 0x76DB, 0x5723, 0x7525, 0x7272, 0x4E58, 0x665F, 0x6E11, 0x771A, 0x7B19, 
	0x5D4A, 0x4E1E, 0x4E57, 0x5057, 0x51BC, 0x5270, 0x52DD, 0x544F, 0x57A9, 0x58AD, 0x59D3, 0x5A0D, 0x5AB5, 0x61B4, 0x6598, 0x6607, 
	0x6660, 0x66FB, 0x67A1, 0x69BA, 0x6A73, 0x6B85, 0x6BB8, 0x6CE9, 0x6E3B, 0x6E66, 0x6FA0, 0x713A, 0x72CC, 0x73C4, 0x741E, 0x7538, 
	0x7AD4, 0x7BB5, 0x7E04, 0x7E69, 0x8056, 0x8072, 0x82FC, 0x8542, 0x8B5D, 0x8CB9, 0x8CF8, 0x924E, 0x935F, 0x9629, 0x965E, 0x9679, 
	0x9C66, 0x9D7F, 0x9F2A
	};
const TText16 KPinyin394[3] = {'s', 'h', 'i', };
const TInt charForPinyin394[242] = {
	0x662F, 0x4F7F, 0x5341, 0x65F6, 0x4E8B, 0x5BA4, 0x5E02, 0x77F3, 0x5E08, 0x8BD5, 0x53F2, 0x5F0F, 0x8BC6, 0x8671, 0x77E2, 0x62FE, 
	0x5C4E, 0x9A76, 0x59CB, 0x4F3C, 0x5618, 0x793A, 0x58EB, 0x4E16, 0x67FF, 0x5319, 0x62ED, 0x8A93, 0x901D, 0x52BF, 0x4EC0, 0x6B96, 
	0x5CD9, 0x55DC, 0x566C, 0x5931, 0x9002, 0x4ED5, 0x4F8D, 0x91CA, 0x9970, 0x6C0F, 0x72EE, 0x98DF, 0x6043, 0x8680, 0x89C6, 0x5B9E, 
	0x65BD, 0x6E7F, 0x8BD7, 0x5C38, 0x8C55, 0x83B3, 0x57D8, 0x94C8, 0x8210, 0x9CA5, 0x9CBA, 0x8D33, 0x8F7C, 0x84CD, 0x7B6E, 0x70BB, 
	0x8C25, 0x5F11, 0x917E, 0x87AB, 0x4E17, 0x4E68, 0x4E8A, 0x4F40, 0x4F66, 0x5158, 0x519F, 0x52E2, 0x534B, 0x5394, 0x53D3, 0x545E, 
	0x5469, 0x54B6, 0x5511, 0x5547, 0x5653, 0x57F6, 0x5824, 0x5852, 0x596D, 0x59FC, 0x5A9E, 0x5B15, 0x5B9F, 0x5BA9, 0x5BB2, 0x5BD4, 
	0x5BE6, 0x5BFA, 0x5C4D, 0x5CD5, 0x5D3C, 0x5D75, 0x5E2B, 0x5F12, 0x5F56, 0x5FA5, 0x5FD5, 0x5FEF, 0x6040, 0x60FF, 0x623A, 0x63D0, 
	0x63D3, 0x65AF, 0x65F9, 0x6630, 0x6642, 0x67BE, 0x67F9, 0x683B, 0x6974, 0x6981, 0x69AF, 0x6AA1, 0x6C41, 0x6CB6, 0x6D02, 0x6D49, 
	0x6DB2, 0x6E5C, 0x6E64, 0x6EA1, 0x6EAE, 0x6EBC, 0x6FA4, 0x6FA8, 0x6FD5, 0x70D2, 0x7176, 0x72E7, 0x72F6, 0x7345, 0x7461, 0x7564, 
	0x75D1, 0x7702, 0x770E, 0x7721, 0x7757, 0x793B, 0x794F, 0x79B5, 0x79F2, 0x7ACD, 0x7B36, 0x7B39, 0x7B5B, 0x7BB7, 0x7BD2, 0x7BE9, 
	0x7C2D, 0x7C42, 0x7C6D, 0x7D41, 0x7E79, 0x7ECE, 0x8006, 0x80A2, 0x80D1, 0x820D, 0x8213, 0x8479, 0x8492, 0x8494, 0x8755, 0x8768, 
	0x8906, 0x8937, 0x896B, 0x8979, 0x8996, 0x89E2, 0x8A11, 0x8A66, 0x8A69, 0x8ADF, 0x8AE1, 0x8B1A, 0x8B58, 0x8CB0, 0x8D6B, 0x8DE9, 
	0x8EFE, 0x8FBB, 0x9048, 0x905E, 0x9069, 0x9070, 0x907E, 0x90BF, 0x90DD, 0x91B3, 0x91C3, 0x91C8, 0x91CB, 0x91F6, 0x9230, 0x9242, 
	0x9243, 0x9247, 0x9248, 0x9250, 0x927D, 0x92B4, 0x9349, 0x9366, 0x93A9, 0x94CA, 0x94E9, 0x98E0, 0x98ED, 0x98FE, 0x9919, 0x991D, 
	0x9963, 0x996C, 0x99B6, 0x99DB, 0x9B73, 0x9B96, 0x9BF4, 0x9C18, 0x9C23, 0x9C24, 0x9CF2, 0x9CFE, 0x9DB3, 0x9E24, 0x9F2B, 0x9F2D, 
	0x9F5B, 0x9F65
	};
const TText16 KPinyin395[5] = {'s', 'h', 'i', 'k', 'e', };
const TInt charForPinyin395[1] = {
	0x5159
	};
const TText16 KPinyin396[5] = {'s', 'h', 'i', 'w', 'a', };
const TInt charForPinyin396[1] = {
	0x74E7
	};
const TText16 KPinyin397[4] = {'s', 'h', 'o', 'u', };
const TInt charForPinyin397[32] = {
	0x624B, 0x53D7, 0x6536, 0x9996, 0x5B88, 0x7626, 0x6388, 0x517D, 0x552E, 0x719F, 0x5BFF, 0x824F, 0x72E9, 0x7EF6, 0x53CE, 0x563C, 
	0x57A8, 0x58FD, 0x5900, 0x624C, 0x63B1, 0x654A, 0x6D9B, 0x6DAD, 0x6FE4, 0x7363, 0x7378, 0x75E9, 0x7DAC, 0x8184, 0x91BB, 0x93C9
	};
const TText16 KPinyin398[3] = {'s', 'h', 'u', };
const TInt charForPinyin398[147] = {
	0x4E66, 0x6811, 0x6570, 0x719F, 0x8F93, 0x68B3, 0x53D4, 0x5C5E, 0x675F, 0x672F, 0x8FF0, 0x8700, 0x9ECD, 0x9F20, 0x6DD1, 0x8D4E, 
	0x5B70, 0x852C, 0x758F, 0x620D, 0x7AD6, 0x5885, 0x5EB6, 0x85AF, 0x6F31, 0x6055, 0x67A2, 0x6691, 0x6B8A, 0x6292, 0x66D9, 0x7F72, 
	0x8212, 0x59DD, 0x6445, 0x79EB, 0x7EBE, 0x6CAD, 0x6BF9, 0x8167, 0x587E, 0x83FD, 0x6BB3, 0x6F8D, 0x500F, 0x4FB8, 0x4FC6, 0x4FDE, 
	0x4FF6, 0x5010, 0x5135, 0x516A, 0x54B0, 0x552E, 0x55FD, 0x5A36, 0x5A4C, 0x5B4E, 0x5C0C, 0x5C17, 0x5C6C, 0x5EBB, 0x5FEC, 0x6037, 
	0x6086, 0x6348, 0x6352, 0x6393, 0x63C4, 0x6504, 0x6578, 0x668F, 0x66F8, 0x672E, 0x6731, 0x6778, 0x677C, 0x67D5, 0x6A1E, 0x6A39, 
	0x6A7E, 0x6BFA, 0x6C00, 0x6D91, 0x6F44, 0x6F4F, 0x6F7B, 0x6FD6, 0x702D, 0x7102, 0x7479, 0x74B9, 0x758B, 0x758E, 0x7659, 0x7A0C, 
	0x7AEA, 0x7C54, 0x7CEC, 0x7D13, 0x7D35, 0x7D49, 0x7D80, 0x7FDB, 0x8357, 0x837C, 0x8481, 0x84A3, 0x85A5, 0x85AE, 0x85EA, 0x85F7, 
	0x866A, 0x8834, 0x883E, 0x8853, 0x88CB, 0x8961, 0x8969, 0x8B36, 0x8C4E, 0x8C6B, 0x8D16, 0x8DFE, 0x8E08, 0x8ED7, 0x8F38, 0x900F, 
	0x9103, 0x91CE, 0x9265, 0x9330, 0x93E3, 0x9432, 0x956F, 0x964E, 0x9664, 0x9683, 0x9B9B, 0x9C6A, 0x9C70, 0x9D68, 0x9D90, 0x9DF8, 
	0x9E00, 0x9E6C, 0x9F21
	};
const TText16 KPinyin399[4] = {'s', 'h', 'u', 'a', };
const TInt charForPinyin399[8] = {
	0x5237, 0x800D, 0x5530, 0x5506, 0x6DAE, 0x8A9C, 0x9009, 0x9078
	};
const TText16 KPinyin400[5] = {'s', 'h', 'u', 'a', 'i', };
const TInt charForPinyin400[12] = {
	0x6454, 0x7529, 0x7387, 0x5E05, 0x8870, 0x87C0, 0x535B, 0x5E25, 0x7D8F, 0x7E17, 0x7EE5, 0x7F1E
	};
const TText16 KPinyin401[5] = {'s', 'h', 'u', 'a', 'n', };
const TInt charForPinyin401[11] = {
	0x6813, 0x62F4, 0x95E9, 0x6DAE, 0x5C08, 0x6812, 0x69EB, 0x6C55, 0x8168, 0x8E39, 0x9582
	};
const TText16 KPinyin402[6] = {'s', 'h', 'u', 'a', 'n', 'g', };
const TInt charForPinyin402[27] = {
	0x53CC, 0x971C, 0x723D, 0x6CF7, 0x5B40, 0x50B1, 0x587D, 0x5B47, 0x6161, 0x6A09, 0x6B06, 0x6DD9, 0x6EDD, 0x6F3A, 0x7027, 0x7040, 
	0x7935, 0x7E14, 0x826D, 0x93EF, 0x96D9, 0x9A3B, 0x9A66, 0x9AA6, 0x9DDE, 0x9E18, 0x9E74
	};
const TText16 KPinyin403[4] = {'s', 'h', 'u', 'i', };
const TInt charForPinyin403[21] = {
	0x6C34, 0x8C01, 0x7761, 0x7A0E, 0x8BF4, 0x5A37, 0x5E28, 0x6329, 0x635D, 0x6C35, 0x6C3A, 0x6D97, 0x6D9A, 0x7971, 0x7A05, 0x813D, 
	0x88DE, 0x8AAA, 0x8AAC, 0x8AB0, 0x9596
	};
const TText16 KPinyin404[4] = {'s', 'h', 'u', 'n', };
const TInt charForPinyin404[18] = {
	0x987A, 0x542E, 0x77AC, 0x821C, 0x4FCA, 0x5DDB, 0x5DE1, 0x5EF5, 0x6042, 0x696F, 0x6A53, 0x7734, 0x779A, 0x77A4, 0x8563, 0x8F34, 
	0x9806, 0x9B0A
	};
const TText16 KPinyin405[4] = {'s', 'h', 'u', 'o', };
const TInt charForPinyin405[33] = {
	0x8BF4, 0x6570, 0x7855, 0x70C1, 0x6714, 0x6420, 0x5981, 0x69CA, 0x84B4, 0x94C4, 0x54FE, 0x55CD, 0x55FD, 0x6B36, 0x6C4B, 0x6D2C, 
	0x6EAF, 0x6FEF, 0x71FF, 0x720D, 0x7361, 0x7642, 0x77DF, 0x78A9, 0x7BBE, 0x836F, 0x8437, 0x85E5, 0x8AAA, 0x8AAC, 0x928F, 0x9399, 
	0x9460
	};
const TText16 KPinyin406[3] = {'s', 'h', 'w', };
const TInt charForPinyin406[1] = {
	0x6298
	};
const TText16 KPinyin407[2] = {'s', 'i', };
const TInt charForPinyin407[121] = {
	0x56DB, 0x6B7B, 0x4E1D, 0x6495, 0x4F3C, 0x79C1, 0x5636, 0x601D, 0x5BFA, 0x53F8, 0x65AF, 0x98DF, 0x4F3A, 0x5395, 0x8086, 0x9972, 
	0x55E3, 0x5DF3, 0x801C, 0x9A77, 0x5155, 0x86F3, 0x53AE, 0x6C5C, 0x9536, 0x6CD7, 0x7B25, 0x549D, 0x9E36, 0x59D2, 0x53B6, 0x7F0C, 
	0x7940, 0x6F8C, 0x4FDF, 0x4E96, 0x4EE5, 0x4F40, 0x4F41, 0x4FA1, 0x4FEC, 0x5072, 0x5082, 0x5129, 0x51D8, 0x53A0, 0x53F0, 0x565D, 
	0x5A30, 0x5AA4, 0x5B60, 0x5EDD, 0x5F99, 0x6056, 0x6122, 0x676B, 0x6790, 0x67B1, 0x67F6, 0x68A9, 0x6952, 0x69B9, 0x6CC0, 0x6CE4, 
	0x6D0D, 0x6D98, 0x7003, 0x71CD, 0x726D, 0x78C3, 0x7960, 0x7997, 0x79A0, 0x79A9, 0x7AE2, 0x7C1B, 0x7CF8, 0x7CF9, 0x7D72, 0x7DE6, 
	0x7E9F, 0x7F52, 0x7F73, 0x8082, 0x8084, 0x83E5, 0x856C, 0x857C, 0x8652, 0x8724, 0x8784, 0x8794, 0x87D6, 0x87F4, 0x8997, 0x8B15, 
	0x8C84, 0x9018, 0x91F2, 0x9236, 0x923B, 0x9270, 0x9289, 0x92AF, 0x92D6, 0x9376, 0x9401, 0x96C9, 0x98B8, 0x98D4, 0x98E4, 0x98F4, 
	0x98FC, 0x9974, 0x99DF, 0x9A03, 0x9A26, 0x9DC9, 0x9DE5, 0x9E97, 0x9F36
	};
const TText16 KPinyin408[2] = {'s', 'o', };
const TInt charForPinyin408[1] = {
	0x87A6
	};
const TText16 KPinyin409[3] = {'s', 'o', 'l', };
const TInt charForPinyin409[1] = {
	0x4E7A
	};
const TText16 KPinyin410[4] = {'s', 'o', 'n', 'g', };
const TInt charForPinyin410[53] = {
	0x9001, 0x677E, 0x8038, 0x5B8B, 0x9882, 0x8BF5, 0x6002, 0x8BBC, 0x7AE6, 0x83D8, 0x6DDE, 0x609A, 0x5D69, 0x51C7, 0x5D27, 0x5FEA, 
	0x502F, 0x50B1, 0x5405, 0x5A00, 0x5D77, 0x5EBA, 0x612F, 0x616B, 0x6181, 0x61BD, 0x6352, 0x6374, 0x63D4, 0x6457, 0x6780, 0x67A9, 
	0x67D7, 0x68A5, 0x68C7, 0x6964, 0x6AA7, 0x6F0E, 0x6FCD, 0x7879, 0x8073, 0x84EF, 0x8634, 0x8719, 0x8A1F, 0x8AA6, 0x9376, 0x93B9, 
	0x9536, 0x980C, 0x9938, 0x99F7, 0x9B06
	};
const TText16 KPinyin411[3] = {'s', 'o', 'u', };
const TInt charForPinyin411[46] = {
	0x8258, 0x641C, 0x64DE, 0x55FD, 0x55FE, 0x55D6, 0x98D5, 0x53DF, 0x85AE, 0x953C, 0x998A, 0x778D, 0x6EB2, 0x878B, 0x5081, 0x51C1, 
	0x53DC, 0x5EC0, 0x5ECB, 0x6352, 0x635C, 0x6457, 0x64A8, 0x64FB, 0x6555, 0x65CF, 0x68F7, 0x6AE2, 0x6B36, 0x6D91, 0x6F5A, 0x7340, 
	0x7636, 0x7C54, 0x8490, 0x84C3, 0x85EA, 0x8B0F, 0x910B, 0x9199, 0x93AA, 0x93C9, 0x98BC, 0x98BE, 0x993F, 0x9A2A
	};
const TText16 KPinyin412[2] = {'s', 'u', };
const TInt charForPinyin412[82] = {
	0x7D20, 0x901F, 0x8BC9, 0x5851, 0x5BBF, 0x4FD7, 0x82CF, 0x8083, 0x7C9F, 0x9165, 0x7F29, 0x6EAF, 0x50F3, 0x612B, 0x7C0C, 0x89EB, 
	0x7A23, 0x5919, 0x55C9, 0x8C21, 0x850C, 0x6D91, 0x5083, 0x50C1, 0x5379, 0x55D6, 0x56CC, 0x5731, 0x5732, 0x57E3, 0x5850, 0x5ACA, 
	0x612C, 0x619F, 0x637D, 0x642C, 0x6475, 0x6880, 0x68F4, 0x69A1, 0x6A0E, 0x6A15, 0x6A5A, 0x6AEF, 0x6B90, 0x6CDD, 0x6D2C, 0x6EB8, 
	0x6F5A, 0x6F65, 0x738A, 0x73DF, 0x749B, 0x7526, 0x78BF, 0x7A21, 0x7A24, 0x7A4C, 0x7AA3, 0x7C9B, 0x7E24, 0x7E2E, 0x8085, 0x8186, 
	0x83A4, 0x85D7, 0x8607, 0x8613, 0x8A34, 0x8B16, 0x8D9A, 0x8E5C, 0x9061, 0x906C, 0x92C9, 0x9917, 0x9A4C, 0x9A95, 0x9BC2, 0x9C50, 
	0x9DEB, 0x9E54
	};
const TText16 KPinyin413[4] = {'s', 'u', 'a', 'n', };
const TInt charForPinyin413[13] = {
	0x9178, 0x7B97, 0x849C, 0x72FB, 0x5334, 0x64B0, 0x75E0, 0x7958, 0x7B07, 0x7B6D, 0x7BF9, 0x9009, 0x9078
	};
const TText16 KPinyin414[3] = {'s', 'u', 'i', };
const TInt charForPinyin414[81] = {
	0x5C81, 0x968F, 0x788E, 0x867D, 0x7A57, 0x9042, 0x5C3F, 0x968B, 0x9AD3, 0x7EE5, 0x96A7, 0x795F, 0x772D, 0x8C07, 0x6FC9, 0x9083, 
	0x71E7, 0x837D, 0x7762, 0x4E97, 0x5020, 0x54F8, 0x55FA, 0x57E3, 0x590A, 0x5A1E, 0x5B18, 0x5D57, 0x633C, 0x65DE, 0x6A96, 0x6B72, 
	0x6B73, 0x6BF8, 0x6D7D, 0x6ED6, 0x6FBB, 0x7021, 0x716B, 0x71A3, 0x74B2, 0x74CD, 0x775F, 0x7815, 0x79AD, 0x7A42, 0x7A5F, 0x7C11, 
	0x7C8B, 0x7CB9, 0x7D8F, 0x7E17, 0x7E40, 0x7E50, 0x7E78, 0x7F1E, 0x813A, 0x81B8, 0x8295, 0x837E, 0x838E, 0x8470, 0x84D1, 0x895A, 
	0x8AB6, 0x8B62, 0x8CE5, 0x9040, 0x9057, 0x907A, 0x93F8, 0x9406, 0x9429, 0x964F, 0x968A, 0x96A8, 0x96D6, 0x9743, 0x9796, 0x97E2, 
	0x9AC4
	};
const TText16 KPinyin415[3] = {'s', 'u', 'n', };
const TInt charForPinyin415[31] = {
	0x5B59, 0x635F, 0x7B0B, 0x69AB, 0x836A, 0x98E7, 0x72F2, 0x96BC, 0x55B0, 0x5B6B, 0x5DFA, 0x627B, 0x640D, 0x640E, 0x644C, 0x6811, 
	0x69C2, 0x6F60, 0x733B, 0x7543, 0x7B4D, 0x7BB0, 0x7C28, 0x84C0, 0x8575, 0x859E, 0x8DE3, 0x93A8, 0x98F1, 0x9910, 0x9DBD
	};
const TText16 KPinyin416[3] = {'s', 'u', 'o', };
const TInt charForPinyin416[60] = {
	0x6240, 0x7F29, 0x9501, 0x7410, 0x7D22, 0x68AD, 0x84D1, 0x838E, 0x5506, 0x6332, 0x7743, 0x55CD, 0x5522, 0x686B, 0x55E6, 0x5A11, 
	0x7FA7, 0x4E9B, 0x509E, 0x55E9, 0x5AC5, 0x5C81, 0x5D57, 0x60E2, 0x6284, 0x6331, 0x644D, 0x669B, 0x6B72, 0x6C99, 0x6E91, 0x6EB9, 
	0x727A, 0x72A7, 0x737B, 0x7411, 0x7463, 0x7485, 0x7C11, 0x7C14, 0x7E12, 0x7E2E, 0x838F, 0x8470, 0x8736, 0x8870, 0x8928, 0x8D96, 
	0x9021, 0x9024, 0x9388, 0x938D, 0x9396, 0x93BB, 0x93C1, 0x970D, 0x9743, 0x9AFF, 0x9B66, 0x9BBB
	};
const TText16 KPinyin417[2] = {'t', 'a', };
const TInt charForPinyin417[73] = {
	0x4ED6, 0x5979, 0x5B83, 0x8E0F, 0x5854, 0x584C, 0x62D3, 0x736D, 0x631E, 0x8E4B, 0x6EBB, 0x8DBF, 0x9CCE, 0x6C93, 0x69BB, 0x6F2F, 
	0x9062, 0x94CA, 0x95FC, 0x55D2, 0x4FA4, 0x509D, 0x547E, 0x549C, 0x5683, 0x56BA, 0x5896, 0x592A, 0x5D09, 0x6428, 0x642D, 0x6498, 
	0x64BB, 0x6999, 0x6BFE, 0x6DBE, 0x6E7F, 0x6E9A, 0x6FBE, 0x6FCC, 0x6FD5, 0x7260, 0x72E7, 0x737A, 0x7942, 0x79A2, 0x8345, 0x891F, 
	0x8ABB, 0x8B76, 0x8E79, 0x8EA2, 0x8FBE, 0x8FCF, 0x8FD6, 0x9039, 0x9054, 0x905D, 0x9248, 0x9314, 0x9389, 0x9391, 0x95D2, 0x95DF, 
	0x95E5, 0x9618, 0x9788, 0x9791, 0x979C, 0x97B3, 0x97C3, 0x9B99, 0x9C28
	};
const TText16 KPinyin418[3] = {'t', 'a', 'e', };
const TInt charForPinyin418[2] = {
	0x5788, 0x8968
	};
const TText16 KPinyin419[3] = {'t', 'a', 'i', };
const TInt charForPinyin419[57] = {
	0x592A, 0x62AC, 0x53F0, 0x6001, 0x80CE, 0x82D4, 0x6CF0, 0x915E, 0x6C70, 0x70B1, 0x80BD, 0x8DC6, 0x5454, 0x9C90, 0x949B, 0x85B9, 
	0x90B0, 0x9A80, 0x5113, 0x51AD, 0x548D, 0x56FC, 0x576E, 0x5927, 0x5933, 0x5964, 0x5B2F, 0x5B61, 0x5FD5, 0x5FF2, 0x614B, 0x64E1, 
	0x6584, 0x65F2, 0x67B1, 0x6AAF, 0x6E99, 0x6F26, 0x70B2, 0x71E4, 0x73C6, 0x7B88, 0x7C49, 0x7C8F, 0x80FD, 0x81FA, 0x8226, 0x83ED, 
	0x8A52, 0x8BD2, 0x8EDA, 0x91D0, 0x9226, 0x9236, 0x98B1, 0x99D8, 0x9B90
	};
const TText16 KPinyin420[3] = {'t', 'a', 'n', };
const TInt charForPinyin420[104] = {
	0x8C08, 0x53F9, 0x63A2, 0x6EE9, 0x5F39, 0x78B3, 0x644A, 0x6F6D, 0x8D2A, 0x575B, 0x75F0, 0x6BEF, 0x5766, 0x70AD, 0x762B, 0x8C2D, 
	0x574D, 0x6A80, 0x8892, 0x94BD, 0x90EF, 0x9561, 0x952C, 0x8983, 0x6FB9, 0x6619, 0x5FD0, 0x4F46, 0x5013, 0x509D, 0x50CB, 0x5103, 
	0x5574, 0x55FF, 0x5606, 0x563D, 0x563E, 0x57EE, 0x58B0, 0x58B5, 0x58C7, 0x58DC, 0x5A52, 0x5F3E, 0x5F48, 0x6039, 0x60D4, 0x619B, 
	0x61B3, 0x61BB, 0x63B8, 0x64A2, 0x64A3, 0x64F9, 0x6524, 0x66BA, 0x66C7, 0x6983, 0x6A5D, 0x6B4E, 0x6C88, 0x6DE1, 0x6E5B, 0x6E60, 
	0x6F22, 0x6F6C, 0x7058, 0x708E, 0x74AE, 0x75D1, 0x7649, 0x7671, 0x79AA, 0x7DC2, 0x7E75, 0x7F48, 0x7F4E, 0x80C6, 0x8211, 0x8214, 
	0x8215, 0x8368, 0x83FC, 0x8541, 0x8548, 0x85EB, 0x88E7, 0x8962, 0x8AC7, 0x8B5A, 0x8B60, 0x8C9A, 0x8CAA, 0x8CE7, 0x8D55, 0x9188, 
	0x9193, 0x91B0, 0x926D, 0x931F, 0x9843, 0x9924, 0x9DE4, 0x9EEE
	};
const TText16 KPinyin421[4] = {'t', 'a', 'n', 'g', };
const TInt charForPinyin421[91] = {
	0x8EBA, 0x8D9F, 0x5802, 0x7CD6, 0x6C64, 0x5858, 0x70EB, 0x5018, 0x6DCC, 0x5510, 0x642A, 0x68E0, 0x819B, 0x87B3, 0x6A18, 0x7FB0, 
	0x91A3, 0x746D, 0x9557, 0x50A5, 0x9967, 0x6E8F, 0x8025, 0x5E11, 0x94F4, 0x8797, 0x4F16, 0x5052, 0x508F, 0x513B, 0x528F, 0x557A, 
	0x5621, 0x5763, 0x5D63, 0x5F39, 0x6113, 0x6203, 0x6269, 0x6465, 0x64F4, 0x6529, 0x66ED, 0x69B6, 0x6A56, 0x6B13, 0x6E6F, 0x6F1F, 
	0x6F21, 0x717B, 0x71D9, 0x7223, 0x77D8, 0x78C4, 0x799F, 0x7BD6, 0x7C1C, 0x7CC3, 0x7CDB, 0x8185, 0x8361, 0x84CE, 0x8569, 0x859A, 
	0x862F, 0x876A, 0x8D6F, 0x8E3C, 0x8E5A, 0x903F, 0x910C, 0x9395, 0x93B2, 0x93DC, 0x940B, 0x943A, 0x9482, 0x94DB, 0x954B, 0x95B6, 
	0x95DB, 0x95E3, 0x960A, 0x969A, 0x97BA, 0x9933, 0x9939, 0x9944, 0x9DB6, 0x9EE8, 0x9F1E
	};
const TText16 KPinyin422[3] = {'t', 'a', 'o', };
const TInt charForPinyin422[68] = {
	0x5957, 0x638F, 0x9003, 0x6843, 0x8BA8, 0x6DD8, 0x6D9B, 0x6ED4, 0x9676, 0x7EE6, 0x8404, 0x9F17, 0x6D2E, 0x7118, 0x5555, 0x9955, 
	0x97EC, 0x53E8, 0x4ED0, 0x530B, 0x54B7, 0x5932, 0x5935, 0x59DA, 0x5ACD, 0x5E4D, 0x5F22, 0x6146, 0x62AD, 0x6311, 0x642F, 0x68BC, 
	0x69C4, 0x6AAE, 0x6DAD, 0x6FE4, 0x71FE, 0x746B, 0x7979, 0x7B79, 0x7C4C, 0x7D5B, 0x7DA2, 0x7DAF, 0x7E1A, 0x7E27, 0x7EF8, 0x7EF9, 
	0x872A, 0x88EA, 0x8A0E, 0x8A5C, 0x8B1F, 0x8DF3, 0x8F41, 0x8FEF, 0x9184, 0x92FE, 0x932D, 0x9780, 0x9789, 0x97B1, 0x97DC, 0x982B, 
	0x98F8, 0x9940, 0x99E3, 0x9A0A
	};
const TText16 KPinyin423[3] = {'t', 'a', 'p', };
const TInt charForPinyin423[1] = {
	0x7553
	};
const TText16 KPinyin424[2] = {'t', 'e', };
const TInt charForPinyin424[17] = {
	0x7279, 0x615D, 0x94FD, 0x5FD1, 0x5FD2, 0x533F, 0x5F0F, 0x7286, 0x8077, 0x8126, 0x86AE, 0x87A3, 0x87D8, 0x8CA3, 0x8CB8, 0x8D37, 
	0x92F1
	};
const TText16 KPinyin425[3] = {'t', 'e', 'i', };
const TInt charForPinyin425[1] = {
	0x5FD2
	};
const TText16 KPinyin426[4] = {'t', 'e', 'n', 'g', };
const TInt charForPinyin426[24] = {
	0x75BC, 0x817E, 0x85E4, 0x8A8A, 0x6ED5, 0x50DC, 0x512F, 0x5E50, 0x6F1B, 0x75CB, 0x7C50, 0x7C58, 0x7E22, 0x81AF, 0x8645, 0x87A3, 
	0x8B04, 0x9086, 0x972F, 0x99E6, 0x9A30, 0x9A63, 0x9C27, 0x9F1F
	};
const TText16 KPinyin427[3] = {'t', 'e', 'o', };
const TInt charForPinyin427[1] = {
	0x551E
	};
const TText16 KPinyin428[4] = {'t', 'e', 'u', 'l', };
const TInt charForPinyin428[1] = {
	0x6730
	};
const TText16 KPinyin429[4] = {'t', 'e', 'u', 'n', };
const TInt charForPinyin429[1] = {
	0x6729
	};
const TText16 KPinyin430[2] = {'t', 'i', };
const TInt charForPinyin430[126] = {
	0x63D0, 0x66FF, 0x4F53, 0x9898, 0x8E22, 0x8E44, 0x5243, 0x5254, 0x68AF, 0x9511, 0x557C, 0x6D95, 0x568F, 0x60D5, 0x5C49, 0x918D, 
	0x9E48, 0x7EE8, 0x7F07, 0x501C, 0x88FC, 0x9016, 0x8351, 0x608C, 0x4FF6, 0x504D, 0x5397, 0x5551, 0x55C1, 0x5694, 0x5943, 0x59FC, 
	0x5A82, 0x5A9E, 0x5C5C, 0x5D39, 0x5D5C, 0x5F1A, 0x5F1F, 0x5FA5, 0x5FB2, 0x6090, 0x60D6, 0x60FF, 0x623B, 0x6298, 0x632E, 0x63A6, 
	0x63E5, 0x64FF, 0x662F, 0x684B, 0x68E3, 0x6974, 0x6B52, 0x6BA2, 0x6D1F, 0x6E27, 0x6F3D, 0x72C4, 0x73F6, 0x7445, 0x74CB, 0x7747, 
	0x78AE, 0x78C3, 0x79B5, 0x7A0A, 0x7A49, 0x7C4A, 0x7D88, 0x7DF9, 0x7F64, 0x8086, 0x82D0, 0x855B, 0x8599, 0x8652, 0x876D, 0x87EC, 
	0x8879, 0x8905, 0x8906, 0x8A46, 0x8AE6, 0x8B15, 0x8BCB, 0x8C1B, 0x8DA7, 0x8DAF, 0x8DC3, 0x8E36, 0x8E4F, 0x8E8D, 0x8EB0, 0x8EC6, 
	0x8FBE, 0x8FCF, 0x8FD6, 0x9037, 0x9046, 0x9069, 0x92BB, 0x932B, 0x9357, 0x941F, 0x9521, 0x984C, 0x9A20, 0x9AB5, 0x9AD4, 0x9AE2, 
	0x9AF0, 0x9B00, 0x9B04, 0x9BA7, 0x9BB7, 0x9BF7, 0x9CC0, 0x9D3A, 0x9D5C, 0x9D97, 0x9D99, 0x9DC8, 0x9DC9, 0x9DE4
	};
const TText16 KPinyin431[4] = {'t', 'i', 'a', 'n', };
const TInt charForPinyin431[88] = {
	0x5929, 0x7530, 0x6DFB, 0x586B, 0x751C, 0x8214, 0x606C, 0x8146, 0x4F43, 0x63AD, 0x94BF, 0x9617, 0x5FDD, 0x6B84, 0x754B, 0x500E, 
	0x5172, 0x5178, 0x541E, 0x5451, 0x553A, 0x55D4, 0x5861, 0x5A17, 0x5A56, 0x5BD8, 0x5C47, 0x60BF, 0x6375, 0x6437, 0x666A, 0x681D, 
	0x6CBA, 0x6CBE, 0x6DDF, 0x6E49, 0x6EC7, 0x7420, 0x7471, 0x74B3, 0x751B, 0x7538, 0x753A, 0x7547, 0x7551, 0x7560, 0x75F6, 0x76F7, 
	0x7753, 0x777C, 0x778B, 0x78B5, 0x78CC, 0x7AB4, 0x7D3E, 0x7DC2, 0x80CB, 0x8211, 0x821A, 0x82EB, 0x83FE, 0x8695, 0x86BA, 0x89A5, 
	0x89CD, 0x8CDF, 0x915F, 0x923F, 0x929B, 0x932A, 0x9369, 0x93AD, 0x93AE, 0x94E6, 0x9518, 0x9547, 0x95D0, 0x9754, 0x975D, 0x9766, 
	0x985A, 0x985B, 0x98A0, 0x9902, 0x9D2B, 0x9DC6, 0x9DCF, 0x9EC7
	};
const TText16 KPinyin432[4] = {'t', 'i', 'a', 'o', };
const TInt charForPinyin432[65] = {
	0x6761, 0x8DF3, 0x6311, 0x8C03, 0x8FE2, 0x773A, 0x9F86, 0x7B24, 0x7967, 0x8729, 0x9AEB, 0x4F7B, 0x7A95, 0x9CA6, 0x82D5, 0x7C9C, 
	0x5135, 0x54B7, 0x5541, 0x59DA, 0x5B25, 0x5BA8, 0x5CA7, 0x5CB9, 0x5EA3, 0x604C, 0x65A2, 0x65EB, 0x6640, 0x6713, 0x6737, 0x6843, 
	0x689D, 0x6A24, 0x7952, 0x7A20, 0x7AB1, 0x7CF6, 0x7D69, 0x804E, 0x8101, 0x8129, 0x825E, 0x8280, 0x8414, 0x84DA, 0x84E7, 0x84E8, 
	0x87A9, 0x899C, 0x8A82, 0x8ABF, 0x8D85, 0x8D92, 0x8DA0, 0x8E14, 0x929A, 0x92DA, 0x93A5, 0x94EB, 0x9797, 0x982B, 0x9BC8, 0x9C37, 
	0x9F60
	};
const TText16 KPinyin433[3] = {'t', 'i', 'e', };
const TInt charForPinyin433[25] = {
	0x94C1, 0x8D34, 0x5E16, 0x841C, 0x992E, 0x50E3, 0x5360, 0x546B, 0x6017, 0x60F5, 0x8051, 0x86C8, 0x8776, 0x8CBC, 0x8DD5, 0x9244, 
	0x9246, 0x9295, 0x92E8, 0x9421, 0x9435, 0x9507, 0x98FB, 0x9A56, 0x9D29
	};
const TText16 KPinyin434[4] = {'t', 'i', 'n', 'g', };
const TInt charForPinyin434[60] = {
	0x542C, 0x505C, 0x633A, 0x5385, 0x4EAD, 0x8247, 0x5EAD, 0x5EF7, 0x70C3, 0x6C40, 0x753A, 0x839B, 0x94E4, 0x8476, 0x5A77, 0x8713, 
	0x6883, 0x9706, 0x4FB1, 0x4FB9, 0x539B, 0x5722, 0x5960, 0x5975, 0x5A17, 0x5D49, 0x5E81, 0x5E8D, 0x5EF0, 0x5EF3, 0x5FCA, 0x686F, 
	0x695F, 0x69B3, 0x6D8F, 0x6E1F, 0x6FCE, 0x70F4, 0x70F6, 0x73F5, 0x73FD, 0x7B73, 0x7D8E, 0x8013, 0x8064, 0x8074, 0x807C, 0x807D, 
	0x8121, 0x827C, 0x874F, 0x8A94, 0x8AEA, 0x9092, 0x92CC, 0x95AE, 0x9793, 0x9832, 0x988B, 0x9F2E
	};
const TText16 KPinyin435[3] = {'t', 'i', 'u', };
const TInt charForPinyin435[1] = {
	0x711E
	};
const TText16 KPinyin436[3] = {'t', 'o', 'l', };
const TInt charForPinyin436[1] = {
	0x4E6D
	};
const TText16 KPinyin437[3] = {'t', 'o', 'n', };
const TInt charForPinyin437[1] = {
	0x7364
	};
const TText16 KPinyin438[4] = {'t', 'o', 'n', 'g', };
const TInt charForPinyin438[80] = {
	0x540C, 0x901A, 0x75DB, 0x94DC, 0x6876, 0x7B52, 0x6345, 0x7EDF, 0x7AE5, 0x5F64, 0x6850, 0x77B3, 0x606B, 0x4F97, 0x916E, 0x6F7C, 
	0x833C, 0x4EDD, 0x783C, 0x5CD2, 0x6078, 0x4F5F, 0x55F5, 0x578C, 0x5045, 0x50EE, 0x528F, 0x52ED, 0x54C3, 0x56F2, 0x5CC2, 0x5CDD, 
	0x5E9D, 0x607F, 0x615F, 0x6185, 0x664D, 0x66C8, 0x6723, 0x6A0B, 0x6A66, 0x6C03, 0x6D1E, 0x6D75, 0x6E69, 0x70B5, 0x70D4, 0x71A5, 
	0x71D1, 0x721E, 0x729D, 0x72EA, 0x735E, 0x75CC, 0x772E, 0x7850, 0x7867, 0x79F1, 0x7A5C, 0x7B69, 0x7CA1, 0x7D67, 0x7D71, 0x7D82, 
	0x81A7, 0x825F, 0x84EA, 0x8692, 0x873C, 0x87F2, 0x8855, 0x8A77, 0x8D68, 0x91CD, 0x9256, 0x9275, 0x9285, 0x9907, 0x9BA6, 0x9C96
	};
const TText16 KPinyin439[3] = {'t', 'o', 'u', };
const TInt charForPinyin439[32] = {
	0x5934, 0x5077, 0x900F, 0x6295, 0x94AD, 0x9AB0, 0x4EA0, 0x5078, 0x57F1, 0x59B5, 0x5A7E, 0x5AAE, 0x6109, 0x6568, 0x65A2, 0x6B95, 
	0x7D0F, 0x7D89, 0x7DF0, 0x7EE3, 0x8623, 0x8915, 0x8AED, 0x8AF3, 0x8C15, 0x8C19, 0x9017, 0x92C0, 0x936E, 0x982D, 0x98F3, 0x9EC8
	};
const TText16 KPinyin440[2] = {'t', 'u', };
const TInt charForPinyin440[77] = {
	0x571F, 0x56FE, 0x5154, 0x6D82, 0x5410, 0x79C3, 0x7A81, 0x5F92, 0x51F8, 0x9014, 0x5C60, 0x9174, 0x837C, 0x948D, 0x83DF, 0x580D, 
	0x4F59, 0x514E, 0x51C3, 0x550B, 0x555A, 0x56F3, 0x5716, 0x5717, 0x5721, 0x5817, 0x5857, 0x58BF, 0x5B8A, 0x5CF9, 0x5D5E, 0x5D80, 
	0x5EA9, 0x5EDC, 0x6022, 0x6087, 0x6348, 0x6378, 0x63EC, 0x6455, 0x6581, 0x675C, 0x688C, 0x6AA1, 0x6C62, 0x6D8B, 0x6E65, 0x6F73, 
	0x7479, 0x75DC, 0x760F, 0x79BF, 0x7A0C, 0x7B61, 0x815E, 0x816F, 0x83B5, 0x8456, 0x84A4, 0x8D83, 0x8DCC, 0x8DFF, 0x8FCC, 0x91F7, 
	0x922F, 0x92C0, 0x92F5, 0x934E, 0x999F, 0x99FC, 0x9D4C, 0x9D5A, 0x9D75, 0x9D9F, 0x9DCB, 0x9DF5, 0x9F35
	};
const TText16 KPinyin441[4] = {'t', 'u', 'a', 'n', };
const TInt charForPinyin441[39] = {
	0x56E2, 0x6E4D, 0x7583, 0x629F, 0x5F56, 0x526C, 0x5278, 0x56E3, 0x5715, 0x5718, 0x587C, 0x58A5, 0x5AE5, 0x5C08, 0x6171, 0x6476, 
	0x6566, 0x69EB, 0x6AB2, 0x6E6A, 0x6F19, 0x7153, 0x732F, 0x757D, 0x78DA, 0x7A05, 0x7A0E, 0x7BFF, 0x7CF0, 0x84F4, 0x890D, 0x8916, 
	0x8C92, 0x93C4, 0x9C44, 0x9D89, 0x9DD2, 0x9DFB, 0x9E51
	};
const TText16 KPinyin442[3] = {'t', 'u', 'i', };
const TInt charForPinyin442[45] = {
	0x817F, 0x63A8, 0x9000, 0x892A, 0x9893, 0x8715, 0x717A, 0x5FD2, 0x4FBB, 0x4FC0, 0x50D3, 0x554D, 0x58A4, 0x5A27, 0x5C35, 0x5F1A, 
	0x5F1F, 0x6022, 0x6A54, 0x7A05, 0x7A0E, 0x7A68, 0x8049, 0x812B, 0x812E, 0x8131, 0x84F7, 0x85EC, 0x8608, 0x86FB, 0x8B09, 0x8B89, 
	0x8E46, 0x8E6A, 0x8FFD, 0x96A4, 0x9839, 0x983A, 0x983D, 0x994B, 0x9988, 0x99FE, 0x9A29, 0x9ABD, 0x9B4B
	};
const TText16 KPinyin443[3] = {'t', 'u', 'n', };
const TInt charForPinyin443[44] = {
	0x541E, 0x5C6F, 0x892A, 0x81C0, 0x56E4, 0x6C3D, 0x9968, 0x8C5A, 0x66BE, 0x5428, 0x5434, 0x5451, 0x554D, 0x564B, 0x5749, 0x5E89, 
	0x5FF3, 0x619E, 0x65FD, 0x671C, 0x6C6D, 0x6C8C, 0x6D92, 0x7096, 0x711E, 0x71C9, 0x757D, 0x7A80, 0x7D14, 0x7EAF, 0x80AB, 0x81AF, 
	0x81CB, 0x829A, 0x8733, 0x8C58, 0x8ED8, 0x9010, 0x932A, 0x9715, 0x98E9, 0x9B68, 0x9C80, 0x9ED7
	};
const TText16 KPinyin444[3] = {'t', 'u', 'o', };
const TInt charForPinyin444[113] = {
	0x62D6, 0x8131, 0x6258, 0x59A5, 0x9A6E, 0x62D3, 0x9A7C, 0x692D, 0x553E, 0x9E35, 0x9640, 0x9B44, 0x6A50, 0x67DD, 0x8DCE, 0x4E47, 
	0x5768, 0x4F57, 0x5EB9, 0x9161, 0x67C1, 0x9F0D, 0x6CB1, 0x7BA8, 0x7823, 0x4ED6, 0x4EDB, 0x4F82, 0x4FBB, 0x5483, 0x5574, 0x563D, 
	0x5836, 0x5AA0, 0x5AF7, 0x5B83, 0x5CAE, 0x5F75, 0x60F0, 0x6261, 0x62D5, 0x6329, 0x635D, 0x64B1, 0x6754, 0x675D, 0x68C1, 0x6955, 
	0x69D6, 0x6A62, 0x6BE4, 0x6BFB, 0x6C51, 0x6C60, 0x6CB0, 0x6DB6, 0x7260, 0x72CF, 0x7824, 0x78A2, 0x78DA, 0x7A05, 0x7A0E, 0x7C5C, 
	0x7D3D, 0x812B, 0x8203, 0x8204, 0x838C, 0x841A, 0x8600, 0x86C7, 0x87FA, 0x8889, 0x8898, 0x88A5, 0x8A11, 0x8A17, 0x8A51, 0x8AAA, 
	0x8AAC, 0x8BAC, 0x8BF4, 0x8DC5, 0x8E3B, 0x8EC3, 0x8FC6, 0x8FE4, 0x8FF1, 0x9248, 0x92D6, 0x94CA, 0x9624, 0x9641, 0x968B, 0x98E5, 
	0x9966, 0x99B1, 0x99B2, 0x99C4, 0x99DD, 0x99DE, 0x9A28, 0x9A52, 0x9A5D, 0x9B60, 0x9B80, 0x9C16, 0x9C53, 0x9D15, 0x9D4E, 0x9F09, 
	0x9F27
	};
const TText16 KPinyin445[2] = {'u', 'u', };
const TInt charForPinyin445[39] = {
	0x5C57, 0x5F9A, 0x658F, 0x66E2, 0x6711, 0x685B, 0x6B5A, 0x6BDC, 0x6BDD, 0x6BEE, 0x6D1C, 0x70EA, 0x7111, 0x713D, 0x71DE, 0x7677, 
	0x76BC, 0x794D, 0x7A25, 0x8002, 0x8041, 0x8063, 0x8248, 0x8312, 0x848A, 0x84DE, 0x85D4, 0x8672, 0x874A, 0x88B0, 0x8D18, 0x8EBC, 
	0x8FAA, 0x9342, 0x93BC, 0x9422, 0x95E7, 0x973B, 0x9D91
	};
const TText16 KPinyin446[2] = {'w', 'a', };
const TInt charForPinyin446[50] = {
	0x6316, 0x74E6, 0x86D9, 0x54C7, 0x5A03, 0x6D3C, 0x51F9, 0x889C, 0x4F64, 0x5A32, 0x817D, 0x52B8, 0x5493, 0x5532, 0x5558, 0x55D7, 
	0x55E2, 0x59FD, 0x5AA7, 0x5C72, 0x5E13, 0x5F8D, 0x6432, 0x6528, 0x6C59, 0x6C5A, 0x6C61, 0x6E9B, 0x6F25, 0x74F2, 0x7556, 0x7819, 
	0x7A75, 0x7A8A, 0x7A90, 0x7AAA, 0x8049, 0x8183, 0x896A, 0x8B41, 0x90B7, 0x977A, 0x978B, 0x97C8, 0x97CE, 0x97E4, 0x9BAD, 0x9C91, 
	0x9EF3, 0x9F03
	};
const TText16 KPinyin447[3] = {'w', 'a', 'i', };
const TInt charForPinyin447[10] = {
	0x5916, 0x6B6A, 0x5D34, 0x5459, 0x54BC, 0x558E, 0x592D, 0x7024, 0x7AF5, 0x9861
	};
const TText16 KPinyin448[3] = {'w', 'a', 'n', };
const TInt charForPinyin448[110] = {
	0x5B8C, 0x4E07, 0x665A, 0x7897, 0x73A9, 0x5F2F, 0x633D, 0x6E7E, 0x4E38, 0x8155, 0x5B9B, 0x5A49, 0x70F7, 0x987D, 0x8C4C, 0x60CB, 
	0x5A29, 0x7696, 0x8513, 0x839E, 0x8118, 0x873F, 0x7EFE, 0x8284, 0x742C, 0x7EA8, 0x525C, 0x7579, 0x83C0, 0x4E5B, 0x5007, 0x514D, 
	0x5173, 0x5213, 0x534D, 0x5350, 0x550D, 0x56ED, 0x57E6, 0x5846, 0x58EA, 0x5917, 0x5918, 0x59A7, 0x5A60, 0x5B6F, 0x5C8F, 0x5E35, 
	0x5F4E, 0x5FE8, 0x60CC, 0x628F, 0x6356, 0x6365, 0x6394, 0x6669, 0x667C, 0x670A, 0x6764, 0x689A, 0x6900, 0x69FE, 0x6C4D, 0x6DB4, 
	0x6F6B, 0x6FAB, 0x7063, 0x7413, 0x76CC, 0x7755, 0x7B02, 0x7BA2, 0x7D08, 0x7D7B, 0x7D84, 0x7DA9, 0x7DB0, 0x7FEB, 0x8115, 0x82CB, 
	0x83A7, 0x83AC, 0x8416, 0x842C, 0x858D, 0x8696, 0x8CA6, 0x8CAB, 0x8D03, 0x8D0E, 0x8D2F, 0x8E20, 0x8F10, 0x8F13, 0x909C, 0x9124, 
	0x92C4, 0x92D4, 0x92FA, 0x933D, 0x9350, 0x93AB, 0x95A2, 0x95D7, 0x95DC, 0x9811, 0x9AA9, 0x9AAA, 0x9AAB, 0x9B6D
	};
const TText16 KPinyin449[4] = {'w', 'a', 'n', 'g', };
const TInt charForPinyin449[48] = {
	0x671B, 0x5FD8, 0x738B, 0x5F80, 0x7F51, 0x4EA1, 0x6789, 0x65FA, 0x6C6A, 0x5984, 0x8292, 0x8F8B, 0x9B4D, 0x60D8, 0x7F54, 0x4EBE, 
	0x4EFC, 0x5166, 0x5321, 0x5C22, 0x5C23, 0x5C29, 0x5C2A, 0x5C2B, 0x5F7A, 0x5F83, 0x5F8D, 0x5FF9, 0x6282, 0x6680, 0x671A, 0x6722, 
	0x68E2, 0x7007, 0x7139, 0x741E, 0x7687, 0x76F3, 0x7DB2, 0x83A3, 0x83F5, 0x869F, 0x86E7, 0x8744, 0x8AB7, 0x8F1E, 0x8FCB, 0x8FEC
	};
const TText16 KPinyin450[3] = {'w', 'e', 'i', };
const TInt charForPinyin450[234] = {
	0x4E3A, 0x4F4D, 0x672A, 0x56F4, 0x5582, 0x80C3, 0x5FAE, 0x5473, 0x5C3E, 0x4F2A, 0x5A01, 0x4F1F, 0x536B, 0x5371, 0x8FDD, 0x59D4, 
	0x9B4F, 0x552F, 0x7EF4, 0x754F, 0x60DF, 0x97E6, 0x5DCD, 0x851A, 0x8C13, 0x5C09, 0x6F4D, 0x7EAC, 0x6170, 0x6845, 0x840E, 0x82C7, 
	0x6E2D, 0x9057, 0x8473, 0x5E0F, 0x8249, 0x9C94, 0x5A13, 0x9036, 0x95F1, 0x9688, 0x6CA9, 0x73AE, 0x6DA0, 0x5E37, 0x5D34, 0x9697, 
	0x8BFF, 0x6D27, 0x504E, 0x7325, 0x732C, 0x5D6C, 0x8ECE, 0x97EA, 0x709C, 0x7168, 0x5729, 0x8587, 0x75FF, 0x4EB9, 0x502D, 0x5049, 
	0x507D, 0x50DE, 0x5130, 0x5383, 0x53DE, 0x54D9, 0x5529, 0x55A1, 0x55B4, 0x5672, 0x56D7, 0x570D, 0x5824, 0x589B, 0x58DD, 0x5A81, 
	0x5A99, 0x5AA6, 0x5BEA, 0x5CBF, 0x5CD7, 0x5CDE, 0x5D23, 0x5D54, 0x5DB6, 0x5DCB, 0x5E43, 0x5EC6, 0x5FAB, 0x6051, 0x6104, 0x6107, 
	0x61C0, 0x6364, 0x637C, 0x63CB, 0x63FB, 0x649D, 0x64B1, 0x6596, 0x6690, 0x6709, 0x673A, 0x68B6, 0x6932, 0x6933, 0x6972, 0x6B08, 
	0x6C87, 0x6D08, 0x6D58, 0x6E28, 0x6E4B, 0x6E88, 0x6EA6, 0x6F59, 0x6F7F, 0x6FCA, 0x6FF0, 0x6FFB, 0x7022, 0x70BA, 0x70D3, 0x7140, 
	0x7152, 0x715F, 0x71A8, 0x71AD, 0x71F0, 0x7232, 0x729A, 0x72A9, 0x7317, 0x731A, 0x741F, 0x744B, 0x748F, 0x74D7, 0x75CF, 0x7650, 
	0x7653, 0x772D, 0x77B6, 0x784A, 0x7859, 0x78A8, 0x78C8, 0x78D1, 0x7ACB, 0x7DAD, 0x7DED, 0x7DEF, 0x7E05, 0x7F7B, 0x8172, 0x829B, 
	0x829F, 0x82FF, 0x831F, 0x8371, 0x837D, 0x83CB, 0x840F, 0x8466, 0x8468, 0x848D, 0x84F6, 0x853F, 0x85B3, 0x85EF, 0x8636, 0x8732, 
	0x8739, 0x873C, 0x875B, 0x875F, 0x87B1, 0x885B, 0x885E, 0x893D, 0x89A3, 0x89B9, 0x89F9, 0x89FD, 0x89FF, 0x8A74, 0x8AC9, 0x8B02, 
	0x8B86, 0x8B8F, 0x8DA1, 0x8E12, 0x8E13, 0x8E97, 0x8E9B, 0x8F4A, 0x9055, 0x907A, 0x912C, 0x9180, 0x9317, 0x934F, 0x9361, 0x93CF, 
	0x95C8, 0x9622, 0x9687, 0x96B9, 0x9728, 0x973A, 0x97CB, 0x97D1, 0x97D9, 0x97E1, 0x9820, 0x98B9, 0x9927, 0x9935, 0x9956, 0x9AA9, 
	0x9AAA, 0x9AAB, 0x9B87, 0x9BA0, 0x9BAA, 0x9C03, 0x9C04, 0x9C16, 0x9CC2, 0x9CDA
	};
const TText16 KPinyin451[3] = {'w', 'e', 'n', };
const TInt charForPinyin451[95] = {
	0x95EE, 0x6587, 0x95FB, 0x7A33, 0x6E29, 0x543B, 0x868A, 0x7EB9, 0x761F, 0x7D0A, 0x6C76, 0x960C, 0x520E, 0x96EF, 0x74BA, 0x514D, 
	0x5445, 0x545A, 0x5461, 0x554F, 0x586D, 0x598F, 0x5A29, 0x5F63, 0x5FDE, 0x5FDF, 0x6120, 0x614D, 0x6286, 0x63FE, 0x6435, 0x6627, 
	0x6637, 0x687D, 0x6985, 0x69B2, 0x6B7E, 0x6B81, 0x6B9F, 0x6E02, 0x6EAB, 0x7086, 0x7174, 0x73F3, 0x7465, 0x7612, 0x773C, 0x7807, 
	0x7A4F, 0x7A69, 0x7B0F, 0x7D0B, 0x7D7B, 0x7DFC, 0x7E15, 0x7F0A, 0x805E, 0x80B3, 0x8115, 0x8117, 0x82A0, 0x83AC, 0x8570, 0x8574, 
	0x8580, 0x85F4, 0x860A, 0x8689, 0x87A1, 0x87C1, 0x891E, 0x8C71, 0x8F3C, 0x8F40, 0x8F92, 0x922B, 0x93BE, 0x95BA, 0x95BF, 0x95C5, 
	0x95E6, 0x9650, 0x97DE, 0x97EB, 0x9850, 0x9942, 0x99BC, 0x9B70, 0x9C1B, 0x9C2E, 0x9CC1, 0x9CFC, 0x9D0D, 0x9D16, 0x9F24
	};
const TText16 KPinyin452[4] = {'w', 'e', 'n', 'g', };
const TInt charForPinyin452[22] = {
	0x7FC1, 0x55E1, 0x74EE, 0x8579, 0x84CA, 0x52DC, 0x5855, 0x58C5, 0x5963, 0x5D61, 0x66A1, 0x6EC3, 0x7515, 0x7788, 0x7F4B, 0x806C, 
	0x8499, 0x8789, 0x9393, 0x9DB2, 0x9E5F, 0x9F46
	};
const TText16 KPinyin453[3] = {'w', 'i', 'e', };
const TInt charForPinyin453[1] = {
	0x81B8
	};
const TText16 KPinyin454[2] = {'w', 'o', };
const TInt charForPinyin454[65] = {
	0x6211, 0x63E1, 0x7A9D, 0x5367, 0x631D, 0x6C83, 0x8717, 0x6DA1, 0x65A1, 0x502D, 0x5E44, 0x9F8C, 0x809F, 0x83B4, 0x5594, 0x6E25, 
	0x786A, 0x4EF4, 0x5053, 0x5529, 0x55CC, 0x5641, 0x5684, 0x57DA, 0x581D, 0x592D, 0x5A50, 0x5A51, 0x5A89, 0x5AAA, 0x5ABC, 0x6370, 
	0x637C, 0x637E, 0x64BE, 0x64ED, 0x674C, 0x6782, 0x6943, 0x6DB4, 0x6DB9, 0x6E26, 0x6FC4, 0x6FE3, 0x7125, 0x7327, 0x74C1, 0x761F, 
	0x7783, 0x77C6, 0x7AA9, 0x815B, 0x81D2, 0x81E5, 0x8267, 0x8435, 0x84A6, 0x85B6, 0x8778, 0x8E12, 0x8E20, 0x96D8, 0x99A7, 0x9F77, 
	0x9F8F
	};
const TText16 KPinyin455[2] = {'w', 'u', };
const TInt charForPinyin455[186] = {
	0x65E0, 0x4E94, 0x5C4B, 0x7269, 0x821E, 0x96FE, 0x8BEF, 0x6342, 0x6C61, 0x609F, 0x52FF, 0x94A8, 0x6B66, 0x620A, 0x52A1, 0x545C, 
	0x4F0D, 0x5434, 0x5348, 0x543E, 0x4FAE, 0x4E4C, 0x6BCB, 0x6076, 0x8BEC, 0x829C, 0x5DEB, 0x6664, 0x68A7, 0x575E, 0x59A9, 0x8708, 
	0x727E, 0x5BE4, 0x5140, 0x6003, 0x9622, 0x90AC, 0x5514, 0x5FE4, 0x9A9B, 0x65BC, 0x92C8, 0x4EF5, 0x674C, 0x9E5C, 0x5A7A, 0x8FD5, 
	0x75E6, 0x82B4, 0x7110, 0x5E91, 0x9E49, 0x9F2F, 0x6D6F, 0x572C, 0x4E44, 0x4EA1, 0x4EBE, 0x4EE1, 0x4F06, 0x4F89, 0x4FC9, 0x5035, 
	0x511B, 0x5166, 0x526D, 0x52D9, 0x5433, 0x5449, 0x554E, 0x5594, 0x55DA, 0x5641, 0x57AD, 0x57E1, 0x5825, 0x5862, 0x58B2, 0x5966, 
	0x5A12, 0x5A2A, 0x5A2C, 0x5AF5, 0x5C7C, 0x5C89, 0x5CFF, 0x5D4D, 0x5D68, 0x5E60, 0x5EE1, 0x5F19, 0x5FA1, 0x5FE2, 0x609E, 0x60AE, 
	0x60E1, 0x61AE, 0x625C, 0x625D, 0x6264, 0x63FE, 0x6440, 0x6544, 0x65C4, 0x65FF, 0x6745, 0x6747, 0x67EE, 0x6A46, 0x6B4D, 0x6BCD, 
	0x6C59, 0x6C5A, 0x6C95, 0x6D16, 0x6D3F, 0x6E1E, 0x6E25, 0x6EA9, 0x6F55, 0x70CF, 0x7121, 0x7183, 0x7193, 0x739D, 0x73F7, 0x73F8, 
	0x7466, 0x7491, 0x7512, 0x7780, 0x77B4, 0x77F9, 0x7894, 0x7966, 0x7991, 0x7A8F, 0x7AB9, 0x7B0F, 0x7BBC, 0x7C85, 0x81B4, 0x8323, 
	0x8381, 0x83AB, 0x856A, 0x8601, 0x8765, 0x8790, 0x87F1, 0x8A88, 0x8AA3, 0x8AA4, 0x8B55, 0x8DB6, 0x8E8C, 0x901C, 0x90DA, 0x9114, 
	0x91EB, 0x92D8, 0x92D9, 0x933B, 0x93A2, 0x94FB, 0x965A, 0x9696, 0x96FA, 0x971A, 0x9727, 0x973F, 0x9770, 0x9A16, 0x9BC3, 0x9C1E, 
	0x9D2E, 0x9D50, 0x9D61, 0x9DA9, 0x9DE1, 0x9E40, 0x9F3F, 0x9F40, 0x9F6C, 0x9F89
	};
const TText16 KPinyin456[2] = {'x', 'i', };
const TInt charForPinyin456[313] = {
	0x897F, 0x6D17, 0x7EC6, 0x5438, 0x620F, 0x7CFB, 0x559C, 0x5E2D, 0x7A00, 0x6EAA, 0x7184, 0x9521, 0x819D, 0x606F, 0x88AD, 0x60DC, 
	0x4E60, 0x563B, 0x5915, 0x6089, 0x77FD, 0x7199, 0x5E0C, 0x6A84, 0x727A, 0x6670, 0x6614, 0x5AB3, 0x7852, 0x94E3, 0x70EF, 0x814A, 
	0x6790, 0x9699, 0x6816, 0x6C50, 0x7280, 0x8725, 0x595A, 0x6D60, 0x8478, 0x9969, 0x5C63, 0x73BA, 0x5B09, 0x798A, 0x516E, 0x7FD5, 
	0x7A78, 0x79A7, 0x50D6, 0x6DC5, 0x84F0, 0x823E, 0x8E4A, 0x91AF, 0x90D7, 0x6B37, 0x7699, 0x87CB, 0x7FB2, 0x831C, 0x5F99, 0x96B0, 
	0x550F, 0x66E6, 0x8785, 0x6B59, 0x6A28, 0x960B, 0x7C9E, 0x71B9, 0x89CB, 0x83E5, 0x9F37, 0x88FC, 0x8204, 0x4E49, 0x4FC2, 0x4FD9, 
	0x5092, 0x51DE, 0x5338, 0x534C, 0x5365, 0x537B, 0x5380, 0x541A, 0x546C, 0x5470, 0x54A5, 0x54A6, 0x54AD, 0x553D, 0x564F, 0x568A, 
	0x56B1, 0x5848, 0x58D0, 0x594A, 0x5A2D, 0x5A90, 0x5B06, 0x5BA9, 0x5C43, 0x5C4E, 0x5C56, 0x5C6D, 0x5D60, 0x5D8D, 0x5DB2, 0x5DC2, 
	0x5DC7, 0x5ED7, 0x5F86, 0x5FAF, 0x5FD4, 0x5FDA, 0x5FE5, 0x602C, 0x6038, 0x6044, 0x6095, 0x60C1, 0x613E, 0x6140, 0x6198, 0x6199, 
	0x622F, 0x6231, 0x6232, 0x6271, 0x6278, 0x6461, 0x6495, 0x64CA, 0x65E2, 0x665E, 0x6673, 0x66BF, 0x676B, 0x67B2, 0x6878, 0x68F2, 
	0x691E, 0x693A, 0x69BD, 0x69E2, 0x6A40, 0x6A72, 0x6B2A, 0x6B2F, 0x6B56, 0x6C23, 0x6C25, 0x6D12, 0x6E13, 0x6E7F, 0x6ECA, 0x6F07, 
	0x6F1D, 0x6F5D, 0x6F5F, 0x6F99, 0x6FD5, 0x7051, 0x7101, 0x7108, 0x711F, 0x712C, 0x7155, 0x7182, 0x7188, 0x71BA, 0x71BB, 0x71CD, 
	0x71E8, 0x7214, 0x7294, 0x72A0, 0x72A7, 0x72F6, 0x730E, 0x7361, 0x737B, 0x740B, 0x74BD, 0x74D5, 0x761C, 0x76FB, 0x774E, 0x77A6, 
	0x77D6, 0x788F, 0x78F6, 0x7902, 0x7A27, 0x7AB8, 0x7CE6, 0x7D30, 0x7D8C, 0x7DC6, 0x7E18, 0x7E30, 0x7E65, 0x7E6B, 0x7E9A, 0x7EE4, 
	0x7F9B, 0x7FA9, 0x7FD2, 0x7FD6, 0x80B8, 0x80B9, 0x80C1, 0x8105, 0x8107, 0x810B, 0x8203, 0x8383, 0x8394, 0x8448, 0x84A0, 0x84B5, 
	0x84C6, 0x8507, 0x856E, 0x8582, 0x8669, 0x8724, 0x8734, 0x8777, 0x8787, 0x87E2, 0x8835, 0x884B, 0x8936, 0x8972, 0x8980, 0x89A1, 
	0x89A4, 0x89F9, 0x89FD, 0x89FF, 0x8A22, 0x8A51, 0x8A92, 0x8AF0, 0x8B11, 0x8B1A, 0x8B35, 0x8B46, 0x8BF6, 0x8C25, 0x8C3F, 0x8C40, 
	0x8C68, 0x8C6F, 0x8C95, 0x8D65, 0x8D69, 0x8D87, 0x8D98, 0x8E5D, 0x8EA7, 0x905F, 0x90C4, 0x90CB, 0x90E4, 0x910E, 0x9145, 0x91D0, 
	0x91F3, 0x91F8, 0x9212, 0x9222, 0x9268, 0x9269, 0x9291, 0x932B, 0x932F, 0x93B4, 0x93ED, 0x9474, 0x9491, 0x9519, 0x95DF, 0x969F, 
	0x96B5, 0x96DF, 0x96ED, 0x972B, 0x973C, 0x98C1, 0x990F, 0x9919, 0x993C, 0x997B, 0x9A31, 0x9A3D, 0x9A68, 0x9B29, 0x9BD1, 0x9C13, 
	0x9C3C, 0x9C5A, 0x9CC3, 0x9CDB, 0x9D57, 0x9E02, 0x9ED6, 0x9F30, 0x9F33
	};
const TText16 KPinyin457[3] = {'x', 'i', 'a', };
const TInt charForPinyin457[98] = {
	0x4E0B, 0x5413, 0x590F, 0x5CE1, 0x867E, 0x778E, 0x971E, 0x72ED, 0x5323, 0x4FA0, 0x8F96, 0x53A6, 0x6687, 0x552C, 0x72CE, 0x67D9, 
	0x5477, 0x9EE0, 0x7856, 0x7F45, 0x9050, 0x7455, 0x4E05, 0x4FE0, 0x5047, 0x5084, 0x53DA, 0x5440, 0x54E7, 0x55C4, 0x55D1, 0x5687, 
	0x5737, 0x57C9, 0x5913, 0x593E, 0x5C88, 0x5CFD, 0x5EC8, 0x5FA6, 0x61D7, 0x62BC, 0x637E, 0x6433, 0x656E, 0x6630, 0x68BA, 0x6B31, 
	0x6B43, 0x6BF3, 0x6D43, 0x6D79, 0x6E8A, 0x70A0, 0x70DA, 0x7146, 0x72F9, 0x73E8, 0x759C, 0x75A8, 0x7615, 0x7771, 0x7864, 0x78AC, 
	0x78CD, 0x796B, 0x7B1A, 0x7B6A, 0x7D66, 0x7E00, 0x7E16, 0x7ED9, 0x7FC8, 0x821D, 0x823A, 0x8290, 0x846D, 0x8578, 0x8766, 0x879B, 
	0x8AD5, 0x8B11, 0x8C3A, 0x8D6E, 0x8F44, 0x90C3, 0x935C, 0x938B, 0x93EC, 0x9595, 0x959C, 0x965C, 0x967F, 0x98AC, 0x9A22, 0x9B7B, 
	0x9C15, 0x9DB7
	};
const TText16 KPinyin458[4] = {'x', 'i', 'a', 'n', };
const TInt charForPinyin458[258] = {
	0x5148, 0x7EBF, 0x53BF, 0x73B0, 0x663E, 0x6380, 0x95F2, 0x732E, 0x5ACC, 0x9677, 0x9669, 0x9C9C, 0x5F26, 0x8854, 0x9985, 0x9650, 
	0x54B8, 0x9528, 0x4ED9, 0x817A, 0x8D24, 0x7EA4, 0x5BAA, 0x8237, 0x6D8E, 0x7FA1, 0x94E3, 0x89C1, 0x82CB, 0x85D3, 0x5C98, 0x75EB, 
	0x83B6, 0x7C7C, 0x5A34, 0x86AC, 0x7303, 0x7946, 0x51BC, 0x71F9, 0x8DE3, 0x8DF9, 0x9170, 0x66B9, 0x6C19, 0x9E47, 0x7B45, 0x9730, 
	0x4EDA, 0x4F23, 0x4F2D, 0x4F61, 0x4FD4, 0x50CA, 0x50E9, 0x50F2, 0x50F4, 0x5481, 0x549E, 0x54EF, 0x550C, 0x5563, 0x55DB, 0x5615, 
	0x57B7, 0x57F3, 0x583F, 0x58CF, 0x597E, 0x5997, 0x59B6, 0x59CD, 0x59D7, 0x59ED, 0x59FA, 0x5A0A, 0x5A28, 0x5A39, 0x5A71, 0x5AFA, 
	0x5AFB, 0x5B10, 0x5B45, 0x5BF0, 0x5C1F, 0x5C20, 0x5C73, 0x5CF4, 0x5D04, 0x5DAE, 0x5E70, 0x5EEF, 0x5F61, 0x5FFA, 0x614A, 0x6173, 
	0x61AA, 0x61B2, 0x61B8, 0x61E2, 0x6326, 0x634D, 0x63A2, 0x63F1, 0x641A, 0x641F, 0x648A, 0x648F, 0x6507, 0x6515, 0x665B, 0x6774, 
	0x67AE, 0x6898, 0x69CF, 0x6A4C, 0x6AF6, 0x6B26, 0x6BE8, 0x6D12, 0x6D17, 0x6D80, 0x6E7A, 0x6E93, 0x6F96, 0x6FC2, 0x7017, 0x7051, 
	0x7066, 0x70CD, 0x72DD, 0x736B, 0x736E, 0x737B, 0x7381, 0x73B9, 0x73D7, 0x73FE, 0x7509, 0x7647, 0x764E, 0x76F7, 0x7701, 0x770C, 
	0x774D, 0x77AF, 0x77E3, 0x784D, 0x78B1, 0x7906, 0x7925, 0x7992, 0x79B0, 0x79C8, 0x7A34, 0x7B15, 0x7B67, 0x7BB2, 0x7CAF, 0x7CEE, 
	0x7D43, 0x7D64, 0x7D85, 0x7D96, 0x7DAB, 0x7DDA, 0x7E23, 0x7E3F, 0x7E4A, 0x7E8E, 0x7E96, 0x7F10, 0x7FA8, 0x7FAC, 0x80A9, 0x80C1, 
	0x80D8, 0x8105, 0x8107, 0x810B, 0x8181, 0x81D4, 0x81E4, 0x81FD, 0x82EE, 0x83A7, 0x8539, 0x859F, 0x85D6, 0x861A, 0x861D, 0x861E, 
	0x86BF, 0x86DD, 0x8706, 0x8858, 0x893C, 0x8973, 0x898B, 0x8AA2, 0x8AB8, 0x8AF4, 0x8B40, 0x8B63, 0x8C4F, 0x8CE2, 0x8D12, 0x8D7B, 
	0x8E6E, 0x8E9A, 0x8ED0, 0x8ED2, 0x8F31, 0x8F69, 0x918E, 0x91B6, 0x91E4, 0x9291, 0x929B, 0x929C, 0x92E7, 0x930E, 0x931F, 0x9341, 
	0x934C, 0x93FE, 0x9466, 0x9490, 0x94E6, 0x952C, 0x9591, 0x9592, 0x95DE, 0x961A, 0x9665, 0x967A, 0x96AA, 0x97C5, 0x97EF, 0x97F1, 
	0x9848, 0x9855, 0x986F, 0x9921, 0x9940, 0x99A6, 0x9BAE, 0x9C14, 0x9C7B, 0x9DB1, 0x9DF3, 0x9DF4, 0x9DFC, 0x9E79, 0x9E99, 0x9EB2, 
	0x9EF9, 0x9F38
	};
const TText16 KPinyin459[5] = {'x', 'i', 'a', 'n', 'g', };
const TInt charForPinyin459[98] = {
	0x60F3, 0x5411, 0x8C61, 0x9879, 0x54CD, 0x9999, 0x4E61, 0x76F8, 0x50CF, 0x7BB1, 0x5DF7, 0x4EAB, 0x9576, 0x53A2, 0x964D, 0x7FD4, 
	0x7965, 0x6A61, 0x8BE6, 0x6E58, 0x8944, 0x98E8, 0x9C9E, 0x9AA7, 0x87D3, 0x5EA0, 0x8297, 0x9977, 0x7F03, 0x8459, 0x4EA8, 0x4EAF, 
	0x4F6D, 0x50A2, 0x5134, 0x52E8, 0x52F7, 0x554C, 0x554D, 0x56AE, 0x59E0, 0x5D91, 0x5EC2, 0x5FC0, 0x6518, 0x6651, 0x66CF, 0x6819, 
	0x697F, 0x6B00, 0x6D0B, 0x6F52, 0x73E6, 0x74D6, 0x74E8, 0x7D74, 0x7DD7, 0x7E95, 0x7F3F, 0x7F8F, 0x81B7, 0x8221, 0x842B, 0x858C, 
	0x8618, 0x8683, 0x8801, 0x8856, 0x8950, 0x8A73, 0x8DED, 0x8FD2, 0x90F7, 0x9109, 0x910A, 0x9115, 0x9284, 0x9297, 0x92DE, 0x940C, 
	0x9472, 0x95A7, 0x95C0, 0x95C2, 0x97FF, 0x9805, 0x9909, 0x9957, 0x995F, 0x9A64, 0x9B28, 0x9B9D, 0x9BD7, 0x9C4C, 0x9C5C, 0x9C76, 
	0x9D39, 0x9E98
	};
const TText16 KPinyin460[4] = {'x', 'i', 'a', 'o', };
const TInt charForPinyin460[168] = {
	0x5C0F, 0x7B11, 0x6D88, 0x524A, 0x9500, 0x8427, 0x6548, 0x5BB5, 0x6653, 0x8096, 0x5B5D, 0x785D, 0x6DC6, 0x5578, 0x9704, 0x54EE, 
	0x56A3, 0x6821, 0x9B48, 0x86F8, 0x9A81, 0x67B5, 0x54D3, 0x5D24, 0x7B71, 0x6F47, 0x900D, 0x67AD, 0x7EE1, 0x7BAB, 0x4F7C, 0x4FBE, 
	0x4FCF, 0x4FF2, 0x509A, 0x52B9, 0x53DC, 0x53DF, 0x53F7, 0x547A, 0x547C, 0x54B2, 0x54BB, 0x54E8, 0x5520, 0x552C, 0x554B, 0x55C3, 
	0x560B, 0x5610, 0x5628, 0x562E, 0x562F, 0x5635, 0x56BB, 0x56C2, 0x59E3, 0x5A4B, 0x5BAF, 0x5EA8, 0x5F47, 0x6054, 0x6077, 0x61A2, 
	0x6320, 0x634E, 0x63F1, 0x641C, 0x6493, 0x64A8, 0x6569, 0x6585, 0x6586, 0x6681, 0x66C9, 0x689F, 0x68A2, 0x6A5A, 0x6AF9, 0x6B4A, 
	0x6B52, 0x6B57, 0x6BBD, 0x6BCA, 0x6D28, 0x6D8D, 0x6EE7, 0x6F3B, 0x6F5A, 0x6FA9, 0x701F, 0x7071, 0x7072, 0x70CB, 0x7107, 0x7187, 
	0x71BD, 0x71C6, 0x71FA, 0x723B, 0x72E1, 0x7307, 0x735F, 0x7362, 0x75DA, 0x75DF, 0x769B, 0x76A2, 0x7744, 0x7863, 0x7A58, 0x7A99, 
	0x7B39, 0x7B7F, 0x7BBE, 0x7BE0, 0x7C18, 0x7C2B, 0x7D5E, 0x7D83, 0x7E3F, 0x7EDE, 0x7FDB, 0x80F6, 0x8129, 0x81AE, 0x828D, 0x832D, 
	0x83A6, 0x8437, 0x856D, 0x8582, 0x85C3, 0x8648, 0x8653, 0x87C2, 0x87CF, 0x87F0, 0x8828, 0x8A24, 0x8A68, 0x8A9F, 0x8AB5, 0x8B0F, 
	0x8B1E, 0x8B3C, 0x8B4A, 0x8E03, 0x8F03, 0x8F47, 0x8F83, 0x90E9, 0x92B7, 0x98B5, 0x9A37, 0x9A4D, 0x9A55, 0x9A84, 0x9A9A, 0x9AB9, 
	0x9AC7, 0x9AD0, 0x9D1E, 0x9D35, 0x9D41, 0x9DCD, 0x9DD5, 0x9E2E
	};
const TText16 KPinyin461[3] = {'x', 'i', 'e', };
const TInt charForPinyin461[176] = {
	0x5199, 0x4E9B, 0x978B, 0x6B47, 0x659C, 0x8840, 0x8C22, 0x5378, 0x631F, 0x5C51, 0x87F9, 0x6CFB, 0x61C8, 0x6CC4, 0x6954, 0x90AA, 
	0x534F, 0x68B0, 0x8C10, 0x874E, 0x643A, 0x80C1, 0x89E3, 0x5951, 0x53F6, 0x7EC1, 0x9889, 0x7F2C, 0x736C, 0x69AD, 0x5EE8, 0x64B7, 
	0x5055, 0x7023, 0x6E2B, 0x4EB5, 0x698D, 0x9082, 0x85A4, 0x8E9E, 0x71EE, 0x52F0, 0x4F33, 0x505E, 0x5070, 0x50C1, 0x5136, 0x51A9, 
	0x52A6, 0x5354, 0x5368, 0x5424, 0x550F, 0x5588, 0x55CB, 0x5667, 0x57A5, 0x586E, 0x5911, 0x593E, 0x594A, 0x5A0E, 0x5A9F, 0x5B48, 
	0x5BEB, 0x5C53, 0x5C5C, 0x5C5F, 0x5C67, 0x5C6D, 0x5CEB, 0x5DB0, 0x5FA2, 0x604A, 0x6136, 0x6140, 0x62F9, 0x633E, 0x63A5, 0x63F3, 
	0x641A, 0x647A, 0x64D5, 0x64F7, 0x651C, 0x65EA, 0x66AC, 0x67BB, 0x6854, 0x699D, 0x69F7, 0x6B38, 0x6B59, 0x6BBA, 0x6C41, 0x6D29, 
	0x6E5D, 0x6E83, 0x6E89, 0x6ECA, 0x6F70, 0x6FA5, 0x7009, 0x707A, 0x70A7, 0x70A8, 0x70F2, 0x710E, 0x7181, 0x71F2, 0x7215, 0x7332, 
	0x744E, 0x772D, 0x78BF, 0x7944, 0x79BC, 0x7CCF, 0x7D32, 0x7D4F, 0x7D5C, 0x7D6C, 0x7D8A, 0x7DE4, 0x7DF3, 0x7E72, 0x7E88, 0x7F37, 
	0x7FD3, 0x8036, 0x8105, 0x8107, 0x810B, 0x818E, 0x85A2, 0x85DB, 0x8751, 0x8762, 0x880D, 0x880F, 0x887A, 0x88CC, 0x8909, 0x893B, 
	0x896D, 0x89DF, 0x89E7, 0x8ADC, 0x8AE7, 0x8B1D, 0x8B6E, 0x8B97, 0x8C0D, 0x8C6B, 0x8DEC, 0x8EA0, 0x8FE6, 0x9371, 0x9437, 0x96B0, 
	0x97A2, 0x97B5, 0x97F0, 0x9801, 0x9821, 0x9875, 0x9AB1, 0x9B39, 0x9B7C, 0x9BAD, 0x9C91, 0x9F42, 0x9F58, 0x9F5B, 0x9F65, 0x9FA4
	};
const TText16 KPinyin462[3] = {'x', 'i', 'n', };
const TInt charForPinyin462[64] = {
	0x65B0, 0x5FC3, 0x6B23, 0x4FE1, 0x82AF, 0x85AA, 0x950C, 0x8F9B, 0x5BFB, 0x8845, 0x5FFB, 0x6B46, 0x56DF, 0x8398, 0x9561, 0x99A8, 
	0x946B, 0x6615, 0x4F08, 0x4F29, 0x4FFD, 0x5174, 0x5677, 0x567A, 0x59A1, 0x59F0, 0x5B1C, 0x5B5E, 0x5C0B, 0x5E8D, 0x5EDE, 0x5FC4, 
	0x60DE, 0x6116, 0x6196, 0x64A2, 0x677A, 0x6794, 0x6A5D, 0x6B35, 0x6B3E, 0x6B40, 0x6F43, 0x7098, 0x712E, 0x76FA, 0x7925, 0x812A, 
	0x8208, 0x820B, 0x8951, 0x8A22, 0x8A2B, 0x8ED0, 0x90A4, 0x91C1, 0x920A, 0x92C5, 0x9414, 0x9620, 0x9856, 0x99AB, 0x99B8, 0x9B35
	};
const TText16 KPinyin463[4] = {'x', 'i', 'n', 'g', };
const TInt charForPinyin463[72] = {
	0x6027, 0x884C, 0x578B, 0x5F62, 0x661F, 0x9192, 0x59D3, 0x8165, 0x5211, 0x674F, 0x5174, 0x5E78, 0x90A2, 0x7329, 0x60FA, 0x7701, 
	0x784E, 0x60BB, 0x8365, 0x9649, 0x64E4, 0x8347, 0x4F80, 0x5016, 0x54D8, 0x5753, 0x5759, 0x57B6, 0x5842, 0x5A19, 0x5A5E, 0x5AC8, 
	0x5B39, 0x5DE0, 0x66D0, 0x6D10, 0x6DAC, 0x6ECE, 0x714B, 0x7192, 0x72CC, 0x7446, 0x76A8, 0x7772, 0x7814, 0x784F, 0x7BB5, 0x7BC2, 
	0x7DC8, 0x80DC, 0x81D6, 0x8208, 0x8395, 0x86F5, 0x88C4, 0x89EA, 0x89F2, 0x8B03, 0x90C9, 0x9203, 0x9276, 0x9292, 0x92DE, 0x9498, 
	0x94CF, 0x9658, 0x9933, 0x9967, 0x9A02, 0x9A8D, 0x9B8F, 0x9BF9
	};
const TText16 KPinyin464[5] = {'x', 'i', 'o', 'n', 'g', };
const TInt charForPinyin464[26] = {
	0x80F8, 0x96C4, 0x51F6, 0x5144, 0x718A, 0x6C79, 0x5308, 0x828E, 0x5147, 0x54C5, 0x5910, 0x5BAA, 0x5FF7, 0x605F, 0x657B, 0x662B, 
	0x6D36, 0x7138, 0x80F7, 0x8A29, 0x8A57, 0x8A7E, 0x8BBB, 0x8BC7, 0x8CEF, 0x8D68
	};
const TText16 KPinyin465[3] = {'x', 'i', 'u', };
const TInt charForPinyin465[60] = {
	0x4FEE, 0x9508, 0x7EE3, 0x4F11, 0x7F9E, 0x5BBF, 0x55C5, 0x8896, 0x79C0, 0x673D, 0x81ED, 0x6EB4, 0x8C85, 0x9990, 0x9AF9, 0x9E3A, 
	0x54BB, 0x5EA5, 0x5CAB, 0x4FE2, 0x568A, 0x6A07, 0x6AF9, 0x6EEB, 0x70CB, 0x70CC, 0x7166, 0x73DB, 0x7407, 0x7493, 0x7CD4, 0x7D87, 
	0x7D89, 0x7E4D, 0x7E61, 0x8119, 0x8129, 0x81F0, 0x81F9, 0x82EC, 0x8320, 0x83A0, 0x84E8, 0x8791, 0x88E6, 0x890E, 0x890F, 0x929D, 
	0x92B9, 0x9380, 0x93C5, 0x93E5, 0x93FD, 0x98CD, 0x9948, 0x9AE4, 0x9BB4, 0x9C43, 0x9D42, 0x9F45
	};
const TText16 KPinyin466[2] = {'x', 'u', };
const TInt charForPinyin466[164] = {
	0x8BB8, 0x987B, 0x9700, 0x865A, 0x5618, 0x84C4, 0x7EED, 0x5E8F, 0x53D9, 0x755C, 0x7D6E, 0x5A7F, 0x620C, 0x5F90, 0x65ED, 0x7EEA, 
	0x5401, 0x9157, 0x6064, 0x589F, 0x7CC8, 0x52D6, 0x6829, 0x6D52, 0x84FF, 0x987C, 0x5729, 0x6D2B, 0x80E5, 0x9191, 0x8BE9, 0x6E86, 
	0x7166, 0x76F1, 0x7809, 0x4E8E, 0x4E90, 0x4F03, 0x4F11, 0x4F35, 0x4F59, 0x4F90, 0x4FC6, 0x5066, 0x5194, 0x52D7, 0x5379, 0x5455, 
	0x5474, 0x547C, 0x54BB, 0x55A3, 0x55C5, 0x5614, 0x563C, 0x5653, 0x57BF, 0x58FB, 0x59B6, 0x59C1, 0x59D0, 0x5AAD, 0x5B03, 0x5E41, 
	0x6034, 0x6035, 0x6053, 0x60D0, 0x6149, 0x639D, 0x63DF, 0x654D, 0x6558, 0x65EE, 0x65F4, 0x662B, 0x6647, 0x668A, 0x6702, 0x6710, 
	0x6948, 0x69D2, 0x6B28, 0x6B30, 0x6B3B, 0x6B54, 0x6B58, 0x6B88, 0x6C7F, 0x6C80, 0x6DE2, 0x6E51, 0x6EC0, 0x6EF8, 0x6F35, 0x6F4A, 
	0x70C5, 0x70FC, 0x735D, 0x73DD, 0x73EC, 0x759E, 0x76E2, 0x76E8, 0x7717, 0x7781, 0x77B2, 0x77DE, 0x7A30, 0x7A38, 0x7AA2, 0x7C72, 
	0x7D9A, 0x7DD2, 0x7DD6, 0x7DF0, 0x7E03, 0x7E7B, 0x7E8C, 0x805F, 0x80B7, 0x80CA, 0x828B, 0x828C, 0x82A7, 0x84A3, 0x84F2, 0x8566, 
	0x85C7, 0x85DA, 0x8657, 0x865B, 0x86BC, 0x86E1, 0x8751, 0x898F, 0x89C4, 0x8A0F, 0x8A31, 0x8A39, 0x8A61, 0x8ADD, 0x8AFF, 0x8B23, 
	0x8B33, 0x8B43, 0x8BB4, 0x8C1E, 0x8CC9, 0x90AA, 0x9126, 0x9265, 0x928A, 0x9450, 0x96E9, 0x9808, 0x980A, 0x9998, 0x9A49, 0x9B1A, 
	0x9B46, 0x9B56, 0x9B63, 0x9C6E
	};
const TText16 KPinyin467[4] = {'x', 'u', 'a', 'n', };
const TInt charForPinyin467[120] = {
	0x9009, 0x60AC, 0x65CB, 0x7384, 0x5BA3, 0x55A7, 0x8F69, 0x7EDA, 0x7729, 0x7663, 0x5238, 0x6684, 0x6966, 0x5107, 0x6E32, 0x6F29, 
	0x6CEB, 0x94C9, 0x7487, 0x714A, 0x78B9, 0x955F, 0x70AB, 0x63CE, 0x8431, 0x75C3, 0x8C16, 0x4E98, 0x5405, 0x54BA, 0x559B, 0x5847, 
	0x5910, 0x59B6, 0x59F0, 0x5A97, 0x5AD9, 0x5B1B, 0x5F32, 0x6030, 0x6103, 0x610B, 0x61C1, 0x61F8, 0x63C8, 0x64B0, 0x64D0, 0x660D, 
	0x6621, 0x6645, 0x6685, 0x6696, 0x66B6, 0x688B, 0x6965, 0x6A88, 0x6D35, 0x6D93, 0x6FB4, 0x70DC, 0x7156, 0x72DF, 0x7367, 0x7386, 
	0x73B9, 0x7401, 0x7404, 0x7444, 0x74BF, 0x74CA, 0x766C, 0x76E4, 0x7734, 0x777B, 0x77CE, 0x79A4, 0x7BAE, 0x7D43, 0x7D62, 0x7D79, 
	0x7E23, 0x7E3C, 0x7E4F, 0x7EE2, 0x7FE7, 0x7FFE, 0x8432, 0x84D2, 0x8519, 0x857F, 0x85FC, 0x8610, 0x8701, 0x870E, 0x8756, 0x8809, 
	0x8852, 0x88A8, 0x8AE0, 0x8AFC, 0x8B5E, 0x8B82, 0x8D19, 0x8ED2, 0x8F4B, 0x9078, 0x9084, 0x9249, 0x92D7, 0x9379, 0x93C7, 0x9436, 
	0x956E, 0x9799, 0x98B4, 0x994C, 0x9994, 0x99E8, 0x99FD, 0x9C1A
	};
const TText16 KPinyin468[3] = {'x', 'u', 'e', };
const TInt charForPinyin468[58] = {
	0x5B66, 0x96EA, 0x8840, 0x9774, 0x7A74, 0x524A, 0x859B, 0x8E05, 0x5671, 0x9CD5, 0x6CF6, 0x4E74, 0x51B3, 0x52EA, 0x5437, 0x54EE, 
	0x56AF, 0x5779, 0x58C6, 0x5B78, 0x5CA4, 0x5CC3, 0x5DA8, 0x6034, 0x6588, 0x6856, 0x688B, 0x6A30, 0x6C7A, 0x6CE7, 0x6CEC, 0x6EC8, 
	0x6FA9, 0x7025, 0x7094, 0x70D5, 0x71E2, 0x72D8, 0x75A6, 0x75B6, 0x77B2, 0x81A4, 0x825D, 0x8313, 0x8486, 0x8895, 0x89F7, 0x8B14, 
	0x8C11, 0x8D90, 0x8F4C, 0x8FA5, 0x96E4, 0x97BE, 0x97E1, 0x9C48, 0x9DFD, 0x9E34
	};
const TText16 KPinyin469[3] = {'x', 'u', 'n', };
const TInt charForPinyin469[120] = {
	0x5BFB, 0x8BAF, 0x718F, 0x8BAD, 0x5FAA, 0x6B89, 0x65EC, 0x5DE1, 0x8FC5, 0x9A6F, 0x6C5B, 0x900A, 0x52CB, 0x8364, 0x8BE2, 0x6D5A, 
	0x5DFD, 0x9C9F, 0x6D54, 0x57D9, 0x6042, 0x736F, 0x91BA, 0x6D35, 0x90C7, 0x5CCB, 0x8548, 0x85B0, 0x8340, 0x7AA8, 0x66DB, 0x5F87, 
	0x4F28, 0x4F9A, 0x5071, 0x52DB, 0x52F2, 0x52F3, 0x5342, 0x54B0, 0x5640, 0x565A, 0x5691, 0x5743, 0x5864, 0x58CE, 0x58E6, 0x595E, 
	0x59F0, 0x5B59, 0x5B6B, 0x5C0B, 0x5EF5, 0x609B, 0x613B, 0x63D7, 0x648F, 0x6533, 0x674A, 0x6812, 0x686A, 0x68AD, 0x6A33, 0x6BBE, 
	0x6BE5, 0x6D12, 0x6F6D, 0x6F6F, 0x6FEC, 0x7065, 0x7104, 0x7147, 0x71C2, 0x71C5, 0x71D6, 0x71FB, 0x720B, 0x7213, 0x72E5, 0x72FB, 
	0x73E3, 0x7495, 0x7734, 0x77C4, 0x7A04, 0x7B4D, 0x7B7C, 0x7BD4, 0x7D03, 0x7D62, 0x7E81, 0x7EDA, 0x81D0, 0x8368, 0x8477, 0x8512, 
	0x8541, 0x85AB, 0x860D, 0x87EB, 0x87F3, 0x8951, 0x8A0A, 0x8A13, 0x8A19, 0x8A62, 0x8CD0, 0x8FFF, 0x9021, 0x9041, 0x905C, 0x9129, 
	0x9442, 0x946B, 0x9868, 0x99B4, 0x99E8, 0x9C4F, 0x9C58, 0x9DBD
	};
const TText16 KPinyin470[2] = {'y', 'a', };
const TInt charForPinyin470[111] = {
	0x5440, 0x538B, 0x7259, 0x62BC, 0x82BD, 0x9E2D, 0x8F67, 0x5D16, 0x54D1, 0x4E9A, 0x6DAF, 0x4E2B, 0x96C5, 0x8859, 0x9E26, 0x8BB6, 
	0x869C, 0x57AD, 0x758B, 0x7811, 0x740A, 0x6860, 0x775A, 0x5A05, 0x75D6, 0x5C88, 0x6C29, 0x4F22, 0x8FD3, 0x63E0, 0x4E5B, 0x4E9C, 
	0x4E9E, 0x4FF9, 0x503B, 0x529C, 0x538A, 0x538C, 0x5393, 0x53AD, 0x5416, 0x543E, 0x547E, 0x5516, 0x555E, 0x5714, 0x5720, 0x5727, 
	0x57E1, 0x580A, 0x5810, 0x58D3, 0x59F6, 0x5A6D, 0x5B72, 0x5D15, 0x5E8C, 0x5E98, 0x5FA1, 0x62C1, 0x631C, 0x6397, 0x672D, 0x6792, 
	0x690F, 0x693B, 0x6B47, 0x6C2C, 0x6D65, 0x6F04, 0x6F5D, 0x70CF, 0x72BD, 0x731A, 0x7330, 0x73A1, 0x7458, 0x75A8, 0x7602, 0x78A3, 
	0x78CD, 0x7A0F, 0x7A75, 0x7AAB, 0x7B0C, 0x8050, 0x8565, 0x897E, 0x8A1D, 0x8ECB, 0x8F05, 0x8F35, 0x8F82, 0x90AA, 0x91FE, 0x930F, 
	0x941A, 0x94D4, 0x9598, 0x95F8, 0x9854, 0x989C, 0x9D09, 0x9D28, 0x9D6A, 0x9D76, 0x9D95, 0x9E4C, 0x9F3C, 0x9F56, 0x9F7E
	};
const TText16 KPinyin471[3] = {'y', 'a', 'n', };
const TInt charForPinyin471[297] = {
	0x773C, 0x70DF, 0x6CBF, 0x76D0, 0x8A00, 0x6F14, 0x4E25, 0x54BD, 0x6DF9, 0x708E, 0x63A9, 0x538C, 0x5BB4, 0x5CA9, 0x7814, 0x5EF6, 
	0x5830, 0x9A8C, 0x8273, 0x6BB7, 0x9609, 0x781A, 0x96C1, 0x5501, 0x5F66, 0x7130, 0x8712, 0x884D, 0x8C1A, 0x71D5, 0x989C, 0x960E, 
	0x94C5, 0x7109, 0x5944, 0x82AB, 0x53A3, 0x960F, 0x83F8, 0x9B47, 0x7430, 0x6EDF, 0x7131, 0x8D5D, 0x7B75, 0x814C, 0x5156, 0x5261, 
	0x990D, 0x6079, 0x7F68, 0x6A90, 0x6E6E, 0x5043, 0x8C33, 0x80ED, 0x664F, 0x95EB, 0x4FE8, 0x90FE, 0x917D, 0x9122, 0x598D, 0x9F39, 
	0x5D26, 0x963D, 0x5AE3, 0x4E75, 0x4F46, 0x4FFA, 0x5050, 0x5063, 0x50BF, 0x513C, 0x5157, 0x5186, 0x5266, 0x533D, 0x5382, 0x5383, 
	0x53AD, 0x53B3, 0x53B4, 0x550C, 0x55A6, 0x55AD, 0x565E, 0x56A5, 0x56B4, 0x56D0, 0x57CF, 0x57EF, 0x5869, 0x5895, 0x58DB, 0x58E7, 
	0x590F, 0x5935, 0x599F, 0x59F2, 0x59F8, 0x5A2B, 0x5A2E, 0x5A95, 0x5B0A, 0x5B10, 0x5B2E, 0x5B3F, 0x5B4D, 0x5C75, 0x5D04, 0x5D43, 
	0x5D52, 0x5D53, 0x5D96, 0x5DAE, 0x5DCC, 0x5DD6, 0x5DD7, 0x5DD8, 0x5DDA, 0x5DE1, 0x5E7F, 0x5EB5, 0x5EF5, 0x5F07, 0x5F65, 0x611D, 
	0x61D5, 0x622D, 0x624A, 0x6281, 0x6329, 0x633B, 0x635D, 0x639E, 0x63C5, 0x63DC, 0x63DE, 0x6565, 0x6616, 0x667B, 0x66A5, 0x66D5, 
	0x66EE, 0x68EA, 0x693B, 0x693C, 0x694C, 0x6A2E, 0x6A6A, 0x6ABF, 0x6AE9, 0x6B15, 0x6B97, 0x6C24, 0x6C87, 0x6D07, 0x6D1D, 0x6D8E, 
	0x6DCA, 0x6DE1, 0x6DEB, 0x6E30, 0x6E37, 0x6E7A, 0x6E8E, 0x6F39, 0x704E, 0x7054, 0x7067, 0x7069, 0x708F, 0x70FB, 0x7114, 0x7159, 
	0x7196, 0x71C4, 0x7213, 0x726A, 0x72E0, 0x72FF, 0x7312, 0x73DA, 0x7402, 0x74DB, 0x7517, 0x784F, 0x786F, 0x787D, 0x789E, 0x7939, 
	0x7BF6, 0x7C37, 0x7D96, 0x7E2F, 0x7FA1, 0x7FA8, 0x8181, 0x81D9, 0x8276, 0x8277, 0x839A, 0x83B6, 0x83F4, 0x8412, 0x844A, 0x8455, 
	0x8505, 0x852B, 0x859F, 0x8664, 0x8758, 0x88FA, 0x8917, 0x8983, 0x898E, 0x89C3, 0x89FE, 0x8A01, 0x8A2E, 0x8A7D, 0x8AFA, 0x8B8C, 
	0x8B9E, 0x8BA0, 0x8C53, 0x8C54, 0x8C5C, 0x8C63, 0x8D0B, 0x8D17, 0x8DBC, 0x8EBD, 0x8EC5, 0x8FD9, 0x9019, 0x9043, 0x90D4, 0x9140, 
	0x9153, 0x9183, 0x91B6, 0x91BC, 0x91C5, 0x925B, 0x931F, 0x952C, 0x9586, 0x95B9, 0x95BB, 0x95BC, 0x962D, 0x9669, 0x9670, 0x9681, 
	0x9692, 0x96AA, 0x9765, 0x9768, 0x984F, 0x9851, 0x9854, 0x9869, 0x995C, 0x9A10, 0x9A13, 0x9A34, 0x9A57, 0x9A60, 0x9B33, 0x9B58, 
	0x9C0B, 0x9CEB, 0x9CF1, 0x9D08, 0x9D33, 0x9DA0, 0x9DC3, 0x9DF0, 0x9E7D, 0x9E99, 0x9EA3, 0x9EB2, 0x9EE1, 0x9EE4, 0x9EEB, 0x9EEC, 
	0x9EED, 0x9EF0, 0x9EF6, 0x9F34, 0x9F57, 0x9F5E, 0x9F74, 0x9F82, 0x9F91
	};
const TText16 KPinyin472[4] = {'y', 'a', 'n', 'g', };
const TInt charForPinyin472[104] = {
	0x6837, 0x517B, 0x7F8A, 0x6D0B, 0x4EF0, 0x626C, 0x79E7, 0x6C27, 0x75D2, 0x6768, 0x6F3E, 0x9633, 0x6B83, 0x592E, 0x9E2F, 0x4F6F, 
	0x75A1, 0x7080, 0x6059, 0x5F89, 0x9785, 0x6CF1, 0x86D8, 0x70CA, 0x600F, 0x4F52, 0x509F, 0x52B7, 0x52DC, 0x536C, 0x5489, 0x5771, 
	0x579F, 0x594D, 0x59CE, 0x5A78, 0x5C07, 0x5C9F, 0x5D35, 0x5D38, 0x6143, 0x61E9, 0x62B0, 0x63DA, 0x6501, 0x656D, 0x65F8, 0x6602, 
	0x661C, 0x6620, 0x6698, 0x67CD, 0x694A, 0x6967, 0x69D8, 0x6A23, 0x6B4D, 0x6C1C, 0x6C31, 0x6E6F, 0x6F52, 0x7001, 0x70B4, 0x716C, 
	0x73DC, 0x7452, 0x760D, 0x7662, 0x770F, 0x773B, 0x7922, 0x7993, 0x7D3B, 0x7F8F, 0x7F95, 0x7F98, 0x7FAA, 0x80E6, 0x82F1, 0x8A47, 
	0x8A73, 0x8AF9, 0x8BE6, 0x8EEE, 0x8F30, 0x9260, 0x9348, 0x935A, 0x940A, 0x9496, 0x9626, 0x967D, 0x96F5, 0x9719, 0x9737, 0x98BA, 
	0x98CF, 0x98EC, 0x990A, 0x99DA, 0x9C11, 0x9D26, 0x9D39, 0x9E09
	};
const TText16 KPinyin473[3] = {'y', 'a', 'o', };
const TInt charForPinyin473[152] = {
	0x8981, 0x6447, 0x836F, 0x54AC, 0x8170, 0x7A91, 0x8200, 0x9080, 0x5996, 0x8C23, 0x9065, 0x59DA, 0x7476, 0x8000, 0x5C27, 0x94A5, 
	0x4FA5, 0x9676, 0x7EA6, 0x759F, 0x73E7, 0x592D, 0x9CD0, 0x9E5E, 0x8F7A, 0x723B, 0x5406, 0x94EB, 0x5E7A, 0x5D3E, 0x80B4, 0x66DC, 
	0x5FAD, 0x6773, 0x7A88, 0x4E48, 0x4E50, 0x4EF8, 0x5004, 0x5060, 0x509C, 0x50E5, 0x530B, 0x556E, 0x5593, 0x55C2, 0x565B, 0x5699, 
	0x579A, 0x582F, 0x5A06, 0x5A79, 0x5AB1, 0x5B08, 0x5B8E, 0x5C2D, 0x5C86, 0x5CE3, 0x5DA2, 0x5DA4, 0x5E7C, 0x5FBA, 0x602E, 0x604C, 
	0x612E, 0x62AD, 0x63FA, 0x6416, 0x647F, 0x64BD, 0x669A, 0x66E3, 0x6796, 0x67FC, 0x6946, 0x699A, 0x69A3, 0x6A02, 0x6B80, 0x6BBD, 
	0x6D2E, 0x6DEB, 0x6E94, 0x6EDB, 0x7039, 0x70C4, 0x70D1, 0x718E, 0x71FF, 0x72D5, 0x7336, 0x733A, 0x735F, 0x7385, 0x7464, 0x7531, 
	0x7711, 0x77C5, 0x78D8, 0x7945, 0x7A7E, 0x7A85, 0x7A94, 0x7AAF, 0x7AB0, 0x7B44, 0x7BB9, 0x7D04, 0x7E47, 0x7E85, 0x825E, 0x82ED, 
	0x835B, 0x846F, 0x847D, 0x84D4, 0x8558, 0x85AC, 0x85E5, 0x8628, 0x888E, 0x899E, 0x8A1E, 0x8A4F, 0x8B20, 0x8B21, 0x8B91, 0x8DAF, 
	0x8E30, 0x8EFA, 0x9059, 0x929A, 0x9390, 0x9470, 0x95C4, 0x9683, 0x977F, 0x9864, 0x98BB, 0x98D6, 0x9906, 0x991A, 0x9A15, 0x9A41, 
	0x9A9C, 0x9C29, 0x9D01, 0x9D22, 0x9DC2, 0x9DD5, 0x9F3C, 0x9F69
	};
const TText16 KPinyin474[2] = {'y', 'e', };
const TInt charForPinyin474[116] = {
	0x4E5F, 0x591C, 0x4E1A, 0x91CE, 0x53F6, 0x7237, 0x9875, 0x6DB2, 0x6396, 0x814B, 0x51B6, 0x564E, 0x8036, 0x54BD, 0x66F3, 0x6930, 
	0x90AA, 0x8C12, 0x90BA, 0x6654, 0x70E8, 0x63F6, 0x94D8, 0x9765, 0x4EAA, 0x4EB1, 0x503B, 0x505E, 0x50F7, 0x5414, 0x5558, 0x559D, 
	0x5622, 0x5688, 0x57DC, 0x5828, 0x5885, 0x58B7, 0x58C4, 0x5C04, 0x5CEB, 0x5DAA, 0x5DAB, 0x61D5, 0x62B4, 0x62FD, 0x6353, 0x6359, 
	0x63DE, 0x63F2, 0x64D6, 0x64DB, 0x64E8, 0x64EA, 0x64EB, 0x659C, 0x668D, 0x66C4, 0x66C5, 0x66D7, 0x6792, 0x67BC, 0x67BD, 0x696A, 
	0x696D, 0x6B4B, 0x6B95, 0x6B97, 0x6D02, 0x6D07, 0x6D82, 0x6F1C, 0x6F71, 0x6FB2, 0x7160, 0x7180, 0x71C1, 0x7217, 0x723A, 0x74DB, 
	0x75F7, 0x76A3, 0x77B1, 0x77B8, 0x790F, 0x7AAB, 0x7DE4, 0x8042, 0x8076, 0x837C, 0x8449, 0x8675, 0x882E, 0x8831, 0x8B01, 0x9113, 
	0x9134, 0x91F6, 0x91FE, 0x92E3, 0x9371, 0x9381, 0x9391, 0x9437, 0x9768, 0x9801, 0x9918, 0x9923, 0x9941, 0x9950, 0x9980, 0x998C, 
	0x9A5C, 0x9D7A, 0x9E08, 0x9EE6
	};
const TText16 KPinyin475[3] = {'y', 'e', 'n', };
const TInt charForPinyin475[2] = {
	0x5C83, 0x81B6
	};
const TText16 KPinyin476[2] = {'y', 'i', };
const TInt charForPinyin476[469] = {
	0x4E00, 0x4EE5, 0x5DF2, 0x4EBF, 0x8863, 0x79FB, 0x4F9D, 0x6613, 0x533B, 0x4E59, 0x4EEA, 0x4EA6, 0x6905, 0x76CA, 0x501A, 0x59E8, 
	0x7FFC, 0x8BD1, 0x4F0A, 0x86C7, 0x9057, 0x98DF, 0x827E, 0x80F0, 0x7591, 0x6C82, 0x5B9C, 0x5F02, 0x5F5D, 0x58F9, 0x8681, 0x8C0A, 
	0x63D6, 0x94F1, 0x77E3, 0x7FCC, 0x827A, 0x6291, 0x7ECE, 0x9091, 0x86FE, 0x5C79, 0x5C3E, 0x5F79, 0x81C6, 0x9038, 0x8084, 0x75AB, 
	0x9890, 0x88D4, 0x610F, 0x6BC5, 0x5FC6, 0x4E49, 0x5937, 0x6EA2, 0x8BE3, 0x8BAE, 0x603F, 0x75CD, 0x9552, 0x7654, 0x6021, 0x9A7F, 
	0x65D6, 0x71A0, 0x914F, 0x7FCA, 0x6B39, 0x5CC4, 0x572F, 0x6BAA, 0x55CC, 0x54A6, 0x61FF, 0x566B, 0x5293, 0x8BD2, 0x9974, 0x6F2A, 
	0x4F5A, 0x54BF, 0x7617, 0x7317, 0x7719, 0x7FBF, 0x5F08, 0x82E1, 0x8351, 0x4EE1, 0x4F7E, 0x8D3B, 0x9487, 0x7F22, 0x8FE4, 0x5208, 
	0x6092, 0x9EDF, 0x7FF3, 0x5F0B, 0x5955, 0x8734, 0x57F8, 0x6339, 0x5DB7, 0x858F, 0x5453, 0x8F76, 0x9571, 0x8223, 0x4E3F, 0x4E41, 
	0x4E42, 0x4E5F, 0x4E84, 0x4F07, 0x4F3F, 0x4F41, 0x4F57, 0x4F87, 0x4FCB, 0x506F, 0x5100, 0x5104, 0x5117, 0x517F, 0x519D, 0x52AE, 
	0x52DA, 0x52E9, 0x5307, 0x531C, 0x5370, 0x53C6, 0x53D5, 0x53F0, 0x53F9, 0x541A, 0x542C, 0x546D, 0x5479, 0x5508, 0x564E, 0x56C8, 
	0x571B, 0x572A, 0x5744, 0x5768, 0x57BC, 0x57F6, 0x58BF, 0x58F1, 0x5901, 0x5915, 0x5931, 0x5947, 0x59B7, 0x59EC, 0x5A90, 0x5AD5, 
	0x5ADB, 0x5B04, 0x5B11, 0x5B1F, 0x5B74, 0x5B83, 0x5B90, 0x5BA7, 0x5BF1, 0x5BF2, 0x5C04, 0x5CD3, 0x5D0E, 0x5D3A, 0x5DA7, 0x5DAC, 
	0x5DF3, 0x5DF8, 0x5E1F, 0x5E20, 0x5E46, 0x5EA1, 0x5ED9, 0x5F0C, 0x5F2C, 0x5F5B, 0x5F5C, 0x5F5E, 0x5F75, 0x5FD4, 0x6008, 0x6020, 
	0x605E, 0x6098, 0x60A5, 0x61B6, 0x61CC, 0x623A, 0x6245, 0x6246, 0x6261, 0x62E9, 0x62F8, 0x638E, 0x639C, 0x640B, 0x6424, 0x648E, 
	0x64C7, 0x653A, 0x6561, 0x657C, 0x6581, 0x65BD, 0x65D1, 0x6633, 0x6679, 0x6686, 0x66C0, 0x66CE, 0x66F5, 0x6759, 0x675D, 0x678D, 
	0x67BB, 0x67C2, 0x6818, 0x6827, 0x683A, 0x684B, 0x68ED, 0x692C, 0x6938, 0x698F, 0x69F7, 0x69F8, 0x6A34, 0x6A8D, 0x6AA5, 0x6AB9, 
	0x6AC2, 0x6B25, 0x6B2D, 0x6B56, 0x6B5D, 0x6B94, 0x6BB9, 0x6BC9, 0x6C7D, 0x6CB6, 0x6CBB, 0x6CC4, 0x6CC6, 0x6D22, 0x6D29, 0x6D2B, 
	0x6D42, 0x6D65, 0x6D73, 0x6E2B, 0x6E59, 0x6F69, 0x6FA4, 0x6FBA, 0x7037, 0x7088, 0x7109, 0x712C, 0x7131, 0x7132, 0x7188, 0x7199, 
	0x71A4, 0x71AA, 0x71BC, 0x71DA, 0x71E1, 0x71F1, 0x7284, 0x72CB, 0x72CF, 0x7348, 0x73B4, 0x73C6, 0x747F, 0x74F5, 0x7569, 0x7570, 
	0x7599, 0x75EC, 0x761E, 0x7631, 0x776A, 0x7796, 0x786A, 0x7912, 0x7919, 0x794E, 0x7995, 0x79C7, 0x7A26, 0x7A53, 0x7AE9, 0x7B16, 
	0x7BB7, 0x7C03, 0x7C4E, 0x7D32, 0x7D4F, 0x7DAD, 0x7DBA, 0x7E0A, 0x7E44, 0x7E76, 0x7E79, 0x7EC1, 0x7EEE, 0x7EF4, 0x7F9B, 0x7FA0, 
	0x7FA1, 0x7FA8, 0x7FA9, 0x801B, 0x8034, 0x808A, 0x8189, 0x8257, 0x8264, 0x8285, 0x82C5, 0x82E2, 0x8413, 0x841F, 0x84FA, 0x85D9, 
	0x85DD, 0x8619, 0x8649, 0x86DC, 0x86E1, 0x86E6, 0x8794, 0x8798, 0x87A0, 0x87FB, 0x8864, 0x886A, 0x8875, 0x8882, 0x8886, 0x8898, 
	0x88A3, 0x88DB, 0x88FF, 0x8918, 0x8939, 0x8957, 0x897C, 0x89FA, 0x8A11, 0x8A32, 0x8A33, 0x8A4D, 0x8A51, 0x8A52, 0x8A63, 0x8A83, 
	0x8A92, 0x8ABC, 0x8B1A, 0x8B3B, 0x8B69, 0x8B6F, 0x8B70, 0x8B7A, 0x8B89, 0x8B9B, 0x8BF6, 0x8C25, 0x8C59, 0x8C5B, 0x8C77, 0x8C96, 
	0x8CA4, 0x8CBD, 0x8CF9, 0x8D00, 0x8DC7, 0x8DE0, 0x8E26, 0x8EFC, 0x8F17, 0x8F22, 0x8F59, 0x8FA5, 0x8FB7, 0x8FC6, 0x8FED, 0x8FF1, 
	0x8FFB, 0x9018, 0x907A, 0x90FC, 0x91AB, 0x91B3, 0x91B7, 0x91CA, 0x91CB, 0x91D4, 0x91F4, 0x91F6, 0x9218, 0x9220, 0x9247, 0x9248, 
	0x926F, 0x9295, 0x92A5, 0x9321, 0x93B0, 0x93D4, 0x943F, 0x9480, 0x94CA, 0x951C, 0x9623, 0x9624, 0x9641, 0x966D, 0x96B6, 0x96BF, 
	0x96C9, 0x9705, 0x972C, 0x9749, 0x977E, 0x9809, 0x9824, 0x9825, 0x984A, 0x9857, 0x98F4, 0x9950, 0x99C5, 0x9A5B, 0x9AAE, 0x9BA7, 
	0x9BA8, 0x9BE3, 0x9CE6, 0x9D3A, 0x9D82, 0x9D83, 0x9D8D, 0x9DC1, 0x9DCA, 0x9DD6, 0x9DE7, 0x9DFE, 0x9E03, 0x9E5D, 0x9E62, 0x9E65, 
	0x9ED3, 0x9EDD, 0x9EF3, 0x9F6E, 0x9F78
	};
const TText16 KPinyin477[3] = {'y', 'i', 'n', };
const TInt charForPinyin477[163] = {
	0x56E0, 0x5F15, 0x5370, 0x94F6, 0x97F3, 0x996E, 0x9634, 0x9690, 0x836B, 0x541F, 0x5C39, 0x5BC5, 0x8335, 0x6DEB, 0x6BB7, 0x59FB, 
	0x70DF, 0x5819, 0x911E, 0x5591, 0x5924, 0x80E4, 0x9F88, 0x5432, 0x573B, 0x72FA, 0x57A0, 0x972A, 0x8693, 0x6C24, 0x94DF, 0x7AA8, 
	0x763E, 0x6D07, 0x831A, 0x4E51, 0x4E5A, 0x4F12, 0x4F17, 0x4F8C, 0x50BF, 0x5198, 0x51D0, 0x542C, 0x552B, 0x5656, 0x567E, 0x569A, 
	0x56D9, 0x5701, 0x5794, 0x57A6, 0x57BD, 0x5837, 0x58F9, 0x5A63, 0x5A6C, 0x5CFE, 0x5D1F, 0x5D2F, 0x5DBE, 0x5E01, 0x5ED5, 0x5EF4, 
	0x6114, 0x6147, 0x616D, 0x6196, 0x6197, 0x61DA, 0x65A6, 0x6704, 0x6836, 0x6880, 0x6A83, 0x6AAD, 0x6ABC, 0x6AFD, 0x6B2D, 0x6B3D, 
	0x6B45, 0x6BA5, 0x6C82, 0x6CFF, 0x6D15, 0x6D54, 0x6DFE, 0x6E5A, 0x6EB5, 0x6EDB, 0x6F6D, 0x6F6F, 0x6FE5, 0x6FE6, 0x70CE, 0x72BE, 
	0x730C, 0x73AA, 0x73E2, 0x748C, 0x7616, 0x764A, 0x766E, 0x784D, 0x7892, 0x78E4, 0x798B, 0x79F5, 0x7B43, 0x7C8C, 0x7D6A, 0x7DF8, 
	0x7E2F, 0x82A9, 0x82C2, 0x8376, 0x8491, 0x8529, 0x852D, 0x861F, 0x87BE, 0x87EB, 0x88C0, 0x8A00, 0x8A14, 0x8A1A, 0x8A21, 0x8A22, 
	0x8ABE, 0x8AF2, 0x8B94, 0x8D7A, 0x8D9B, 0x8F11, 0x9153, 0x9173, 0x91FF, 0x920F, 0x921D, 0x9280, 0x92A6, 0x95C7, 0x95C9, 0x9625, 
	0x9670, 0x967B, 0x9682, 0x96A0, 0x96B1, 0x9712, 0x9720, 0x9777, 0x9787, 0x97FE, 0x98EE, 0x98F2, 0x99F0, 0x9A83, 0x9BA3, 0x9DE3, 
	0x9F57, 0x9F66, 0x9F82
	};
const TText16 KPinyin478[4] = {'y', 'i', 'n', 'g', };
const TInt charForPinyin478[159] = {
	0x5E94, 0x786C, 0x5F71, 0x8425, 0x8FCE, 0x6620, 0x8747, 0x8D62, 0x9E70, 0x82F1, 0x9896, 0x83B9, 0x76C8, 0x5A74, 0x6A31, 0x7F28, 
	0x8367, 0x8424, 0x8426, 0x6979, 0x84E5, 0x763F, 0x8314, 0x9E66, 0x5AB5, 0x83BA, 0x748E, 0x90E2, 0x5624, 0x6484, 0x745B, 0x6EE2, 
	0x6F46, 0x5B34, 0x7F42, 0x701B, 0x81BA, 0x8365, 0x988D, 0x4FD3, 0x5040, 0x50CC, 0x54FD, 0x5568, 0x55B6, 0x565F, 0x56B6, 0x584B, 
	0x5903, 0x592E, 0x5A96, 0x5AC8, 0x5B30, 0x5B46, 0x5B7E, 0x5D64, 0x5DC6, 0x5DCA, 0x5EEE, 0x5FDC, 0x6125, 0x61C9, 0x646C, 0x650D, 
	0x6516, 0x651A, 0x65F2, 0x666F, 0x668E, 0x6720, 0x67CD, 0x685C, 0x686F, 0x68AC, 0x6AFB, 0x6AFF, 0x6CC2, 0x6D67, 0x6E36, 0x6E81, 
	0x6E8B, 0x6ECE, 0x6F41, 0x6FD9, 0x6FDA, 0x6FF4, 0x7005, 0x7020, 0x702F, 0x7034, 0x7050, 0x705C, 0x7138, 0x7150, 0x7192, 0x71DF, 
	0x73F1, 0x7469, 0x74D4, 0x7507, 0x7516, 0x7538, 0x766D, 0x76C1, 0x770F, 0x77E8, 0x78A4, 0x792F, 0x7A4E, 0x7C5D, 0x7C6F, 0x7DD3, 
	0x7E04, 0x7E08, 0x7E69, 0x7E93, 0x7EEC, 0x7EF3, 0x7F43, 0x7F4C, 0x803A, 0x81A1, 0x8396, 0x843E, 0x85C0, 0x8621, 0x86CD, 0x8767, 
	0x877F, 0x87A2, 0x8805, 0x8833, 0x892E, 0x89AE, 0x8B0D, 0x8B4D, 0x8B7B, 0x8CCF, 0x8D0F, 0x8EC8, 0x901E, 0x93A3, 0x941B, 0x944D, 
	0x9533, 0x9719, 0x9795, 0x97F9, 0x97FA, 0x9834, 0x9895, 0x9C66, 0x9D2C, 0x9DA7, 0x9DAF, 0x9DEA, 0x9DF9, 0x9E0E, 0x9E1A
	};
const TText16 KPinyin479[2] = {'y', 'o', };
const TInt charForPinyin479[5] = {
	0x54DF, 0x80B2, 0x5537, 0x55B2, 0x569B
	};
const TText16 KPinyin480[4] = {'y', 'o', 'n', 'g', };
const TInt charForPinyin480[79] = {
	0x7528, 0x6D8C, 0x6C38, 0x62E5, 0x86F9, 0x52C7, 0x96CD, 0x548F, 0x6CF3, 0x4F63, 0x8E0A, 0x75C8, 0x5EB8, 0x81C3, 0x607F, 0x58C5, 
	0x6175, 0x4FD1, 0x5889, 0x9CD9, 0x9095, 0x5581, 0x752C, 0x9954, 0x955B, 0x509B, 0x50AD, 0x52C8, 0x55C8, 0x5670, 0x57C7, 0x584E, 
	0x5ADE, 0x5BB9, 0x5D71, 0x5EF1, 0x5F6E, 0x603A, 0x6080, 0x60E5, 0x6111, 0x6139, 0x6142, 0x63D8, 0x64C1, 0x67E1, 0x6810, 0x69E6, 
	0x6E67, 0x6EFD, 0x6FAD, 0x7049, 0x7245, 0x7655, 0x7670, 0x783D, 0x7867, 0x799C, 0x7B69, 0x81FE, 0x82DA, 0x848F, 0x8579, 0x8A60, 
	0x8E34, 0x9047, 0x90FA, 0x9118, 0x919F, 0x92BF, 0x93DE, 0x96DD, 0x9852, 0x9899, 0x9BD2, 0x9C2B, 0x9C45, 0x9CAC, 0x9DDB
	};
const TText16 KPinyin481[3] = {'y', 'o', 'u', };
const TInt charForPinyin481[139] = {
	0x6709, 0x53C8, 0x7531, 0x53F3, 0x6CB9, 0x6E38, 0x5E7C, 0x4F18, 0x53CB, 0x94C0, 0x5FE7, 0x5C24, 0x72B9, 0x8BF1, 0x60A0, 0x90AE, 
	0x9149, 0x4F51, 0x91C9, 0x5E7D, 0x75A3, 0x6538, 0x86B0, 0x83A0, 0x9C7F, 0x5363, 0x9EDD, 0x83B8, 0x7337, 0x86B4, 0x5BA5, 0x7256, 
	0x56FF, 0x67DA, 0x8763, 0x839C, 0x9F2C, 0x94D5, 0x8764, 0x7E47, 0x5466, 0x4F91, 0x4E23, 0x4EB4, 0x5064, 0x512A, 0x5198, 0x53F9, 
	0x54CA, 0x5500, 0x5698, 0x5773, 0x5965, 0x598B, 0x59F7, 0x5B67, 0x5C22, 0x5C23, 0x5CDF, 0x5CF3, 0x5EAE, 0x601E, 0x6023, 0x602E, 
	0x6182, 0x61EE, 0x622D, 0x6270, 0x63C2, 0x63C4, 0x65BF, 0x682F, 0x6884, 0x688E, 0x6962, 0x69F1, 0x6ACC, 0x6AFE, 0x6C53, 0x6C7C, 
	0x6C8B, 0x6CC5, 0x6CC8, 0x6CD1, 0x6D5F, 0x6E75, 0x6EFA, 0x7000, 0x7257, 0x7270, 0x72D6, 0x7336, 0x7376, 0x7534, 0x75CF, 0x7950, 
	0x7989, 0x79DE, 0x7CFF, 0x7E8B, 0x7F90, 0x7F91, 0x7F97, 0x8030, 0x8048, 0x8071, 0x80AC, 0x811C, 0x8129, 0x82C3, 0x83A4, 0x848F, 
	0x8555, 0x8698, 0x870F, 0x890E, 0x890F, 0x8A27, 0x8A98, 0x8C81, 0x8F0F, 0x8F36, 0x8FF6, 0x900C, 0x9030, 0x904A, 0x908E, 0x90F5, 
	0x913E, 0x916D, 0x923E, 0x92AA, 0x92B9, 0x9508, 0x99C0, 0x9B77, 0x9B8B, 0x9C89, 0x9E80
	};
const TText16 KPinyin482[2] = {'y', 'u', };
const TInt charForPinyin482[347] = {
	0x4E0E, 0x4E8E, 0x6B32, 0x9C7C, 0x96E8, 0x4F59, 0x9047, 0x8BED, 0x6108, 0x72F1, 0x7389, 0x6E14, 0x4E88, 0x8A89, 0x80B2, 0x611A, 
	0x7FBD, 0x865E, 0x5A31, 0x6DE4, 0x8206, 0x5C7F, 0x79B9, 0x5B87, 0x8FC2, 0x4FDE, 0x903E, 0x57DF, 0x828B, 0x90C1, 0x8C37, 0x5401, 
	0x76C2, 0x55BB, 0x5CEA, 0x5FA1, 0x6109, 0x7CA5, 0x6E1D, 0x5C09, 0x6986, 0x9685, 0x6D74, 0x5BD3, 0x88D5, 0x9884, 0x8C6B, 0x9A6D, 
	0x851A, 0x59AA, 0x5D5B, 0x96E9, 0x9980, 0x9608, 0x7AAC, 0x9E46, 0x59A4, 0x63C4, 0x7AB3, 0x89CE, 0x81FE, 0x8201, 0x9F89, 0x84E3, 
	0x715C, 0x94B0, 0x8C00, 0x7EA1, 0x65BC, 0x7AFD, 0x745C, 0x79BA, 0x807F, 0x6B24, 0x4FE3, 0x4F1B, 0x5704, 0x9E6C, 0x5EBE, 0x6631, 
	0x8438, 0x7610, 0x8C15, 0x9B3B, 0x5709, 0x7600, 0x71A8, 0x996B, 0x6BD3, 0x71E0, 0x8174, 0x72F3, 0x83C0, 0x872E, 0x8753, 0x4E02, 
	0x4E8F, 0x4E90, 0x4F03, 0x4FC1, 0x4FFC, 0x504A, 0x50B4, 0x50EA, 0x5125, 0x516A, 0x532C, 0x53DE, 0x5433, 0x543E, 0x5537, 0x5539, 
	0x5581, 0x5585, 0x5590, 0x55A9, 0x564A, 0x5662, 0x5673, 0x572B, 0x5809, 0x5823, 0x582C, 0x58BA, 0x5915, 0x5965, 0x5A1B, 0x5A2A, 
	0x5A2F, 0x5A7E, 0x5A80, 0x5AAE, 0x5AD7, 0x5B29, 0x5B9B, 0x5BD9, 0x5CFF, 0x5D1B, 0x5D33, 0x5D4E, 0x5D8E, 0x5DBC, 0x5EBD, 0x5F67, 
	0x5FEC, 0x6086, 0x6087, 0x60CC, 0x60D0, 0x617E, 0x61CA, 0x61D9, 0x6216, 0x622B, 0x625C, 0x6275, 0x62D7, 0x6327, 0x6353, 0x6554, 
	0x6594, 0x659E, 0x65DF, 0x6619, 0x6745, 0x6829, 0x682F, 0x6859, 0x68A7, 0x68DB, 0x68DC, 0x68EB, 0x6940, 0x6961, 0x6970, 0x6AF2, 
	0x6B0E, 0x6B1D, 0x6B48, 0x6B5F, 0x6B76, 0x6C59, 0x6C5A, 0x6C61, 0x6C69, 0x6DE2, 0x6DEF, 0x6E61, 0x6EEA, 0x6F01, 0x6F9A, 0x6F9E, 
	0x6FA6, 0x6FB3, 0x706A, 0x7079, 0x7134, 0x7168, 0x71CF, 0x71F0, 0x7229, 0x724F, 0x7344, 0x735D, 0x738B, 0x7397, 0x7399, 0x7419, 
	0x741F, 0x7440, 0x74B5, 0x756C, 0x756D, 0x75CF, 0x7609, 0x7652, 0x76D3, 0x776E, 0x77DE, 0x7821, 0x7862, 0x7907, 0x7916, 0x791C, 
	0x7964, 0x79A6, 0x79D7, 0x7A22, 0x7A36, 0x7A65, 0x7A7B, 0x7B8A, 0x7BFD, 0x7C45, 0x7C5E, 0x7C72, 0x7D06, 0x7DCE, 0x7E58, 0x7F6D, 
	0x7FAD, 0x7FD1, 0x8167, 0x8207, 0x8212, 0x8245, 0x828C, 0x82D1, 0x831F, 0x8330, 0x8362, 0x83F8, 0x842D, 0x842E, 0x84AE, 0x84F9, 
	0x854D, 0x8577, 0x8581, 0x85C7, 0x860C, 0x861B, 0x8676, 0x870D, 0x871F, 0x877A, 0x87B8, 0x87C8, 0x8858, 0x8859, 0x8867, 0x88AC, 
	0x8915, 0x89A6, 0x8A9E, 0x8ADB, 0x8AED, 0x8B23, 0x8B7D, 0x8C8D, 0x8C90, 0x8C97, 0x8E30, 0x8EC9, 0x8F0D, 0x8F3F, 0x8F5D, 0x8FC3, 
	0x9033, 0x9079, 0x9098, 0x90DA, 0x9105, 0x9151, 0x91A7, 0x91EA, 0x923A, 0x9289, 0x92CA, 0x92D9, 0x9325, 0x935D, 0x940D, 0x942D, 
	0x94FB, 0x95BC, 0x95BE, 0x960F, 0x9653, 0x9683, 0x96A9, 0x96D3, 0x9731, 0x9810, 0x9828, 0x9852, 0x9899, 0x98EB, 0x9918, 0x9947, 
	0x99AD, 0x9A1F, 0x9A48, 0x9AAC, 0x9AC3, 0x9B30, 0x9B31, 0x9B4A, 0x9B5A, 0x9B63, 0x9BBD, 0x9BF2, 0x9C05, 0x9C4A, 0x9C6E, 0x9CFF, 
	0x9D25, 0x9D27, 0x9D2A, 0x9D52, 0x9DE0, 0x9DF8, 0x9E06, 0x9E12, 0x9E8C, 0x9F6C, 0x9F75
	};
const TText16 KPinyin483[4] = {'y', 'u', 'a', 'n', };
const TInt charForPinyin483[131] = {
	0x8FDC, 0x5458, 0x5143, 0x9662, 0x5706, 0x539F, 0x613F, 0x56ED, 0x63F4, 0x733F, 0x6028, 0x51A4, 0x6E90, 0x7F18, 0x8881, 0x6E0A, 
	0x82D1, 0x57A3, 0x9E33, 0x8F95, 0x571C, 0x9F0B, 0x6A7C, 0x5A9B, 0x7230, 0x7722, 0x9E22, 0x63BE, 0x82AB, 0x6C85, 0x7457, 0x8788, 
	0x7BA2, 0x586C, 0x57B8, 0x5086, 0x5141, 0x5248, 0x53A1, 0x53B5, 0x54BD, 0x54E1, 0x559B, 0x566E, 0x56E6, 0x570E, 0x5712, 0x5713, 
	0x5917, 0x59A7, 0x59B4, 0x5AB4, 0x5AC4, 0x5ADA, 0x5B3D, 0x5B9B, 0x5BC3, 0x5F32, 0x6081, 0x60CC, 0x6350, 0x676C, 0x68E9, 0x6965, 
	0x699E, 0x69AC, 0x6ADE, 0x6D93, 0x6DB4, 0x6DF5, 0x6E01, 0x6E06, 0x6E15, 0x6E72, 0x6E92, 0x7041, 0x7106, 0x7328, 0x7342, 0x76F6, 
	0x7990, 0x7A7F, 0x7B0E, 0x7DE3, 0x7E01, 0x7FB1, 0x8099, 0x847E, 0x849D, 0x84AC, 0x8597, 0x85B3, 0x8696, 0x870E, 0x8735, 0x875D, 
	0x876F, 0x884F, 0x88EB, 0x88F7, 0x8911, 0x8924, 0x8B1C, 0x8C9F, 0x8D20, 0x8F10, 0x8F45, 0x903A, 0x9060, 0x908D, 0x90A7, 0x915B, 
	0x9228, 0x92FA, 0x93B1, 0x962E, 0x9668, 0x9695, 0x9858, 0x99CC, 0x9A35, 0x9B6D, 0x9CF6, 0x9D1B, 0x9D77, 0x9DA2, 0x9DB0, 0x9E53, 
	0x9EFF, 0x9F18, 0x9F1D
	};
const TText16 KPinyin484[3] = {'y', 'u', 'e', };
const TInt charForPinyin484[87] = {
	0x6708, 0x8D8A, 0x7EA6, 0x8DC3, 0x9605, 0x4E50, 0x5CB3, 0x60A6, 0x66F0, 0x8BF4, 0x7CA4, 0x94A5, 0x7039, 0x94BA, 0x5216, 0x9FA0, 
	0x680E, 0x6A3E, 0x54D5, 0x54FE, 0x5666, 0x56DD, 0x5757, 0x5981, 0x599C, 0x5B33, 0x5C84, 0x5DBD, 0x5F5F, 0x5F60, 0x6071, 0x6085, 
	0x6209, 0x625A, 0x6288, 0x6373, 0x64FD, 0x66F1, 0x6782, 0x6ADF, 0x6C4B, 0x70C1, 0x7106, 0x720D, 0x721A, 0x73A5, 0x77C6, 0x77F1, 
	0x793F, 0x79B4, 0x7BB9, 0x7BD7, 0x7C46, 0x7C65, 0x7C70, 0x7CB5, 0x7D04, 0x81D2, 0x836F, 0x8625, 0x868E, 0x868F, 0x86FB, 0x8715, 
	0x8816, 0x8AAA, 0x8AAC, 0x8DAF, 0x8DC0, 0x8DDE, 0x8E8D, 0x8E92, 0x8ECF, 0x9205, 0x925E, 0x92B3, 0x92ED, 0x9460, 0x94C4, 0x9510, 
	0x95B1, 0x95B2, 0x9AFA, 0x9E11, 0x9E19, 0x9EE6, 0x9FA5
	};
const TText16 KPinyin485[3] = {'y', 'u', 'g', };
const TInt charForPinyin485[1] = {
	0x5590
	};
const TText16 KPinyin486[3] = {'y', 'u', 'n', };
const TInt charForPinyin486[126] = {
	0x4E91, 0x8FD0, 0x6655, 0x5141, 0x5300, 0x97F5, 0x9668, 0x5B55, 0x8018, 0x8574, 0x915D, 0x90E7, 0x5458, 0x6C32, 0x607D, 0x6120, 
	0x90D3, 0x82B8, 0x7B60, 0x97EB, 0x6600, 0x72C1, 0x6B92, 0x7EAD, 0x71A8, 0x4F1D, 0x508A, 0x52FB, 0x53DE, 0x544D, 0x54E1, 0x5597, 
	0x56E9, 0x5747, 0x593D, 0x596B, 0x5998, 0x5AAA, 0x5ABC, 0x5C09, 0x5C39, 0x6028, 0x60F2, 0x612A, 0x614D, 0x628E, 0x62A3, 0x6688, 
	0x679F, 0x6985, 0x6A02, 0x6A52, 0x6B9E, 0x6C33, 0x6C84, 0x6D92, 0x6DA2, 0x6E29, 0x6EB3, 0x6F90, 0x7147, 0x7174, 0x717E, 0x7185, 
	0x7189, 0x73A7, 0x7547, 0x761F, 0x76FE, 0x7703, 0x78D2, 0x79D0, 0x7B4D, 0x7B7C, 0x7BD4, 0x7D1C, 0x7DF7, 0x7DFC, 0x7E15, 0x7E1C, 
	0x7E67, 0x7F0A, 0x803A, 0x816A, 0x82D1, 0x837A, 0x83C0, 0x8480, 0x8495, 0x84B7, 0x8553, 0x8570, 0x8580, 0x85F4, 0x860A, 0x8735, 
	0x8779, 0x891E, 0x8C9F, 0x8CF1, 0x8D07, 0x8D20, 0x8D5F, 0x8F3C, 0x8F40, 0x8F92, 0x904B, 0x9106, 0x9116, 0x9196, 0x919E, 0x9217, 
	0x92C6, 0x962D, 0x9695, 0x96F2, 0x9723, 0x97D7, 0x97DE, 0x97FB, 0x9835, 0x992B, 0x99A7, 0x99BB, 0x9F6B, 0x9F73
	};
const TText16 KPinyin487[2] = {'z', 'a', };
const TInt charForPinyin487[35] = {
	0x6742, 0x7838, 0x548B, 0x531D, 0x624E, 0x54B1, 0x5482, 0x62F6, 0x5548, 0x5550, 0x5592, 0x5601, 0x5648, 0x56C3, 0x56CB, 0x56D0, 
	0x5E00, 0x685A, 0x6C9E, 0x6CAF, 0x6FFD, 0x7052, 0x78FC, 0x7C74, 0x7D25, 0x7D2E, 0x81DC, 0x81E2, 0x894D, 0x9254, 0x96D1, 0x96DC, 
	0x96E5, 0x97F4, 0x9B73
	};
const TText16 KPinyin488[3] = {'z', 'a', 'd', };
const TInt charForPinyin488[1] = {
	0x66F1
	};
const TText16 KPinyin489[3] = {'z', 'a', 'i', };
const TInt charForPinyin489[25] = {
	0x5728, 0x518D, 0x707E, 0x8F7D, 0x683D, 0x5BB0, 0x54C9, 0x753E, 0x5D3D, 0x4ED4, 0x50A4, 0x510E, 0x624D, 0x6257, 0x6D05, 0x6E3D, 
	0x6EA8, 0x707D, 0x70D6, 0x7775, 0x7E21, 0x83D1, 0x8CF3, 0x8F09, 0x9168
	};
const TText16 KPinyin490[3] = {'z', 'a', 'n', };
const TInt charForPinyin490[50] = {
	0x54B1, 0x6682, 0x6512, 0x8D5E, 0x7C2A, 0x8DB1, 0x7CCC, 0x74D2, 0x62F6, 0x661D, 0x933E, 0x507A, 0x5127, 0x5139, 0x5142, 0x5592, 
	0x56CB, 0x5BC1, 0x63DD, 0x648D, 0x6522, 0x66AB, 0x685A, 0x6D94, 0x6E54, 0x6FFA, 0x6FFD, 0x7052, 0x74C9, 0x74DA, 0x79B6, 0x7A73, 
	0x7BF8, 0x7C2E, 0x81E2, 0x8978, 0x8B83, 0x8B9A, 0x8CDB, 0x8D0A, 0x8DB2, 0x8E54, 0x913C, 0x9142, 0x9147, 0x93E8, 0x93E9, 0x9415, 
	0x941F, 0x9961
	};
const TText16 KPinyin491[4] = {'z', 'a', 'n', 'g', };
const TInt charForPinyin491[25] = {
	0x810F, 0x846C, 0x8D43, 0x85CF, 0x5958, 0x81E7, 0x9A75, 0x5328, 0x585F, 0x5F09, 0x6215, 0x7242, 0x726B, 0x7F98, 0x81D3, 0x81DF, 
	0x8535, 0x8CCD, 0x8CD8, 0x8D13, 0x8D1C, 0x92BA, 0x99D4, 0x9A61, 0x9AD2
	};
const TText16 KPinyin492[3] = {'z', 'a', 'o', };
const TInt charForPinyin492[44] = {
	0x65E9, 0x9020, 0x906D, 0x7CDF, 0x7076, 0x71E5, 0x67A3, 0x51FF, 0x8E81, 0x85FB, 0x7682, 0x566A, 0x6FA1, 0x86A4, 0x5523, 0x50AE, 
	0x5515, 0x55BF, 0x6165, 0x6806, 0x688D, 0x68D7, 0x69FD, 0x7170, 0x7485, 0x74AA, 0x7681, 0x7A96, 0x7AC3, 0x7AC8, 0x7C09, 0x7E45, 
	0x7E70, 0x7F2B, 0x7F32, 0x8241, 0x8349, 0x85BB, 0x8B32, 0x8B5F, 0x8DAE, 0x8E67, 0x91A9, 0x947F
	};
const TText16 KPinyin493[2] = {'z', 'e', };
const TInt charForPinyin493[70] = {
	0x5219, 0x8D23, 0x62E9, 0x6CFD, 0x548B, 0x4FA7, 0x7BA6, 0x8234, 0x5E3B, 0x8FEE, 0x5567, 0x4EC4, 0x6603, 0x7B2E, 0x8D5C, 0x4F2C, 
	0x5074, 0x5247, 0x5395, 0x53A0, 0x5536, 0x556B, 0x5616, 0x5928, 0x5AE7, 0x5D31, 0x5E58, 0x5E82, 0x5EC1, 0x629E, 0x6351, 0x63AA, 
	0x64C7, 0x6617, 0x67DE, 0x6A0D, 0x6B75, 0x6C44, 0x6CA2, 0x6CCE, 0x6EAD, 0x6EDC, 0x6FA4, 0x7042, 0x769F, 0x776A, 0x7794, 0x77E0, 
	0x790B, 0x7A04, 0x7A37, 0x7C00, 0x802B, 0x841A, 0x8443, 0x8536, 0x8600, 0x880C, 0x8957, 0x8ACE, 0x8B2B, 0x8B2E, 0x8B81, 0x8C2A, 
	0x8CAC, 0x8CFE, 0x98F5, 0x9E05, 0x9F5A, 0x9F70
	};
const TText16 KPinyin494[3] = {'z', 'e', 'i', };
const TInt charForPinyin494[8] = {
	0x8D3C, 0x8808, 0x8CCA, 0x9BFD, 0x9C02, 0x9C61, 0x9C97, 0x9CAB
	};
const TText16 KPinyin495[3] = {'z', 'e', 'n', };
const TInt charForPinyin495[7] = {
	0x600E, 0x8C2E, 0x50ED, 0x56CE, 0x648D, 0x8B56, 0x8B5B
	};
const TText16 KPinyin496[4] = {'z', 'e', 'n', 'g', };
const TInt charForPinyin496[25] = {
	0x589E, 0x8D60, 0x618E, 0x66FE, 0x7EFC, 0x7F2F, 0x7F7E, 0x7511, 0x9503, 0x5897, 0x66FD, 0x6A67, 0x71B7, 0x7494, 0x77F0, 0x78F3, 
	0x7D9C, 0x7E21, 0x7E52, 0x8B44, 0x8D08, 0x912B, 0x92E5, 0x9B37, 0x9C5B
	};
const TText16 KPinyin497[3] = {'z', 'h', 'a', };
const TInt charForPinyin497[102] = {
	0x624E, 0x70B8, 0x6E23, 0x95F8, 0x7728, 0x69A8, 0x4E4D, 0x8F67, 0x8BC8, 0x94E1, 0x672D, 0x8721, 0x67E5, 0x6805, 0x548B, 0x55B3, 
	0x781F, 0x75C4, 0x5412, 0x54F3, 0x6942, 0x7339, 0x86B1, 0x63F8, 0x558B, 0x67DE, 0x54A4, 0x9F44, 0x505E, 0x5067, 0x518A, 0x518C, 
	0x5273, 0x5284, 0x538F, 0x54C6, 0x55A5, 0x56C3, 0x5953, 0x5BB1, 0x600D, 0x6260, 0x62AF, 0x62C3, 0x6313, 0x633F, 0x63D2, 0x63F7, 
	0x6429, 0x643E, 0x6463, 0x64D6, 0x67E4, 0x67F5, 0x6A1D, 0x6E2B, 0x6EA0, 0x6F73, 0x7079, 0x7160, 0x7250, 0x7534, 0x76B6, 0x76BB, 
	0x7B2E, 0x7B91, 0x7B9A, 0x7D25, 0x7D2E, 0x802B, 0x81AA, 0x82F2, 0x82F4, 0x8516, 0x854F, 0x85F8, 0x86BB, 0x89F0, 0x8A50, 0x8ACE, 
	0x8B2F, 0x8B47, 0x8B57, 0x8E37, 0x8E45, 0x8ECB, 0x8FCA, 0x91A1, 0x9358, 0x9598, 0x9705, 0x97A2, 0x9B93, 0x9BBA, 0x9C08, 0x9C8A, 
	0x9C9D, 0x9CBD, 0x9F47, 0x9F5F, 0x9F70, 0x9F83
	};
const TText16 KPinyin498[4] = {'z', 'h', 'a', 'i', };
const TInt charForPinyin498[42] = {
	0x6458, 0x7A84, 0x503A, 0x658B, 0x5BE8, 0x62E9, 0x7FDF, 0x5B85, 0x4FA7, 0x796D, 0x7826, 0x7635, 0x4E9D, 0x5074, 0x50B5, 0x5387, 
	0x538F, 0x5547, 0x568C, 0x5908, 0x5EA6, 0x62A7, 0x635A, 0x64C7, 0x64FF, 0x658E, 0x67F4, 0x69B8, 0x6AA1, 0x7274, 0x75B5, 0x7BA6, 
	0x7C00, 0x7C82, 0x81AA, 0x8CAC, 0x8D23, 0x9259, 0x99D8, 0x9A80, 0x9AB4, 0x9F4B
	};
const TText16 KPinyin499[4] = {'z', 'h', 'a', 'n', };
const TInt charForPinyin499[96] = {
	0x7AD9, 0x5360, 0x6218, 0x76CF, 0x6CBE, 0x7C98, 0x6BE1, 0x5C55, 0x6808, 0x8A79, 0x98A4, 0x8638, 0x6E5B, 0x7EFD, 0x65A9, 0x8F97, 
	0x5D2D, 0x77BB, 0x8C35, 0x640C, 0x65C3, 0x4EB6, 0x4F54, 0x5061, 0x5661, 0x5AF8, 0x5D41, 0x5D83, 0x5D84, 0x5D98, 0x5DA6, 0x6017, 
	0x60C9, 0x6226, 0x6230, 0x62C3, 0x65AC, 0x65DC, 0x6834, 0x685F, 0x68E7, 0x693E, 0x6990, 0x6A4F, 0x6B03, 0x6C08, 0x6C0A, 0x6E54, 
	0x6FB6, 0x7416, 0x76BD, 0x76DE, 0x788A, 0x7DBB, 0x83DA, 0x859D, 0x8665, 0x8666, 0x86C5, 0x8892, 0x8962, 0x89B1, 0x8A40, 0x8B19, 
	0x8B67, 0x8B6B, 0x8B9D, 0x8C26, 0x8D88, 0x8DD5, 0x8E4D, 0x8E94, 0x8F1A, 0x8F3E, 0x8F4F, 0x9085, 0x9186, 0x91AE, 0x959A, 0x9711, 
	0x98AD, 0x98D0, 0x98E6, 0x9930, 0x9958, 0x9A4F, 0x9A59, 0x9AA3, 0x9B59, 0x9C63, 0x9CE3, 0x9CFD, 0x9E07, 0x9E6F, 0x9EDE, 0x9EF5
	};
const TText16 KPinyin500[5] = {'z', 'h', 'a', 'n', 'g', };
const TInt charForPinyin500[56] = {
	0x5F20, 0x7AE0, 0x957F, 0x5E10, 0x4ED7, 0x4E08, 0x638C, 0x6DA8, 0x8D26, 0x6A1F, 0x6756, 0x5F70, 0x6F33, 0x80C0, 0x7634, 0x969C, 
	0x4EC9, 0x5ADC, 0x5E5B, 0x9123, 0x748B, 0x5D82, 0x7350, 0x87D1, 0x4EE7, 0x50BD, 0x5887, 0x5E33, 0x5E65, 0x5F21, 0x5F35, 0x615E, 
	0x6259, 0x627F, 0x66B2, 0x6DB1, 0x6F32, 0x75EE, 0x762C, 0x7795, 0x7903, 0x7C80, 0x7CBB, 0x8139, 0x8501, 0x8CEC, 0x9067, 0x93F1, 
	0x9423, 0x9577, 0x9578, 0x979D, 0x9926, 0x9A3F, 0x9C46, 0x9E9E
	};
const TText16 KPinyin501[4] = {'z', 'h', 'a', 'o', };
const TInt charForPinyin501[61] = {
	0x627E, 0x7740, 0x7167, 0x62DB, 0x7F69, 0x722A, 0x5146, 0x671D, 0x662D, 0x6CBC, 0x8087, 0x5632, 0x53EC, 0x8D75, 0x68F9, 0x5541, 
	0x948A, 0x7B0A, 0x8BCF, 0x4F4B, 0x5545, 0x5797, 0x59B1, 0x5DF6, 0x65D0, 0x6641, 0x66CC, 0x679B, 0x6843, 0x6AC2, 0x6DD6, 0x6FEF, 
	0x70A4, 0x71F3, 0x722B, 0x72E3, 0x7475, 0x76BD, 0x76C4, 0x77BE, 0x7ABC, 0x7B8C, 0x7F40, 0x7F84, 0x8081, 0x8088, 0x83EC, 0x8457, 
	0x86A4, 0x8A54, 0x8B3F, 0x8D99, 0x91D7, 0x91FD, 0x924A, 0x9363, 0x99CB, 0x9BA1, 0x9CED, 0x9F02, 0x9F0C
	};
const TText16 KPinyin502[3] = {'z', 'h', 'e', };
const TInt charForPinyin502[86] = {
	0x7740, 0x8FD9, 0x8005, 0x6298, 0x906E, 0x86F0, 0x54F2, 0x8517, 0x9517, 0x8F99, 0x6D59, 0x67D8, 0x8F84, 0x8D6D, 0x647A, 0x9E67, 
	0x78D4, 0x8936, 0x8707, 0x8C2A, 0x4E47, 0x4EDB, 0x5387, 0x5560, 0x5586, 0x55EB, 0x55FB, 0x5600, 0x569E, 0x56C1, 0x57D1, 0x5835, 
	0x5AEC, 0x5EB6, 0x608A, 0x6179, 0x6278, 0x6442, 0x6444, 0x651D, 0x65A5, 0x6662, 0x6663, 0x6754, 0x68CF, 0x6A00, 0x6A1C, 0x6B7D, 
	0x6DDB, 0x6F6A, 0x77FA, 0x7813, 0x7C77, 0x7C8D, 0x8037, 0x8042, 0x8051, 0x8076, 0x8674, 0x87C4, 0x87C5, 0x88A9, 0x891A, 0x8975, 
	0x8A5F, 0x8B2B, 0x8B36, 0x8B3A, 0x8B81, 0x8B8B, 0x8EFC, 0x8F12, 0x8F19, 0x8F4D, 0x8F76, 0x9019, 0x9069, 0x92B8, 0x937A, 0x966C, 
	0x99B2, 0x9A5D, 0x9BBF, 0x9DD3, 0x9DD9, 0x9E37
	};
const TText16 KPinyin503[4] = {'z', 'h', 'e', 'i', };
const TInt charForPinyin503[2] = {
	0x8FD9, 0x9019
	};
const TText16 KPinyin504[4] = {'z', 'h', 'e', 'n', };
const TInt charForPinyin504[133] = {
	0x771F, 0x9635, 0x9547, 0x9488, 0x9707, 0x6795, 0x632F, 0x659F, 0x73CD, 0x75B9, 0x8BCA, 0x7504, 0x7827, 0x81FB, 0x8D1E, 0x4FA6, 
	0x7F1C, 0x84C1, 0x796F, 0x7BB4, 0x8F78, 0x699B, 0x7A39, 0x8D48, 0x6715, 0x9E29, 0x80D7, 0x6D48, 0x6862, 0x755B, 0x5733, 0x6939, 
	0x4FB2, 0x5075, 0x5507, 0x576B, 0x5861, 0x5866, 0x586B, 0x59EB, 0x5AC3, 0x5BCA, 0x5C52, 0x5E2A, 0x5F2B, 0x614E, 0x6221, 0x62AE, 
	0x630B, 0x63D5, 0x6438, 0x6552, 0x6576, 0x6623, 0x673E, 0x67AE, 0x6815, 0x681A, 0x686D, 0x6968, 0x6990, 0x69C7, 0x6A3C, 0x6B9D, 
	0x6CB4, 0x6CB5, 0x6E5E, 0x6EB1, 0x6EC7, 0x6F67, 0x6FB5, 0x7349, 0x73CE, 0x7467, 0x7715, 0x771E, 0x7739, 0x78AA, 0x798E, 0x799B, 
	0x7AE7, 0x7C48, 0x7D16, 0x7D3E, 0x7D7C, 0x7E1D, 0x7E25, 0x7EBC, 0x8044, 0x8419, 0x8474, 0x8496, 0x85BD, 0x8704, 0x8897, 0x88D6, 
	0x8999, 0x8A3A, 0x8AAB, 0x8B13, 0x8C9E, 0x8CD1, 0x8D81, 0x8D82, 0x8EEB, 0x8F43, 0x8FB4, 0x8FE7, 0x9049, 0x9156, 0x9159, 0x91DD, 
	0x9202, 0x9241, 0x92F4, 0x9331, 0x9356, 0x937C, 0x93AD, 0x93AE, 0x9663, 0x9673, 0x9755, 0x99D7, 0x9B12, 0x9B9D, 0x9C75, 0x9C9E, 
	0x9D06, 0x9EEE, 0x9EF0, 0x9F0E, 0x9F11
	};
const TText16 KPinyin505[5] = {'z', 'h', 'e', 'n', 'g', };
const TInt charForPinyin505[82] = {
	0x6B63, 0x6574, 0x7741, 0x4E89, 0x6323, 0x5F81, 0x6014, 0x8BC1, 0x5E27, 0x75C7, 0x90D1, 0x62EF, 0x4E01, 0x84B8, 0x72F0, 0x653F, 
	0x5CE5, 0x94B2, 0x94EE, 0x7B5D, 0x8BE4, 0x5FB5, 0x9CAD, 0x4E1E, 0x4F25, 0x4F42, 0x5000, 0x51E7, 0x57E5, 0x57E9, 0x5863, 0x59C3, 
	0x5A9C, 0x5D1D, 0x5D22, 0x5D92, 0x5E40, 0x5F8E, 0x5FB0, 0x5FB4, 0x6138, 0x6195, 0x627F, 0x628D, 0x6399, 0x639F, 0x63C1, 0x649C, 
	0x655E, 0x6678, 0x6B62, 0x6C36, 0x6D67, 0x6E5E, 0x70A1, 0x70DD, 0x722D, 0x7319, 0x753A, 0x7665, 0x7710, 0x775C, 0x77A0, 0x7B8F, 
	0x7BDC, 0x7CFD, 0x7DAA, 0x8047, 0x8100, 0x8A3C, 0x8ACD, 0x8B49, 0x8D9F, 0x8E2D, 0x912D, 0x9266, 0x931A, 0x9B07, 0x9B8F, 0x9BD6, 
	0x9BF9, 0x9D0A
	};
const TText16 KPinyin506[3] = {'z', 'h', 'i', };
const TInt charForPinyin506[308] = {
	0x53EA, 0x4E4B, 0x76F4, 0x77E5, 0x5236, 0x6307, 0x7EB8, 0x652F, 0x829D, 0x679D, 0x7A1A, 0x5431, 0x8718, 0x8D28, 0x80A2, 0x8102, 
	0x6C41, 0x7099, 0x7EC7, 0x804C, 0x75D4, 0x690D, 0x62B5, 0x6B96, 0x6267, 0x503C, 0x4F84, 0x5740, 0x6EDE, 0x6B62, 0x8DBE, 0x6CBB, 
	0x65E8, 0x7A92, 0x5FD7, 0x631A, 0x63B7, 0x81F3, 0x81F4, 0x7F6E, 0x5E1C, 0x8BC6, 0x5CD9, 0x6C0F, 0x667A, 0x79E9, 0x5E19, 0x646D, 
	0x9EF9, 0x684E, 0x67B3, 0x8F75, 0x5FEE, 0x7949, 0x86ED, 0x81A3, 0x89EF, 0x90C5, 0x6800, 0x5F58, 0x82B7, 0x7957, 0x54AB, 0x9E37, 
	0x7D77, 0x8E2C, 0x80DD, 0x9A98, 0x8F7E, 0x75E3, 0x965F, 0x8E2F, 0x96C9, 0x57F4, 0x8D3D, 0x536E, 0x916F, 0x8C78, 0x8DD6, 0x6809, 
	0x4E7F, 0x4E8A, 0x4F0E, 0x4FE7, 0x5001, 0x5024, 0x506B, 0x5082, 0x5128, 0x51EA, 0x526C, 0x5295, 0x52A7, 0x5394, 0x54A5, 0x5694, 
	0x5741, 0x5767, 0x5781, 0x57C3, 0x57F7, 0x5886, 0x588C, 0x5902, 0x591A, 0x591B, 0x59B7, 0x59EA, 0x5A21, 0x5A9E, 0x5B02, 0x5B9E, 
	0x5BD8, 0x5BE6, 0x5D3B, 0x5DF5, 0x5E0B, 0x5E5F, 0x5EA2, 0x5EA4, 0x5ECC, 0x5F8F, 0x5F94, 0x5F9D, 0x5FB4, 0x5FB5, 0x6043, 0x6049, 
	0x6179, 0x6184, 0x61E5, 0x61EB, 0x6220, 0x627A, 0x627B, 0x62A7, 0x62D3, 0x62DE, 0x6303, 0x6357, 0x6418, 0x6431, 0x6455, 0x6468, 
	0x646F, 0x64F2, 0x64F3, 0x64FF, 0x65A6, 0x65D8, 0x6635, 0x664A, 0x675D, 0x676B, 0x67E3, 0x683A, 0x683D, 0x6894, 0x68BD, 0x6925, 
	0x6956, 0x69B0, 0x69DC, 0x6A00, 0x6A32, 0x6A34, 0x6ACD, 0x6ADB, 0x6B6D, 0x6C10, 0x6C65, 0x6C66, 0x6C9A, 0x6CDC, 0x6D14, 0x6D37, 
	0x6DFD, 0x6ECD, 0x6EEF, 0x6F10, 0x6F4C, 0x6F6A, 0x7004, 0x71AB, 0x7286, 0x72FE, 0x7318, 0x74C6, 0x74E1, 0x7564, 0x7590, 0x75B7, 
	0x75BB, 0x7608, 0x7730, 0x780B, 0x7929, 0x793A, 0x7941, 0x7947, 0x7951, 0x796C, 0x7983, 0x7994, 0x79B5, 0x79C7, 0x79D3, 0x79D6, 
	0x79EA, 0x79EF, 0x79F2, 0x79F7, 0x7A19, 0x7A3A, 0x7A49, 0x7B6B, 0x7D19, 0x7D29, 0x7D7A, 0x7D95, 0x7DFB, 0x7E36, 0x7E54, 0x7FD0, 
	0x8006, 0x8040, 0x8077, 0x80D1, 0x80F5, 0x81B1, 0x81F7, 0x81F8, 0x8296, 0x830B, 0x831D, 0x83ED, 0x8599, 0x85E2, 0x8635, 0x8652, 
	0x8694, 0x87B2, 0x87D9, 0x8879, 0x887C, 0x889F, 0x88A0, 0x88FD, 0x8967, 0x899F, 0x89D7, 0x89DD, 0x89F6, 0x8A28, 0x8A8C, 0x8B22, 
	0x8B58, 0x8C51, 0x8C52, 0x8CAD, 0x8CEA, 0x8D04, 0x8DF1, 0x8E36, 0x8E5B, 0x8E60, 0x8E62, 0x8E91, 0x8E93, 0x8EC4, 0x8EF9, 0x8EFD, 
	0x8F0A, 0x8FDF, 0x8FE3, 0x905F, 0x9072, 0x90E6, 0x9148, 0x91DE, 0x9244, 0x928D, 0x92B4, 0x92D5, 0x9455, 0x94C1, 0x94DA, 0x9527, 
	0x9624, 0x962F, 0x9641, 0x96B2, 0x96BB, 0x99B6, 0x99BD, 0x99E4, 0x9A2D, 0x9A3A, 0x9A47, 0x9BEF, 0x9CE9, 0x9CF7, 0x9D19, 0x9D32, 
	0x9DA8, 0x9DD9, 0x9E20, 0x9F05
	};
const TText16 KPinyin507[5] = {'z', 'h', 'o', 'n', 'g', };
const TInt charForPinyin507[74] = {
	0x4E2D, 0x91CD, 0x79CD, 0x949F, 0x80BF, 0x4F17, 0x7EC8, 0x76C5, 0x5FE0, 0x4EF2, 0x8877, 0x8E35, 0x822F, 0x87BD, 0x953A, 0x51A2, 
	0x5FEA, 0x4E51, 0x4F00, 0x5045, 0x5223, 0x55A0, 0x5839, 0x585A, 0x5902, 0x5990, 0x5995, 0x5A91, 0x5C30, 0x5E52, 0x5F78, 0x5FB8, 
	0x67CA, 0x6B71, 0x6C77, 0x6CC8, 0x6F7C, 0x7082, 0x7144, 0x72C6, 0x7607, 0x773E, 0x794C, 0x7A2E, 0x7A5C, 0x7AE5, 0x7B57, 0x7C66, 
	0x7D42, 0x7DDF, 0x816B, 0x8202, 0x833D, 0x8463, 0x8520, 0x869B, 0x86A3, 0x8769, 0x87A4, 0x87F2, 0x8846, 0x8873, 0x8876, 0x8908, 
	0x8AE5, 0x8E71, 0x8FDA, 0x9206, 0x9221, 0x92BF, 0x937E, 0x9418, 0x9D24, 0x9F28
	};
const TText16 KPinyin508[4] = {'z', 'h', 'o', 'u', };
const TInt charForPinyin508[104] = {
	0x5468, 0x6D32, 0x76B1, 0x7CA5, 0x5DDE, 0x8F74, 0x821F, 0x663C, 0x9AA4, 0x5B99, 0x8BCC, 0x8098, 0x5E1A, 0x5492, 0x7E47, 0x80C4, 
	0x7EA3, 0x836E, 0x5541, 0x78A1, 0x7EC9, 0x7C40, 0x59AF, 0x914E, 0x4F37, 0x4F8F, 0x4F9C, 0x501C, 0x50FD, 0x5191, 0x546A, 0x54AE, 
	0x5544, 0x558C, 0x5599, 0x5663, 0x568B, 0x5A64, 0x5E9C, 0x5F9F, 0x626D, 0x63AB, 0x665D, 0x666D, 0x67DA, 0x6906, 0x6CE8, 0x6D00, 
	0x6DCD, 0x70BF, 0x70D0, 0x73D8, 0x7503, 0x759B, 0x76BA, 0x76E9, 0x776D, 0x77EA, 0x795D, 0x7B92, 0x7C52, 0x7C55, 0x7C99, 0x7D02, 
	0x7D2C, 0x7E10, 0x7FE2, 0x80D5, 0x8233, 0x83F7, 0x8464, 0x85B5, 0x8A4B, 0x8A76, 0x8ABF, 0x8ACF, 0x8B05, 0x8B78, 0x8BEA, 0x8BF9, 
	0x8C03, 0x8CD9, 0x8D52, 0x8EF8, 0x8F08, 0x8F16, 0x8F80, 0x9010, 0x9031, 0x90EE, 0x923E, 0x9282, 0x94C0, 0x970C, 0x99CE, 0x99F2, 
	0x9A06, 0x9A36, 0x9A5F, 0x9A7A, 0x9B3B, 0x9BDE, 0x9D43, 0x9E3C
	};
const TText16 KPinyin509[3] = {'z', 'h', 'u', };
const TInt charForPinyin509[170] = {
	0x4F4F, 0x4E3B, 0x732A, 0x7AF9, 0x682A, 0x716E, 0x7B51, 0x8457, 0x8D2E, 0x94F8, 0x5631, 0x62C4, 0x6CE8, 0x795D, 0x9A7B, 0x5C5E, 
	0x672F, 0x73E0, 0x77A9, 0x86DB, 0x6731, 0x67F1, 0x8BF8, 0x8BDB, 0x9010, 0x52A9, 0x70DB, 0x86C0, 0x6F74, 0x6D19, 0x4F2B, 0x7603, 
	0x7FE5, 0x8331, 0x82CE, 0x6A65, 0x8233, 0x677C, 0x7BB8, 0x70B7, 0x4F8F, 0x94E2, 0x75B0, 0x6E1A, 0x891A, 0x8E85, 0x9E88, 0x90BE, 
	0x69E0, 0x7AFA, 0x4E36, 0x4E88, 0x4F47, 0x5285, 0x529A, 0x52AF, 0x54AE, 0x55FB, 0x5663, 0x56D1, 0x577E, 0x58B8, 0x58F4, 0x5B4E, 
	0x5B81, 0x5B94, 0x5C0C, 0x5C6C, 0x5D40, 0x5EB6, 0x640A, 0x6571, 0x6580, 0x6597, 0x65B8, 0x66EF, 0x671D, 0x6793, 0x67E0, 0x67F7, 
	0x696E, 0x6A26, 0x6AE1, 0x6AE7, 0x6AEB, 0x6B18, 0x6BB6, 0x6CCF, 0x6CDE, 0x6F8D, 0x6FD0, 0x7026, 0x705F, 0x70A2, 0x7151, 0x71ED, 
	0x7225, 0x771D, 0x77DA, 0x782B, 0x7843, 0x78E9, 0x7969, 0x79FC, 0x7A8B, 0x7ADA, 0x7B01, 0x7B1C, 0x7B6F, 0x7BC9, 0x7BEB, 0x7BF4, 
	0x7D35, 0x7D38, 0x7D51, 0x7EBB, 0x7F5C, 0x7F9C, 0x82A7, 0x82E7, 0x8301, 0x833F, 0x8387, 0x84EB, 0x854F, 0x85A5, 0x85F7, 0x85F8, 
	0x86B0, 0x876B, 0x880B, 0x8829, 0x883E, 0x88BE, 0x8A3B, 0x8A5D, 0x8A85, 0x8AF8, 0x8C6C, 0x8CAF, 0x8DD3, 0x8DD9, 0x8DE6, 0x8EF4, 
	0x8FEC, 0x9017, 0x902B, 0x924F, 0x9252, 0x9296, 0x92F3, 0x9444, 0x9483, 0x963B, 0x9664, 0x967C, 0x9714, 0x98F3, 0x99B5, 0x99D0, 
	0x99EF, 0x9A36, 0x9A7A, 0x9BA2, 0x9BFA, 0x9C41, 0x9D38, 0x9E00, 0x9E86, 0x9F04
	};
const TText16 KPinyin510[4] = {'z', 'h', 'u', 'a', };
const TInt charForPinyin510[9] = {
	0x6293, 0x722A, 0x631D, 0x6463, 0x64BE, 0x6A9B, 0x7C3B, 0x81BC, 0x9AFD
	};
const TText16 KPinyin511[5] = {'z', 'h', 'u', 'a', 'i', };
const TInt charForPinyin511[7] = {
	0x62FD, 0x8F6C, 0x5C35, 0x6359, 0x7749, 0x8DE9, 0x9861
	};
const TText16 KPinyin512[5] = {'z', 'h', 'u', 'a', 'n', };
const TInt charForPinyin512[54] = {
	0x8F6C, 0x4E13, 0x7816, 0x8D5A, 0x4F20, 0x64B0, 0x7BC6, 0x989B, 0x9994, 0x556D, 0x6C8C, 0x50B3, 0x50CE, 0x50DD, 0x5278, 0x53C0, 
	0x56C0, 0x581F, 0x587C, 0x5AE5, 0x5B68, 0x5C02, 0x5C08, 0x606E, 0x629F, 0x6476, 0x6E4D, 0x6F19, 0x7077, 0x7451, 0x747C, 0x750E, 
	0x78DA, 0x7AF1, 0x7BF9, 0x7BFF, 0x7C28, 0x7C51, 0x7E33, 0x8011, 0x815E, 0x819E, 0x8483, 0x87E4, 0x8948, 0x8AEF, 0x8B54, 0x8CFA, 
	0x8EE2, 0x8F49, 0x911F, 0x9853, 0x994C, 0x9C44
	};
const TText16 KPinyin513[6] = {'z', 'h', 'u', 'a', 'n', 'g', };
const TInt charForPinyin513[36] = {
	0x88C5, 0x649E, 0x5E84, 0x58EE, 0x6869, 0x72B6, 0x5E62, 0x5986, 0x50EE, 0x5958, 0x6206, 0x4E2C, 0x58EF, 0x58F5, 0x599D, 0x5A24, 
	0x5E92, 0x61A7, 0x6205, 0x6207, 0x6889, 0x6A01, 0x6E77, 0x6F34, 0x710B, 0x72C0, 0x735E, 0x7CA7, 0x7CDA, 0x825F, 0x8358, 0x838A, 
	0x88DD, 0x8D11, 0x8D1B, 0x8D63
	};
const TText16 KPinyin514[4] = {'z', 'h', 'u', 'i', };
const TInt charForPinyin514[46] = {
	0x8FFD, 0x5760, 0x7F00, 0x9525, 0x8D58, 0x690E, 0x9A93, 0x60F4, 0x7F12, 0x96B9, 0x5015, 0x5782, 0x57C0, 0x589C, 0x5A37, 0x63E3, 
	0x69CC, 0x6C9D, 0x7500, 0x7577, 0x787E, 0x78D3, 0x7908, 0x7B0D, 0x7BA0, 0x7DB4, 0x7E0B, 0x814F, 0x8187, 0x81F4, 0x8411, 0x8AC8, 
	0x8D05, 0x8F5B, 0x9180, 0x918A, 0x9310, 0x9317, 0x9323, 0x939A, 0x9446, 0x968A, 0x96A7, 0x991F, 0x9A05, 0x9D7B
	};
const TText16 KPinyin515[4] = {'z', 'h', 'u', 'n', };
const TInt charForPinyin515[29] = {
	0x51C6, 0x8C06, 0x5C6F, 0x80AB, 0x7A80, 0x51D6, 0x554D, 0x572B, 0x57FB, 0x5B92, 0x5FF3, 0x65FD, 0x6DF3, 0x6E7B, 0x6E96, 0x753D, 
	0x76F9, 0x7A15, 0x7D14, 0x7DA7, 0x7EAF, 0x80D7, 0x8860, 0x8A30, 0x8AC4, 0x8FCD, 0x98E9, 0x9968, 0x9EF1
	};
const TText16 KPinyin516[4] = {'z', 'h', 'u', 'o', };
const TInt charForPinyin516[99] = {
	0x6349, 0x684C, 0x7740, 0x5544, 0x62D9, 0x707C, 0x6D4A, 0x5353, 0x7422, 0x7F34, 0x8301, 0x914C, 0x64E2, 0x712F, 0x6FEF, 0x8BFC, 
	0x6D5E, 0x6DBF, 0x502C, 0x956F, 0x799A, 0x65AB, 0x4E35, 0x5262, 0x5285, 0x52FA, 0x53D5, 0x5545, 0x555C, 0x5663, 0x5734, 0x5767, 
	0x588C, 0x59B0, 0x5A3A, 0x5F74, 0x6354, 0x6387, 0x64AF, 0x64C6, 0x6580, 0x65AE, 0x65B1, 0x65B2, 0x65B5, 0x666B, 0x6753, 0x68B2, 
	0x68C1, 0x68F3, 0x68F9, 0x6913, 0x69D5, 0x6AE1, 0x6C4B, 0x6DD6, 0x6E96, 0x6FC1, 0x7042, 0x70AA, 0x70F5, 0x72B3, 0x72F5, 0x7438, 
	0x77E0, 0x787A, 0x7A5B, 0x7A71, 0x7AA1, 0x7AA7, 0x7BB8, 0x7BE7, 0x7C57, 0x7C71, 0x7E73, 0x7F6C, 0x8049, 0x80AB, 0x8457, 0x84D4, 
	0x855E, 0x85CB, 0x8743, 0x8817, 0x883F, 0x8AC1, 0x8AD1, 0x8B36, 0x8DA0, 0x8DB5, 0x8E14, 0x8E60, 0x8E85, 0x9275, 0x92DC, 0x942F, 
	0x9432, 0x9D6B, 0x9DDF
	};
const TText16 KPinyin517[2] = {'z', 'i', };
const TInt charForPinyin517[119] = {
	0x5B57, 0x81EA, 0x5B50, 0x7D2B, 0x7C7D, 0x8D44, 0x59FF, 0x5431, 0x6ED3, 0x4ED4, 0x5179, 0x54A8, 0x5B5C, 0x6E0D, 0x6ECB, 0x6DC4, 
	0x7B2B, 0x7CA2, 0x9F87, 0x79ED, 0x6063, 0x8C18, 0x8D91, 0x7F01, 0x6893, 0x9CBB, 0x9531, 0x5B73, 0x8014, 0x89DC, 0x9AED, 0x8D40, 
	0x8308, 0x8A3E, 0x5D6B, 0x7726, 0x59CA, 0x8F8E, 0x4E8B, 0x5033, 0x525A, 0x5407, 0x5470, 0x5472, 0x5559, 0x55DE, 0x59C9, 0x59D5, 
	0x5B56, 0x5B76, 0x5D30, 0x674D, 0x6825, 0x6914, 0x699F, 0x6A74, 0x6B21, 0x6C9D, 0x6CDA, 0x6D13, 0x6E7D, 0x6F2C, 0x6FAC, 0x7278, 
	0x7386, 0x74BE, 0x753E, 0x75B5, 0x7725, 0x77F7, 0x798C, 0x79C4, 0x79F6, 0x7A35, 0x7A67, 0x7D0E, 0x7DC7, 0x80CF, 0x80D4, 0x80FE, 
	0x8293, 0x830A, 0x8321, 0x8332, 0x83D1, 0x8458, 0x84FB, 0x858B, 0x8678, 0x8A3F, 0x8AEE, 0x8CB2, 0x8CC7, 0x8D7C, 0x8DA6, 0x8DD0, 
	0x8F09, 0x8F1C, 0x8F3A, 0x8F7D, 0x9111, 0x91E8, 0x922D, 0x92C5, 0x9319, 0x937F, 0x93A1, 0x950C, 0x9543, 0x983E, 0x983F, 0x9BD4, 
	0x9C26, 0x9D85, 0x9F12, 0x9F4A, 0x9F4D, 0x9F50, 0x9F5C
	};
const TText16 KPinyin518[2] = {'z', 'o', };
const TInt charForPinyin518[2] = {
	0x5497, 0x5528
	};
const TText16 KPinyin519[4] = {'z', 'o', 'n', 'g', };
const TInt charForPinyin519[73] = {
	0x603B, 0x7EB5, 0x5B97, 0x68D5, 0x7EFC, 0x8E2A, 0x9B03, 0x506C, 0x7CBD, 0x679E, 0x8159, 0x500A, 0x5027, 0x50AF, 0x582B, 0x5D4F, 
	0x5D55, 0x5D78, 0x5F9E, 0x60E3, 0x60FE, 0x6121, 0x6374, 0x63D4, 0x6403, 0x6460, 0x662E, 0x6721, 0x6936, 0x6A05, 0x6F40, 0x6F48, 
	0x6F68, 0x719C, 0x71A7, 0x71EA, 0x7314, 0x7323, 0x75AD, 0x7632, 0x7882, 0x78EB, 0x7A2F, 0x7CC9, 0x7D9C, 0x7DC3, 0x7DCF, 0x7DEB, 
	0x7DF5, 0x7E02, 0x7E26, 0x7E31, 0x7E3D, 0x7FEA, 0x8250, 0x847C, 0x84D7, 0x84EF, 0x876C, 0x8C75, 0x8E28, 0x8E64, 0x931D, 0x936F, 
	0x93D3, 0x9441, 0x9A0C, 0x9A23, 0x9A94, 0x9B09, 0x9B37, 0x9BEE, 0x9BFC
	};
const TText16 KPinyin520[3] = {'z', 'o', 'u', };
const TInt charForPinyin520[31] = {
	0x8D70, 0x63CD, 0x594F, 0x90B9, 0x9CB0, 0x9139, 0x966C, 0x9A7A, 0x8BF9, 0x5062, 0x5AB0, 0x63AB, 0x640A, 0x65CF, 0x68F7, 0x68F8, 
	0x6971, 0x7B83, 0x7DC5, 0x82BB, 0x83C6, 0x8ACF, 0x8D71, 0x90F0, 0x9112, 0x9A36, 0x9BD0, 0x9BEB, 0x9EC0, 0x9F71, 0x9F7A
	};
const TText16 KPinyin521[2] = {'z', 'u', };
const TInt charForPinyin521[57] = {
	0x7EC4, 0x65CF, 0x8DB3, 0x963B, 0x79DF, 0x7956, 0x8BC5, 0x83F9, 0x955E, 0x5352, 0x4FCE, 0x4F1C, 0x4F39, 0x5005, 0x50B6, 0x5346, 
	0x54EB, 0x5550, 0x5601, 0x5CA8, 0x5D12, 0x5D2A, 0x5F82, 0x601A, 0x67E4, 0x6CAE, 0x6DEC, 0x723C, 0x73C7, 0x7820, 0x7A21, 0x7BA4, 
	0x7D23, 0x7D44, 0x7DB7, 0x82F4, 0x8445, 0x84A9, 0x8A5B, 0x8B2F, 0x8DB1, 0x8DB2, 0x8E24, 0x8E3F, 0x8E74, 0x9243, 0x924F, 0x9250, 
	0x930A, 0x9390, 0x93BA, 0x93C3, 0x947F, 0x977B, 0x9847, 0x99D4, 0x9A75
	};
const TText16 KPinyin522[4] = {'z', 'u', 'a', 'n', };
const TInt charForPinyin522[21] = {
	0x94BB, 0x7E82, 0x8D5A, 0x7F35, 0x8E9C, 0x6525, 0x5297, 0x63DD, 0x64AE, 0x6512, 0x6522, 0x6B11, 0x7BF9, 0x7C6B, 0x7E64, 0x7E89, 
	0x7E98, 0x8CFA, 0x8EA6, 0x945A, 0x947D
	};
const TText16 KPinyin523[3] = {'z', 'u', 'i', };
const TInt charForPinyin523[44] = {
	0x6700, 0x5634, 0x9189, 0x7F6A, 0x5806, 0x5480, 0x89DC, 0x855E, 0x539C, 0x55FA, 0x567F, 0x5AE2, 0x5D89, 0x5D8A, 0x5DB5, 0x6467, 
	0x64AE, 0x666C, 0x6718, 0x67A0, 0x682C, 0x69EF, 0x6A36, 0x6A87, 0x6A8C, 0x6B08, 0x6FE2, 0x74BB, 0x775F, 0x797D, 0x7A21, 0x7A5D, 
	0x7D4A, 0x7E97, 0x7FA7, 0x8127, 0x87D5, 0x8FA0, 0x9154, 0x9168, 0x917B, 0x92F7, 0x930A, 0x96CB
	};
const TText16 KPinyin524[3] = {'z', 'u', 'n', };
const TInt charForPinyin524[28] = {
	0x5C0A, 0x9075, 0x9CDF, 0x6499, 0x6A3D, 0x50CE, 0x50D4, 0x5642, 0x58AB, 0x5960, 0x5D9F, 0x62F5, 0x6358, 0x637D, 0x682B, 0x7033, 
	0x7E5C, 0x7F47, 0x88B8, 0x8B50, 0x8DE7, 0x8E06, 0x8E72, 0x928C, 0x940F, 0x9C52, 0x9D8E, 0x9DF7
	};
const TText16 KPinyin525[3] = {'z', 'u', 'o', };
const TInt charForPinyin525[45] = {
	0x505A, 0x4F5C, 0x5750, 0x5DE6, 0x5EA7, 0x6628, 0x51FF, 0x7422, 0x64AE, 0x4F50, 0x7B2E, 0x562C, 0x9162, 0x5511, 0x795A, 0x80D9, 
	0x600D, 0x963C, 0x67DE, 0x4E4D, 0x4FB3, 0x5497, 0x5C9D, 0x5C9E, 0x632B, 0x637D, 0x67EE, 0x690A, 0x781F, 0x79E8, 0x7A13, 0x7B70, 
	0x7CF3, 0x7E53, 0x82F2, 0x838B, 0x8443, 0x8444, 0x84D9, 0x888F, 0x8ACE, 0x918B, 0x923C, 0x947F, 0x98F5
	};
static const TPinyinCharacterPair allPinyinPair[] = {
	{ KPinyin000, sizeof(KPinyin000)/sizeof(KPinyin000[0]), sizeof(charForPinyin000)/sizeof(charForPinyin000[0]), charForPinyin000 },
	{ KPinyin001, sizeof(KPinyin001)/sizeof(KPinyin001[0]), sizeof(charForPinyin001)/sizeof(charForPinyin001[0]), charForPinyin001 },
	{ KPinyin002, sizeof(KPinyin002)/sizeof(KPinyin002[0]), sizeof(charForPinyin002)/sizeof(charForPinyin002[0]), charForPinyin002 },
	{ KPinyin003, sizeof(KPinyin003)/sizeof(KPinyin003[0]), sizeof(charForPinyin003)/sizeof(charForPinyin003[0]), charForPinyin003 },
	{ KPinyin004, sizeof(KPinyin004)/sizeof(KPinyin004[0]), sizeof(charForPinyin004)/sizeof(charForPinyin004[0]), charForPinyin004 },
	{ KPinyin005, sizeof(KPinyin005)/sizeof(KPinyin005[0]), sizeof(charForPinyin005)/sizeof(charForPinyin005[0]), charForPinyin005 },
	{ KPinyin006, sizeof(KPinyin006)/sizeof(KPinyin006[0]), sizeof(charForPinyin006)/sizeof(charForPinyin006[0]), charForPinyin006 },
	{ KPinyin007, sizeof(KPinyin007)/sizeof(KPinyin007[0]), sizeof(charForPinyin007)/sizeof(charForPinyin007[0]), charForPinyin007 },
	{ KPinyin008, sizeof(KPinyin008)/sizeof(KPinyin008[0]), sizeof(charForPinyin008)/sizeof(charForPinyin008[0]), charForPinyin008 },
	{ KPinyin009, sizeof(KPinyin009)/sizeof(KPinyin009[0]), sizeof(charForPinyin009)/sizeof(charForPinyin009[0]), charForPinyin009 },
	{ KPinyin010, sizeof(KPinyin010)/sizeof(KPinyin010[0]), sizeof(charForPinyin010)/sizeof(charForPinyin010[0]), charForPinyin010 },
	{ KPinyin011, sizeof(KPinyin011)/sizeof(KPinyin011[0]), sizeof(charForPinyin011)/sizeof(charForPinyin011[0]), charForPinyin011 },
	{ KPinyin012, sizeof(KPinyin012)/sizeof(KPinyin012[0]), sizeof(charForPinyin012)/sizeof(charForPinyin012[0]), charForPinyin012 },
	{ KPinyin013, sizeof(KPinyin013)/sizeof(KPinyin013[0]), sizeof(charForPinyin013)/sizeof(charForPinyin013[0]), charForPinyin013 },
	{ KPinyin014, sizeof(KPinyin014)/sizeof(KPinyin014[0]), sizeof(charForPinyin014)/sizeof(charForPinyin014[0]), charForPinyin014 },
	{ KPinyin015, sizeof(KPinyin015)/sizeof(KPinyin015[0]), sizeof(charForPinyin015)/sizeof(charForPinyin015[0]), charForPinyin015 },
	{ KPinyin016, sizeof(KPinyin016)/sizeof(KPinyin016[0]), sizeof(charForPinyin016)/sizeof(charForPinyin016[0]), charForPinyin016 },
	{ KPinyin017, sizeof(KPinyin017)/sizeof(KPinyin017[0]), sizeof(charForPinyin017)/sizeof(charForPinyin017[0]), charForPinyin017 },
	{ KPinyin018, sizeof(KPinyin018)/sizeof(KPinyin018[0]), sizeof(charForPinyin018)/sizeof(charForPinyin018[0]), charForPinyin018 },
	{ KPinyin019, sizeof(KPinyin019)/sizeof(KPinyin019[0]), sizeof(charForPinyin019)/sizeof(charForPinyin019[0]), charForPinyin019 },
	{ KPinyin020, sizeof(KPinyin020)/sizeof(KPinyin020[0]), sizeof(charForPinyin020)/sizeof(charForPinyin020[0]), charForPinyin020 },
	{ KPinyin021, sizeof(KPinyin021)/sizeof(KPinyin021[0]), sizeof(charForPinyin021)/sizeof(charForPinyin021[0]), charForPinyin021 },
	{ KPinyin022, sizeof(KPinyin022)/sizeof(KPinyin022[0]), sizeof(charForPinyin022)/sizeof(charForPinyin022[0]), charForPinyin022 },
	{ KPinyin023, sizeof(KPinyin023)/sizeof(KPinyin023[0]), sizeof(charForPinyin023)/sizeof(charForPinyin023[0]), charForPinyin023 },
	{ KPinyin024, sizeof(KPinyin024)/sizeof(KPinyin024[0]), sizeof(charForPinyin024)/sizeof(charForPinyin024[0]), charForPinyin024 },
	{ KPinyin025, sizeof(KPinyin025)/sizeof(KPinyin025[0]), sizeof(charForPinyin025)/sizeof(charForPinyin025[0]), charForPinyin025 },
	{ KPinyin026, sizeof(KPinyin026)/sizeof(KPinyin026[0]), sizeof(charForPinyin026)/sizeof(charForPinyin026[0]), charForPinyin026 },
	{ KPinyin027, sizeof(KPinyin027)/sizeof(KPinyin027[0]), sizeof(charForPinyin027)/sizeof(charForPinyin027[0]), charForPinyin027 },
	{ KPinyin028, sizeof(KPinyin028)/sizeof(KPinyin028[0]), sizeof(charForPinyin028)/sizeof(charForPinyin028[0]), charForPinyin028 },
	{ KPinyin029, sizeof(KPinyin029)/sizeof(KPinyin029[0]), sizeof(charForPinyin029)/sizeof(charForPinyin029[0]), charForPinyin029 },
	{ KPinyin030, sizeof(KPinyin030)/sizeof(KPinyin030[0]), sizeof(charForPinyin030)/sizeof(charForPinyin030[0]), charForPinyin030 },
	{ KPinyin031, sizeof(KPinyin031)/sizeof(KPinyin031[0]), sizeof(charForPinyin031)/sizeof(charForPinyin031[0]), charForPinyin031 },
	{ KPinyin032, sizeof(KPinyin032)/sizeof(KPinyin032[0]), sizeof(charForPinyin032)/sizeof(charForPinyin032[0]), charForPinyin032 },
	{ KPinyin033, sizeof(KPinyin033)/sizeof(KPinyin033[0]), sizeof(charForPinyin033)/sizeof(charForPinyin033[0]), charForPinyin033 },
	{ KPinyin034, sizeof(KPinyin034)/sizeof(KPinyin034[0]), sizeof(charForPinyin034)/sizeof(charForPinyin034[0]), charForPinyin034 },
	{ KPinyin035, sizeof(KPinyin035)/sizeof(KPinyin035[0]), sizeof(charForPinyin035)/sizeof(charForPinyin035[0]), charForPinyin035 },
	{ KPinyin036, sizeof(KPinyin036)/sizeof(KPinyin036[0]), sizeof(charForPinyin036)/sizeof(charForPinyin036[0]), charForPinyin036 },
	{ KPinyin037, sizeof(KPinyin037)/sizeof(KPinyin037[0]), sizeof(charForPinyin037)/sizeof(charForPinyin037[0]), charForPinyin037 },
	{ KPinyin038, sizeof(KPinyin038)/sizeof(KPinyin038[0]), sizeof(charForPinyin038)/sizeof(charForPinyin038[0]), charForPinyin038 },
	{ KPinyin039, sizeof(KPinyin039)/sizeof(KPinyin039[0]), sizeof(charForPinyin039)/sizeof(charForPinyin039[0]), charForPinyin039 },
	{ KPinyin040, sizeof(KPinyin040)/sizeof(KPinyin040[0]), sizeof(charForPinyin040)/sizeof(charForPinyin040[0]), charForPinyin040 },
	{ KPinyin041, sizeof(KPinyin041)/sizeof(KPinyin041[0]), sizeof(charForPinyin041)/sizeof(charForPinyin041[0]), charForPinyin041 },
	{ KPinyin042, sizeof(KPinyin042)/sizeof(KPinyin042[0]), sizeof(charForPinyin042)/sizeof(charForPinyin042[0]), charForPinyin042 },
	{ KPinyin043, sizeof(KPinyin043)/sizeof(KPinyin043[0]), sizeof(charForPinyin043)/sizeof(charForPinyin043[0]), charForPinyin043 },
	{ KPinyin044, sizeof(KPinyin044)/sizeof(KPinyin044[0]), sizeof(charForPinyin044)/sizeof(charForPinyin044[0]), charForPinyin044 },
	{ KPinyin045, sizeof(KPinyin045)/sizeof(KPinyin045[0]), sizeof(charForPinyin045)/sizeof(charForPinyin045[0]), charForPinyin045 },
	{ KPinyin046, sizeof(KPinyin046)/sizeof(KPinyin046[0]), sizeof(charForPinyin046)/sizeof(charForPinyin046[0]), charForPinyin046 },
	{ KPinyin047, sizeof(KPinyin047)/sizeof(KPinyin047[0]), sizeof(charForPinyin047)/sizeof(charForPinyin047[0]), charForPinyin047 },
	{ KPinyin048, sizeof(KPinyin048)/sizeof(KPinyin048[0]), sizeof(charForPinyin048)/sizeof(charForPinyin048[0]), charForPinyin048 },
	{ KPinyin049, sizeof(KPinyin049)/sizeof(KPinyin049[0]), sizeof(charForPinyin049)/sizeof(charForPinyin049[0]), charForPinyin049 },
	{ KPinyin050, sizeof(KPinyin050)/sizeof(KPinyin050[0]), sizeof(charForPinyin050)/sizeof(charForPinyin050[0]), charForPinyin050 },
	{ KPinyin051, sizeof(KPinyin051)/sizeof(KPinyin051[0]), sizeof(charForPinyin051)/sizeof(charForPinyin051[0]), charForPinyin051 },
	{ KPinyin052, sizeof(KPinyin052)/sizeof(KPinyin052[0]), sizeof(charForPinyin052)/sizeof(charForPinyin052[0]), charForPinyin052 },
	{ KPinyin053, sizeof(KPinyin053)/sizeof(KPinyin053[0]), sizeof(charForPinyin053)/sizeof(charForPinyin053[0]), charForPinyin053 },
	{ KPinyin054, sizeof(KPinyin054)/sizeof(KPinyin054[0]), sizeof(charForPinyin054)/sizeof(charForPinyin054[0]), charForPinyin054 },
	{ KPinyin055, sizeof(KPinyin055)/sizeof(KPinyin055[0]), sizeof(charForPinyin055)/sizeof(charForPinyin055[0]), charForPinyin055 },
	{ KPinyin056, sizeof(KPinyin056)/sizeof(KPinyin056[0]), sizeof(charForPinyin056)/sizeof(charForPinyin056[0]), charForPinyin056 },
	{ KPinyin057, sizeof(KPinyin057)/sizeof(KPinyin057[0]), sizeof(charForPinyin057)/sizeof(charForPinyin057[0]), charForPinyin057 },
	{ KPinyin058, sizeof(KPinyin058)/sizeof(KPinyin058[0]), sizeof(charForPinyin058)/sizeof(charForPinyin058[0]), charForPinyin058 },
	{ KPinyin059, sizeof(KPinyin059)/sizeof(KPinyin059[0]), sizeof(charForPinyin059)/sizeof(charForPinyin059[0]), charForPinyin059 },
	{ KPinyin060, sizeof(KPinyin060)/sizeof(KPinyin060[0]), sizeof(charForPinyin060)/sizeof(charForPinyin060[0]), charForPinyin060 },
	{ KPinyin061, sizeof(KPinyin061)/sizeof(KPinyin061[0]), sizeof(charForPinyin061)/sizeof(charForPinyin061[0]), charForPinyin061 },
	{ KPinyin062, sizeof(KPinyin062)/sizeof(KPinyin062[0]), sizeof(charForPinyin062)/sizeof(charForPinyin062[0]), charForPinyin062 },
	{ KPinyin063, sizeof(KPinyin063)/sizeof(KPinyin063[0]), sizeof(charForPinyin063)/sizeof(charForPinyin063[0]), charForPinyin063 },
	{ KPinyin064, sizeof(KPinyin064)/sizeof(KPinyin064[0]), sizeof(charForPinyin064)/sizeof(charForPinyin064[0]), charForPinyin064 },
	{ KPinyin065, sizeof(KPinyin065)/sizeof(KPinyin065[0]), sizeof(charForPinyin065)/sizeof(charForPinyin065[0]), charForPinyin065 },
	{ KPinyin066, sizeof(KPinyin066)/sizeof(KPinyin066[0]), sizeof(charForPinyin066)/sizeof(charForPinyin066[0]), charForPinyin066 },
	{ KPinyin067, sizeof(KPinyin067)/sizeof(KPinyin067[0]), sizeof(charForPinyin067)/sizeof(charForPinyin067[0]), charForPinyin067 },
	{ KPinyin068, sizeof(KPinyin068)/sizeof(KPinyin068[0]), sizeof(charForPinyin068)/sizeof(charForPinyin068[0]), charForPinyin068 },
	{ KPinyin069, sizeof(KPinyin069)/sizeof(KPinyin069[0]), sizeof(charForPinyin069)/sizeof(charForPinyin069[0]), charForPinyin069 },
	{ KPinyin070, sizeof(KPinyin070)/sizeof(KPinyin070[0]), sizeof(charForPinyin070)/sizeof(charForPinyin070[0]), charForPinyin070 },
	{ KPinyin071, sizeof(KPinyin071)/sizeof(KPinyin071[0]), sizeof(charForPinyin071)/sizeof(charForPinyin071[0]), charForPinyin071 },
	{ KPinyin072, sizeof(KPinyin072)/sizeof(KPinyin072[0]), sizeof(charForPinyin072)/sizeof(charForPinyin072[0]), charForPinyin072 },
	{ KPinyin073, sizeof(KPinyin073)/sizeof(KPinyin073[0]), sizeof(charForPinyin073)/sizeof(charForPinyin073[0]), charForPinyin073 },
	{ KPinyin074, sizeof(KPinyin074)/sizeof(KPinyin074[0]), sizeof(charForPinyin074)/sizeof(charForPinyin074[0]), charForPinyin074 },
	{ KPinyin075, sizeof(KPinyin075)/sizeof(KPinyin075[0]), sizeof(charForPinyin075)/sizeof(charForPinyin075[0]), charForPinyin075 },
	{ KPinyin076, sizeof(KPinyin076)/sizeof(KPinyin076[0]), sizeof(charForPinyin076)/sizeof(charForPinyin076[0]), charForPinyin076 },
	{ KPinyin077, sizeof(KPinyin077)/sizeof(KPinyin077[0]), sizeof(charForPinyin077)/sizeof(charForPinyin077[0]), charForPinyin077 },
	{ KPinyin078, sizeof(KPinyin078)/sizeof(KPinyin078[0]), sizeof(charForPinyin078)/sizeof(charForPinyin078[0]), charForPinyin078 },
	{ KPinyin079, sizeof(KPinyin079)/sizeof(KPinyin079[0]), sizeof(charForPinyin079)/sizeof(charForPinyin079[0]), charForPinyin079 },
	{ KPinyin080, sizeof(KPinyin080)/sizeof(KPinyin080[0]), sizeof(charForPinyin080)/sizeof(charForPinyin080[0]), charForPinyin080 },
	{ KPinyin081, sizeof(KPinyin081)/sizeof(KPinyin081[0]), sizeof(charForPinyin081)/sizeof(charForPinyin081[0]), charForPinyin081 },
	{ KPinyin082, sizeof(KPinyin082)/sizeof(KPinyin082[0]), sizeof(charForPinyin082)/sizeof(charForPinyin082[0]), charForPinyin082 },
	{ KPinyin083, sizeof(KPinyin083)/sizeof(KPinyin083[0]), sizeof(charForPinyin083)/sizeof(charForPinyin083[0]), charForPinyin083 },
	{ KPinyin084, sizeof(KPinyin084)/sizeof(KPinyin084[0]), sizeof(charForPinyin084)/sizeof(charForPinyin084[0]), charForPinyin084 },
	{ KPinyin085, sizeof(KPinyin085)/sizeof(KPinyin085[0]), sizeof(charForPinyin085)/sizeof(charForPinyin085[0]), charForPinyin085 },
	{ KPinyin086, sizeof(KPinyin086)/sizeof(KPinyin086[0]), sizeof(charForPinyin086)/sizeof(charForPinyin086[0]), charForPinyin086 },
	{ KPinyin087, sizeof(KPinyin087)/sizeof(KPinyin087[0]), sizeof(charForPinyin087)/sizeof(charForPinyin087[0]), charForPinyin087 },
	{ KPinyin088, sizeof(KPinyin088)/sizeof(KPinyin088[0]), sizeof(charForPinyin088)/sizeof(charForPinyin088[0]), charForPinyin088 },
	{ KPinyin089, sizeof(KPinyin089)/sizeof(KPinyin089[0]), sizeof(charForPinyin089)/sizeof(charForPinyin089[0]), charForPinyin089 },
	{ KPinyin090, sizeof(KPinyin090)/sizeof(KPinyin090[0]), sizeof(charForPinyin090)/sizeof(charForPinyin090[0]), charForPinyin090 },
	{ KPinyin091, sizeof(KPinyin091)/sizeof(KPinyin091[0]), sizeof(charForPinyin091)/sizeof(charForPinyin091[0]), charForPinyin091 },
	{ KPinyin092, sizeof(KPinyin092)/sizeof(KPinyin092[0]), sizeof(charForPinyin092)/sizeof(charForPinyin092[0]), charForPinyin092 },
	{ KPinyin093, sizeof(KPinyin093)/sizeof(KPinyin093[0]), sizeof(charForPinyin093)/sizeof(charForPinyin093[0]), charForPinyin093 },
	{ KPinyin094, sizeof(KPinyin094)/sizeof(KPinyin094[0]), sizeof(charForPinyin094)/sizeof(charForPinyin094[0]), charForPinyin094 },
	{ KPinyin095, sizeof(KPinyin095)/sizeof(KPinyin095[0]), sizeof(charForPinyin095)/sizeof(charForPinyin095[0]), charForPinyin095 },
	{ KPinyin096, sizeof(KPinyin096)/sizeof(KPinyin096[0]), sizeof(charForPinyin096)/sizeof(charForPinyin096[0]), charForPinyin096 },
	{ KPinyin097, sizeof(KPinyin097)/sizeof(KPinyin097[0]), sizeof(charForPinyin097)/sizeof(charForPinyin097[0]), charForPinyin097 },
	{ KPinyin098, sizeof(KPinyin098)/sizeof(KPinyin098[0]), sizeof(charForPinyin098)/sizeof(charForPinyin098[0]), charForPinyin098 },
	{ KPinyin099, sizeof(KPinyin099)/sizeof(KPinyin099[0]), sizeof(charForPinyin099)/sizeof(charForPinyin099[0]), charForPinyin099 },
	{ KPinyin100, sizeof(KPinyin100)/sizeof(KPinyin100[0]), sizeof(charForPinyin100)/sizeof(charForPinyin100[0]), charForPinyin100 },
	{ KPinyin101, sizeof(KPinyin101)/sizeof(KPinyin101[0]), sizeof(charForPinyin101)/sizeof(charForPinyin101[0]), charForPinyin101 },
	{ KPinyin102, sizeof(KPinyin102)/sizeof(KPinyin102[0]), sizeof(charForPinyin102)/sizeof(charForPinyin102[0]), charForPinyin102 },
	{ KPinyin103, sizeof(KPinyin103)/sizeof(KPinyin103[0]), sizeof(charForPinyin103)/sizeof(charForPinyin103[0]), charForPinyin103 },
	{ KPinyin104, sizeof(KPinyin104)/sizeof(KPinyin104[0]), sizeof(charForPinyin104)/sizeof(charForPinyin104[0]), charForPinyin104 },
	{ KPinyin105, sizeof(KPinyin105)/sizeof(KPinyin105[0]), sizeof(charForPinyin105)/sizeof(charForPinyin105[0]), charForPinyin105 },
	{ KPinyin106, sizeof(KPinyin106)/sizeof(KPinyin106[0]), sizeof(charForPinyin106)/sizeof(charForPinyin106[0]), charForPinyin106 },
	{ KPinyin107, sizeof(KPinyin107)/sizeof(KPinyin107[0]), sizeof(charForPinyin107)/sizeof(charForPinyin107[0]), charForPinyin107 },
	{ KPinyin108, sizeof(KPinyin108)/sizeof(KPinyin108[0]), sizeof(charForPinyin108)/sizeof(charForPinyin108[0]), charForPinyin108 },
	{ KPinyin109, sizeof(KPinyin109)/sizeof(KPinyin109[0]), sizeof(charForPinyin109)/sizeof(charForPinyin109[0]), charForPinyin109 },
	{ KPinyin110, sizeof(KPinyin110)/sizeof(KPinyin110[0]), sizeof(charForPinyin110)/sizeof(charForPinyin110[0]), charForPinyin110 },
	{ KPinyin111, sizeof(KPinyin111)/sizeof(KPinyin111[0]), sizeof(charForPinyin111)/sizeof(charForPinyin111[0]), charForPinyin111 },
	{ KPinyin112, sizeof(KPinyin112)/sizeof(KPinyin112[0]), sizeof(charForPinyin112)/sizeof(charForPinyin112[0]), charForPinyin112 },
	{ KPinyin113, sizeof(KPinyin113)/sizeof(KPinyin113[0]), sizeof(charForPinyin113)/sizeof(charForPinyin113[0]), charForPinyin113 },
	{ KPinyin114, sizeof(KPinyin114)/sizeof(KPinyin114[0]), sizeof(charForPinyin114)/sizeof(charForPinyin114[0]), charForPinyin114 },
	{ KPinyin115, sizeof(KPinyin115)/sizeof(KPinyin115[0]), sizeof(charForPinyin115)/sizeof(charForPinyin115[0]), charForPinyin115 },
	{ KPinyin116, sizeof(KPinyin116)/sizeof(KPinyin116[0]), sizeof(charForPinyin116)/sizeof(charForPinyin116[0]), charForPinyin116 },
	{ KPinyin117, sizeof(KPinyin117)/sizeof(KPinyin117[0]), sizeof(charForPinyin117)/sizeof(charForPinyin117[0]), charForPinyin117 },
	{ KPinyin118, sizeof(KPinyin118)/sizeof(KPinyin118[0]), sizeof(charForPinyin118)/sizeof(charForPinyin118[0]), charForPinyin118 },
	{ KPinyin119, sizeof(KPinyin119)/sizeof(KPinyin119[0]), sizeof(charForPinyin119)/sizeof(charForPinyin119[0]), charForPinyin119 },
	{ KPinyin120, sizeof(KPinyin120)/sizeof(KPinyin120[0]), sizeof(charForPinyin120)/sizeof(charForPinyin120[0]), charForPinyin120 },
	{ KPinyin121, sizeof(KPinyin121)/sizeof(KPinyin121[0]), sizeof(charForPinyin121)/sizeof(charForPinyin121[0]), charForPinyin121 },
	{ KPinyin122, sizeof(KPinyin122)/sizeof(KPinyin122[0]), sizeof(charForPinyin122)/sizeof(charForPinyin122[0]), charForPinyin122 },
	{ KPinyin123, sizeof(KPinyin123)/sizeof(KPinyin123[0]), sizeof(charForPinyin123)/sizeof(charForPinyin123[0]), charForPinyin123 },
	{ KPinyin124, sizeof(KPinyin124)/sizeof(KPinyin124[0]), sizeof(charForPinyin124)/sizeof(charForPinyin124[0]), charForPinyin124 },
	{ KPinyin125, sizeof(KPinyin125)/sizeof(KPinyin125[0]), sizeof(charForPinyin125)/sizeof(charForPinyin125[0]), charForPinyin125 },
	{ KPinyin126, sizeof(KPinyin126)/sizeof(KPinyin126[0]), sizeof(charForPinyin126)/sizeof(charForPinyin126[0]), charForPinyin126 },
	{ KPinyin127, sizeof(KPinyin127)/sizeof(KPinyin127[0]), sizeof(charForPinyin127)/sizeof(charForPinyin127[0]), charForPinyin127 },
	{ KPinyin128, sizeof(KPinyin128)/sizeof(KPinyin128[0]), sizeof(charForPinyin128)/sizeof(charForPinyin128[0]), charForPinyin128 },
	{ KPinyin129, sizeof(KPinyin129)/sizeof(KPinyin129[0]), sizeof(charForPinyin129)/sizeof(charForPinyin129[0]), charForPinyin129 },
	{ KPinyin130, sizeof(KPinyin130)/sizeof(KPinyin130[0]), sizeof(charForPinyin130)/sizeof(charForPinyin130[0]), charForPinyin130 },
	{ KPinyin131, sizeof(KPinyin131)/sizeof(KPinyin131[0]), sizeof(charForPinyin131)/sizeof(charForPinyin131[0]), charForPinyin131 },
	{ KPinyin132, sizeof(KPinyin132)/sizeof(KPinyin132[0]), sizeof(charForPinyin132)/sizeof(charForPinyin132[0]), charForPinyin132 },
	{ KPinyin133, sizeof(KPinyin133)/sizeof(KPinyin133[0]), sizeof(charForPinyin133)/sizeof(charForPinyin133[0]), charForPinyin133 },
	{ KPinyin134, sizeof(KPinyin134)/sizeof(KPinyin134[0]), sizeof(charForPinyin134)/sizeof(charForPinyin134[0]), charForPinyin134 },
	{ KPinyin135, sizeof(KPinyin135)/sizeof(KPinyin135[0]), sizeof(charForPinyin135)/sizeof(charForPinyin135[0]), charForPinyin135 },
	{ KPinyin136, sizeof(KPinyin136)/sizeof(KPinyin136[0]), sizeof(charForPinyin136)/sizeof(charForPinyin136[0]), charForPinyin136 },
	{ KPinyin137, sizeof(KPinyin137)/sizeof(KPinyin137[0]), sizeof(charForPinyin137)/sizeof(charForPinyin137[0]), charForPinyin137 },
	{ KPinyin138, sizeof(KPinyin138)/sizeof(KPinyin138[0]), sizeof(charForPinyin138)/sizeof(charForPinyin138[0]), charForPinyin138 },
	{ KPinyin139, sizeof(KPinyin139)/sizeof(KPinyin139[0]), sizeof(charForPinyin139)/sizeof(charForPinyin139[0]), charForPinyin139 },
	{ KPinyin140, sizeof(KPinyin140)/sizeof(KPinyin140[0]), sizeof(charForPinyin140)/sizeof(charForPinyin140[0]), charForPinyin140 },
	{ KPinyin141, sizeof(KPinyin141)/sizeof(KPinyin141[0]), sizeof(charForPinyin141)/sizeof(charForPinyin141[0]), charForPinyin141 },
	{ KPinyin142, sizeof(KPinyin142)/sizeof(KPinyin142[0]), sizeof(charForPinyin142)/sizeof(charForPinyin142[0]), charForPinyin142 },
	{ KPinyin143, sizeof(KPinyin143)/sizeof(KPinyin143[0]), sizeof(charForPinyin143)/sizeof(charForPinyin143[0]), charForPinyin143 },
	{ KPinyin144, sizeof(KPinyin144)/sizeof(KPinyin144[0]), sizeof(charForPinyin144)/sizeof(charForPinyin144[0]), charForPinyin144 },
	{ KPinyin145, sizeof(KPinyin145)/sizeof(KPinyin145[0]), sizeof(charForPinyin145)/sizeof(charForPinyin145[0]), charForPinyin145 },
	{ KPinyin146, sizeof(KPinyin146)/sizeof(KPinyin146[0]), sizeof(charForPinyin146)/sizeof(charForPinyin146[0]), charForPinyin146 },
	{ KPinyin147, sizeof(KPinyin147)/sizeof(KPinyin147[0]), sizeof(charForPinyin147)/sizeof(charForPinyin147[0]), charForPinyin147 },
	{ KPinyin148, sizeof(KPinyin148)/sizeof(KPinyin148[0]), sizeof(charForPinyin148)/sizeof(charForPinyin148[0]), charForPinyin148 },
	{ KPinyin149, sizeof(KPinyin149)/sizeof(KPinyin149[0]), sizeof(charForPinyin149)/sizeof(charForPinyin149[0]), charForPinyin149 },
	{ KPinyin150, sizeof(KPinyin150)/sizeof(KPinyin150[0]), sizeof(charForPinyin150)/sizeof(charForPinyin150[0]), charForPinyin150 },
	{ KPinyin151, sizeof(KPinyin151)/sizeof(KPinyin151[0]), sizeof(charForPinyin151)/sizeof(charForPinyin151[0]), charForPinyin151 },
	{ KPinyin152, sizeof(KPinyin152)/sizeof(KPinyin152[0]), sizeof(charForPinyin152)/sizeof(charForPinyin152[0]), charForPinyin152 },
	{ KPinyin153, sizeof(KPinyin153)/sizeof(KPinyin153[0]), sizeof(charForPinyin153)/sizeof(charForPinyin153[0]), charForPinyin153 },
	{ KPinyin154, sizeof(KPinyin154)/sizeof(KPinyin154[0]), sizeof(charForPinyin154)/sizeof(charForPinyin154[0]), charForPinyin154 },
	{ KPinyin155, sizeof(KPinyin155)/sizeof(KPinyin155[0]), sizeof(charForPinyin155)/sizeof(charForPinyin155[0]), charForPinyin155 },
	{ KPinyin156, sizeof(KPinyin156)/sizeof(KPinyin156[0]), sizeof(charForPinyin156)/sizeof(charForPinyin156[0]), charForPinyin156 },
	{ KPinyin157, sizeof(KPinyin157)/sizeof(KPinyin157[0]), sizeof(charForPinyin157)/sizeof(charForPinyin157[0]), charForPinyin157 },
	{ KPinyin158, sizeof(KPinyin158)/sizeof(KPinyin158[0]), sizeof(charForPinyin158)/sizeof(charForPinyin158[0]), charForPinyin158 },
	{ KPinyin159, sizeof(KPinyin159)/sizeof(KPinyin159[0]), sizeof(charForPinyin159)/sizeof(charForPinyin159[0]), charForPinyin159 },
	{ KPinyin160, sizeof(KPinyin160)/sizeof(KPinyin160[0]), sizeof(charForPinyin160)/sizeof(charForPinyin160[0]), charForPinyin160 },
	{ KPinyin161, sizeof(KPinyin161)/sizeof(KPinyin161[0]), sizeof(charForPinyin161)/sizeof(charForPinyin161[0]), charForPinyin161 },
	{ KPinyin162, sizeof(KPinyin162)/sizeof(KPinyin162[0]), sizeof(charForPinyin162)/sizeof(charForPinyin162[0]), charForPinyin162 },
	{ KPinyin163, sizeof(KPinyin163)/sizeof(KPinyin163[0]), sizeof(charForPinyin163)/sizeof(charForPinyin163[0]), charForPinyin163 },
	{ KPinyin164, sizeof(KPinyin164)/sizeof(KPinyin164[0]), sizeof(charForPinyin164)/sizeof(charForPinyin164[0]), charForPinyin164 },
	{ KPinyin165, sizeof(KPinyin165)/sizeof(KPinyin165[0]), sizeof(charForPinyin165)/sizeof(charForPinyin165[0]), charForPinyin165 },
	{ KPinyin166, sizeof(KPinyin166)/sizeof(KPinyin166[0]), sizeof(charForPinyin166)/sizeof(charForPinyin166[0]), charForPinyin166 },
	{ KPinyin167, sizeof(KPinyin167)/sizeof(KPinyin167[0]), sizeof(charForPinyin167)/sizeof(charForPinyin167[0]), charForPinyin167 },
	{ KPinyin168, sizeof(KPinyin168)/sizeof(KPinyin168[0]), sizeof(charForPinyin168)/sizeof(charForPinyin168[0]), charForPinyin168 },
	{ KPinyin169, sizeof(KPinyin169)/sizeof(KPinyin169[0]), sizeof(charForPinyin169)/sizeof(charForPinyin169[0]), charForPinyin169 },
	{ KPinyin170, sizeof(KPinyin170)/sizeof(KPinyin170[0]), sizeof(charForPinyin170)/sizeof(charForPinyin170[0]), charForPinyin170 },
	{ KPinyin171, sizeof(KPinyin171)/sizeof(KPinyin171[0]), sizeof(charForPinyin171)/sizeof(charForPinyin171[0]), charForPinyin171 },
	{ KPinyin172, sizeof(KPinyin172)/sizeof(KPinyin172[0]), sizeof(charForPinyin172)/sizeof(charForPinyin172[0]), charForPinyin172 },
	{ KPinyin173, sizeof(KPinyin173)/sizeof(KPinyin173[0]), sizeof(charForPinyin173)/sizeof(charForPinyin173[0]), charForPinyin173 },
	{ KPinyin174, sizeof(KPinyin174)/sizeof(KPinyin174[0]), sizeof(charForPinyin174)/sizeof(charForPinyin174[0]), charForPinyin174 },
	{ KPinyin175, sizeof(KPinyin175)/sizeof(KPinyin175[0]), sizeof(charForPinyin175)/sizeof(charForPinyin175[0]), charForPinyin175 },
	{ KPinyin176, sizeof(KPinyin176)/sizeof(KPinyin176[0]), sizeof(charForPinyin176)/sizeof(charForPinyin176[0]), charForPinyin176 },
	{ KPinyin177, sizeof(KPinyin177)/sizeof(KPinyin177[0]), sizeof(charForPinyin177)/sizeof(charForPinyin177[0]), charForPinyin177 },
	{ KPinyin178, sizeof(KPinyin178)/sizeof(KPinyin178[0]), sizeof(charForPinyin178)/sizeof(charForPinyin178[0]), charForPinyin178 },
	{ KPinyin179, sizeof(KPinyin179)/sizeof(KPinyin179[0]), sizeof(charForPinyin179)/sizeof(charForPinyin179[0]), charForPinyin179 },
	{ KPinyin180, sizeof(KPinyin180)/sizeof(KPinyin180[0]), sizeof(charForPinyin180)/sizeof(charForPinyin180[0]), charForPinyin180 },
	{ KPinyin181, sizeof(KPinyin181)/sizeof(KPinyin181[0]), sizeof(charForPinyin181)/sizeof(charForPinyin181[0]), charForPinyin181 },
	{ KPinyin182, sizeof(KPinyin182)/sizeof(KPinyin182[0]), sizeof(charForPinyin182)/sizeof(charForPinyin182[0]), charForPinyin182 },
	{ KPinyin183, sizeof(KPinyin183)/sizeof(KPinyin183[0]), sizeof(charForPinyin183)/sizeof(charForPinyin183[0]), charForPinyin183 },
	{ KPinyin184, sizeof(KPinyin184)/sizeof(KPinyin184[0]), sizeof(charForPinyin184)/sizeof(charForPinyin184[0]), charForPinyin184 },
	{ KPinyin185, sizeof(KPinyin185)/sizeof(KPinyin185[0]), sizeof(charForPinyin185)/sizeof(charForPinyin185[0]), charForPinyin185 },
	{ KPinyin186, sizeof(KPinyin186)/sizeof(KPinyin186[0]), sizeof(charForPinyin186)/sizeof(charForPinyin186[0]), charForPinyin186 },
	{ KPinyin187, sizeof(KPinyin187)/sizeof(KPinyin187[0]), sizeof(charForPinyin187)/sizeof(charForPinyin187[0]), charForPinyin187 },
	{ KPinyin188, sizeof(KPinyin188)/sizeof(KPinyin188[0]), sizeof(charForPinyin188)/sizeof(charForPinyin188[0]), charForPinyin188 },
	{ KPinyin189, sizeof(KPinyin189)/sizeof(KPinyin189[0]), sizeof(charForPinyin189)/sizeof(charForPinyin189[0]), charForPinyin189 },
	{ KPinyin190, sizeof(KPinyin190)/sizeof(KPinyin190[0]), sizeof(charForPinyin190)/sizeof(charForPinyin190[0]), charForPinyin190 },
	{ KPinyin191, sizeof(KPinyin191)/sizeof(KPinyin191[0]), sizeof(charForPinyin191)/sizeof(charForPinyin191[0]), charForPinyin191 },
	{ KPinyin192, sizeof(KPinyin192)/sizeof(KPinyin192[0]), sizeof(charForPinyin192)/sizeof(charForPinyin192[0]), charForPinyin192 },
	{ KPinyin193, sizeof(KPinyin193)/sizeof(KPinyin193[0]), sizeof(charForPinyin193)/sizeof(charForPinyin193[0]), charForPinyin193 },
	{ KPinyin194, sizeof(KPinyin194)/sizeof(KPinyin194[0]), sizeof(charForPinyin194)/sizeof(charForPinyin194[0]), charForPinyin194 },
	{ KPinyin195, sizeof(KPinyin195)/sizeof(KPinyin195[0]), sizeof(charForPinyin195)/sizeof(charForPinyin195[0]), charForPinyin195 },
	{ KPinyin196, sizeof(KPinyin196)/sizeof(KPinyin196[0]), sizeof(charForPinyin196)/sizeof(charForPinyin196[0]), charForPinyin196 },
	{ KPinyin197, sizeof(KPinyin197)/sizeof(KPinyin197[0]), sizeof(charForPinyin197)/sizeof(charForPinyin197[0]), charForPinyin197 },
	{ KPinyin198, sizeof(KPinyin198)/sizeof(KPinyin198[0]), sizeof(charForPinyin198)/sizeof(charForPinyin198[0]), charForPinyin198 },
	{ KPinyin199, sizeof(KPinyin199)/sizeof(KPinyin199[0]), sizeof(charForPinyin199)/sizeof(charForPinyin199[0]), charForPinyin199 },
	{ KPinyin200, sizeof(KPinyin200)/sizeof(KPinyin200[0]), sizeof(charForPinyin200)/sizeof(charForPinyin200[0]), charForPinyin200 },
	{ KPinyin201, sizeof(KPinyin201)/sizeof(KPinyin201[0]), sizeof(charForPinyin201)/sizeof(charForPinyin201[0]), charForPinyin201 },
	{ KPinyin202, sizeof(KPinyin202)/sizeof(KPinyin202[0]), sizeof(charForPinyin202)/sizeof(charForPinyin202[0]), charForPinyin202 },
	{ KPinyin203, sizeof(KPinyin203)/sizeof(KPinyin203[0]), sizeof(charForPinyin203)/sizeof(charForPinyin203[0]), charForPinyin203 },
	{ KPinyin204, sizeof(KPinyin204)/sizeof(KPinyin204[0]), sizeof(charForPinyin204)/sizeof(charForPinyin204[0]), charForPinyin204 },
	{ KPinyin205, sizeof(KPinyin205)/sizeof(KPinyin205[0]), sizeof(charForPinyin205)/sizeof(charForPinyin205[0]), charForPinyin205 },
	{ KPinyin206, sizeof(KPinyin206)/sizeof(KPinyin206[0]), sizeof(charForPinyin206)/sizeof(charForPinyin206[0]), charForPinyin206 },
	{ KPinyin207, sizeof(KPinyin207)/sizeof(KPinyin207[0]), sizeof(charForPinyin207)/sizeof(charForPinyin207[0]), charForPinyin207 },
	{ KPinyin208, sizeof(KPinyin208)/sizeof(KPinyin208[0]), sizeof(charForPinyin208)/sizeof(charForPinyin208[0]), charForPinyin208 },
	{ KPinyin209, sizeof(KPinyin209)/sizeof(KPinyin209[0]), sizeof(charForPinyin209)/sizeof(charForPinyin209[0]), charForPinyin209 },
	{ KPinyin210, sizeof(KPinyin210)/sizeof(KPinyin210[0]), sizeof(charForPinyin210)/sizeof(charForPinyin210[0]), charForPinyin210 },
	{ KPinyin211, sizeof(KPinyin211)/sizeof(KPinyin211[0]), sizeof(charForPinyin211)/sizeof(charForPinyin211[0]), charForPinyin211 },
	{ KPinyin212, sizeof(KPinyin212)/sizeof(KPinyin212[0]), sizeof(charForPinyin212)/sizeof(charForPinyin212[0]), charForPinyin212 },
	{ KPinyin213, sizeof(KPinyin213)/sizeof(KPinyin213[0]), sizeof(charForPinyin213)/sizeof(charForPinyin213[0]), charForPinyin213 },
	{ KPinyin214, sizeof(KPinyin214)/sizeof(KPinyin214[0]), sizeof(charForPinyin214)/sizeof(charForPinyin214[0]), charForPinyin214 },
	{ KPinyin215, sizeof(KPinyin215)/sizeof(KPinyin215[0]), sizeof(charForPinyin215)/sizeof(charForPinyin215[0]), charForPinyin215 },
	{ KPinyin216, sizeof(KPinyin216)/sizeof(KPinyin216[0]), sizeof(charForPinyin216)/sizeof(charForPinyin216[0]), charForPinyin216 },
	{ KPinyin217, sizeof(KPinyin217)/sizeof(KPinyin217[0]), sizeof(charForPinyin217)/sizeof(charForPinyin217[0]), charForPinyin217 },
	{ KPinyin218, sizeof(KPinyin218)/sizeof(KPinyin218[0]), sizeof(charForPinyin218)/sizeof(charForPinyin218[0]), charForPinyin218 },
	{ KPinyin219, sizeof(KPinyin219)/sizeof(KPinyin219[0]), sizeof(charForPinyin219)/sizeof(charForPinyin219[0]), charForPinyin219 },
	{ KPinyin220, sizeof(KPinyin220)/sizeof(KPinyin220[0]), sizeof(charForPinyin220)/sizeof(charForPinyin220[0]), charForPinyin220 },
	{ KPinyin221, sizeof(KPinyin221)/sizeof(KPinyin221[0]), sizeof(charForPinyin221)/sizeof(charForPinyin221[0]), charForPinyin221 },
	{ KPinyin222, sizeof(KPinyin222)/sizeof(KPinyin222[0]), sizeof(charForPinyin222)/sizeof(charForPinyin222[0]), charForPinyin222 },
	{ KPinyin223, sizeof(KPinyin223)/sizeof(KPinyin223[0]), sizeof(charForPinyin223)/sizeof(charForPinyin223[0]), charForPinyin223 },
	{ KPinyin224, sizeof(KPinyin224)/sizeof(KPinyin224[0]), sizeof(charForPinyin224)/sizeof(charForPinyin224[0]), charForPinyin224 },
	{ KPinyin225, sizeof(KPinyin225)/sizeof(KPinyin225[0]), sizeof(charForPinyin225)/sizeof(charForPinyin225[0]), charForPinyin225 },
	{ KPinyin226, sizeof(KPinyin226)/sizeof(KPinyin226[0]), sizeof(charForPinyin226)/sizeof(charForPinyin226[0]), charForPinyin226 },
	{ KPinyin227, sizeof(KPinyin227)/sizeof(KPinyin227[0]), sizeof(charForPinyin227)/sizeof(charForPinyin227[0]), charForPinyin227 },
	{ KPinyin228, sizeof(KPinyin228)/sizeof(KPinyin228[0]), sizeof(charForPinyin228)/sizeof(charForPinyin228[0]), charForPinyin228 },
	{ KPinyin229, sizeof(KPinyin229)/sizeof(KPinyin229[0]), sizeof(charForPinyin229)/sizeof(charForPinyin229[0]), charForPinyin229 },
	{ KPinyin230, sizeof(KPinyin230)/sizeof(KPinyin230[0]), sizeof(charForPinyin230)/sizeof(charForPinyin230[0]), charForPinyin230 },
	{ KPinyin231, sizeof(KPinyin231)/sizeof(KPinyin231[0]), sizeof(charForPinyin231)/sizeof(charForPinyin231[0]), charForPinyin231 },
	{ KPinyin232, sizeof(KPinyin232)/sizeof(KPinyin232[0]), sizeof(charForPinyin232)/sizeof(charForPinyin232[0]), charForPinyin232 },
	{ KPinyin233, sizeof(KPinyin233)/sizeof(KPinyin233[0]), sizeof(charForPinyin233)/sizeof(charForPinyin233[0]), charForPinyin233 },
	{ KPinyin234, sizeof(KPinyin234)/sizeof(KPinyin234[0]), sizeof(charForPinyin234)/sizeof(charForPinyin234[0]), charForPinyin234 },
	{ KPinyin235, sizeof(KPinyin235)/sizeof(KPinyin235[0]), sizeof(charForPinyin235)/sizeof(charForPinyin235[0]), charForPinyin235 },
	{ KPinyin236, sizeof(KPinyin236)/sizeof(KPinyin236[0]), sizeof(charForPinyin236)/sizeof(charForPinyin236[0]), charForPinyin236 },
	{ KPinyin237, sizeof(KPinyin237)/sizeof(KPinyin237[0]), sizeof(charForPinyin237)/sizeof(charForPinyin237[0]), charForPinyin237 },
	{ KPinyin238, sizeof(KPinyin238)/sizeof(KPinyin238[0]), sizeof(charForPinyin238)/sizeof(charForPinyin238[0]), charForPinyin238 },
	{ KPinyin239, sizeof(KPinyin239)/sizeof(KPinyin239[0]), sizeof(charForPinyin239)/sizeof(charForPinyin239[0]), charForPinyin239 },
	{ KPinyin240, sizeof(KPinyin240)/sizeof(KPinyin240[0]), sizeof(charForPinyin240)/sizeof(charForPinyin240[0]), charForPinyin240 },
	{ KPinyin241, sizeof(KPinyin241)/sizeof(KPinyin241[0]), sizeof(charForPinyin241)/sizeof(charForPinyin241[0]), charForPinyin241 },
	{ KPinyin242, sizeof(KPinyin242)/sizeof(KPinyin242[0]), sizeof(charForPinyin242)/sizeof(charForPinyin242[0]), charForPinyin242 },
	{ KPinyin243, sizeof(KPinyin243)/sizeof(KPinyin243[0]), sizeof(charForPinyin243)/sizeof(charForPinyin243[0]), charForPinyin243 },
	{ KPinyin244, sizeof(KPinyin244)/sizeof(KPinyin244[0]), sizeof(charForPinyin244)/sizeof(charForPinyin244[0]), charForPinyin244 },
	{ KPinyin245, sizeof(KPinyin245)/sizeof(KPinyin245[0]), sizeof(charForPinyin245)/sizeof(charForPinyin245[0]), charForPinyin245 },
	{ KPinyin246, sizeof(KPinyin246)/sizeof(KPinyin246[0]), sizeof(charForPinyin246)/sizeof(charForPinyin246[0]), charForPinyin246 },
	{ KPinyin247, sizeof(KPinyin247)/sizeof(KPinyin247[0]), sizeof(charForPinyin247)/sizeof(charForPinyin247[0]), charForPinyin247 },
	{ KPinyin248, sizeof(KPinyin248)/sizeof(KPinyin248[0]), sizeof(charForPinyin248)/sizeof(charForPinyin248[0]), charForPinyin248 },
	{ KPinyin249, sizeof(KPinyin249)/sizeof(KPinyin249[0]), sizeof(charForPinyin249)/sizeof(charForPinyin249[0]), charForPinyin249 },
	{ KPinyin250, sizeof(KPinyin250)/sizeof(KPinyin250[0]), sizeof(charForPinyin250)/sizeof(charForPinyin250[0]), charForPinyin250 },
	{ KPinyin251, sizeof(KPinyin251)/sizeof(KPinyin251[0]), sizeof(charForPinyin251)/sizeof(charForPinyin251[0]), charForPinyin251 },
	{ KPinyin252, sizeof(KPinyin252)/sizeof(KPinyin252[0]), sizeof(charForPinyin252)/sizeof(charForPinyin252[0]), charForPinyin252 },
	{ KPinyin253, sizeof(KPinyin253)/sizeof(KPinyin253[0]), sizeof(charForPinyin253)/sizeof(charForPinyin253[0]), charForPinyin253 },
	{ KPinyin254, sizeof(KPinyin254)/sizeof(KPinyin254[0]), sizeof(charForPinyin254)/sizeof(charForPinyin254[0]), charForPinyin254 },
	{ KPinyin255, sizeof(KPinyin255)/sizeof(KPinyin255[0]), sizeof(charForPinyin255)/sizeof(charForPinyin255[0]), charForPinyin255 },
	{ KPinyin256, sizeof(KPinyin256)/sizeof(KPinyin256[0]), sizeof(charForPinyin256)/sizeof(charForPinyin256[0]), charForPinyin256 },
	{ KPinyin257, sizeof(KPinyin257)/sizeof(KPinyin257[0]), sizeof(charForPinyin257)/sizeof(charForPinyin257[0]), charForPinyin257 },
	{ KPinyin258, sizeof(KPinyin258)/sizeof(KPinyin258[0]), sizeof(charForPinyin258)/sizeof(charForPinyin258[0]), charForPinyin258 },
	{ KPinyin259, sizeof(KPinyin259)/sizeof(KPinyin259[0]), sizeof(charForPinyin259)/sizeof(charForPinyin259[0]), charForPinyin259 },
	{ KPinyin260, sizeof(KPinyin260)/sizeof(KPinyin260[0]), sizeof(charForPinyin260)/sizeof(charForPinyin260[0]), charForPinyin260 },
	{ KPinyin261, sizeof(KPinyin261)/sizeof(KPinyin261[0]), sizeof(charForPinyin261)/sizeof(charForPinyin261[0]), charForPinyin261 },
	{ KPinyin262, sizeof(KPinyin262)/sizeof(KPinyin262[0]), sizeof(charForPinyin262)/sizeof(charForPinyin262[0]), charForPinyin262 },
	{ KPinyin263, sizeof(KPinyin263)/sizeof(KPinyin263[0]), sizeof(charForPinyin263)/sizeof(charForPinyin263[0]), charForPinyin263 },
	{ KPinyin264, sizeof(KPinyin264)/sizeof(KPinyin264[0]), sizeof(charForPinyin264)/sizeof(charForPinyin264[0]), charForPinyin264 },
	{ KPinyin265, sizeof(KPinyin265)/sizeof(KPinyin265[0]), sizeof(charForPinyin265)/sizeof(charForPinyin265[0]), charForPinyin265 },
	{ KPinyin266, sizeof(KPinyin266)/sizeof(KPinyin266[0]), sizeof(charForPinyin266)/sizeof(charForPinyin266[0]), charForPinyin266 },
	{ KPinyin267, sizeof(KPinyin267)/sizeof(KPinyin267[0]), sizeof(charForPinyin267)/sizeof(charForPinyin267[0]), charForPinyin267 },
	{ KPinyin268, sizeof(KPinyin268)/sizeof(KPinyin268[0]), sizeof(charForPinyin268)/sizeof(charForPinyin268[0]), charForPinyin268 },
	{ KPinyin269, sizeof(KPinyin269)/sizeof(KPinyin269[0]), sizeof(charForPinyin269)/sizeof(charForPinyin269[0]), charForPinyin269 },
	{ KPinyin270, sizeof(KPinyin270)/sizeof(KPinyin270[0]), sizeof(charForPinyin270)/sizeof(charForPinyin270[0]), charForPinyin270 },
	{ KPinyin271, sizeof(KPinyin271)/sizeof(KPinyin271[0]), sizeof(charForPinyin271)/sizeof(charForPinyin271[0]), charForPinyin271 },
	{ KPinyin272, sizeof(KPinyin272)/sizeof(KPinyin272[0]), sizeof(charForPinyin272)/sizeof(charForPinyin272[0]), charForPinyin272 },
	{ KPinyin273, sizeof(KPinyin273)/sizeof(KPinyin273[0]), sizeof(charForPinyin273)/sizeof(charForPinyin273[0]), charForPinyin273 },
	{ KPinyin274, sizeof(KPinyin274)/sizeof(KPinyin274[0]), sizeof(charForPinyin274)/sizeof(charForPinyin274[0]), charForPinyin274 },
	{ KPinyin275, sizeof(KPinyin275)/sizeof(KPinyin275[0]), sizeof(charForPinyin275)/sizeof(charForPinyin275[0]), charForPinyin275 },
	{ KPinyin276, sizeof(KPinyin276)/sizeof(KPinyin276[0]), sizeof(charForPinyin276)/sizeof(charForPinyin276[0]), charForPinyin276 },
	{ KPinyin277, sizeof(KPinyin277)/sizeof(KPinyin277[0]), sizeof(charForPinyin277)/sizeof(charForPinyin277[0]), charForPinyin277 },
	{ KPinyin278, sizeof(KPinyin278)/sizeof(KPinyin278[0]), sizeof(charForPinyin278)/sizeof(charForPinyin278[0]), charForPinyin278 },
	{ KPinyin279, sizeof(KPinyin279)/sizeof(KPinyin279[0]), sizeof(charForPinyin279)/sizeof(charForPinyin279[0]), charForPinyin279 },
	{ KPinyin280, sizeof(KPinyin280)/sizeof(KPinyin280[0]), sizeof(charForPinyin280)/sizeof(charForPinyin280[0]), charForPinyin280 },
	{ KPinyin281, sizeof(KPinyin281)/sizeof(KPinyin281[0]), sizeof(charForPinyin281)/sizeof(charForPinyin281[0]), charForPinyin281 },
	{ KPinyin282, sizeof(KPinyin282)/sizeof(KPinyin282[0]), sizeof(charForPinyin282)/sizeof(charForPinyin282[0]), charForPinyin282 },
	{ KPinyin283, sizeof(KPinyin283)/sizeof(KPinyin283[0]), sizeof(charForPinyin283)/sizeof(charForPinyin283[0]), charForPinyin283 },
	{ KPinyin284, sizeof(KPinyin284)/sizeof(KPinyin284[0]), sizeof(charForPinyin284)/sizeof(charForPinyin284[0]), charForPinyin284 },
	{ KPinyin285, sizeof(KPinyin285)/sizeof(KPinyin285[0]), sizeof(charForPinyin285)/sizeof(charForPinyin285[0]), charForPinyin285 },
	{ KPinyin286, sizeof(KPinyin286)/sizeof(KPinyin286[0]), sizeof(charForPinyin286)/sizeof(charForPinyin286[0]), charForPinyin286 },
	{ KPinyin287, sizeof(KPinyin287)/sizeof(KPinyin287[0]), sizeof(charForPinyin287)/sizeof(charForPinyin287[0]), charForPinyin287 },
	{ KPinyin288, sizeof(KPinyin288)/sizeof(KPinyin288[0]), sizeof(charForPinyin288)/sizeof(charForPinyin288[0]), charForPinyin288 },
	{ KPinyin289, sizeof(KPinyin289)/sizeof(KPinyin289[0]), sizeof(charForPinyin289)/sizeof(charForPinyin289[0]), charForPinyin289 },
	{ KPinyin290, sizeof(KPinyin290)/sizeof(KPinyin290[0]), sizeof(charForPinyin290)/sizeof(charForPinyin290[0]), charForPinyin290 },
	{ KPinyin291, sizeof(KPinyin291)/sizeof(KPinyin291[0]), sizeof(charForPinyin291)/sizeof(charForPinyin291[0]), charForPinyin291 },
	{ KPinyin292, sizeof(KPinyin292)/sizeof(KPinyin292[0]), sizeof(charForPinyin292)/sizeof(charForPinyin292[0]), charForPinyin292 },
	{ KPinyin293, sizeof(KPinyin293)/sizeof(KPinyin293[0]), sizeof(charForPinyin293)/sizeof(charForPinyin293[0]), charForPinyin293 },
	{ KPinyin294, sizeof(KPinyin294)/sizeof(KPinyin294[0]), sizeof(charForPinyin294)/sizeof(charForPinyin294[0]), charForPinyin294 },
	{ KPinyin295, sizeof(KPinyin295)/sizeof(KPinyin295[0]), sizeof(charForPinyin295)/sizeof(charForPinyin295[0]), charForPinyin295 },
	{ KPinyin296, sizeof(KPinyin296)/sizeof(KPinyin296[0]), sizeof(charForPinyin296)/sizeof(charForPinyin296[0]), charForPinyin296 },
	{ KPinyin297, sizeof(KPinyin297)/sizeof(KPinyin297[0]), sizeof(charForPinyin297)/sizeof(charForPinyin297[0]), charForPinyin297 },
	{ KPinyin298, sizeof(KPinyin298)/sizeof(KPinyin298[0]), sizeof(charForPinyin298)/sizeof(charForPinyin298[0]), charForPinyin298 },
	{ KPinyin299, sizeof(KPinyin299)/sizeof(KPinyin299[0]), sizeof(charForPinyin299)/sizeof(charForPinyin299[0]), charForPinyin299 },
	{ KPinyin300, sizeof(KPinyin300)/sizeof(KPinyin300[0]), sizeof(charForPinyin300)/sizeof(charForPinyin300[0]), charForPinyin300 },
	{ KPinyin301, sizeof(KPinyin301)/sizeof(KPinyin301[0]), sizeof(charForPinyin301)/sizeof(charForPinyin301[0]), charForPinyin301 },
	{ KPinyin302, sizeof(KPinyin302)/sizeof(KPinyin302[0]), sizeof(charForPinyin302)/sizeof(charForPinyin302[0]), charForPinyin302 },
	{ KPinyin303, sizeof(KPinyin303)/sizeof(KPinyin303[0]), sizeof(charForPinyin303)/sizeof(charForPinyin303[0]), charForPinyin303 },
	{ KPinyin304, sizeof(KPinyin304)/sizeof(KPinyin304[0]), sizeof(charForPinyin304)/sizeof(charForPinyin304[0]), charForPinyin304 },
	{ KPinyin305, sizeof(KPinyin305)/sizeof(KPinyin305[0]), sizeof(charForPinyin305)/sizeof(charForPinyin305[0]), charForPinyin305 },
	{ KPinyin306, sizeof(KPinyin306)/sizeof(KPinyin306[0]), sizeof(charForPinyin306)/sizeof(charForPinyin306[0]), charForPinyin306 },
	{ KPinyin307, sizeof(KPinyin307)/sizeof(KPinyin307[0]), sizeof(charForPinyin307)/sizeof(charForPinyin307[0]), charForPinyin307 },
	{ KPinyin308, sizeof(KPinyin308)/sizeof(KPinyin308[0]), sizeof(charForPinyin308)/sizeof(charForPinyin308[0]), charForPinyin308 },
	{ KPinyin309, sizeof(KPinyin309)/sizeof(KPinyin309[0]), sizeof(charForPinyin309)/sizeof(charForPinyin309[0]), charForPinyin309 },
	{ KPinyin310, sizeof(KPinyin310)/sizeof(KPinyin310[0]), sizeof(charForPinyin310)/sizeof(charForPinyin310[0]), charForPinyin310 },
	{ KPinyin311, sizeof(KPinyin311)/sizeof(KPinyin311[0]), sizeof(charForPinyin311)/sizeof(charForPinyin311[0]), charForPinyin311 },
	{ KPinyin312, sizeof(KPinyin312)/sizeof(KPinyin312[0]), sizeof(charForPinyin312)/sizeof(charForPinyin312[0]), charForPinyin312 },
	{ KPinyin313, sizeof(KPinyin313)/sizeof(KPinyin313[0]), sizeof(charForPinyin313)/sizeof(charForPinyin313[0]), charForPinyin313 },
	{ KPinyin314, sizeof(KPinyin314)/sizeof(KPinyin314[0]), sizeof(charForPinyin314)/sizeof(charForPinyin314[0]), charForPinyin314 },
	{ KPinyin315, sizeof(KPinyin315)/sizeof(KPinyin315[0]), sizeof(charForPinyin315)/sizeof(charForPinyin315[0]), charForPinyin315 },
	{ KPinyin316, sizeof(KPinyin316)/sizeof(KPinyin316[0]), sizeof(charForPinyin316)/sizeof(charForPinyin316[0]), charForPinyin316 },
	{ KPinyin317, sizeof(KPinyin317)/sizeof(KPinyin317[0]), sizeof(charForPinyin317)/sizeof(charForPinyin317[0]), charForPinyin317 },
	{ KPinyin318, sizeof(KPinyin318)/sizeof(KPinyin318[0]), sizeof(charForPinyin318)/sizeof(charForPinyin318[0]), charForPinyin318 },
	{ KPinyin319, sizeof(KPinyin319)/sizeof(KPinyin319[0]), sizeof(charForPinyin319)/sizeof(charForPinyin319[0]), charForPinyin319 },
	{ KPinyin320, sizeof(KPinyin320)/sizeof(KPinyin320[0]), sizeof(charForPinyin320)/sizeof(charForPinyin320[0]), charForPinyin320 },
	{ KPinyin321, sizeof(KPinyin321)/sizeof(KPinyin321[0]), sizeof(charForPinyin321)/sizeof(charForPinyin321[0]), charForPinyin321 },
	{ KPinyin322, sizeof(KPinyin322)/sizeof(KPinyin322[0]), sizeof(charForPinyin322)/sizeof(charForPinyin322[0]), charForPinyin322 },
	{ KPinyin323, sizeof(KPinyin323)/sizeof(KPinyin323[0]), sizeof(charForPinyin323)/sizeof(charForPinyin323[0]), charForPinyin323 },
	{ KPinyin324, sizeof(KPinyin324)/sizeof(KPinyin324[0]), sizeof(charForPinyin324)/sizeof(charForPinyin324[0]), charForPinyin324 },
	{ KPinyin325, sizeof(KPinyin325)/sizeof(KPinyin325[0]), sizeof(charForPinyin325)/sizeof(charForPinyin325[0]), charForPinyin325 },
	{ KPinyin326, sizeof(KPinyin326)/sizeof(KPinyin326[0]), sizeof(charForPinyin326)/sizeof(charForPinyin326[0]), charForPinyin326 },
	{ KPinyin327, sizeof(KPinyin327)/sizeof(KPinyin327[0]), sizeof(charForPinyin327)/sizeof(charForPinyin327[0]), charForPinyin327 },
	{ KPinyin328, sizeof(KPinyin328)/sizeof(KPinyin328[0]), sizeof(charForPinyin328)/sizeof(charForPinyin328[0]), charForPinyin328 },
	{ KPinyin329, sizeof(KPinyin329)/sizeof(KPinyin329[0]), sizeof(charForPinyin329)/sizeof(charForPinyin329[0]), charForPinyin329 },
	{ KPinyin330, sizeof(KPinyin330)/sizeof(KPinyin330[0]), sizeof(charForPinyin330)/sizeof(charForPinyin330[0]), charForPinyin330 },
	{ KPinyin331, sizeof(KPinyin331)/sizeof(KPinyin331[0]), sizeof(charForPinyin331)/sizeof(charForPinyin331[0]), charForPinyin331 },
	{ KPinyin332, sizeof(KPinyin332)/sizeof(KPinyin332[0]), sizeof(charForPinyin332)/sizeof(charForPinyin332[0]), charForPinyin332 },
	{ KPinyin333, sizeof(KPinyin333)/sizeof(KPinyin333[0]), sizeof(charForPinyin333)/sizeof(charForPinyin333[0]), charForPinyin333 },
	{ KPinyin334, sizeof(KPinyin334)/sizeof(KPinyin334[0]), sizeof(charForPinyin334)/sizeof(charForPinyin334[0]), charForPinyin334 },
	{ KPinyin335, sizeof(KPinyin335)/sizeof(KPinyin335[0]), sizeof(charForPinyin335)/sizeof(charForPinyin335[0]), charForPinyin335 },
	{ KPinyin336, sizeof(KPinyin336)/sizeof(KPinyin336[0]), sizeof(charForPinyin336)/sizeof(charForPinyin336[0]), charForPinyin336 },
	{ KPinyin337, sizeof(KPinyin337)/sizeof(KPinyin337[0]), sizeof(charForPinyin337)/sizeof(charForPinyin337[0]), charForPinyin337 },
	{ KPinyin338, sizeof(KPinyin338)/sizeof(KPinyin338[0]), sizeof(charForPinyin338)/sizeof(charForPinyin338[0]), charForPinyin338 },
	{ KPinyin339, sizeof(KPinyin339)/sizeof(KPinyin339[0]), sizeof(charForPinyin339)/sizeof(charForPinyin339[0]), charForPinyin339 },
	{ KPinyin340, sizeof(KPinyin340)/sizeof(KPinyin340[0]), sizeof(charForPinyin340)/sizeof(charForPinyin340[0]), charForPinyin340 },
	{ KPinyin341, sizeof(KPinyin341)/sizeof(KPinyin341[0]), sizeof(charForPinyin341)/sizeof(charForPinyin341[0]), charForPinyin341 },
	{ KPinyin342, sizeof(KPinyin342)/sizeof(KPinyin342[0]), sizeof(charForPinyin342)/sizeof(charForPinyin342[0]), charForPinyin342 },
	{ KPinyin343, sizeof(KPinyin343)/sizeof(KPinyin343[0]), sizeof(charForPinyin343)/sizeof(charForPinyin343[0]), charForPinyin343 },
	{ KPinyin344, sizeof(KPinyin344)/sizeof(KPinyin344[0]), sizeof(charForPinyin344)/sizeof(charForPinyin344[0]), charForPinyin344 },
	{ KPinyin345, sizeof(KPinyin345)/sizeof(KPinyin345[0]), sizeof(charForPinyin345)/sizeof(charForPinyin345[0]), charForPinyin345 },
	{ KPinyin346, sizeof(KPinyin346)/sizeof(KPinyin346[0]), sizeof(charForPinyin346)/sizeof(charForPinyin346[0]), charForPinyin346 },
	{ KPinyin347, sizeof(KPinyin347)/sizeof(KPinyin347[0]), sizeof(charForPinyin347)/sizeof(charForPinyin347[0]), charForPinyin347 },
	{ KPinyin348, sizeof(KPinyin348)/sizeof(KPinyin348[0]), sizeof(charForPinyin348)/sizeof(charForPinyin348[0]), charForPinyin348 },
	{ KPinyin349, sizeof(KPinyin349)/sizeof(KPinyin349[0]), sizeof(charForPinyin349)/sizeof(charForPinyin349[0]), charForPinyin349 },
	{ KPinyin350, sizeof(KPinyin350)/sizeof(KPinyin350[0]), sizeof(charForPinyin350)/sizeof(charForPinyin350[0]), charForPinyin350 },
	{ KPinyin351, sizeof(KPinyin351)/sizeof(KPinyin351[0]), sizeof(charForPinyin351)/sizeof(charForPinyin351[0]), charForPinyin351 },
	{ KPinyin352, sizeof(KPinyin352)/sizeof(KPinyin352[0]), sizeof(charForPinyin352)/sizeof(charForPinyin352[0]), charForPinyin352 },
	{ KPinyin353, sizeof(KPinyin353)/sizeof(KPinyin353[0]), sizeof(charForPinyin353)/sizeof(charForPinyin353[0]), charForPinyin353 },
	{ KPinyin354, sizeof(KPinyin354)/sizeof(KPinyin354[0]), sizeof(charForPinyin354)/sizeof(charForPinyin354[0]), charForPinyin354 },
	{ KPinyin355, sizeof(KPinyin355)/sizeof(KPinyin355[0]), sizeof(charForPinyin355)/sizeof(charForPinyin355[0]), charForPinyin355 },
	{ KPinyin356, sizeof(KPinyin356)/sizeof(KPinyin356[0]), sizeof(charForPinyin356)/sizeof(charForPinyin356[0]), charForPinyin356 },
	{ KPinyin357, sizeof(KPinyin357)/sizeof(KPinyin357[0]), sizeof(charForPinyin357)/sizeof(charForPinyin357[0]), charForPinyin357 },
	{ KPinyin358, sizeof(KPinyin358)/sizeof(KPinyin358[0]), sizeof(charForPinyin358)/sizeof(charForPinyin358[0]), charForPinyin358 },
	{ KPinyin359, sizeof(KPinyin359)/sizeof(KPinyin359[0]), sizeof(charForPinyin359)/sizeof(charForPinyin359[0]), charForPinyin359 },
	{ KPinyin360, sizeof(KPinyin360)/sizeof(KPinyin360[0]), sizeof(charForPinyin360)/sizeof(charForPinyin360[0]), charForPinyin360 },
	{ KPinyin361, sizeof(KPinyin361)/sizeof(KPinyin361[0]), sizeof(charForPinyin361)/sizeof(charForPinyin361[0]), charForPinyin361 },
	{ KPinyin362, sizeof(KPinyin362)/sizeof(KPinyin362[0]), sizeof(charForPinyin362)/sizeof(charForPinyin362[0]), charForPinyin362 },
	{ KPinyin363, sizeof(KPinyin363)/sizeof(KPinyin363[0]), sizeof(charForPinyin363)/sizeof(charForPinyin363[0]), charForPinyin363 },
	{ KPinyin364, sizeof(KPinyin364)/sizeof(KPinyin364[0]), sizeof(charForPinyin364)/sizeof(charForPinyin364[0]), charForPinyin364 },
	{ KPinyin365, sizeof(KPinyin365)/sizeof(KPinyin365[0]), sizeof(charForPinyin365)/sizeof(charForPinyin365[0]), charForPinyin365 },
	{ KPinyin366, sizeof(KPinyin366)/sizeof(KPinyin366[0]), sizeof(charForPinyin366)/sizeof(charForPinyin366[0]), charForPinyin366 },
	{ KPinyin367, sizeof(KPinyin367)/sizeof(KPinyin367[0]), sizeof(charForPinyin367)/sizeof(charForPinyin367[0]), charForPinyin367 },
	{ KPinyin368, sizeof(KPinyin368)/sizeof(KPinyin368[0]), sizeof(charForPinyin368)/sizeof(charForPinyin368[0]), charForPinyin368 },
	{ KPinyin369, sizeof(KPinyin369)/sizeof(KPinyin369[0]), sizeof(charForPinyin369)/sizeof(charForPinyin369[0]), charForPinyin369 },
	{ KPinyin370, sizeof(KPinyin370)/sizeof(KPinyin370[0]), sizeof(charForPinyin370)/sizeof(charForPinyin370[0]), charForPinyin370 },
	{ KPinyin371, sizeof(KPinyin371)/sizeof(KPinyin371[0]), sizeof(charForPinyin371)/sizeof(charForPinyin371[0]), charForPinyin371 },
	{ KPinyin372, sizeof(KPinyin372)/sizeof(KPinyin372[0]), sizeof(charForPinyin372)/sizeof(charForPinyin372[0]), charForPinyin372 },
	{ KPinyin373, sizeof(KPinyin373)/sizeof(KPinyin373[0]), sizeof(charForPinyin373)/sizeof(charForPinyin373[0]), charForPinyin373 },
	{ KPinyin374, sizeof(KPinyin374)/sizeof(KPinyin374[0]), sizeof(charForPinyin374)/sizeof(charForPinyin374[0]), charForPinyin374 },
	{ KPinyin375, sizeof(KPinyin375)/sizeof(KPinyin375[0]), sizeof(charForPinyin375)/sizeof(charForPinyin375[0]), charForPinyin375 },
	{ KPinyin376, sizeof(KPinyin376)/sizeof(KPinyin376[0]), sizeof(charForPinyin376)/sizeof(charForPinyin376[0]), charForPinyin376 },
	{ KPinyin377, sizeof(KPinyin377)/sizeof(KPinyin377[0]), sizeof(charForPinyin377)/sizeof(charForPinyin377[0]), charForPinyin377 },
	{ KPinyin378, sizeof(KPinyin378)/sizeof(KPinyin378[0]), sizeof(charForPinyin378)/sizeof(charForPinyin378[0]), charForPinyin378 },
	{ KPinyin379, sizeof(KPinyin379)/sizeof(KPinyin379[0]), sizeof(charForPinyin379)/sizeof(charForPinyin379[0]), charForPinyin379 },
	{ KPinyin380, sizeof(KPinyin380)/sizeof(KPinyin380[0]), sizeof(charForPinyin380)/sizeof(charForPinyin380[0]), charForPinyin380 },
	{ KPinyin381, sizeof(KPinyin381)/sizeof(KPinyin381[0]), sizeof(charForPinyin381)/sizeof(charForPinyin381[0]), charForPinyin381 },
	{ KPinyin382, sizeof(KPinyin382)/sizeof(KPinyin382[0]), sizeof(charForPinyin382)/sizeof(charForPinyin382[0]), charForPinyin382 },
	{ KPinyin383, sizeof(KPinyin383)/sizeof(KPinyin383[0]), sizeof(charForPinyin383)/sizeof(charForPinyin383[0]), charForPinyin383 },
	{ KPinyin384, sizeof(KPinyin384)/sizeof(KPinyin384[0]), sizeof(charForPinyin384)/sizeof(charForPinyin384[0]), charForPinyin384 },
	{ KPinyin385, sizeof(KPinyin385)/sizeof(KPinyin385[0]), sizeof(charForPinyin385)/sizeof(charForPinyin385[0]), charForPinyin385 },
	{ KPinyin386, sizeof(KPinyin386)/sizeof(KPinyin386[0]), sizeof(charForPinyin386)/sizeof(charForPinyin386[0]), charForPinyin386 },
	{ KPinyin387, sizeof(KPinyin387)/sizeof(KPinyin387[0]), sizeof(charForPinyin387)/sizeof(charForPinyin387[0]), charForPinyin387 },
	{ KPinyin388, sizeof(KPinyin388)/sizeof(KPinyin388[0]), sizeof(charForPinyin388)/sizeof(charForPinyin388[0]), charForPinyin388 },
	{ KPinyin389, sizeof(KPinyin389)/sizeof(KPinyin389[0]), sizeof(charForPinyin389)/sizeof(charForPinyin389[0]), charForPinyin389 },
	{ KPinyin390, sizeof(KPinyin390)/sizeof(KPinyin390[0]), sizeof(charForPinyin390)/sizeof(charForPinyin390[0]), charForPinyin390 },
	{ KPinyin391, sizeof(KPinyin391)/sizeof(KPinyin391[0]), sizeof(charForPinyin391)/sizeof(charForPinyin391[0]), charForPinyin391 },
	{ KPinyin392, sizeof(KPinyin392)/sizeof(KPinyin392[0]), sizeof(charForPinyin392)/sizeof(charForPinyin392[0]), charForPinyin392 },
	{ KPinyin393, sizeof(KPinyin393)/sizeof(KPinyin393[0]), sizeof(charForPinyin393)/sizeof(charForPinyin393[0]), charForPinyin393 },
	{ KPinyin394, sizeof(KPinyin394)/sizeof(KPinyin394[0]), sizeof(charForPinyin394)/sizeof(charForPinyin394[0]), charForPinyin394 },
	{ KPinyin395, sizeof(KPinyin395)/sizeof(KPinyin395[0]), sizeof(charForPinyin395)/sizeof(charForPinyin395[0]), charForPinyin395 },
	{ KPinyin396, sizeof(KPinyin396)/sizeof(KPinyin396[0]), sizeof(charForPinyin396)/sizeof(charForPinyin396[0]), charForPinyin396 },
	{ KPinyin397, sizeof(KPinyin397)/sizeof(KPinyin397[0]), sizeof(charForPinyin397)/sizeof(charForPinyin397[0]), charForPinyin397 },
	{ KPinyin398, sizeof(KPinyin398)/sizeof(KPinyin398[0]), sizeof(charForPinyin398)/sizeof(charForPinyin398[0]), charForPinyin398 },
	{ KPinyin399, sizeof(KPinyin399)/sizeof(KPinyin399[0]), sizeof(charForPinyin399)/sizeof(charForPinyin399[0]), charForPinyin399 },
	{ KPinyin400, sizeof(KPinyin400)/sizeof(KPinyin400[0]), sizeof(charForPinyin400)/sizeof(charForPinyin400[0]), charForPinyin400 },
	{ KPinyin401, sizeof(KPinyin401)/sizeof(KPinyin401[0]), sizeof(charForPinyin401)/sizeof(charForPinyin401[0]), charForPinyin401 },
	{ KPinyin402, sizeof(KPinyin402)/sizeof(KPinyin402[0]), sizeof(charForPinyin402)/sizeof(charForPinyin402[0]), charForPinyin402 },
	{ KPinyin403, sizeof(KPinyin403)/sizeof(KPinyin403[0]), sizeof(charForPinyin403)/sizeof(charForPinyin403[0]), charForPinyin403 },
	{ KPinyin404, sizeof(KPinyin404)/sizeof(KPinyin404[0]), sizeof(charForPinyin404)/sizeof(charForPinyin404[0]), charForPinyin404 },
	{ KPinyin405, sizeof(KPinyin405)/sizeof(KPinyin405[0]), sizeof(charForPinyin405)/sizeof(charForPinyin405[0]), charForPinyin405 },
	{ KPinyin406, sizeof(KPinyin406)/sizeof(KPinyin406[0]), sizeof(charForPinyin406)/sizeof(charForPinyin406[0]), charForPinyin406 },
	{ KPinyin407, sizeof(KPinyin407)/sizeof(KPinyin407[0]), sizeof(charForPinyin407)/sizeof(charForPinyin407[0]), charForPinyin407 },
	{ KPinyin408, sizeof(KPinyin408)/sizeof(KPinyin408[0]), sizeof(charForPinyin408)/sizeof(charForPinyin408[0]), charForPinyin408 },
	{ KPinyin409, sizeof(KPinyin409)/sizeof(KPinyin409[0]), sizeof(charForPinyin409)/sizeof(charForPinyin409[0]), charForPinyin409 },
	{ KPinyin410, sizeof(KPinyin410)/sizeof(KPinyin410[0]), sizeof(charForPinyin410)/sizeof(charForPinyin410[0]), charForPinyin410 },
	{ KPinyin411, sizeof(KPinyin411)/sizeof(KPinyin411[0]), sizeof(charForPinyin411)/sizeof(charForPinyin411[0]), charForPinyin411 },
	{ KPinyin412, sizeof(KPinyin412)/sizeof(KPinyin412[0]), sizeof(charForPinyin412)/sizeof(charForPinyin412[0]), charForPinyin412 },
	{ KPinyin413, sizeof(KPinyin413)/sizeof(KPinyin413[0]), sizeof(charForPinyin413)/sizeof(charForPinyin413[0]), charForPinyin413 },
	{ KPinyin414, sizeof(KPinyin414)/sizeof(KPinyin414[0]), sizeof(charForPinyin414)/sizeof(charForPinyin414[0]), charForPinyin414 },
	{ KPinyin415, sizeof(KPinyin415)/sizeof(KPinyin415[0]), sizeof(charForPinyin415)/sizeof(charForPinyin415[0]), charForPinyin415 },
	{ KPinyin416, sizeof(KPinyin416)/sizeof(KPinyin416[0]), sizeof(charForPinyin416)/sizeof(charForPinyin416[0]), charForPinyin416 },
	{ KPinyin417, sizeof(KPinyin417)/sizeof(KPinyin417[0]), sizeof(charForPinyin417)/sizeof(charForPinyin417[0]), charForPinyin417 },
	{ KPinyin418, sizeof(KPinyin418)/sizeof(KPinyin418[0]), sizeof(charForPinyin418)/sizeof(charForPinyin418[0]), charForPinyin418 },
	{ KPinyin419, sizeof(KPinyin419)/sizeof(KPinyin419[0]), sizeof(charForPinyin419)/sizeof(charForPinyin419[0]), charForPinyin419 },
	{ KPinyin420, sizeof(KPinyin420)/sizeof(KPinyin420[0]), sizeof(charForPinyin420)/sizeof(charForPinyin420[0]), charForPinyin420 },
	{ KPinyin421, sizeof(KPinyin421)/sizeof(KPinyin421[0]), sizeof(charForPinyin421)/sizeof(charForPinyin421[0]), charForPinyin421 },
	{ KPinyin422, sizeof(KPinyin422)/sizeof(KPinyin422[0]), sizeof(charForPinyin422)/sizeof(charForPinyin422[0]), charForPinyin422 },
	{ KPinyin423, sizeof(KPinyin423)/sizeof(KPinyin423[0]), sizeof(charForPinyin423)/sizeof(charForPinyin423[0]), charForPinyin423 },
	{ KPinyin424, sizeof(KPinyin424)/sizeof(KPinyin424[0]), sizeof(charForPinyin424)/sizeof(charForPinyin424[0]), charForPinyin424 },
	{ KPinyin425, sizeof(KPinyin425)/sizeof(KPinyin425[0]), sizeof(charForPinyin425)/sizeof(charForPinyin425[0]), charForPinyin425 },
	{ KPinyin426, sizeof(KPinyin426)/sizeof(KPinyin426[0]), sizeof(charForPinyin426)/sizeof(charForPinyin426[0]), charForPinyin426 },
	{ KPinyin427, sizeof(KPinyin427)/sizeof(KPinyin427[0]), sizeof(charForPinyin427)/sizeof(charForPinyin427[0]), charForPinyin427 },
	{ KPinyin428, sizeof(KPinyin428)/sizeof(KPinyin428[0]), sizeof(charForPinyin428)/sizeof(charForPinyin428[0]), charForPinyin428 },
	{ KPinyin429, sizeof(KPinyin429)/sizeof(KPinyin429[0]), sizeof(charForPinyin429)/sizeof(charForPinyin429[0]), charForPinyin429 },
	{ KPinyin430, sizeof(KPinyin430)/sizeof(KPinyin430[0]), sizeof(charForPinyin430)/sizeof(charForPinyin430[0]), charForPinyin430 },
	{ KPinyin431, sizeof(KPinyin431)/sizeof(KPinyin431[0]), sizeof(charForPinyin431)/sizeof(charForPinyin431[0]), charForPinyin431 },
	{ KPinyin432, sizeof(KPinyin432)/sizeof(KPinyin432[0]), sizeof(charForPinyin432)/sizeof(charForPinyin432[0]), charForPinyin432 },
	{ KPinyin433, sizeof(KPinyin433)/sizeof(KPinyin433[0]), sizeof(charForPinyin433)/sizeof(charForPinyin433[0]), charForPinyin433 },
	{ KPinyin434, sizeof(KPinyin434)/sizeof(KPinyin434[0]), sizeof(charForPinyin434)/sizeof(charForPinyin434[0]), charForPinyin434 },
	{ KPinyin435, sizeof(KPinyin435)/sizeof(KPinyin435[0]), sizeof(charForPinyin435)/sizeof(charForPinyin435[0]), charForPinyin435 },
	{ KPinyin436, sizeof(KPinyin436)/sizeof(KPinyin436[0]), sizeof(charForPinyin436)/sizeof(charForPinyin436[0]), charForPinyin436 },
	{ KPinyin437, sizeof(KPinyin437)/sizeof(KPinyin437[0]), sizeof(charForPinyin437)/sizeof(charForPinyin437[0]), charForPinyin437 },
	{ KPinyin438, sizeof(KPinyin438)/sizeof(KPinyin438[0]), sizeof(charForPinyin438)/sizeof(charForPinyin438[0]), charForPinyin438 },
	{ KPinyin439, sizeof(KPinyin439)/sizeof(KPinyin439[0]), sizeof(charForPinyin439)/sizeof(charForPinyin439[0]), charForPinyin439 },
	{ KPinyin440, sizeof(KPinyin440)/sizeof(KPinyin440[0]), sizeof(charForPinyin440)/sizeof(charForPinyin440[0]), charForPinyin440 },
	{ KPinyin441, sizeof(KPinyin441)/sizeof(KPinyin441[0]), sizeof(charForPinyin441)/sizeof(charForPinyin441[0]), charForPinyin441 },
	{ KPinyin442, sizeof(KPinyin442)/sizeof(KPinyin442[0]), sizeof(charForPinyin442)/sizeof(charForPinyin442[0]), charForPinyin442 },
	{ KPinyin443, sizeof(KPinyin443)/sizeof(KPinyin443[0]), sizeof(charForPinyin443)/sizeof(charForPinyin443[0]), charForPinyin443 },
	{ KPinyin444, sizeof(KPinyin444)/sizeof(KPinyin444[0]), sizeof(charForPinyin444)/sizeof(charForPinyin444[0]), charForPinyin444 },
	{ KPinyin445, sizeof(KPinyin445)/sizeof(KPinyin445[0]), sizeof(charForPinyin445)/sizeof(charForPinyin445[0]), charForPinyin445 },
	{ KPinyin446, sizeof(KPinyin446)/sizeof(KPinyin446[0]), sizeof(charForPinyin446)/sizeof(charForPinyin446[0]), charForPinyin446 },
	{ KPinyin447, sizeof(KPinyin447)/sizeof(KPinyin447[0]), sizeof(charForPinyin447)/sizeof(charForPinyin447[0]), charForPinyin447 },
	{ KPinyin448, sizeof(KPinyin448)/sizeof(KPinyin448[0]), sizeof(charForPinyin448)/sizeof(charForPinyin448[0]), charForPinyin448 },
	{ KPinyin449, sizeof(KPinyin449)/sizeof(KPinyin449[0]), sizeof(charForPinyin449)/sizeof(charForPinyin449[0]), charForPinyin449 },
	{ KPinyin450, sizeof(KPinyin450)/sizeof(KPinyin450[0]), sizeof(charForPinyin450)/sizeof(charForPinyin450[0]), charForPinyin450 },
	{ KPinyin451, sizeof(KPinyin451)/sizeof(KPinyin451[0]), sizeof(charForPinyin451)/sizeof(charForPinyin451[0]), charForPinyin451 },
	{ KPinyin452, sizeof(KPinyin452)/sizeof(KPinyin452[0]), sizeof(charForPinyin452)/sizeof(charForPinyin452[0]), charForPinyin452 },
	{ KPinyin453, sizeof(KPinyin453)/sizeof(KPinyin453[0]), sizeof(charForPinyin453)/sizeof(charForPinyin453[0]), charForPinyin453 },
	{ KPinyin454, sizeof(KPinyin454)/sizeof(KPinyin454[0]), sizeof(charForPinyin454)/sizeof(charForPinyin454[0]), charForPinyin454 },
	{ KPinyin455, sizeof(KPinyin455)/sizeof(KPinyin455[0]), sizeof(charForPinyin455)/sizeof(charForPinyin455[0]), charForPinyin455 },
	{ KPinyin456, sizeof(KPinyin456)/sizeof(KPinyin456[0]), sizeof(charForPinyin456)/sizeof(charForPinyin456[0]), charForPinyin456 },
	{ KPinyin457, sizeof(KPinyin457)/sizeof(KPinyin457[0]), sizeof(charForPinyin457)/sizeof(charForPinyin457[0]), charForPinyin457 },
	{ KPinyin458, sizeof(KPinyin458)/sizeof(KPinyin458[0]), sizeof(charForPinyin458)/sizeof(charForPinyin458[0]), charForPinyin458 },
	{ KPinyin459, sizeof(KPinyin459)/sizeof(KPinyin459[0]), sizeof(charForPinyin459)/sizeof(charForPinyin459[0]), charForPinyin459 },
	{ KPinyin460, sizeof(KPinyin460)/sizeof(KPinyin460[0]), sizeof(charForPinyin460)/sizeof(charForPinyin460[0]), charForPinyin460 },
	{ KPinyin461, sizeof(KPinyin461)/sizeof(KPinyin461[0]), sizeof(charForPinyin461)/sizeof(charForPinyin461[0]), charForPinyin461 },
	{ KPinyin462, sizeof(KPinyin462)/sizeof(KPinyin462[0]), sizeof(charForPinyin462)/sizeof(charForPinyin462[0]), charForPinyin462 },
	{ KPinyin463, sizeof(KPinyin463)/sizeof(KPinyin463[0]), sizeof(charForPinyin463)/sizeof(charForPinyin463[0]), charForPinyin463 },
	{ KPinyin464, sizeof(KPinyin464)/sizeof(KPinyin464[0]), sizeof(charForPinyin464)/sizeof(charForPinyin464[0]), charForPinyin464 },
	{ KPinyin465, sizeof(KPinyin465)/sizeof(KPinyin465[0]), sizeof(charForPinyin465)/sizeof(charForPinyin465[0]), charForPinyin465 },
	{ KPinyin466, sizeof(KPinyin466)/sizeof(KPinyin466[0]), sizeof(charForPinyin466)/sizeof(charForPinyin466[0]), charForPinyin466 },
	{ KPinyin467, sizeof(KPinyin467)/sizeof(KPinyin467[0]), sizeof(charForPinyin467)/sizeof(charForPinyin467[0]), charForPinyin467 },
	{ KPinyin468, sizeof(KPinyin468)/sizeof(KPinyin468[0]), sizeof(charForPinyin468)/sizeof(charForPinyin468[0]), charForPinyin468 },
	{ KPinyin469, sizeof(KPinyin469)/sizeof(KPinyin469[0]), sizeof(charForPinyin469)/sizeof(charForPinyin469[0]), charForPinyin469 },
	{ KPinyin470, sizeof(KPinyin470)/sizeof(KPinyin470[0]), sizeof(charForPinyin470)/sizeof(charForPinyin470[0]), charForPinyin470 },
	{ KPinyin471, sizeof(KPinyin471)/sizeof(KPinyin471[0]), sizeof(charForPinyin471)/sizeof(charForPinyin471[0]), charForPinyin471 },
	{ KPinyin472, sizeof(KPinyin472)/sizeof(KPinyin472[0]), sizeof(charForPinyin472)/sizeof(charForPinyin472[0]), charForPinyin472 },
	{ KPinyin473, sizeof(KPinyin473)/sizeof(KPinyin473[0]), sizeof(charForPinyin473)/sizeof(charForPinyin473[0]), charForPinyin473 },
	{ KPinyin474, sizeof(KPinyin474)/sizeof(KPinyin474[0]), sizeof(charForPinyin474)/sizeof(charForPinyin474[0]), charForPinyin474 },
	{ KPinyin475, sizeof(KPinyin475)/sizeof(KPinyin475[0]), sizeof(charForPinyin475)/sizeof(charForPinyin475[0]), charForPinyin475 },
	{ KPinyin476, sizeof(KPinyin476)/sizeof(KPinyin476[0]), sizeof(charForPinyin476)/sizeof(charForPinyin476[0]), charForPinyin476 },
	{ KPinyin477, sizeof(KPinyin477)/sizeof(KPinyin477[0]), sizeof(charForPinyin477)/sizeof(charForPinyin477[0]), charForPinyin477 },
	{ KPinyin478, sizeof(KPinyin478)/sizeof(KPinyin478[0]), sizeof(charForPinyin478)/sizeof(charForPinyin478[0]), charForPinyin478 },
	{ KPinyin479, sizeof(KPinyin479)/sizeof(KPinyin479[0]), sizeof(charForPinyin479)/sizeof(charForPinyin479[0]), charForPinyin479 },
	{ KPinyin480, sizeof(KPinyin480)/sizeof(KPinyin480[0]), sizeof(charForPinyin480)/sizeof(charForPinyin480[0]), charForPinyin480 },
	{ KPinyin481, sizeof(KPinyin481)/sizeof(KPinyin481[0]), sizeof(charForPinyin481)/sizeof(charForPinyin481[0]), charForPinyin481 },
	{ KPinyin482, sizeof(KPinyin482)/sizeof(KPinyin482[0]), sizeof(charForPinyin482)/sizeof(charForPinyin482[0]), charForPinyin482 },
	{ KPinyin483, sizeof(KPinyin483)/sizeof(KPinyin483[0]), sizeof(charForPinyin483)/sizeof(charForPinyin483[0]), charForPinyin483 },
	{ KPinyin484, sizeof(KPinyin484)/sizeof(KPinyin484[0]), sizeof(charForPinyin484)/sizeof(charForPinyin484[0]), charForPinyin484 },
	{ KPinyin485, sizeof(KPinyin485)/sizeof(KPinyin485[0]), sizeof(charForPinyin485)/sizeof(charForPinyin485[0]), charForPinyin485 },
	{ KPinyin486, sizeof(KPinyin486)/sizeof(KPinyin486[0]), sizeof(charForPinyin486)/sizeof(charForPinyin486[0]), charForPinyin486 },
	{ KPinyin487, sizeof(KPinyin487)/sizeof(KPinyin487[0]), sizeof(charForPinyin487)/sizeof(charForPinyin487[0]), charForPinyin487 },
	{ KPinyin488, sizeof(KPinyin488)/sizeof(KPinyin488[0]), sizeof(charForPinyin488)/sizeof(charForPinyin488[0]), charForPinyin488 },
	{ KPinyin489, sizeof(KPinyin489)/sizeof(KPinyin489[0]), sizeof(charForPinyin489)/sizeof(charForPinyin489[0]), charForPinyin489 },
	{ KPinyin490, sizeof(KPinyin490)/sizeof(KPinyin490[0]), sizeof(charForPinyin490)/sizeof(charForPinyin490[0]), charForPinyin490 },
	{ KPinyin491, sizeof(KPinyin491)/sizeof(KPinyin491[0]), sizeof(charForPinyin491)/sizeof(charForPinyin491[0]), charForPinyin491 },
	{ KPinyin492, sizeof(KPinyin492)/sizeof(KPinyin492[0]), sizeof(charForPinyin492)/sizeof(charForPinyin492[0]), charForPinyin492 },
	{ KPinyin493, sizeof(KPinyin493)/sizeof(KPinyin493[0]), sizeof(charForPinyin493)/sizeof(charForPinyin493[0]), charForPinyin493 },
	{ KPinyin494, sizeof(KPinyin494)/sizeof(KPinyin494[0]), sizeof(charForPinyin494)/sizeof(charForPinyin494[0]), charForPinyin494 },
	{ KPinyin495, sizeof(KPinyin495)/sizeof(KPinyin495[0]), sizeof(charForPinyin495)/sizeof(charForPinyin495[0]), charForPinyin495 },
	{ KPinyin496, sizeof(KPinyin496)/sizeof(KPinyin496[0]), sizeof(charForPinyin496)/sizeof(charForPinyin496[0]), charForPinyin496 },
	{ KPinyin497, sizeof(KPinyin497)/sizeof(KPinyin497[0]), sizeof(charForPinyin497)/sizeof(charForPinyin497[0]), charForPinyin497 },
	{ KPinyin498, sizeof(KPinyin498)/sizeof(KPinyin498[0]), sizeof(charForPinyin498)/sizeof(charForPinyin498[0]), charForPinyin498 },
	{ KPinyin499, sizeof(KPinyin499)/sizeof(KPinyin499[0]), sizeof(charForPinyin499)/sizeof(charForPinyin499[0]), charForPinyin499 },
	{ KPinyin500, sizeof(KPinyin500)/sizeof(KPinyin500[0]), sizeof(charForPinyin500)/sizeof(charForPinyin500[0]), charForPinyin500 },
	{ KPinyin501, sizeof(KPinyin501)/sizeof(KPinyin501[0]), sizeof(charForPinyin501)/sizeof(charForPinyin501[0]), charForPinyin501 },
	{ KPinyin502, sizeof(KPinyin502)/sizeof(KPinyin502[0]), sizeof(charForPinyin502)/sizeof(charForPinyin502[0]), charForPinyin502 },
	{ KPinyin503, sizeof(KPinyin503)/sizeof(KPinyin503[0]), sizeof(charForPinyin503)/sizeof(charForPinyin503[0]), charForPinyin503 },
	{ KPinyin504, sizeof(KPinyin504)/sizeof(KPinyin504[0]), sizeof(charForPinyin504)/sizeof(charForPinyin504[0]), charForPinyin504 },
	{ KPinyin505, sizeof(KPinyin505)/sizeof(KPinyin505[0]), sizeof(charForPinyin505)/sizeof(charForPinyin505[0]), charForPinyin505 },
	{ KPinyin506, sizeof(KPinyin506)/sizeof(KPinyin506[0]), sizeof(charForPinyin506)/sizeof(charForPinyin506[0]), charForPinyin506 },
	{ KPinyin507, sizeof(KPinyin507)/sizeof(KPinyin507[0]), sizeof(charForPinyin507)/sizeof(charForPinyin507[0]), charForPinyin507 },
	{ KPinyin508, sizeof(KPinyin508)/sizeof(KPinyin508[0]), sizeof(charForPinyin508)/sizeof(charForPinyin508[0]), charForPinyin508 },
	{ KPinyin509, sizeof(KPinyin509)/sizeof(KPinyin509[0]), sizeof(charForPinyin509)/sizeof(charForPinyin509[0]), charForPinyin509 },
	{ KPinyin510, sizeof(KPinyin510)/sizeof(KPinyin510[0]), sizeof(charForPinyin510)/sizeof(charForPinyin510[0]), charForPinyin510 },
	{ KPinyin511, sizeof(KPinyin511)/sizeof(KPinyin511[0]), sizeof(charForPinyin511)/sizeof(charForPinyin511[0]), charForPinyin511 },
	{ KPinyin512, sizeof(KPinyin512)/sizeof(KPinyin512[0]), sizeof(charForPinyin512)/sizeof(charForPinyin512[0]), charForPinyin512 },
	{ KPinyin513, sizeof(KPinyin513)/sizeof(KPinyin513[0]), sizeof(charForPinyin513)/sizeof(charForPinyin513[0]), charForPinyin513 },
	{ KPinyin514, sizeof(KPinyin514)/sizeof(KPinyin514[0]), sizeof(charForPinyin514)/sizeof(charForPinyin514[0]), charForPinyin514 },
	{ KPinyin515, sizeof(KPinyin515)/sizeof(KPinyin515[0]), sizeof(charForPinyin515)/sizeof(charForPinyin515[0]), charForPinyin515 },
	{ KPinyin516, sizeof(KPinyin516)/sizeof(KPinyin516[0]), sizeof(charForPinyin516)/sizeof(charForPinyin516[0]), charForPinyin516 },
	{ KPinyin517, sizeof(KPinyin517)/sizeof(KPinyin517[0]), sizeof(charForPinyin517)/sizeof(charForPinyin517[0]), charForPinyin517 },
	{ KPinyin518, sizeof(KPinyin518)/sizeof(KPinyin518[0]), sizeof(charForPinyin518)/sizeof(charForPinyin518[0]), charForPinyin518 },
	{ KPinyin519, sizeof(KPinyin519)/sizeof(KPinyin519[0]), sizeof(charForPinyin519)/sizeof(charForPinyin519[0]), charForPinyin519 },
	{ KPinyin520, sizeof(KPinyin520)/sizeof(KPinyin520[0]), sizeof(charForPinyin520)/sizeof(charForPinyin520[0]), charForPinyin520 },
	{ KPinyin521, sizeof(KPinyin521)/sizeof(KPinyin521[0]), sizeof(charForPinyin521)/sizeof(charForPinyin521[0]), charForPinyin521 },
	{ KPinyin522, sizeof(KPinyin522)/sizeof(KPinyin522[0]), sizeof(charForPinyin522)/sizeof(charForPinyin522[0]), charForPinyin522 },
	{ KPinyin523, sizeof(KPinyin523)/sizeof(KPinyin523[0]), sizeof(charForPinyin523)/sizeof(charForPinyin523[0]), charForPinyin523 },
	{ KPinyin524, sizeof(KPinyin524)/sizeof(KPinyin524[0]), sizeof(charForPinyin524)/sizeof(charForPinyin524[0]), charForPinyin524 },
	{ KPinyin525, sizeof(KPinyin525)/sizeof(KPinyin525[0]), sizeof(charForPinyin525)/sizeof(charForPinyin525[0]), charForPinyin525 },
	};

const TPinyinTable pinyinTable = { 526, allPinyinPair };
