/*
* Copyright (c) 2003-2007 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  The MNssRecognizeInitCompleteHandler interface class handles events 
*               generated by RecognizeHandler::RecognizeInit().
*
*/


#ifndef NSSVASMRECOGNIZEINITCOMPLETEHANDLER_H
#define NSSVASMRECOGNIZEINITCOMPLETEHANDLER_H

//  INCLUDES

#include <e32base.h>
#include <e32def.h>

// CLASS DECLARATION

/**
*  RecognizezInit event handler class.
*  Handles events generated by MNssRecognitionHandler::RecognizeInit().
*
*  @lib NssVASApi.lib
*  @since 2.0
*/

class MNssRecognizeInitCompleteHandler
    {

    public:  //enum

        enum TNssRecognizeInitError
        {
        EVasErrorNone,
        EVasRecognizeInitFailed,
        EVasNoTagInContexts,
        EVasRecognizeUndefinedError10,   // for place holder
        EVasRecognizeUndefinedError9,
        EVasRecognizeUndefinedError8,
        EVasRecognizeUndefinedError7,
        EVasRecognizeUndefinedError6,
        EVasRecognizeUndefinedError5,
        EVasRecognizeUndefinedError4,
        EVasRecognizeUndefinedError3,
        EVasRecognizeUndefinedError2,
        EVasRecognizeUndefinedError1
        };
    
    public: // New functions

        /**
        * Recognizer Initialization Complete Event -  The Recognizer 
        * has been initialized. 
        *
        * @since 2.0
        * @param aErrorCode EVasErrorNone if initialization was successfull
        */              
        virtual void HandleRecognizeInitComplete( TNssRecognizeInitError aErrorCode ) = 0;
        
        /**
        * Pre-sampling has been started. Samples will be discarded until
        * MNssRecognitionHandler::Recognize is called.
        *
        * @since 3.2
        * @param "TInt aErrorCode" KErrNone if start of pre sampling was successful
        */
        virtual void HandlePreSamplingStarted( TInt /*aErrorCode*/ ) {};

    };

#endif // NSSVASMRECOGNIZEINITCOMPLETEHANDLER_H  
            
// End of File
