# findpackage.py - finds which Symbian package contains a file (if any) by searching opengrok

import urllib2
import urllib
import os.path
import cookielib
import sys
import getpass
from BeautifulSoup import BeautifulSoup

user_agent = 'findpackage.py script'
headers = { 'User-Agent' : user_agent }
top_level_url = "http://developer.symbian.org"

COOKIEFILE = 'cookies.lwp'
# the path and filename to save your cookies in

# importing cookielib worked
urlopen = urllib2.urlopen
Request = urllib2.Request
cj = cookielib.LWPCookieJar()

# This is a subclass of FileCookieJar
# that has useful load and save methods
if os.path.isfile(COOKIEFILE):
	cj.load(COOKIEFILE)
	
# Now we need to get our Cookie Jar
# installed in the opener;
# for fetching URLs
opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj))
urllib2.install_opener(opener)

def login():
	loginurl = 'https://developer.symbian.org/main/user_profile/login.php'
	
	print >> sys.stderr, 'username: ',
	username=sys.stdin.readline().strip()
	password=getpass.getpass()
	
	values = {'username' : username,
	          'password' : password,
	          'submit': 'Login'}
	          
	headers = { 'User-Agent' : user_agent }
	
	
	data = urllib.urlencode(values)
	req = urllib2.Request(loginurl, data, headers)

	response = urllib2.urlopen(req)
	doc=response.read()      

	if doc.find('Please try again') != -1:
		print >> sys.stderr, 'Login failed'
		return False
	
	cj.save(COOKIEFILE) 
	return True

def findpackageforlibrary(filename, project):

	dotpos = filename.find('.')
	
	if dotpos != -1:
		searchterm = filename[0:dotpos]
	else:
		searchterm = filename
		
	searchurl = 'https://developer.symbian.org/xref/sfl/search?q="TARGET+%s"&defs=&refs=&path=&hist=&project=%%2F%s'
	url = searchurl % (searchterm, project)
	req = urllib2.Request(url)
	
	response = urllib2.urlopen(req)
	
	doc=response.read()
	
	if doc.find('Restricted access') != -1:
		if(login()):
			# try again after login
			response = urllib2.urlopen(req)
			doc=response.read()
		else:
			return False
			
	
	# BeatifulSoup chokes on some javascript, so we cut away everything before the <body>
	try:
		bodystart=doc.find('<body>')
		doc = doc[bodystart:]
	except:
		pass
			
	soup=BeautifulSoup(doc)
	
	# let's hope the HTML format never changes...
	results=soup.findAll('div', id='results')
	pkgname=''
	try:
		temp=results[0].a.string
		fspos=temp.find('sf')
		temp=temp[fspos+3:]
		pkgpos=temp.find('/')
		temp=temp[pkgpos+1:]
	
		endpkgpos=temp.find('/')
		pkgname=temp[0:endpkgpos]
	except:
		print 'error: file \'%s\' not found in opengrok' % filename
	else:
		print 'first package with target %s: %s' % (searchterm,pkgname)
	
	return True
			
def findpackageforheader(filename, project):
	searchterm=filename
	searchurl = 'https://developer.symbian.org/xref/sfl/search?q=&defs=&refs=&path=%s&hist=&project=%%2F%s'
	url = searchurl % (searchterm, project)

	req = urllib2.Request(url)
	
	response = urllib2.urlopen(req)
	
	doc=response.read()
	
	if doc.find('Restricted access') != -1:
		if(login()):
			# try again after login
			response = urllib2.urlopen(req)
			doc=response.read()
		else:
			return False
			
	
	# BeatifulSoup chokes on some javascript, so we cut away everything before the <body>
	try:
		bodystart=doc.find('<body>')
		doc = doc[bodystart:]
	except:
		pass
			
	soup=BeautifulSoup(doc)
	
	# let's hope the HTML format never changes...
	results=soup.findAll('div', id='results')
	pkgname=''
	try:
		temp=results[0].a.string
		fspos=temp.find('sf')
		temp=temp[fspos+3:]
		pkgpos=temp.find('/')
		temp=temp[pkgpos+1:]
	
		endpkgpos=temp.find('/')
		pkgname=temp[0:endpkgpos]
	except:
		print 'error: file \'%s\' not found in opengrok' % filename
	else:
		print 'package:', pkgname
	
	return True
		

if len(sys.argv) < 2:
	print 'usage: findpackage.py <filename> [project]'
	exit()

filename = sys.argv[1]

if len(sys.argv) == 3:
	project = sys.argv[2]
else:
	project = 'Symbian2'

if filename.endswith('.lib') or filename.endswith('.dll'):
	findpackageforlibrary(filename, project)
else:
	findpackageforheader(filename, project)
