/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Parses the input XML file to form an equivalent DOM tree.
 */
public class XMLFileParser {

	/**
	 * Defines a factory API that enables applications to obtain a parser that
	 * produces DOM object trees from XML documents
	 */
	private static DocumentBuilderFactory myDocBuilderF = null;

	/**
	 * Defines the API to obtain DOM Document instances from an XML document.
	 */
	private static DocumentBuilder myDocBuilder = null;

	/**
	 * Specifies if the parser is initialised or not
	 */
	private static boolean isInitialised = false;

	/**
	 * 
	 * @throws FactoryConfigurationError
	 *             If the implementation is not available or cannot be
	 *             instantiated.
	 * @throws ParserConfigurationException
	 *             If DocumentBuilder cannot be created which satisfies the
	 *             configuration requested.
	 */
	private static void init(boolean isValidating)
			throws FactoryConfigurationError, ParserConfigurationException {
		if (false == isInitialised) {
			myDocBuilderF = DocumentBuilderFactory.newInstance();
			myDocBuilderF.setValidating(isValidating);
			myDocBuilderF.setIgnoringElementContentWhitespace(true);
			myDocBuilderF.setCoalescing(true);
			myDocBuilderF.setNamespaceAware(true);
			myDocBuilderF.setIgnoringComments(true);
			myDocBuilderF.setExpandEntityReferences(true);
			myDocBuilder = myDocBuilderF.newDocumentBuilder();
			myDocBuilder.setEntityResolver(new MyEntityResolver());
			isInitialised = true;
		}
	}

	/**
	 * Parses the given XML file to form a DOM tree.
	 * 
	 * @param fileName
	 *            Name of the file to be parsed.
	 * @return XML file as DOM tree.
	 * @throws FactoryConfigurationError
	 *             If the implementation is not available or cannot be
	 *             instantiated.
	 * @throws ParserConfigurationException
	 *             If DocumentBuilder cannot be created which satisfies the
	 *             configuration requested.
	 * @throws IOException
	 *             If any IO errors occur.
	 * @throws SAXException
	 *             If any parse errors occur.
	 * @throws IllegalArgumentException
	 *             If the file is null.
	 */
	public static Document parseFile(String fileName, boolean isValidating)
			throws FactoryConfigurationError, ParserConfigurationException,
			IOException, SAXException, IllegalArgumentException

	{
		init(isValidating);
		File inFile = new File((String) fileName);
		Document parsedDoc = myDocBuilder.parse(inFile);

		return parsedDoc;
	}

	/**
	 * Obtain a new instance of a DOM Document object to build a DOM tree with.
	 * 
	 * @return New <code>Document</code>.
	 * @throws FactoryConfigurationError
	 *             If the implementation is not available or cannot be
	 *             instantiated.
	 * @throws ParserConfigurationException
	 *             If DocumentBuilder cannot be created which satisfies the
	 *             configuration requested.
	 */
	public static Document getEmptyDocument() throws FactoryConfigurationError,
			ParserConfigurationException {
		init(false);

		return myDocBuilder.newDocument();
	}

	private static class MyEntityResolver implements EntityResolver {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.xml.sax.EntityResolver#resolveEntity(java.lang.String,
		 * java.lang.String)
		 */
		public InputSource resolveEntity(String publicId, String systemId)
				throws SAXException, IOException {
			if (systemId.toLowerCase().endsWith(".dtd") == true) {
				// System.out.println(schemaFile);
				String fpath = ResourceBundle.getBundle("SVG2SVGTProperties")
						.getString("SVGT_DTD_ENTITYRESOLVER"); // "..\\config\\svg.dtd"
																// ;
				File f = new File(fpath);

				// fpath = fpath.substring(5, fpath.length());
				System.out.println(systemId);
				// return new org.xml.sax.InputSource(new java.io.FileReader
				// (fpath )); //(f.getAbsolutePath().toString()));
				return new org.xml.sax.InputSource(
						new java.io.InputStreamReader(
								new FileInputStream(fpath), "windows-1252"));
			}
			return null;
		}

	}

}
