/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

/**
 * Handles the log messages. The message patterns must be stored in a standard
 * Java properties files whose names start with 'LogMessages'. The pattern
 * format: code=message {0} ... {n} Where {i} is the i th parameter of the
 * message and the code is of type long.
 * 
 */
public class LogMessages {

	/**
	 * A hashtable containing the messageformats as value and message code as
	 * key.
	 */
	private static Hashtable logMessageFormats = new Hashtable();

	/**
	 * The file extension for the log messages file.
	 */
	private static final String FILE_EXTENSION = ".properties";

	/**
	 * Initialize this class. If the give directory does not exist throws a
	 * LogException.
	 * 
	 * @param directory
	 *            The directory that contains the file with the log messages.
	 */
	public static void init(String directory, String region) throws Exception {
		// if directory not specified, set the directory as current working
		// directory
		if (null == directory) {
			directory = ".";
		}

		// check the region
		if (null == region) {
			region = "GB";
		}
		// directory = "C:\\Eclipse\\eclipse\\workspace\\SVGToSVGT\\";
		// form the file name for the file containing messages
		String logMessageFile = "LogMessages_" + region + FILE_EXTENSION;

		Properties properties = new Properties();
		FileInputStream fis = null;

		try {
			fis = new FileInputStream(directory + File.separator
					+ logMessageFile);
		} catch (FileNotFoundException _ex) {
			// _ex.printStackTrace();
			throw new Exception("Error reading from file " + logMessageFile);
		}

		try {
			properties.load(fis);
		} catch (IOException ioex) {
			throw new Exception("Error loading messages from " + logMessageFile);
		}

		Enumeration enumeration = properties.keys();
		while (true == enumeration.hasMoreElements()) {
			String s = (String) enumeration.nextElement();
			String format = (String) properties.get(s);
			Long code;
			try {
				code = Long.valueOf(s);
			} catch (NumberFormatException nfex) {
				System.out.println("Invalid code number: " + s);
				continue;
			}
			MessageFormat messageformat = new MessageFormat(format);
			logMessageFormats.put(code, messageformat);
		}
	}

	/**
	 * Get the formatted message associated to the given code.
	 * 
	 * @param code
	 *            The code of the message string.
	 */
	public static String getLogMessage(long code) {
		return getLogMessage(code, null);
	}

	/**
	 * Get the formatted message associated to the given code.
	 * 
	 * @param code
	 *            The code of the message string.
	 * @param params
	 *            The parameters that must replace each variable in the message
	 *            text.
	 */
	public static String getLogMessage(long code, Object[] params) {
		StringBuffer stringbuffer = new StringBuffer(200);
		MessageFormat messageformat = (MessageFormat) logMessageFormats
				.get(new Long(code));
		if (messageformat == null) {
			// System.out.println( "No log message for code " + code );
			return null;
		} else {
			return messageformat.format(params).toString();
		}
	}

}
