/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui.ext.list;

import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractListModel;
import javax.swing.JList;

public class MultiSelectionComboList extends JList {
    private MultiSelectionListModel model;
    /** Creates a new instance of MultiSelectionComboList */
    public MultiSelectionComboList () {
        super();
        model = new MultiSelectionListModel(new ArrayList());
        setModel(model);
        setVisibleRowCount(4);
        setFixedCellHeight(-1);
    }
    
    public MultiSelectionComboList (List list) {
        super();
        model = new MultiSelectionListModel(list);
        setModel(model);
        setVisibleRowCount(4);
        setFixedCellHeight(-1);
    }
    
    public MultiSelectionComboList (Object[] data) {
        super();
        model = new MultiSelectionListModel(data);
        setModel(model);
        setVisibleRowCount(4);
        setFixedCellHeight(-1);
    }
    
    public void addData (Object data) {
        model.add(data);
    }
    
    public void clear () {
    	model.clearAll();
    	clearSelection();
    }
    
    private class MultiSelectionListModel extends AbstractListModel {
        private List list;
        
        MultiSelectionListModel (Object[] data) {
            list = new ArrayList();
            for (int i = 0; i < data.length; i++) {
                list.add(data[i]);
            }
        }
        
        MultiSelectionListModel (List l) {
            list = l;
        }
        
        void clearAll () {
			list.clear();
        }
        
        public void add (Object data) {
			//list = new ArrayList(list);
            list.add(data);
            int size = getSize();
            fireIntervalAdded(this, size - 1, size - 1);
        }
        
        public int getSize() {
            return list.size();
        }
        
        public Object getElementAt(int index) {
            if (index < getSize()) {
                return list.get(index);
            }
            
            return null;
        }
        
    }        
}
