/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.WindowConstants;
import javax.swing.filechooser.FileFilter;

import com.nokia.svg2svgt.SVG2SVGTConverterApplication;
import com.nokia.svg2svgt.configuration.Configuration;
import com.nokia.svg2svgt.configuration.ConfigurationManager;
import com.nokia.svg2svgt.converter.NameSpaceAnalyzer;
import com.nokia.svg2svgt.localiser.Localiser;
import com.nokia.svg2svgt.util.WCMatcher;

/**
 * This is the main view class for GUI for the Convertion of images From SVG to
 * SVGT
 */

public class SVG2SVGTMainView extends JFrame implements ActionListener,
		WindowListener, ConFigButton {

	private SVGTConverterController myController = null;

	/**
	 * Related to Menu bar of the GUI
	 */
	private JMenuBar menuBar;

	private JMenu file;

	private JMenuItem newOption;
	private JMenuItem openOtion;

	private JMenuItem configOitem;
	private JMenuItem passThroughOpenitem;

	private JMenuItem saveitem;
	private JMenuItem saveasitem;
	private JMenuItem exititem;
	private JMenuItem convertitem;

	private JMenuItem contentitem;
	private JMenuItem aboutitem;

	private JMenuItem item;

	private JMenu tools;
	private JMenu help;

	private JSplitPane pane1;

	private JTable commonList;
	private JList list;
	private JScrollPane left;

	private JPanel panel;
	private JScrollPane right;

	private JTextArea logWindow;
	private JSplitPane top;
	private JScrollPane bottom;

	private final String configState = "CONFIG_PANEL";
	private final String passThroughtState = "PASSTHROUGH_PANEL";

	private String state = configState;
	private Hashtable lastSettingsTable = new Hashtable();
	private String openpathc_key = "configopenpath";
	private String openpathp_key = "passThroughopenpath";
	private String saveas_key = "saveaspath";
	private String path = null;
	private String lastsettingspath = null;

	private Localiser myLocaliser = null;
	private ConfigPanel configpanel;
	private NameSpaceAnalyzer myAnaliser = null;
	private ArrayList myDefaultNameSpaceList = null;
	private boolean empty = false;
	PassThroughPanel passThroughpanel = null;
	String savepath;
	private Vector listVector = null;
	boolean firstTime = true;

	/**
	 * Constructor which loads the GUI
	 * 
	 */

	public SVG2SVGTMainView(SVGTConverterController parent, Localiser localiser) {
		super(localiser.getText("ConvertUI.Title"));
		myController = parent;
		this.myLocaliser = localiser;
		path = myLocaliser.getText("CurrentDirectory");
		lastsettingspath = myLocaliser.getText("FilesettingsPath");
		this.configpanel = new ConfigPanel(myController, this.myLocaliser,
				this, this, this);

		try {
			myAnaliser = new NameSpaceAnalyzer(myLocaliser
					.getText("DefaultPassThroughFile"), null);
			ConfigurationManager manager = new ConfigurationManager(
					lastsettingspath);
			Configuration config = manager.getConfiguration();
			this.lastSettingsTable = config.toHash();
			configpanel.setTable(config.toHash());
			configpanel.setConfigHashTable(config.toHash());
			passThroughpanel = new PassThroughPanel(myController, myLocaliser,
					this);
			passThroughpanel.setMyNameSpaces(myAnaliser.getNSInPassThrough());
			myDefaultNameSpaceList = myAnaliser.getNSInPassThrough();
		} catch (Exception e) {
		}
		this.panel = configpanel;
		this.addWindowListener(this);
		buildUI(configpanel);
		/*
		 * HelpMediator mediator =
		 * SVG2SVGTConverterApplication.getHelpMediator(); if(mediator != null){
		 * mediator.registerComponent(this.configpanel,"CONFIG_VIEW");
		 * mediator.registerComponent(passThroughpanel,"PSSTHROUGH_VIEW"); }
		 */
	}

	/**
	 * Method responsible for the generating the GUI
	 * 
	 * @param configPanel
	 */
	public void buildUI(final ConfigPanel configPanel) {

		menuBar = new JMenuBar();
		// HelpMediator mediator =
		// SVG2SVGTConverterApplication.getHelpMediator();

		file = new JMenu(myLocaliser.getText("JMenu.File"));
		file.setMnemonic(KeyEvent.VK_F);
		file.add(newOption = new JMenuItem(myLocaliser
				.getText("JMenu.File.new")));

		newOption.setMnemonic(KeyEvent.VK_N);
		newOption.setAccelerator(KeyStroke.getKeyStroke('N',
				ActionEvent.CTRL_MASK));
		newOption.addActionListener(this);

		file.add(openOtion = new JMenuItem(myLocaliser
				.getText("JMenu.File.open")));
		openOtion.setMnemonic(KeyEvent.VK_O);
		openOtion.setAccelerator(KeyStroke.getKeyStroke('O',
				ActionEvent.CTRL_MASK));
		openOtion.addActionListener(this);

		file.addSeparator();

		file.add(configOitem = new JMenuItem(myLocaliser
				.getText("JMenu.File.open.Configuration")));
		configOitem.addActionListener(this);
		configOitem.setAccelerator(KeyStroke.getKeyStroke('C',
				ActionEvent.CTRL_MASK));

		file.add(passThroughOpenitem = new JMenuItem(myLocaliser
				.getText("JMenu.File.open.passThrough")));
		passThroughOpenitem.addActionListener(this);
		passThroughOpenitem.setAccelerator(KeyStroke.getKeyStroke('P',
				ActionEvent.CTRL_MASK));
		file.addSeparator();

		file.add(saveitem = new JMenuItem(myLocaliser
				.getText("JMenu.File.save")));
		saveitem.setEnabled(false);
		saveitem.setMnemonic(KeyEvent.VK_S);
		saveitem.addActionListener(this);
		saveitem.setAccelerator(KeyStroke.getKeyStroke('S',
				ActionEvent.CTRL_MASK));

		file.add(saveasitem = new JMenuItem(myLocaliser
				.getText("JMenu.File.saveas")));
		saveasitem.setMnemonic(KeyEvent.VK_S);
		// saveasitem.setDisplayedMnemonicIndex( 4 );
		saveasitem.addActionListener(this);
		saveasitem.setAccelerator(KeyStroke.getKeyStroke('S',
				(ActionEvent.CTRL_MASK + ActionEvent.SHIFT_MASK)));

		file.addSeparator();

		file.add(exititem = new JMenuItem(myLocaliser
				.getText("JMenu.File.exit")));
		exititem.setMnemonic(KeyEvent.VK_X);
		// exititem.setAccelerator( KeyStroke.getKeyStroke(
		// 'X',ActionEvent.CTRL_MASK ) );
		exititem.addActionListener(this);

		menuBar.add(file);

		tools = new JMenu(myLocaliser.getText("JMenu.tools"));
		tools.add(convertitem = new JMenuItem(myLocaliser
				.getText("JMenu.tools.converter")));
		tools.setMnemonic(KeyEvent.VK_T);
		convertitem.setEnabled(false);
		convertitem.addActionListener(this);
		menuBar.add(tools);

		help = new JMenu(myLocaliser.getText("JMenu.help"));
		help.setMnemonic(KeyEvent.VK_H);
		help.add(contentitem = new JMenuItem(myLocaliser
				.getText("JMenu.help.contents")));
		contentitem.addActionListener(this);

		help.add(aboutitem = new JMenuItem(myLocaliser
				.getText("JMenu.help.about")));
		aboutitem.setMnemonic(KeyEvent.VK_F1);
		aboutitem.addActionListener(this);

		menuBar.add(help);
		setJMenuBar(menuBar);

		/**
		 * This split pane is the main split pane which separates the above
		 * split pane and the JTextArea related to split pane and creating the
		 * new object of the main Panel and adding to the split pane ,Top split
		 * pane contains one List and panel
		 */

		list = new JList();

		left = new JScrollPane(list);
		right = new JScrollPane(panel);

		top = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, left, right);
		top.setDividerLocation(140);

		logWindow = new JTextArea();

		logWindow.setEditable(false);
		logWindow.setLineWrap(true);
		bottom = new JScrollPane(logWindow);

		pane1 = new JSplitPane(JSplitPane.VERTICAL_SPLIT, top, bottom);
		pane1.setDividerLocation(310);

		getContentPane().add(pane1, BorderLayout.CENTER);

		try {
			File file = new File(path);
			String[] fileList = file.list(new ListFileFilter("*.cfg"));
			list.setListData(fileList);
		} catch (NullPointerException ne) {
		}

		list.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204),
				5));
		list.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				if (e.getClickCount() > 1) {
					saveitem.setEnabled(true);
					String str = path;
					str += "\\";
					str += (String) list.getSelectedValue();
					setTitle(myLocaliser.getText("ConvertUI.Title") + "-"
							+ (String) list.getSelectedValue());
					savepath = str;
					if (str.endsWith(".cfg")) {
						Hashtable config = getFromfile(str);
						configpanel.setConfigHashTable(config);
					} else if (str.endsWith(".xml")) {
						try {
							NameSpaceAnalyzer analiser = new NameSpaceAnalyzer(
									str, null);
							passThroughpanel.setMyNameSpaces(analiser
									.getNSInPassThrough());
							passThroughpanel.populateTable();
						} catch (Exception ex) {
						}
					}
				} else {
					saveitem.setEnabled(false);
				}
			}
		});
		configOitem.setEnabled(false);

		/*
		 * if(mediator != null){ mediator.registerComponent(menuBar,"MENU_BAR");
		 * mediator.registerComponent(list,"JLIST");
		 * mediator.registerComponent(logWindow,"MESSAGE_WINDOW"); }
		 */
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(newOption)) {
			if (state == configState) {
				newConfiguration();
			} else {
				newpassThroughfile();
			}
		} else if (e.getSource().equals(openOtion)) {
			if (state == configState) {
				openConfiguration();
			} else {
				openPassThroughFile();
			}
		} else if (e.getSource().equals(configOitem)) {
			passThroughOpenitem.setEnabled(true);
			configOitem.setEnabled(false);
			if (true == passThroughpanel.isChanged()) {
				int YesNo = JOptionPane.showConfirmDialog(configpanel,
						"Save passthrough?", "Save", JOptionPane.YES_NO_OPTION);
				if (YesNo == JOptionPane.YES_OPTION) {
					saveas();
				}
			}
			try {
				populateList(configState);
				top.remove(top.getRightComponent());
				right = new JScrollPane(panel);
				top.setRightComponent(right);
				top.setDividerLocation(140);
				getContentPane().validate();
				getContentPane().repaint();
				state = configState;
			} catch (NullPointerException ne) {
			}
		} else if (e.getSource().equals(passThroughOpenitem)) {
			configOitem.setEnabled(true);
			passThroughOpenitem.setEnabled(false);
			if (true == configpanel.isModified()) {
				if (!configpanel.isFieldsEmpty()) {
					int YesNo = JOptionPane.showConfirmDialog(configpanel,
							"Save configuration?", "Save",
							JOptionPane.YES_NO_OPTION);
					if (YesNo == JOptionPane.YES_OPTION) {
						saveas();
					}
				}
			}
			try {
				if (firstTime == true) {
					passThroughpanel.populateTable(myDefaultNameSpaceList);
					firstTime = false;
				}
				populateList(passThroughtState);
				top.remove(top.getRightComponent());
				right = new JScrollPane(passThroughpanel);
				top.setRightComponent(right);
				top.setDividerLocation(140);
				getContentPane().validate();
				getContentPane().repaint();
				state = passThroughtState;
			} catch (NullPointerException ne) {
			}
		} else if (e.getActionCommand().equals(
				myLocaliser.getText("JMenu.File.save"))) {
			save();
		} else if (e.getActionCommand().equals(
				myLocaliser.getText("JMenu.File.saveas"))) {
			saveas();
		} else if (e.getActionCommand().equals(
				myLocaliser.getText("JMenu.File.exit"))) {
			settings();
		} else if (e.getActionCommand().equals(
				myLocaliser.getText("JMenu.tools.converter"))) {
			configpanel.covertion();
		} else if (e.getActionCommand().equals(
				myLocaliser.getText("JMenu.help.contents"))) {
			// System.out.println("To be Implemented contents");
			/*
			 * HelpMediator mediator =
			 * SVG2SVGTConverterApplication.getHelpMediator(); if(mediator !=
			 * null) mediator.invokeHelp("introduction");
			 */
		} else if (e.getActionCommand().equals(
				myLocaliser.getText("JMenu.help.about"))) {
			showDialog();
		}
	}

	/**
    * 
    *
    */

	private void settings() {
		int j = JOptionPane.showConfirmDialog(this, "Exit application?",
				"Exit", JOptionPane.YES_NO_OPTION);
		if (j == JOptionPane.YES_OPTION) {
			try {
				Hashtable settings = configpanel.getTable();
				settings.put(openpathc_key, lastSettingsTable
						.get(openpathc_key));
				settings.put(openpathp_key, lastSettingsTable
						.get(openpathp_key));
				settings.put(saveas_key, lastSettingsTable.get(saveas_key));
				Configuration configClass = new Configuration(settings);
				ConfigurationManager configManager = new ConfigurationManager(
						lastsettingspath);
				configManager.setConfiguration(configClass);
			} catch (NullPointerException ne) {
				System.out.println("Unable to open the file");
			}
			this.dispose();
		}
	}

	public void newConfiguration() {
		saveitem.setEnabled(false);
		configpanel.reset();
		populateList(configState);
		this.setTitle(myLocaliser.getText("ConvertUI.Title") + "-"
				+ "New Configuration");
	}

	public void newpassThroughfile() {
		saveitem.setEnabled(false);
		try {
			NameSpaceAnalyzer analiser = new NameSpaceAnalyzer(myLocaliser
					.getText("DefaultPassThroughFile"), null);
			passThroughpanel.setMyNameSpaces(analiser.getNSInPassThrough());
			passThroughpanel.populateTable();
			populateList(passThroughtState);
			this.setTitle(myLocaliser.getText("ConvertUI.Title") + "-"
					+ "Default PassThrough File");
		} catch (Exception e) {
		}
	}

	public void openConfiguration() {
		JFileChooser chooser = new JFileChooser();
		if (null == (String) lastSettingsTable.get(openpathc_key)) {
			chooser.setCurrentDirectory(new File(myLocaliser
					.getText("CurrentDirectory")));
		} else {
			chooser.setCurrentDirectory(new File((String) lastSettingsTable
					.get(openpathc_key)));
		}
		MyFileFilter filter = new MyFileFilter("*.cfg");
		FileFilter fil = chooser.getFileFilter();
		chooser.removeChoosableFileFilter(fil);
		chooser.addChoosableFileFilter((FileFilter) filter);
		int approved = chooser.showDialog(item, "Open");
		if (approved == JFileChooser.APPROVE_OPTION) {
			try {
				String f = chooser.getSelectedFile().getAbsolutePath();
				Hashtable config = getFromfile(f);
				configpanel.setConfigHashTable(config);
				saveitem.setEnabled(true);
				populateList(configState);
				this.setTitle(myLocaliser.getText("ConvertUI.Title") + "-"
						+ chooser.getSelectedFile().getName());
				String openPath = chooser.getCurrentDirectory()
						.getAbsolutePath();
				savepath = chooser.getSelectedFile().getAbsolutePath();
				lastSettingsTable.put(openpathc_key, openPath);
			} catch (Exception e) {
			}
		}
	}

	public void openPassThroughFile() {
		JFileChooser chooser = new JFileChooser();
		if (null == (String) lastSettingsTable.get(openpathp_key)) {
			chooser.setCurrentDirectory(new File(myLocaliser
					.getText("CurrentDirectory")));
		} else {
			chooser.setCurrentDirectory(new File((String) lastSettingsTable
					.get(openpathp_key)));
		}
		MyFileFilter filter = new MyFileFilter("*.xml");
		FileFilter fil = chooser.getFileFilter();
		chooser.removeChoosableFileFilter(fil);
		chooser.addChoosableFileFilter((FileFilter) filter);
		int approved = chooser.showDialog(item, "Open");
		if (approved == JFileChooser.APPROVE_OPTION) {
			try {
				File f = chooser.getSelectedFile();
				if (f != null) {
					saveitem.setEnabled(true);
					populateList(passThroughtState);

					if (false == configpanel
							.checkForValidatePassThrough(chooser
									.getSelectedFile().getAbsolutePath())) {
						JOptionPane.showMessageDialog(this,
								"Invalid passthrough file.");
					} else {
						this.setTitle(myLocaliser.getText("ConvertUI.Title")
								+ "-" + chooser.getSelectedFile().getName());
						NameSpaceAnalyzer analiser = new NameSpaceAnalyzer(f
								.getAbsolutePath(), null);
						passThroughpanel.setMyNameSpaces(analiser
								.getNSInPassThrough());
						passThroughpanel.populateTable();
					}
					String openPath = chooser.getCurrentDirectory()
							.getAbsolutePath();
					savepath = chooser.getSelectedFile().getAbsolutePath();
					lastSettingsTable.put(openpathp_key, openPath);
				}
			} catch (Exception e) {
			}
		}
	}

	public void save() {
		if (state.equals(configState)) {
			Hashtable config = configpanel.getConfigHashTable();
			putTofile(savepath, config);
		} else {
			System.out.println(" savePath " + savepath);
			SVGPassThroughFileStorer storer = new SVGPassThroughFileStorer(
					passThroughpanel.addDialog.getMyNameSpaces(), savepath,
					myLocaliser, true, this);
		}
	}

	public void saveas() {
		saveitem.setEnabled(false);
		JFileChooser chooser = new JFileChooser();
		if (null == (String) lastSettingsTable.get(saveas_key)) {
			chooser.setCurrentDirectory(new File(myLocaliser
					.getText("CurrentDirectory")));
		} else {
			chooser.setCurrentDirectory(new File((String) lastSettingsTable
					.get(saveas_key)));
		}

		if (state.equals(passThroughtState)) {

			MyFileFilter filter = new MyFileFilter("*.xml");
			FileFilter fil = chooser.getFileFilter();
			chooser.removeChoosableFileFilter(fil);
			chooser.addChoosableFileFilter((FileFilter) filter);
			int approved = chooser.showSaveDialog(item);
			if (approved == JFileChooser.APPROVE_OPTION) {
				File f = chooser.getSelectedFile();
				SVGPassThroughFileStorer savetoXML = new SVGPassThroughFileStorer(
						passThroughpanel.getMyNameSpaces(),
						f.getAbsolutePath(), myLocaliser, false, this);
				passThroughpanel.setChanged(false);
			}
			lastSettingsTable.put(saveas_key, chooser.getCurrentDirectory()
					.getAbsolutePath());
			chooser.removeChoosableFileFilter(filter);
			chooser.addChoosableFileFilter(fil);
			populateList(passThroughtState);
		} else {

			MyFileFilter filter = new MyFileFilter("*.cfg");
			FileFilter fil = chooser.getFileFilter();
			chooser.removeChoosableFileFilter(fil);
			chooser.addChoosableFileFilter((FileFilter) filter);
			int approved = chooser.showSaveDialog(item);
			if (approved == JFileChooser.APPROVE_OPTION) {
				String f = chooser.getSelectedFile().getAbsolutePath();
				System.out.println(f);
				if (-1 == f.indexOf(".cfg"))
					f = f + ".cfg";
				System.out.println(f);
				ConfigurationManager manager = new ConfigurationManager(f);
				Hashtable config = configpanel.getConfigHashTable();
				Configuration config1 = new Configuration(config);
				manager.setConfiguration(config1);

				lastSettingsTable.put(saveas_key, chooser.getCurrentDirectory()
						.getAbsolutePath());
				configpanel.setModified(false);
			}
			chooser.removeChoosableFileFilter(filter);
			chooser.addChoosableFileFilter(fil);
			populateList(configState);
		}

	}

	private void populateList(String state1) {
		if (state1 != passThroughtState) {
			try {
				File file = new File(path);
				String[] fileList = file.list(new ListFileFilter("*.cfg"));
				list.setListData(fileList);
			} catch (Exception e1) {
			}
		} else {
			try {
				File file = new File(path);
				File[] fileList = file.listFiles(new ListFileFilter("*.xml"));
				Vector listVec = new Vector();
				for (int i = 0; i < fileList.length; i++) {
					boolean validOrInvalid = configpanel
							.checkForValidatePassThrough(fileList[i]
									.getAbsolutePath());
					if (true == validOrInvalid) {
						listVec.add(fileList[i].getName());
					}
				}
				list.setListData(listVec);
			} catch (Exception e1) {
			}
		}
	}

	public void showDialog() {
		ConvertDialog dialog = new ConvertDialog(this, myLocaliser);
		dialog.setTitle(myLocaliser.getText("JMenu.help.about"));
		dialog.setSize(357, 207);
		dialog.setVisible(true);
		dialog.setModal(true);
		dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		dialog.setLocation(this.getLocation().x + 150,
				this.getLocation().y + 150);
	}

	private void putTofile(String savepath, Hashtable config) {
		Configuration configClass = new Configuration(config);
		ConfigurationManager configManager = new ConfigurationManager(savepath);
		configManager.setConfiguration(configClass);
	}

	public void clearTextArea() {
		logWindow.setText("");
	}

	private Hashtable getFromfile(String openpath) {
		ConfigurationManager manager = new ConfigurationManager(openpath);
		Configuration config = manager.getConfiguration();
		return config.toHash();
	}

	public void log(String desc) {
		if (null != logWindow) {
			logWindow.append(desc);
			logWindow.append(" \n ");
		}
	}

	public void setIfListisEmty(boolean empty) {
		this.empty = empty;
		if (empty) {
			convertitem.setEnabled(false);
		} else {
			convertitem.setEnabled(true);
		}
	}

	public void windowActivated(WindowEvent arg0) {
	}

	public void windowClosed(WindowEvent arg0) {

	}

	public void windowClosing(WindowEvent arg0) {
		settings();
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
	}

	public void windowDeactivated(WindowEvent arg0) {
	}

	public void windowDeiconified(WindowEvent arg0) {
	}

	public void windowIconified(WindowEvent arg0) {
	}

	public void windowOpened(WindowEvent arg0) {
	}

	/**
	 * <code>SVGFilenameFilter</code> implements <code>FilenameFilter</code>. It
	 * provides the functionality for filtering the file present in a directory
	 * based on the criteria specified by the user.
	 */
	private static class ListFileFilter implements FilenameFilter {
		/**
		 * Specifies the filtering criteria set by the user.
		 */
		private String myFilteringCriteria = null;

		/**
		 * Creates a filter based on the criteria specified by the user.
		 * 
		 * @param filter
		 *            Filtering criteria specified by the user.
		 */
		public ListFileFilter(String filter) {
			myFilteringCriteria = filter;
		}

		/**
		 * Tests if a specified file should be included in a file list.
		 * 
		 * @param dir
		 *            The directory in which the file was found
		 * @param name
		 *            The name of the file
		 * @return True if and only if the name should be included in the file
		 *         list; false otherwise
		 */
		public boolean accept(File dir, String name) {
			File temp = new File(name);
			return WCMatcher.match(myFilteringCriteria, name);

		}
	}

	private class MyFileFilter extends FileFilter {
		private String myFilteringCriteria = null;

		public MyFileFilter(String filter) {
			myFilteringCriteria = filter;
		}

		public boolean accept(File fileName) {
			if (true == fileName.isDirectory()) {
				return true;
			}
			return WCMatcher.match(myFilteringCriteria, fileName.getName());
		}

		public String getDescription() {
			return myFilteringCriteria;
		}
	}
}
