/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.converter;



/**
 * Factory that creates the respective classes handling the conversions
 * for the elements/attributes defined in the conversions file.
 * 
 */
public class ConversionsFactory
{

    /**
     * Creates the concerete <code>Conversions</code> class instance based
     * on the element/attribute name.
     *   
     * @param className	Class name for the concrete Conversions class. 
     * @return			Instance for the specific Conversions class.
     */
    public static Conversions getConversionsInstance( String className )
    {
		try
		{
			Class keyValueClass = Class.forName( className );
			Object instance = keyValueClass.newInstance();
			return ( Conversions ) instance;
		}
		catch ( Exception ex )
		{
			System.out.println( ex.getMessage() );
			return null;
		}
    }
}
