/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.converter;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.nokia.svg2svgt.log.Logger;

/**
 * This interface defines the interface for concerete conversion class
 * implementations.
 */
public interface Conversions
{

    /**
     * The implementation classes should provide the implementation for the
     * conversions to be performed.
     * @param svgNode	Node for which the conversions are to be performed.
     * @param svgDoc	Parsed document reference.
     * @param svgtNode	SVGT node.
     * @param svgtDoc	SVGT document reference.
     */
    public void doConversion( Node svgNode, Document svgDoc, Node svgtNode, Document svgtDoc, Logger logger, String nsURL );

}
