/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Symbian Foundation License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
package com.nokia.svg2svgt.configuration;

/**
 * This class provides the management functionality for managing the
 * configuration i.e. Output properties, grey list and black list for
 * the converter tool. It uses <code>ConfigurationStorage</code> to
 * read / write the configuration to / from the configuration files.
 */
public class ConfigurationManager
{
   /**
    * <code>ConfigurationStorage</code> for this configuration manager.
    */
   private ConfigurationStorage myConfigurationStorage;

   /**
    * File name for which this <code>ConfigurationManager</code> instance
    * belongs.
    */
   private String myFileName;



   /**
    * Creates a configuration manager for the configurtaion file "fileName".
    *
    * @param fileName   Configuration file to be read.
    */
   public ConfigurationManager(String fileName)
   {
       myFileName = fileName;
       myConfigurationStorage = new ConfigurationStorage( fileName );
   }



   /**
    * Obtains the <code>Configuration</code> for the given configuration
    * file.
    *
    * @return   Current file configuration.
    */
   public Configuration getConfiguration()
   {
        return myConfigurationStorage.readConfiguration();
   }



   /**
    * Sets the configuration for the given configuration file to the new
    * <code>Configuration</code> specified in the argument.
    *
    * @param newConfig  New configuration to be set.
    */
   public void setConfiguration(Configuration newConfig)
   {
       myConfigurationStorage.saveConfiguration( newConfig );
   }


   /**
    * Main method. For testing purposes.
    * @param args   Command line arguments.
    */
   public static void main( String[] args )
   {
       ConfigurationManager configMgr = new ConfigurationManager("C:\\Eclipse\\Eclipse\\workspace\\SVGTOSVGT\\settings\\SVG2SVGTConverter.properties");
       Configuration config = configMgr.getConfiguration();
       System.out.println( config.toString() );

   }

}
