/*
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies). 
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of the License "Symbian Foundation License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.symbianfoundation.org/legal/sfl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description:
 *
 */
package com.nokia.svg2svgt;

import java.util.Hashtable;

import javax.swing.JOptionPane;

import com.nokia.svg2svgt.converter.SVG2SVGTConverter;
import com.nokia.svg2svgt.gui.SVGTConverterController;
import com.nokia.svg2svgt.log.LogWriter;

/**
 * This class provides the access point for launching the converter application
 * from the command line (batch processing mode) or from the LCT (stand-alone
 * mode).
 * 
 */
public class SVG2SVGTConverterApplication {
	/**
	 * Specifies the mode of operation for the tool - GUI or BATCH mode.
	 */
	private static String modeOfOperation = SVG2SVGTConstants.GUI_MODE;

	/**
	 * Singleton instance for the application
	 */
	private static SVGTConverterController myApplication = null;

	/**
	 * Single LogWriter instance used by the tool.
	 */
	private static LogWriter myLogWriter = null;

	/**
	 * 
	 * @param args
	 */
	private static boolean instantiateHelp = false;

	/**
	 * Launches the converter tool GUI in stand alone mode else carries out the
	 * conversion based on the command line arguments.
	 * 
	 * @param args
	 *            Command line parameters specified by the user. Null parameter
	 *            launches the GUI for the converter tool.
	 */
	public static void launchApplication(String[] args) {
		Hashtable cmdLineArgs = null;
		// create the logger
		// myLogger = new Logger();
		if ((null == args) || (0 >= args.length)) {
			// no arguments specified, launch in GUI mode
			launchApplicationInGUIMode();
		} else {
			try {

				// parse the command line argument
				cmdLineArgs = CommandLineParser.parseCommandLineArguments(args);
				// System.out.println(cmdLineArgs);
				if (true == cmdLineArgs.isEmpty()) {
					launchApplicationInGUIMode();
				} else {
					modeOfOperation = SVG2SVGTConstants.BATCH_MODE;
					myLogWriter = (LogWriter) ServiceRegistry
							.getService("com.nokia.svg2svgt.log.LogWriter");
					myApplication = new SVGTConverterController(cmdLineArgs,
							modeOfOperation, myLogWriter);

					String[] exceptions = SVG2SVGTConverter.exceptionMessage;
					for (int i = 0; i < exceptions.length; i++) {
						String exp = exceptions[i];
						if (exp != null) {
							JOptionPane.showMessageDialog(null, exp);
						}
					}
				}
			} catch (Exception ex) {
				System.out.println("Unable to launch the application. Reason: "
						+ ex.getMessage());
				// myLogger.log( ex.getMessage(), SVG2SVGTConstants.BATCH_MODE
				// );
			}

		}
	}

	/**
	 * Launches the converter tool in GUI mode.
	 */
	public static void launchApplicationInGUIMode() {
		modeOfOperation = SVG2SVGTConstants.GUI_MODE;
		myLogWriter = (LogWriter) ServiceRegistry
				.getService("com.nokia.svg2svgt.log.Logger");

		if (null == myLogWriter) {
			myLogWriter = new LogWriter(SVG2SVGTConstants.DEFAULT_REGION);
			ServiceRegistry.registerService(myLogWriter);
		}
		myApplication = new SVGTConverterController(modeOfOperation,
				myLogWriter);
	}

	/**
	 * Main method for launching the tool in the command line mode.
	 * 
	 * @param args
	 *            Command line arguments.
	 */
	public static void main(String args[]) {
		instantiateHelp = true;
		// launch the application
		SVG2SVGTConverterApplication.launchApplication(args);
	}

}
