/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.util;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrintDOMTree {
    private static short[] nodeTypes = new short[]{2, 4, 8, 11, 9, 10, 1, 6, 5, 12, 7, 3};
    private static String[] nodeTypeNames = new String[]{"ATTRIBUTE", "CDATA_SECTION", "COMMENT_NODE", "DOCUMENT_FRAGMENT", "DOCUMENT", "DOCUMENT_TYPE", "ELEMENT", "ENTITY", "ENTITY_REFERENCE", "NOTATION", "PROCESSING_INSTRUCTION", "TEXT"};

    public static void printDOMTree(Document document) {
        Element root = document.getDocumentElement();
        PrintDOMTree.showTree(root, 2, 0);
    }

    public static String getType(short type) {
        int i = 0;
        while (i < nodeTypes.length) {
            if (type == nodeTypes[i]) {
                return nodeTypeNames[i];
            }
            ++i;
        }
        return "UNKNOWN";
    }

    private static String getSpaces(int count) {
        String spaces = "";
        int i = 0;
        while (i < count) {
            spaces = String.valueOf(spaces) + " ";
            ++i;
        }
        return spaces;
    }

    public static void showTree(Node node, int indent, int size) {
        PrintDOMTree.showTree(node, indent, size, -1);
    }

    public static void showTree(Node node, int indent, int size, int depth) {
        if (node == null) {
            return;
        }
        String name = node.getNodeName();
        short type = node.getNodeType();
        String nodeInfo = "";
        nodeInfo = String.valueOf(nodeInfo) + PrintDOMTree.getSpaces(size * indent) + "<" + name;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int count = attributes.getLength();
            int i = 0;
            while (i < count) {
                Node attribute = attributes.item(i);
                nodeInfo = String.valueOf(nodeInfo) + " " + attribute.getNodeName() + "=\"" + attribute.getNodeValue() + "\"";
                ++i;
            }
        }
        if (3 == type) {
            nodeInfo = String.valueOf(nodeInfo) + " " + node.getNodeValue();
        }
        nodeInfo = String.valueOf(nodeInfo) + ">";
        NodeList list = node.getChildNodes();
        boolean hasText = false;
        boolean hasNodes = false;
        int i = 0;
        while (i < list.getLength()) {
            String text;
            if (3 == list.item(i).getNodeType() && !(text = list.item(i).getNodeValue()).trim().equals("")) {
                nodeInfo = String.valueOf(nodeInfo) + text;
                hasText = true;
            }
            ++i;
        }
        if (hasText) {
            nodeInfo = String.valueOf(nodeInfo) + "</" + name + ">";
        }
        System.out.println(nodeInfo);
        if (node.hasChildNodes() && (depth == -1 || depth > 0)) {
            i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() != 3) {
                    PrintDOMTree.showTree(list.item(i), indent, size + 1, depth != -1 ? depth - 1 : -1);
                }
                ++i;
            }
        }
        if (!hasText) {
            System.out.println(String.valueOf(PrintDOMTree.getSpaces(size * indent)) + "</" + name + ">");
        }
    }
}

