/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui.ext;

import com.nokia.svg2svgt.gui.ext.JMultiSelectionComboBox;
import com.nokia.svg2svgt.gui.ext.list.MultiSelectionComboList;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicArrowButton;

class MultiSelectionPopup
extends JPopupMenu {
    private JMultiSelectionComboBox comboBox;
    private JScrollPane scrollPane;
    private MultiSelectionComboList list;
    private MouseListener mouseListener;

    public MultiSelectionPopup(JMultiSelectionComboBox combo) {
        this.comboBox = combo;
        this.mouseListener = new InvocationMouseHandler();
        this.scrollPane = new JScrollPane();
        this.createList();
        this.scrollPane.getViewport().add(this.list);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.scrollPane);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.addPopupMenuListener(new InvocationPopupListener());
    }

    public void setData(Vector v) {
        this.list.setListData(v);
    }

    public void setData(Object[] data) {
        this.list.setListData(data);
    }

    public void addData(Object obj) {
        this.list.addData(obj);
    }

    Object getPrototypeCellValue() {
        return this.list.getPrototypeCellValue();
    }

    private void createList() {
        this.list = new MultiSelectionComboList();
        this.list.addListSelectionListener(new SelectionListener());
    }

    private void togglePopup() {
        if (this.isVisible()) {
            this.hidePopup();
        } else {
            this.showPopup();
        }
    }

    private void hidePopup() {
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        manager.clearSelectedPath();
    }

    private void showPopup() {
        Rectangle rect = this.list.getCellBounds(0, 0);
        if (rect != null) {
            int row = Math.min(this.list.getVisibleRowCount(), this.list.getModel().getSize());
            this.setPopupSize(this.comboBox.getWidth(), rect.height * row);
        } else {
            this.setPopupSize(this.comboBox.getWidth(), this.comboBox.getHeight());
        }
        this.show(this.comboBox, 0, this.comboBox.getHeight());
    }

    MouseListener getMouseListener() {
        return this.mouseListener;
    }

    void addItem(Object data) {
        this.list.addData(data);
    }

    int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    int[] getSelectedIndices() {
        return this.list.getSelectedIndices();
    }

    Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }

    void removeAllElements() {
        this.list.clear();
    }

    void clearSelection() {
        this.list.clearSelection();
    }

    void selectItem(Object toBeSelected) {
        this.list.setSelectedValue(toBeSelected, false);
    }

    public void selectIndex(int index) {
        this.list.setSelectedIndex(index);
    }

    private class SelectionListener
    implements ListSelectionListener {
        int[] prevSelectedIndices;

        SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            String text;
            MultiSelectionComboList list = (MultiSelectionComboList)e.getSource();
            Object selectedItems = list.getSelectedValue();
            if (selectedItems != null && (text = selectedItems.toString()).trim().length() > 0) {
                MultiSelectionPopup.this.comboBox.setText(text);
            }
            if (this.prevSelectedIndices == null || !this.compareIndices(this.prevSelectedIndices, list.getSelectedIndices())) {
                MultiSelectionPopup.this.comboBox.firePopupSelectionChanging();
                this.prevSelectedIndices = list.getSelectedIndices();
            }
        }

        private boolean compareIndices(int[] i, int[] j) {
            boolean b = true;
            int iLength = i.length;
            int jLength = j.length;
            if (iLength == jLength) {
                int k = 0;
                while (k < iLength) {
                    if (i[k] != j[k]) {
                        b = false;
                        break;
                    }
                    ++k;
                }
            } else {
                b = false;
            }
            return b;
        }
    }

    private class InvocationPopupListener
    implements PopupMenuListener {
        InvocationPopupListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            MultiSelectionPopup.this.comboBox.firePopupWillBecomeInvisible();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            MultiSelectionPopup.this.comboBox.firePopupWillBecomeVisible();
        }
    }

    private class InvocationMouseHandler
    extends MouseAdapter {
        InvocationMouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || !MultiSelectionPopup.this.comboBox.isEnabled()) {
                return;
            }
            Object source = e.getSource();
            if (source instanceof BasicArrowButton) {
                MultiSelectionPopup.this.togglePopup();
            }
        }
    }
}

