/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui;

import com.nokia.svg2svgt.gui.CustomFileChooser;
import com.nokia.svg2svgt.util.WCMatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class SVGTFileChooser
extends JDialog
implements ActionListener,
CaretListener {
    private JPanel contentPane;
    private SVGFileChooser myFileChooser = new SVGFileChooser();
    private JPanel foldersPanel = new JPanel();
    private Border border1;
    private TitledBorder titledBorder1;
    private JCheckBox subFoldersCheckBox = new JCheckBox();
    private JCheckBox folderStructCheckBox = new JCheckBox();
    private JButton addWCButton = new JButton();
    private File[] svgFiles;
    private String myParentDirectory = " ";
    Vector listOfFiles = new Vector();
    private Vector myWildCardsFiles = new Vector();
    boolean isAddOrAddWithWildCards = true;
    private String myCharSeq = null;
    private JTextField textField = null;
    private JButton openButton = null;
    private File myCurrentDirectory = null;
    private boolean canceled = false;

    public SVGTFileChooser(Frame frame, String title) {
        super(frame, true);
        this.setModal(true);
        this.setTitle(title);
        this.setResizable(false);
        this.enableEvents(64L);
    }

    public void showCustomFileChooser() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.myFileChooser.setApproveButtonText("Add");
        this.textField = CustomFileChooser.makeComponentInvisible(this.myFileChooser, UIManager.getString("FileChooser.filesOfTypeLabelText"));
        this.textField.addCaretListener(this);
        this.openButton = CustomFileChooser.getButton(this.myFileChooser, UIManager.getString("FileChooser.filesOfTypeLabelText"));
        if (this.myCurrentDirectory != null) {
            this.myFileChooser.setCurrentDirectory(this.myCurrentDirectory);
        }
        this.myFileChooser.setMultiSelectionEnabled(true);
        this.myFileChooser.setBounds(new Rectangle(4, 3, 486, 300));
        this.myFileChooser.addActionListener(this);
        this.addWCButton.setBounds(new Rectangle(340, 300, 140, 24));
        this.addWCButton.setRequestFocusEnabled(true);
        this.addWCButton.setToolTipText("");
        this.addWCButton.setHorizontalTextPosition(0);
        this.addWCButton.setText("Add with WildCards");
        this.addWCButton.addActionListener(this);
        this.subFoldersCheckBox.setActionCommand("jCheckBox1");
        this.subFoldersCheckBox.setText("Include subfolders");
        this.subFoldersCheckBox.setBounds(new Rectangle(5, 14, 152, 24));
        this.folderStructCheckBox.setText("Maintain Folder Structure");
        this.folderStructCheckBox.setBounds(new Rectangle(5, 32, 163, 24));
        this.titledBorder1 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), "Folders");
        this.foldersPanel.setBorder(this.titledBorder1);
        this.foldersPanel.setBounds(new Rectangle(10, 300, 230, 64));
        this.foldersPanel.setLayout(null);
        this.foldersPanel.add((Component)this.folderStructCheckBox, null);
        this.foldersPanel.add((Component)this.subFoldersCheckBox, null);
        this.addWCButton.setEnabled(false);
        this.subFoldersCheckBox.setEnabled(false);
        this.folderStructCheckBox.setEnabled(false);
        this.myFileChooser.addActionListener(this);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(null);
        this.contentPane.setBounds(new Rectangle(10, 484, 452, 82));
        this.setContentPane(this.contentPane);
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)this.addWCButton, null);
        this.getContentPane().add((Component)this.myFileChooser, null);
        this.getContentPane().add((Component)this.foldersPanel, null);
        this.pack();
        this.setSize(new Dimension(497, 395));
        this.show();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.addWCButton)) {
            this.isAddOrAddWithWildCards = false;
            this.getConvertionFiles();
            this.setMyCurrentDirectory(this.myFileChooser.getCurrentDirectory());
            this.dispose();
        }
    }

    public void getConvertionFiles() {
        this.getFiles();
        this.getFilesWithWildCards();
    }

    private void getFilesWithWildCards() {
        this.myCharSeq = this.textField.getText();
        if (this.listOfFiles != null) {
            int i = 0;
            File[] svg1Files = new File[this.listOfFiles.size()];
            int k = 0;
            while (k < this.listOfFiles.size()) {
                File f = (File)this.listOfFiles.get(k);
                if (WCMatcher.match(this.textField.getText(), f.getName())) {
                    this.myWildCardsFiles.add(f);
                    svg1Files[i] = f;
                    ++i;
                }
                ++k;
            }
            File[] svgFiles2 = new File[i];
            int k2 = 0;
            while (k2 < i) {
                svgFiles2[k2] = svg1Files[k2];
                ++k2;
            }
            this.setSVGTFiles(svgFiles2);
        }
    }

    private void getFiles() {
        File file = this.myFileChooser.getCurrentDirectory();
        this.setMyParentDirectory(file.getAbsolutePath());
        if (file != null && file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            this.listOfFiles = new Vector();
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (f.isFile()) {
                    this.listOfFiles.add(f);
                } else if (f.isDirectory() && this.subFoldersCheckBox.isSelected()) {
                    this.getMyFiles(f);
                }
                ++i;
            }
        }
    }

    private void getMyFiles(File f) {
        File[] files = f.listFiles();
        int i = 0;
        while (i < files.length) {
            File f1 = files[i];
            if (f1.isFile()) {
                this.listOfFiles.add(f1);
            } else if (f1.isDirectory()) {
                this.getMyFiles(f1);
            }
            ++i;
        }
    }

    private void setSVGTFiles(File[] file) {
        this.svgFiles = file;
    }

    public File[] getSelectedSVGFiles() {
        return this.svgFiles;
    }

    public boolean isMaintainFolderStrucSelected() {
        return this.folderStructCheckBox.isSelected();
    }

    public String getMyParentDirectory() {
        return this.myParentDirectory;
    }

    public void setMyParentDirectory(String string) {
        this.myParentDirectory = string;
    }

    public Vector getMyWildCardsFiles() {
        return this.myWildCardsFiles;
    }

    public boolean isAddOrAddWithWildCards() {
        return this.isAddOrAddWithWildCards;
    }

    public String getMyCharSeq() {
        return this.myCharSeq;
    }

    public void caretUpdate(CaretEvent e) {
        String text = this.textField.getText();
        if (-1 != text.indexOf("*") || -1 != text.indexOf("?")) {
            this.addWCButton.setEnabled(true);
            this.subFoldersCheckBox.setEnabled(true);
            this.folderStructCheckBox.setEnabled(true);
        } else {
            this.addWCButton.setEnabled(false);
            this.subFoldersCheckBox.setEnabled(false);
            this.folderStructCheckBox.setEnabled(false);
        }
        if (text.length() != 0) {
            this.openButton.setEnabled(true);
        } else {
            this.openButton.setEnabled(false);
        }
    }

    public File getMyCurrentDirectory() {
        return this.myCurrentDirectory;
    }

    public void setMyCurrentDirectory(File string) {
        this.myCurrentDirectory = string;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean b) {
        this.canceled = b;
    }

    class SVGFileChooser
    extends JFileChooser {
        SVGFileChooser() {
        }

        public void approveSelection() {
            super.approveSelection();
            System.out.println("The files" + this.getSelectedFile().getName());
            SVGTFileChooser.this.setSVGTFiles(this.getSelectedFiles());
            SVGTFileChooser.this.setMyCurrentDirectory(SVGTFileChooser.this.myFileChooser.getCurrentDirectory());
            SVGTFileChooser.this.dispose();
        }

        public void cancelSelection() {
            super.cancelSelection();
            SVGTFileChooser.this.setCanceled(true);
            SVGTFileChooser.this.dispose();
        }
    }
}

