/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.svg2svgt.gui;

import com.nokia.svg2svgt.converter.SVGAttribute;
import com.nokia.svg2svgt.converter.SVGElement;
import com.nokia.svg2svgt.converter.SVGNameSpace;
import com.nokia.svg2svgt.localiser.Localiser;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGPassThroughFileStorer {
    private Document document;
    private String fileName;
    private File configFile;
    private ArrayList myList;
    private Localiser myLocaliser = null;
    private boolean save = true;
    private Frame frame = null;

    public SVGPassThroughFileStorer(ArrayList list, String path, Localiser localiser, boolean saveOrsaveas, Frame frame) {
        this.myList = list;
        this.myLocaliser = localiser;
        this.save = saveOrsaveas;
        this.frame = frame;
        try {
            this.createXMLdocument("passThrough", path, this.save);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createXMLdocument(String rootTag, String path, boolean save) throws Exception {
        this.document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
            Element root = this.document.createElement(rootTag);
            this.document.appendChild(root);
            this.createNodes(root);
            this.writeToXmlFile(path, save);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }

    public void createNodes(Element root) {
        if (this.myList != null) {
            Element nsNode = null;
            Element mainNode = null;
            Element elementNode = null;
            Element attributeNode = null;
            int i = 0;
            while (i < this.myList.size()) {
                SVGNameSpace nameSpace = (SVGNameSpace)this.myList.get(i);
                if (nameSpace != null) {
                    nsNode = this.createNode("namespace");
                    nsNode.setAttribute("name", nameSpace.getnameSpaceName());
                    if (nameSpace.getMyUri() != null) {
                        if (nameSpace.isURI()) {
                            nsNode.setAttribute("url", nameSpace.getMyUri());
                        } else {
                            nsNode.setAttribute("urlcontains", nameSpace.getMyUri());
                        }
                    }
                    if (nameSpace.isWarn()) {
                        nsNode.setAttribute("warn", "true");
                    }
                    root.appendChild(nsNode);
                    mainNode = this.createNode(nameSpace.getnameSpaceName());
                    if (nameSpace.isIsallowed()) {
                        mainNode.setAttribute("allowAll", "true");
                        root.appendChild(mainNode);
                    } else {
                        ArrayList elements = nameSpace.getnameSpaceElements();
                        if (elements != null) {
                            int j = 0;
                            while (j < elements.size()) {
                                ArrayList attributes;
                                SVGElement svgElement = (SVGElement)elements.get(j);
                                elementNode = this.createNode("element");
                                elementNode.setAttribute("name", svgElement.getElementName());
                                if (svgElement.isWarned()) {
                                    elementNode.setAttribute("warn", "true");
                                }
                                if ((attributes = svgElement.getElementAttributes()) != null) {
                                    int k = 0;
                                    while (k < attributes.size()) {
                                        SVGAttribute attribute = (SVGAttribute)attributes.get(k);
                                        attributeNode = this.createNode("attribute");
                                        attributeNode.setAttribute("name", attribute.getAttributeName());
                                        if (attribute.getAttributeValue() != null) {
                                            attributeNode.setAttribute("value", (String)attribute.getAttributeValue());
                                        }
                                        if (attribute.isWarned()) {
                                            attributeNode.setAttribute("warn", "true");
                                        }
                                        elementNode.appendChild(attributeNode);
                                        ++k;
                                    }
                                }
                                mainNode.appendChild(elementNode);
                                ++j;
                            }
                        }
                        root.appendChild(mainNode);
                    }
                }
                ++i;
            }
        }
    }

    public void writeToXmlFile(String pathVar, boolean save) throws Exception {
        System.out.println("path" + pathVar);
        if (save) {
            try {
                if (!pathVar.endsWith(".xml")) {
                    pathVar = String.valueOf(pathVar) + ".xml";
                }
                File f = new File(pathVar);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                System.out.println("document = " + (this.document == null));
                DOMSource source = new DOMSource(this.document);
                StreamResult result = new StreamResult(f);
                transformer.transform(source, result);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.frame, e.getMessage());
            }
        } else {
            try {
                if (!pathVar.endsWith(".xml")) {
                    pathVar = String.valueOf(pathVar) + ".xml";
                }
                File f = new File(pathVar);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                System.out.println("document = " + (this.document == null));
                DOMSource source = new DOMSource(this.document);
                int i = 0;
                while (f.exists()) {
                    String newFile = String.valueOf(pathVar) + "_" + ++i + "." + "xml";
                    f = new File(newFile);
                }
                StreamResult result = new StreamResult(f);
                transformer.transform(source, result);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception();
            }
        }
    }

    private Element createNode(String nodeName) {
        Element node = this.document.createElement(nodeName);
        return node;
    }

    public static void main(String[] args) {
    }

    class PTConstants {
        private static final String TAG_PASSTHROUGH = "passThrough";
        private static final String TAG_NAMESPACE = "namespace";
        private static final String TAG_NAME = "name";
        private static final String TAG_WARN = "warn";
        private static final String TAG_ALLOWALL = "allowAll";
        private static final String TAG_ELEMENT = "element";
        private static final String TAG_ATTRIBUTE = "attribute";
        private static final String TAG_TRUE = "true";
        private static final String TAG_FALSE = "false";
        private static final String TAG_VALUE = "value";
        private static final String TAG_URL = "url";
        private static final String TAG_URLCONTAINS = "urlcontains";

        PTConstants() {
        }
    }
}

